/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-12-11 21:21:19 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=MyISAM AUTO_INCREMENT=76 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=2174 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=95 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_backups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL DEFAULT '',
  `package` longtext NOT NULL,
  `archive_name` varchar(350) NOT NULL DEFAULT '',
  `progress` float NOT NULL DEFAULT 0,
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE') NOT NULL DEFAULT '',
  `version` varchar(30) NOT NULL DEFAULT '',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`),
  KEY `archive_name` (`archive_name`(250))
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_entities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `data` longtext NOT NULL,
  `value_1` varchar(255) NOT NULL DEFAULT '',
  `value_2` varchar(255) NOT NULL DEFAULT '',
  `value_3` varchar(255) NOT NULL DEFAULT '',
  `value_4` varchar(255) NOT NULL DEFAULT '',
  `value_5` varchar(255) NOT NULL DEFAULT '',
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`(250)),
  KEY `value_2` (`value_2`(250)),
  KEY `value_3` (`value_3`(250)),
  KEY `value_4` (`value_4`(250)),
  KEY `value_5` (`value_5`(250))
) ENGINE=MyISAM AUTO_INCREMENT=3409 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_gf_addon_feed` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(8) unsigned NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `feed_order` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `meta` longtext DEFAULT NULL,
  `addon_slug` varchar(50) DEFAULT NULL,
  `event_type` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `addon_form` (`addon_slug`,`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gf_draft_submissions` (
  `uuid` char(32) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `form_id` mediumint(10) unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` varchar(45) NOT NULL,
  `source_url` longtext NOT NULL,
  `submission` longtext NOT NULL,
  PRIMARY KEY (`uuid`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gf_entry` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `post_id` bigint(10) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_starred` tinyint(10) NOT NULL DEFAULT 0,
  `is_read` tinyint(10) NOT NULL DEFAULT 0,
  `ip` varchar(45) NOT NULL,
  `source_url` varchar(200) NOT NULL DEFAULT '',
  `user_agent` varchar(250) NOT NULL DEFAULT '',
  `currency` varchar(5) DEFAULT NULL,
  `payment_status` varchar(15) DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_amount` decimal(19,2) DEFAULT NULL,
  `payment_method` varchar(30) DEFAULT NULL,
  `transaction_id` varchar(50) DEFAULT NULL,
  `is_fulfilled` tinyint(10) DEFAULT NULL,
  `created_by` bigint(10) unsigned DEFAULT NULL,
  `transaction_type` tinyint(10) DEFAULT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'active',
  `source_id` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `form_id_status` (`form_id`,`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gf_entry_meta` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL DEFAULT 0,
  `entry_id` bigint(10) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  `item_index` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `entry_id` (`entry_id`),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gf_entry_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` int(10) unsigned NOT NULL,
  `user_name` varchar(250) DEFAULT NULL,
  `user_id` bigint(10) DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `value` longtext DEFAULT NULL,
  `note_type` varchar(50) DEFAULT NULL,
  `sub_type` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `entry_id` (`entry_id`),
  KEY `entry_user_key` (`entry_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gf_form` (
  `id` mediumint(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(150) NOT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_active` tinyint(10) NOT NULL DEFAULT 1,
  `is_trash` tinyint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gf_form_meta` (
  `form_id` mediumint(10) unsigned NOT NULL,
  `display_meta` longtext DEFAULT NULL,
  `entries_grid_meta` longtext DEFAULT NULL,
  `confirmations` longtext DEFAULT NULL,
  `notifications` longtext DEFAULT NULL,
  PRIMARY KEY (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gf_form_revisions` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `display_meta` longtext DEFAULT NULL,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gf_form_view` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` char(15) DEFAULT NULL,
  `count` mediumint(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gf_rest_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=100689 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=1012 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=823 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_redirection_404` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `url` mediumtext NOT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `agent` varchar(255) DEFAULT NULL,
  `referrer` varchar(255) DEFAULT NULL,
  `http_code` int(11) unsigned NOT NULL DEFAULT 0,
  `request_method` varchar(10) DEFAULT NULL,
  `request_data` mediumtext DEFAULT NULL,
  `ip` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created` (`created`),
  KEY `referrer` (`referrer`(191)),
  KEY `ip` (`ip`)
) ENGINE=MyISAM AUTO_INCREMENT=20910 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_redirection_groups` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `tracking` int(11) NOT NULL DEFAULT 1,
  `module_id` int(11) unsigned NOT NULL DEFAULT 0,
  `status` enum('enabled','disabled') NOT NULL DEFAULT 'enabled',
  `position` int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `module_id` (`module_id`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_redirection_items` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `url` mediumtext NOT NULL,
  `match_url` varchar(2000) DEFAULT NULL,
  `match_data` text DEFAULT NULL,
  `regex` int(11) unsigned NOT NULL DEFAULT 0,
  `position` int(11) unsigned NOT NULL DEFAULT 0,
  `last_count` int(10) unsigned NOT NULL DEFAULT 0,
  `last_access` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `group_id` int(11) NOT NULL DEFAULT 0,
  `status` enum('enabled','disabled') NOT NULL DEFAULT 'enabled',
  `action_type` varchar(20) NOT NULL,
  `action_code` int(11) unsigned NOT NULL,
  `action_data` mediumtext DEFAULT NULL,
  `match_type` varchar(20) NOT NULL,
  `title` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `status` (`status`),
  KEY `regex` (`regex`),
  KEY `group_idpos` (`group_id`,`position`),
  KEY `group` (`group_id`),
  KEY `match_url` (`match_url`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_redirection_logs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `url` mediumtext NOT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `sent_to` mediumtext DEFAULT NULL,
  `agent` mediumtext DEFAULT NULL,
  `referrer` mediumtext DEFAULT NULL,
  `http_code` int(11) unsigned NOT NULL DEFAULT 0,
  `request_method` varchar(10) DEFAULT NULL,
  `request_data` mediumtext DEFAULT NULL,
  `redirect_by` varchar(50) DEFAULT NULL,
  `redirection_id` int(11) unsigned DEFAULT NULL,
  `ip` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created` (`created`),
  KEY `redirection_id` (`redirection_id`),
  KEY `ip` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=110 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  `type` varchar(191) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_rg_zapier` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(8) unsigned NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `name` varchar(150) NOT NULL,
  `url` varchar(150) NOT NULL,
  `meta` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_tm_taskmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `task_id` (`task_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_tm_tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `type` varchar(300) NOT NULL,
  `class_identifier` varchar(300) DEFAULT '0',
  `attempts` int(11) DEFAULT 0,
  `description` varchar(300) DEFAULT NULL,
  `time_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `last_locked_at` bigint(20) DEFAULT 0,
  `status` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=75 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wpmailsmtp_debug_events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content` text DEFAULT NULL,
  `initiator` text DEFAULT NULL,
  `event_type` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpmailsmtp_tasks_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `action` varchar(255) NOT NULL,
  `data` longtext NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext DEFAULT NULL,
  `permalink_hash` varchar(40) DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(32) NOT NULL,
  `object_sub_type` varchar(32) DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `post_parent` bigint(20) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `breadcrumb_title` text DEFAULT NULL,
  `post_status` varchar(20) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT 0,
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext DEFAULT NULL,
  `primary_focus_keyword` varchar(191) DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT 0,
  `is_robots_noindex` tinyint(1) DEFAULT 0,
  `is_robots_nofollow` tinyint(1) DEFAULT 0,
  `is_robots_noarchive` tinyint(1) DEFAULT 0,
  `is_robots_noimageindex` tinyint(1) DEFAULT 0,
  `is_robots_nosnippet` tinyint(1) DEFAULT 0,
  `twitter_title` text DEFAULT NULL,
  `twitter_image` longtext DEFAULT NULL,
  `twitter_description` longtext DEFAULT NULL,
  `twitter_image_id` varchar(191) DEFAULT NULL,
  `twitter_image_source` text DEFAULT NULL,
  `open_graph_title` text DEFAULT NULL,
  `open_graph_description` longtext DEFAULT NULL,
  `open_graph_image` longtext DEFAULT NULL,
  `open_graph_image_id` varchar(191) DEFAULT NULL,
  `open_graph_image_source` text DEFAULT NULL,
  `open_graph_image_meta` mediumtext DEFAULT NULL,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  `schema_page_type` varchar(64) DEFAULT NULL,
  `schema_article_type` varchar(64) DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT 0,
  `estimated_reading_time_minutes` int(11) DEFAULT NULL,
  `version` int(11) DEFAULT 1,
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wp_yoast_migrations_version` (`version`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `term_id` bigint(20) DEFAULT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) NOT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yoast_seo_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT NULL,
  `incoming_link_count` int(10) unsigned DEFAULT NULL,
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("43", "action_scheduler/migration_hook", "failed", "2025-01-13 19:22:50", "2025-01-13 14:22:50", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1736796170;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1736796170;}", "1", "1", "2025-01-13 19:22:53", "2025-01-13 14:22:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("53", "wp_mail_smtp_summary_report_email", "pending", "2025-12-12 14:32:55", "2025-12-12 09:32:55", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765549975;s:18:\"\0*\0first_timestamp\";i:1737399600;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765549975;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("50", "wp_mail_smtp_admin_notifications_update", "complete", "2025-08-29 15:05:00", "2025-08-29 11:05:00", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756479900;s:18:\"\0*\0first_timestamp\";i:1736796172;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756479900;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-05 14:32:54", "2025-12-05 09:32:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("51", "wp_mail_smtp_summary_report_email", "complete", "2025-09-04 15:05:01", "2025-09-04 11:05:01", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756998301;s:18:\"\0*\0first_timestamp\";i:1737399600;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756998301;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-12-05 14:32:55", "2025-12-05 09:32:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("52", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-06 14:32:54", "2025-12-06 09:32:54", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765031574;s:18:\"\0*\0first_timestamp\";i:1736796172;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765031574;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-06 16:17:34", "2025-12-06 11:17:34", "400", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("49", "action_scheduler/migration_hook", "failed", "2025-01-13 20:17:03", "2025-01-13 15:17:03", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1736799423;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1736799423;}", "1", "1", "2025-08-28 15:05:00", "2025-08-28 11:05:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("54", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-05 14:33:28", "2025-12-05 09:33:28", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764945208;s:18:\"\0*\0first_timestamp\";i:1764945208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764945208;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-05 14:34:28", "2025-12-05 09:34:28", "85", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("55", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-05 14:33:28", "2025-12-05 09:33:28", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764945208;s:18:\"\0*\0first_timestamp\";i:1764945208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764945208;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-12-05 14:34:28", "2025-12-05 09:34:28", "85", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("56", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-06 14:34:28", "2025-12-06 09:34:28", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765031668;s:18:\"\0*\0first_timestamp\";i:1764945208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765031668;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-06 16:17:34", "2025-12-06 11:17:34", "400", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("57", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-06 14:34:28", "2025-12-06 09:34:28", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765031668;s:18:\"\0*\0first_timestamp\";i:1764945208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765031668;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-06 16:17:34", "2025-12-06 11:17:34", "400", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("58", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-07 16:17:34", "2025-12-07 11:17:34", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765124254;s:18:\"\0*\0first_timestamp\";i:1736796172;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765124254;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-07 16:20:08", "2025-12-07 11:20:08", "434", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("59", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-07 16:17:34", "2025-12-07 11:17:34", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765124254;s:18:\"\0*\0first_timestamp\";i:1764945208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765124254;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-07 16:20:09", "2025-12-07 11:20:09", "434", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("60", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-07 16:17:34", "2025-12-07 11:17:34", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765124254;s:18:\"\0*\0first_timestamp\";i:1764945208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765124254;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-07 16:20:09", "2025-12-07 11:20:09", "434", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("61", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-08 16:20:08", "2025-12-08 11:20:08", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765210808;s:18:\"\0*\0first_timestamp\";i:1736796172;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765210808;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-08 16:21:14", "2025-12-08 11:21:14", "734", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("62", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-08 16:20:09", "2025-12-08 11:20:09", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765210809;s:18:\"\0*\0first_timestamp\";i:1764945208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765210809;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-08 16:21:14", "2025-12-08 11:21:14", "734", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("63", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-08 16:20:09", "2025-12-08 11:20:09", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765210809;s:18:\"\0*\0first_timestamp\";i:1764945208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765210809;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-08 16:21:14", "2025-12-08 11:21:14", "734", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("64", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-09 16:21:14", "2025-12-09 11:21:14", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765297274;s:18:\"\0*\0first_timestamp\";i:1736796172;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765297274;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-09 16:21:35", "2025-12-09 11:21:35", "1316", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("65", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-09 16:21:14", "2025-12-09 11:21:14", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765297274;s:18:\"\0*\0first_timestamp\";i:1764945208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765297274;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-09 16:21:35", "2025-12-09 11:21:35", "1316", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("66", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-09 16:21:14", "2025-12-09 11:21:14", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765297274;s:18:\"\0*\0first_timestamp\";i:1764945208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765297274;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-09 16:21:35", "2025-12-09 11:21:35", "1316", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("67", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-10 16:21:35", "2025-12-10 11:21:35", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765383695;s:18:\"\0*\0first_timestamp\";i:1736796172;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765383695;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-10 16:21:37", "2025-12-10 11:21:37", "1859", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("68", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-10 16:21:35", "2025-12-10 11:21:35", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765383695;s:18:\"\0*\0first_timestamp\";i:1764945208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765383695;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-10 16:21:37", "2025-12-10 11:21:37", "1859", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("69", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-10 16:21:35", "2025-12-10 11:21:35", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765383695;s:18:\"\0*\0first_timestamp\";i:1764945208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765383695;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-10 16:21:37", "2025-12-10 11:21:37", "1859", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("70", "wp_mail_smtp_admin_notifications_update", "complete", "2025-12-11 16:21:37", "2025-12-11 11:21:37", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765470097;s:18:\"\0*\0first_timestamp\";i:1736796172;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765470097;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-12-11 16:21:58", "2025-12-11 11:21:58", "2053", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("71", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-11 16:21:37", "2025-12-11 11:21:37", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765470097;s:18:\"\0*\0first_timestamp\";i:1764945208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765470097;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-11 16:21:58", "2025-12-11 11:21:58", "2053", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("72", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-12-11 16:21:37", "2025-12-11 11:21:37", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765470097;s:18:\"\0*\0first_timestamp\";i:1764945208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765470097;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-12-11 16:21:58", "2025-12-11 11:21:58", "2053", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("73", "wp_mail_smtp_admin_notifications_update", "pending", "2025-12-12 16:21:58", "2025-12-12 11:21:58", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765556518;s:18:\"\0*\0first_timestamp\";i:1736796172;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765556518;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("74", "action_scheduler_run_recurring_actions_schedule_hook", "pending", "2025-12-12 16:21:58", "2025-12-12 11:21:58", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765556518;s:18:\"\0*\0first_timestamp\";i:1764945208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765556518;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("75", "action_scheduler_run_recurring_actions_schedule_hook", "pending", "2025-12-12 16:21:58", "2025-12-12 11:21:58", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765556518;s:18:\"\0*\0first_timestamp\";i:1764945208;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765556518;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "wp_mail_smtp");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "ActionScheduler");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "ActionScheduler");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("26", "51", "action created", "2025-08-28 15:05:01", "2025-08-28 11:05:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("28", "50", "action complete via WP Cron", "2025-12-05 14:32:54", "2025-12-05 09:32:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4", "43", "action created", "2025-01-13 19:21:50", "2025-01-13 14:21:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("27", "50", "action started via WP Cron", "2025-12-05 14:32:54", "2025-12-05 09:32:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("23", "50", "action created", "2025-08-28 15:05:00", "2025-08-28 11:05:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7", "43", "action started via Async Request", "2025-01-13 19:22:53", "2025-01-13 14:22:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("8", "43", "action failed via Async Request: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2025-01-13 19:22:53", "2025-01-13 14:22:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("30", "51", "action started via WP Cron", "2025-12-05 14:32:54", "2025-12-05 09:32:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("29", "52", "action created", "2025-12-05 14:32:54", "2025-12-05 09:32:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("20", "49", "action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2025-08-28 15:05:00", "2025-08-28 11:05:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("19", "49", "action started via WP Cron", "2025-08-28 15:05:00", "2025-08-28 11:05:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("18", "49", "action created", "2025-01-13 20:16:03", "2025-01-13 15:16:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("31", "51", "action complete via WP Cron", "2025-12-05 14:32:55", "2025-12-05 09:32:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("32", "53", "action created", "2025-12-05 14:32:55", "2025-12-05 09:32:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("33", "54", "action created", "2025-12-05 14:33:28", "2025-12-05 09:33:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("34", "55", "action created", "2025-12-05 14:33:28", "2025-12-05 09:33:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("35", "54", "action started via WP Cron", "2025-12-05 14:34:28", "2025-12-05 09:34:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("36", "54", "action complete via WP Cron", "2025-12-05 14:34:28", "2025-12-05 09:34:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("37", "56", "action created", "2025-12-05 14:34:28", "2025-12-05 09:34:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("38", "55", "action started via WP Cron", "2025-12-05 14:34:28", "2025-12-05 09:34:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("39", "55", "action complete via WP Cron", "2025-12-05 14:34:28", "2025-12-05 09:34:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("40", "57", "action created", "2025-12-05 14:34:28", "2025-12-05 09:34:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("41", "52", "action started via WP Cron", "2025-12-06 16:17:34", "2025-12-06 11:17:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("42", "52", "action complete via WP Cron", "2025-12-06 16:17:34", "2025-12-06 11:17:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("43", "58", "action created", "2025-12-06 16:17:34", "2025-12-06 11:17:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("44", "56", "action started via WP Cron", "2025-12-06 16:17:34", "2025-12-06 11:17:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("45", "56", "action complete via WP Cron", "2025-12-06 16:17:34", "2025-12-06 11:17:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("46", "59", "action created", "2025-12-06 16:17:34", "2025-12-06 11:17:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("47", "57", "action started via WP Cron", "2025-12-06 16:17:34", "2025-12-06 11:17:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("48", "57", "action complete via WP Cron", "2025-12-06 16:17:34", "2025-12-06 11:17:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("49", "60", "action created", "2025-12-06 16:17:34", "2025-12-06 11:17:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("50", "58", "action started via WP Cron", "2025-12-07 16:20:08", "2025-12-07 11:20:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("51", "58", "action complete via WP Cron", "2025-12-07 16:20:08", "2025-12-07 11:20:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("52", "61", "action created", "2025-12-07 16:20:09", "2025-12-07 11:20:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("53", "59", "action started via WP Cron", "2025-12-07 16:20:09", "2025-12-07 11:20:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("54", "59", "action complete via WP Cron", "2025-12-07 16:20:09", "2025-12-07 11:20:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("55", "62", "action created", "2025-12-07 16:20:09", "2025-12-07 11:20:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("56", "60", "action started via WP Cron", "2025-12-07 16:20:09", "2025-12-07 11:20:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("57", "60", "action complete via WP Cron", "2025-12-07 16:20:09", "2025-12-07 11:20:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("58", "63", "action created", "2025-12-07 16:20:09", "2025-12-07 11:20:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("59", "61", "action started via WP Cron", "2025-12-08 16:21:14", "2025-12-08 11:21:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("60", "61", "action complete via WP Cron", "2025-12-08 16:21:14", "2025-12-08 11:21:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("61", "64", "action created", "2025-12-08 16:21:14", "2025-12-08 11:21:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("62", "62", "action started via WP Cron", "2025-12-08 16:21:14", "2025-12-08 11:21:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("63", "62", "action complete via WP Cron", "2025-12-08 16:21:14", "2025-12-08 11:21:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("64", "65", "action created", "2025-12-08 16:21:14", "2025-12-08 11:21:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("65", "63", "action started via WP Cron", "2025-12-08 16:21:14", "2025-12-08 11:21:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("66", "63", "action complete via WP Cron", "2025-12-08 16:21:14", "2025-12-08 11:21:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("67", "66", "action created", "2025-12-08 16:21:14", "2025-12-08 11:21:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("68", "64", "action started via WP Cron", "2025-12-09 16:21:35", "2025-12-09 11:21:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("69", "64", "action complete via WP Cron", "2025-12-09 16:21:35", "2025-12-09 11:21:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("70", "67", "action created", "2025-12-09 16:21:35", "2025-12-09 11:21:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("71", "65", "action started via WP Cron", "2025-12-09 16:21:35", "2025-12-09 11:21:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("72", "65", "action complete via WP Cron", "2025-12-09 16:21:35", "2025-12-09 11:21:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("73", "68", "action created", "2025-12-09 16:21:35", "2025-12-09 11:21:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("74", "66", "action started via WP Cron", "2025-12-09 16:21:35", "2025-12-09 11:21:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("75", "66", "action complete via WP Cron", "2025-12-09 16:21:35", "2025-12-09 11:21:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("76", "69", "action created", "2025-12-09 16:21:35", "2025-12-09 11:21:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("77", "67", "action started via WP Cron", "2025-12-10 16:21:36", "2025-12-10 11:21:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("78", "67", "action complete via WP Cron", "2025-12-10 16:21:37", "2025-12-10 11:21:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("79", "70", "action created", "2025-12-10 16:21:37", "2025-12-10 11:21:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("80", "68", "action started via WP Cron", "2025-12-10 16:21:37", "2025-12-10 11:21:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("81", "68", "action complete via WP Cron", "2025-12-10 16:21:37", "2025-12-10 11:21:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("82", "71", "action created", "2025-12-10 16:21:37", "2025-12-10 11:21:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("83", "69", "action started via WP Cron", "2025-12-10 16:21:37", "2025-12-10 11:21:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("84", "69", "action complete via WP Cron", "2025-12-10 16:21:37", "2025-12-10 11:21:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("85", "72", "action created", "2025-12-10 16:21:37", "2025-12-10 11:21:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("86", "70", "action started via WP Cron", "2025-12-11 16:21:58", "2025-12-11 11:21:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("87", "70", "action complete via WP Cron", "2025-12-11 16:21:58", "2025-12-11 11:21:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("88", "73", "action created", "2025-12-11 16:21:58", "2025-12-11 11:21:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("89", "71", "action started via WP Cron", "2025-12-11 16:21:58", "2025-12-11 11:21:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("90", "71", "action complete via WP Cron", "2025-12-11 16:21:58", "2025-12-11 11:21:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("91", "74", "action created", "2025-12-11 16:21:58", "2025-12-11 11:21:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("92", "72", "action started via WP Cron", "2025-12-11 16:21:58", "2025-12-11 11:21:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("93", "72", "action complete via WP Cron", "2025-12-11 16:21:58", "2025-12-11 11:21:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("94", "75", "action created", "2025-12-11 16:21:58", "2025-12-11 11:21:58");

/* INSERT TABLE DATA: wp_duplicator_backups */
INSERT INTO `wp_duplicator_backups` VALUES("12", "20250113_brickslevotheme", "dad3962c824db8005985_20250113192946", "100", "2025-01-13 19:29:48", "unknown", "{\n    \"ID\": 12,\n    \"VersionWP\": \"6.7.1\",\n    \"VersionDB\": \"10.2.44\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20250113_brickslevotheme\",\n    \"Hash\": \"dad3962c824db8005985_20250113192946\",\n    \"NameHash\": \"20250113_brickslevotheme_dad3962c824db8005985_20250113192946\",\n    \"Type\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"http:\\/\\/roxus.levoengage.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250113_brickslevotheme_dad3962c824db8005985_20250113192946_scan.json\",\n    \"timer_start\": 1736796600.1071889400482177734375,\n    \"Runtime\": \"7.594 sec.\",\n    \"ExeSize\": \"167.75KB\",\n    \"ZipSize\": \"78.47MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/.opcache\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/.tmb\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/bps-backup\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/cache\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/old-cache\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/updraft\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/wfcache\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/.htaccess\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/.user.ini\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/php.ini\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/web.config\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-config.php\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20250113_brickslevotheme_dad3962c824db8005985_20250113192946_archive.daf\",\n        \"Format\": \"DAF\",\n        \"PackDir\": \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\",\n        \"Size\": 82281545,\n        \"Dirs\": [],\n        \"DirCount\": 2224,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 11551,\n        \"file_count\": 13776,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250113_brickslevotheme_dad3962c824db8005985_20250113192946_installer.php\",\n        \"Size\": 171777,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"vBqrGh0FqxdXkfmiV3lsDxPEvLqVgFbeAF6oY52JTrPdIfW\\/eoFz596JbkdjVPufWVbITkYUDlmdMITeeoKbDA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 751,\n        \"numDirsAdded\": 153\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"MyISAM\",\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"n4f5a65_test-environment\",\n            \"tablesBaseCount\": 49,\n            \"tablesFinalCount\": 49,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 635,\n            \"tablesSizeOnDisk\": 3759592,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 19424\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 3086\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 9284\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 5016\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 4096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 49072\n                },\n                \"wp_gf_addon_feed\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_gf_draft_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_gf_entry\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_gf_entry_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_gf_entry_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_gf_form\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 2120\n                },\n                \"wp_gf_form_meta\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 99300\n                },\n                \"wp_gf_form_revisions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_gf_form_view\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_gf_rest_api_keys\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 6308\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"378\",\n                    \"insertedRows\": 378,\n                    \"size\": 3290952\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 10408\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 13796\n                },\n                \"wp_redirection_404\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 14272\n                },\n                \"wp_redirection_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 4164\n                },\n                \"wp_redirection_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_redirection_logs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_css\": {\n                    \"inaccurateRows\": \"109\",\n                    \"insertedRows\": 109,\n                    \"size\": 95152\n                },\n                \"wp_revslider_layer_animations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_navigations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_sliders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_slides\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_static_slides\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_rg_zapier\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 13352\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 4128\n                },\n                \"wp_tm_taskmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_tm_tasks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"43\",\n                    \"insertedRows\": 43,\n                    \"size\": 14256\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 8284\n                },\n                \"wp_wpmailsmtp_debug_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpmailsmtp_tasks_meta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 2116\n                },\n                \"wp_yoast_indexable\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 14188\n                },\n                \"wp_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 5204\n                },\n                \"wp_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 9792\n                },\n                \"wp_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_yoast_seo_links\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 4172\n                },\n                \"wp_yoast_seo_meta\": {\n                    \"inaccurateRows\": \"18\",\n                    \"insertedRows\": 18,\n                    \"size\": 2354\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.2.44\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 2825949,\n        \"File\": \"20250113_brickslevotheme_dad3962c824db8005985_20250113192946_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/backups-dup-pro\\/tmp\\/20250113_brickslevotheme_dad3962c824db8005985_20250113192946_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 3,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1736796607,\n            \"stopped_timestamp\": 1736796608,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": 13,\n    \"template_id\": 5,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2025-01-13 19:29:48\",\n    \"updated\": \"2025-01-13 19:30:08\",\n    \"flags\": [\n        \"MANUAL\",\n        \"DUP_ARCHIVE\",\n        \"HAVE_LOCAL\",\n        \"DISASTER_AVAIABLE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}", "20250113_brickslevotheme_dad3962c824db8005985_20250113192946_archive.daf", "100", "MANUAL,HAVE_LOCAL,DISASTER_AVAIABLE,DUP_ARCHIVE", "4.5.14.2", "2025-01-13 19:30:08");
INSERT INTO `wp_duplicator_backups` VALUES("13", "20250113_brickslevotheme", "1ed06004268ec9b19798_20250113193438", "100", "2025-01-13 19:34:41", "unknown", "{\n    \"ID\": 13,\n    \"VersionWP\": \"6.7.1\",\n    \"VersionDB\": \"10.2.44\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20250113_brickslevotheme\",\n    \"Hash\": \"1ed06004268ec9b19798_20250113193438\",\n    \"NameHash\": \"20250113_brickslevotheme_1ed06004268ec9b19798_20250113193438\",\n    \"Type\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"http:\\/\\/roxus.levoengage.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250113_brickslevotheme_1ed06004268ec9b19798_20250113193438_scan.json\",\n    \"timer_start\": 1736796892.9562890529632568359375,\n    \"Runtime\": \"19.995 sec.\",\n    \"ExeSize\": \"128.85KB\",\n    \"ZipSize\": \"71.93MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/.opcache\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/.tmb\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/bps-backup\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/cache\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/old-cache\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/updraft\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/wfcache\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/.htaccess\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/.user.ini\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/php.ini\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/web.config\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-config.php\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20250113_brickslevotheme_1ed06004268ec9b19798_20250113193438_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\",\n        \"Size\": 75428338,\n        \"Dirs\": [],\n        \"DirCount\": 2224,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 11551,\n        \"file_count\": 13775,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250113_brickslevotheme_1ed06004268ec9b19798_20250113193438_installer.php\",\n        \"Size\": 131947,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"QGvqChE4R0iPyXqxGUu3p9PYlb\\/g\\/AVz+J2iWGIVBtD1+Mv2nkPdsBGobBHaxkYetTAHe4dDgy7RZhlIEUbGhg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"MyISAM\",\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"n4f5a65_test-environment\",\n            \"tablesBaseCount\": 49,\n            \"tablesFinalCount\": 49,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 644,\n            \"tablesSizeOnDisk\": 3808368,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 19424\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 3086\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 9284\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 5016\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 2,\n                    \"size\": 52872\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 49072\n                },\n                \"wp_gf_addon_feed\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_gf_draft_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_gf_entry\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_gf_entry_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_gf_entry_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_gf_form\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 2120\n                },\n                \"wp_gf_form_meta\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 99300\n                },\n                \"wp_gf_form_revisions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_gf_form_view\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_gf_rest_api_keys\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 6308\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"384\",\n                    \"insertedRows\": 384,\n                    \"size\": 3290952\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 10408\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 7,\n                    \"size\": 13796\n                },\n                \"wp_redirection_404\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 14272\n                },\n                \"wp_redirection_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 4164\n                },\n                \"wp_redirection_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_redirection_logs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_css\": {\n                    \"inaccurateRows\": \"109\",\n                    \"insertedRows\": 109,\n                    \"size\": 95152\n                },\n                \"wp_revslider_layer_animations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_navigations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_sliders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_slides\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_static_slides\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_rg_zapier\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 13352\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 4128\n                },\n                \"wp_tm_taskmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_tm_tasks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"43\",\n                    \"insertedRows\": 43,\n                    \"size\": 14256\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 8284\n                },\n                \"wp_wpmailsmtp_debug_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpmailsmtp_tasks_meta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 2116\n                },\n                \"wp_yoast_indexable\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 14188\n                },\n                \"wp_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 5204\n                },\n                \"wp_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 9792\n                },\n                \"wp_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_yoast_seo_links\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 4172\n                },\n                \"wp_yoast_seo_meta\": {\n                    \"inaccurateRows\": \"18\",\n                    \"insertedRows\": 18,\n                    \"size\": 2354\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.2.44\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 2849083,\n        \"File\": \"20250113_brickslevotheme_1ed06004268ec9b19798_20250113193438_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/backups-dup-pro\\/tmp\\/20250113_brickslevotheme_1ed06004268ec9b19798_20250113193438_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1736796913,\n            \"stopped_timestamp\": 1736796913,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": 13,\n    \"template_id\": 5,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2025-01-13 19:34:41\",\n    \"updated\": \"2025-01-13 19:35:13\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\",\n        \"DISASTER_AVAIABLE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}", "20250113_brickslevotheme_1ed06004268ec9b19798_20250113193438_archive.zip", "100", "MANUAL,HAVE_LOCAL,DISASTER_AVAIABLE,ZIP_ARCHIVE", "4.5.14.2", "2025-01-13 19:35:13");

/* INSERT TABLE DATA: wp_duplicator_entities */
INSERT INTO `wp_duplicator_entities` VALUES("1", "DUP_PRO_Global_Entity", "{\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"crypt\": true,\n    \"email_summary_frequency\": \"weekly\",\n    \"email_summary_recipients\": [],\n    \"usageTracking\": true,\n    \"amNotices\": true,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 2,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": null,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 6,\n    \"homepath_as_abspath\": false,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 18,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"ajax_protocol\": \"admin\",\n    \"custom_ajax_url\": \"http:\\/\\/roxus.levoengage.com\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"chunk_size\": 2048,\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"max_default_store_files\": 20,\n    \"purge_default_package_record\": false,\n    \"dropbox_upload_chunksize_in_kb\": 2000,\n    \"dropbox_transfer_mode\": 1,\n    \"gdrive_upload_chunksize_in_kb\": 1024,\n    \"gdrive_transfer_mode\": 0,\n    \"s3_upload_part_size_in_kb\": 6000,\n    \"onedrive_upload_chunksize_in_kb\": 3200,\n    \"local_upload_chunksize_in_MB\": 16,\n    \"manual_mode_storage_ids\": [\n        13\n    ],\n    \"license_status\": 0,\n    \"license_expiration_time\": 1737401096,\n    \"license_no_activations_left\": false,\n    \"license_key_visible\": 1,\n    \"lkp\": \"\",\n    \"license_type\": \"6\",\n    \"license_limit\": 500,\n    \"last_system_check_timestamp\": 1699376727,\n    \"initial_activation_timestamp\": 1629259970,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"debug_on\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"recoveryCustomPath\": \"\",\n    \"id\": 1,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-31 04:28:05\",\n    \"updated\": \"2025-01-13 19:34:38\"\n}", "", "", "", "", "", "4.5.14.2", "2023-12-31 04:28:05", "2025-01-13 19:34:38");
INSERT INTO `wp_duplicator_entities` VALUES("2", "DUP_PRO_Secure_Global_Entity", "{\n    \"basic_auth_password\": \"\",\n    \"lkp\": \"\",\n    \"id\": 2,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-31 04:28:05\",\n    \"updated\": \"2025-01-13 19:24:54\"\n}", "", "", "", "", "", "4.5.14.2", "2023-12-31 04:28:05", "2025-01-13 19:24:54");
INSERT INTO `wp_duplicator_entities` VALUES("3", "DUP_PRO_System_Global_Entity", "{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1736799293,\n    \"id\": 3,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-31 04:28:05\",\n    \"updated\": \"2025-01-13 20:14:53\"\n}", "", "", "", "", "", "4.5.14.2", "2023-12-31 04:28:05", "2025-01-13 20:14:53");
INSERT INTO `wp_duplicator_entities` VALUES("4", "DUP_PRO_Package_Template_Entity", "{\n    \"name\": \"Default\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": [],\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"mostWSRzhf1dlJJZ7FJmzjss1U0CiF\\/izCSCYz1lZQyH4oQjgtbvAHgg2TXap4pVh6WIL33AmAdaLnnsOaXBdA==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"type\": \"DUP_PRO_Package_Template_Entity\"\n}", "", "", "", "", "", "", "2023-12-31 04:28:05", "2023-12-31 04:28:05");
INSERT INTO `wp_duplicator_entities` VALUES("5", "DUP_PRO_Package_Template_Entity", "{\n    \"name\": \"[Manual Mode]\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"KACHU0kLEFXnHaUqKdz8EFklMspEBWuHXkWbJgUyBjd24d66EEDpZPYfaFMz7tB5cjlPraK61cihRWqdM7Cr+w==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": 0,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"id\": 5,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-31 04:28:05\",\n    \"updated\": \"2025-01-13 19:34:38\"\n}", "", "", "", "", "", "4.5.14.2", "2023-12-31 04:28:05", "2025-01-13 19:34:38");
INSERT INTO `wp_duplicator_entities` VALUES("10", "DUP_PRO_DupArchive_Expand_State_Entity", "{\n    \"package_id\": 10,\n    \"basePath\": \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/backups-dup-pro\\/tmp\\/validate\",\n    \"archivePath\": \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/backups-dup-pro\\/tmp\\/20220426_levotheme_4cb0777298eb18b84285_20220426200403_archive.daf\",\n    \"isCompressed\": true,\n    \"currentFileOffset\": 0,\n    \"archiveOffset\": 72888492,\n    \"timeSliceInSecs\": 10,\n    \"working\": false,\n    \"startTimestamp\": -1,\n    \"throttleDelayInUs\": 0,\n    \"timeoutTimestamp\": 1651003490,\n    \"timerEnabled\": true,\n    \"archiveHeaderString\": \"{\\\"isCompressed\\\":true}\",\n    \"currentFileHeaderString\": null,\n    \"failuresString\": \"[]\",\n    \"validateOnly\": true,\n    \"validationType\": 1,\n    \"fileWriteCount\": 13109,\n    \"directoryWriteCount\": 2472,\n    \"expectedFileCount\": 13109,\n    \"expectedDirectoryCount\": 2472,\n    \"isRobust\": false,\n    \"type\": \"DUP_PRO_DupArchive_Expand_State_Entity\",\n    \"currentFileHeader\": null,\n    \"filteredDirectories\": [],\n    \"excludedDirWithoutChilds\": [],\n    \"filteredFiles\": [],\n    \"includedFiles\": [],\n    \"fileRenames\": [],\n    \"directoryModeOverride\": -1,\n    \"fileModeOverride\": -1,\n    \"lastHeaderOffset\": -1,\n    \"failures\": [],\n    \"failureCount\": 0\n}", "", "", "", "", "", "", "2023-12-31 04:28:05", "2025-01-13 11:17:53");
INSERT INTO `wp_duplicator_entities` VALUES("15", "DUP_PRO_Package_Template_Entity", "{\n    \"name\": \"Default\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"60K+fY4MIVPB8qGpyK7d8mC1dDbr2K\\/6YlUqxvOU2xES8nsuSmP2ivebfAFrN4AiSXSqh0m9CRytJENf4CSsSg==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"id\": 15,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.14\",\n    \"created\": \"2023-12-31 12:28:05\",\n    \"updated\": \"2023-12-31 12:28:05\"\n}", "", "", "", "", "", "4.5.14", "2023-12-31 12:28:05", "2023-12-31 12:28:05");
INSERT INTO `wp_duplicator_entities` VALUES("16", "DUP_PRO_Package_Template_Entity", "{\n    \"name\": \"[Manual Mode]\",\n    \"notes\": \"\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"cacxEnHpwvQPhFivh4McXRSqczxG+SIclFEejFJLOaJwdcLMUffg9BACuA2xPcMOgm+P0XT\\/8YJEaG93Eue16w==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": 0,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"id\": 16,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.14\",\n    \"created\": \"2023-12-31 12:28:05\",\n    \"updated\": \"2023-12-31 12:28:05\"\n}", "", "", "", "", "", "4.5.14", "2023-12-31 12:28:05", "2023-12-31 12:28:05");
INSERT INTO `wp_duplicator_entities` VALUES("13", "DUP_PRO_Storage_Entity", "{\n    \"name\": \"Default\",\n    \"notes\": \"The default location for storage on this server.\",\n    \"storage_type\": -2,\n    \"config\": \"tu\\/QgDXJrQVAvycv4gvtvkzcldRdCi4b+DD8T\\/n5zl9fbWCOU06dEoYstm5TtRY9QlxBOeHjnd6iX8+lVPTDiWz5Yo90b090lBRxsiCR4EpxpPkar\\/02gajcak16wcJll8fNljSFTnWaoOlHnjwOC7rNOVfGFx\\/uQS9usdPS1Yv2kDrNzMZk5dIg37kL1D+6Ke0xi1WPCLJXtbCcs6wI6P9NbWzShcsXcExPKMSvkOWRqGYLksOKDPbnN4RK\\/UDRykA61LuZEyJ\\/YmyFUO9FbQRNmnfznKJNZW28hv33xmV\\/WxcvjfwK02b6WHb5H7Hz\",\n    \"legacyEntity\": false,\n    \"local_storage_folder\": \"\",\n    \"local_max_files\": 10,\n    \"local_filter_protection\": true,\n    \"purge_package_record\": true,\n    \"dropbox_access_token\": \"\",\n    \"dropbox_access_token_secret\": \"\",\n    \"dropbox_v2_access_token\": \"\",\n    \"dropbox_storage_folder\": \"\",\n    \"dropbox_max_files\": 10,\n    \"dropbox_authorization_state\": 0,\n    \"onedrive_endpoint_url\": \"\",\n    \"onedrive_resource_id\": \"\",\n    \"onedrive_access_token\": \"\",\n    \"onedrive_refresh_token\": \"\",\n    \"onedrive_token_obtained\": 0,\n    \"onedrive_user_id\": \"\",\n    \"onedrive_storage_folder\": \"\",\n    \"onedrive_max_files\": 10,\n    \"onedrive_storage_folder_id\": \"\",\n    \"onedrive_authorization_state\": 0,\n    \"onedrive_storage_folder_web_url\": \"\",\n    \"ftp_server\": \"\",\n    \"ftp_port\": 21,\n    \"ftp_username\": \"\",\n    \"ftp_password\": \"\",\n    \"ftp_use_curl\": false,\n    \"ftp_storage_folder\": \"\",\n    \"ftp_max_files\": 10,\n    \"ftp_timeout_in_secs\": 15,\n    \"ftp_ssl\": false,\n    \"ftp_passive_mode\": false,\n    \"sftp_server\": \"\",\n    \"sftp_port\": 22,\n    \"sftp_username\": \"\",\n    \"sftp_password\": \"\",\n    \"sftp_private_key\": \"\",\n    \"sftp_private_key_password\": \"\",\n    \"sftp_storage_folder\": \"\",\n    \"sftp_timeout_in_secs\": 15,\n    \"sftp_max_files\": 10,\n    \"sftp_disable_chunking_mode\": false,\n    \"gdrive_access_token_set_json\": \"\",\n    \"gdrive_refresh_token\": \"\",\n    \"gdrive_storage_folder\": \"\",\n    \"gdrive_max_files\": 10,\n    \"gdrive_authorization_state\": 0,\n    \"gdrive_client_number\": -1,\n    \"s3_access_key\": \"\",\n    \"s3_bucket\": \"\",\n    \"s3_max_files\": 10,\n    \"s3_provider\": \"amazon\",\n    \"s3_region\": \"\",\n    \"s3_endpoint\": \"\",\n    \"s3_secret_key\": \"\",\n    \"s3_storage_class\": \"STANDARD\",\n    \"s3_storage_folder\": \"\",\n    \"s3_ACL_full_control\": true,\n    \"id\": 13,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-31 12:28:05\",\n    \"updated\": \"2025-01-13 19:24:33\"\n}", "", "", "", "", "", "4.5.14.2", "2023-12-31 12:28:05", "2025-01-13 19:24:33");
INSERT INTO `wp_duplicator_entities` VALUES("14", "EmailSummary", "{\n    \"manualPackageIds\": [\n        12,\n        13\n    ],\n    \"scheduledPackageIds\": [],\n    \"failedPackageIds\": [],\n    \"scheduleIds\": [],\n    \"storageIds\": [\n        13\n    ],\n    \"id\": 14,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2023-12-31 12:28:05\",\n    \"updated\": \"2025-01-13 19:35:12\"\n}", "", "", "", "", "", "4.5.14.2", "2023-12-31 12:28:05", "2025-01-13 19:35:12");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("3", "20250113_brickslevotheme", "c695d5a1ff96c1439373_20251211184609", "100", "2025-12-11 18:46:14", "levo", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-11 18:46:09\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.7.4\";s:9:\"VersionDB\";s:7:\"10.6.24\";s:10:\"VersionPHP\";s:6:\"8.1.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:3;s:4:\"Name\";s:24:\"20250113_brickslevotheme\";s:4:\"Hash\";s:35:\"c695d5a1ff96c1439373_20251211184609\";s:8:\"NameHash\";s:60:\"20250113_brickslevotheme_c695d5a1ff96c1439373_20251211184609\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:70:\"20250113_brickslevotheme_c695d5a1ff96c1439373_20251211184609_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"14.37 sec.\";s:7:\"ExeSize\";s:6:\"73.5KB\";s:7:\"ZipSize\";s:8:\"105.71MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:4:\"levo\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:72:\"20250113_brickslevotheme_c695d5a1ff96c1439373_20251211184609_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:42:\"/home/levoen5/staging/roxus.levoengage.com\";s:4:\"Size\";i:110843971;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2211;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11385;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:13595;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:51:\"/home/levoen5/staging/roxus.levoengage.com/wp-admin\";i:1;s:54:\"/home/levoen5/staging/roxus.levoengage.com/wp-includes\";i:2;s:63:\"/home/levoen5/staging/roxus.levoengage.com/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:42:\"/home/levoen5/staging/roxus.levoengage.com\";i:1;s:42:\"/home/levoen5/staging/roxus.levoengage.com\";i:2;s:53:\"/home/levoen5/staging/roxus.levoengage.com/wp-content\";i:3;s:61:\"/home/levoen5/staging/roxus.levoengage.com/wp-content/uploads\";i:4;s:61:\"/home/levoen5/staging/roxus.levoengage.com/wp-content/plugins\";i:5;s:64:\"/home/levoen5/staging/roxus.levoengage.com/wp-content/mu-plugins\";i:6;s:60:\"/home/levoen5/staging/roxus.levoengage.com/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:74:\"/home/levoen5/staging/roxus.levoengage.com/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:78:\"20250113_brickslevotheme_c695d5a1ff96c1439373_20251211184609_installer.php.bak\";s:4:\"Size\";i:75260;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:126:\"/home/levoen5/staging/roxus.levoengage.com/wp-content/backups-dup-lite/tmp/original_files_c695d5a-11184609/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:106:\"/home/levoen5/staging/roxus.levoengage.com/wp-content/backups-dup-lite/tmp/original_files_c695d5a-11184609\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:42:\"/home/levoen5/staging/roxus.levoengage.com\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:56:\"/home/levoen5/staging/roxus.levoengage.com/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3332:\"<?php\n/**\n * The base configuration for WordPress\n *\n * The wp-config.php creation script uses this file during the\n * installation. You don\'t have to use the web site, you can\n * copy this file to \"wp-config.php\" and fill in the values.\n *\n * This file contains the following configurations:\n *\n * * MySQL settings\n * * Secret keys\n * * Database table prefix\n * * ABSPATH\n *\n * @link https://codex.wordpress.org/Editing_wp-config.php\n *\n * @package WordPress\n */\n\n// ** MySQL settings - You can get this info from your web host ** //\n/** The name of the database for WordPress */\ndefine( \'DB_NAME\', \"levoen5_roxus\" );\n\n/** MySQL database username */\ndefine( \'DB_USER\', \"levoen5_usr\" );\n\n/** MySQL database password */\ndefine( \'DB_PASSWORD\', \"MaF3-j0N&-9375!#\" );\n\n/** MySQL hostname */\ndefine( \'DB_HOST\', \"localhost\" );\n\n/** Database Charset to use in creating database tables. */\ndefine( \'DB_CHARSET\', \'latin1\' );\n\n/** The Database Collate type. Don\'t change this if in doubt. */\ndefine( \'DB_COLLATE\', \'\' );\n\n/**#@+\n * Authentication Unique Keys and Salts.\n *\n * Change these to different unique phrases!\n * You can generate these using the {@link https://api.wordpress.org/secret-key/1.1/salt/ WordPress.org secret-key service}\n * You can change these at any point in time to invalidate all existing cookies. This will force all users to have to log in again.\n *\n * @since 2.6.0\n */\ndefine(\'AUTH_KEY\',         \'pTydt&v(D PS-RL*}jWs`.@p57mX>y^]||^a?J1|k)ZBqI1Fcky+3obRDB$I*;Bn\');\ndefine(\'SECURE_AUTH_KEY\',  \'53+kmy>NxFk]?&ip8XRGNhqm*H4|<Ik*$keD5|27)fH;w*7qd+Ay$[9?)6]6LheB\');\ndefine(\'LOGGED_IN_KEY\',    \'YP|=n*.(/J~}CLVW5:~kcqpoZ]xcy_H)bHA)BB~N04&.=KMdG}*CTL<l6JV.Q48&\');\ndefine(\'NONCE_KEY\',        \'Zds%1t52;zZ6#*3d;&Q=]xol&txA[i^XZ=uxo{4aCDqGk%+&l51t6@qW&<R-pxi|\');\ndefine(\'AUTH_SALT\',        \'Dh<Jl5_A>rM.dPWbfr.jRdd;.z2+YUFo24jLsusJo:&P) ~YE~x{Ee~/V^Ttd#y#\');\ndefine(\'SECURE_AUTH_SALT\', \'b!fY#zh`CQR-9]K|FUYviSIb-|gI+A})Pe|lA<#]0SpJZ =!!oJ*i{Z{,U=%x=~8\');\ndefine(\'LOGGED_IN_SALT\',   \'RBFvi|~Qp7QK-sW81JJ]ouS&|my:C4Z-O6j<+KUt4!c+i!GnQ|J6KFr;&+@k_mKJ\');\ndefine(\'NONCE_SALT\',       \'|SjZ68HGG=SWX4~]6i)Em5*fW^BP|}{[]hX~GQfMa;Ra:X?2I5_SGx?n;T8{#z1u\');\n\n/**#@-*/\n\n/**\n * WordPress Database Table prefix.\n *\n * You can have multiple installations in one database if you give each\n * a unique prefix. Only numbers, letters, and underscores please!\n */\n$table_prefix = \'wp_\';\n\n/**\n * For developers: WordPress debugging mode.\n *\n * Change this to true to enable the display of notices during development.\n * It is strongly recommended that plugin and theme developers use WP_DEBUG\n * in their development environments.\n *\n * For information on other constants that can be used for debugging,\n * visit the Codex.\n *\n * @link https://codex.wordpress.org/Debugging_in_WordPress\n */\ndefine( \'WP_DEBUG\', false );\n\ndefine( \'DUPLICATOR_AUTH_KEY\', \'83fe03e243891ced530f2be41de6e288\' );\ndefine( \'WP_PLUGIN_DIR\', \'/home/levoen5/staging/roxus.levoengage.com/wp-content/plugins\' );\ndefine( \'WPMU_PLUGIN_DIR\', \'/home/levoen5/staging/roxus.levoengage.com/wp-content/mu-plugins\' );\n/* That\'s all, stop editing! Happy publishing. */\n\n/** Absolute path to the WordPress directory. */\nif ( ! defined( \'ABSPATH\' ) ) {\n	define( \'ABSPATH\', __DIR__ . \'/\' );\n}\n\n/** Sets up WordPress vars and included files. */\nrequire_once( ABSPATH . \'wp-settings.php\' );\n\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:19:{s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:37:\"define( \'DB_NAME\', \"levoen5_roxus\" );\";s:5:\"value\";s:15:\"\"levoen5_roxus\"\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_NAME\'\";i:1;s:18:\", \"levoen5_roxus\" \";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:35:\"define( \'DB_USER\', \"levoen5_usr\" );\";s:5:\"value\";s:13:\"\"levoen5_usr\"\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_USER\'\";i:1;s:16:\", \"levoen5_usr\" \";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:44:\"define( \'DB_PASSWORD\', \"MaF3-j0N&-9375!#\" );\";s:5:\"value\";s:18:\"\"MaF3-j0N&-9375!#\"\";s:5:\"parts\";a:3:{i:0;s:21:\"define( \'DB_PASSWORD\'\";i:1;s:21:\", \"MaF3-j0N&-9375!#\" \";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:33:\"define( \'DB_HOST\', \"localhost\" );\";s:5:\"value\";s:11:\"\"localhost\"\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_HOST\'\";i:1;s:14:\", \"localhost\" \";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:33:\"define( \'DB_CHARSET\', \'latin1\' );\";s:5:\"value\";s:8:\"\'latin1\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_CHARSET\'\";i:1;s:11:\", \'latin1\' \";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:27:\"define( \'DB_COLLATE\', \'\' );\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_COLLATE\'\";i:1;s:5:\", \'\' \";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:95:\"define(\'AUTH_KEY\',         \'pTydt&v(D PS-RL*}jWs`.@p57mX>y^]||^a?J1|k)ZBqI1Fcky+3obRDB$I*;Bn\');\";s:5:\"value\";s:66:\"\'pTydt&v(D PS-RL*}jWs`.@p57mX>y^]||^a?J1|k)ZBqI1Fcky+3obRDB$I*;Bn\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define(\'AUTH_KEY\'\";i:1;s:76:\",         \'pTydt&v(D PS-RL*}jWs`.@p57mX>y^]||^a?J1|k)ZBqI1Fcky+3obRDB$I*;Bn\'\";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:95:\"define(\'SECURE_AUTH_KEY\',  \'53+kmy>NxFk]?&ip8XRGNhqm*H4|<Ik*$keD5|27)fH;w*7qd+Ay$[9?)6]6LheB\');\";s:5:\"value\";s:66:\"\'53+kmy>NxFk]?&ip8XRGNhqm*H4|<Ik*$keD5|27)fH;w*7qd+Ay$[9?)6]6LheB\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define(\'SECURE_AUTH_KEY\'\";i:1;s:69:\",  \'53+kmy>NxFk]?&ip8XRGNhqm*H4|<Ik*$keD5|27)fH;w*7qd+Ay$[9?)6]6LheB\'\";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:95:\"define(\'LOGGED_IN_KEY\',    \'YP|=n*.(/J~}CLVW5:~kcqpoZ]xcy_H)bHA)BB~N04&.=KMdG}*CTL<l6JV.Q48&\');\";s:5:\"value\";s:66:\"\'YP|=n*.(/J~}CLVW5:~kcqpoZ]xcy_H)bHA)BB~N04&.=KMdG}*CTL<l6JV.Q48&\'\";s:5:\"parts\";a:3:{i:0;s:22:\"define(\'LOGGED_IN_KEY\'\";i:1;s:71:\",    \'YP|=n*.(/J~}CLVW5:~kcqpoZ]xcy_H)bHA)BB~N04&.=KMdG}*CTL<l6JV.Q48&\'\";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:95:\"define(\'NONCE_KEY\',        \'Zds%1t52;zZ6#*3d;&Q=]xol&txA[i^XZ=uxo{4aCDqGk%+&l51t6@qW&<R-pxi|\');\";s:5:\"value\";s:66:\"\'Zds%1t52;zZ6#*3d;&Q=]xol&txA[i^XZ=uxo{4aCDqGk%+&l51t6@qW&<R-pxi|\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'NONCE_KEY\'\";i:1;s:75:\",        \'Zds%1t52;zZ6#*3d;&Q=]xol&txA[i^XZ=uxo{4aCDqGk%+&l51t6@qW&<R-pxi|\'\";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'AUTH_SALT\',        \'Dh<Jl5_A>rM.dPWbfr.jRdd;.z2+YUFo24jLsusJo:&P) ~YE~x{Ee~/V^Ttd#y#\');\";s:5:\"value\";s:66:\"\'Dh<Jl5_A>rM.dPWbfr.jRdd;.z2+YUFo24jLsusJo:&P) ~YE~x{Ee~/V^Ttd#y#\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'AUTH_SALT\'\";i:1;s:75:\",        \'Dh<Jl5_A>rM.dPWbfr.jRdd;.z2+YUFo24jLsusJo:&P) ~YE~x{Ee~/V^Ttd#y#\'\";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'SECURE_AUTH_SALT\', \'b!fY#zh`CQR-9]K|FUYviSIb-|gI+A})Pe|lA<#]0SpJZ =!!oJ*i{Z{,U=%x=~8\');\";s:5:\"value\";s:66:\"\'b!fY#zh`CQR-9]K|FUYviSIb-|gI+A})Pe|lA<#]0SpJZ =!!oJ*i{Z{,U=%x=~8\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define(\'SECURE_AUTH_SALT\'\";i:1;s:68:\", \'b!fY#zh`CQR-9]K|FUYviSIb-|gI+A})Pe|lA<#]0SpJZ =!!oJ*i{Z{,U=%x=~8\'\";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'LOGGED_IN_SALT\',   \'RBFvi|~Qp7QK-sW81JJ]ouS&|my:C4Z-O6j<+KUt4!c+i!GnQ|J6KFr;&+@k_mKJ\');\";s:5:\"value\";s:66:\"\'RBFvi|~Qp7QK-sW81JJ]ouS&|my:C4Z-O6j<+KUt4!c+i!GnQ|J6KFr;&+@k_mKJ\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define(\'LOGGED_IN_SALT\'\";i:1;s:70:\",   \'RBFvi|~Qp7QK-sW81JJ]ouS&|my:C4Z-O6j<+KUt4!c+i!GnQ|J6KFr;&+@k_mKJ\'\";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'NONCE_SALT\',       \'|SjZ68HGG=SWX4~]6i)Em5*fW^BP|}{[]hX~GQfMa;Ra:X?2I5_SGx?n;T8{#z1u\');\";s:5:\"value\";s:66:\"\'|SjZ68HGG=SWX4~]6i)Em5*fW^BP|}{[]hX~GQfMa;Ra:X?2I5_SGx?n;T8{#z1u\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'NONCE_SALT\'\";i:1;s:74:\",       \'|SjZ68HGG=SWX4~]6i)Em5*fW^BP|}{[]hX~GQfMa;Ra:X?2I5_SGx?n;T8{#z1u\'\";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:28:\"define( \'WP_DEBUG\', false );\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_DEBUG\'\";i:1;s:8:\", false \";i:2;s:2:\");\";}}s:19:\"DUPLICATOR_AUTH_KEY\";a:3:{s:3:\"src\";s:68:\"define( \'DUPLICATOR_AUTH_KEY\', \'83fe03e243891ced530f2be41de6e288\' );\";s:5:\"value\";s:34:\"\'83fe03e243891ced530f2be41de6e288\'\";s:5:\"parts\";a:3:{i:0;s:29:\"define( \'DUPLICATOR_AUTH_KEY\'\";i:1;s:37:\", \'83fe03e243891ced530f2be41de6e288\' \";i:2;s:2:\");\";}}s:13:\"WP_PLUGIN_DIR\";a:3:{s:3:\"src\";s:91:\"define( \'WP_PLUGIN_DIR\', \'/home/levoen5/staging/roxus.levoengage.com/wp-content/plugins\' );\";s:5:\"value\";s:63:\"\'/home/levoen5/staging/roxus.levoengage.com/wp-content/plugins\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define( \'WP_PLUGIN_DIR\'\";i:1;s:66:\", \'/home/levoen5/staging/roxus.levoengage.com/wp-content/plugins\' \";i:2;s:2:\");\";}}s:15:\"WPMU_PLUGIN_DIR\";a:3:{s:3:\"src\";s:96:\"define( \'WPMU_PLUGIN_DIR\', \'/home/levoen5/staging/roxus.levoengage.com/wp-content/mu-plugins\' );\";s:5:\"value\";s:66:\"\'/home/levoen5/staging/roxus.levoengage.com/wp-content/mu-plugins\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define( \'WPMU_PLUGIN_DIR\'\";i:1;s:69:\", \'/home/levoen5/staging/roxus.levoengage.com/wp-content/mu-plugins\' \";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:36:\"	define( \'ABSPATH\', __DIR__ . \'/\' );\";s:5:\"value\";s:13:\"__DIR__ . \'/\'\";s:5:\"parts\";a:3:{i:0;s:18:\"	define( \'ABSPATH\'\";i:1;s:16:\", __DIR__ . \'/\' \";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:22:\"$table_prefix = \'wp_\';\";s:5:\"value\";s:5:\"\'wp_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:7:\" \'wp_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:20417856;s:4:\"File\";s:73:\"20250113_brickslevotheme_c695d5a1ff96c1439373_20251211184609_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:2:{i:0;s:7:\"utf8mb4\";i:1;s:6:\"latin1\";}s:13:\"collationList\";a:3:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:22:\"utf8mb4_unicode_520_ci\";i:2;s:18:\"utf8mb4_unicode_ci\";}s:10:\"engineList\";a:2:{i:0;s:6:\"MyISAM\";i:1;s:6:\"InnoDB\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:13:\"levoen5_roxus\";s:15:\"tablesBaseCount\";i:50;s:16:\"tablesFinalCount\";i:50;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:1590;s:16:\"tablesSizeOnDisk\";i:18709659;s:10:\"tablesList\";a:50:{s:26:\"wp_actionscheduler_actions\";a:3:{s:14:\"inaccurateRows\";i:28;s:12:\"insertedRows\";i:28;s:4:\"size\";i:33288;}s:25:\"wp_actionscheduler_claims\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:3100;}s:25:\"wp_actionscheduler_groups\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:9340;}s:23:\"wp_actionscheduler_logs\";a:3:{s:14:\"inaccurateRows\";i:76;s:12:\"insertedRows\";i:76;s:4:\"size\";i:12752;}s:14:\"wp_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:11:\"wp_comments\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:21:\"wp_duplicator_backups\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:58336;}s:22:\"wp_duplicator_entities\";a:3:{s:14:\"inaccurateRows\";i:10;s:12:\"insertedRows\";i:10;s:4:\"size\";i:45552;}s:22:\"wp_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:9152;}s:16:\"wp_gf_addon_feed\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:23:\"wp_gf_draft_submissions\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:11:\"wp_gf_entry\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:16:\"wp_gf_entry_meta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:17:\"wp_gf_entry_notes\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:10:\"wp_gf_form\";a:3:{s:14:\"inaccurateRows\";i:3;s:12:\"insertedRows\";i:3;s:4:\"size\";i:2168;}s:15:\"wp_gf_form_meta\";a:3:{s:14:\"inaccurateRows\";i:3;s:12:\"insertedRows\";i:3;s:4:\"size\";i:37928;}s:20:\"wp_gf_form_revisions\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:15:\"wp_gf_form_view\";a:3:{s:14:\"inaccurateRows\";i:3;s:12:\"insertedRows\";i:3;s:4:\"size\";i:4336;}s:19:\"wp_gf_rest_api_keys\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:6308;}s:8:\"wp_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:10:\"wp_options\";a:3:{s:14:\"inaccurateRows\";i:422;s:12:\"insertedRows\";i:422;s:4:\"size\";i:2379372;}s:11:\"wp_postmeta\";a:3:{s:14:\"inaccurateRows\";i:409;s:12:\"insertedRows\";i:409;s:4:\"size\";i:15730604;}s:8:\"wp_posts\";a:3:{s:14:\"inaccurateRows\";i:269;s:12:\"insertedRows\";i:269;s:4:\"size\";i:103348;}s:18:\"wp_redirection_404\";a:3:{s:14:\"inaccurateRows\";i:128;s:12:\"insertedRows\";i:128;s:4:\"size\";i:37292;}s:21:\"wp_redirection_groups\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:4164;}s:20:\"wp_redirection_items\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:19:\"wp_redirection_logs\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:16:\"wp_revslider_css\";a:3:{s:14:\"inaccurateRows\";i:109;s:12:\"insertedRows\";i:109;s:4:\"size\";i:95152;}s:29:\"wp_revslider_layer_animations\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:24:\"wp_revslider_navigations\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:20:\"wp_revslider_sliders\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:19:\"wp_revslider_slides\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:26:\"wp_revslider_static_slides\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:12:\"wp_rg_zapier\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:11:\"wp_termmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:8:\"wp_terms\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:13388;}s:21:\"wp_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:3156;}s:16:\"wp_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:4168;}s:14:\"wp_tm_taskmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:11:\"wp_tm_tasks\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:11:\"wp_usermeta\";a:3:{s:14:\"inaccurateRows\";i:46;s:12:\"insertedRows\";i:46;s:4:\"size\";i:16048;}s:8:\"wp_users\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:8284;}s:26:\"wp_wpmailsmtp_debug_events\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:3;s:4:\"size\";i:16384;}s:24:\"wp_wpmailsmtp_tasks_meta\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:2116;}s:18:\"wp_yoast_indexable\";a:3:{s:14:\"inaccurateRows\";i:10;s:12:\"insertedRows\";i:10;s:4:\"size\";i:15432;}s:28:\"wp_yoast_indexable_hierarchy\";a:3:{s:14:\"inaccurateRows\";i:9;s:12:\"insertedRows\";i:9;s:4:\"size\";i:5309;}s:19:\"wp_yoast_migrations\";a:3:{s:14:\"inaccurateRows\";i:24;s:12:\"insertedRows\";i:24;s:4:\"size\";i:9792;}s:21:\"wp_yoast_primary_term\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:18:\"wp_yoast_seo_links\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:4172;}s:17:\"wp_yoast_seo_meta\";a:3:{s:14:\"inaccurateRows\";i:18;s:12:\"insertedRows\";i:18;s:4:\"size\";i:2354;}}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:7:\"MariaDB\";s:7:\"version\";s:7:\"10.6.24\";s:14:\"versionComment\";s:14:\"MariaDB Server\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:148:\"/home/levoen5/staging/roxus.levoengage.com/wp-content/backups-dup-lite/tmp/20250113_brickslevotheme_c695d5a1ff96c1439373_20251211184609_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-11 18:46:09\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.7.4\";s:9:\"VersionDB\";s:7:\"10.6.24\";s:10:\"VersionPHP\";s:6:\"8.1.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:24:\"20250113_brickslevotheme\";s:4:\"Hash\";s:35:\"c695d5a1ff96c1439373_20251211184609\";s:8:\"NameHash\";s:60:\"20250113_brickslevotheme_c695d5a1ff96c1439373_20251211184609\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:248;s:13:\"BuildProgress\";r:494;}}}");
INSERT INTO `wp_duplicator_packages` VALUES("4", "20250113_brickslevotheme", "73dc243ddce0c0629693_20251211212115", "21", "2025-12-11 21:21:19", "levo", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-11 21:21:15\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.7.4\";s:9:\"VersionDB\";s:7:\"10.6.24\";s:10:\"VersionPHP\";s:6:\"8.1.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:4;s:4:\"Name\";s:24:\"20250113_brickslevotheme\";s:4:\"Hash\";s:35:\"73dc243ddce0c0629693_20251211212115\";s:8:\"NameHash\";s:60:\"20250113_brickslevotheme_73dc243ddce0c0629693_20251211212115\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:70:\"20250113_brickslevotheme_73dc243ddce0c0629693_20251211212115_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.6\";s:6:\"WPUser\";s:4:\"levo\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:72:\"20250113_brickslevotheme_73dc243ddce0c0629693_20251211212115_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:42:\"/home/levoen5/staging/roxus.levoengage.com\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2211;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11389;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-11 21:21:15\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.7.4\";s:9:\"VersionDB\";s:7:\"10.6.24\";s:10:\"VersionPHP\";s:6:\"8.1.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:24:\"20250113_brickslevotheme\";s:4:\"Hash\";s:35:\"73dc243ddce0c0629693_20251211212115\";s:8:\"NameHash\";s:60:\"20250113_brickslevotheme_73dc243ddce0c0629693_20251211212115\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:78:\"20250113_brickslevotheme_73dc243ddce0c0629693_20251211212115_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:56:\"/home/levoen5/staging/roxus.levoengage.com/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:73:\"20250113_brickslevotheme_73dc243ddce0c0629693_20251211212115_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:148:\"/home/levoen5/staging/roxus.levoengage.com/wp-content/backups-dup-lite/tmp/20250113_brickslevotheme_73dc243ddce0c0629693_20251211212115_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:51:\"/home/levoen5/staging/roxus.levoengage.com/wp-admin\";i:1;s:54:\"/home/levoen5/staging/roxus.levoengage.com/wp-includes\";i:2;s:63:\"/home/levoen5/staging/roxus.levoengage.com/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:42:\"/home/levoen5/staging/roxus.levoengage.com\";i:1;s:42:\"/home/levoen5/staging/roxus.levoengage.com\";i:2;s:53:\"/home/levoen5/staging/roxus.levoengage.com/wp-content\";i:3;s:61:\"/home/levoen5/staging/roxus.levoengage.com/wp-content/uploads\";i:4;s:61:\"/home/levoen5/staging/roxus.levoengage.com/wp-content/plugins\";i:5;s:64:\"/home/levoen5/staging/roxus.levoengage.com/wp-content/mu-plugins\";i:6;s:60:\"/home/levoen5/staging/roxus.levoengage.com/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:74:\"/home/levoen5/staging/roxus.levoengage.com/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_gf_form */
INSERT INTO `wp_gf_form` VALUES("1", "Test", "2021-04-14 15:13:36", NULL, "1", "1");
INSERT INTO `wp_gf_form` VALUES("2", "Newsletter Form", "2022-06-29 20:56:39", NULL, "1", "0");
INSERT INTO `wp_gf_form` VALUES("3", "Contact Form", "2025-12-11 14:41:44", NULL, "1", "0");

/* INSERT TABLE DATA: wp_gf_form_meta */
INSERT INTO `wp_gf_form_meta` VALUES("1", "{\"title\":\"Test\",\"description\":\"\",\"labelPlacement\":\"top_label\",\"descriptionPlacement\":\"below\",\"button\":{\"type\":\"text\",\"text\":\"Submit\",\"imageUrl\":\"\"},\"fields\":[{\"type\":\"text\",\"id\":1,\"label\":\"Email\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":1,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"enablePasswordInput\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"pageNumber\":1,\"fields\":\"\"}],\"version\":\"2.4.24\",\"id\":1,\"nextFieldId\":2,\"useCurrentUserAsAuthor\":true,\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null}", NULL, "{\"607706a0d2e04\":{\"id\":\"607706a0d2e04\",\"name\":\"Default Confirmation\",\"isDefault\":true,\"type\":\"message\",\"message\":\"Thanks for contacting us! We will get in touch with you shortly.\",\"url\":\"\",\"pageId\":\"\",\"queryString\":\"\"}}", "{\"607706a0d2d27\":{\"id\":\"607706a0d2d27\",\"isActive\":true,\"to\":\"{admin_email}\",\"name\":\"Admin Notification\",\"event\":\"form_submission\",\"toType\":\"email\",\"subject\":\"New submission from {form_title}\",\"message\":\"{all_fields}\"}}");
INSERT INTO `wp_gf_form_meta` VALUES("2", "{\"title\":\"Newsletter Form\",\"description\":\"\",\"labelPlacement\":\"top_label\",\"descriptionPlacement\":\"below\",\"button\":{\"type\":\"text\",\"text\":\"Join\",\"imageUrl\":\"\",\"conditionalLogic\":null,\"width\":\"auto\",\"location\":\"inline\",\"layoutGridColumnSpan\":2,\"id\":\"submit\"},\"fields\":[{\"is_payment\":false,\"type\":\"email\",\"id\":27,\"label\":\"Email\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"email\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Email*\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":null,\"productField\":\"\",\"emailConfirmEnabled\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"checkboxLabel\":\"\",\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"25aa1281\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"layoutGridColumnSpan\":12,\"errors\":[],\"pageNumber\":1,\"layoutSpacerGridColumnSpan\":0},{\"is_payment\":false,\"type\":\"hidden\",\"id\":11,\"label\":\"Lead Source\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":true,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"lead_source\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"2c162251\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"pageNumber\":1},{\"is_payment\":false,\"type\":\"hidden\",\"id\":12,\"label\":\"Entry URL\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":true,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"entry_url\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"34bb0ca4\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"pageNumber\":1},{\"is_payment\":false,\"type\":\"hidden\",\"id\":13,\"label\":\"Entry Referrer URL\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":true,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"entry_http_referrer\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"4590c5d8\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"pageNumber\":1},{\"is_payment\":false,\"type\":\"hidden\",\"id\":37,\"label\":\"Post URL\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"{embed_url}\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"7c62a5b7\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"layoutGridColumnSpan\":12,\"pageNumber\":1},{\"is_payment\":false,\"type\":\"hidden\",\"id\":15,\"label\":\"Post Referrer URL\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":true,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"current_http_referrer\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"cb0845db\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"pageNumber\":1},{\"is_payment\":false,\"type\":\"hidden\",\"id\":16,\"label\":\"UTM Source\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":true,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"utm_source\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"ff70118e\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"pageNumber\":1},{\"is_payment\":false,\"type\":\"hidden\",\"id\":17,\"label\":\"UTM Medium\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":true,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"utm_medium\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"a958e410\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"pageNumber\":1},{\"is_payment\":false,\"type\":\"hidden\",\"id\":18,\"label\":\"UTM Campaign\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":true,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"utm_campaign\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"f3611456\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"pageNumber\":1},{\"is_payment\":false,\"type\":\"hidden\",\"id\":19,\"label\":\"UTM Term\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":true,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"utm_term\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"fac82c89\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"pageNumber\":1},{\"is_payment\":false,\"type\":\"hidden\",\"id\":20,\"label\":\"UTM Content\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":true,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"utm_content\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"b7f4d2b9\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"pageNumber\":1},{\"is_payment\":false,\"type\":\"hidden\",\"id\":38,\"label\":\"GCLID\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":true,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"gclid\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"7288596e\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"layoutGridColumnSpan\":12,\"pageNumber\":1},{\"is_payment\":false,\"type\":\"hidden\",\"id\":39,\"label\":\"FBCLID\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":true,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"fbclid\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"5bd5f6f0\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"layoutGridColumnSpan\":12,\"pageNumber\":1},{\"is_payment\":false,\"type\":\"hidden\",\"id\":21,\"label\":\"User IP\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":true,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"user_ip\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"e532f9ae\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"pageNumber\":1,\"layoutGridColumnSpan\":6}],\"version\":\"2.9.23.2\",\"id\":2,\"nextFieldId\":40,\"useCurrentUserAsAuthor\":true,\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"is_active\":\"1\",\"date_created\":\"2020-06-30 07:48:35\",\"is_trash\":\"0\",\"subLabelPlacement\":\"below\",\"requiredIndicator\":\"asterisk\",\"customRequiredIndicator\":\"(Required)\",\"cssClass\":\"\",\"buttonType\":\"text\",\"buttonText\":\"Submit\",\"buttonImageURL\":\"\",\"form_button_conditional_logic_object\":\"\",\"form_button_conditional_logic\":\"0\",\"saveButtonText\":\"Save and Continue Later\",\"limitEntries\":false,\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":false,\"scheduleStart\":\"\",\"scheduleEnd\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":false,\"requireLoginMessage\":\"\",\"enableGFZeroSpam\":\"1\",\"validationSummary\":false,\"saveEnabled\":\"\",\"enableHoneypot\":false,\"enableAnimation\":false,\"markupVersion\":2,\"save\":{\"enabled\":false,\"button\":{\"type\":\"link\",\"text\":\"Save and Continue Later\"}},\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\",\"validationPlacement\":\"below\",\"honeypotAction\":\"spam\",\"deprecated\":\"\",\"submitSpeedCheckThreshold\":2000,\"submitSpeedCheckMode\":\"normal\",\"enableSubmitSpeedCheck\":false}", NULL, "{\"5efaee5398b5f\":{\"id\":\"5efaee5398b5f\",\"name\":\"Default Confirmation\",\"isDefault\":true,\"type\":\"message\",\"message\":\"Thank You!\",\"url\":\"\",\"pageId\":\"2017\",\"queryString\":\"\",\"disableAutoformat\":false,\"conditionalLogic\":[],\"event\":\"\",\"page\":\"2017\"}}", "{\"5efaee5398943\":{\"isActive\":true,\"name\":\"Admin Notificatio\",\"service\":\"wordpress\",\"event\":\"form_submission\",\"to\":\"{admin_email}\",\"toType\":\"email\",\"cc\":\"\",\"bcc\":\"rsilva@levohealth.com, apedersen@levohealth.com\",\"subject\":\"New Form Submission\",\"message\":\"{all_fields}\",\"from\":\"{admin_email}\",\"fromName\":\"\",\"replyTo\":\"\",\"routing\":null,\"conditionalLogic\":null,\"disableAutoformat\":true,\"enableAttachments\":false,\"id\":\"5efaee5398943\",\"toEmail\":\"{admin_email}\",\"toField\":\"\",\"notification_conditional_logic_object\":\"\",\"notification_conditional_logic\":\"0\"}}");
INSERT INTO `wp_gf_form_meta` VALUES("3", "{\"title\":\"Contact Form\",\"description\":\"\",\"labelPlacement\":\"top_label\",\"descriptionPlacement\":\"below\",\"button\":{\"type\":\"text\",\"text\":\"Submit\",\"imageUrl\":\"\",\"conditionalLogic\":null,\"width\":\"auto\",\"location\":\"inline\",\"layoutGridColumnSpan\":2,\"id\":\"submit\"},\"fields\":[{\"is_payment\":false,\"type\":\"text\",\"id\":40,\"formId\":3,\"label\":\"First Name\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"text\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"First Name*\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"enableDisplayInColumns\":\"\",\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"6526c4fe\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\"},{\"is_payment\":false,\"type\":\"text\",\"id\":41,\"formId\":3,\"label\":\"Last Name\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"text\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Last Name*\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"enableDisplayInColumns\":\"\",\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"6526c4fe\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\"},{\"is_payment\":false,\"type\":\"email\",\"id\":27,\"label\":\"Email\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":3,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"email\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Email*\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":null,\"productField\":\"\",\"emailConfirmEnabled\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"checkboxLabel\":\"\",\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"25aa1281\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"layoutGridColumnSpan\":6,\"errors\":[],\"pageNumber\":1,\"layoutSpacerGridColumnSpan\":0},{\"is_payment\":false,\"type\":\"phone\",\"id\":42,\"formId\":3,\"label\":\"Phone\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"phoneFormat\":\"standard\",\"autocompleteAttribute\":\"tel\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"phone\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Phone*\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"enableDisplayInColumns\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"25aa1281\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"pageNumber\":1,\"fields\":\"\"},{\"is_payment\":false,\"type\":\"select\",\"id\":43,\"formId\":3,\"label\":\"Are you a patient or prescriber?\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"validateState\":true,\"inputs\":null,\"choices\":[{\"text\":\"Patient\",\"value\":\"Patient\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Prescriber\",\"value\":\"Prescriber\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"select\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Are you a patient or prescriber?*\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"enableEnhancedUI\":false,\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enablePrice\":\"\",\"layoutGroupId\":\"eb4ecaa0\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\"},{\"is_payment\":false,\"type\":\"hidden\",\"id\":11,\"label\":\"Lead Source\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":3,\"description\":\"\",\"allowsPrepopulate\":true,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"lead_source\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"2c162251\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"pageNumber\":1},{\"is_payment\":false,\"type\":\"hidden\",\"id\":12,\"label\":\"Entry URL\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":3,\"description\":\"\",\"allowsPrepopulate\":true,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"entry_url\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"34bb0ca4\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"pageNumber\":1},{\"is_payment\":false,\"type\":\"hidden\",\"id\":13,\"label\":\"Entry Referrer URL\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":3,\"description\":\"\",\"allowsPrepopulate\":true,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"entry_http_referrer\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"4590c5d8\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"pageNumber\":1},{\"is_payment\":false,\"type\":\"hidden\",\"id\":37,\"label\":\"Post URL\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":3,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"{embed_url}\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"7c62a5b7\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"layoutGridColumnSpan\":12,\"pageNumber\":1},{\"is_payment\":false,\"type\":\"hidden\",\"id\":15,\"label\":\"Post Referrer URL\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":3,\"description\":\"\",\"allowsPrepopulate\":true,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"current_http_referrer\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"cb0845db\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"pageNumber\":1},{\"is_payment\":false,\"type\":\"hidden\",\"id\":16,\"label\":\"UTM Source\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":3,\"description\":\"\",\"allowsPrepopulate\":true,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"utm_source\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"ff70118e\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"pageNumber\":1},{\"is_payment\":false,\"type\":\"hidden\",\"id\":17,\"label\":\"UTM Medium\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":3,\"description\":\"\",\"allowsPrepopulate\":true,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"utm_medium\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"a958e410\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"pageNumber\":1},{\"is_payment\":false,\"type\":\"hidden\",\"id\":18,\"label\":\"UTM Campaign\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":3,\"description\":\"\",\"allowsPrepopulate\":true,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"utm_campaign\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"f3611456\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"pageNumber\":1},{\"is_payment\":false,\"type\":\"hidden\",\"id\":19,\"label\":\"UTM Term\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":3,\"description\":\"\",\"allowsPrepopulate\":true,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"utm_term\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"fac82c89\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"pageNumber\":1},{\"is_payment\":false,\"type\":\"hidden\",\"id\":20,\"label\":\"UTM Content\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":3,\"description\":\"\",\"allowsPrepopulate\":true,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"utm_content\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"b7f4d2b9\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"pageNumber\":1},{\"is_payment\":false,\"type\":\"hidden\",\"id\":38,\"label\":\"GCLID\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":3,\"description\":\"\",\"allowsPrepopulate\":true,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"gclid\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"7288596e\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"layoutGridColumnSpan\":12,\"pageNumber\":1},{\"is_payment\":false,\"type\":\"hidden\",\"id\":39,\"label\":\"FBCLID\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":3,\"description\":\"\",\"allowsPrepopulate\":true,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"fbclid\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"5bd5f6f0\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"layoutGridColumnSpan\":12,\"pageNumber\":1},{\"is_payment\":false,\"type\":\"hidden\",\"id\":21,\"label\":\"User IP\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":3,\"description\":\"\",\"allowsPrepopulate\":true,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"hidden\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"user_ip\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"layoutGroupId\":\"e532f9ae\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"enableChoiceValue\":\"\",\"errors\":[],\"pageNumber\":1,\"layoutGridColumnSpan\":6}],\"version\":\"2.9.24\",\"id\":3,\"nextFieldId\":44,\"useCurrentUserAsAuthor\":true,\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"is_active\":\"1\",\"date_created\":\"2020-06-30 07:48:35\",\"is_trash\":\"0\",\"subLabelPlacement\":\"below\",\"requiredIndicator\":\"asterisk\",\"customRequiredIndicator\":\"(Required)\",\"cssClass\":\"\",\"buttonType\":\"text\",\"buttonText\":\"Submit\",\"buttonImageURL\":\"\",\"form_button_conditional_logic_object\":\"\",\"form_button_conditional_logic\":\"0\",\"saveButtonText\":\"Save and Continue Later\",\"limitEntries\":false,\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":false,\"scheduleStart\":\"\",\"scheduleEnd\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":false,\"requireLoginMessage\":\"\",\"enableGFZeroSpam\":\"1\",\"validationSummary\":false,\"saveEnabled\":\"\",\"enableHoneypot\":false,\"enableAnimation\":false,\"markupVersion\":2,\"save\":{\"enabled\":false,\"button\":{\"type\":\"link\",\"text\":\"Save and Continue Later\"}},\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\",\"validationPlacement\":\"below\",\"honeypotAction\":\"spam\",\"deprecated\":\"\",\"submitSpeedCheckThreshold\":2000,\"submitSpeedCheckMode\":\"normal\",\"enableSubmitSpeedCheck\":false}", NULL, "{\"5efaee5398b5f\":{\"id\":\"5efaee5398b5f\",\"name\":\"Default Confirmation\",\"isDefault\":true,\"type\":\"page\",\"message\":\"Thank You!\",\"url\":\"\",\"pageId\":\"743\",\"queryString\":\"\",\"disableAutoformat\":false,\"conditionalLogic\":[],\"event\":\"\",\"page\":\"743\"}}", "{\"5efaee5398943\":{\"isActive\":true,\"name\":\"Admin Notification\",\"service\":\"wordpress\",\"event\":\"form_submission\",\"to\":\"info@roxus.com\",\"toType\":\"email\",\"cc\":\"\",\"bcc\":\"apedersen@levohealth.com\",\"subject\":\"New Contact Form Submission\",\"message\":\"{all_fields}\",\"from\":\"info@roxus.com\",\"fromName\":\"Roxus Website\",\"replyTo\":\"info@roxus.com\",\"routing\":null,\"conditionalLogic\":null,\"disableAutoformat\":true,\"enableAttachments\":false,\"id\":\"5efaee5398943\",\"toEmail\":\"info@roxus.com\",\"toField\":\"\",\"notification_conditional_logic_object\":\"\",\"notification_conditional_logic\":\"0\"}}");

/* INSERT TABLE DATA: wp_gf_form_view */
INSERT INTO `wp_gf_form_view` VALUES("1", "2", "2025-12-09 17:52:58", "", "10");
INSERT INTO `wp_gf_form_view` VALUES("2", "2", "2025-12-10 18:41:40", "", "28");
INSERT INTO `wp_gf_form_view` VALUES("3", "3", "2025-12-11 16:16:08", "", "16");
INSERT INTO `wp_gf_form_view` VALUES("4", "2", "2025-12-11 20:58:40", "", "14");

/* INSERT TABLE DATA: wp_gf_rest_api_keys */
INSERT INTO `wp_gf_rest_api_keys` VALUES("1", "1", "zapier", "read_write", "99adceb3d2933bf2d48abd57cde9d3e6c28c09c1235c66e57a499537e3ba8f1d", "cs_bdb61c090cbdc227131f4547ae87fee96d7c9458", NULL, "e5001c7", "2021-08-10 10:48:29");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://roxus.levoengage.com", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://roxus.levoengage.com", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "Roxus", "on");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "Fast Acting Nasal Spray for Erectile Dysfunction", "on");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "info@levohealth.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:18:{i:0;s:47:\"better-search-replace/better-search-replace.php\";i:1;s:33:\"classic-editor/classic-editor.php\";i:2;s:35:\"classic-widgets/classic-widgets.php\";i:3;s:37:\"disable-comments/disable-comments.php\";i:4;s:25:\"duplicator/duplicator.php\";i:5;s:29:\"gravityforms/gravityforms.php\";i:6;s:29:\"gravityformszapier/zapier.php\";i:7;s:50:\"gravity-forms-zero-spam/gravityforms-zero-spam.php\";i:8;s:41:\"levo-tracking-data/levo-tracking-data.php\";i:9;s:37:\"post-types-order/post-types-order.php\";i:10;s:45:\"post-types-unlimited/post-types-unlimited.php\";i:11;s:27:\"redirection/redirection.php\";i:12;s:21:\"safe-svg/safe-svg.php\";i:13;s:29:\"theme-editor/theme_editor.php\";i:14;s:29:\"wp-mail-smtp/wp_mail_smtp.php\";i:15;s:33:\"duplicate-post/duplicate-post.php\";i:16;s:24:\"wordpress-seo/wp-seo.php\";i:17;s:25:\"duplicator/duplicator.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:5:{i:0;s:79:\"/home/levoen5/staging/roxus.levoengage.com/wp-content/themes/Levo/functions.php\";i:2;s:75:\"/home/levoen5/staging/roxus.levoengage.com/wp-content/themes/Levo/style.css\";i:3;s:87:\"/home/levoen5/staging/roxus.levoengage.com/wp-content/themes/levo-theme-child/style.css\";i:4;s:87:\"/home/levosites/staging/biosense.levosites.com/wp-content/themes/twentytwenty/style.css\";i:5;s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "bricks", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "bricks-child", "yes");
INSERT INTO `wp_options` VALUES("44", "comment_registration", "1", "yes");
INSERT INTO `wp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("48", "db_version", "58975", "yes");
INSERT INTO `wp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("51", "blog_public", "0", "yes");
INSERT INTO `wp_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("73", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_text", "a:3:{i:2;a:4:{s:5:\"title\";s:15:\"About This Site\";s:4:\"text\";s:85:\"This may be a good place to introduce yourself and your site or include some credits.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:3;a:4:{s:5:\"title\";s:7:\"Find Us\";s:4:\"text\";s:168:\"<strong>Address</strong>\n123 Main Street\nNew York, NY 10001\n\n<strong>Hours</strong>\nMonday&mdash;Friday: 9:00AM&ndash;5:00PM\nSaturday &amp; Sunday: 11:00AM&ndash;3:00PM\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("81", "uninstall_plugins", "a:3:{s:33:\"classic-editor/classic-editor.php\";a:2:{i:0;s:14:\"Classic_Editor\";i:1;s:9:\"uninstall\";}s:27:\"redirection/redirection.php\";a:2:{i:0;s:17:\"Redirection_Admin\";i:1;s:16:\"plugin_uninstall\";}s:27:\"wp-optimize/wp-optimize.php\";s:21:\"wpo_uninstall_actions\";}", "no");
INSERT INTO `wp_options` VALUES("82", "timezone_string", "America/New_York", "yes");
INSERT INTO `wp_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "page_on_front", "85", "yes");
INSERT INTO `wp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("88", "site_icon", "804", "on");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("92", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("93", "admin_email_lifespan", "1765514574", "yes");
INSERT INTO `wp_options` VALUES("94", "initial_db_version", "45805", "yes");
INSERT INTO `wp_options` VALUES("95", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:90:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:20:\"wpseo_manage_options\";b:1;s:10:\"copy_posts\";b:1;s:31:\"vc_access_rules_post_types/post\";b:1;s:31:\"vc_access_rules_post_types/page\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:31:\"vc_access_rules_unfiltered_html\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:24:\"vc_access_rules_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:20:\"duplicator_pro_basic\";b:1;s:21:\"duplicator_pro_create\";b:1;s:23:\"duplicator_pro_schedule\";b:1;s:22:\"duplicator_pro_storage\";b:1;s:29:\"duplicator_pro_backup_restore\";b:1;s:21:\"duplicator_pro_import\";b:1;s:21:\"duplicator_pro_export\";b:1;s:23:\"duplicator_pro_settings\";b:1;s:22:\"duplicator_pro_license\";b:1;s:17:\"bricks_upload_svg\";b:1;s:29:\"bricks_form_submission_access\";b:1;s:19:\"bricks_execute_code\";b:1;s:18:\"bricks_full_access\";b:1;s:25:\"bricks_bypass_maintenance\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:51:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:10:\"copy_posts\";b:1;s:31:\"vc_access_rules_post_types/post\";b:1;s:31:\"vc_access_rules_post_types/page\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:31:\"vc_access_rules_unfiltered_html\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:17:\"bricks_upload_svg\";b:1;s:19:\"bricks_execute_code\";b:1;s:19:\"bricks_edit_content\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:23:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:31:\"vc_access_rules_post_types/post\";b:1;s:31:\"vc_access_rules_post_types/page\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:31:\"vc_access_rules_unfiltered_html\";b:0;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:19:\"bricks_edit_content\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:18:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:31:\"vc_access_rules_post_types/post\";b:1;s:31:\"vc_access_rules_post_types/page\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:30:\"vc_access_rules_backend_editor\";b:0;s:31:\"vc_access_rules_frontend_editor\";b:0;s:31:\"vc_access_rules_unfiltered_html\";b:0;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:0;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:19:\"bricks_edit_content\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:48:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:0;s:31:\"vc_access_rules_frontend_editor\";b:0;s:31:\"vc_access_rules_unfiltered_html\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:0;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:46:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:0;s:31:\"vc_access_rules_frontend_editor\";b:0;s:31:\"vc_access_rules_unfiltered_html\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:0;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("96", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("97", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "sidebars_widgets", "a:3:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";}s:7:\"sidebar\";a:5:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:10:\"archives-2\";i:3;s:12:\"categories-2\";i:4;s:6:\"meta-2\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("96988", "bricks_global_settings", "a:11:{s:9:\"postTypes\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:12:\"smoothScroll\";b:1;s:20:\"wp_auth_url_behavior\";s:7:\"default\";s:15:\"remoteTemplates\";a:0:{}s:11:\"builderMode\";s:4:\"dark\";s:13:\"builderLocale\";s:12:\"site-default\";s:22:\"builderToolbarLogoLink\";s:7:\"current\";s:33:\"builderResponsiveControlIndicator\";s:3:\"any\";s:24:\"builderFontFamilyControl\";s:9:\"favorites\";s:26:\"builderGlobalClassesImport\";s:9:\"conflicts\";s:18:\"executeCodeEnabled\";b:1;}", "auto");
INSERT INTO `wp_options` VALUES("97049", "duplicator_pro_ui_view_state", "a:3:{s:22:\"dup-pack-archive-panel\";s:1:\"0\";s:22:\"dup-pack-storage-panel\";s:1:\"0\";s:25:\"dpro-pack-installer-panel\";s:1:\"1\";}", "auto");
INSERT INTO `wp_options` VALUES("97055", "duplicator_pro_package_active", "{\n    \"ID\": null,\n    \"VersionWP\": \"6.7.1\",\n    \"VersionDB\": \"10.2.44\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20250113_brickslevotheme\",\n    \"Hash\": \"1ed06004268ec9b19798_20250113193438\",\n    \"NameHash\": \"20250113_brickslevotheme_1ed06004268ec9b19798_20250113193438\",\n    \"Type\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"http:\\/\\/roxus.levoengage.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250113_brickslevotheme_1ed06004268ec9b19798_20250113193438_scan.json\",\n    \"timer_start\": -1,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/.opcache\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/.tmb\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/bps-backup\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/cache\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/old-cache\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/updraft\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/wfcache\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/.htaccess\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/.user.ini\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/php.ini\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/web.config\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-config.php\",\n            \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": null,\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\",\n        \"Size\": 219038220,\n        \"Dirs\": [],\n        \"DirCount\": 2224,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 11551,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"qm\\/gC8PZ1veJAOVCdQfNKgJDvRCLRS4f8GroTF8rr7md9jUrAB0pLjgcrLYDIpo+SFX1JdgpQ21wfy6KbyFqbw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"latin1\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"MyISAM\",\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"n4f5a65_test-environment\",\n            \"tablesBaseCount\": 49,\n            \"tablesFinalCount\": 49,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 644,\n            \"tablesSizeOnDisk\": 3808368,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 0,\n                    \"size\": 19424\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 3086\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 9284\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 0,\n                    \"size\": 5016\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 52872\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 0,\n                    \"size\": 49072\n                },\n                \"wp_gf_addon_feed\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_gf_draft_submissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_gf_entry\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_gf_entry_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_gf_entry_notes\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_gf_form\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 2120\n                },\n                \"wp_gf_form_meta\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 99300\n                },\n                \"wp_gf_form_revisions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_gf_form_view\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_gf_rest_api_keys\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 6308\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"384\",\n                    \"insertedRows\": 0,\n                    \"size\": 3290952\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 10408\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 13796\n                },\n                \"wp_redirection_404\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 14272\n                },\n                \"wp_redirection_groups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 4164\n                },\n                \"wp_redirection_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_redirection_logs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_css\": {\n                    \"inaccurateRows\": \"109\",\n                    \"insertedRows\": 0,\n                    \"size\": 95152\n                },\n                \"wp_revslider_layer_animations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_navigations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_sliders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_slides\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_revslider_static_slides\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_rg_zapier\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 13352\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 4128\n                },\n                \"wp_tm_taskmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"wp_tm_tasks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"43\",\n                    \"insertedRows\": 0,\n                    \"size\": 14256\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 8284\n                },\n                \"wp_wpmailsmtp_debug_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpmailsmtp_tasks_meta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 2116\n                },\n                \"wp_yoast_indexable\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 14188\n                },\n                \"wp_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 5204\n                },\n                \"wp_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 0,\n                    \"size\": 9792\n                },\n                \"wp_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"wp_yoast_seo_links\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 4172\n                },\n                \"wp_yoast_seo_meta\": {\n                    \"inaccurateRows\": \"18\",\n                    \"insertedRows\": 0,\n                    \"size\": 2354\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.2.44\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHP\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 5,\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 13,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": 5,\n    \"version\": \"4.5.14.2\",\n    \"created\": \"2025-01-13 19:34:39\",\n    \"updated\": \"2025-01-13 19:34:39\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}", "auto");
INSERT INTO `wp_options` VALUES("97114", "duplicator_activate_plugins_after_installation", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("97324", "duplicator_migration_data", "{\n    \"plugin\": \"dup-lite\",\n    \"installerVersion\": \"1.5.13.1\",\n    \"installType\": -1,\n    \"logicModes\": [\n        \"CLASSIC\"\n    ],\n    \"template\": \"base\",\n    \"restoreBackupMode\": false,\n    \"recoveryMode\": false,\n    \"archivePath\": \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/20250113_brickslevotheme_e9191a8a33915c013905_20250828155849_archive.zip\",\n    \"packageHash\": \"e9191a8-28155849\",\n    \"installerPath\": \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/installer.php\",\n    \"installerBootLog\": \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/dup-installer-bootlog__4e55f3c-28155849.txt\",\n    \"installerLog\": \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/dup-installer\\/dup-installer-log__4e55f3c-28155849.txt\",\n    \"dupInstallerPath\": \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/dup-installer\",\n    \"origFileFolderPath\": \"\\/home\\/levoen5\\/staging\\/roxus.levoengage.com\\/dup-installer\\/original_files_e9191a8-28155849\",\n    \"safeMode\": 0,\n    \"cleanInstallerFiles\": true,\n    \"licenseType\": 0,\n    \"phpVersion\": \"8.1.33\",\n    \"archiveType\": \"zip\",\n    \"siteSize\": 78870172,\n    \"siteNumFiles\": 13205,\n    \"siteDbSize\": 2901745,\n    \"siteDBNumTables\": 50,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"ustatIdentifier\": \"\",\n    \"time\": 1764945174\n}", "no");
INSERT INTO `wp_options` VALUES("103", "cron", "a:17:{i:1765488136;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1765490051;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1765518001;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765520484;a:1:{s:22:\"redirection_log_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765526507;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765528846;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765540294;a:1:{s:17:\"gravityforms_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765540539;a:1:{s:19:\"wpseo-reindex-links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765541048;a:3:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:20:\"wpseo_home_url_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765550094;a:1:{s:29:\"wpseo_detect_default_seo_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765569707;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765654910;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765825200;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765901071;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765905901;a:1:{s:41:\"enable_jquery_migrate_helper_notification\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765997806;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("96905", "gf_last_telemetry_run", "1764945200", "auto");
INSERT INTO `wp_options` VALUES("96906", "gf_telemetry_data", "a:2:{s:8:\"snapshot\";O:64:\"Gravity_Forms\\Gravity_Forms\\Telemetry\\GF_Telemetry_Snapshot_Data\":3:{s:4:\"data\";a:31:{s:3:\"key\";s:32:\"d1603069b4306883753292b1197af0d1\";s:10:\"wp_version\";s:5:\"6.7.3\";s:11:\"php_version\";s:6:\"8.1.33\";s:13:\"mysql_version\";s:7:\"10.6.24\";s:7:\"plugins\";a:20:{i:0;a:4:{s:4:\"name\";s:21:\"Better Search Replace\";s:4:\"slug\";s:21:\"better-search-replace\";s:7:\"version\";s:6:\"1.4.10\";s:9:\"is_active\";b:1;}i:1;a:4:{s:4:\"name\";s:14:\"Classic Editor\";s:4:\"slug\";s:14:\"classic-editor\";s:7:\"version\";s:5:\"1.6.7\";s:9:\"is_active\";b:1;}i:2;a:4:{s:4:\"name\";s:15:\"Classic Widgets\";s:4:\"slug\";s:15:\"classic-widgets\";s:7:\"version\";s:3:\"0.3\";s:9:\"is_active\";b:1;}i:3;a:4:{s:4:\"name\";s:16:\"Disable Comments\";s:4:\"slug\";s:16:\"disable-comments\";s:7:\"version\";s:5:\"2.5.2\";s:9:\"is_active\";b:1;}i:4;a:4:{s:4:\"name\";s:10:\"Duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:7:\"version\";s:8:\"1.5.13.1\";s:9:\"is_active\";b:1;}i:5;a:4:{s:4:\"name\";s:13:\"Gravity Forms\";s:4:\"slug\";s:12:\"gravityforms\";s:7:\"version\";s:8:\"2.9.23.2\";s:9:\"is_active\";b:1;}i:6;a:4:{s:4:\"name\";s:27:\"Gravity Forms Zapier Add-On\";s:4:\"slug\";s:18:\"gravityformszapier\";s:7:\"version\";s:5:\"4.5.1\";s:9:\"is_active\";b:1;}i:7;a:4:{s:4:\"name\";s:23:\"Gravity Forms Zero Spam\";s:4:\"slug\";s:23:\"gravity-forms-zero-spam\";s:7:\"version\";s:5:\"1.4.6\";s:9:\"is_active\";b:1;}i:8;a:4:{s:4:\"name\";s:36:\"LEVO Tracking Data for Gravity Forms\";s:4:\"slug\";s:18:\"levo-tracking-data\";s:7:\"version\";s:5:\"1.4.1\";s:9:\"is_active\";b:1;}i:9;a:4:{s:4:\"name\";s:16:\"Post Types Order\";s:4:\"slug\";s:16:\"post-types-order\";s:7:\"version\";s:5:\"2.4.1\";s:9:\"is_active\";b:1;}i:10;a:4:{s:4:\"name\";s:20:\"Post Types Unlimited\";s:4:\"slug\";s:20:\"post-types-unlimited\";s:7:\"version\";s:5:\"1.2.8\";s:9:\"is_active\";b:1;}i:11;a:4:{s:4:\"name\";s:11:\"Redirection\";s:4:\"slug\";s:11:\"redirection\";s:7:\"version\";s:5:\"5.5.2\";s:9:\"is_active\";b:1;}i:12;a:4:{s:4:\"name\";s:8:\"Safe SVG\";s:4:\"slug\";s:8:\"safe-svg\";s:7:\"version\";s:5:\"2.4.0\";s:9:\"is_active\";b:1;}i:13;a:4:{s:4:\"name\";s:12:\"Theme Editor\";s:4:\"slug\";s:12:\"theme-editor\";s:7:\"version\";s:3:\"3.1\";s:9:\"is_active\";b:1;}i:14;a:4:{s:4:\"name\";s:18:\"Wordfence Security\";s:4:\"slug\";s:9:\"wordfence\";s:7:\"version\";s:5:\"8.1.3\";s:9:\"is_active\";b:0;}i:15;a:4:{s:4:\"name\";s:36:\"WP-Optimize - Clean, Compress, Cache\";s:4:\"slug\";s:11:\"wp-optimize\";s:7:\"version\";s:5:\"4.3.1\";s:9:\"is_active\";b:0;}i:16;a:4:{s:4:\"name\";s:12:\"WP Mail SMTP\";s:4:\"slug\";s:12:\"wp-mail-smtp\";s:7:\"version\";s:5:\"4.7.1\";s:9:\"is_active\";b:1;}i:17;a:4:{s:4:\"name\";s:14:\"WPS Hide Login\";s:4:\"slug\";s:14:\"wps-hide-login\";s:7:\"version\";s:8:\"1.9.17.2\";s:9:\"is_active\";b:0;}i:18;a:4:{s:4:\"name\";s:20:\"Yoast Duplicate Post\";s:4:\"slug\";s:14:\"duplicate-post\";s:7:\"version\";s:3:\"4.5\";s:9:\"is_active\";b:1;}i:19;a:4:{s:4:\"name\";s:9:\"Yoast SEO\";s:4:\"slug\";s:13:\"wordpress-seo\";s:7:\"version\";s:4:\"26.5\";s:9:\"is_active\";b:1;}}s:10:\"theme_name\";s:18:\"Bricks Child Theme\";s:9:\"theme_uri\";s:25:\"https://bricksbuilder.io/\";s:13:\"theme_version\";s:3:\"1.1\";s:12:\"theme_author\";s:6:\"Bricks\";s:16:\"theme_author_uri\";s:25:\"https://bricksbuilder.io/\";s:12:\"is_multisite\";b:0;s:11:\"total_forms\";i:1;s:13:\"total_entries\";s:1:\"0\";s:11:\"emails_sent\";i:0;s:9:\"api_calls\";i:0;s:16:\"entry_meta_count\";i:0;s:19:\"entry_details_count\";i:0;s:17:\"entry_notes_count\";i:0;s:4:\"lang\";s:5:\"en_US\";s:2:\"db\";s:7:\"MariaDB\";s:10:\"autoUpdate\";i:1;s:8:\"currency\";s:3:\"USD\";s:14:\"dataCollection\";i:0;s:5:\"email\";b:0;s:9:\"formTypes\";s:0:\"\";s:14:\"formTypesOther\";b:0;s:11:\"hideLicense\";i:0;s:12:\"organization\";b:0;s:17:\"organizationOther\";b:0;s:8:\"services\";s:0:\"\";s:13:\"servicesOther\";b:0;}s:3:\"key\";s:8:\"snapshot\";s:15:\"data_collection\";b:0;}s:6:\"events\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("104", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "theme_mods_twentytwenty", "a:3:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1581441913;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}s:18:\"nav_menu_locations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("115", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("158", "current_theme", "Bricks Child Theme", "yes");
INSERT INTO `wp_options` VALUES("159", "theme_mods_LevoTheme-child", "a:7:{i:0;b:0;s:24:\"recommend_plugins_enable\";b:1;s:13:\"page_composer\";s:7:\"content\";s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:15:\"top_bar_content\";s:275:\"<span class=\"wpex-inline\">[font_awesome icon=\"phone\"] (855) 234-0232</span>\n\n<span class=\"wpex-inline\">[font_awesome icon=\"envelope\"] info@levohealth.com</span>\n\n<span class=\"wpex-inline\">[font_awesome icon=\"user\"] [wp_login_url text=\"User Login\" logout_text=\"Logout\"]</span>\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1583480825;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";}s:7:\"sidebar\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:13:\"pages_sidebar\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:14:\"search_sidebar\";a:0:{}s:20:\"testimonials_sidebar\";a:0:{}s:10:\"footer_one\";a:0:{}s:10:\"footer_two\";a:0:{}s:12:\"footer_three\";a:0:{}s:11:\"footer_four\";a:0:{}}}}", "off");
INSERT INTO `wp_options` VALUES("160", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("161", "total_initial_version", "4.9.3", "no");
INSERT INTO `wp_options` VALUES("162", "wpex_total_customizer_backup", "a:1:{i:0;b:0;}", "no");
INSERT INTO `wp_options` VALUES("163", "total_version", "4.9.3", "no");
INSERT INTO `wp_options` VALUES("166", "widget_wpex_about", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("167", "widget_wpex_mailchimp", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("168", "widget_wpex_newsletter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("169", "widget_wpex_info_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("170", "widget_wpex_fontawesome_social_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("171", "widget_wpex_social_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("172", "widget_wpex_simple_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("173", "widget_wpex_modern_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("174", "widget_wpex_facebook_page_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("175", "widget_wpex_gmap_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("176", "widget_wpex_flickr", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("177", "widget_wpex_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("178", "widget_wpex_recent_posts_thumb", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("179", "widget_wpex_recent_posts_thumb_grid", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("180", "widget_wpex_recent_posts_icons", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("181", "widget_wpex_insagram_slider", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("182", "widget_wpex_users_grid", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("183", "widget_wpex_recent_comments_avatars_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("185", "gf_db_version", "2.9.24", "off");
INSERT INTO `wp_options` VALUES("186", "rg_form_version", "2.9.24", "no");
INSERT INTO `wp_options` VALUES("187", "gform_enable_background_updates", "1", "yes");
INSERT INTO `wp_options` VALUES("188", "gform_pending_installation", "", "yes");
INSERT INTO `wp_options` VALUES("189", "revslider_servers", "a:7:{i:0;s:22:\"themepunch-ext-b.tools\";i:1;s:16:\"themepunch.tools\";i:2;s:22:\"themepunch-ext-a.tools\";i:3;s:22:\"themepunch-ext-a.tools\";i:4;s:22:\"themepunch-ext-a.tools\";i:5;s:22:\"themepunch-ext-b.tools\";i:6;s:22:\"themepunch-ext-b.tools\";}", "yes");
INSERT INTO `wp_options` VALUES("190", "revslider_server_refresh", "1650513585", "yes");
INSERT INTO `wp_options` VALUES("191", "revslider-update-check-short", "1651003144", "yes");
INSERT INTO `wp_options` VALUES("192", "revslider-templates-check", "1651003145", "yes");
INSERT INTO `wp_options` VALUES("196", "widget_gform_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("197", "gravityformsaddon_gravityformswebapi_version", "1.0", "yes");
INSERT INTO `wp_options` VALUES("200", "revslider-library-check", "1650583356", "yes");
INSERT INTO `wp_options` VALUES("201", "rs-library", "a:3:{s:4:\"hash\";s:32:\"dae3de1eb57eeeee008b70e9a23844b5\";s:7:\"objects\";a:417:{i:0;a:12:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:1;a:12:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:2;a:12:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:3;a:12:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:4;a:12:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:5;a:12:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:6;a:12:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:7;a:12:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:8;a:12:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:9;a:12:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:10;a:12:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:11;a:12:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:12;a:12:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:13;a:12:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:14;a:12:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:15;a:12:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:16;a:12:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:17;a:12:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:18;a:12:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:19;a:12:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:20;a:12:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:21;a:12:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:22;a:12:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:23;a:12:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:24;a:12:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:25;a:12:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:26;a:12:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:27;a:12:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:28;a:12:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:29;a:12:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:30;a:12:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:31;a:12:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:32;a:12:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:33;a:12:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:34;a:12:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:35;a:12:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:36;a:12:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:37;a:12:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:38;a:12:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:39;a:12:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:40;a:12:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:41;a:12:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:42;a:12:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:43;a:12:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:44;a:12:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:45;a:12:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:46;a:12:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:47;a:12:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:48;a:12:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:49;a:12:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:50;a:12:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:51;a:12:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:52;a:12:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:53;a:12:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:54;a:12:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:55;a:12:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:56;a:12:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:57;a:12:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:58;a:12:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:59;a:12:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:60;a:12:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:61;a:12:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:62;a:12:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:63;a:12:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:64;a:12:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:65;a:12:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:66;a:12:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:67;a:12:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:68;a:12:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:69;a:12:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:70;a:12:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:71;a:12:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:72;a:12:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:73;a:12:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:74;a:12:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:75;a:12:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:76;a:12:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:77;a:12:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:78;a:12:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:79;a:12:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:80;a:12:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:81;a:12:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:82;a:12:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:83;a:12:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:84;a:12:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:85;a:12:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:86;a:12:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:87;a:12:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:88;a:12:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:89;a:12:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:90;a:12:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:91;a:12:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:92;a:12:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:93;a:12:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:94;a:12:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:95;a:12:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:96;a:12:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:97;a:12:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:98;a:12:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:99;a:12:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:100;a:12:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:101;a:12:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:102;a:12:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:103;a:12:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:104;a:12:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:105;a:12:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:106;a:12:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:107;a:12:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:108;a:12:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:109;a:12:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:110;a:12:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:111;a:12:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:112;a:12:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:113;a:12:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:114;a:12:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:115;a:12:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:116;a:12:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:117;a:12:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:118;a:12:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:119;a:12:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:120;a:12:{s:2:\"id\";s:3:\"479\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:121;a:12:{s:2:\"id\";s:3:\"478\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:122;a:12:{s:2:\"id\";s:3:\"477\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:123;a:12:{s:2:\"id\";s:3:\"476\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:124;a:12:{s:2:\"id\";s:3:\"475\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:125;a:12:{s:2:\"id\";s:3:\"474\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:126;a:12:{s:2:\"id\";s:3:\"473\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:127;a:12:{s:2:\"id\";s:3:\"472\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:128;a:12:{s:2:\"id\";s:3:\"471\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:129;a:12:{s:2:\"id\";s:3:\"470\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:130;a:12:{s:2:\"id\";s:3:\"469\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:131;a:12:{s:2:\"id\";s:3:\"468\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:132;a:12:{s:2:\"id\";s:3:\"467\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:133;a:12:{s:2:\"id\";s:3:\"466\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:134;a:12:{s:2:\"id\";s:3:\"465\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:135;a:12:{s:2:\"id\";s:3:\"464\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:136;a:12:{s:2:\"id\";s:3:\"463\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:137;a:12:{s:2:\"id\";s:3:\"462\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:138;a:12:{s:2:\"id\";s:3:\"461\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:139;a:12:{s:2:\"id\";s:3:\"460\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:140;a:12:{s:2:\"id\";s:3:\"459\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:141;a:12:{s:2:\"id\";s:3:\"458\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:142;a:12:{s:2:\"id\";s:3:\"457\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:143;a:12:{s:2:\"id\";s:3:\"456\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:144;a:12:{s:2:\"id\";s:3:\"455\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:145;a:12:{s:2:\"id\";s:3:\"454\";s:6:\"handle\";s:11:\"Balance.jpg\";s:4:\"name\";s:7:\"Balance\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:146;a:12:{s:2:\"id\";s:3:\"453\";s:6:\"handle\";s:19:\"Pool-meditation.jpg\";s:4:\"name\";s:15:\"Pool meditation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:147;a:12:{s:2:\"id\";s:3:\"452\";s:6:\"handle\";s:18:\"Soccer-stadium.jpg\";s:4:\"name\";s:14:\"Soccer stadium\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:148;a:12:{s:2:\"id\";s:3:\"451\";s:6:\"handle\";s:25:\"Soccer-field-top-view.jpg\";s:4:\"name\";s:21:\"Soccer field top view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:149;a:12:{s:2:\"id\";s:3:\"450\";s:6:\"handle\";s:14:\"Basketball.jpg\";s:4:\"name\";s:10:\"Basketball\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:150;a:12:{s:2:\"id\";s:3:\"449\";s:6:\"handle\";s:14:\"in-the-fog.jpg\";s:4:\"name\";s:10:\"in the fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:151;a:12:{s:2:\"id\";s:3:\"448\";s:6:\"handle\";s:13:\"Handstand.jpg\";s:4:\"name\";s:9:\"Handstand\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:152;a:12:{s:2:\"id\";s:3:\"447\";s:6:\"handle\";s:11:\"Friends.jpg\";s:4:\"name\";s:7:\"Friends\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:153;a:12:{s:2:\"id\";s:3:\"446\";s:6:\"handle\";s:28:\"Sneakers-on-the-railroad.jpg\";s:4:\"name\";s:24:\"Sneakers on the railroad\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:154;a:12:{s:2:\"id\";s:3:\"445\";s:6:\"handle\";s:23:\"Family-on-the-ocean.jpg\";s:4:\"name\";s:19:\"Family on the ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:155;a:12:{s:2:\"id\";s:3:\"444\";s:6:\"handle\";s:10:\"Sunset.jpg\";s:4:\"name\";s:6:\"Sunset\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:156;a:12:{s:2:\"id\";s:3:\"443\";s:6:\"handle\";s:9:\"Books.jpg\";s:4:\"name\";s:5:\"Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:157;a:12:{s:2:\"id\";s:3:\"442\";s:6:\"handle\";s:25:\"Looking-at-the-window.jpg\";s:4:\"name\";s:21:\"Looking at the window\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:158;a:12:{s:2:\"id\";s:3:\"441\";s:6:\"handle\";s:48:\"woman-standing-near-buildings-during-daytime.jpg\";s:4:\"name\";s:44:\"woman standing near buildings during daytime\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:159;a:12:{s:2:\"id\";s:3:\"440\";s:6:\"handle\";s:12:\"Lollipop.jpg\";s:4:\"name\";s:8:\"Lollipop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1395\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:160;a:12:{s:2:\"id\";s:3:\"439\";s:6:\"handle\";s:26:\"People-crossing-street.jpg\";s:4:\"name\";s:22:\"People crossing street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:161;a:12:{s:2:\"id\";s:3:\"438\";s:6:\"handle\";s:24:\"Friends-on-the-shore.jpg\";s:4:\"name\";s:20:\"Friends on the shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:162;a:12:{s:2:\"id\";s:3:\"437\";s:6:\"handle\";s:13:\"Coworkers.jpg\";s:4:\"name\";s:9:\"Coworkers\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:163;a:12:{s:2:\"id\";s:3:\"436\";s:6:\"handle\";s:27:\"Hiking-in-the-Dolomites.jpg\";s:4:\"name\";s:23:\"Hiking in the Dolomites\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:164;a:12:{s:2:\"id\";s:3:\"435\";s:6:\"handle\";s:18:\"Successful-man.jpg\";s:4:\"name\";s:14:\"Successful man\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:165;a:12:{s:2:\"id\";s:3:\"434\";s:6:\"handle\";s:23:\"Beautiful-sunny-day.jpg\";s:4:\"name\";s:19:\"Beautiful sunny day\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:166;a:12:{s:2:\"id\";s:3:\"433\";s:6:\"handle\";s:8:\"Guys.jpg\";s:4:\"name\";s:4:\"Guys\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:167;a:12:{s:2:\"id\";s:3:\"432\";s:6:\"handle\";s:19:\"Confetti-Shower.jpg\";s:4:\"name\";s:15:\"Confetti Shower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:168;a:12:{s:2:\"id\";s:3:\"431\";s:6:\"handle\";s:24:\"Sun-was-setting-down.jpg\";s:4:\"name\";s:20:\"Sun was setting down\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:169;a:12:{s:2:\"id\";s:3:\"430\";s:6:\"handle\";s:9:\"Jumps.jpg\";s:4:\"name\";s:5:\"Jumps\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:170;a:12:{s:2:\"id\";s:3:\"429\";s:6:\"handle\";s:23:\"Friends-by-the-fire.jpg\";s:4:\"name\";s:19:\"Friends by the fire\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:171;a:12:{s:2:\"id\";s:3:\"428\";s:6:\"handle\";s:21:\"Under-the-blanket.jpg\";s:4:\"name\";s:17:\"Under the blanket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1413\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:172;a:12:{s:2:\"id\";s:3:\"427\";s:6:\"handle\";s:18:\"Pretty-in-Pink.jpg\";s:4:\"name\";s:14:\"Pretty in Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1394\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:173;a:12:{s:2:\"id\";s:3:\"426\";s:6:\"handle\";s:31:\"Discussions-at-a-long-table.jpg\";s:4:\"name\";s:27:\"Discussions at a long table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1268\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:174;a:12:{s:2:\"id\";s:3:\"425\";s:6:\"handle\";s:18:\"Lost-in-Lemons.jpg\";s:4:\"name\";s:14:\"Lost in Lemons\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:175;a:12:{s:2:\"id\";s:3:\"424\";s:6:\"handle\";s:13:\"Team-work.jpg\";s:4:\"name\";s:9:\"Team work\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:176;a:12:{s:2:\"id\";s:3:\"423\";s:6:\"handle\";s:20:\"Romantic-evening.jpg\";s:4:\"name\";s:16:\"Romantic evening\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1263\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:177;a:12:{s:2:\"id\";s:3:\"422\";s:6:\"handle\";s:19:\"Crew-collective.jpg\";s:4:\"name\";s:15:\"Crew collective\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:178;a:12:{s:2:\"id\";s:3:\"421\";s:6:\"handle\";s:8:\"Code.jpg\";s:4:\"name\";s:4:\"Code\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:179;a:12:{s:2:\"id\";s:3:\"420\";s:6:\"handle\";s:48:\"Yellow-ceramic-mug-beside-gray-aluminum-iMac.jpg\";s:4:\"name\";s:44:\"Yellow ceramic mug beside gray aluminum iMac\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:180;a:12:{s:2:\"id\";s:3:\"419\";s:6:\"handle\";s:11:\"My-desk.jpg\";s:4:\"name\";s:7:\"My desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1315\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:181;a:12:{s:2:\"id\";s:3:\"418\";s:6:\"handle\";s:17:\"Cooperation-2.jpg\";s:4:\"name\";s:13:\"Cooperation 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:182;a:12:{s:2:\"id\";s:3:\"417\";s:6:\"handle\";s:33:\"MacBook-on-top-of-brown-table.jpg\";s:4:\"name\";s:29:\"MacBook on top of brown table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:183;a:12:{s:2:\"id\";s:3:\"416\";s:6:\"handle\";s:27:\"Beautiful-working-place.jpg\";s:4:\"name\";s:23:\"Beautiful working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:184;a:12:{s:2:\"id\";s:3:\"415\";s:6:\"handle\";s:14:\"Typewriter.jpg\";s:4:\"name\";s:10:\"Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:185;a:12:{s:2:\"id\";s:3:\"414\";s:6:\"handle\";s:19:\"White-desk-lamp.jpg\";s:4:\"name\";s:15:\"White desk lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:186;a:12:{s:2:\"id\";s:3:\"413\";s:6:\"handle\";s:18:\"Office-working.jpg\";s:4:\"name\";s:14:\"Office working\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:187;a:12:{s:2:\"id\";s:3:\"412\";s:6:\"handle\";s:36:\"Silver-iMac-on-brown-wooden-desk.jpg\";s:4:\"name\";s:32:\"Silver iMac on brown wooden desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1240\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:188;a:12:{s:2:\"id\";s:3:\"411\";s:6:\"handle\";s:23:\"Working-in-progress.jpg\";s:4:\"name\";s:19:\"Working in progress\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:189;a:12:{s:2:\"id\";s:3:\"410\";s:6:\"handle\";s:15:\"Cooperation.jpg\";s:4:\"name\";s:11:\"Cooperation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:190;a:12:{s:2:\"id\";s:3:\"409\";s:6:\"handle\";s:17:\"Working-place.jpg\";s:4:\"name\";s:13:\"Working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:191;a:12:{s:2:\"id\";s:3:\"408\";s:6:\"handle\";s:16:\"Working-desk.jpg\";s:4:\"name\";s:12:\"Working desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:192;a:12:{s:2:\"id\";s:3:\"407\";s:6:\"handle\";s:23:\"low-angle-of-forest.jpg\";s:4:\"name\";s:19:\"low angle of forest\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:193;a:12:{s:2:\"id\";s:3:\"406\";s:6:\"handle\";s:23:\"Lake-under-blue-sky.jpg\";s:4:\"name\";s:19:\"Lake under blue sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1351\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:194;a:12:{s:2:\"id\";s:3:\"405\";s:6:\"handle\";s:21:\"Blue-starry-night.jpg\";s:4:\"name\";s:17:\"Blue starry night\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:195;a:12:{s:2:\"id\";s:3:\"404\";s:6:\"handle\";s:22:\"Aerial-photography.jpg\";s:4:\"name\";s:18:\"Aerial photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:196;a:12:{s:2:\"id\";s:3:\"403\";s:6:\"handle\";s:14:\"Red-clouds.jpg\";s:4:\"name\";s:10:\"Red clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:197;a:12:{s:2:\"id\";s:3:\"402\";s:6:\"handle\";s:14:\"Snow-field.jpg\";s:4:\"name\";s:10:\"Snow field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1227\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:198;a:12:{s:2:\"id\";s:3:\"401\";s:6:\"handle\";s:13:\"White-sky.jpg\";s:4:\"name\";s:9:\"White sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:199;a:12:{s:2:\"id\";s:3:\"400\";s:6:\"handle\";s:24:\"Trees-covered-by-fog.jpg\";s:4:\"name\";s:20:\"Trees covered by fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:200;a:12:{s:2:\"id\";s:3:\"399\";s:6:\"handle\";s:26:\"Red-and-white-mushroom.jpg\";s:4:\"name\";s:22:\"Red and white mushroom\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:201;a:12:{s:2:\"id\";s:3:\"398\";s:6:\"handle\";s:24:\"Lake-near-pine-trees.jpg\";s:4:\"name\";s:20:\"Lake near pine trees\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:202;a:12:{s:2:\"id\";s:3:\"397\";s:6:\"handle\";s:35:\"After-a-long-day-of-backpacking.jpg\";s:4:\"name\";s:31:\"After a long day of backpacking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:203;a:12:{s:2:\"id\";s:3:\"396\";s:6:\"handle\";s:32:\"Mountains-during-golden-hour.jpg\";s:4:\"name\";s:28:\"Mountains during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:204;a:12:{s:2:\"id\";s:3:\"395\";s:6:\"handle\";s:27:\"Man-looking-on-mountain.jpg\";s:4:\"name\";s:23:\"Man looking on mountain\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:205;a:12:{s:2:\"id\";s:3:\"394\";s:6:\"handle\";s:19:\"Body-of-water-2.jpg\";s:4:\"name\";s:15:\"Body of water 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:206;a:12:{s:2:\"id\";s:3:\"393\";s:6:\"handle\";s:15:\"Brown-cliff.jpg\";s:4:\"name\";s:11:\"Brown cliff\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:207;a:12:{s:2:\"id\";s:3:\"392\";s:6:\"handle\";s:20:\"Green-foggy-tree.jpg\";s:4:\"name\";s:16:\"Green foggy tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1417\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:208;a:12:{s:2:\"id\";s:3:\"391\";s:6:\"handle\";s:32:\"Grayscale-photo-of-mountains.jpg\";s:4:\"name\";s:28:\"Grayscale photo of mountains\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:209;a:12:{s:2:\"id\";s:3:\"390\";s:6:\"handle\";s:19:\"Under-sunny-sky.jpg\";s:4:\"name\";s:15:\"Under sunny sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:210;a:12:{s:2:\"id\";s:3:\"389\";s:6:\"handle\";s:16:\"Rock-concert.jpg\";s:4:\"name\";s:12:\"Rock concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1443\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:211;a:12:{s:2:\"id\";s:3:\"388\";s:6:\"handle\";s:30:\"Group-of-people-in-concert.jpg\";s:4:\"name\";s:26:\"Group of people in concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:212;a:12:{s:2:\"id\";s:3:\"387\";s:6:\"handle\";s:6:\"DJ.jpg\";s:4:\"name\";s:2:\"DJ\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:213;a:12:{s:2:\"id\";s:3:\"386\";s:6:\"handle\";s:56:\"Woman-standing-watching-LED-light-musical-instrument.jpg\";s:4:\"name\";s:52:\"Woman standing watching LED light musical instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:214;a:12:{s:2:\"id\";s:3:\"385\";s:6:\"handle\";s:16:\"Concert-hall.jpg\";s:4:\"name\";s:12:\"Concert hall\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:215;a:12:{s:2:\"id\";s:3:\"384\";s:6:\"handle\";s:18:\"Concert-hall-2.jpg\";s:4:\"name\";s:14:\"Concert hall 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:216;a:12:{s:2:\"id\";s:3:\"383\";s:6:\"handle\";s:29:\"man-playing-upright-piano.jpg\";s:4:\"name\";s:25:\"man playing upright piano\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1340\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:217;a:12:{s:2:\"id\";s:3:\"382\";s:6:\"handle\";s:30:\"person-performing-on-stage.jpg\";s:4:\"name\";s:26:\"person performing on stage\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:218;a:12:{s:2:\"id\";s:3:\"381\";s:6:\"handle\";s:27:\"Brown-string-instrument.jpg\";s:4:\"name\";s:23:\"Brown string instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:219;a:12:{s:2:\"id\";s:3:\"380\";s:6:\"handle\";s:36:\"silhouette-of-person-with-guitar.jpg\";s:4:\"name\";s:32:\"silhouette of person with guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:220;a:12:{s:2:\"id\";s:3:\"379\";s:6:\"handle\";s:14:\"Party-fans.jpg\";s:4:\"name\";s:10:\"Party fans\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:221;a:12:{s:2:\"id\";s:3:\"378\";s:6:\"handle\";s:24:\"Condenser-microphone.jpg\";s:4:\"name\";s:20:\"Condenser microphone\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:222;a:12:{s:2:\"id\";s:3:\"377\";s:6:\"handle\";s:42:\"Low-angle-photo-of-high-rise-buildings.jpg\";s:4:\"name\";s:38:\"Low angle photo of high rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:223;a:12:{s:2:\"id\";s:3:\"376\";s:6:\"handle\";s:23:\"High-rise-buildings.jpg\";s:4:\"name\";s:19:\"High rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:224;a:12:{s:2:\"id\";s:3:\"375\";s:6:\"handle\";s:16:\"Cable-bridge.jpg\";s:4:\"name\";s:12:\"Cable bridge\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:225;a:12:{s:2:\"id\";s:3:\"374\";s:6:\"handle\";s:35:\"Bokeh-effect-from-street-lights.jpg\";s:4:\"name\";s:31:\"Bokeh effect from street lights\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:226;a:12:{s:2:\"id\";s:3:\"373\";s:6:\"handle\";s:18:\"Low-angle-view.jpg\";s:4:\"name\";s:14:\"Low angle view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:227;a:12:{s:2:\"id\";s:3:\"372\";s:6:\"handle\";s:21:\"Double-decker-bus.jpg\";s:4:\"name\";s:17:\"Double decker bus\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1373\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:228;a:12:{s:2:\"id\";s:3:\"371\";s:6:\"handle\";s:32:\"Buildings-near-body-of-water.jpg\";s:4:\"name\";s:28:\"Buildings near body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1370\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:229;a:12:{s:2:\"id\";s:3:\"370\";s:6:\"handle\";s:18:\"Satellite-view.jpg\";s:4:\"name\";s:14:\"Satellite view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:230;a:12:{s:2:\"id\";s:3:\"369\";s:6:\"handle\";s:14:\"Twin-Tower.jpg\";s:4:\"name\";s:10:\"Twin Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:231;a:12:{s:2:\"id\";s:3:\"368\";s:6:\"handle\";s:22:\"Two-person-walking.jpg\";s:4:\"name\";s:18:\"Two person walking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1345\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:232;a:12:{s:2:\"id\";s:3:\"367\";s:6:\"handle\";s:15:\"Sears-Tower.jpg\";s:4:\"name\";s:11:\"Sears Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:233;a:12:{s:2:\"id\";s:3:\"366\";s:6:\"handle\";s:19:\"Night-cityscape.jpg\";s:4:\"name\";s:15:\"Night cityscape\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:234;a:12:{s:2:\"id\";s:3:\"365\";s:6:\"handle\";s:25:\"Empire-State-Building.jpg\";s:4:\"name\";s:21:\"Empire State Building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:235;a:12:{s:2:\"id\";s:3:\"364\";s:6:\"handle\";s:9:\"Paris.jpg\";s:4:\"name\";s:5:\"Paris\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:236;a:12:{s:2:\"id\";s:3:\"363\";s:6:\"handle\";s:31:\"Building-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Building during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1288\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:237;a:12:{s:2:\"id\";s:3:\"362\";s:6:\"handle\";s:21:\"Afternoon-skyline.jpg\";s:4:\"name\";s:17:\"Afternoon skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:238;a:12:{s:2:\"id\";s:3:\"361\";s:6:\"handle\";s:22:\"Concrete-buildings.jpg\";s:4:\"name\";s:18:\"Concrete buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:239;a:12:{s:2:\"id\";s:3:\"360\";s:6:\"handle\";s:26:\"Architectural-building.jpg\";s:4:\"name\";s:22:\"Architectural building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1382\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:240;a:12:{s:2:\"id\";s:3:\"359\";s:6:\"handle\";s:23:\"Skyline-photography.jpg\";s:4:\"name\";s:19:\"Skyline photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:241;a:12:{s:2:\"id\";s:3:\"358\";s:6:\"handle\";s:38:\"People-standing-on-pedestrian-lane.jpg\";s:4:\"name\";s:34:\"People standing on pedestrian lane\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1154\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:242;a:12:{s:2:\"id\";s:3:\"357\";s:6:\"handle\";s:16:\"Burj-Khalifa.jpg\";s:4:\"name\";s:12:\"Burj Khalifa\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:243;a:12:{s:2:\"id\";s:3:\"356\";s:6:\"handle\";s:13:\"Skycraper.jpg\";s:4:\"name\";s:9:\"Skycraper\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:244;a:12:{s:2:\"id\";s:3:\"355\";s:6:\"handle\";s:14:\"Gray-tower.jpg\";s:4:\"name\";s:10:\"Gray tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1433\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:245;a:12:{s:2:\"id\";s:3:\"354\";s:6:\"handle\";s:28:\"One-fine-day-in-Maldives.jpg\";s:4:\"name\";s:24:\"One fine day in Maldives\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1116\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:246;a:12:{s:2:\"id\";s:3:\"353\";s:6:\"handle\";s:25:\"Boat-on-body-of-water.jpg\";s:4:\"name\";s:21:\"Boat on body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:247;a:12:{s:2:\"id\";s:3:\"352\";s:6:\"handle\";s:33:\"Aerial-photo-of-body-of-water.jpg\";s:4:\"name\";s:29:\"Aerial photo of body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1078\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:248;a:12:{s:2:\"id\";s:3:\"351\";s:6:\"handle\";s:31:\"Assorted-color-beach-houses.jpg\";s:4:\"name\";s:27:\"Assorted color beach houses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1135\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:249;a:12:{s:2:\"id\";s:3:\"350\";s:6:\"handle\";s:36:\"Woman-leaning-on-tree-near-beach.jpg\";s:4:\"name\";s:32:\"Woman leaning on tree near beach\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1559\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:250;a:12:{s:2:\"id\";s:3:\"349\";s:6:\"handle\";s:17:\"Body-of-water.jpg\";s:4:\"name\";s:13:\"Body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1269\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:251;a:12:{s:2:\"id\";s:3:\"348\";s:6:\"handle\";s:17:\"People-on-sea.jpg\";s:4:\"name\";s:13:\"People on sea\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:252;a:12:{s:2:\"id\";s:3:\"347\";s:6:\"handle\";s:31:\"Man-sitting-beside-of-woman.jpg\";s:4:\"name\";s:27:\"Man sitting beside of woman\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:253;a:12:{s:2:\"id\";s:3:\"346\";s:6:\"handle\";s:22:\"woman-in-the-water.jpg\";s:4:\"name\";s:18:\"woman in the water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:254;a:12:{s:2:\"id\";s:3:\"345\";s:6:\"handle\";s:39:\"Brown-stone-near-sea-at-golden-hour.jpg\";s:4:\"name\";s:35:\"Brown stone near sea at golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:255;a:12:{s:2:\"id\";s:3:\"344\";s:6:\"handle\";s:18:\"Birds-eye-view.jpg\";s:4:\"name\";s:14:\"Birds eye view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:256;a:12:{s:2:\"id\";s:3:\"343\";s:6:\"handle\";s:18:\"Empty-seashore.jpg\";s:4:\"name\";s:14:\"Empty seashore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1365\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:257;a:12:{s:2:\"id\";s:3:\"342\";s:6:\"handle\";s:31:\"Seashore-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Seashore during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:258;a:12:{s:2:\"id\";s:3:\"341\";s:6:\"handle\";s:16:\"Coconut-tree.jpg\";s:4:\"name\";s:12:\"Coconut tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:259;a:12:{s:2:\"id\";s:3:\"340\";s:6:\"handle\";s:37:\"Aerial-photography-of-beach-shore.jpg\";s:4:\"name\";s:33:\"Aerial photography of beach shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:260;a:12:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:261;a:12:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:262;a:12:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:263;a:12:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:264;a:12:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:265;a:12:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:266;a:12:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:267;a:12:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:268;a:12:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:269;a:12:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:270;a:12:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:271;a:12:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:272;a:12:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:273;a:12:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:274;a:12:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:275;a:12:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:276;a:12:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:277;a:12:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:278;a:12:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:279;a:12:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:280;a:12:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:281;a:12:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:282;a:12:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:283;a:12:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:284;a:12:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:285;a:12:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:286;a:12:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:287;a:12:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:288;a:12:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:289;a:12:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:290;a:12:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:291;a:12:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:292;a:12:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:293;a:12:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:294;a:12:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:295;a:12:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:296;a:12:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:297;a:12:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:298;a:12:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:299;a:12:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:300;a:12:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:301;a:12:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:302;a:12:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:303;a:12:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:304;a:12:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:305;a:12:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:306;a:12:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:307;a:12:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:308;a:12:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:309;a:13:{s:2:\"id\";s:3:\"529\";s:6:\"handle\";s:13:\"Fitness-4.jpg\";s:5:\"video\";s:13:\"Fitness-4.mp4\";s:4:\"name\";s:10:\"Fitness 4 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:310;a:13:{s:2:\"id\";s:3:\"528\";s:6:\"handle\";s:13:\"Fitness-3.jpg\";s:5:\"video\";s:13:\"Fitness-3.mp4\";s:4:\"name\";s:10:\"Fitness 3 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:311;a:13:{s:2:\"id\";s:3:\"527\";s:6:\"handle\";s:9:\"Chess.jpg\";s:5:\"video\";s:9:\"Chess.mp4\";s:4:\"name\";s:6:\"Chess \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:312;a:13:{s:2:\"id\";s:3:\"526\";s:6:\"handle\";s:13:\"Fitness-2.jpg\";s:5:\"video\";s:13:\"Fitness-2.mp4\";s:4:\"name\";s:10:\"Fitness 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:313;a:13:{s:2:\"id\";s:3:\"525\";s:6:\"handle\";s:11:\"Fitness.jpg\";s:5:\"video\";s:11:\"Fitness.mp4\";s:4:\"name\";s:8:\"Fitness \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:314;a:13:{s:2:\"id\";s:3:\"524\";s:6:\"handle\";s:9:\"Earth.jpg\";s:5:\"video\";s:9:\"Earth.mp4\";s:4:\"name\";s:6:\"Earth \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:315;a:13:{s:2:\"id\";s:3:\"523\";s:6:\"handle\";s:11:\"Space-2.jpg\";s:5:\"video\";s:11:\"Space-2.mp4\";s:4:\"name\";s:8:\"Space 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1440\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:316;a:13:{s:2:\"id\";s:3:\"522\";s:6:\"handle\";s:13:\"Asteroids.jpg\";s:5:\"video\";s:13:\"Asteroids.mp4\";s:4:\"name\";s:10:\"Asteroids \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:317;a:13:{s:2:\"id\";s:3:\"521\";s:6:\"handle\";s:9:\"Space.jpg\";s:5:\"video\";s:9:\"Space.mp4\";s:4:\"name\";s:6:\"Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:318;a:13:{s:2:\"id\";s:3:\"520\";s:6:\"handle\";s:10:\"People.jpg\";s:5:\"video\";s:10:\"People.mp4\";s:4:\"name\";s:7:\"People \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:319;a:13:{s:2:\"id\";s:3:\"519\";s:6:\"handle\";s:11:\"Walking.jpg\";s:5:\"video\";s:11:\"Walking.mp4\";s:4:\"name\";s:8:\"Walking \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:320;a:13:{s:2:\"id\";s:3:\"518\";s:6:\"handle\";s:19:\"Double-Exposure.jpg\";s:5:\"video\";s:19:\"Double-Exposure.mp4\";s:4:\"name\";s:16:\"Double Exposure \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:321;a:13:{s:2:\"id\";s:3:\"517\";s:6:\"handle\";s:8:\"Girl.jpg\";s:5:\"video\";s:8:\"Girl.mp4\";s:4:\"name\";s:5:\"Girl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1088\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:322;a:13:{s:2:\"id\";s:3:\"516\";s:6:\"handle\";s:17:\"Bengal-Lights.jpg\";s:5:\"video\";s:17:\"Bengal-Lights.mp4\";s:4:\"name\";s:14:\"Bengal Lights \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:323;a:13:{s:2:\"id\";s:3:\"515\";s:6:\"handle\";s:13:\"Swiping-2.jpg\";s:5:\"video\";s:13:\"Swiping-2.mp4\";s:4:\"name\";s:10:\"Swiping 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:324;a:13:{s:2:\"id\";s:3:\"514\";s:6:\"handle\";s:11:\"Mock-Up.jpg\";s:5:\"video\";s:11:\"Mock-Up.mp4\";s:4:\"name\";s:8:\"Mock Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:325;a:13:{s:2:\"id\";s:3:\"513\";s:6:\"handle\";s:13:\"Countdown.jpg\";s:5:\"video\";s:13:\"Countdown.mp4\";s:4:\"name\";s:10:\"Countdown \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:326;a:13:{s:2:\"id\";s:3:\"512\";s:6:\"handle\";s:18:\"Wall-Sketching.jpg\";s:5:\"video\";s:18:\"Wall-Sketching.mp4\";s:4:\"name\";s:15:\"Wall Sketching \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:327;a:13:{s:2:\"id\";s:3:\"511\";s:6:\"handle\";s:26:\"Typing-on-the-keyboard.jpg\";s:5:\"video\";s:26:\"Typing-on-the-keyboard.mp4\";s:4:\"name\";s:23:\"Typing on the keyboard \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:328;a:13:{s:2:\"id\";s:3:\"510\";s:6:\"handle\";s:11:\"Meeting.jpg\";s:5:\"video\";s:11:\"Meeting.mp4\";s:4:\"name\";s:8:\"Meeting \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:329;a:13:{s:2:\"id\";s:3:\"509\";s:6:\"handle\";s:11:\"Swiping.jpg\";s:5:\"video\";s:11:\"Swiping.mp4\";s:4:\"name\";s:8:\"Swiping \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:330;a:13:{s:2:\"id\";s:3:\"508\";s:6:\"handle\";s:9:\"Alarm.jpg\";s:5:\"video\";s:9:\"Alarm.mp4\";s:4:\"name\";s:6:\"Alarm \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1013\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:331;a:13:{s:2:\"id\";s:3:\"507\";s:6:\"handle\";s:13:\"Hey-World.jpg\";s:5:\"video\";s:13:\"Hey-World.mp4\";s:4:\"name\";s:10:\"Hey World \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:332;a:13:{s:2:\"id\";s:3:\"506\";s:6:\"handle\";s:28:\"Typing-on-the-keyboard-2.jpg\";s:5:\"video\";s:28:\"Typing-on-the-keyboard-2.mp4\";s:4:\"name\";s:25:\"Typing on the keyboard 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:333;a:13:{s:2:\"id\";s:3:\"505\";s:6:\"handle\";s:10:\"Valley.jpg\";s:5:\"video\";s:10:\"Valley.mp4\";s:4:\"name\";s:7:\"Valley \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:334;a:13:{s:2:\"id\";s:3:\"504\";s:6:\"handle\";s:9:\"Stars.jpg\";s:5:\"video\";s:9:\"Stars.mp4\";s:4:\"name\";s:6:\"Stars \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:335;a:13:{s:2:\"id\";s:3:\"503\";s:6:\"handle\";s:21:\"Car-in-the-forest.jpg\";s:5:\"video\";s:21:\"Car-in-the-forest.mp4\";s:4:\"name\";s:18:\"Car in the forest \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1012\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:336;a:13:{s:2:\"id\";s:3:\"502\";s:6:\"handle\";s:15:\"Aerial-Shot.jpg\";s:5:\"video\";s:15:\"Aerial-Shot.mp4\";s:4:\"name\";s:12:\"Aerial Shot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:337;a:13:{s:2:\"id\";s:3:\"501\";s:6:\"handle\";s:14:\"Disco-Ball.jpg\";s:5:\"video\";s:14:\"Disco-Ball.mp4\";s:4:\"name\";s:11:\"Disco Ball \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:338;a:13:{s:2:\"id\";s:3:\"500\";s:6:\"handle\";s:22:\"Man-Playing-Guitar.jpg\";s:5:\"video\";s:22:\"Man-Playing-Guitar.mp4\";s:4:\"name\";s:19:\"Man Playing Guitar \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:339;a:13:{s:2:\"id\";s:3:\"499\";s:6:\"handle\";s:14:\"Live-Music.jpg\";s:5:\"video\";s:14:\"Live-Music.mp4\";s:4:\"name\";s:11:\"Live Music \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:340;a:13:{s:2:\"id\";s:3:\"498\";s:6:\"handle\";s:12:\"Cheer-Up.jpg\";s:5:\"video\";s:12:\"Cheer-Up.mp4\";s:4:\"name\";s:9:\"Cheer Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:341;a:13:{s:2:\"id\";s:3:\"497\";s:6:\"handle\";s:14:\"Night-club.jpg\";s:5:\"video\";s:14:\"Night-club.mp4\";s:4:\"name\";s:11:\"Night club \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:342;a:13:{s:2:\"id\";s:3:\"496\";s:6:\"handle\";s:17:\"Cup-Of-Coffee.jpg\";s:5:\"video\";s:17:\"Cup-Of-Coffee.mp4\";s:4:\"name\";s:14:\"Cup Of Coffee \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:343;a:13:{s:2:\"id\";s:3:\"495\";s:6:\"handle\";s:7:\"Pot.jpg\";s:5:\"video\";s:7:\"Pot.mp4\";s:4:\"name\";s:4:\"Pot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:344;a:13:{s:2:\"id\";s:3:\"494\";s:6:\"handle\";s:11:\"Grill-2.jpg\";s:5:\"video\";s:11:\"Grill-2.mp4\";s:4:\"name\";s:8:\"Grill 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:345;a:13:{s:2:\"id\";s:3:\"493\";s:6:\"handle\";s:13:\"Rice-Bowl.jpg\";s:5:\"video\";s:13:\"Rice-Bowl.mp4\";s:4:\"name\";s:10:\"Rice Bowl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1010\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:346;a:13:{s:2:\"id\";s:3:\"492\";s:6:\"handle\";s:9:\"Grill.jpg\";s:5:\"video\";s:9:\"Grill.mp4\";s:4:\"name\";s:6:\"Grill \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:347;a:13:{s:2:\"id\";s:3:\"491\";s:6:\"handle\";s:9:\"Water.jpg\";s:5:\"video\";s:9:\"Water.mp4\";s:4:\"name\";s:6:\"Water \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:348;a:13:{s:2:\"id\";s:3:\"490\";s:6:\"handle\";s:17:\"Feet-and-Sand.jpg\";s:5:\"video\";s:17:\"Feet-and-Sand.mp4\";s:4:\"name\";s:14:\"Feet and Sand \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:349;a:13:{s:2:\"id\";s:3:\"489\";s:6:\"handle\";s:9:\"Ocean.jpg\";s:5:\"video\";s:9:\"Ocean.mp4\";s:4:\"name\";s:6:\"Ocean \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:350;a:13:{s:2:\"id\";s:3:\"488\";s:6:\"handle\";s:9:\"Waves.jpg\";s:5:\"video\";s:9:\"Waves.mp4\";s:4:\"name\";s:6:\"Waves \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:351;a:13:{s:2:\"id\";s:3:\"487\";s:6:\"handle\";s:10:\"Hearts.jpg\";s:5:\"video\";s:10:\"Hearts.mp4\";s:4:\"name\";s:7:\"Hearts \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:352;a:13:{s:2:\"id\";s:3:\"486\";s:6:\"handle\";s:12:\"Octagons.jpg\";s:5:\"video\";s:12:\"Octagons.mp4\";s:4:\"name\";s:9:\"Octagons \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:353;a:13:{s:2:\"id\";s:3:\"485\";s:6:\"handle\";s:11:\"Squares.jpg\";s:5:\"video\";s:11:\"Squares.mp4\";s:4:\"name\";s:8:\"Squares \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:354;a:13:{s:2:\"id\";s:3:\"484\";s:6:\"handle\";s:12:\"Pink-ink.jpg\";s:5:\"video\";s:12:\"Pink-ink.mp4\";s:4:\"name\";s:9:\"Pink ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:355;a:13:{s:2:\"id\";s:3:\"483\";s:6:\"handle\";s:22:\"Blurred-Background.jpg\";s:5:\"video\";s:22:\"Blurred-Background.mp4\";s:4:\"name\";s:19:\"Blurred Background \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:356;a:13:{s:2:\"id\";s:3:\"482\";s:6:\"handle\";s:20:\"Blinking-bubbles.jpg\";s:5:\"video\";s:20:\"Blinking-bubbles.mp4\";s:4:\"name\";s:17:\"Blinking bubbles \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:357;a:13:{s:2:\"id\";s:3:\"481\";s:6:\"handle\";s:13:\"Fireworks.jpg\";s:5:\"video\";s:13:\"Fireworks.mp4\";s:4:\"name\";s:10:\"Fireworks \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:358;a:13:{s:2:\"id\";s:3:\"480\";s:6:\"handle\";s:12:\"Dark-ink.jpg\";s:5:\"video\";s:12:\"Dark-ink.mp4\";s:4:\"name\";s:9:\"Dark ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:359;a:13:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:360;a:13:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:361;a:13:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:362;a:13:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:363;a:13:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:364;a:13:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:365;a:13:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:366;a:13:{s:2:\"id\";s:3:\"231\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:367;a:13:{s:2:\"id\";s:3:\"230\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:368;a:13:{s:2:\"id\";s:3:\"229\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:369;a:13:{s:2:\"id\";s:3:\"339\";s:6:\"handle\";s:19:\"best_price_dark.jpg\";s:5:\"video\";s:19:\"best_price_dark.mp4\";s:4:\"name\";s:15:\"best_price_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"best_price_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:370;a:13:{s:2:\"id\";s:3:\"337\";s:6:\"handle\";s:27:\"limited_time_offer_dark.jpg\";s:5:\"video\";s:27:\"limited_time_offer_dark.mp4\";s:4:\"name\";s:23:\"limited_time_offer_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:23:\"limited_time_offer_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:371;a:13:{s:2:\"id\";s:3:\"336\";s:6:\"handle\";s:26:\"slider_revolution_dark.jpg\";s:5:\"video\";s:26:\"slider_revolution_dark.mp4\";s:4:\"name\";s:22:\"slider_revolution_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:22:\"slider_revolution_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:372;a:13:{s:2:\"id\";s:3:\"335\";s:6:\"handle\";s:19:\"mick_brown_dark.jpg\";s:5:\"video\";s:19:\"mick_brown_dark.mp4\";s:4:\"name\";s:15:\"mick_brown_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"mick_brown_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:373;a:13:{s:2:\"id\";s:3:\"334\";s:6:\"handle\";s:14:\"sales_dark.jpg\";s:5:\"video\";s:14:\"sales_dark.mp4\";s:4:\"name\";s:10:\"sales_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:10:\"sales_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:374;a:13:{s:2:\"id\";s:3:\"333\";s:6:\"handle\";s:21:\"robert_smith_dark.jpg\";s:5:\"video\";s:21:\"robert_smith_dark.mp4\";s:4:\"name\";s:17:\"robert_smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"robert_smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:375;a:13:{s:2:\"id\";s:3:\"332\";s:6:\"handle\";s:21:\"product_name_dark.jpg\";s:5:\"video\";s:21:\"product_name_dark.mp4\";s:4:\"name\";s:17:\"product_name_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"product_name_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:376;a:13:{s:2:\"id\";s:3:\"331\";s:6:\"handle\";s:21:\"high_quality_dark.jpg\";s:5:\"video\";s:21:\"high_quality_dark.mp4\";s:4:\"name\";s:17:\"high_quality_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"high_quality_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:377;a:13:{s:2:\"id\";s:3:\"330\";s:6:\"handle\";s:24:\"robert_johnson_light.jpg\";s:5:\"video\";s:24:\"robert_johnson_light.mp4\";s:4:\"name\";s:20:\"robert_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"robert_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:378;a:13:{s:2:\"id\";s:3:\"329\";s:6:\"handle\";s:21:\"jake_collins_dark.jpg\";s:5:\"video\";s:21:\"jake_collins_dark.mp4\";s:4:\"name\";s:17:\"jake_collins_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"jake_collins_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:379;a:13:{s:2:\"id\";s:3:\"328\";s:6:\"handle\";s:22:\"daniele_wood_light.jpg\";s:5:\"video\";s:22:\"daniele_wood_light.mp4\";s:4:\"name\";s:18:\"daniele_wood_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"daniele_wood_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:31:30\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:380;a:13:{s:2:\"id\";s:3:\"327\";s:6:\"handle\";s:23:\"michael_blake_light.jpg\";s:5:\"video\";s:23:\"michael_blake_light.mp4\";s:4:\"name\";s:19:\"michael_blake_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"michael_blake_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:381;a:13:{s:2:\"id\";s:3:\"326\";s:6:\"handle\";s:22:\"product_name_light.jpg\";s:5:\"video\";s:22:\"product_name_light.mp4\";s:4:\"name\";s:18:\"product_name_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"product_name_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:382;a:13:{s:2:\"id\";s:3:\"325\";s:6:\"handle\";s:24:\"rebecca_cooper_light.jpg\";s:5:\"video\";s:24:\"rebecca_cooper_light.mp4\";s:4:\"name\";s:20:\"rebecca_cooper_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"rebecca_cooper_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:383;a:13:{s:2:\"id\";s:3:\"324\";s:6:\"handle\";s:28:\"limited_time_offer_light.jpg\";s:5:\"video\";s:28:\"limited_time_offer_light.mp4\";s:4:\"name\";s:24:\"limited_time_offer_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:24:\"limited_time_offer_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:384;a:13:{s:2:\"id\";s:3:\"322\";s:6:\"handle\";s:22:\"jake_michael_light.jpg\";s:5:\"video\";s:22:\"jake_michael_light.mp4\";s:4:\"name\";s:18:\"jake_michael_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"jake_michael_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:385;a:13:{s:2:\"id\";s:3:\"321\";s:6:\"handle\";s:23:\"colin_johnson_light.jpg\";s:5:\"video\";s:23:\"colin_johnson_light.mp4\";s:4:\"name\";s:19:\"colin_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"colin_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:386;a:13:{s:2:\"id\";s:3:\"320\";s:6:\"handle\";s:21:\"colin_morris_dark.jpg\";s:5:\"video\";s:21:\"colin_morris_dark.mp4\";s:4:\"name\";s:17:\"colin_morris_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"colin_morris_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:387;a:13:{s:2:\"id\";s:3:\"319\";s:6:\"handle\";s:22:\"justin_cooper_dark.jpg\";s:5:\"video\";s:22:\"justin_cooper_dark.mp4\";s:4:\"name\";s:18:\"justin_cooper_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"justin_cooper_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:388;a:13:{s:2:\"id\";s:3:\"318\";s:6:\"handle\";s:21:\"james-dodson_dark.jpg\";s:5:\"video\";s:21:\"james-dodson_dark.mp4\";s:4:\"name\";s:17:\"james-dodson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"james-dodson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:389;a:13:{s:2:\"id\";s:3:\"317\";s:6:\"handle\";s:23:\"robert_sanders_dark.jpg\";s:5:\"video\";s:23:\"robert_sanders_dark.mp4\";s:4:\"name\";s:19:\"robert_sanders_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"robert_sanders_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:390;a:13:{s:2:\"id\";s:3:\"316\";s:6:\"handle\";s:21:\"emily_carney_dark.jpg\";s:5:\"video\";s:21:\"emily_carney_dark.mp4\";s:4:\"name\";s:17:\"emily_carney_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"emily_carney_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:391;a:13:{s:2:\"id\";s:3:\"315\";s:6:\"handle\";s:22:\"michael-smith_dark.jpg\";s:5:\"video\";s:22:\"michael-smith_dark.mp4\";s:4:\"name\";s:18:\"michael-smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"michael-smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:392;a:13:{s:2:\"id\";s:3:\"314\";s:6:\"handle\";s:23:\"sandra_johnson_dark.jpg\";s:5:\"video\";s:23:\"sandra_johnson_dark.mp4\";s:4:\"name\";s:19:\"sandra_johnson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"sandra_johnson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:393;a:13:{s:2:\"id\";s:3:\"313\";s:6:\"handle\";s:22:\"robert_bolton_dark.jpg\";s:5:\"video\";s:22:\"robert_bolton_dark.mp4\";s:4:\"name\";s:18:\"robert_bolton_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"robert_bolton_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:394;a:13:{s:2:\"id\";s:3:\"312\";s:6:\"handle\";s:25:\"elegant_captions_dark.png\";s:5:\"video\";s:25:\"elegant_captions_dark.mp4\";s:4:\"name\";s:21:\"elegant_captions_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:21:\"elegant_captions_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-18 14:41:45\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:395;a:13:{s:2:\"id\";s:3:\"311\";s:6:\"handle\";s:19:\"Caption_Dark_06.png\";s:5:\"video\";s:19:\"Caption_Dark_06.mp4\";s:4:\"name\";s:15:\"Caption_Dark_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_06\";s:5:\"width\";s:3:\"414\";s:6:\"height\";s:3:\"225\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:396;a:13:{s:2:\"id\";s:3:\"310\";s:6:\"handle\";s:19:\"Header_Light_02.png\";s:5:\"video\";s:19:\"Header_Light_02.mp4\";s:4:\"name\";s:15:\"Header_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:397;a:13:{s:2:\"id\";s:3:\"309\";s:6:\"handle\";s:21:\"Columns_4_Dark_01.png\";s:5:\"video\";s:21:\"Columns_4_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_4_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_4_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:398;a:13:{s:2:\"id\";s:3:\"308\";s:6:\"handle\";s:18:\"Header_Dark_01.png\";s:5:\"video\";s:18:\"Header_Dark_01.mp4\";s:4:\"name\";s:14:\"Header_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:399;a:13:{s:2:\"id\";s:3:\"307\";s:6:\"handle\";s:19:\"Caption_Dark_03.png\";s:5:\"video\";s:19:\"Caption_Dark_03.mp4\";s:4:\"name\";s:15:\"Caption_Dark_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:400;a:13:{s:2:\"id\";s:3:\"306\";s:6:\"handle\";s:21:\"Columns_3_Dark_01.png\";s:5:\"video\";s:21:\"Columns_3_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_3_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_3_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:401;a:13:{s:2:\"id\";s:3:\"305\";s:6:\"handle\";s:19:\"Caption_Dark_05.png\";s:5:\"video\";s:19:\"Caption_Dark_05.mp4\";s:4:\"name\";s:15:\"Caption_Dark_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_05\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:402;a:13:{s:2:\"id\";s:3:\"304\";s:6:\"handle\";s:20:\"Caption_Light_06.png\";s:5:\"video\";s:20:\"Caption_Light_06.mp4\";s:4:\"name\";s:16:\"Caption_Light_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_06\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:403;a:13:{s:2:\"id\";s:3:\"303\";s:6:\"handle\";s:19:\"Header_Light_01.png\";s:5:\"video\";s:19:\"Header_Light_01.mp4\";s:4:\"name\";s:15:\"Header_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:404;a:13:{s:2:\"id\";s:3:\"302\";s:6:\"handle\";s:20:\"Caption_Light_03.png\";s:5:\"video\";s:20:\"Caption_Light_03.mp4\";s:4:\"name\";s:16:\"Caption_Light_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:405;a:13:{s:2:\"id\";s:3:\"301\";s:6:\"handle\";s:19:\"Caption_Dark_01.png\";s:5:\"video\";s:19:\"Caption_Dark_01.mp4\";s:4:\"name\";s:15:\"Caption_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:406;a:13:{s:2:\"id\";s:3:\"300\";s:6:\"handle\";s:21:\"PromoCode_Dark_01.png\";s:5:\"video\";s:21:\"PromoCode_Dark_01.mp4\";s:4:\"name\";s:17:\"PromoCode_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"PromoCode_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:407;a:13:{s:2:\"id\";s:3:\"299\";s:6:\"handle\";s:19:\"Caption_Dark_02.png\";s:5:\"video\";s:19:\"Caption_Dark_02.mp4\";s:4:\"name\";s:15:\"Caption_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:408;a:13:{s:2:\"id\";s:3:\"298\";s:6:\"handle\";s:18:\"Header_Dark_02.png\";s:5:\"video\";s:18:\"Header_Dark_02.mp4\";s:4:\"name\";s:14:\"Header_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:409;a:13:{s:2:\"id\";s:3:\"297\";s:6:\"handle\";s:22:\"Columns_3_Light_01.png\";s:5:\"video\";s:22:\"Columns_3_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_3_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_3_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:410;a:13:{s:2:\"id\";s:3:\"296\";s:6:\"handle\";s:20:\"Caption_Light_01.png\";s:5:\"video\";s:20:\"Caption_Light_01.mp4\";s:4:\"name\";s:16:\"Caption_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:411;a:13:{s:2:\"id\";s:3:\"295\";s:6:\"handle\";s:19:\"Caption_Dark_04.png\";s:5:\"video\";s:19:\"Caption_Dark_04.mp4\";s:4:\"name\";s:15:\"Caption_Dark_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_04\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:412;a:13:{s:2:\"id\";s:3:\"294\";s:6:\"handle\";s:20:\"Caption_Light_02.png\";s:5:\"video\";s:20:\"Caption_Light_02.mp4\";s:4:\"name\";s:16:\"Caption_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_02\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:413;a:13:{s:2:\"id\";s:3:\"293\";s:6:\"handle\";s:20:\"Caption_Light_04.png\";s:5:\"video\";s:20:\"Caption_Light_04.mp4\";s:4:\"name\";s:16:\"Caption_Light_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_04\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:414;a:13:{s:2:\"id\";s:3:\"292\";s:6:\"handle\";s:22:\"Columns_4_Light_01.png\";s:5:\"video\";s:22:\"Columns_4_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_4_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_4_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:415;a:13:{s:2:\"id\";s:3:\"291\";s:6:\"handle\";s:20:\"Caption_Light_05.png\";s:5:\"video\";s:20:\"Caption_Light_05.mp4\";s:4:\"name\";s:16:\"Caption_Light_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_05\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:416;a:13:{s:2:\"id\";s:3:\"290\";s:6:\"handle\";s:22:\"PromoCode_Light_01.png\";s:5:\"video\";s:22:\"PromoCode_Light_01.mp4\";s:4:\"name\";s:18:\"PromoCode_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"PromoCode_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}", "no");
INSERT INTO `wp_options` VALUES("203", "rs_tables_created", "1", "yes");
INSERT INTO `wp_options` VALUES("205", "revslider-global-settings", "{\"version\":\"6.2.0\",\"permission\":\"admin\",\"includeids\":\"\",\"script\":{\"footer\":false,\"defer\":false,\"full\":false},\"fonturl\":\"\",\"size\":{\"desktop\":1240,\"notebook\":1024,\"tablet\":778,\"mobile\":480}}", "yes");
INSERT INTO `wp_options` VALUES("206", "revslider_update_version", "6.2.0", "yes");
INSERT INTO `wp_options` VALUES("207", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("208", "gform_version_info", "a:12:{s:12:\"is_valid_key\";b:1;s:6:\"reason\";s:0:\"\";s:7:\"version\";s:6:\"2.9.24\";s:3:\"url\";s:186:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/releases/gravityforms_2.9.24.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=xmk4v7Xh2R3TegJ7jYz62pRxhEQ%3D\";s:15:\"expiration_time\";i:1775592745;s:9:\"offerings\";a:72:{s:12:\"gravityforms\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:6:\"2.9.24\";s:14:\"version_latest\";s:6:\"2.9.24\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:186:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/releases/gravityforms_2.9.24.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=xmk4v7Xh2R3TegJ7jYz62pRxhEQ%3D\";s:10:\"url_latest\";s:186:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/releases/gravityforms_2.9.24.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=xmk4v7Xh2R3TegJ7jYz62pRxhEQ%3D\";}s:10:\"gravitycrm\";a:4:{s:12:\"is_available\";b:0;s:7:\"version\";s:0:\"\";s:14:\"version_latest\";s:0:\"\";s:20:\"minimum_requirements\";a:0:{}}s:21:\"gravityforms2checkout\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.4.0\";s:14:\"version_latest\";s:5:\"2.4.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/2checkout/gravityforms2checkout_2.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=jCtIJHWY8TjOJriFUzXQejPQzdw%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/2checkout/gravityforms2checkout_2.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=jCtIJHWY8TjOJriFUzXQejPQzdw%3D\";}s:26:\"gravityformsactivecampaign\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.2.0\";s:14:\"version_latest\";s:5:\"2.2.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:212:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/activecampaign/gravityformsactivecampaign_2.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=UuhFVj9TkZLRb3gs4cc1sD0wQZI%3D\";s:10:\"url_latest\";s:212:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/activecampaign/gravityformsactivecampaign_2.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=UuhFVj9TkZLRb3gs4cc1sD0wQZI%3D\";}s:32:\"gravityformsadvancedpostcreation\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.5.0\";s:14:\"version_latest\";s:5:\"1.5.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:224:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/advancedpostcreation/gravityformsadvancedpostcreation_1.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=XO2lySKbOIxWSRiQOmeegjDmDxE%3D\";s:10:\"url_latest\";s:224:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/advancedpostcreation/gravityformsadvancedpostcreation_1.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=XO2lySKbOIxWSRiQOmeegjDmDxE%3D\";}s:20:\"gravityformsagilecrm\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.6.0\";s:14:\"version_latest\";s:5:\"1.6.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/agilecrm/gravityformsagilecrm_1.6.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=peLejCOwkfUpUveBCmzNPtGIPNc%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/agilecrm/gravityformsagilecrm_1.6.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=peLejCOwkfUpUveBCmzNPtGIPNc%3D\";}s:19:\"gravityformsakismet\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.1.0\";s:14:\"version_latest\";s:5:\"1.1.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/akismet/gravityformsakismet_1.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=VB2929igDf6VmZukSIWY%2FsMRpik%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/akismet/gravityformsakismet_1.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=VB2929igDf6VmZukSIWY%2FsMRpik%3D\";}s:24:\"gravityformsauthorizenet\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:4:\"2.11\";s:14:\"version_latest\";s:4:\"2.11\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:207:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/authorizenet/gravityformsauthorizenet_2.11.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=HEGkSLe12Qw5PTRSQHxlrcz6rIk%3D\";s:10:\"url_latest\";s:207:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/authorizenet/gravityformsauthorizenet_2.11.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=HEGkSLe12Qw5PTRSQHxlrcz6rIk%3D\";}s:18:\"gravityformsaweber\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"4.2.0\";s:14:\"version_latest\";s:5:\"4.2.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/aweber/gravityformsaweber_4.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=Vq%2FR1zbEgWvk7%2F9ygyEEn%2Bk7oZQ%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/aweber/gravityformsaweber_4.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=Vq%2FR1zbEgWvk7%2F9ygyEEn%2Bk7oZQ%3D\";}s:21:\"gravityformsbatchbook\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.3\";s:14:\"version_latest\";s:3:\"1.3\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/batchbook/gravityformsbatchbook_1.3.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=5olmiVTFEc9KIokR%2Fmce0iDAwXQ%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/batchbook/gravityformsbatchbook_1.3.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=5olmiVTFEc9KIokR%2Fmce0iDAwXQ%3D\";}s:18:\"gravityformsbreeze\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.7.0\";s:14:\"version_latest\";s:5:\"1.7.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/breeze/gravityformsbreeze_1.7.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=2qMWCpEdCJb%2FC8q7ZUu9%2F1%2FVFJo%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/breeze/gravityformsbreeze_1.7.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=2qMWCpEdCJb%2FC8q7ZUu9%2F1%2FVFJo%3D\";}s:17:\"gravityformsbrevo\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.0.0\";s:14:\"version_latest\";s:5:\"1.0.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/brevo/gravityformsbrevo_1.0.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=7nbb3CfmrdonEpkxSyPi09DzZtc%3D\";s:10:\"url_latest\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/brevo/gravityformsbrevo_1.0.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=7nbb3CfmrdonEpkxSyPi09DzZtc%3D\";}s:27:\"gravityformscampaignmonitor\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"4.1.0\";s:14:\"version_latest\";s:5:\"4.1.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:214:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/campaignmonitor/gravityformscampaignmonitor_4.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=pLe05TMTtbawurKhn1DgTWRnNK8%3D\";s:10:\"url_latest\";s:214:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/campaignmonitor/gravityformscampaignmonitor_4.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=pLe05TMTtbawurKhn1DgTWRnNK8%3D\";}s:20:\"gravityformscampfire\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.1\";s:14:\"version_latest\";s:5:\"1.2.2\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/campfire/gravityformscampfire_1.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=Z150lAeZkLYboiOOGKam7V8fZro%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/campfire/gravityformscampfire_1.2.2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=mGkW00CCWO0AKzRZ5dyCP0ymJ2o%3D\";}s:22:\"gravityformscapsulecrm\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.0\";s:14:\"version_latest\";s:5:\"1.8.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:206:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/capsulecrm/gravityformscapsulecrm_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=%2FnwT9y73w0oowOM9d6ZEwI8d9ug%3D\";s:10:\"url_latest\";s:206:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/capsulecrm/gravityformscapsulecrm_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=%2FnwT9y73w0oowOM9d6ZEwI8d9ug%3D\";}s:26:\"gravityformschainedselects\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.0\";s:14:\"version_latest\";s:5:\"1.8.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:212:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/chainedselects/gravityformschainedselects_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=T6w3YoYqzK3ITWxD6pzsUQO2UnM%3D\";s:10:\"url_latest\";s:212:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/chainedselects/gravityformschainedselects_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=T6w3YoYqzK3ITWxD6pzsUQO2UnM%3D\";}s:23:\"gravityformscleverreach\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.9.0\";s:14:\"version_latest\";s:5:\"1.9.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:208:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/cleverreach/gravityformscleverreach_1.9.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=ma2g%2BzpGKqppFqDSUJR0bayyIio%3D\";s:10:\"url_latest\";s:208:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/cleverreach/gravityformscleverreach_1.9.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=ma2g%2BzpGKqppFqDSUJR0bayyIio%3D\";}s:15:\"gravityformscli\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:0:\"\";s:14:\"version_latest\";s:3:\"1.7\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:0:\"\";s:10:\"url_latest\";s:192:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/cli/gravityformscli_1.7.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=eUi47jBhJZdzy2ve%2FH8VB%2F0OdgU%3D\";}s:27:\"gravityformsconstantcontact\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.0\";s:14:\"version_latest\";s:5:\"1.8.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:216:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/constantcontact/gravityformsconstantcontact_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=7rDyCracN%2FzC7p4q3EDg4aPKU1o%3D\";s:10:\"url_latest\";s:216:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/constantcontact/gravityformsconstantcontact_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=7rDyCracN%2FzC7p4q3EDg4aPKU1o%3D\";}s:31:\"gravityformsconversationalforms\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.6.0\";s:14:\"version_latest\";s:5:\"1.6.3\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:222:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/conversationalforms/gravityformsconversationalforms_1.6.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=wpzIOILIGIwJmQqvVF1BNIpgrHA%3D\";s:10:\"url_latest\";s:222:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/conversationalforms/gravityformsconversationalforms_1.6.3.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=OPv0cUG6DxfhoBCE5Mbk67PmVNA%3D\";}s:22:\"gravityformsconvertkit\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.2.0\";s:14:\"version_latest\";s:5:\"1.2.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:206:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/convertkit/gravityformsconvertkit_1.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=6yXAuQDoovdSZNEptjwyi%2B5e9cY%3D\";s:10:\"url_latest\";s:206:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/convertkit/gravityformsconvertkit_1.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=6yXAuQDoovdSZNEptjwyi%2B5e9cY%3D\";}s:19:\"gravityformscoupons\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"3.5.0\";s:14:\"version_latest\";s:5:\"3.5.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/coupons/gravityformscoupons_3.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=7gpsh6uO45t2CXuQOhcgcUDcxKg%3D\";s:10:\"url_latest\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/coupons/gravityformscoupons_3.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=7gpsh6uO45t2CXuQOhcgcUDcxKg%3D\";}s:17:\"gravityformsdebug\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:0:\"\";s:14:\"version_latest\";s:10:\"1.0.beta12\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:0:\"\";s:10:\"url_latest\";s:199:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/debug/gravityformsdebug_1.0.beta12.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=drlBbGemTKDOet9RCzQNKTAod7g%3D\";}s:19:\"gravityformsdropbox\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"3.3.0\";s:14:\"version_latest\";s:7:\"3.3.0.2\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/dropbox/gravityformsdropbox_3.3.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=eh3HK7XPJqeA%2BZR99IG1A1hhsG0%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/dropbox/gravityformsdropbox_3.3.0.2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=oJtOT2acC9HQbQs9hcp4OtTflKg%3D\";}s:24:\"gravityformsemailoctopus\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.4.0\";s:14:\"version_latest\";s:5:\"1.4.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:212:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/emailoctopus/gravityformsemailoctopus_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=BCLPfWDx%2FxhqqQ0Ma1%2BUJZpY7yU%3D\";s:10:\"url_latest\";s:212:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/emailoctopus/gravityformsemailoctopus_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=BCLPfWDx%2FxhqqQ0Ma1%2BUJZpY7yU%3D\";}s:16:\"gravityformsemma\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.0\";s:14:\"version_latest\";s:5:\"1.8.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/emma/gravityformsemma_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=yLdejyzJVkuKcWZ3J%2FW9gW5aVEM%3D\";s:10:\"url_latest\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/emma/gravityformsemma_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=yLdejyzJVkuKcWZ3J%2FW9gW5aVEM%3D\";}s:22:\"gravityformsfreshbooks\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"2.8\";s:14:\"version_latest\";s:3:\"2.8\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/freshbooks/gravityformsfreshbooks_2.8.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=lHf3yQ6ZwPEzUCfpQ3pgEvYZES4%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/freshbooks/gravityformsfreshbooks_2.8.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=lHf3yQ6ZwPEzUCfpQ3pgEvYZES4%3D\";}s:23:\"gravityformsgeolocation\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.5.0\";s:14:\"version_latest\";s:5:\"1.5.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:208:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/geolocation/gravityformsgeolocation_1.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=U8H6LGAqPDKXSIojmzRqKGv%2BOC8%3D\";s:10:\"url_latest\";s:208:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/geolocation/gravityformsgeolocation_1.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=U8H6LGAqPDKXSIojmzRqKGv%2BOC8%3D\";}s:23:\"gravityformsgetresponse\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.9.0\";s:14:\"version_latest\";s:5:\"1.9.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:206:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/getresponse/gravityformsgetresponse_1.9.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=lJ97Nz0tVi4MA0SMZSvWYnbblFs%3D\";s:10:\"url_latest\";s:206:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/getresponse/gravityformsgetresponse_1.9.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=lJ97Nz0tVi4MA0SMZSvWYnbblFs%3D\";}s:27:\"gravityformsgoogleanalytics\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.4.0\";s:14:\"version_latest\";s:5:\"2.4.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:214:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/googleanalytics/gravityformsgoogleanalytics_2.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=VG4ax9mblXtJDId3JQOHelhMFqw%3D\";s:10:\"url_latest\";s:214:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/googleanalytics/gravityformsgoogleanalytics_2.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=VG4ax9mblXtJDId3JQOHelhMFqw%3D\";}s:21:\"gravityformsgutenberg\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:10:\"1.0-rc-1.4\";s:14:\"version_latest\";s:10:\"1.0-rc-1.5\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:209:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/gutenberg/gravityformsgutenberg_1.0-rc-1.4.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=n1FFnp7O1c3fp7xM8AGRZ7HB%2BDA%3D\";s:10:\"url_latest\";s:207:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/gutenberg/gravityformsgutenberg_1.0-rc-1.5.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=3b9bWHlTWNjbyZHSirABcCM3pm0%3D\";}s:21:\"gravityformshelpscout\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.4.0\";s:14:\"version_latest\";s:7:\"2.4.0.2\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/helpscout/gravityformshelpscout_2.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=3HdvkF9KoeRiIehYFL%2FKaqgM0wk%3D\";s:10:\"url_latest\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/helpscout/gravityformshelpscout_2.4.0.2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=A2Ge7xLcVpcZc1G8LwBJE9W8HA8%3D\";}s:20:\"gravityformshighrise\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.3\";s:14:\"version_latest\";s:3:\"1.3\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/highrise/gravityformshighrise_1.3.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=nRnKhtfvghGeMEkdoV9V2qagNwg%3D\";s:10:\"url_latest\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/highrise/gravityformshighrise_1.3.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=nRnKhtfvghGeMEkdoV9V2qagNwg%3D\";}s:19:\"gravityformshipchat\";a:4:{s:12:\"is_available\";b:0;s:7:\"version\";s:3:\"1.2\";s:14:\"version_latest\";s:3:\"1.2\";s:20:\"minimum_requirements\";a:0:{}}s:19:\"gravityformshubspot\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.3.0\";s:14:\"version_latest\";s:5:\"2.3.3\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/hubspot/gravityformshubspot_2.3.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=bHR6Xx%2FRHNuAGzSJQnChuNaqtn4%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/hubspot/gravityformshubspot_2.3.3.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=4w6%2BCY78zPW%2FVJa9OdLp8MyvujI%3D\";}s:20:\"gravityformsicontact\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.0\";s:14:\"version_latest\";s:5:\"1.8.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/icontact/gravityformsicontact_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=r8kxOFcDpYr6fq5q1MVvf8p5N5E%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/icontact/gravityformsicontact_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=r8kxOFcDpYr6fq5q1MVvf8p5N5E%3D\";}s:19:\"gravityformslogging\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.3\";s:14:\"version_latest\";s:5:\"1.3.1\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/logging/gravityformslogging_1.3.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=kV1sdkT7Fa0xq%2BG%2FlRMoooWxq%2B4%3D\";s:10:\"url_latest\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/logging/gravityformslogging_1.3.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=%2B%2FftFdC%2FmYEW1gqkle8XdsfI7cQ%3D\";}s:19:\"gravityformsmadmimi\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.5.0\";s:14:\"version_latest\";s:5:\"1.5.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/madmimi/gravityformsmadmimi_1.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=xhkfN0kWKy9jRILIJsNstt8oMIA%3D\";s:10:\"url_latest\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/madmimi/gravityformsmadmimi_1.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=xhkfN0kWKy9jRILIJsNstt8oMIA%3D\";}s:21:\"gravityformsmailchimp\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"5.7.0\";s:14:\"version_latest\";s:5:\"5.7.1\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/mailchimp/gravityformsmailchimp_5.7.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=IEo606BmHXqVvKzop2FtaJOkh28%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/mailchimp/gravityformsmailchimp_5.7.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=wYHo5dg0MNw6H0zWtWOZk4jILEk%3D\";}s:22:\"gravityformsmailerlite\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.1.0\";s:14:\"version_latest\";s:5:\"1.1.1\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/mailerlite/gravityformsmailerlite_1.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=RCxhohJQ3IqTl7U3MBBaTCyzGmY%3D\";s:10:\"url_latest\";s:206:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/mailerlite/gravityformsmailerlite_1.1.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=ZNZiYj7pL6Buk3K4Ni%2FWsxgM0Zo%3D\";}s:19:\"gravityformsmailgun\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.4.0\";s:14:\"version_latest\";s:5:\"1.4.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/mailgun/gravityformsmailgun_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=c1OQekxwZMuXoIadlYApetgtFhs%3D\";s:10:\"url_latest\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/mailgun/gravityformsmailgun_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=c1OQekxwZMuXoIadlYApetgtFhs%3D\";}s:22:\"gravityformsmoderation\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.3.0\";s:14:\"version_latest\";s:5:\"1.3.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/moderation/gravityformsmoderation_1.3.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=Aug7vb0d1lku5Eh7iMXOnTAPY88%3D\";s:10:\"url_latest\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/moderation/gravityformsmoderation_1.3.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=Aug7vb0d1lku5Eh7iMXOnTAPY88%3D\";}s:18:\"gravityformsmollie\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.0\";s:14:\"version_latest\";s:5:\"1.8.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/mollie/gravityformsmollie_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=BXqtG72k015q0lxk7pnwFsccU9w%3D\";s:10:\"url_latest\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/mollie/gravityformsmollie_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=BXqtG72k015q0lxk7pnwFsccU9w%3D\";}s:26:\"gravityformspartialentries\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.0\";s:14:\"version_latest\";s:5:\"1.8.1\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:212:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/partialentries/gravityformspartialentries_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=30GzTK2nirNO1kVT3solHoA6jqE%3D\";s:10:\"url_latest\";s:212:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/partialentries/gravityformspartialentries_1.8.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=0SOxq1B7ewCCzyDJD02MvZzV4W0%3D\";}s:18:\"gravityformspaypal\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"3.5\";s:14:\"version_latest\";s:3:\"3.5\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/paypal/gravityformspaypal_3.5.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=tSbNwfCwub3MyRUjVIlzdnOioDM%3D\";s:10:\"url_latest\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/paypal/gravityformspaypal_3.5.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=tSbNwfCwub3MyRUjVIlzdnOioDM%3D\";}s:33:\"gravityformspaypalexpresscheckout\";a:3:{s:12:\"is_available\";b:0;s:7:\"version\";s:0:\"\";s:14:\"version_latest\";s:0:\"\";}s:29:\"gravityformspaypalpaymentspro\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"2.7\";s:14:\"version_latest\";s:3:\"2.7\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:216:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/paypalpaymentspro/gravityformspaypalpaymentspro_2.7.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=OZ3KYsYZf93luCkaGqfHrLKYsPA%3D\";s:10:\"url_latest\";s:216:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/paypalpaymentspro/gravityformspaypalpaymentspro_2.7.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=OZ3KYsYZf93luCkaGqfHrLKYsPA%3D\";}s:21:\"gravityformspaypalpro\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.1\";s:14:\"version_latest\";s:5:\"1.8.4\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:212:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/paypalpro/gravityformspaypalpro_1.8.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=J%2FLsxXnk%2BlW%2F2ss5%2BYHh%2BEa53mc%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/paypalpro/gravityformspaypalpro_1.8.4.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=28oPDIUM4wn8fAWA7PCa9PZ7FKo%3D\";}s:20:\"gravityformspicatcha\";a:4:{s:12:\"is_available\";b:0;s:7:\"version\";s:3:\"2.0\";s:14:\"version_latest\";s:3:\"2.0\";s:20:\"minimum_requirements\";a:0:{}}s:16:\"gravityformspipe\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.4.0\";s:14:\"version_latest\";s:5:\"1.4.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/pipe/gravityformspipe_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=a7fmIkVQY44lvnBeU4dkPS766%2BA%3D\";s:10:\"url_latest\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/pipe/gravityformspipe_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=a7fmIkVQY44lvnBeU4dkPS766%2BA%3D\";}s:17:\"gravityformspolls\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"4.4.0\";s:14:\"version_latest\";s:5:\"4.4.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/polls/gravityformspolls_4.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=BBFrmdgfs9u8Os4Due0KSvfw6Jc%3D\";s:10:\"url_latest\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/polls/gravityformspolls_4.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=BBFrmdgfs9u8Os4Due0KSvfw6Jc%3D\";}s:20:\"gravityformspostmark\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.4.0\";s:14:\"version_latest\";s:5:\"1.4.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/postmark/gravityformspostmark_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=JxLYvWpyNChDy18PpygNPGm8AKo%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/postmark/gravityformspostmark_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=JxLYvWpyNChDy18PpygNPGm8AKo%3D\";}s:16:\"gravityformsppcp\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"4.0.1\";s:14:\"version_latest\";s:5:\"4.0.1\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/ppcp/gravityformsppcp_4.0.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=I96bfcY%2FNB6XgQr08eRDuUm5smA%3D\";s:10:\"url_latest\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/ppcp/gravityformsppcp_4.0.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=I96bfcY%2FNB6XgQr08eRDuUm5smA%3D\";}s:16:\"gravityformsquiz\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"4.3.0\";s:14:\"version_latest\";s:5:\"4.3.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:192:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/quiz/gravityformsquiz_4.3.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=uxMVT4vM2iE7EDcN0uO89omYb0k%3D\";s:10:\"url_latest\";s:192:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/quiz/gravityformsquiz_4.3.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=uxMVT4vM2iE7EDcN0uO89omYb0k%3D\";}s:21:\"gravityformsrecaptcha\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.1.0\";s:14:\"version_latest\";s:5:\"2.1.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:206:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/recaptcha/gravityformsrecaptcha_2.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=%2FXYCr%2FzXAFR6Gjoj91QaPDumMNs%3D\";s:10:\"url_latest\";s:206:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/recaptcha/gravityformsrecaptcha_2.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=%2FXYCr%2FzXAFR6Gjoj91QaPDumMNs%3D\";}s:19:\"gravityformsrestapi\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:10:\"2.0-beta-2\";s:14:\"version_latest\";s:10:\"2.0-beta-2\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:203:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/restapi/gravityformsrestapi_2.0-beta-2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=xl5dQ3dAEnyaDzOpyw5rNc0l8fo%3D\";s:10:\"url_latest\";s:203:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/restapi/gravityformsrestapi_2.0-beta-2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=xl5dQ3dAEnyaDzOpyw5rNc0l8fo%3D\";}s:22:\"gravityformssalesforce\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.1.0\";s:14:\"version_latest\";s:5:\"1.1.1\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:206:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/salesforce/gravityformssalesforce_1.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=USGdTul0z%2FkeA3ogfYYRg2AIkkI%3D\";s:10:\"url_latest\";s:208:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/salesforce/gravityformssalesforce_1.1.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=wU6Fl%2FtCdOIBKPhq1q9w%2FF2xq4Q%3D\";}s:20:\"gravityformssendgrid\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.6.0\";s:14:\"version_latest\";s:5:\"1.6.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/sendgrid/gravityformssendgrid_1.6.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=Vrbt5Xtbnw6Fr4v%2FFzvrJOYYrgs%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/sendgrid/gravityformssendgrid_1.6.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=Vrbt5Xtbnw6Fr4v%2FFzvrJOYYrgs%3D\";}s:21:\"gravityformssignature\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"4.9.0\";s:14:\"version_latest\";s:5:\"4.9.1\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:206:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/signature/gravityformssignature_4.9.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=FRpt%2Fh87PcnbNwXyGWF9CLg%2BoLM%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/signature/gravityformssignature_4.9.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=kkGJcfZIjXt1EvyR1G9DLdbEMOQ%3D\";}s:17:\"gravityformsslack\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.2.0\";s:14:\"version_latest\";s:5:\"2.2.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/slack/gravityformsslack_2.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=KjOnOt9sqpfHJsSg8JV%2BDLSJ%2BMo%3D\";s:10:\"url_latest\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/slack/gravityformsslack_2.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=KjOnOt9sqpfHJsSg8JV%2BDLSJ%2BMo%3D\";}s:18:\"gravityformssquare\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.5.1\";s:14:\"version_latest\";s:5:\"2.5.1\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/square/gravityformssquare_2.5.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=YXG5lK8RWhbESn%2BwJhDruuZ2wQ4%3D\";s:10:\"url_latest\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/square/gravityformssquare_2.5.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=YXG5lK8RWhbESn%2BwJhDruuZ2wQ4%3D\";}s:18:\"gravityformsstripe\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:7:\"6.0.1.0\";s:14:\"version_latest\";s:7:\"6.0.1.1\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/stripe/gravityformsstripe_6.0.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=Vd%2FZWtgNkGznUlML2qkbC3%2BN2d4%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/stripe/gravityformsstripe_6.0.1.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=PD12JH0Nh8zZLsq%2B%2By6ddo0K9HA%3D\";}s:18:\"gravityformssurvey\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"4.2.1\";s:14:\"version_latest\";s:5:\"4.2.2\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/survey/gravityformssurvey_4.2.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=wiyPn6BAn1OAalHY96f%2BIPi2q8A%3D\";s:10:\"url_latest\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/survey/gravityformssurvey_4.2.2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=gUCCqZJDkqEToB34tp2kMx5A4UA%3D\";}s:18:\"gravityformstrello\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.2.0\";s:14:\"version_latest\";s:7:\"2.2.0.2\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/trello/gravityformstrello_2.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=Do1JTsxFmoWMZnBBO7%2BmFn1q2g8%3D\";s:10:\"url_latest\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/trello/gravityformstrello_2.2.0.2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=DSMM3KFaXju%2Bw%2F%2BOSX0vQmGAzEg%3D\";}s:21:\"gravityformsturnstile\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.4.0\";s:14:\"version_latest\";s:5:\"1.4.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/turnstile/gravityformsturnstile_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=Kcfrrl8AJJO9WygdMTdfzv23SB0%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/turnstile/gravityformsturnstile_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=Kcfrrl8AJJO9WygdMTdfzv23SB0%3D\";}s:18:\"gravityformstwilio\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"3.1.0\";s:14:\"version_latest\";s:5:\"3.1.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/twilio/gravityformstwilio_3.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=xZ45MRXVi4NDf5SKm1PAR2kMupQ%3D\";s:10:\"url_latest\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/twilio/gravityformstwilio_3.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=xZ45MRXVi4NDf5SKm1PAR2kMupQ%3D\";}s:28:\"gravityformsuserregistration\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"5.4.0\";s:14:\"version_latest\";s:5:\"5.4.1\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:218:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/userregistration/gravityformsuserregistration_5.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=eCxTMQ8Bqs5vdfxj%2BPgdubFCqRY%3D\";s:10:\"url_latest\";s:216:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/userregistration/gravityformsuserregistration_5.4.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=FJIR9L3tgxh8Zaqvo8dckns31Ow%3D\";}s:20:\"gravityformswebhooks\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.7.0\";s:14:\"version_latest\";s:5:\"1.7.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/webhooks/gravityformswebhooks_1.7.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=uOmL9Mbn2rvdlJ5lXCVyIxNbdTg%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/webhooks/gravityformswebhooks_1.7.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=uOmL9Mbn2rvdlJ5lXCVyIxNbdTg%3D\";}s:18:\"gravityformszapier\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"4.5.1\";s:14:\"version_latest\";s:5:\"4.5.1\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/zapier/gravityformszapier_4.5.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=wMWgRtNydasmLXtejUrFRZuwzGE%3D\";s:10:\"url_latest\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/zapier/gravityformszapier_4.5.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=wMWgRtNydasmLXtejUrFRZuwzGE%3D\";}s:19:\"gravityformszohocrm\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.4.0\";s:14:\"version_latest\";s:7:\"2.4.0.2\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/zohocrm/gravityformszohocrm_2.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=O4k8RsW5bT56FalopuvDV6ljUJQ%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/zohocrm/gravityformszohocrm_2.4.0.2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=bxLa3GfdeAGza2tSDM%2B7KrUtTP0%3D\";}s:11:\"gravitysmtp\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.1.1\";s:14:\"version_latest\";s:5:\"2.1.1\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:183:\"https://s3.dualstack.us-east-1.amazonaws.com/gravitysmtp/releases/gravitysmtp_2.1.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=C2hvb62s9WRi6Ak159QxGLkQoC0%3D\";s:10:\"url_latest\";s:183:\"https://s3.dualstack.us-east-1.amazonaws.com/gravitysmtp/releases/gravitysmtp_2.1.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=C2hvb62s9WRi6Ak159QxGLkQoC0%3D\";}s:7:\"testing\";a:4:{s:12:\"is_available\";b:0;s:7:\"version\";s:0:\"\";s:14:\"version_latest\";s:5:\"1.www\";s:20:\"minimum_requirements\";a:0:{}}}s:9:\"is_active\";s:1:\"1\";s:12:\"product_code\";s:7:\"GFELITE\";s:12:\"date_created\";s:19:\"2018-03-08 20:12:50\";s:14:\"version_latest\";s:6:\"2.9.24\";s:10:\"url_latest\";s:186:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/releases/gravityforms_2.9.24.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765635620&Signature=xmk4v7Xh2R3TegJ7jYz62pRxhEQ%3D\";s:9:\"timestamp\";i:1765462820;}", "off");
INSERT INTO `wp_options` VALUES("212", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("214", "wpseo", "a:120:{s:8:\"tracking\";b:0;s:16:\"toggled_tracking\";b:0;s:22:\"license_server_version\";s:1:\"2\";s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:1;s:19:\"indexing_first_time\";b:1;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:23:\"home_url_option_changed\";s:29:\"indexables_indexing_completed\";b:1;s:13:\"index_now_key\";s:0:\"\";s:7:\"version\";s:4:\"26.5\";s:16:\"previous_version\";s:4:\"25.8\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:0;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:12:\"ahrefsverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:34:\"inclusive_language_analysis_active\";b:0;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:16:\"enable_index_now\";b:1;s:19:\"enable_ai_generator\";b:1;s:22:\"ai_enabled_pre_default\";b:0;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";s:10:\"1581422137\";s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:12:\"/%postname%/\";s:8:\"home_url\";s:27:\"http://roxus.levoengage.com\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:2:{s:12:\"template_tag\";s:12:\"template_tag\";s:15:\"template_bundle\";s:15:\"template_bundle\";}s:29:\"enable_enhanced_slack_sharing\";b:1;s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;s:14:\"import_cursors\";a:0:{}s:13:\"workouts_data\";a:1:{s:13:\"configuration\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:28:\"configuration_finished_steps\";a:0:{}s:36:\"dismiss_configuration_workout_notice\";b:0;s:34:\"dismiss_premium_deactivated_notice\";b:0;s:19:\"importing_completed\";a:0:{}s:26:\"wincher_integration_active\";b:1;s:14:\"wincher_tokens\";a:0:{}s:36:\"wincher_automatically_add_keyphrases\";b:0;s:18:\"wincher_website_id\";s:0:\"\";s:18:\"first_time_install\";b:0;s:34:\"should_redirect_after_install_free\";b:0;s:34:\"activation_redirect_timestamp_free\";s:10:\"1652258756\";s:18:\"remove_feed_global\";b:0;s:27:\"remove_feed_global_comments\";b:1;s:25:\"remove_feed_post_comments\";b:0;s:19:\"remove_feed_authors\";b:1;s:22:\"remove_feed_categories\";b:1;s:16:\"remove_feed_tags\";b:1;s:29:\"remove_feed_custom_taxonomies\";b:1;s:22:\"remove_feed_post_types\";b:1;s:18:\"remove_feed_search\";b:1;s:21:\"remove_atom_rdf_feeds\";b:1;s:17:\"remove_shortlinks\";b:1;s:21:\"remove_rest_api_links\";b:1;s:20:\"remove_rsd_wlw_links\";b:1;s:19:\"remove_oembed_links\";b:1;s:16:\"remove_generator\";b:1;s:20:\"remove_emoji_scripts\";b:1;s:24:\"remove_powered_by_header\";b:1;s:22:\"remove_pingback_header\";b:1;s:28:\"clean_campaign_tracking_urls\";b:0;s:16:\"clean_permalinks\";b:0;s:32:\"clean_permalinks_extra_variables\";s:0:\"\";s:14:\"search_cleanup\";b:0;s:20:\"search_cleanup_emoji\";b:0;s:23:\"search_cleanup_patterns\";b:0;s:22:\"search_character_limit\";i:50;s:20:\"deny_search_crawling\";b:0;s:21:\"deny_wp_json_crawling\";b:1;s:20:\"deny_adsbot_crawling\";b:0;s:19:\"deny_ccbot_crawling\";b:0;s:29:\"deny_google_extended_crawling\";b:0;s:20:\"deny_gptbot_crawling\";b:0;s:27:\"redirect_search_pretty_urls\";b:0;s:29:\"least_readability_ignore_list\";a:0:{}s:27:\"least_seo_score_ignore_list\";a:0:{}s:23:\"most_linked_ignore_list\";a:0:{}s:24:\"least_linked_ignore_list\";a:0:{}s:28:\"indexables_page_reading_list\";a:5:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;}s:25:\"indexables_overview_state\";s:21:\"dashboard-not-visited\";s:28:\"last_known_public_post_types\";a:3:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:15:\"bricks_template\";}s:28:\"last_known_public_taxonomies\";a:4:{i:0;s:8:\"category\";i:1;s:8:\"post_tag\";i:2;s:12:\"template_tag\";i:3;s:15:\"template_bundle\";}s:23:\"last_known_no_unindexed\";a:6:{s:27:\"wpseo_total_unindexed_posts\";i:1765474233;s:27:\"wpseo_total_unindexed_terms\";i:1765474233;s:40:\"wpseo_total_unindexed_post_type_archives\";i:1765463771;s:35:\"wpseo_total_unindexed_general_items\";i:1765383725;s:31:\"wpseo_unindexed_post_link_count\";i:1765462874;s:31:\"wpseo_unindexed_term_link_count\";i:1765463771;}s:14:\"new_post_types\";a:1:{i:2;s:15:\"bricks_template\";}s:14:\"new_taxonomies\";a:2:{i:2;s:12:\"template_tag\";i:3;s:15:\"template_bundle\";}s:34:\"show_new_content_type_notification\";b:0;s:44:\"site_kit_configuration_permanently_dismissed\";b:0;s:18:\"site_kit_connected\";b:0;s:37:\"site_kit_tracking_setup_widget_loaded\";s:2:\"no\";s:41:\"site_kit_tracking_first_interaction_stage\";s:0:\"\";s:40:\"site_kit_tracking_last_interaction_stage\";s:0:\"\";s:52:\"site_kit_tracking_setup_widget_temporarily_dismissed\";s:2:\"no\";s:52:\"site_kit_tracking_setup_widget_permanently_dismissed\";s:2:\"no\";s:31:\"google_site_kit_feature_enabled\";b:0;s:25:\"ai_free_sparks_started_on\";N;s:15:\"enable_llms_txt\";b:0;s:15:\"last_updated_on\";i:1764945201;s:17:\"default_seo_title\";a:0:{}s:21:\"default_seo_meta_desc\";a:0:{}s:18:\"first_activated_by\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("215", "wpseo_titles", "a:171:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:1;s:12:\"disable-date\";b:1;s:19:\"disable-post_format\";b:1;s:18:\"disable-attachment\";b:1;s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:22:\"company_alternate_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:24:\"publishing_principles_id\";i:0;s:25:\"ownership_funding_info_id\";i:0;s:29:\"actionable_feedback_policy_id\";i:0;s:21:\"corrections_policy_id\";i:0;s:16:\"ethics_policy_id\";i:0;s:19:\"diversity_policy_id\";i:0;s:28:\"diversity_staffing_report_id\";i:0;s:15:\"org-description\";s:0:\"\";s:9:\"org-email\";s:0:\"\";s:9:\"org-phone\";s:0:\"\";s:14:\"org-legal-name\";s:0:\"\";s:17:\"org-founding-date\";s:0:\"\";s:20:\"org-number-employees\";s:0:\"\";s:10:\"org-vat-id\";s:0:\"\";s:10:\"org-tax-id\";s:0:\"\";s:7:\"org-iso\";s:0:\"\";s:8:\"org-duns\";s:0:\"\";s:11:\"org-leicode\";s:0:\"\";s:9:\"org-naics\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:1;s:25:\"social-title-tax-category\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:26:\"taxonomy-category-ptparent\";i:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:1;s:25:\"social-title-tax-post_tag\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:26:\"taxonomy-post_tag-ptparent\";i:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:23:\"%%term_title%% Archives\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:29:\"taxonomy-post_format-ptparent\";i:0;s:21:\"title-tax-post_series\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_series\";s:0:\"\";s:31:\"display-metabox-tax-post_series\";b:1;s:23:\"noindex-tax-post_series\";b:1;s:28:\"social-title-tax-post_series\";s:23:\"%%term_title%% Archives\";s:34:\"social-description-tax-post_series\";s:0:\"\";s:32:\"social-image-url-tax-post_series\";s:0:\"\";s:31:\"social-image-id-tax-post_series\";i:0;s:29:\"taxonomy-post_series-ptparent\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:0;s:29:\"open_graph_frontpage_image_id\";i:0;s:15:\"title-portfolio\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:18:\"metadesc-portfolio\";s:0:\"\";s:17:\"noindex-portfolio\";s:5:\"false\";s:28:\"display-metabox-pt-portfolio\";s:4:\"true\";s:28:\"post_types-portfolio-maintax\";s:1:\"0\";s:11:\"title-staff\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:14:\"metadesc-staff\";s:0:\"\";s:13:\"noindex-staff\";s:5:\"false\";s:24:\"display-metabox-pt-staff\";s:4:\"true\";s:24:\"post_types-staff-maintax\";s:1:\"0\";s:18:\"title-testimonials\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-testimonials\";s:0:\"\";s:20:\"noindex-testimonials\";s:5:\"false\";s:31:\"display-metabox-pt-testimonials\";s:4:\"true\";s:31:\"post_types-testimonials-maintax\";s:1:\"0\";s:23:\"title-tax-portfolio_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-tax-portfolio_tag\";s:0:\"\";s:25:\"noindex-tax-portfolio_tag\";s:5:\"false\";s:31:\"taxonomy-portfolio_tag-ptparent\";s:1:\"0\";s:28:\"title-tax-portfolio_category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:31:\"metadesc-tax-portfolio_category\";s:0:\"\";s:30:\"noindex-tax-portfolio_category\";s:5:\"false\";s:36:\"taxonomy-portfolio_category-ptparent\";s:1:\"0\";s:19:\"title-tax-staff_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:22:\"metadesc-tax-staff_tag\";s:0:\"\";s:21:\"noindex-tax-staff_tag\";s:5:\"false\";s:27:\"taxonomy-staff_tag-ptparent\";s:1:\"0\";s:24:\"title-tax-staff_category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:27:\"metadesc-tax-staff_category\";s:0:\"\";s:26:\"noindex-tax-staff_category\";s:5:\"false\";s:32:\"taxonomy-staff_category-ptparent\";s:1:\"0\";s:31:\"title-tax-testimonials_category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:34:\"metadesc-tax-testimonials_category\";s:0:\"\";s:33:\"noindex-tax-testimonials_category\";s:5:\"false\";s:39:\"taxonomy-testimonials_category-ptparent\";s:1:\"0\";}", "yes");
INSERT INTO `wp_options` VALUES("216", "wpseo_social", "a:18:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("217", "wpseo_flush_rewrite", "1", "yes");
INSERT INTO `wp_options` VALUES("227", "vc_version", "8.0.1", "yes");
INSERT INTO `wp_options` VALUES("234", "templatera_migrated_templates", "yes", "yes");
INSERT INTO `wp_options` VALUES("235", "widget_wpex_templatera", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("238", "gf_zapier_version", "3.3", "yes");
INSERT INTO `wp_options` VALUES("243", "mk_te_settings_options", "a:5:{s:7:\"e_d_t_e\";s:3:\"yes\";s:17:\"code_editor_theme\";s:6:\"cobalt\";s:9:\"e_w_d_t_e\";s:3:\"yes\";s:7:\"e_d_p_e\";s:3:\"yes\";s:9:\"e_w_d_p_e\";s:3:\"yes\";}", "yes");
INSERT INTO `wp_options` VALUES("247", "duplicate_post_copytitle", "1", "yes");
INSERT INTO `wp_options` VALUES("248", "duplicate_post_copydate", "", "yes");
INSERT INTO `wp_options` VALUES("249", "duplicate_post_copystatus", "", "yes");
INSERT INTO `wp_options` VALUES("250", "duplicate_post_copyslug", "", "yes");
INSERT INTO `wp_options` VALUES("251", "duplicate_post_copyexcerpt", "1", "yes");
INSERT INTO `wp_options` VALUES("252", "duplicate_post_copycontent", "1", "yes");
INSERT INTO `wp_options` VALUES("253", "duplicate_post_copythumbnail", "1", "yes");
INSERT INTO `wp_options` VALUES("254", "duplicate_post_copytemplate", "1", "yes");
INSERT INTO `wp_options` VALUES("255", "duplicate_post_copyformat", "1", "yes");
INSERT INTO `wp_options` VALUES("256", "duplicate_post_copyauthor", "", "yes");
INSERT INTO `wp_options` VALUES("257", "duplicate_post_copypassword", "", "yes");
INSERT INTO `wp_options` VALUES("258", "duplicate_post_copyattachments", "", "yes");
INSERT INTO `wp_options` VALUES("259", "duplicate_post_copychildren", "", "yes");
INSERT INTO `wp_options` VALUES("260", "duplicate_post_copycomments", "", "yes");
INSERT INTO `wp_options` VALUES("261", "duplicate_post_copymenuorder", "1", "yes");
INSERT INTO `wp_options` VALUES("262", "duplicate_post_taxonomies_blacklist", "", "yes");
INSERT INTO `wp_options` VALUES("263", "duplicate_post_blacklist", "", "yes");
INSERT INTO `wp_options` VALUES("264", "duplicate_post_types_enabled", "a:3:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:7:\"ptu_tax\";}", "yes");
INSERT INTO `wp_options` VALUES("269", "duplicate_post_show_original_column", "", "yes");
INSERT INTO `wp_options` VALUES("270", "duplicate_post_show_original_in_post_states", "", "yes");
INSERT INTO `wp_options` VALUES("271", "duplicate_post_show_original_meta_box", "", "yes");
INSERT INTO `wp_options` VALUES("277", "redirection_options", "a:27:{s:7:\"support\";b:0;s:5:\"token\";s:32:\"a82f7630b65daee77da8f82d1de5e562\";s:12:\"monitor_post\";i:1;s:13:\"monitor_types\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:19:\"associated_redirect\";s:0:\"\";s:11:\"auto_target\";s:0:\"\";s:15:\"expire_redirect\";i:7;s:10:\"expire_404\";i:7;s:7:\"modules\";a:0:{}s:10:\"newsletter\";b:0;s:14:\"redirect_cache\";i:1;s:10:\"ip_logging\";i:1;s:13:\"last_group_id\";i:1;s:8:\"rest_api\";i:0;s:5:\"https\";b:0;s:7:\"headers\";a:0:{}s:8:\"database\";s:3:\"4.2\";s:10:\"flag_query\";s:5:\"exact\";s:9:\"flag_case\";b:0;s:13:\"flag_trailing\";b:0;s:10:\"flag_regex\";b:0;s:12:\"log_external\";b:0;s:10:\"log_header\";b:0;s:10:\"track_hits\";b:1;s:8:\"relocate\";s:0:\"\";s:16:\"preferred_domain\";s:0:\"\";s:7:\"aliases\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("280", "gf_zero_spam_key", "5dei7pZAyVdFgSrSZRkX6PXUY8rWMBUilLsfeDpA1Un27raaaW9g9t864DImXAgz", "no");
INSERT INTO `wp_options` VALUES("444", "theme_editor_email_verified_1", "yes", "yes");
INSERT INTO `wp_options` VALUES("715", "wpb_js_composer_license_activation_notified", "yes", "yes");
INSERT INTO `wp_options` VALUES("723", "theme_mods_Levo Theme", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1581441947;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";}s:7:\"sidebar\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:13:\"pages_sidebar\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:14:\"search_sidebar\";a:0:{}s:20:\"testimonials_sidebar\";a:0:{}s:10:\"footer_one\";a:0:{}s:10:\"footer_two\";a:0:{}s:12:\"footer_three\";a:0:{}s:11:\"footer_four\";a:0:{}}}}", "off");
INSERT INTO `wp_options` VALUES("820", "revslider-connection", "1", "yes");
INSERT INTO `wp_options` VALUES("821", "revslider-latest-version", "6.5.20", "yes");
INSERT INTO `wp_options` VALUES("822", "revslider-stable-version", "4.2.0", "yes");
INSERT INTO `wp_options` VALUES("823", "revslider-notices", "a:1:{i:0;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"9.9.9\";s:4:\"text\";s:546:\"<div style=\"display: block; background: #fff;text-align: center; height: 250px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 960px; height: 250px; display: inline-block;\" muted=\"\" loop=\"\" autoplay=\"\" preload=\"auto\"><source src=\"https://sliderrevolution.com/wp-content/uploads/2021/07/adminpremiumvid4.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:12:\"TPRSV6511-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("824", "revslider-dashboard", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("825", "revslider-addons", "O:8:\"stdClass\":29:{s:25:\"revslider-particles-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"60\";s:9:\"releaseid\";s:1:\"7\";s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"2.1.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:2:\"10\";s:11:\"last_update\";s:10:\"2020-08-13\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_particles.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"74\";s:9:\"releaseid\";s:2:\"20\";s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"2.2.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"20\";s:11:\"last_update\";s:10:\"2020-10-30\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"68\";s:9:\"releaseid\";s:2:\"15\";s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"2.0.8\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"40\";s:11:\"last_update\";s:10:\"2020-10-17\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_beforeafter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"56\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"5.3.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:2:\"50\";s:11:\"last_update\";s:10:\"2020-06-18\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_typewriter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"307\";s:9:\"releaseid\";s:2:\"24\";s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:6:\"6.2.23\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"2.0.8\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"60\";s:11:\"last_update\";s:10:\"2020-10-15\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_mousetrap.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"75\";s:9:\"releaseid\";s:2:\"21\";s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"2.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"70\";s:11:\"last_update\";s:10:\"2020-05-05\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_distortion.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"77\";s:9:\"releaseid\";s:2:\"23\";s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"2.1.9\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"90\";s:11:\"last_update\";s:10:\"2020-06-14\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_paintbrush.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"311\";s:9:\"releaseid\";s:2:\"13\";s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"2.0.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"110\";s:11:\"last_update\";s:10:\"2020-05-05\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_slicey.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"64\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"2.0.4\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"125\";s:11:\"last_update\";s:10:\"2021-01-05\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_filmstrip.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"58\";s:9:\"releaseid\";s:1:\"4\";s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"5.3.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"2.1.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"127\";s:11:\"last_update\";s:10:\"2020-12-15\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:84:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_underconstruction.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"72\";s:9:\"releaseid\";s:2:\"19\";s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"2.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"130\";s:11:\"last_update\";s:10:\"2020-01-01\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_reveal.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"70\";s:9:\"releaseid\";s:2:\"17\";s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:7:\"5.4.5.2\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"2.1.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"135\";s:11:\"last_update\";s:10:\"2020-10-07\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:75:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_panorama.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"310\";s:9:\"releaseid\";s:2:\"26\";s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.3.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"2.0.4\";s:10:\"background\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"140\";s:11:\"last_update\";s:10:\"2021-02-24\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"76\";s:9:\"releaseid\";s:2:\"22\";s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"2.1.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"150\";s:11:\"last_update\";s:10:\"2020-07-16\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_exploding.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"57\";s:9:\"releaseid\";s:1:\"5\";s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"5.3.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"165\";s:11:\"last_update\";s:10:\"2020-02-20\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:80:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_socialsharing.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:3:\"308\";s:9:\"releaseid\";s:1:\"1\";s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"2.2.3\";s:10:\"background\";s:81:\"//updates.themepunch-ext-b.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"170\";s:11:\"last_update\";s:10:\"2021-01-15\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_whiteboard.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"61\";s:9:\"releaseid\";s:2:\"14\";s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"2.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"180\";s:11:\"last_update\";s:10:\"2020-01-01\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:75:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_polyfold.jpg\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"78\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"300\";s:11:\"last_update\";s:10:\"2020-02-19\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:79:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_domainswitch.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"73\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"2.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"330\";s:11:\"last_update\";s:10:\"2020-01-01\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_reload.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"55\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"340\";s:11:\"last_update\";s:10:\"2021-06-12\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wprelated.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"59\";s:9:\"releaseid\";s:1:\"6\";s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"2.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"380\";s:11:\"last_update\";s:10:\"2020-12-04\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:71:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_snow.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"54\";s:9:\"releaseid\";s:1:\"2\";s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"430\";s:11:\"last_update\";s:10:\"2020-12-04\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpgallery.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"53\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"500\";s:11:\"last_update\";s:10:\"2020-12-04\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_backup.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"62\";s:9:\"releaseid\";s:1:\"8\";s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"620\";s:11:\"last_update\";s:10:\"2020-12-04\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:70:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_404.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"63\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"630\";s:11:\"last_update\";s:10:\"2020-12-04\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"65\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"650\";s:11:\"last_update\";s:10:\"2020-12-04\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:72:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_login.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"66\";s:9:\"releaseid\";s:2:\"12\";s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"660\";s:11:\"last_update\";s:10:\"2020-12-04\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"69\";s:9:\"releaseid\";s:2:\"16\";s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:7:\"5.4.5.2\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"690\";s:11:\"last_update\";s:10:\"2020-12-04\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_weather.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":15:{s:2:\"id\";s:2:\"71\";s:9:\"releaseid\";s:2:\"18\";s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"2.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"710\";s:11:\"last_update\";s:10:\"2020-01-01\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_duotone.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}}}", "yes");
INSERT INTO `wp_options` VALUES("974", "theme_mods_Total", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1583494490;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";}s:7:\"sidebar\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:13:\"pages_sidebar\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:14:\"search_sidebar\";a:0:{}s:20:\"testimonials_sidebar\";a:0:{}s:10:\"footer_one\";a:0:{}s:10:\"footer_two\";a:0:{}s:12:\"footer_three\";a:0:{}s:11:\"footer_four\";a:0:{}}}}", "off");
INSERT INTO `wp_options` VALUES("997", "theme_mods_total-child-theme", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1583484996;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";}s:7:\"sidebar\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:13:\"pages_sidebar\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:14:\"search_sidebar\";a:0:{}s:20:\"testimonials_sidebar\";a:0:{}s:10:\"footer_one\";a:0:{}s:10:\"footer_two\";a:0:{}s:12:\"footer_three\";a:0:{}s:11:\"footer_four\";a:0:{}}}}", "off");
INSERT INTO `wp_options` VALUES("1146", "theme_mods_levo-theme", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1583494284;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";}s:7:\"sidebar\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:13:\"pages_sidebar\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:14:\"search_sidebar\";a:0:{}s:20:\"testimonials_sidebar\";a:0:{}s:10:\"footer_one\";a:0:{}s:10:\"footer_two\";a:0:{}s:12:\"footer_three\";a:0:{}s:11:\"footer_four\";a:0:{}}}}", "off");
INSERT INTO `wp_options` VALUES("1489", "ms_child_theme_editor_configvars", "a:38:{s:8:\"addl_css\";N;s:8:\"forcedep\";N;s:8:\"cssunreg\";N;s:9:\"csswphead\";N;s:10:\"cssnotheme\";N;s:7:\"reorder\";N;s:10:\"parnt_deps\";N;s:10:\"child_deps\";a:2:{i:0;s:10:\"wpex-style\";i:1;s:20:\"wpex-visual-composer\";}s:9:\"hasstyles\";i:1;s:11:\"parntloaded\";N;s:11:\"childloaded\";N;s:11:\"ignoreparnt\";N;s:9:\"qpriority\";i:10;s:7:\"enqueue\";s:7:\"enqueue\";s:8:\"handling\";s:7:\"primary\";s:9:\"templates\";a:245:{i:0;s:10:\"footer.php\";i:1;s:12:\"singular.php\";i:2;s:14:\"author-bio.php\";i:3;s:15:\"woocommerce.php\";i:4;s:28:\"single-elementor_library.php\";i:5;s:7:\"404.php\";i:6;s:12:\"comments.php\";i:7;s:9:\"index.php\";i:8;s:21:\"single-templatera.php\";i:9;s:8:\"page.php\";i:10;s:10:\"search.php\";i:11;s:11:\"sidebar.php\";i:12;s:14:\"searchform.php\";i:13;s:10:\"header.php\";i:14;s:14:\"attachment.php\";i:15;s:27:\"templates/right-sidebar.php\";i:16;s:19:\"templates/login.php\";i:17;s:24:\"templates/no-sidebar.php\";i:18;s:26:\"templates/landing-page.php\";i:19;s:18:\"templates/blog.php\";i:20;s:32:\"templates/blog-content-above.php\";i:21;s:26:\"templates/left-sidebar.php\";i:22;s:33:\"tribe-events/default-template.php\";i:23;s:26:\"vc_templates/vc_column.php\";i:24;s:23:\"vc_templates/vc_row.php\";i:25;s:27:\"vc_templates/vc_section.php\";i:26;s:22:\"partials/post-edit.php\";i:27;s:30:\"partials/page-single-share.php\";i:28;s:30:\"partials/page-single-title.php\";i:29;s:33:\"partials/page-single-comments.php\";i:30;s:25:\"partials/social-share.php\";i:31;s:22:\"partials/next-prev.php\";i:32;s:23:\"partials/scroll-top.php\";i:33;s:31:\"partials/page-single-layout.php\";i:34;s:29:\"partials/term-description.php\";i:35;s:30:\"partials/page-header-title.php\";i:36;s:35:\"partials/page-header-subheading.php\";i:37;s:30:\"partials/page-single-media.php\";i:38;s:24:\"partials/page-header.php\";i:39;s:37:\"partials/password-protection-form.php\";i:40;s:24:\"partials/post-series.php\";i:41;s:32:\"partials/page-single-content.php\";i:42;s:24:\"partials/breadcrumbs.php\";i:43;s:23:\"partials/link-pages.php\";i:44;s:24:\"partials/post-slider.php\";i:45;s:34:\"partials/footer/footer-widgets.php\";i:46;s:38:\"partials/footer/footer-reveal-open.php\";i:47;s:33:\"partials/footer/footer-layout.php\";i:48;s:39:\"partials/footer/footer-reveal-close.php\";i:49;s:33:\"partials/footer/footer-bottom.php\";i:50;s:34:\"partials/footer/footer-builder.php\";i:51;s:34:\"partials/footer/footer-callout.php\";i:52;s:38:\"partials/footer/footer-bottom-menu.php\";i:53;s:43:\"partials/footer/footer-bottom-copyright.php\";i:54;s:51:\"partials/testimonials/testimonials-entry-avatar.php\";i:55;s:51:\"partials/testimonials/testimonials-entry-rating.php\";i:56;s:51:\"partials/testimonials/testimonials-entry-author.php\";i:57;s:49:\"partials/testimonials/testimonials-entry-meta.php\";i:58;s:52:\"partials/testimonials/testimonials-entry-company.php\";i:59;s:52:\"partials/testimonials/testimonials-entry-content.php\";i:60;s:52:\"partials/testimonials/testimonials-single-layout.php\";i:61;s:44:\"partials/testimonials/testimonials-entry.php\";i:62;s:34:\"partials/topbar/topbar-content.php\";i:63;s:33:\"partials/topbar/topbar-social.php\";i:64;s:31:\"partials/topbar/topbar-menu.php\";i:65;s:33:\"partials/topbar/topbar-layout.php\";i:66;s:30:\"partials/cart/cart-overlay.php\";i:67;s:31:\"partials/cart/cart-dropdown.php\";i:68;s:40:\"partials/togglebar/togglebar-content.php\";i:69;s:39:\"partials/togglebar/togglebar-layout.php\";i:70;s:39:\"partials/togglebar/togglebar-button.php\";i:71;s:30:\"partials/loop/loop-product.php\";i:72;s:29:\"partials/loop/loop-bottom.php\";i:73;s:32:\"partials/loop/loop-portfolio.php\";i:74;s:28:\"partials/loop/loop-staff.php\";i:75;s:32:\"partials/loop/loop-top-staff.php\";i:76;s:31:\"partials/loop/loop-top-blog.php\";i:77;s:26:\"partials/loop/loop-top.php\";i:78;s:34:\"partials/loop/loop-top-product.php\";i:79;s:35:\"partials/loop/loop-testimonials.php\";i:80;s:39:\"partials/loop/loop-top-testimonials.php\";i:81;s:27:\"partials/loop/loop-blog.php\";i:82;s:37:\"partials/loop/loop-bottom-product.php\";i:83;s:36:\"partials/loop/loop-top-portfolio.php\";i:84;s:22:\"partials/loop/loop.php\";i:85;s:34:\"partials/loop/loop-bottom-blog.php\";i:86;s:22:\"partials/meta/meta.php\";i:87;s:44:\"partials/portfolio/portfolio-single-meta.php\";i:88;s:45:\"partials/portfolio/portfolio-single-media.php\";i:89;s:47:\"partials/portfolio/portfolio-single-related.php\";i:90;s:38:\"partials/portfolio/portfolio-entry.php\";i:91;s:44:\"partials/portfolio/portfolio-entry-title.php\";i:92;s:45:\"partials/portfolio/portfolio-single-share.php\";i:93;s:46:\"partials/portfolio/portfolio-single-layout.php\";i:94;s:47:\"partials/portfolio/portfolio-single-content.php\";i:95;s:46:\"partials/portfolio/portfolio-entry-content.php\";i:96;s:45:\"partials/portfolio/portfolio-single-title.php\";i:97;s:48:\"partials/portfolio/portfolio-single-comments.php\";i:98;s:44:\"partials/portfolio/portfolio-entry-media.php\";i:99;s:47:\"partials/portfolio/portfolio-single-gallery.php\";i:100;s:46:\"partials/portfolio/portfolio-entry-excerpt.php\";i:101;s:44:\"partials/header/header-menu-mobile-icons.php\";i:102;s:37:\"partials/header/header-logo-inner.php\";i:103;s:31:\"partials/header/header-logo.php\";i:104;s:31:\"partials/header/header-menu.php\";i:105;s:48:\"partials/header/header-menu-mobile-fixed-top.php\";i:106;s:33:\"partials/header/header-layout.php\";i:107;s:45:\"partials/header/header-menu-mobile-navbar.php\";i:108;s:32:\"partials/header/header-aside.php\";i:109;s:42:\"partials/header/header-menu-mobile-alt.php\";i:110;s:34:\"partials/header/header-builder.php\";i:111;s:34:\"partials/header/header-buttons.php\";i:112;s:41:\"partials/search/header-search-replace.php\";i:113;s:40:\"partials/search/search-entry-excerpt.php\";i:114;s:37:\"partials/search/search-no-results.php\";i:115;s:37:\"partials/search/mobile-searchform.php\";i:116;s:39:\"partials/search/search-entry-header.php\";i:117;s:41:\"partials/search/header-search-overlay.php\";i:118;s:32:\"partials/search/search-entry.php\";i:119;s:42:\"partials/search/search-entry-thumbnail.php\";i:120;s:42:\"partials/search/header-search-dropdown.php\";i:121;s:34:\"partials/blog/blog-single-tags.php\";i:122;s:35:\"partials/blog/blog-single-title.php\";i:123;s:43:\"partials/blog/blog-single-related-entry.php\";i:124;s:36:\"partials/blog/blog-single-series.php\";i:125;s:42:\"partials/blog/blog-entry-category-tags.php\";i:126;s:36:\"partials/blog/blog-entry-content.php\";i:127;s:45:\"partials/blog/blog-single-related-heading.php\";i:128;s:37:\"partials/blog/blog-entry-readmore.php\";i:129;s:33:\"partials/blog/blog-entry-meta.php\";i:130;s:35:\"partials/blog/blog-entry-layout.php\";i:131;s:36:\"partials/blog/blog-single-layout.php\";i:132;s:35:\"partials/blog/blog-single-quote.php\";i:133;s:34:\"partials/blog/blog-entry-title.php\";i:134;s:37:\"partials/blog/blog-single-content.php\";i:135;s:34:\"partials/blog/blog-entry-quote.php\";i:136;s:37:\"partials/blog/blog-single-related.php\";i:137;s:34:\"partials/blog/blog-single-meta.php\";i:138;s:35:\"partials/blog/blog-entry-avatar.php\";i:139;s:40:\"partials/blog/media/blog-single-link.php\";i:140;s:40:\"partials/blog/media/blog-entry-video.php\";i:141;s:40:\"partials/blog/media/blog-entry-audio.php\";i:142;s:35:\"partials/blog/media/blog-single.php\";i:143;s:42:\"partials/blog/media/blog-entry-gallery.php\";i:144;s:41:\"partials/blog/media/blog-single-audio.php\";i:145;s:39:\"partials/blog/media/blog-entry-link.php\";i:146;s:43:\"partials/blog/media/blog-single-gallery.php\";i:147;s:34:\"partials/blog/media/blog-entry.php\";i:148;s:41:\"partials/blog/media/blog-single-video.php\";i:149;s:36:\"partials/cpt/cpt-single-comments.php\";i:150;s:38:\"partials/cpt/cpt-single-page-links.php\";i:151;s:32:\"partials/cpt/cpt-single-meta.php\";i:152;s:39:\"partials/cpt/cpt-single-post-series.php\";i:153;s:35:\"partials/cpt/cpt-entry-readmore.php\";i:154;s:34:\"partials/cpt/cpt-entry-gallery.php\";i:155;s:33:\"partials/cpt/cpt-single-share.php\";i:156;s:38:\"partials/cpt/cpt-single-author-bio.php\";i:157;s:35:\"partials/cpt/cpt-single-content.php\";i:158;s:34:\"partials/cpt/cpt-entry-content.php\";i:159;s:33:\"partials/cpt/cpt-single-media.php\";i:160;s:26:\"partials/cpt/cpt-entry.php\";i:161;s:31:\"partials/cpt/cpt-entry-meta.php\";i:162;s:32:\"partials/cpt/cpt-entry-media.php\";i:163;s:35:\"partials/cpt/cpt-single-related.php\";i:164;s:27:\"partials/cpt/cpt-single.php\";i:165;s:35:\"partials/cpt/cpt-single-gallery.php\";i:166;s:33:\"partials/cpt/cpt-single-title.php\";i:167;s:32:\"partials/cpt/cpt-entry-title.php\";i:168;s:42:\"partials/accessibility/skip-to-content.php\";i:169;s:41:\"partials/overlays/title-excerpt-hover.php\";i:170;s:36:\"partials/overlays/plus-two-hover.php\";i:171;s:32:\"partials/overlays/plus-hover.php\";i:172;s:35:\"partials/overlays/title-push-up.php\";i:173;s:40:\"partials/overlays/title-center-boxed.php\";i:174;s:38:\"partials/overlays/magnifying-hover.php\";i:175;s:41:\"partials/overlays/slideup-title-white.php\";i:176;s:38:\"partials/overlays/plus-three-hover.php\";i:177;s:34:\"partials/overlays/category-tag.php\";i:178;s:38:\"partials/overlays/category-tag-two.php\";i:179;s:40:\"partials/overlays/title-date-visible.php\";i:180;s:34:\"partials/overlays/title-center.php\";i:181;s:38:\"partials/overlays/title-date-hover.php\";i:182;s:34:\"partials/overlays/hover-button.php\";i:183;s:38:\"partials/overlays/thumb-swap-title.php\";i:184;s:32:\"partials/overlays/video-icon.php\";i:185;s:46:\"partials/overlays/title-bottom-see-through.php\";i:186;s:44:\"partials/overlays/title-category-visible.php\";i:187;s:32:\"partials/overlays/thumb-swap.php\";i:188;s:42:\"partials/overlays/title-category-hover.php\";i:189;s:48:\"partials/overlays/view-lightbox-buttons-text.php\";i:190;s:53:\"partials/overlays/categories-title-bottom-visible.php\";i:191;s:39:\"partials/overlays/title-price-hover.php\";i:192;s:51:\"partials/overlays/view-lightbox-buttons-buttons.php\";i:193;s:34:\"partials/overlays/title-bottom.php\";i:194;s:41:\"partials/overlays/slideup-title-black.php\";i:195;s:36:\"partials/staff/staff-entry-title.php\";i:196;s:36:\"partials/staff/staff-entry-media.php\";i:197;s:38:\"partials/staff/staff-single-layout.php\";i:198;s:39:\"partials/staff/staff-single-gallery.php\";i:199;s:37:\"partials/staff/staff-single-title.php\";i:200;s:39:\"partials/staff/staff-single-related.php\";i:201;s:30:\"partials/staff/staff-entry.php\";i:202;s:38:\"partials/staff/staff-entry-excerpt.php\";i:203;s:36:\"partials/staff/staff-single-meta.php\";i:204;s:39:\"partials/staff/staff-entry-position.php\";i:205;s:37:\"partials/staff/staff-single-media.php\";i:206;s:39:\"partials/staff/staff-single-content.php\";i:207;s:37:\"partials/staff/staff-single-share.php\";i:208;s:40:\"partials/staff/staff-single-position.php\";i:209;s:38:\"partials/staff/staff-entry-content.php\";i:210;s:40:\"partials/staff/staff-single-comments.php\";i:211;s:37:\"partials/staff/staff-entry-social.php\";i:212;s:31:\"woocommerce/archive-product.php\";i:213;s:29:\"woocommerce/password-form.php\";i:214;s:31:\"woocommerce/loop/pagination.php\";i:215;s:31:\"woocommerce/loop/loop-start.php\";i:216;s:41:\"woocommerce/loop/thumbnail/image-swap.php\";i:217;s:45:\"woocommerce/loop/thumbnail/gallery-slider.php\";i:218;s:45:\"woocommerce/loop/thumbnail/featured-image.php\";i:219;s:38:\"woocommerce/checkout/form-checkout.php\";i:220;s:37:\"woocommerce/single-product/rating.php\";i:221;s:36:\"woocommerce/single-product/title.php\";i:222;s:35:\"woocommerce/single-product/meta.php\";i:223;s:29:\"functions/addfunc-options.php\";i:224;s:29:\"framework/default-filters.php\";i:225;s:44:\"framework/vendor/tribe-events/customizer.php\";i:226;s:39:\"framework/vendor/bbpress/customizer.php\";i:227;s:43:\"framework/vendor/woocommerce/customizer.php\";i:228;s:52:\"framework/vendor/wpbakery/vc-customizer-settings.php\";i:229;s:34:\"framework/updates/update-3_0_0.php\";i:230;s:45:\"framework/wp-actions/remove-emoji-scripts.php\";i:231;s:51:\"framework/customizer/customizer-partial-refresh.php\";i:232;s:43:\"framework/customizer/settings/togglebar.php\";i:233;s:43:\"framework/customizer/settings/portfolio.php\";i:234;s:46:\"framework/customizer/settings/testimonials.php\";i:235;s:47:\"framework/customizer/settings/footer_bottom.php\";i:236;s:40:\"framework/customizer/settings/layout.php\";i:237;s:39:\"framework/customizer/settings/staff.php\";i:238;s:41:\"framework/customizer/settings/callout.php\";i:239;s:48:\"framework/customizer/settings/footer_widgets.php\";i:240;s:41:\"framework/customizer/settings/sidebar.php\";i:241;s:40:\"framework/customizer/settings/header.php\";i:242;s:38:\"framework/customizer/settings/blog.php\";i:243;s:41:\"framework/customizer/settings/general.php\";i:244;s:40:\"framework/customizer/settings/topbar.php\";}s:7:\"max_sel\";N;s:7:\"imports\";a:2:{s:5:\"child\";a:0:{}s:5:\"parnt\";a:0:{}}s:13:\"child_version\";s:3:\"1.0\";s:12:\"child_author\";s:11:\"Levo Health\";s:10:\"child_name\";s:10:\"Levo Child\";s:14:\"child_themeuri\";N;s:15:\"child_authoruri\";N;s:11:\"child_descr\";s:27:\"Levo Health WordPress Theme\";s:10:\"child_tags\";N;s:5:\"parnt\";s:10:\"levo-theme\";s:5:\"child\";s:16:\"levo-theme-child\";s:10:\"configtype\";s:5:\"theme\";s:6:\"valkey\";i:1342;s:7:\"rulekey\";i:136;s:5:\"qskey\";i:3043;s:6:\"selkey\";i:3000;s:8:\"querykey\";i:23;s:8:\"tokenkey\";N;s:6:\"recent\";N;s:9:\"converted\";i:1;s:5:\"fsize\";i:166;s:7:\"version\";s:7:\"2.3.0.4\";}", "no");
INSERT INTO `wp_options` VALUES("1490", "ms_child_theme_editor_dict_qs", "a:3043:{i:1;s:3:\"1:1\";i:2;s:3:\"2:2\";i:3;s:3:\"2:3\";i:4;s:3:\"2:4\";i:5;s:3:\"2:5\";i:6;s:3:\"2:6\";i:7;s:3:\"2:7\";i:8;s:3:\"2:8\";i:9;s:3:\"2:9\";i:10;s:4:\"2:10\";i:11;s:4:\"2:11\";i:12;s:4:\"2:12\";i:13;s:4:\"2:13\";i:14;s:4:\"2:14\";i:15;s:4:\"2:15\";i:16;s:4:\"2:16\";i:17;s:4:\"2:17\";i:18;s:4:\"2:18\";i:19;s:4:\"2:19\";i:20;s:4:\"2:20\";i:21;s:4:\"2:21\";i:22;s:4:\"2:22\";i:23;s:4:\"2:23\";i:24;s:4:\"2:24\";i:25;s:4:\"2:25\";i:26;s:4:\"2:26\";i:27;s:4:\"2:27\";i:28;s:4:\"2:28\";i:29;s:4:\"2:29\";i:30;s:4:\"2:30\";i:31;s:4:\"2:31\";i:32;s:4:\"2:32\";i:33;s:4:\"3:33\";i:34;s:4:\"4:33\";i:35;s:4:\"5:34\";i:36;s:4:\"5:35\";i:37;s:4:\"5:36\";i:38;s:4:\"5:37\";i:39;s:4:\"5:38\";i:40;s:4:\"5:39\";i:41;s:4:\"5:40\";i:42;s:4:\"5:41\";i:43;s:4:\"5:42\";i:44;s:4:\"5:43\";i:45;s:4:\"5:44\";i:46;s:4:\"5:45\";i:47;s:4:\"5:46\";i:48;s:4:\"5:47\";i:49;s:4:\"5:48\";i:50;s:4:\"5:49\";i:51;s:4:\"5:50\";i:52;s:4:\"5:51\";i:53;s:4:\"5:52\";i:54;s:4:\"5:53\";i:55;s:4:\"5:54\";i:56;s:4:\"5:55\";i:57;s:4:\"5:56\";i:58;s:4:\"5:57\";i:59;s:4:\"5:58\";i:60;s:4:\"5:59\";i:61;s:4:\"5:60\";i:62;s:4:\"5:61\";i:63;s:4:\"5:62\";i:64;s:4:\"6:63\";i:65;s:4:\"6:64\";i:66;s:4:\"6:65\";i:67;s:4:\"7:66\";i:68;s:4:\"8:66\";i:69;s:4:\"9:66\";i:70;s:5:\"10:67\";i:71;s:5:\"11:68\";i:72;s:5:\"11:69\";i:73;s:5:\"11:70\";i:74;s:5:\"11:71\";i:75;s:5:\"12:72\";i:76;s:5:\"12:73\";i:77;s:5:\"12:74\";i:78;s:5:\"12:75\";i:79;s:5:\"12:76\";i:80;s:5:\"12:77\";i:81;s:5:\"13:78\";i:82;s:5:\"13:79\";i:83;s:5:\"13:80\";i:84;s:5:\"13:81\";i:85;s:5:\"14:82\";i:86;s:5:\"14:83\";i:87;s:5:\"14:84\";i:88;s:5:\"15:85\";i:89;s:5:\"15:86\";i:90;s:5:\"15:87\";i:91;s:5:\"15:88\";i:92;s:5:\"15:89\";i:93;s:5:\"15:90\";i:94;s:5:\"15:91\";i:95;s:5:\"15:92\";i:96;s:5:\"15:93\";i:97;s:5:\"15:94\";i:98;s:5:\"15:95\";i:99;s:5:\"15:96\";i:100;s:5:\"15:97\";i:101;s:5:\"15:98\";i:102;s:5:\"15:99\";i:103;s:6:\"15:100\";i:104;s:6:\"15:101\";i:105;s:6:\"16:102\";i:106;s:6:\"16:103\";i:107;s:6:\"16:104\";i:108;s:6:\"16:105\";i:109;s:6:\"16:106\";i:110;s:5:\"16:88\";i:111;s:6:\"16:107\";i:112;s:5:\"16:36\";i:113;s:6:\"16:108\";i:114;s:6:\"16:109\";i:115;s:6:\"16:110\";i:116;s:6:\"16:111\";i:117;s:6:\"16:112\";i:118;s:6:\"16:113\";i:119;s:6:\"16:114\";i:120;s:6:\"16:115\";i:121;s:6:\"16:116\";i:122;s:6:\"16:117\";i:123;s:6:\"16:118\";i:124;s:6:\"16:119\";i:125;s:6:\"16:120\";i:126;s:6:\"16:121\";i:127;s:6:\"16:122\";i:128;s:6:\"16:123\";i:129;s:6:\"16:124\";i:130;s:6:\"16:125\";i:131;s:6:\"16:126\";i:132;s:6:\"16:127\";i:133;s:6:\"16:128\";i:134;s:6:\"16:129\";i:135;s:6:\"16:130\";i:136;s:6:\"16:131\";i:137;s:6:\"16:132\";i:138;s:6:\"16:133\";i:139;s:6:\"16:134\";i:140;s:6:\"16:135\";i:141;s:6:\"16:136\";i:142;s:6:\"16:137\";i:143;s:6:\"16:138\";i:144;s:6:\"16:139\";i:145;s:6:\"16:140\";i:146;s:6:\"16:141\";i:147;s:6:\"16:142\";i:148;s:6:\"16:143\";i:149;s:6:\"16:144\";i:150;s:6:\"16:145\";i:151;s:6:\"16:146\";i:152;s:6:\"16:147\";i:153;s:6:\"16:148\";i:154;s:6:\"16:149\";i:155;s:6:\"16:150\";i:156;s:6:\"16:151\";i:157;s:6:\"16:152\";i:158;s:6:\"16:153\";i:159;s:6:\"16:154\";i:160;s:5:\"17:36\";i:161;s:6:\"17:155\";i:162;s:6:\"17:109\";i:163;s:6:\"17:156\";i:164;s:6:\"18:157\";i:165;s:6:\"18:158\";i:166;s:6:\"18:159\";i:167;s:6:\"18:160\";i:168;s:6:\"18:161\";i:169;s:6:\"18:162\";i:170;s:6:\"18:163\";i:171;s:6:\"19:164\";i:172;s:6:\"19:165\";i:173;s:6:\"19:166\";i:174;s:6:\"19:167\";i:175;s:6:\"19:168\";i:176;s:6:\"19:169\";i:177;s:6:\"19:170\";i:178;s:6:\"19:171\";i:179;s:6:\"19:172\";i:180;s:6:\"19:173\";i:181;s:6:\"19:174\";i:182;s:6:\"19:175\";i:183;s:6:\"19:176\";i:184;s:6:\"19:177\";i:185;s:6:\"19:178\";i:186;s:6:\"19:179\";i:187;s:6:\"19:180\";i:188;s:6:\"19:181\";i:189;s:6:\"19:182\";i:190;s:6:\"19:183\";i:191;s:6:\"19:184\";i:192;s:6:\"20:185\";i:193;s:6:\"20:186\";i:194;s:6:\"20:187\";i:195;s:6:\"20:188\";i:196;s:6:\"20:189\";i:197;s:6:\"20:190\";i:198;s:6:\"20:191\";i:199;s:6:\"20:192\";i:200;s:6:\"20:193\";i:201;s:6:\"20:194\";i:202;s:6:\"20:195\";i:203;s:6:\"20:196\";i:204;s:6:\"20:197\";i:205;s:6:\"20:198\";i:206;s:6:\"21:199\";i:207;s:6:\"21:200\";i:208;s:6:\"21:201\";i:209;s:6:\"21:202\";i:210;s:6:\"21:203\";i:211;s:6:\"21:204\";i:212;s:6:\"21:205\";i:213;s:6:\"21:206\";i:214;s:6:\"21:207\";i:215;s:6:\"21:208\";i:216;s:6:\"21:209\";i:217;s:6:\"21:210\";i:218;s:6:\"21:211\";i:219;s:6:\"21:212\";i:220;s:6:\"22:213\";i:221;s:6:\"22:214\";i:222;s:6:\"22:215\";i:223;s:6:\"22:216\";i:224;s:6:\"22:217\";i:225;s:6:\"22:218\";i:226;s:6:\"22:219\";i:227;s:6:\"22:220\";i:228;s:6:\"22:221\";i:229;s:6:\"22:222\";i:230;s:6:\"22:223\";i:231;s:6:\"22:224\";i:232;s:6:\"22:225\";i:233;s:6:\"22:226\";i:234;s:6:\"23:227\";i:235;s:6:\"23:228\";i:236;s:6:\"23:229\";i:237;s:6:\"23:230\";i:238;s:6:\"23:231\";i:239;s:6:\"23:232\";i:240;s:6:\"23:233\";i:241;s:6:\"23:234\";i:242;s:6:\"23:235\";i:243;s:6:\"23:236\";i:244;s:6:\"23:237\";i:245;s:6:\"23:238\";i:246;s:6:\"23:239\";i:247;s:6:\"23:240\";i:248;s:6:\"23:241\";i:249;s:6:\"23:242\";i:250;s:6:\"23:243\";i:251;s:6:\"23:244\";i:252;s:6:\"23:245\";i:253;s:6:\"23:246\";i:254;s:6:\"23:247\";i:255;s:6:\"23:248\";i:256;s:5:\"23:64\";i:257;s:6:\"23:249\";i:258;s:5:\"23:72\";i:259;s:6:\"23:250\";i:260;s:5:\"23:73\";i:261;s:6:\"23:251\";i:262;s:6:\"23:106\";i:263;s:6:\"23:252\";i:264;s:6:\"23:253\";i:265;s:6:\"23:254\";i:266;s:6:\"23:255\";i:267;s:6:\"23:256\";i:268;s:6:\"23:257\";i:269;s:6:\"23:258\";i:270;s:6:\"23:259\";i:271;s:6:\"23:260\";i:272;s:6:\"23:114\";i:273;s:5:\"23:35\";i:274;s:6:\"23:261\";i:275;s:6:\"23:262\";i:276;s:6:\"23:263\";i:277;s:6:\"23:264\";i:278;s:6:\"23:265\";i:279;s:6:\"23:266\";i:280;s:6:\"23:267\";i:281;s:6:\"23:268\";i:282;s:6:\"23:269\";i:283;s:4:\"23:1\";i:284;s:6:\"23:270\";i:285;s:6:\"23:271\";i:286;s:6:\"23:272\";i:287;s:6:\"23:273\";i:288;s:6:\"23:274\";i:289;s:6:\"23:275\";i:290;s:6:\"23:276\";i:291;s:6:\"23:277\";i:292;s:6:\"23:278\";i:293;s:6:\"23:279\";i:294;s:6:\"23:280\";i:295;s:6:\"23:281\";i:296;s:6:\"23:282\";i:297;s:6:\"23:283\";i:298;s:6:\"23:284\";i:299;s:6:\"23:285\";i:300;s:6:\"23:286\";i:301;s:6:\"23:287\";i:302;s:6:\"23:288\";i:303;s:6:\"23:289\";i:304;s:6:\"23:290\";i:305;s:6:\"23:291\";i:306;s:6:\"23:292\";i:307;s:6:\"23:293\";i:308;s:6:\"23:294\";i:309;s:6:\"23:295\";i:310;s:6:\"23:296\";i:311;s:6:\"23:297\";i:312;s:6:\"23:298\";i:313;s:6:\"23:299\";i:314;s:6:\"23:300\";i:315;s:6:\"23:301\";i:316;s:6:\"23:302\";i:317;s:6:\"23:303\";i:318;s:6:\"23:304\";i:319;s:6:\"23:305\";i:320;s:6:\"23:306\";i:321;s:6:\"23:307\";i:322;s:6:\"23:308\";i:323;s:6:\"23:309\";i:324;s:6:\"23:310\";i:325;s:6:\"23:311\";i:326;s:6:\"23:312\";i:327;s:6:\"23:313\";i:328;s:6:\"23:314\";i:329;s:6:\"23:315\";i:330;s:6:\"23:316\";i:331;s:6:\"23:112\";i:332;s:6:\"23:317\";i:333;s:6:\"23:318\";i:334;s:6:\"23:319\";i:335;s:6:\"23:320\";i:336;s:6:\"23:321\";i:337;s:6:\"23:322\";i:338;s:6:\"23:323\";i:339;s:6:\"23:324\";i:340;s:6:\"23:325\";i:341;s:6:\"23:326\";i:342;s:6:\"23:327\";i:343;s:6:\"23:328\";i:344;s:6:\"23:329\";i:345;s:6:\"23:330\";i:346;s:6:\"23:331\";i:347;s:6:\"23:332\";i:348;s:6:\"23:333\";i:349;s:6:\"23:334\";i:350;s:6:\"23:335\";i:351;s:6:\"23:336\";i:352;s:6:\"23:337\";i:353;s:6:\"23:338\";i:354;s:6:\"23:339\";i:355;s:6:\"23:340\";i:356;s:6:\"23:341\";i:357;s:6:\"23:342\";i:358;s:6:\"23:343\";i:359;s:6:\"23:344\";i:360;s:6:\"23:345\";i:361;s:6:\"23:346\";i:362;s:6:\"23:347\";i:363;s:6:\"23:348\";i:364;s:6:\"23:349\";i:365;s:6:\"23:350\";i:366;s:6:\"23:351\";i:367;s:6:\"23:352\";i:368;s:6:\"23:353\";i:369;s:6:\"23:354\";i:370;s:6:\"23:355\";i:371;s:6:\"23:356\";i:372;s:6:\"23:357\";i:373;s:6:\"23:358\";i:374;s:6:\"23:359\";i:375;s:6:\"23:360\";i:376;s:6:\"23:361\";i:377;s:6:\"23:362\";i:378;s:6:\"23:363\";i:379;s:6:\"23:364\";i:380;s:6:\"23:365\";i:381;s:6:\"23:366\";i:382;s:6:\"23:367\";i:383;s:6:\"23:368\";i:384;s:6:\"23:369\";i:385;s:6:\"23:370\";i:386;s:6:\"23:371\";i:387;s:6:\"23:372\";i:388;s:6:\"23:373\";i:389;s:6:\"23:374\";i:390;s:6:\"23:375\";i:391;s:6:\"23:376\";i:392;s:6:\"23:377\";i:393;s:6:\"23:378\";i:394;s:6:\"23:379\";i:395;s:6:\"23:380\";i:396;s:6:\"23:381\";i:397;s:6:\"23:382\";i:398;s:6:\"23:383\";i:399;s:6:\"23:384\";i:400;s:6:\"23:385\";i:401;s:6:\"23:386\";i:402;s:6:\"23:387\";i:403;s:6:\"23:388\";i:404;s:6:\"23:389\";i:405;s:6:\"23:390\";i:406;s:6:\"23:391\";i:407;s:6:\"23:392\";i:408;s:6:\"23:393\";i:409;s:6:\"23:394\";i:410;s:6:\"23:395\";i:411;s:6:\"23:396\";i:412;s:6:\"23:397\";i:413;s:6:\"23:398\";i:414;s:6:\"23:399\";i:415;s:6:\"23:400\";i:416;s:6:\"23:401\";i:417;s:6:\"23:402\";i:418;s:6:\"23:403\";i:419;s:6:\"23:404\";i:420;s:6:\"23:405\";i:421;s:6:\"23:406\";i:422;s:6:\"23:407\";i:423;s:6:\"23:408\";i:424;s:6:\"23:409\";i:425;s:6:\"23:410\";i:426;s:6:\"23:411\";i:427;s:6:\"23:412\";i:428;s:6:\"23:413\";i:429;s:6:\"23:414\";i:430;s:6:\"23:415\";i:431;s:6:\"23:416\";i:432;s:6:\"23:417\";i:433;s:6:\"23:418\";i:434;s:6:\"23:419\";i:435;s:6:\"23:420\";i:436;s:6:\"23:421\";i:437;s:6:\"23:422\";i:438;s:6:\"23:423\";i:439;s:6:\"23:424\";i:440;s:6:\"23:425\";i:441;s:6:\"23:426\";i:442;s:6:\"23:427\";i:443;s:6:\"23:428\";i:444;s:6:\"23:429\";i:445;s:6:\"23:430\";i:446;s:6:\"23:431\";i:447;s:6:\"23:432\";i:448;s:6:\"23:433\";i:449;s:6:\"23:434\";i:450;s:6:\"23:435\";i:451;s:6:\"23:436\";i:452;s:6:\"23:437\";i:453;s:6:\"23:438\";i:454;s:6:\"23:439\";i:455;s:6:\"23:440\";i:456;s:6:\"23:441\";i:457;s:6:\"23:442\";i:458;s:6:\"23:443\";i:459;s:6:\"23:444\";i:460;s:6:\"23:445\";i:461;s:6:\"23:446\";i:462;s:6:\"23:447\";i:463;s:6:\"23:448\";i:464;s:6:\"23:449\";i:465;s:6:\"23:450\";i:466;s:6:\"23:451\";i:467;s:6:\"23:452\";i:468;s:6:\"23:453\";i:469;s:6:\"23:454\";i:470;s:6:\"23:455\";i:471;s:6:\"23:456\";i:472;s:6:\"23:457\";i:473;s:6:\"23:458\";i:474;s:6:\"23:459\";i:475;s:6:\"23:460\";i:476;s:6:\"23:461\";i:477;s:6:\"23:462\";i:478;s:6:\"23:463\";i:479;s:6:\"23:464\";i:480;s:6:\"23:465\";i:481;s:6:\"23:466\";i:482;s:6:\"23:467\";i:483;s:6:\"23:468\";i:484;s:6:\"23:469\";i:485;s:6:\"23:470\";i:486;s:6:\"23:471\";i:487;s:6:\"23:472\";i:488;s:6:\"23:473\";i:489;s:6:\"23:474\";i:490;s:6:\"23:475\";i:491;s:6:\"23:476\";i:492;s:6:\"23:477\";i:493;s:6:\"23:478\";i:494;s:6:\"23:479\";i:495;s:6:\"23:480\";i:496;s:6:\"23:481\";i:497;s:6:\"23:482\";i:498;s:6:\"23:483\";i:499;s:6:\"23:484\";i:500;s:6:\"23:485\";i:501;s:6:\"23:486\";i:502;s:6:\"23:487\";i:503;s:6:\"23:488\";i:504;s:6:\"23:489\";i:505;s:6:\"23:490\";i:506;s:6:\"23:491\";i:507;s:6:\"23:492\";i:508;s:6:\"23:493\";i:509;s:6:\"23:494\";i:510;s:6:\"23:495\";i:511;s:6:\"23:496\";i:512;s:6:\"23:497\";i:513;s:6:\"23:498\";i:514;s:6:\"23:499\";i:515;s:6:\"23:500\";i:516;s:6:\"23:501\";i:517;s:6:\"23:502\";i:518;s:6:\"23:503\";i:519;s:6:\"23:504\";i:520;s:6:\"23:505\";i:521;s:6:\"23:506\";i:522;s:6:\"23:507\";i:523;s:6:\"23:508\";i:524;s:6:\"23:509\";i:525;s:6:\"23:510\";i:526;s:6:\"23:511\";i:527;s:6:\"23:512\";i:528;s:6:\"23:513\";i:529;s:6:\"23:514\";i:530;s:6:\"23:515\";i:531;s:6:\"23:516\";i:532;s:6:\"23:517\";i:533;s:6:\"23:518\";i:534;s:6:\"23:519\";i:535;s:6:\"23:520\";i:536;s:6:\"23:521\";i:537;s:6:\"23:522\";i:538;s:6:\"23:523\";i:539;s:6:\"23:524\";i:540;s:6:\"23:525\";i:541;s:6:\"23:526\";i:542;s:6:\"23:527\";i:543;s:6:\"23:528\";i:544;s:6:\"23:529\";i:545;s:6:\"23:530\";i:546;s:6:\"23:531\";i:547;s:6:\"23:532\";i:548;s:6:\"23:533\";i:549;s:6:\"23:534\";i:550;s:6:\"23:535\";i:551;s:6:\"23:536\";i:552;s:6:\"23:537\";i:553;s:6:\"23:538\";i:554;s:6:\"23:539\";i:555;s:6:\"23:540\";i:556;s:6:\"23:541\";i:557;s:6:\"23:542\";i:558;s:6:\"23:543\";i:559;s:6:\"23:544\";i:560;s:6:\"23:545\";i:561;s:6:\"23:546\";i:562;s:6:\"23:547\";i:563;s:6:\"23:548\";i:564;s:6:\"23:549\";i:565;s:6:\"23:550\";i:566;s:6:\"23:551\";i:567;s:6:\"23:552\";i:568;s:6:\"23:553\";i:569;s:6:\"23:554\";i:570;s:6:\"23:555\";i:571;s:6:\"23:556\";i:572;s:6:\"23:557\";i:573;s:6:\"23:558\";i:574;s:6:\"23:559\";i:575;s:6:\"23:560\";i:576;s:6:\"23:561\";i:577;s:6:\"23:562\";i:578;s:6:\"23:563\";i:579;s:6:\"23:564\";i:580;s:6:\"23:565\";i:581;s:6:\"23:566\";i:582;s:6:\"23:567\";i:583;s:6:\"23:568\";i:584;s:6:\"23:569\";i:585;s:6:\"23:570\";i:586;s:6:\"23:571\";i:587;s:6:\"23:572\";i:588;s:6:\"23:573\";i:589;s:6:\"23:574\";i:590;s:6:\"23:575\";i:591;s:6:\"23:576\";i:592;s:6:\"23:577\";i:593;s:6:\"23:578\";i:594;s:6:\"23:579\";i:595;s:6:\"23:580\";i:596;s:6:\"23:581\";i:597;s:6:\"23:582\";i:598;s:6:\"23:583\";i:599;s:6:\"23:584\";i:600;s:6:\"23:585\";i:601;s:6:\"23:586\";i:602;s:6:\"23:587\";i:603;s:6:\"23:588\";i:604;s:6:\"23:589\";i:605;s:6:\"23:590\";i:606;s:6:\"23:591\";i:607;s:6:\"23:592\";i:608;s:6:\"23:593\";i:609;s:6:\"23:594\";i:610;s:6:\"23:595\";i:611;s:6:\"23:596\";i:612;s:6:\"23:597\";i:613;s:6:\"23:598\";i:614;s:6:\"23:599\";i:615;s:6:\"23:600\";i:616;s:6:\"23:601\";i:617;s:6:\"23:602\";i:618;s:6:\"23:603\";i:619;s:6:\"23:604\";i:620;s:6:\"23:605\";i:621;s:6:\"23:606\";i:622;s:6:\"23:607\";i:623;s:6:\"23:608\";i:624;s:6:\"23:609\";i:625;s:6:\"23:610\";i:626;s:6:\"23:611\";i:627;s:6:\"23:612\";i:628;s:6:\"23:613\";i:629;s:6:\"23:614\";i:630;s:6:\"23:615\";i:631;s:6:\"23:616\";i:632;s:6:\"23:617\";i:633;s:6:\"23:618\";i:634;s:6:\"23:619\";i:635;s:6:\"23:620\";i:636;s:6:\"23:621\";i:637;s:6:\"23:622\";i:638;s:6:\"23:623\";i:639;s:6:\"23:624\";i:640;s:6:\"23:625\";i:641;s:6:\"23:626\";i:642;s:6:\"23:627\";i:643;s:6:\"23:628\";i:644;s:6:\"23:629\";i:645;s:6:\"23:630\";i:646;s:6:\"23:631\";i:647;s:6:\"23:632\";i:648;s:6:\"23:633\";i:649;s:6:\"23:634\";i:650;s:6:\"23:635\";i:651;s:6:\"23:636\";i:652;s:6:\"23:637\";i:653;s:6:\"23:638\";i:654;s:6:\"23:639\";i:655;s:6:\"23:640\";i:656;s:6:\"23:641\";i:657;s:6:\"23:642\";i:658;s:6:\"23:643\";i:659;s:6:\"23:644\";i:660;s:6:\"23:645\";i:661;s:6:\"23:646\";i:662;s:6:\"23:647\";i:663;s:6:\"23:648\";i:664;s:6:\"23:649\";i:665;s:6:\"23:650\";i:666;s:6:\"23:651\";i:667;s:6:\"23:652\";i:668;s:6:\"23:653\";i:669;s:6:\"23:654\";i:670;s:6:\"23:655\";i:671;s:6:\"23:656\";i:672;s:6:\"23:657\";i:673;s:6:\"23:658\";i:674;s:6:\"23:659\";i:675;s:6:\"23:660\";i:676;s:6:\"23:661\";i:677;s:6:\"23:662\";i:678;s:6:\"23:663\";i:679;s:6:\"23:664\";i:680;s:6:\"23:665\";i:681;s:6:\"23:666\";i:682;s:6:\"23:667\";i:683;s:6:\"23:668\";i:684;s:6:\"23:669\";i:685;s:6:\"23:670\";i:686;s:6:\"23:671\";i:687;s:6:\"23:672\";i:688;s:6:\"23:673\";i:689;s:6:\"23:674\";i:690;s:6:\"23:675\";i:691;s:6:\"23:676\";i:692;s:6:\"23:677\";i:693;s:6:\"23:678\";i:694;s:6:\"23:679\";i:695;s:6:\"23:680\";i:696;s:6:\"23:681\";i:697;s:6:\"23:682\";i:698;s:6:\"23:683\";i:699;s:6:\"23:684\";i:700;s:6:\"23:685\";i:701;s:6:\"23:686\";i:702;s:6:\"23:687\";i:703;s:6:\"23:688\";i:704;s:6:\"23:689\";i:705;s:6:\"23:690\";i:706;s:6:\"23:691\";i:707;s:6:\"23:692\";i:708;s:6:\"23:693\";i:709;s:6:\"23:694\";i:710;s:6:\"23:695\";i:711;s:6:\"23:696\";i:712;s:6:\"23:697\";i:713;s:6:\"23:698\";i:714;s:6:\"23:699\";i:715;s:6:\"23:700\";i:716;s:6:\"23:701\";i:717;s:6:\"23:702\";i:718;s:6:\"23:703\";i:719;s:6:\"23:704\";i:720;s:6:\"23:705\";i:721;s:6:\"23:706\";i:722;s:6:\"23:707\";i:723;s:6:\"23:708\";i:724;s:6:\"23:709\";i:725;s:6:\"23:710\";i:726;s:6:\"23:711\";i:727;s:6:\"23:712\";i:728;s:6:\"23:713\";i:729;s:6:\"23:714\";i:730;s:6:\"23:715\";i:731;s:6:\"23:716\";i:732;s:6:\"23:717\";i:733;s:6:\"23:718\";i:734;s:6:\"23:719\";i:735;s:6:\"23:720\";i:736;s:6:\"23:721\";i:737;s:6:\"23:722\";i:738;s:6:\"23:723\";i:739;s:6:\"23:724\";i:740;s:6:\"23:725\";i:741;s:6:\"23:726\";i:742;s:6:\"23:727\";i:743;s:6:\"23:728\";i:744;s:6:\"23:729\";i:745;s:6:\"23:730\";i:746;s:6:\"23:731\";i:747;s:6:\"23:732\";i:748;s:6:\"23:733\";i:749;s:6:\"23:734\";i:750;s:6:\"23:735\";i:751;s:6:\"23:736\";i:752;s:6:\"23:737\";i:753;s:6:\"23:738\";i:754;s:6:\"23:739\";i:755;s:6:\"23:740\";i:756;s:6:\"23:741\";i:757;s:6:\"23:742\";i:758;s:6:\"23:743\";i:759;s:6:\"23:744\";i:760;s:6:\"23:745\";i:761;s:6:\"23:746\";i:762;s:6:\"23:747\";i:763;s:6:\"23:748\";i:764;s:6:\"23:749\";i:765;s:6:\"23:750\";i:766;s:6:\"23:751\";i:767;s:6:\"23:752\";i:768;s:6:\"23:753\";i:769;s:6:\"23:754\";i:770;s:6:\"23:755\";i:771;s:6:\"23:756\";i:772;s:6:\"23:757\";i:773;s:6:\"23:758\";i:774;s:6:\"23:759\";i:775;s:6:\"23:760\";i:776;s:6:\"23:761\";i:777;s:6:\"23:762\";i:778;s:6:\"23:763\";i:779;s:6:\"23:764\";i:780;s:6:\"23:765\";i:781;s:6:\"23:766\";i:782;s:6:\"23:767\";i:783;s:6:\"23:768\";i:784;s:6:\"23:769\";i:785;s:6:\"23:770\";i:786;s:6:\"23:771\";i:787;s:6:\"23:772\";i:788;s:6:\"23:773\";i:789;s:6:\"23:774\";i:790;s:6:\"23:775\";i:791;s:6:\"23:776\";i:792;s:6:\"23:777\";i:793;s:6:\"23:778\";i:794;s:6:\"23:779\";i:795;s:6:\"23:780\";i:796;s:6:\"23:781\";i:797;s:6:\"23:782\";i:798;s:6:\"23:783\";i:799;s:6:\"23:784\";i:800;s:6:\"23:785\";i:801;s:6:\"23:786\";i:802;s:6:\"23:787\";i:803;s:6:\"23:788\";i:804;s:6:\"23:789\";i:805;s:6:\"23:790\";i:806;s:6:\"23:791\";i:807;s:6:\"23:792\";i:808;s:6:\"23:793\";i:809;s:6:\"23:794\";i:810;s:6:\"23:795\";i:811;s:6:\"23:796\";i:812;s:6:\"23:797\";i:813;s:6:\"23:798\";i:814;s:6:\"23:799\";i:815;s:6:\"23:800\";i:816;s:6:\"23:801\";i:817;s:6:\"23:802\";i:818;s:6:\"23:803\";i:819;s:6:\"23:804\";i:820;s:6:\"23:805\";i:821;s:6:\"23:806\";i:822;s:6:\"23:807\";i:823;s:6:\"23:808\";i:824;s:6:\"23:809\";i:825;s:6:\"23:810\";i:826;s:6:\"23:811\";i:827;s:6:\"23:812\";i:828;s:6:\"23:813\";i:829;s:6:\"23:814\";i:830;s:6:\"23:815\";i:831;s:6:\"23:816\";i:832;s:6:\"23:817\";i:833;s:6:\"23:818\";i:834;s:6:\"23:819\";i:835;s:6:\"23:820\";i:836;s:6:\"23:821\";i:837;s:6:\"23:822\";i:838;s:6:\"23:823\";i:839;s:6:\"23:824\";i:840;s:6:\"23:825\";i:841;s:6:\"23:826\";i:842;s:6:\"23:827\";i:843;s:6:\"23:828\";i:844;s:6:\"23:829\";i:845;s:6:\"23:830\";i:846;s:6:\"23:831\";i:847;s:6:\"23:832\";i:848;s:6:\"23:833\";i:849;s:6:\"23:834\";i:850;s:6:\"23:835\";i:851;s:6:\"23:836\";i:852;s:6:\"23:837\";i:853;s:6:\"23:838\";i:854;s:6:\"23:839\";i:855;s:6:\"23:840\";i:856;s:6:\"23:841\";i:857;s:6:\"23:842\";i:858;s:6:\"23:843\";i:859;s:6:\"23:844\";i:860;s:6:\"23:845\";i:861;s:6:\"23:846\";i:862;s:6:\"23:847\";i:863;s:6:\"23:848\";i:864;s:6:\"23:849\";i:865;s:6:\"23:850\";i:866;s:6:\"23:851\";i:867;s:6:\"23:852\";i:868;s:6:\"23:853\";i:869;s:6:\"23:854\";i:870;s:6:\"23:855\";i:871;s:6:\"23:856\";i:872;s:6:\"23:857\";i:873;s:6:\"23:858\";i:874;s:6:\"23:859\";i:875;s:6:\"23:860\";i:876;s:6:\"23:861\";i:877;s:6:\"23:862\";i:878;s:6:\"23:863\";i:879;s:6:\"23:864\";i:880;s:6:\"23:865\";i:881;s:6:\"23:866\";i:882;s:6:\"23:867\";i:883;s:6:\"23:868\";i:884;s:6:\"23:869\";i:885;s:6:\"23:870\";i:886;s:6:\"23:871\";i:887;s:6:\"23:872\";i:888;s:6:\"23:873\";i:889;s:6:\"23:874\";i:890;s:6:\"23:875\";i:891;s:6:\"23:876\";i:892;s:6:\"23:877\";i:893;s:6:\"23:878\";i:894;s:6:\"23:879\";i:895;s:6:\"23:880\";i:896;s:6:\"23:881\";i:897;s:6:\"23:882\";i:898;s:6:\"23:883\";i:899;s:6:\"23:884\";i:900;s:6:\"23:885\";i:901;s:6:\"23:886\";i:902;s:6:\"23:887\";i:903;s:6:\"23:888\";i:904;s:6:\"23:889\";i:905;s:6:\"23:890\";i:906;s:6:\"23:891\";i:907;s:6:\"23:892\";i:908;s:6:\"23:893\";i:909;s:6:\"23:894\";i:910;s:6:\"23:895\";i:911;s:6:\"23:896\";i:912;s:6:\"23:897\";i:913;s:6:\"23:898\";i:914;s:6:\"23:899\";i:915;s:6:\"23:900\";i:916;s:6:\"23:901\";i:917;s:6:\"23:902\";i:918;s:6:\"23:903\";i:919;s:6:\"23:904\";i:920;s:6:\"23:905\";i:921;s:6:\"23:906\";i:922;s:6:\"23:907\";i:923;s:6:\"23:908\";i:924;s:6:\"23:909\";i:925;s:6:\"23:910\";i:926;s:6:\"23:911\";i:927;s:6:\"23:912\";i:928;s:6:\"23:913\";i:929;s:6:\"23:914\";i:930;s:6:\"23:915\";i:931;s:6:\"23:916\";i:932;s:6:\"23:917\";i:933;s:6:\"23:918\";i:934;s:6:\"23:919\";i:935;s:6:\"23:920\";i:936;s:6:\"23:921\";i:937;s:6:\"23:922\";i:938;s:6:\"23:923\";i:939;s:6:\"23:924\";i:940;s:6:\"23:925\";i:941;s:6:\"23:926\";i:942;s:6:\"23:927\";i:943;s:6:\"23:928\";i:944;s:6:\"23:929\";i:945;s:6:\"23:930\";i:946;s:6:\"23:931\";i:947;s:6:\"23:932\";i:948;s:6:\"23:933\";i:949;s:6:\"23:934\";i:950;s:6:\"23:935\";i:951;s:6:\"23:936\";i:952;s:6:\"23:937\";i:953;s:6:\"23:938\";i:954;s:6:\"23:939\";i:955;s:6:\"23:940\";i:956;s:6:\"23:941\";i:957;s:6:\"23:942\";i:958;s:6:\"23:943\";i:959;s:6:\"23:944\";i:960;s:6:\"23:945\";i:961;s:6:\"23:946\";i:962;s:6:\"23:947\";i:963;s:6:\"23:948\";i:964;s:6:\"23:949\";i:965;s:6:\"23:950\";i:966;s:6:\"23:951\";i:967;s:6:\"23:952\";i:968;s:6:\"23:953\";i:969;s:6:\"23:954\";i:970;s:6:\"23:955\";i:971;s:6:\"23:956\";i:972;s:6:\"23:957\";i:973;s:6:\"23:958\";i:974;s:6:\"23:959\";i:975;s:6:\"23:960\";i:976;s:6:\"23:961\";i:977;s:6:\"23:962\";i:978;s:6:\"23:963\";i:979;s:6:\"23:964\";i:980;s:6:\"23:965\";i:981;s:6:\"23:966\";i:982;s:6:\"23:967\";i:983;s:6:\"23:968\";i:984;s:6:\"23:969\";i:985;s:6:\"23:970\";i:986;s:6:\"23:971\";i:987;s:6:\"23:972\";i:988;s:6:\"23:973\";i:989;s:6:\"23:974\";i:990;s:6:\"23:975\";i:991;s:6:\"23:976\";i:992;s:6:\"23:977\";i:993;s:6:\"23:978\";i:994;s:6:\"23:979\";i:995;s:6:\"23:980\";i:996;s:6:\"23:981\";i:997;s:6:\"23:982\";i:998;s:6:\"23:983\";i:999;s:6:\"23:984\";i:1000;s:6:\"23:985\";i:1001;s:6:\"23:986\";i:1002;s:6:\"23:987\";i:1003;s:6:\"23:988\";i:1004;s:6:\"23:989\";i:1005;s:6:\"23:990\";i:1006;s:6:\"23:991\";i:1007;s:6:\"23:992\";i:1008;s:6:\"23:993\";i:1009;s:6:\"23:994\";i:1010;s:6:\"23:995\";i:1011;s:6:\"23:996\";i:1012;s:6:\"23:997\";i:1013;s:6:\"23:998\";i:1014;s:6:\"23:999\";i:1015;s:7:\"23:1000\";i:1016;s:7:\"23:1001\";i:1017;s:7:\"23:1002\";i:1018;s:7:\"23:1003\";i:1019;s:7:\"23:1004\";i:1020;s:7:\"23:1005\";i:1021;s:7:\"23:1006\";i:1022;s:7:\"23:1007\";i:1023;s:7:\"23:1008\";i:1024;s:7:\"23:1009\";i:1025;s:7:\"23:1010\";i:1026;s:7:\"23:1011\";i:1027;s:7:\"23:1012\";i:1028;s:7:\"23:1013\";i:1029;s:7:\"23:1014\";i:1030;s:7:\"23:1015\";i:1031;s:7:\"23:1016\";i:1032;s:7:\"23:1017\";i:1033;s:7:\"23:1018\";i:1034;s:7:\"23:1019\";i:1035;s:7:\"23:1020\";i:1036;s:7:\"23:1021\";i:1037;s:7:\"23:1022\";i:1038;s:7:\"23:1023\";i:1039;s:7:\"23:1024\";i:1040;s:7:\"23:1025\";i:1041;s:7:\"23:1026\";i:1042;s:7:\"23:1027\";i:1043;s:7:\"23:1028\";i:1044;s:7:\"23:1029\";i:1045;s:7:\"23:1030\";i:1046;s:7:\"23:1031\";i:1047;s:7:\"23:1032\";i:1048;s:7:\"23:1033\";i:1049;s:7:\"23:1034\";i:1050;s:7:\"23:1035\";i:1051;s:7:\"23:1036\";i:1052;s:7:\"23:1037\";i:1053;s:7:\"23:1038\";i:1054;s:7:\"23:1039\";i:1055;s:7:\"23:1040\";i:1056;s:7:\"23:1041\";i:1057;s:7:\"23:1042\";i:1058;s:7:\"23:1043\";i:1059;s:7:\"23:1044\";i:1060;s:7:\"23:1045\";i:1061;s:7:\"23:1046\";i:1062;s:7:\"23:1047\";i:1063;s:7:\"23:1048\";i:1064;s:7:\"23:1049\";i:1065;s:7:\"23:1050\";i:1066;s:7:\"23:1051\";i:1067;s:7:\"23:1052\";i:1068;s:7:\"23:1053\";i:1069;s:7:\"23:1054\";i:1070;s:7:\"23:1055\";i:1071;s:7:\"23:1056\";i:1072;s:7:\"23:1057\";i:1073;s:7:\"23:1058\";i:1074;s:7:\"23:1059\";i:1075;s:7:\"23:1060\";i:1076;s:7:\"23:1061\";i:1077;s:7:\"23:1062\";i:1078;s:7:\"23:1063\";i:1079;s:7:\"23:1064\";i:1080;s:7:\"23:1065\";i:1081;s:7:\"23:1066\";i:1082;s:7:\"23:1067\";i:1083;s:7:\"23:1068\";i:1084;s:7:\"23:1069\";i:1085;s:7:\"23:1070\";i:1086;s:7:\"23:1071\";i:1087;s:7:\"23:1072\";i:1088;s:7:\"23:1073\";i:1089;s:7:\"23:1074\";i:1090;s:7:\"23:1075\";i:1091;s:7:\"23:1076\";i:1092;s:7:\"23:1077\";i:1093;s:7:\"23:1078\";i:1094;s:7:\"23:1079\";i:1095;s:7:\"23:1080\";i:1096;s:7:\"23:1081\";i:1097;s:7:\"23:1082\";i:1098;s:7:\"23:1083\";i:1099;s:7:\"23:1084\";i:1100;s:7:\"23:1085\";i:1101;s:7:\"23:1086\";i:1102;s:7:\"23:1087\";i:1103;s:7:\"23:1088\";i:1104;s:7:\"23:1089\";i:1105;s:7:\"23:1090\";i:1106;s:7:\"23:1091\";i:1107;s:7:\"23:1092\";i:1108;s:7:\"23:1093\";i:1109;s:7:\"23:1094\";i:1110;s:7:\"23:1095\";i:1111;s:7:\"23:1096\";i:1112;s:7:\"23:1097\";i:1113;s:7:\"23:1098\";i:1114;s:7:\"23:1099\";i:1115;s:7:\"23:1100\";i:1116;s:7:\"23:1101\";i:1117;s:7:\"23:1102\";i:1118;s:7:\"23:1103\";i:1119;s:7:\"23:1104\";i:1120;s:7:\"23:1105\";i:1121;s:7:\"23:1106\";i:1122;s:7:\"23:1107\";i:1123;s:7:\"23:1108\";i:1124;s:7:\"23:1109\";i:1125;s:7:\"23:1110\";i:1126;s:7:\"23:1111\";i:1127;s:7:\"23:1112\";i:1128;s:7:\"23:1113\";i:1129;s:7:\"23:1114\";i:1130;s:7:\"23:1115\";i:1131;s:7:\"23:1116\";i:1132;s:7:\"23:1117\";i:1133;s:7:\"23:1118\";i:1134;s:7:\"23:1119\";i:1135;s:5:\"23:96\";i:1136;s:7:\"23:1120\";i:1137;s:7:\"23:1121\";i:1138;s:7:\"23:1122\";i:1139;s:7:\"23:1123\";i:1140;s:7:\"23:1124\";i:1141;s:7:\"23:1125\";i:1142;s:7:\"23:1126\";i:1143;s:7:\"23:1127\";i:1144;s:7:\"23:1128\";i:1145;s:7:\"23:1129\";i:1146;s:7:\"23:1130\";i:1147;s:7:\"23:1131\";i:1148;s:7:\"23:1132\";i:1149;s:7:\"23:1133\";i:1150;s:7:\"23:1134\";i:1151;s:7:\"23:1135\";i:1152;s:7:\"23:1136\";i:1153;s:7:\"23:1137\";i:1154;s:7:\"23:1138\";i:1155;s:7:\"23:1139\";i:1156;s:7:\"23:1140\";i:1157;s:7:\"23:1141\";i:1158;s:7:\"23:1142\";i:1159;s:7:\"23:1143\";i:1160;s:7:\"23:1144\";i:1161;s:7:\"23:1145\";i:1162;s:7:\"23:1146\";i:1163;s:7:\"23:1147\";i:1164;s:7:\"23:1148\";i:1165;s:7:\"23:1149\";i:1166;s:7:\"23:1150\";i:1167;s:7:\"23:1151\";i:1168;s:7:\"23:1152\";i:1169;s:7:\"23:1153\";i:1170;s:7:\"23:1154\";i:1171;s:7:\"23:1155\";i:1172;s:7:\"23:1156\";i:1173;s:7:\"23:1157\";i:1174;s:7:\"23:1158\";i:1175;s:7:\"23:1159\";i:1176;s:7:\"23:1160\";i:1177;s:7:\"23:1161\";i:1178;s:7:\"23:1162\";i:1179;s:7:\"23:1163\";i:1180;s:7:\"23:1164\";i:1181;s:7:\"23:1165\";i:1182;s:7:\"23:1166\";i:1183;s:7:\"23:1167\";i:1184;s:7:\"23:1168\";i:1185;s:7:\"23:1169\";i:1186;s:7:\"23:1170\";i:1187;s:7:\"23:1171\";i:1188;s:7:\"23:1172\";i:1189;s:7:\"23:1173\";i:1190;s:7:\"23:1174\";i:1191;s:7:\"23:1175\";i:1192;s:7:\"23:1176\";i:1193;s:7:\"23:1177\";i:1194;s:7:\"23:1178\";i:1195;s:7:\"23:1179\";i:1196;s:7:\"23:1180\";i:1197;s:7:\"23:1181\";i:1198;s:7:\"23:1182\";i:1199;s:7:\"23:1183\";i:1200;s:7:\"23:1184\";i:1201;s:7:\"23:1185\";i:1202;s:7:\"23:1186\";i:1203;s:7:\"23:1187\";i:1204;s:7:\"23:1188\";i:1205;s:5:\"23:53\";i:1206;s:7:\"23:1189\";i:1207;s:7:\"23:1190\";i:1208;s:5:\"23:56\";i:1209;s:7:\"23:1191\";i:1210;s:7:\"23:1192\";i:1211;s:7:\"23:1193\";i:1212;s:7:\"23:1194\";i:1213;s:7:\"23:1195\";i:1214;s:7:\"23:1196\";i:1215;s:7:\"23:1197\";i:1216;s:7:\"23:1198\";i:1217;s:7:\"23:1199\";i:1218;s:7:\"23:1200\";i:1219;s:7:\"23:1201\";i:1220;s:7:\"23:1202\";i:1221;s:7:\"23:1203\";i:1222;s:7:\"23:1204\";i:1223;s:7:\"23:1205\";i:1224;s:7:\"23:1206\";i:1225;s:7:\"23:1207\";i:1226;s:7:\"23:1208\";i:1227;s:7:\"23:1209\";i:1228;s:7:\"23:1210\";i:1229;s:7:\"23:1211\";i:1230;s:7:\"23:1212\";i:1231;s:7:\"23:1213\";i:1232;s:7:\"23:1214\";i:1233;s:7:\"23:1215\";i:1234;s:7:\"23:1216\";i:1235;s:7:\"23:1217\";i:1236;s:7:\"23:1218\";i:1237;s:7:\"23:1219\";i:1238;s:7:\"23:1220\";i:1239;s:7:\"23:1221\";i:1240;s:7:\"23:1222\";i:1241;s:7:\"23:1223\";i:1242;s:7:\"23:1224\";i:1243;s:7:\"23:1225\";i:1244;s:7:\"23:1226\";i:1245;s:7:\"23:1227\";i:1246;s:7:\"23:1228\";i:1247;s:7:\"23:1229\";i:1248;s:7:\"23:1230\";i:1249;s:7:\"23:1231\";i:1250;s:7:\"23:1232\";i:1251;s:7:\"23:1233\";i:1252;s:7:\"23:1234\";i:1253;s:7:\"23:1235\";i:1254;s:7:\"23:1236\";i:1255;s:7:\"23:1237\";i:1256;s:7:\"23:1238\";i:1257;s:7:\"23:1239\";i:1258;s:7:\"23:1240\";i:1259;s:7:\"23:1241\";i:1260;s:7:\"23:1242\";i:1261;s:7:\"23:1243\";i:1262;s:7:\"23:1244\";i:1263;s:7:\"23:1245\";i:1264;s:7:\"23:1246\";i:1265;s:7:\"23:1247\";i:1266;s:7:\"23:1248\";i:1267;s:7:\"23:1249\";i:1268;s:7:\"23:1250\";i:1269;s:7:\"23:1251\";i:1270;s:7:\"23:1252\";i:1271;s:7:\"23:1253\";i:1272;s:7:\"23:1254\";i:1273;s:7:\"23:1255\";i:1274;s:7:\"23:1256\";i:1275;s:7:\"23:1257\";i:1276;s:6:\"23:145\";i:1277;s:7:\"23:1258\";i:1278;s:7:\"23:1259\";i:1279;s:7:\"23:1260\";i:1280;s:7:\"23:1261\";i:1281;s:7:\"23:1262\";i:1282;s:7:\"23:1263\";i:1283;s:7:\"23:1264\";i:1284;s:7:\"23:1265\";i:1285;s:7:\"23:1266\";i:1286;s:7:\"23:1267\";i:1287;s:7:\"23:1268\";i:1288;s:7:\"23:1269\";i:1289;s:7:\"23:1270\";i:1290;s:7:\"23:1271\";i:1291;s:7:\"23:1272\";i:1292;s:7:\"23:1273\";i:1293;s:7:\"23:1274\";i:1294;s:7:\"23:1275\";i:1295;s:7:\"23:1276\";i:1296;s:7:\"23:1277\";i:1297;s:7:\"23:1278\";i:1298;s:7:\"23:1279\";i:1299;s:7:\"23:1280\";i:1300;s:7:\"23:1281\";i:1301;s:7:\"23:1282\";i:1302;s:7:\"23:1283\";i:1303;s:7:\"23:1284\";i:1304;s:7:\"23:1285\";i:1305;s:7:\"23:1286\";i:1306;s:7:\"23:1287\";i:1307;s:7:\"23:1288\";i:1308;s:7:\"23:1289\";i:1309;s:7:\"23:1290\";i:1310;s:7:\"23:1291\";i:1311;s:7:\"23:1292\";i:1312;s:7:\"23:1293\";i:1313;s:7:\"23:1294\";i:1314;s:7:\"23:1295\";i:1315;s:7:\"23:1296\";i:1316;s:7:\"23:1297\";i:1317;s:7:\"23:1298\";i:1318;s:7:\"23:1299\";i:1319;s:7:\"23:1300\";i:1320;s:7:\"23:1301\";i:1321;s:7:\"23:1302\";i:1322;s:7:\"23:1303\";i:1323;s:7:\"23:1304\";i:1324;s:7:\"23:1305\";i:1325;s:7:\"23:1306\";i:1326;s:7:\"23:1307\";i:1327;s:7:\"23:1308\";i:1328;s:7:\"23:1309\";i:1329;s:7:\"23:1310\";i:1330;s:7:\"23:1311\";i:1331;s:7:\"23:1312\";i:1332;s:7:\"23:1313\";i:1333;s:7:\"23:1314\";i:1334;s:7:\"23:1315\";i:1335;s:7:\"23:1316\";i:1336;s:6:\"23:154\";i:1337;s:7:\"23:1317\";i:1338;s:7:\"23:1318\";i:1339;s:7:\"23:1319\";i:1340;s:7:\"23:1320\";i:1341;s:7:\"23:1321\";i:1342;s:7:\"23:1322\";i:1343;s:7:\"23:1323\";i:1344;s:7:\"23:1324\";i:1345;s:7:\"23:1325\";i:1346;s:7:\"23:1326\";i:1347;s:7:\"23:1327\";i:1348;s:7:\"23:1328\";i:1349;s:7:\"23:1329\";i:1350;s:7:\"23:1330\";i:1351;s:7:\"23:1331\";i:1352;s:6:\"23:125\";i:1353;s:7:\"23:1332\";i:1354;s:7:\"23:1333\";i:1355;s:7:\"23:1334\";i:1356;s:7:\"23:1335\";i:1357;s:7:\"23:1336\";i:1358;s:7:\"23:1337\";i:1359;s:6:\"23:132\";i:1360;s:7:\"23:1338\";i:1361;s:7:\"23:1339\";i:1362;s:7:\"23:1340\";i:1363;s:7:\"23:1341\";i:1364;s:6:\"23:157\";i:1365;s:7:\"23:1342\";i:1366;s:6:\"23:130\";i:1367;s:7:\"23:1343\";i:1368;s:7:\"23:1344\";i:1369;s:7:\"23:1345\";i:1370;s:7:\"23:1346\";i:1371;s:7:\"23:1347\";i:1372;s:7:\"23:1348\";i:1373;s:6:\"23:129\";i:1374;s:7:\"23:1349\";i:1375;s:7:\"23:1350\";i:1376;s:7:\"23:1351\";i:1377;s:7:\"23:1352\";i:1378;s:6:\"23:126\";i:1379;s:7:\"23:1353\";i:1380;s:6:\"23:127\";i:1381;s:7:\"23:1354\";i:1382;s:7:\"23:1355\";i:1383;s:7:\"23:1356\";i:1384;s:7:\"23:1357\";i:1385;s:7:\"23:1358\";i:1386;s:7:\"23:1359\";i:1387;s:7:\"23:1360\";i:1388;s:7:\"23:1361\";i:1389;s:7:\"23:1362\";i:1390;s:7:\"23:1363\";i:1391;s:7:\"23:1364\";i:1392;s:7:\"23:1365\";i:1393;s:7:\"23:1366\";i:1394;s:7:\"23:1367\";i:1395;s:7:\"23:1368\";i:1396;s:5:\"23:38\";i:1397;s:7:\"23:1369\";i:1398;s:7:\"23:1370\";i:1399;s:7:\"23:1371\";i:1400;s:7:\"23:1372\";i:1401;s:7:\"23:1373\";i:1402;s:6:\"23:115\";i:1403;s:7:\"23:1374\";i:1404;s:7:\"23:1375\";i:1405;s:7:\"23:1376\";i:1406;s:7:\"23:1377\";i:1407;s:7:\"23:1378\";i:1408;s:7:\"23:1379\";i:1409;s:7:\"23:1380\";i:1410;s:7:\"23:1381\";i:1411;s:7:\"23:1382\";i:1412;s:7:\"23:1383\";i:1413;s:7:\"23:1384\";i:1414;s:7:\"23:1385\";i:1415;s:7:\"23:1386\";i:1416;s:7:\"23:1387\";i:1417;s:7:\"23:1388\";i:1418;s:7:\"23:1389\";i:1419;s:7:\"23:1390\";i:1420;s:7:\"23:1391\";i:1421;s:7:\"23:1392\";i:1422;s:7:\"23:1393\";i:1423;s:7:\"23:1394\";i:1424;s:7:\"23:1395\";i:1425;s:7:\"23:1396\";i:1426;s:7:\"23:1397\";i:1427;s:7:\"23:1398\";i:1428;s:7:\"23:1399\";i:1429;s:7:\"23:1400\";i:1430;s:7:\"23:1401\";i:1431;s:7:\"23:1402\";i:1432;s:7:\"23:1403\";i:1433;s:7:\"23:1404\";i:1434;s:7:\"23:1405\";i:1435;s:7:\"23:1406\";i:1436;s:7:\"23:1407\";i:1437;s:7:\"23:1408\";i:1438;s:7:\"23:1409\";i:1439;s:7:\"23:1410\";i:1440;s:7:\"23:1411\";i:1441;s:7:\"23:1412\";i:1442;s:7:\"23:1413\";i:1443;s:7:\"23:1414\";i:1444;s:7:\"23:1415\";i:1445;s:7:\"23:1416\";i:1446;s:7:\"23:1417\";i:1447;s:7:\"23:1418\";i:1448;s:7:\"23:1419\";i:1449;s:7:\"23:1420\";i:1450;s:7:\"23:1421\";i:1451;s:7:\"23:1422\";i:1452;s:7:\"23:1423\";i:1453;s:7:\"23:1424\";i:1454;s:7:\"23:1425\";i:1455;s:7:\"23:1426\";i:1456;s:7:\"23:1427\";i:1457;s:5:\"23:41\";i:1458;s:7:\"23:1428\";i:1459;s:5:\"23:42\";i:1460;s:7:\"23:1429\";i:1461;s:7:\"23:1430\";i:1462;s:7:\"23:1431\";i:1463;s:7:\"23:1432\";i:1464;s:7:\"23:1433\";i:1465;s:7:\"23:1434\";i:1466;s:7:\"23:1435\";i:1467;s:7:\"23:1436\";i:1468;s:7:\"23:1437\";i:1469;s:7:\"23:1438\";i:1470;s:7:\"23:1439\";i:1471;s:7:\"23:1440\";i:1472;s:7:\"23:1441\";i:1473;s:7:\"23:1442\";i:1474;s:7:\"23:1443\";i:1475;s:7:\"23:1444\";i:1476;s:7:\"23:1445\";i:1477;s:7:\"23:1446\";i:1478;s:7:\"23:1447\";i:1479;s:7:\"23:1448\";i:1480;s:7:\"23:1449\";i:1481;s:7:\"23:1450\";i:1482;s:7:\"23:1451\";i:1483;s:7:\"23:1452\";i:1484;s:7:\"23:1453\";i:1485;s:7:\"23:1454\";i:1486;s:7:\"23:1455\";i:1487;s:7:\"23:1456\";i:1488;s:7:\"23:1457\";i:1489;s:7:\"23:1458\";i:1490;s:7:\"23:1459\";i:1491;s:7:\"23:1460\";i:1492;s:7:\"23:1461\";i:1493;s:7:\"23:1462\";i:1494;s:7:\"23:1463\";i:1495;s:7:\"23:1464\";i:1496;s:7:\"23:1465\";i:1497;s:7:\"23:1466\";i:1498;s:7:\"23:1467\";i:1499;s:7:\"23:1468\";i:1500;s:7:\"23:1469\";i:1501;s:7:\"23:1470\";i:1502;s:7:\"23:1471\";i:1503;s:7:\"23:1472\";i:1504;s:7:\"23:1473\";i:1505;s:7:\"23:1474\";i:1506;s:7:\"23:1475\";i:1507;s:7:\"23:1476\";i:1508;s:7:\"23:1477\";i:1509;s:7:\"23:1478\";i:1510;s:7:\"23:1479\";i:1511;s:7:\"23:1480\";i:1512;s:7:\"23:1481\";i:1513;s:7:\"23:1482\";i:1514;s:7:\"23:1483\";i:1515;s:7:\"23:1484\";i:1516;s:7:\"23:1485\";i:1517;s:7:\"23:1486\";i:1518;s:7:\"23:1487\";i:1519;s:5:\"23:12\";i:1520;s:7:\"23:1488\";i:1521;s:7:\"23:1489\";i:1522;s:7:\"23:1490\";i:1523;s:7:\"23:1491\";i:1524;s:7:\"23:1492\";i:1525;s:7:\"23:1493\";i:1526;s:7:\"23:1494\";i:1527;s:7:\"23:1495\";i:1528;s:7:\"23:1496\";i:1529;s:7:\"23:1497\";i:1530;s:7:\"23:1498\";i:1531;s:7:\"23:1499\";i:1532;s:7:\"23:1500\";i:1533;s:7:\"23:1501\";i:1534;s:7:\"23:1502\";i:1535;s:7:\"23:1503\";i:1536;s:7:\"23:1504\";i:1537;s:7:\"23:1505\";i:1538;s:7:\"23:1506\";i:1539;s:7:\"23:1507\";i:1540;s:7:\"23:1508\";i:1541;s:7:\"23:1509\";i:1542;s:7:\"23:1510\";i:1543;s:7:\"23:1511\";i:1544;s:7:\"23:1512\";i:1545;s:7:\"23:1513\";i:1546;s:7:\"23:1514\";i:1547;s:7:\"23:1515\";i:1548;s:7:\"23:1516\";i:1549;s:7:\"23:1517\";i:1550;s:7:\"23:1518\";i:1551;s:7:\"23:1519\";i:1552;s:7:\"23:1520\";i:1553;s:7:\"23:1521\";i:1554;s:7:\"23:1522\";i:1555;s:7:\"23:1523\";i:1556;s:7:\"23:1524\";i:1557;s:7:\"23:1525\";i:1558;s:7:\"23:1526\";i:1559;s:7:\"23:1527\";i:1560;s:7:\"23:1528\";i:1561;s:7:\"23:1529\";i:1562;s:7:\"23:1530\";i:1563;s:7:\"23:1531\";i:1564;s:7:\"23:1532\";i:1565;s:7:\"23:1533\";i:1566;s:7:\"23:1534\";i:1567;s:7:\"23:1535\";i:1568;s:7:\"23:1536\";i:1569;s:7:\"23:1537\";i:1570;s:7:\"23:1538\";i:1571;s:7:\"23:1539\";i:1572;s:7:\"23:1540\";i:1573;s:7:\"23:1541\";i:1574;s:7:\"23:1542\";i:1575;s:7:\"23:1543\";i:1576;s:7:\"23:1544\";i:1577;s:7:\"23:1545\";i:1578;s:7:\"23:1546\";i:1579;s:7:\"23:1547\";i:1580;s:7:\"23:1548\";i:1581;s:7:\"23:1549\";i:1582;s:7:\"23:1550\";i:1583;s:7:\"23:1551\";i:1584;s:7:\"23:1552\";i:1585;s:7:\"23:1553\";i:1586;s:7:\"23:1554\";i:1587;s:7:\"23:1555\";i:1588;s:7:\"23:1556\";i:1589;s:7:\"23:1557\";i:1590;s:7:\"23:1558\";i:1591;s:7:\"23:1559\";i:1592;s:7:\"23:1560\";i:1593;s:7:\"23:1561\";i:1594;s:7:\"23:1562\";i:1595;s:7:\"23:1563\";i:1596;s:7:\"23:1564\";i:1597;s:7:\"23:1565\";i:1598;s:7:\"23:1566\";i:1599;s:7:\"23:1567\";i:1600;s:7:\"23:1568\";i:1601;s:7:\"23:1569\";i:1602;s:7:\"23:1570\";i:1603;s:7:\"23:1571\";i:1604;s:7:\"23:1572\";i:1605;s:7:\"23:1573\";i:1606;s:7:\"23:1574\";i:1607;s:7:\"23:1575\";i:1608;s:7:\"23:1576\";i:1609;s:7:\"23:1577\";i:1610;s:7:\"23:1578\";i:1611;s:7:\"23:1579\";i:1612;s:7:\"23:1580\";i:1613;s:7:\"23:1581\";i:1614;s:7:\"23:1582\";i:1615;s:7:\"23:1583\";i:1616;s:7:\"23:1584\";i:1617;s:7:\"23:1585\";i:1618;s:7:\"23:1586\";i:1619;s:7:\"23:1587\";i:1620;s:7:\"23:1588\";i:1621;s:7:\"23:1589\";i:1622;s:7:\"23:1590\";i:1623;s:7:\"23:1591\";i:1624;s:7:\"23:1592\";i:1625;s:7:\"23:1593\";i:1626;s:7:\"23:1594\";i:1627;s:7:\"23:1595\";i:1628;s:7:\"23:1596\";i:1629;s:7:\"23:1597\";i:1630;s:7:\"23:1598\";i:1631;s:7:\"23:1599\";i:1632;s:7:\"23:1600\";i:1633;s:7:\"23:1601\";i:1634;s:7:\"23:1602\";i:1635;s:7:\"23:1603\";i:1636;s:7:\"23:1604\";i:1637;s:7:\"23:1605\";i:1638;s:7:\"23:1606\";i:1639;s:7:\"23:1607\";i:1640;s:7:\"23:1608\";i:1641;s:7:\"23:1609\";i:1642;s:7:\"23:1610\";i:1643;s:7:\"23:1611\";i:1644;s:7:\"23:1612\";i:1645;s:7:\"23:1613\";i:1646;s:7:\"23:1614\";i:1647;s:7:\"23:1615\";i:1648;s:7:\"23:1616\";i:1649;s:7:\"23:1617\";i:1650;s:7:\"23:1618\";i:1651;s:7:\"23:1619\";i:1652;s:7:\"23:1620\";i:1653;s:7:\"23:1621\";i:1654;s:7:\"23:1622\";i:1655;s:7:\"23:1623\";i:1656;s:7:\"23:1624\";i:1657;s:7:\"23:1625\";i:1658;s:7:\"23:1626\";i:1659;s:7:\"23:1627\";i:1660;s:7:\"23:1628\";i:1661;s:7:\"23:1629\";i:1662;s:7:\"23:1630\";i:1663;s:7:\"23:1631\";i:1664;s:7:\"23:1632\";i:1665;s:7:\"23:1633\";i:1666;s:7:\"23:1634\";i:1667;s:7:\"23:1635\";i:1668;s:7:\"23:1636\";i:1669;s:7:\"23:1637\";i:1670;s:7:\"23:1638\";i:1671;s:7:\"23:1639\";i:1672;s:7:\"23:1640\";i:1673;s:7:\"23:1641\";i:1674;s:7:\"23:1642\";i:1675;s:7:\"23:1643\";i:1676;s:7:\"23:1644\";i:1677;s:7:\"23:1645\";i:1678;s:7:\"23:1646\";i:1679;s:7:\"23:1647\";i:1680;s:7:\"23:1648\";i:1681;s:7:\"23:1649\";i:1682;s:7:\"23:1650\";i:1683;s:7:\"23:1651\";i:1684;s:7:\"23:1652\";i:1685;s:7:\"23:1653\";i:1686;s:7:\"23:1654\";i:1687;s:7:\"23:1655\";i:1688;s:7:\"23:1656\";i:1689;s:7:\"23:1657\";i:1690;s:7:\"23:1658\";i:1691;s:7:\"23:1659\";i:1692;s:7:\"23:1660\";i:1693;s:7:\"23:1661\";i:1694;s:7:\"23:1662\";i:1695;s:7:\"23:1663\";i:1696;s:7:\"23:1664\";i:1697;s:7:\"23:1665\";i:1698;s:7:\"23:1666\";i:1699;s:7:\"23:1667\";i:1700;s:7:\"23:1668\";i:1701;s:7:\"23:1669\";i:1702;s:7:\"23:1670\";i:1703;s:7:\"23:1671\";i:1704;s:7:\"23:1672\";i:1705;s:7:\"23:1673\";i:1706;s:7:\"23:1674\";i:1707;s:7:\"23:1675\";i:1708;s:7:\"23:1676\";i:1709;s:7:\"23:1677\";i:1710;s:7:\"23:1678\";i:1711;s:7:\"23:1679\";i:1712;s:7:\"23:1680\";i:1713;s:7:\"23:1681\";i:1714;s:7:\"23:1682\";i:1715;s:7:\"23:1683\";i:1716;s:7:\"23:1684\";i:1717;s:7:\"23:1685\";i:1718;s:7:\"23:1686\";i:1719;s:7:\"23:1687\";i:1720;s:7:\"23:1688\";i:1721;s:7:\"23:1689\";i:1722;s:7:\"23:1690\";i:1723;s:7:\"23:1691\";i:1724;s:7:\"23:1692\";i:1725;s:7:\"23:1693\";i:1726;s:7:\"23:1694\";i:1727;s:7:\"23:1695\";i:1728;s:7:\"23:1696\";i:1729;s:7:\"23:1697\";i:1730;s:7:\"23:1698\";i:1731;s:7:\"23:1699\";i:1732;s:7:\"23:1700\";i:1733;s:7:\"23:1701\";i:1734;s:7:\"23:1702\";i:1735;s:7:\"23:1703\";i:1736;s:7:\"23:1704\";i:1737;s:7:\"23:1705\";i:1738;s:7:\"23:1706\";i:1739;s:7:\"23:1707\";i:1740;s:7:\"23:1708\";i:1741;s:7:\"23:1709\";i:1742;s:7:\"23:1710\";i:1743;s:7:\"23:1711\";i:1744;s:7:\"23:1712\";i:1745;s:7:\"23:1713\";i:1746;s:7:\"23:1714\";i:1747;s:7:\"23:1715\";i:1748;s:7:\"23:1716\";i:1749;s:7:\"23:1717\";i:1750;s:7:\"23:1718\";i:1751;s:7:\"23:1719\";i:1752;s:7:\"23:1720\";i:1753;s:7:\"23:1721\";i:1754;s:7:\"23:1722\";i:1755;s:7:\"23:1723\";i:1756;s:7:\"23:1724\";i:1757;s:7:\"23:1725\";i:1758;s:7:\"23:1726\";i:1759;s:7:\"23:1727\";i:1760;s:7:\"23:1728\";i:1761;s:7:\"23:1729\";i:1762;s:7:\"23:1730\";i:1763;s:7:\"23:1731\";i:1764;s:7:\"23:1732\";i:1765;s:7:\"23:1733\";i:1766;s:7:\"23:1734\";i:1767;s:7:\"23:1735\";i:1768;s:7:\"23:1736\";i:1769;s:7:\"23:1737\";i:1770;s:7:\"23:1738\";i:1771;s:7:\"23:1739\";i:1772;s:7:\"23:1740\";i:1773;s:7:\"23:1741\";i:1774;s:7:\"23:1742\";i:1775;s:7:\"23:1743\";i:1776;s:7:\"23:1744\";i:1777;s:7:\"23:1745\";i:1778;s:7:\"23:1746\";i:1779;s:7:\"23:1747\";i:1780;s:7:\"23:1748\";i:1781;s:7:\"23:1749\";i:1782;s:7:\"23:1750\";i:1783;s:7:\"23:1751\";i:1784;s:7:\"23:1752\";i:1785;s:7:\"23:1753\";i:1786;s:7:\"23:1754\";i:1787;s:7:\"23:1755\";i:1788;s:7:\"23:1756\";i:1789;s:7:\"23:1757\";i:1790;s:7:\"23:1758\";i:1791;s:7:\"23:1759\";i:1792;s:7:\"23:1760\";i:1793;s:7:\"23:1761\";i:1794;s:7:\"23:1762\";i:1795;s:7:\"23:1763\";i:1796;s:7:\"23:1764\";i:1797;s:7:\"23:1765\";i:1798;s:7:\"23:1766\";i:1799;s:7:\"23:1767\";i:1800;s:7:\"23:1768\";i:1801;s:7:\"23:1769\";i:1802;s:7:\"23:1770\";i:1803;s:7:\"23:1771\";i:1804;s:7:\"23:1772\";i:1805;s:7:\"23:1773\";i:1806;s:7:\"23:1774\";i:1807;s:7:\"23:1775\";i:1808;s:7:\"23:1776\";i:1809;s:7:\"23:1777\";i:1810;s:7:\"23:1778\";i:1811;s:7:\"23:1779\";i:1812;s:7:\"23:1780\";i:1813;s:7:\"23:1781\";i:1814;s:7:\"23:1782\";i:1815;s:7:\"23:1783\";i:1816;s:7:\"23:1784\";i:1817;s:7:\"23:1785\";i:1818;s:7:\"23:1786\";i:1819;s:7:\"23:1787\";i:1820;s:7:\"23:1788\";i:1821;s:7:\"23:1789\";i:1822;s:7:\"23:1790\";i:1823;s:7:\"23:1791\";i:1824;s:7:\"23:1792\";i:1825;s:7:\"23:1793\";i:1826;s:7:\"23:1794\";i:1827;s:7:\"23:1795\";i:1828;s:7:\"23:1796\";i:1829;s:7:\"23:1797\";i:1830;s:7:\"23:1798\";i:1831;s:7:\"23:1799\";i:1832;s:7:\"23:1800\";i:1833;s:7:\"23:1801\";i:1834;s:7:\"23:1802\";i:1835;s:7:\"23:1803\";i:1836;s:7:\"23:1804\";i:1837;s:7:\"23:1805\";i:1838;s:7:\"23:1806\";i:1839;s:7:\"23:1807\";i:1840;s:7:\"23:1808\";i:1841;s:7:\"23:1809\";i:1842;s:7:\"23:1810\";i:1843;s:7:\"23:1811\";i:1844;s:7:\"23:1812\";i:1845;s:7:\"23:1813\";i:1846;s:7:\"23:1814\";i:1847;s:7:\"23:1815\";i:1848;s:7:\"23:1816\";i:1849;s:7:\"23:1817\";i:1850;s:7:\"23:1818\";i:1851;s:7:\"23:1819\";i:1852;s:7:\"23:1820\";i:1853;s:7:\"23:1821\";i:1854;s:7:\"23:1822\";i:1855;s:7:\"23:1823\";i:1856;s:7:\"23:1824\";i:1857;s:6:\"23:156\";i:1858;s:7:\"23:1825\";i:1859;s:7:\"23:1826\";i:1860;s:7:\"23:1827\";i:1861;s:7:\"23:1828\";i:1862;s:7:\"23:1829\";i:1863;s:7:\"23:1830\";i:1864;s:7:\"23:1831\";i:1865;s:7:\"23:1832\";i:1866;s:7:\"23:1833\";i:1867;s:7:\"23:1834\";i:1868;s:7:\"23:1835\";i:1869;s:7:\"23:1836\";i:1870;s:7:\"23:1837\";i:1871;s:7:\"23:1838\";i:1872;s:7:\"23:1839\";i:1873;s:7:\"23:1840\";i:1874;s:7:\"23:1841\";i:1875;s:7:\"23:1842\";i:1876;s:7:\"23:1843\";i:1877;s:7:\"23:1844\";i:1878;s:7:\"23:1845\";i:1879;s:7:\"23:1846\";i:1880;s:7:\"23:1847\";i:1881;s:7:\"23:1848\";i:1882;s:7:\"23:1849\";i:1883;s:7:\"23:1850\";i:1884;s:7:\"23:1851\";i:1885;s:7:\"23:1852\";i:1886;s:7:\"23:1853\";i:1887;s:7:\"23:1854\";i:1888;s:7:\"23:1855\";i:1889;s:7:\"23:1856\";i:1890;s:7:\"23:1857\";i:1891;s:7:\"23:1858\";i:1892;s:7:\"23:1859\";i:1893;s:7:\"23:1860\";i:1894;s:7:\"23:1861\";i:1895;s:7:\"23:1862\";i:1896;s:7:\"23:1863\";i:1897;s:7:\"23:1864\";i:1898;s:7:\"23:1865\";i:1899;s:7:\"23:1866\";i:1900;s:7:\"23:1867\";i:1901;s:7:\"23:1868\";i:1902;s:7:\"23:1869\";i:1903;s:7:\"23:1870\";i:1904;s:7:\"23:1871\";i:1905;s:7:\"23:1872\";i:1906;s:7:\"23:1873\";i:1907;s:7:\"23:1874\";i:1908;s:7:\"23:1875\";i:1909;s:7:\"23:1876\";i:1910;s:7:\"23:1877\";i:1911;s:7:\"23:1878\";i:1912;s:7:\"23:1879\";i:1913;s:7:\"23:1880\";i:1914;s:7:\"23:1881\";i:1915;s:7:\"23:1882\";i:1916;s:7:\"23:1883\";i:1917;s:7:\"23:1884\";i:1918;s:7:\"23:1885\";i:1919;s:7:\"23:1886\";i:1920;s:7:\"23:1887\";i:1921;s:7:\"23:1888\";i:1922;s:7:\"23:1889\";i:1923;s:7:\"23:1890\";i:1924;s:7:\"23:1891\";i:1925;s:7:\"23:1892\";i:1926;s:7:\"23:1893\";i:1927;s:7:\"23:1894\";i:1928;s:7:\"23:1895\";i:1929;s:7:\"23:1896\";i:1930;s:7:\"23:1897\";i:1931;s:7:\"23:1898\";i:1932;s:7:\"23:1899\";i:1933;s:7:\"23:1900\";i:1934;s:7:\"23:1901\";i:1935;s:7:\"23:1902\";i:1936;s:7:\"23:1903\";i:1937;s:7:\"23:1904\";i:1938;s:7:\"23:1905\";i:1939;s:7:\"23:1906\";i:1940;s:7:\"23:1907\";i:1941;s:7:\"23:1908\";i:1942;s:7:\"23:1909\";i:1943;s:7:\"23:1910\";i:1944;s:7:\"23:1911\";i:1945;s:7:\"23:1912\";i:1946;s:7:\"23:1913\";i:1947;s:7:\"23:1914\";i:1948;s:7:\"23:1915\";i:1949;s:7:\"23:1916\";i:1950;s:7:\"23:1917\";i:1951;s:7:\"23:1918\";i:1952;s:7:\"23:1919\";i:1953;s:7:\"23:1920\";i:1954;s:6:\"23:140\";i:1955;s:6:\"23:141\";i:1956;s:7:\"23:1921\";i:1957;s:7:\"23:1922\";i:1958;s:7:\"23:1923\";i:1959;s:7:\"23:1924\";i:1960;s:7:\"23:1925\";i:1961;s:7:\"23:1926\";i:1962;s:7:\"23:1927\";i:1963;s:7:\"23:1928\";i:1964;s:7:\"23:1929\";i:1965;s:7:\"23:1930\";i:1966;s:7:\"23:1931\";i:1967;s:7:\"23:1932\";i:1968;s:7:\"23:1933\";i:1969;s:7:\"23:1934\";i:1970;s:7:\"23:1935\";i:1971;s:7:\"23:1936\";i:1972;s:7:\"23:1937\";i:1973;s:7:\"23:1938\";i:1974;s:7:\"23:1939\";i:1975;s:7:\"23:1940\";i:1976;s:7:\"23:1941\";i:1977;s:7:\"23:1942\";i:1978;s:7:\"23:1943\";i:1979;s:7:\"23:1944\";i:1980;s:7:\"23:1945\";i:1981;s:7:\"23:1946\";i:1982;s:7:\"23:1947\";i:1983;s:7:\"23:1948\";i:1984;s:7:\"23:1949\";i:1985;s:7:\"23:1950\";i:1986;s:7:\"23:1951\";i:1987;s:7:\"23:1952\";i:1988;s:7:\"23:1953\";i:1989;s:7:\"23:1954\";i:1990;s:7:\"23:1955\";i:1991;s:7:\"23:1956\";i:1992;s:7:\"23:1957\";i:1993;s:7:\"23:1958\";i:1994;s:7:\"23:1959\";i:1995;s:7:\"23:1960\";i:1996;s:7:\"23:1961\";i:1997;s:7:\"23:1962\";i:1998;s:7:\"23:1963\";i:1999;s:7:\"23:1964\";i:2000;s:7:\"23:1965\";i:2001;s:7:\"23:1966\";i:2002;s:7:\"23:1967\";i:2003;s:7:\"23:1968\";i:2004;s:7:\"23:1969\";i:2005;s:7:\"23:1970\";i:2006;s:7:\"23:1971\";i:2007;s:7:\"23:1972\";i:2008;s:7:\"23:1973\";i:2009;s:7:\"23:1974\";i:2010;s:7:\"23:1975\";i:2011;s:7:\"23:1976\";i:2012;s:7:\"23:1977\";i:2013;s:7:\"23:1978\";i:2014;s:7:\"23:1979\";i:2015;s:7:\"23:1980\";i:2016;s:7:\"23:1981\";i:2017;s:7:\"23:1982\";i:2018;s:7:\"23:1983\";i:2019;s:7:\"23:1984\";i:2020;s:7:\"23:1985\";i:2021;s:7:\"23:1986\";i:2022;s:7:\"23:1987\";i:2023;s:7:\"23:1988\";i:2024;s:7:\"23:1989\";i:2025;s:7:\"23:1990\";i:2026;s:7:\"23:1991\";i:2027;s:7:\"23:1992\";i:2028;s:7:\"23:1993\";i:2029;s:7:\"23:1994\";i:2030;s:7:\"23:1995\";i:2031;s:7:\"23:1996\";i:2032;s:7:\"23:1997\";i:2033;s:7:\"23:1998\";i:2034;s:7:\"23:1999\";i:2035;s:7:\"23:2000\";i:2036;s:7:\"23:2001\";i:2037;s:7:\"23:2002\";i:2038;s:7:\"23:2003\";i:2039;s:7:\"23:2004\";i:2040;s:7:\"23:2005\";i:2041;s:7:\"23:2006\";i:2042;s:7:\"23:2007\";i:2043;s:7:\"23:2008\";i:2044;s:7:\"23:2009\";i:2045;s:7:\"23:2010\";i:2046;s:7:\"23:2011\";i:2047;s:7:\"23:2012\";i:2048;s:7:\"23:2013\";i:2049;s:7:\"23:2014\";i:2050;s:7:\"23:2015\";i:2051;s:7:\"23:2016\";i:2052;s:7:\"23:2017\";i:2053;s:7:\"23:2018\";i:2054;s:7:\"23:2019\";i:2055;s:7:\"23:2020\";i:2056;s:7:\"23:2021\";i:2057;s:7:\"23:2022\";i:2058;s:7:\"23:2023\";i:2059;s:7:\"23:2024\";i:2060;s:7:\"23:2025\";i:2061;s:7:\"23:2026\";i:2062;s:7:\"23:2027\";i:2063;s:7:\"23:2028\";i:2064;s:7:\"23:2029\";i:2065;s:7:\"23:2030\";i:2066;s:7:\"23:2031\";i:2067;s:7:\"23:2032\";i:2068;s:7:\"23:2033\";i:2069;s:5:\"23:33\";i:2070;s:7:\"23:2034\";i:2071;s:7:\"23:2035\";i:2072;s:7:\"23:2036\";i:2073;s:7:\"23:2037\";i:2074;s:7:\"23:2038\";i:2075;s:7:\"23:2039\";i:2076;s:7:\"23:2040\";i:2077;s:7:\"23:2041\";i:2078;s:7:\"23:2042\";i:2079;s:7:\"23:2043\";i:2080;s:7:\"23:2044\";i:2081;s:7:\"23:2045\";i:2082;s:7:\"23:2046\";i:2083;s:7:\"23:2047\";i:2084;s:7:\"23:2048\";i:2085;s:7:\"23:2049\";i:2086;s:7:\"23:2050\";i:2087;s:7:\"23:2051\";i:2088;s:7:\"23:2052\";i:2089;s:7:\"23:2053\";i:2090;s:7:\"23:2054\";i:2091;s:7:\"23:2055\";i:2092;s:7:\"23:2056\";i:2093;s:7:\"23:2057\";i:2094;s:7:\"23:2058\";i:2095;s:7:\"23:2059\";i:2096;s:7:\"23:2060\";i:2097;s:6:\"23:148\";i:2098;s:6:\"23:149\";i:2099;s:7:\"23:2061\";i:2100;s:7:\"23:2062\";i:2101;s:7:\"23:2063\";i:2102;s:7:\"23:2064\";i:2103;s:7:\"23:2065\";i:2104;s:7:\"23:2066\";i:2105;s:7:\"23:2067\";i:2106;s:7:\"23:2068\";i:2107;s:7:\"23:2069\";i:2108;s:7:\"23:2070\";i:2109;s:7:\"23:2071\";i:2110;s:7:\"23:2072\";i:2111;s:7:\"23:2073\";i:2112;s:7:\"23:2074\";i:2113;s:7:\"23:2075\";i:2114;s:7:\"23:2076\";i:2115;s:7:\"23:2077\";i:2116;s:7:\"23:2078\";i:2117;s:7:\"23:2079\";i:2118;s:7:\"23:2080\";i:2119;s:7:\"23:2081\";i:2120;s:7:\"23:2082\";i:2121;s:7:\"23:2083\";i:2122;s:7:\"23:2084\";i:2123;s:7:\"23:2085\";i:2124;s:7:\"23:2086\";i:2125;s:7:\"23:2087\";i:2126;s:7:\"23:2088\";i:2127;s:7:\"23:2089\";i:2128;s:6:\"23:150\";i:2129;s:7:\"23:2090\";i:2130;s:7:\"23:2091\";i:2131;s:7:\"23:2092\";i:2132;s:6:\"23:151\";i:2133;s:7:\"23:2093\";i:2134;s:7:\"23:2094\";i:2135;s:7:\"23:2095\";i:2136;s:7:\"23:2096\";i:2137;s:7:\"23:2097\";i:2138;s:6:\"23:152\";i:2139;s:7:\"23:2098\";i:2140;s:7:\"23:2099\";i:2141;s:7:\"23:2100\";i:2142;s:7:\"23:2101\";i:2143;s:7:\"23:2102\";i:2144;s:7:\"23:2103\";i:2145;s:7:\"23:2104\";i:2146;s:7:\"23:2105\";i:2147;s:7:\"23:2106\";i:2148;s:7:\"23:2107\";i:2149;s:7:\"23:2108\";i:2150;s:7:\"23:2109\";i:2151;s:7:\"23:2110\";i:2152;s:7:\"23:2111\";i:2153;s:7:\"23:2112\";i:2154;s:7:\"23:2113\";i:2155;s:7:\"23:2114\";i:2156;s:7:\"23:2115\";i:2157;s:7:\"23:2116\";i:2158;s:7:\"23:2117\";i:2159;s:7:\"23:2118\";i:2160;s:7:\"23:2119\";i:2161;s:7:\"23:2120\";i:2162;s:7:\"23:2121\";i:2163;s:7:\"23:2122\";i:2164;s:7:\"23:2123\";i:2165;s:7:\"23:2124\";i:2166;s:7:\"23:2125\";i:2167;s:7:\"23:2126\";i:2168;s:7:\"23:2127\";i:2169;s:7:\"23:2128\";i:2170;s:7:\"23:2129\";i:2171;s:7:\"23:2130\";i:2172;s:7:\"23:2131\";i:2173;s:7:\"23:2132\";i:2174;s:7:\"23:2133\";i:2175;s:7:\"23:2134\";i:2176;s:7:\"23:2135\";i:2177;s:7:\"23:2136\";i:2178;s:7:\"23:2137\";i:2179;s:7:\"23:2138\";i:2180;s:7:\"23:2139\";i:2181;s:7:\"23:2140\";i:2182;s:7:\"23:2141\";i:2183;s:7:\"23:2142\";i:2184;s:7:\"23:2143\";i:2185;s:7:\"23:2144\";i:2186;s:7:\"23:2145\";i:2187;s:7:\"23:2146\";i:2188;s:7:\"23:2147\";i:2189;s:7:\"23:2148\";i:2190;s:7:\"23:2149\";i:2191;s:7:\"23:2150\";i:2192;s:7:\"23:2151\";i:2193;s:7:\"23:2152\";i:2194;s:7:\"23:2153\";i:2195;s:7:\"23:2154\";i:2196;s:7:\"23:2155\";i:2197;s:7:\"23:2156\";i:2198;s:7:\"23:2157\";i:2199;s:7:\"23:2158\";i:2200;s:7:\"23:2159\";i:2201;s:7:\"23:2160\";i:2202;s:7:\"23:2161\";i:2203;s:7:\"23:2162\";i:2204;s:7:\"23:2163\";i:2205;s:7:\"23:2164\";i:2206;s:7:\"23:2165\";i:2207;s:7:\"23:2166\";i:2208;s:7:\"23:2167\";i:2209;s:7:\"23:2168\";i:2210;s:7:\"23:2169\";i:2211;s:7:\"23:2170\";i:2212;s:7:\"23:2171\";i:2213;s:7:\"23:2172\";i:2214;s:7:\"23:2173\";i:2215;s:7:\"23:2174\";i:2216;s:7:\"23:2175\";i:2217;s:7:\"23:2176\";i:2218;s:7:\"23:2177\";i:2219;s:7:\"23:2178\";i:2220;s:7:\"23:2179\";i:2221;s:7:\"23:2180\";i:2222;s:7:\"23:2181\";i:2223;s:7:\"23:2182\";i:2224;s:7:\"23:2183\";i:2225;s:7:\"23:2184\";i:2226;s:7:\"23:2185\";i:2227;s:7:\"23:2186\";i:2228;s:7:\"23:2187\";i:2229;s:7:\"23:2188\";i:2230;s:7:\"23:2189\";i:2231;s:7:\"23:2190\";i:2232;s:7:\"23:2191\";i:2233;s:7:\"23:2192\";i:2234;s:7:\"23:2193\";i:2235;s:7:\"23:2194\";i:2236;s:7:\"23:2195\";i:2237;s:7:\"23:2196\";i:2238;s:7:\"23:2197\";i:2239;s:7:\"23:2198\";i:2240;s:7:\"23:2199\";i:2241;s:7:\"23:2200\";i:2242;s:7:\"23:2201\";i:2243;s:7:\"23:2202\";i:2244;s:7:\"23:2203\";i:2245;s:7:\"23:2204\";i:2246;s:7:\"23:2205\";i:2247;s:7:\"23:2206\";i:2248;s:7:\"23:2207\";i:2249;s:7:\"23:2208\";i:2250;s:7:\"23:2209\";i:2251;s:7:\"23:2210\";i:2252;s:7:\"23:2211\";i:2253;s:7:\"23:2212\";i:2254;s:7:\"23:2213\";i:2255;s:7:\"23:2214\";i:2256;s:7:\"23:2215\";i:2257;s:7:\"23:2216\";i:2258;s:7:\"23:2217\";i:2259;s:7:\"23:2218\";i:2260;s:7:\"23:2219\";i:2261;s:7:\"23:2220\";i:2262;s:7:\"23:2221\";i:2263;s:7:\"23:2222\";i:2264;s:7:\"23:2223\";i:2265;s:7:\"23:2224\";i:2266;s:7:\"23:2225\";i:2267;s:7:\"23:2226\";i:2268;s:7:\"23:2227\";i:2269;s:7:\"23:2228\";i:2270;s:7:\"23:2229\";i:2271;s:7:\"23:2230\";i:2272;s:7:\"23:2231\";i:2273;s:7:\"23:2232\";i:2274;s:7:\"23:2233\";i:2275;s:7:\"23:2234\";i:2276;s:7:\"23:2235\";i:2277;s:7:\"23:2236\";i:2278;s:7:\"23:2237\";i:2279;s:7:\"23:2238\";i:2280;s:7:\"23:2239\";i:2281;s:7:\"23:2240\";i:2282;s:7:\"23:2241\";i:2283;s:7:\"23:2242\";i:2284;s:7:\"23:2243\";i:2285;s:7:\"23:2244\";i:2286;s:7:\"23:2245\";i:2287;s:7:\"23:2246\";i:2288;s:7:\"23:2247\";i:2289;s:7:\"23:2248\";i:2290;s:7:\"23:2249\";i:2291;s:7:\"23:2250\";i:2292;s:7:\"23:2251\";i:2293;s:7:\"23:2252\";i:2294;s:7:\"23:2253\";i:2295;s:7:\"23:2254\";i:2296;s:7:\"23:2255\";i:2297;s:7:\"23:2256\";i:2298;s:7:\"23:2257\";i:2299;s:7:\"23:2258\";i:2300;s:7:\"23:2259\";i:2301;s:7:\"23:2260\";i:2302;s:7:\"23:2261\";i:2303;s:7:\"23:2262\";i:2304;s:7:\"23:2263\";i:2305;s:7:\"23:2264\";i:2306;s:7:\"23:2265\";i:2307;s:7:\"23:2266\";i:2308;s:7:\"23:2267\";i:2309;s:7:\"23:2268\";i:2310;s:7:\"23:2269\";i:2311;s:7:\"23:2270\";i:2312;s:7:\"23:2271\";i:2313;s:7:\"23:2272\";i:2314;s:7:\"23:2273\";i:2315;s:7:\"23:2274\";i:2316;s:7:\"23:2275\";i:2317;s:7:\"23:2276\";i:2318;s:7:\"23:2277\";i:2319;s:7:\"23:2278\";i:2320;s:7:\"23:2279\";i:2321;s:7:\"23:2280\";i:2322;s:7:\"23:2281\";i:2323;s:7:\"23:2282\";i:2324;s:7:\"23:2283\";i:2325;s:7:\"23:2284\";i:2326;s:7:\"23:2285\";i:2327;s:7:\"23:2286\";i:2328;s:7:\"23:2287\";i:2329;s:7:\"23:2288\";i:2330;s:7:\"23:2289\";i:2331;s:7:\"23:2290\";i:2332;s:7:\"23:2291\";i:2333;s:7:\"23:2292\";i:2334;s:7:\"23:2293\";i:2335;s:7:\"23:2294\";i:2336;s:7:\"23:2295\";i:2337;s:7:\"23:2296\";i:2338;s:7:\"23:2297\";i:2339;s:7:\"23:2298\";i:2340;s:7:\"23:2299\";i:2341;s:7:\"23:2300\";i:2342;s:7:\"23:2301\";i:2343;s:7:\"23:2302\";i:2344;s:7:\"23:2303\";i:2345;s:7:\"23:2304\";i:2346;s:7:\"23:2305\";i:2347;s:7:\"23:2306\";i:2348;s:7:\"23:2307\";i:2349;s:7:\"23:2308\";i:2350;s:7:\"23:2309\";i:2351;s:7:\"23:2310\";i:2352;s:7:\"23:2311\";i:2353;s:7:\"23:2312\";i:2354;s:7:\"23:2313\";i:2355;s:7:\"23:2314\";i:2356;s:7:\"23:2315\";i:2357;s:7:\"23:2316\";i:2358;s:7:\"23:2317\";i:2359;s:7:\"23:2318\";i:2360;s:7:\"23:2319\";i:2361;s:7:\"23:2320\";i:2362;s:7:\"23:2321\";i:2363;s:7:\"23:2322\";i:2364;s:7:\"23:2323\";i:2365;s:7:\"23:2324\";i:2366;s:7:\"23:2325\";i:2367;s:7:\"23:2326\";i:2368;s:7:\"23:2327\";i:2369;s:7:\"23:2328\";i:2370;s:7:\"23:2329\";i:2371;s:7:\"23:2330\";i:2372;s:7:\"23:2331\";i:2373;s:7:\"23:2332\";i:2374;s:7:\"23:2333\";i:2375;s:7:\"23:2334\";i:2376;s:7:\"23:2335\";i:2377;s:7:\"23:2336\";i:2378;s:7:\"23:2337\";i:2379;s:7:\"23:2338\";i:2380;s:7:\"23:2339\";i:2381;s:7:\"23:2340\";i:2382;s:7:\"23:2341\";i:2383;s:7:\"23:2342\";i:2384;s:7:\"23:2343\";i:2385;s:7:\"23:2344\";i:2386;s:7:\"23:2345\";i:2387;s:7:\"23:2346\";i:2388;s:7:\"23:2347\";i:2389;s:7:\"23:2348\";i:2390;s:7:\"23:2349\";i:2391;s:7:\"23:2350\";i:2392;s:7:\"23:2351\";i:2393;s:7:\"23:2352\";i:2394;s:7:\"23:2353\";i:2395;s:7:\"23:2354\";i:2396;s:7:\"23:2355\";i:2397;s:7:\"23:2356\";i:2398;s:7:\"23:2357\";i:2399;s:7:\"23:2358\";i:2400;s:7:\"23:2359\";i:2401;s:7:\"23:2360\";i:2402;s:7:\"23:2361\";i:2403;s:7:\"23:2362\";i:2404;s:7:\"23:2363\";i:2405;s:7:\"23:2364\";i:2406;s:7:\"23:2365\";i:2407;s:7:\"23:2366\";i:2408;s:7:\"23:2367\";i:2409;s:7:\"23:2368\";i:2410;s:7:\"23:2369\";i:2411;s:7:\"23:2370\";i:2412;s:7:\"23:2371\";i:2413;s:7:\"23:2372\";i:2414;s:7:\"23:2373\";i:2415;s:7:\"23:2374\";i:2416;s:7:\"23:2375\";i:2417;s:7:\"23:2376\";i:2418;s:7:\"23:2377\";i:2419;s:7:\"23:2378\";i:2420;s:7:\"23:2379\";i:2421;s:7:\"23:2380\";i:2422;s:7:\"23:2381\";i:2423;s:7:\"23:2382\";i:2424;s:7:\"23:2383\";i:2425;s:7:\"23:2384\";i:2426;s:7:\"23:2385\";i:2427;s:7:\"23:2386\";i:2428;s:7:\"23:2387\";i:2429;s:7:\"23:2388\";i:2430;s:7:\"23:2389\";i:2431;s:7:\"23:2390\";i:2432;s:7:\"23:2391\";i:2433;s:7:\"23:2392\";i:2434;s:7:\"23:2393\";i:2435;s:7:\"23:2394\";i:2436;s:7:\"23:2395\";i:2437;s:7:\"23:2396\";i:2438;s:7:\"23:2397\";i:2439;s:7:\"23:2398\";i:2440;s:7:\"23:2399\";i:2441;s:7:\"23:2400\";i:2442;s:7:\"23:2401\";i:2443;s:7:\"23:2402\";i:2444;s:7:\"23:2403\";i:2445;s:7:\"23:2404\";i:2446;s:7:\"23:2405\";i:2447;s:7:\"23:2406\";i:2448;s:7:\"23:2407\";i:2449;s:7:\"23:2408\";i:2450;s:7:\"23:2409\";i:2451;s:7:\"23:2410\";i:2452;s:7:\"23:2411\";i:2453;s:7:\"23:2412\";i:2454;s:7:\"23:2413\";i:2455;s:7:\"23:2414\";i:2456;s:7:\"23:2415\";i:2457;s:7:\"23:2416\";i:2458;s:7:\"23:2417\";i:2459;s:7:\"23:2418\";i:2460;s:7:\"23:2419\";i:2461;s:7:\"23:2420\";i:2462;s:7:\"23:2421\";i:2463;s:7:\"23:2422\";i:2464;s:7:\"23:2423\";i:2465;s:7:\"23:2424\";i:2466;s:7:\"23:2425\";i:2467;s:7:\"23:2426\";i:2468;s:7:\"23:2427\";i:2469;s:7:\"23:2428\";i:2470;s:7:\"23:2429\";i:2471;s:7:\"23:2430\";i:2472;s:7:\"23:2431\";i:2473;s:7:\"23:2432\";i:2474;s:7:\"23:2433\";i:2475;s:7:\"23:2434\";i:2476;s:7:\"23:2435\";i:2477;s:7:\"23:2436\";i:2478;s:7:\"23:2437\";i:2479;s:7:\"23:2438\";i:2480;s:7:\"23:2439\";i:2481;s:7:\"23:2440\";i:2482;s:7:\"23:2441\";i:2483;s:7:\"23:2442\";i:2484;s:7:\"23:2443\";i:2485;s:7:\"23:2444\";i:2486;s:7:\"23:2445\";i:2487;s:7:\"23:2446\";i:2488;s:7:\"23:2447\";i:2489;s:7:\"23:2448\";i:2490;s:7:\"23:2449\";i:2491;s:7:\"23:2450\";i:2492;s:7:\"23:2451\";i:2493;s:7:\"23:2452\";i:2494;s:7:\"23:2453\";i:2495;s:7:\"23:2454\";i:2496;s:7:\"23:2455\";i:2497;s:7:\"23:2456\";i:2498;s:7:\"23:2457\";i:2499;s:7:\"23:2458\";i:2500;s:7:\"23:2459\";i:2501;s:7:\"23:2460\";i:2502;s:7:\"23:2461\";i:2503;s:7:\"23:2462\";i:2504;s:7:\"23:2463\";i:2505;s:7:\"23:2464\";i:2506;s:7:\"23:2465\";i:2507;s:7:\"23:2466\";i:2508;s:7:\"23:2467\";i:2509;s:7:\"23:2468\";i:2510;s:7:\"23:2469\";i:2511;s:7:\"23:2470\";i:2512;s:7:\"23:2471\";i:2513;s:7:\"23:2472\";i:2514;s:7:\"23:2473\";i:2515;s:7:\"23:2474\";i:2516;s:7:\"23:2475\";i:2517;s:7:\"23:2476\";i:2518;s:7:\"23:2477\";i:2519;s:7:\"23:2478\";i:2520;s:7:\"23:2479\";i:2521;s:7:\"23:2480\";i:2522;s:7:\"23:2481\";i:2523;s:7:\"23:2482\";i:2524;s:7:\"23:2483\";i:2525;s:7:\"23:2484\";i:2526;s:7:\"23:2485\";i:2527;s:7:\"23:2486\";i:2528;s:7:\"23:2487\";i:2529;s:7:\"23:2488\";i:2530;s:7:\"23:2489\";i:2531;s:7:\"23:2490\";i:2532;s:7:\"23:2491\";i:2533;s:7:\"23:2492\";i:2534;s:7:\"23:2493\";i:2535;s:7:\"23:2494\";i:2536;s:7:\"23:2495\";i:2537;s:7:\"23:2496\";i:2538;s:7:\"23:2497\";i:2539;s:7:\"23:2498\";i:2540;s:7:\"23:2499\";i:2541;s:7:\"23:2500\";i:2542;s:7:\"23:2501\";i:2543;s:7:\"23:2502\";i:2544;s:7:\"23:2503\";i:2545;s:7:\"23:2504\";i:2546;s:7:\"23:2505\";i:2547;s:7:\"23:2506\";i:2548;s:7:\"23:2507\";i:2549;s:7:\"23:2508\";i:2550;s:7:\"23:2509\";i:2551;s:7:\"23:2510\";i:2552;s:7:\"23:2511\";i:2553;s:7:\"23:2512\";i:2554;s:7:\"23:2513\";i:2555;s:7:\"23:2514\";i:2556;s:7:\"23:2515\";i:2557;s:7:\"23:2516\";i:2558;s:7:\"23:2517\";i:2559;s:7:\"23:2518\";i:2560;s:7:\"23:2519\";i:2561;s:7:\"23:2520\";i:2562;s:7:\"23:2521\";i:2563;s:7:\"23:2522\";i:2564;s:7:\"23:2523\";i:2565;s:7:\"23:2524\";i:2566;s:7:\"23:2525\";i:2567;s:7:\"23:2526\";i:2568;s:7:\"23:2527\";i:2569;s:7:\"23:2528\";i:2570;s:7:\"23:2529\";i:2571;s:7:\"23:2530\";i:2572;s:7:\"23:2531\";i:2573;s:7:\"23:2532\";i:2574;s:7:\"23:2533\";i:2575;s:7:\"23:2534\";i:2576;s:7:\"23:2535\";i:2577;s:7:\"23:2536\";i:2578;s:7:\"23:2537\";i:2579;s:7:\"23:2538\";i:2580;s:7:\"23:2539\";i:2581;s:7:\"23:2540\";i:2582;s:7:\"23:2541\";i:2583;s:7:\"23:2542\";i:2584;s:7:\"23:2543\";i:2585;s:7:\"23:2544\";i:2586;s:7:\"23:2545\";i:2587;s:7:\"23:2546\";i:2588;s:7:\"23:2547\";i:2589;s:7:\"23:2548\";i:2590;s:7:\"23:2549\";i:2591;s:7:\"23:2550\";i:2592;s:7:\"23:2551\";i:2593;s:7:\"23:2552\";i:2594;s:7:\"23:2553\";i:2595;s:7:\"23:2554\";i:2596;s:7:\"23:2555\";i:2597;s:7:\"23:2556\";i:2598;s:7:\"23:2557\";i:2599;s:7:\"23:2558\";i:2600;s:7:\"23:2559\";i:2601;s:7:\"23:2560\";i:2602;s:7:\"23:2561\";i:2603;s:7:\"23:2562\";i:2604;s:7:\"23:2563\";i:2605;s:7:\"23:2564\";i:2606;s:7:\"23:2565\";i:2607;s:7:\"23:2566\";i:2608;s:7:\"23:2567\";i:2609;s:7:\"23:2568\";i:2610;s:7:\"23:2569\";i:2611;s:7:\"23:2570\";i:2612;s:7:\"23:2571\";i:2613;s:7:\"23:2572\";i:2614;s:7:\"23:2573\";i:2615;s:7:\"23:2574\";i:2616;s:7:\"23:2575\";i:2617;s:7:\"23:2576\";i:2618;s:7:\"23:2577\";i:2619;s:7:\"23:2578\";i:2620;s:7:\"23:2579\";i:2621;s:7:\"23:2580\";i:2622;s:7:\"23:2581\";i:2623;s:7:\"23:2582\";i:2624;s:7:\"23:2583\";i:2625;s:7:\"23:2584\";i:2626;s:7:\"23:2585\";i:2627;s:7:\"23:2586\";i:2628;s:7:\"23:2587\";i:2629;s:7:\"23:2588\";i:2630;s:7:\"23:2589\";i:2631;s:7:\"23:2590\";i:2632;s:7:\"23:2591\";i:2633;s:7:\"23:2592\";i:2634;s:7:\"23:2593\";i:2635;s:7:\"23:2594\";i:2636;s:7:\"23:2595\";i:2637;s:7:\"23:2596\";i:2638;s:7:\"23:2597\";i:2639;s:7:\"23:2598\";i:2640;s:7:\"23:2599\";i:2641;s:7:\"23:2600\";i:2642;s:7:\"23:2601\";i:2643;s:7:\"23:2602\";i:2644;s:7:\"23:2603\";i:2645;s:7:\"23:2604\";i:2646;s:7:\"23:2605\";i:2647;s:7:\"23:2606\";i:2648;s:7:\"23:2607\";i:2649;s:7:\"23:2608\";i:2650;s:7:\"23:2609\";i:2651;s:7:\"23:2610\";i:2652;s:7:\"23:2611\";i:2653;s:7:\"23:2612\";i:2654;s:7:\"23:2613\";i:2655;s:7:\"23:2614\";i:2656;s:7:\"23:2615\";i:2657;s:7:\"23:2616\";i:2658;s:7:\"23:2617\";i:2659;s:7:\"23:2618\";i:2660;s:7:\"23:2619\";i:2661;s:7:\"23:2620\";i:2662;s:7:\"23:2621\";i:2663;s:7:\"23:2622\";i:2664;s:7:\"23:2623\";i:2665;s:7:\"23:2624\";i:2666;s:7:\"23:2625\";i:2667;s:7:\"23:2626\";i:2668;s:7:\"23:2627\";i:2669;s:7:\"23:2628\";i:2670;s:7:\"23:2629\";i:2671;s:7:\"23:2630\";i:2672;s:7:\"23:2631\";i:2673;s:7:\"23:2632\";i:2674;s:7:\"23:2633\";i:2675;s:7:\"23:2634\";i:2676;s:7:\"23:2635\";i:2677;s:7:\"23:2636\";i:2678;s:7:\"23:2637\";i:2679;s:7:\"23:2638\";i:2680;s:7:\"23:2639\";i:2681;s:7:\"23:2640\";i:2682;s:7:\"23:2641\";i:2683;s:7:\"23:2642\";i:2684;s:7:\"23:2643\";i:2685;s:7:\"23:2644\";i:2686;s:7:\"23:2645\";i:2687;s:7:\"23:2646\";i:2688;s:7:\"23:2647\";i:2689;s:7:\"23:2648\";i:2690;s:7:\"23:2649\";i:2691;s:7:\"23:2650\";i:2692;s:7:\"23:2651\";i:2693;s:7:\"23:2652\";i:2694;s:7:\"23:2653\";i:2695;s:7:\"23:2654\";i:2696;s:7:\"23:2655\";i:2697;s:7:\"23:2656\";i:2698;s:7:\"23:2657\";i:2699;s:7:\"23:2658\";i:2700;s:7:\"23:2659\";i:2701;s:7:\"23:2660\";i:2702;s:7:\"23:2661\";i:2703;s:7:\"23:2662\";i:2704;s:7:\"23:2663\";i:2705;s:7:\"23:2664\";i:2706;s:7:\"23:2665\";i:2707;s:7:\"23:2666\";i:2708;s:7:\"23:2667\";i:2709;s:7:\"23:2668\";i:2710;s:7:\"23:2669\";i:2711;s:7:\"23:2670\";i:2712;s:7:\"23:2671\";i:2713;s:7:\"23:2672\";i:2714;s:7:\"23:2673\";i:2715;s:7:\"23:2674\";i:2716;s:7:\"23:2675\";i:2717;s:7:\"23:2676\";i:2718;s:7:\"23:2677\";i:2719;s:7:\"23:2678\";i:2720;s:7:\"23:2679\";i:2721;s:7:\"23:2680\";i:2722;s:7:\"23:2681\";i:2723;s:7:\"23:2682\";i:2724;s:7:\"23:2683\";i:2725;s:7:\"23:2684\";i:2726;s:7:\"23:2685\";i:2727;s:7:\"23:2686\";i:2728;s:7:\"23:2687\";i:2729;s:7:\"23:2688\";i:2730;s:7:\"23:2689\";i:2731;s:7:\"23:2690\";i:2732;s:7:\"23:2691\";i:2733;s:7:\"23:2692\";i:2734;s:7:\"23:2693\";i:2735;s:7:\"23:2694\";i:2736;s:7:\"23:2695\";i:2737;s:7:\"23:2696\";i:2738;s:7:\"23:2697\";i:2739;s:7:\"23:2698\";i:2740;s:7:\"23:2699\";i:2741;s:7:\"23:2700\";i:2742;s:7:\"23:2701\";i:2743;s:7:\"23:2702\";i:2744;s:7:\"23:2703\";i:2745;s:7:\"23:2704\";i:2746;s:7:\"23:2705\";i:2747;s:7:\"23:2706\";i:2748;s:7:\"23:2707\";i:2749;s:7:\"23:2708\";i:2750;s:7:\"23:2709\";i:2751;s:7:\"23:2710\";i:2752;s:7:\"23:2711\";i:2753;s:7:\"23:2712\";i:2754;s:7:\"23:2713\";i:2755;s:7:\"23:2714\";i:2756;s:7:\"23:2715\";i:2757;s:7:\"23:2716\";i:2758;s:7:\"23:2717\";i:2759;s:7:\"23:2718\";i:2760;s:7:\"23:2719\";i:2761;s:7:\"23:2720\";i:2762;s:7:\"23:2721\";i:2763;s:7:\"23:2722\";i:2764;s:7:\"23:2723\";i:2765;s:7:\"23:2724\";i:2766;s:7:\"23:2725\";i:2767;s:7:\"23:2726\";i:2768;s:7:\"23:2727\";i:2769;s:7:\"23:2728\";i:2770;s:7:\"23:2729\";i:2771;s:7:\"23:2730\";i:2772;s:7:\"23:2731\";i:2773;s:7:\"23:2732\";i:2774;s:7:\"23:2733\";i:2775;s:7:\"23:2734\";i:2776;s:7:\"23:2735\";i:2777;s:7:\"23:2736\";i:2778;s:7:\"23:2737\";i:2779;s:7:\"23:2738\";i:2780;s:7:\"23:2739\";i:2781;s:7:\"23:2740\";i:2782;s:7:\"23:2741\";i:2783;s:7:\"23:2742\";i:2784;s:7:\"23:2743\";i:2785;s:7:\"23:2744\";i:2786;s:7:\"23:2745\";i:2787;s:7:\"23:2746\";i:2788;s:7:\"23:2747\";i:2789;s:7:\"23:2748\";i:2790;s:7:\"23:2749\";i:2791;s:7:\"23:2750\";i:2792;s:7:\"23:2751\";i:2793;s:7:\"23:2752\";i:2794;s:7:\"23:2753\";i:2795;s:7:\"23:2754\";i:2796;s:7:\"23:2755\";i:2797;s:7:\"23:2756\";i:2798;s:7:\"23:2757\";i:2799;s:7:\"23:2758\";i:2800;s:7:\"23:2759\";i:2801;s:7:\"23:2760\";i:2802;s:7:\"23:2761\";i:2803;s:7:\"23:2762\";i:2804;s:7:\"23:2763\";i:2805;s:7:\"23:2764\";i:2806;s:7:\"23:2765\";i:2807;s:7:\"23:2766\";i:2808;s:7:\"23:2767\";i:2809;s:7:\"23:2768\";i:2810;s:7:\"23:2769\";i:2811;s:7:\"23:2770\";i:2812;s:7:\"23:2771\";i:2813;s:7:\"23:2772\";i:2814;s:7:\"23:2773\";i:2815;s:7:\"23:2774\";i:2816;s:7:\"23:2775\";i:2817;s:7:\"23:2776\";i:2818;s:7:\"23:2777\";i:2819;s:7:\"23:2778\";i:2820;s:7:\"23:2779\";i:2821;s:7:\"23:2780\";i:2822;s:7:\"23:2781\";i:2823;s:7:\"23:2782\";i:2824;s:7:\"23:2783\";i:2825;s:7:\"23:2784\";i:2826;s:7:\"23:2785\";i:2827;s:7:\"23:2786\";i:2828;s:7:\"23:2787\";i:2829;s:7:\"23:2788\";i:2830;s:7:\"23:2789\";i:2831;s:7:\"23:2790\";i:2832;s:7:\"23:2791\";i:2833;s:7:\"23:2792\";i:2834;s:7:\"23:2793\";i:2835;s:7:\"23:2794\";i:2836;s:7:\"23:2795\";i:2837;s:7:\"23:2796\";i:2838;s:7:\"23:2797\";i:2839;s:7:\"23:2798\";i:2840;s:7:\"23:2799\";i:2841;s:7:\"23:2800\";i:2842;s:7:\"23:2801\";i:2843;s:7:\"23:2802\";i:2844;s:7:\"23:2803\";i:2845;s:7:\"23:2804\";i:2846;s:7:\"23:2805\";i:2847;s:7:\"23:2806\";i:2848;s:7:\"23:2807\";i:2849;s:7:\"23:2808\";i:2850;s:7:\"23:2809\";i:2851;s:7:\"23:2810\";i:2852;s:7:\"23:2811\";i:2853;s:7:\"23:2812\";i:2854;s:7:\"23:2813\";i:2855;s:7:\"23:2814\";i:2856;s:7:\"23:2815\";i:2857;s:7:\"23:2816\";i:2858;s:7:\"23:2817\";i:2859;s:7:\"23:2818\";i:2860;s:7:\"23:2819\";i:2861;s:7:\"23:2820\";i:2862;s:7:\"23:2821\";i:2863;s:7:\"23:2822\";i:2864;s:7:\"23:2823\";i:2865;s:7:\"23:2824\";i:2866;s:7:\"23:2825\";i:2867;s:7:\"23:2826\";i:2868;s:7:\"23:2827\";i:2869;s:7:\"23:2828\";i:2870;s:7:\"23:2829\";i:2871;s:7:\"23:2830\";i:2872;s:7:\"23:2831\";i:2873;s:7:\"23:2832\";i:2874;s:7:\"23:2833\";i:2875;s:7:\"23:2834\";i:2876;s:7:\"23:2835\";i:2877;s:7:\"23:2836\";i:2878;s:7:\"23:2837\";i:2879;s:7:\"23:2838\";i:2880;s:7:\"23:2839\";i:2881;s:7:\"23:2840\";i:2882;s:7:\"23:2841\";i:2883;s:7:\"23:2842\";i:2884;s:7:\"23:2843\";i:2885;s:7:\"23:2844\";i:2886;s:7:\"23:2845\";i:2887;s:7:\"23:2846\";i:2888;s:7:\"23:2847\";i:2889;s:7:\"23:2848\";i:2890;s:7:\"23:2849\";i:2891;s:7:\"23:2850\";i:2892;s:7:\"23:2851\";i:2893;s:7:\"23:2852\";i:2894;s:7:\"23:2853\";i:2895;s:7:\"23:2854\";i:2896;s:7:\"23:2855\";i:2897;s:7:\"23:2856\";i:2898;s:7:\"23:2857\";i:2899;s:7:\"23:2858\";i:2900;s:7:\"23:2859\";i:2901;s:7:\"23:2860\";i:2902;s:7:\"23:2861\";i:2903;s:7:\"23:2862\";i:2904;s:7:\"23:2863\";i:2905;s:7:\"23:2864\";i:2906;s:7:\"23:2865\";i:2907;s:7:\"23:2866\";i:2908;s:7:\"23:2867\";i:2909;s:7:\"23:2868\";i:2910;s:7:\"23:2869\";i:2911;s:7:\"23:2870\";i:2912;s:7:\"23:2871\";i:2913;s:7:\"23:2872\";i:2914;s:7:\"23:2873\";i:2915;s:7:\"23:2874\";i:2916;s:7:\"23:2875\";i:2917;s:7:\"23:2876\";i:2918;s:7:\"23:2877\";i:2919;s:7:\"23:2878\";i:2920;s:7:\"23:2879\";i:2921;s:7:\"23:2880\";i:2922;s:7:\"23:2881\";i:2923;s:7:\"23:2882\";i:2924;s:7:\"23:2883\";i:2925;s:7:\"23:2884\";i:2926;s:7:\"23:2885\";i:2927;s:7:\"23:2886\";i:2928;s:7:\"23:2887\";i:2929;s:7:\"23:2888\";i:2930;s:7:\"23:2889\";i:2931;s:7:\"23:2890\";i:2932;s:7:\"23:2891\";i:2933;s:7:\"23:2892\";i:2934;s:7:\"23:2893\";i:2935;s:7:\"23:2894\";i:2936;s:7:\"23:2895\";i:2937;s:7:\"23:2896\";i:2938;s:7:\"23:2897\";i:2939;s:7:\"23:2898\";i:2940;s:7:\"23:2899\";i:2941;s:7:\"23:2900\";i:2942;s:7:\"23:2901\";i:2943;s:7:\"23:2902\";i:2944;s:7:\"23:2903\";i:2945;s:7:\"23:2904\";i:2946;s:7:\"23:2905\";i:2947;s:7:\"23:2906\";i:2948;s:7:\"23:2907\";i:2949;s:7:\"23:2908\";i:2950;s:7:\"23:2909\";i:2951;s:7:\"23:2910\";i:2952;s:7:\"23:2911\";i:2953;s:7:\"23:2912\";i:2954;s:7:\"23:2913\";i:2955;s:7:\"23:2914\";i:2956;s:5:\"23:66\";i:2957;s:7:\"23:2915\";i:2958;s:7:\"23:2916\";i:2959;s:7:\"23:2917\";i:2960;s:7:\"23:2918\";i:2961;s:7:\"23:2919\";i:2962;s:7:\"23:2920\";i:2963;s:7:\"23:2921\";i:2964;s:7:\"23:2922\";i:2965;s:7:\"23:2923\";i:2966;s:7:\"23:2924\";i:2967;s:7:\"23:2925\";i:2968;s:7:\"23:2926\";i:2969;s:7:\"23:2927\";i:2970;s:7:\"23:2928\";i:2971;s:7:\"23:2929\";i:2972;s:7:\"23:2930\";i:2973;s:7:\"23:2931\";i:2974;s:7:\"23:2932\";i:2975;s:7:\"23:2933\";i:2976;s:7:\"23:2934\";i:2977;s:7:\"23:2935\";i:2978;s:7:\"23:2936\";i:2979;s:7:\"23:2937\";i:2980;s:7:\"23:2938\";i:2981;s:7:\"23:2939\";i:2982;s:7:\"23:2940\";i:2983;s:7:\"23:2941\";i:2984;s:7:\"23:2942\";i:2985;s:7:\"23:2943\";i:2986;s:7:\"23:2944\";i:2987;s:7:\"23:2945\";i:2988;s:7:\"23:2946\";i:2989;s:7:\"23:2947\";i:2990;s:7:\"23:2948\";i:2991;s:7:\"23:2949\";i:2992;s:7:\"23:2950\";i:2993;s:7:\"23:2951\";i:2994;s:7:\"23:2952\";i:2995;s:7:\"23:2953\";i:2996;s:7:\"23:2954\";i:2997;s:7:\"23:2955\";i:2998;s:7:\"23:2956\";i:2999;s:7:\"23:2957\";i:3000;s:7:\"23:2958\";i:3001;s:7:\"23:2959\";i:3002;s:7:\"23:2960\";i:3003;s:7:\"23:2961\";i:3004;s:7:\"23:2962\";i:3005;s:7:\"23:2963\";i:3006;s:7:\"23:2964\";i:3007;s:7:\"23:2965\";i:3008;s:7:\"23:2966\";i:3009;s:7:\"23:2967\";i:3010;s:7:\"23:2968\";i:3011;s:7:\"23:2969\";i:3012;s:7:\"23:2970\";i:3013;s:7:\"23:2971\";i:3014;s:7:\"23:2972\";i:3015;s:7:\"23:2973\";i:3016;s:7:\"23:2974\";i:3017;s:7:\"23:2975\";i:3018;s:7:\"23:2976\";i:3019;s:7:\"23:2977\";i:3020;s:7:\"23:2978\";i:3021;s:7:\"23:2979\";i:3022;s:7:\"23:2980\";i:3023;s:7:\"23:2981\";i:3024;s:7:\"23:2982\";i:3025;s:7:\"23:2983\";i:3026;s:7:\"23:2984\";i:3027;s:7:\"23:2985\";i:3028;s:7:\"23:2986\";i:3029;s:7:\"23:2987\";i:3030;s:7:\"23:2988\";i:3031;s:7:\"23:2989\";i:3032;s:7:\"23:2990\";i:3033;s:7:\"23:2991\";i:3034;s:7:\"23:2992\";i:3035;s:7:\"23:2993\";i:3036;s:7:\"23:2994\";i:3037;s:5:\"23:40\";i:3038;s:7:\"23:2995\";i:3039;s:7:\"23:2996\";i:3040;s:7:\"23:2997\";i:3041;s:7:\"23:2998\";i:3042;s:7:\"23:2999\";i:3043;s:7:\"23:3000\";}", "no");
INSERT INTO `wp_options` VALUES("1491", "ms_child_theme_editor_dict_sel", "a:3000:{i:1;s:50:\"#wpex-sfb-l, #wpex-sfb-r, #wpex-sfb-t, #wpex-sfb-b\";i:2;s:15:\".hidden-desktop\";i:3;s:15:\".text-lg-center\";i:4;s:14:\".text-lg-right\";i:5;s:13:\".text-lg-left\";i:6;s:14:\".footer-reveal\";i:7;s:65:\".footer-has-reveal #overlay-header-wrap, .footer-has-reveal #main\";i:8;s:29:\"body.wpex-has-vertical-header\";i:9;s:58:\"body.wpex-has-vertical-header.full-width-main-layout #wrap\";i:10;s:62:\"body.wpex-has-vertical-header.rtl.full-width-main-layout #wrap\";i:11;s:90:\"body.wpex-has-vertical-header.full-width-main-layout.wpex-site-header-disabled #outer-wrap\";i:12;s:42:\"body.wpex-has-vertical-header #site-header\";i:13;s:53:\"body.wpex-has-vertical-header #site-header.header-six\";i:14;s:53:\"body.wpex-has-vertical-header #site-header .container\";i:15;s:46:\"body.wpex-has-vertical-header.rtl #site-header\";i:16;s:69:\"body.wpex-has-vertical-header.wpex-fixed-vertical-header #site-header\";i:17;s:79:\"body.wpex-has-vertical-header.wpex-fixed-vertical-header.admin-bar #site-header\";i:18;s:40:\"body.wpex-has-vertical-header #site-logo\";i:19;s:44:\"body.wpex-has-vertical-header #site-logo img\";i:20;s:52:\"body.wpex-has-vertical-header .header-six #site-logo\";i:21;s:46:\"body.wpex-has-vertical-header #site-logo-inner\";i:22;s:41:\"body.wpex-has-vertical-header .sf-menu ul\";i:23;s:53:\"body.wpex-has-vertical-header.boxed-main-layout #wrap\";i:24;s:79:\"body.wpex-has-vertical-header.boxed-main-layout.wpex-site-header-disabled #wrap\";i:25;s:71:\"body.wpex-has-vertical-header.boxed-main-layout #site-header .container\";i:26;s:57:\"body.wpex-has-vertical-header.rtl.boxed-main-layout #wrap\";i:27;s:42:\"body.wpex-has-vertical-header .page-header\";i:28;s:39:\"#site-header.wpex-full-width .container\";i:29;s:81:\"#site-header.header-one.wpex-full-width, #site-header.header-five.wpex-full-width\";i:30;s:58:\"#site-header.header-two.wpex-full-width #site-header-inner\";i:31;s:29:\"#top-bar-wrap.wpex-full-width\";i:32;s:40:\"#top-bar-wrap.wpex-full-width .container\";i:33;s:36:\"#wpex-searchform-overlay .wpex-inner\";i:34;s:55:\".header-one-search-toggle, .visible-desktop, .post-edit\";i:35;s:24:\".boxed-main-layout #wrap\";i:36;s:57:\"body.has-sidebar .content-area, .wpex-content-w, #sidebar\";i:37;s:55:\"body.has-composer.has-sidebar #primary, .wpex-content-w\";i:38;s:54:\"#site-header.wpex-header-two-flex-v #site-header-inner\";i:39;s:43:\"body.has-mobile-menu .hide-at-mm-breakpoint\";i:40;s:43:\"body.has-mobile-menu .show-at-mm-breakpoint\";i:41;s:17:\".header-two-aside\";i:42;s:18:\"#header-two-search\";i:43;s:49:\"body.mobile-menu-disabled #site-header #site-logo\";i:44;s:38:\"body.mobile-menu-disabled #site-logo a\";i:45;s:40:\"body.mobile-menu-disabled #site-logo img\";i:46;s:60:\"body.mobile-menu-disabled #site-header #site-navigation-wrap\";i:47;s:52:\"body.wpex-mobile-toggle-menu-icon_buttons #site-logo\";i:48;s:56:\"body.wpex-mobile-toggle-menu-icon_buttons.rtl #site-logo\";i:49;s:63:\"body.wpex-mobile-toggle-menu-icon_buttons_under_logo #site-logo\";i:50;s:70:\"body.wpex-mobile-toggle-menu-icon_buttons_under_logo .header-two-aside\";i:51;s:54:\"body.has-mobile-menu.wpex-mobile-toggle-menu-fixed_top\";i:52;s:89:\"body.has-mobile-menu.wpex-mobile-toggle-menu-fixed_top #site-header.header-one #site-logo\";i:53;s:36:\".wpex-social-share.position-vertical\";i:54;s:39:\".wpex-social-share.position-vertical ul\";i:55;s:39:\".wpex-social-share.position-vertical li\";i:56;s:41:\".wpex-social-share.position-vertical li a\";i:57;s:50:\".wpex-social-share.position-vertical.style-rounded\";i:58;s:53:\".wpex-social-share.position-vertical.style-rounded li\";i:59;s:55:\".wpex-social-share.position-vertical.style-rounded li a\";i:60;s:40:\"body.wpex-share-p-vertical.wpex-docready\";i:61;s:57:\"body.wpex-share-p-vertical.wpex-docready #site-scroll-top\";i:62;s:28:\"body.footer-has-reveal #wrap\";i:63;s:167:\"#sidebar, #footer-callout-wrap, #footer, #footer-bottom, #top-bar-wrap, #site-navigation-wrap, .toggle-bar-btn, .post-pagination, .related.products, .product form.cart\";i:64;s:10:\".container\";i:65;s:43:\".wpb_accordion_content, .wpb_toggle_content\";i:66;s:10:\".sp-button\";i:67;s:22:\".visible-desktop-large\";i:68;s:63:\"#site-navigation .dropdown-menu li.flip-drops-smallscreen ul ul\";i:69;s:79:\"#site-navigation .dropdown-menu li.flip-drops-smallscreen ul .ticon-angle-right\";i:70;s:86:\"#site-navigation .dropdown-menu li.flip-drops-smallscreen ul .ticon-angle-right:before\";i:71;s:72:\"body #site-navigation .sf-menu li.flip-drops-smallscreen ul a.sf-with-ul\";i:72;s:47:\"body.has-sidebar .content-area, .wpex-content-w\";i:73;s:8:\"#sidebar\";i:74;s:14:\".visible-phone\";i:75;s:15:\".text-md-center\";i:76;s:14:\".text-md-right\";i:77;s:13:\".text-md-left\";i:78;s:21:\".hidden-desktop-large\";i:79;s:15:\".text-xl-center\";i:80;s:14:\".text-xl-right\";i:81;s:13:\".text-xl-left\";i:82;s:59:\".hidden-desktop, .visible-tablet, .visible-tablet-landscape\";i:83;s:95:\".hidden-desktop.vc_row-flex, .visible-tablet.vc_row-flex, .visible-tablet-landscape.vc_row-flex\";i:84;s:42:\".visible-desktop, .hidden-tablet-landscape\";i:85;s:41:\".visible-tablet, .visible-tablet-portrait\";i:86;s:65:\".visible-tablet.vc_row-flex, .visible-tablet-portrait.vc_row-flex\";i:87;s:75:\".hidden-tablet, .hide-on-tablets, .tparrows.custom, .hidden-tablet-portrait\";i:88;s:27:\"body.boxed-main-layout#wrap\";i:89;s:141:\".tablet-fullwidth-columns .wpb_column, .tablet-fullwidth-columns .vcex-feature-box-content, .tablet-fullwidth-columns .vcex-feature-box-media\";i:90;s:57:\".tablet-fullwidth-columns.vcex-feature-box.v-align-middle\";i:91;s:49:\".tablet-fullwidth-columns .vcex-feature-box-media\";i:92;s:79:\".tablet-fullwidth-columns.vcex-feature-box-match-height .vcex-feature-box-image\";i:93;s:83:\".tablet-fullwidth-columns.vcex-feature-box-match-height .vcex-feature-box-image img\";i:94;s:93:\".tablet-fullwidth-columns.vcex-feature-box.left-content-right-image .vcex-feature-box-content\";i:95;s:93:\".tablet-fullwidth-columns.vcex-feature-box.left-image-right-content .vcex-feature-box-content\";i:96;s:35:\".site-breadcrumbs.position-absolute\";i:97;s:36:\".boxed-main-layout .site-breadcrumbs\";i:98;s:84:\".wpex-row .span_1_of_4.col-3.col, .wpex-row .span_1_of_4.col.product:nth-child(2n+3)\";i:99;s:100:\".wpex-row .span_1_of_4.col, .vcex-isotope-grid .span_1_of_4.col, .wpex-isotope-grid .span_1_of_4.col\";i:100;s:20:\"#footer-widgets .col\";i:101;s:21:\".tablet-single-column\";i:102;s:66:\".visible-desktop, .hidden-phone, .hide-on-phones, .tparrows.custom\";i:103;s:15:\".text-sm-center\";i:104;s:14:\".text-sm-right\";i:105;s:13:\".text-sm-left\";i:106;s:5:\"#wrap\";i:107;s:91:\".col, .blog-entry, .wpex-row .col, .wpex-row.vcex-no-margin-grid .col, #footer-widgets .col\";i:108;s:29:\"#wrap .wpex-row.gap-none .col\";i:109;s:27:\".row-no-spacing .wpb_column\";i:110;s:21:\".vc_span12.wpb_column\";i:111;s:52:\".gallery-format-post-slider-wrap .flex-direction-nav\";i:112;s:46:\".one-half, .one-third, .one-fourth, .one-fifth\";i:113;s:19:\"div.wpcf7 .one-half\";i:114;s:30:\".boxed-main-layout #outer-wrap\";i:115;s:10:\"#site-logo\";i:116;s:45:\"body .entries.left-thumbs .entry .entry-media\";i:117;s:94:\"body .entries.left-thumbs .entry .entry-media, body .entries.left-thumbs .entry .entry-details\";i:118;s:169:\".phone-fullwidth-columns .col, .phone-fullwidth-columns .wpb_column, .phone-fullwidth-columns .vcex-feature-box-content, .phone-fullwidth-columns .vcex-feature-box-media\";i:119;s:48:\".phone-fullwidth-columns .vcex-feature-box-media\";i:120;s:56:\".phone-fullwidth-columns.vcex-feature-box.v-align-middle\";i:121;s:102:\".phone-fullwidth-columns.vcex-feature-box-match-height .vcex-feature-box-media .vcex-feature-box-image\";i:122;s:106:\".phone-fullwidth-columns.vcex-feature-box-match-height .vcex-feature-box-media .vcex-feature-box-image img\";i:123;s:92:\".phone-fullwidth-columns.vcex-feature-box.left-content-right-image .vcex-feature-box-content\";i:124;s:92:\".phone-fullwidth-columns.vcex-feature-box.left-image-right-content .vcex-feature-box-content\";i:125;s:8:\"#top-bar\";i:126;s:15:\"#top-bar-social\";i:127;s:18:\"#top-bar-social li\";i:128;s:29:\".top-bar-left, .top-bar-right\";i:129;s:16:\".top-bar-menu li\";i:130;s:18:\"#top-bar #lang_sel\";i:131;s:27:\"body.rtl #top-bar #lang_sel\";i:132;s:14:\".top-bar-right\";i:133;s:86:\"body.hasnt-overlay-header .page-header.background-image-page-header .page-header-table\";i:134;s:178:\"body.hasnt-overlay-header .page-header.background-image-page-header .page-header-title, .centered-page-header .page-header-title, .centered-minimal-page-header .page-header-title\";i:135;s:179:\".centered-page-header .page-subheading, .centered-minimal-page-header .page-header-subheading, body.hasnt-overlay-header .page-header.background-image-page-header .page-subheading\";i:136;s:39:\"body.has-breadcrumbs .page-header-title\";i:137;s:29:\".portfolio-archives-filter li\";i:138;s:21:\".filterable-portfolio\";i:139;s:22:\"#single-post-next-prev\";i:140;s:36:\".entry-has-avatar .blog-entry-header\";i:141;s:25:\".blog-entry-author-avatar\";i:142;s:13:\".related-post\";i:143;s:35:\".wpex-responsive .author-bio-avatar\";i:144;s:28:\".wpex-responsive .author-bio\";i:145;s:19:\"#comments .children\";i:146;s:164:\".comment-form-author input, .comment-form-author input, .comment-form-email input, .comment-form-website input, .comment-form-comment input, .comment-form-url input\";i:147;s:34:\"#main .widget_nav_menu li a:before\";i:148;s:15:\"#footer-callout\";i:149;s:43:\"#footer-callout-left, #footer-callout-right\";i:150;s:14:\"#footer-bottom\";i:151;s:19:\".footer-bottom-flex\";i:152;s:19:\"#footer-bottom-menu\";i:153;s:25:\"#footer-bottom-menu ul li\";i:154;s:16:\"#site-scroll-top\";i:155;s:4:\".col\";i:156;s:39:\".wpex-flickr-widget .flickr_badge_image\";i:157;s:33:\"#top-bar-content span.wpex-inline\";i:158;s:24:\".mobile-menu-extra-icons\";i:159;s:80:\".mobile-menu-extra-icons.wpex-shop, .mobile-menu-extra-icons.wpex-show-on-mobile\";i:160;s:22:\".woocommerce-cart-form\";i:161;s:16:\".text-xsm-center\";i:162;s:15:\".text-xsm-right\";i:163;s:14:\".text-xsm-left\";i:164;s:29:\".wpex-row .col.span_1_of_1_tl\";i:165;s:72:\".wpex-row .col.span_1_of_1_tl.col-1, .wpex-row .col.span_1_of_1_tl.first\";i:166;s:45:\".wpex-row .col.span_1_of_1_tl:nth-child(1n+1)\";i:167;s:29:\".wpex-row .col.span_1_of_2_tl\";i:168;s:72:\".wpex-row .col.span_1_of_2_tl.col-1, .wpex-row .col.span_1_of_2_tl.first\";i:169;s:45:\".wpex-row .col.span_1_of_2_tl:nth-child(2n+1)\";i:170;s:29:\".wpex-row .col.span_1_of_3_tl\";i:171;s:72:\".wpex-row .col.span_1_of_3_tl.col-1, .wpex-row .col.span_1_of_3_tl.first\";i:172;s:45:\".wpex-row .col.span_1_of_3_tl:nth-child(3n+1)\";i:173;s:29:\".wpex-row .col.span_1_of_4_tl\";i:174;s:72:\".wpex-row .col.span_1_of_4_tl.col-1, .wpex-row .col.span_1_of_4_tl.first\";i:175;s:45:\".wpex-row .col.span_1_of_4_tl:nth-child(4n+1)\";i:176;s:29:\".wpex-row .col.span_1_of_5_tl\";i:177;s:72:\".wpex-row .col.span_1_of_5_tl.col-1, .wpex-row .col.span_1_of_5_tl.first\";i:178;s:45:\".wpex-row .col.span_1_of_5_tl:nth-child(5n+1)\";i:179;s:29:\".wpex-row .col.span_1_of_6_tl\";i:180;s:72:\".wpex-row .col.span_1_of_6_tl.col-1, .wpex-row .col.span_1_of_6_tl.first\";i:181;s:45:\".wpex-row .col.span_1_of_6_tl:nth-child(6n+1)\";i:182;s:29:\".wpex-row .col.span_1_of_7_tl\";i:183;s:72:\".wpex-row .col.span_1_of_7_tl.col-1, .wpex-row .col.span_1_of_7_tl.first\";i:184;s:45:\".wpex-row .col.span_1_of_7_tl:nth-child(7n+1)\";i:185;s:35:\"#wrap .wpex-row .col.span_1_of_1_tp\";i:186;s:51:\"#wrap .wpex-row .col.span_1_of_1_tp:nth-child(1n+1)\";i:187;s:35:\"#wrap .wpex-row .col.span_1_of_2_tp\";i:188;s:51:\"#wrap .wpex-row .col.span_1_of_2_tp:nth-child(2n+1)\";i:189;s:35:\"#wrap .wpex-row .col.span_1_of_3_tp\";i:190;s:51:\"#wrap .wpex-row .col.span_1_of_3_tp:nth-child(3n+1)\";i:191;s:35:\"#wrap .wpex-row .col.span_1_of_4_tp\";i:192;s:51:\"#wrap .wpex-row .col.span_1_of_4_tp:nth-child(4n+1)\";i:193;s:35:\"#wrap .wpex-row .col.span_1_of_5_tp\";i:194;s:51:\"#wrap .wpex-row .col.span_1_of_5_tp:nth-child(5n+1)\";i:195;s:35:\"#wrap .wpex-row .col.span_1_of_6_tp\";i:196;s:51:\"#wrap .wpex-row .col.span_1_of_6_tp:nth-child(6n+1)\";i:197;s:35:\"#wrap .wpex-row .col.span_1_of_7_tp\";i:198;s:51:\"#wrap .wpex-row .col.span_1_of_7_tp:nth-child(7n+1)\";i:199;s:47:\"#outer-wrap #wrap .wpex-row .col.span_1_of_1_pl\";i:200;s:63:\"#outer-wrap #wrap .wpex-row .col.span_1_of_1_pl:nth-child(1n+1)\";i:201;s:47:\"#outer-wrap #wrap .wpex-row .col.span_1_of_2_pl\";i:202;s:63:\"#outer-wrap #wrap .wpex-row .col.span_1_of_2_pl:nth-child(2n+1)\";i:203;s:47:\"#outer-wrap #wrap .wpex-row .col.span_1_of_3_pl\";i:204;s:63:\"#outer-wrap #wrap .wpex-row .col.span_1_of_3_pl:nth-child(3n+1)\";i:205;s:47:\"#outer-wrap #wrap .wpex-row .col.span_1_of_4_pl\";i:206;s:63:\"#outer-wrap #wrap .wpex-row .col.span_1_of_4_pl:nth-child(4n+1)\";i:207;s:47:\"#outer-wrap #wrap .wpex-row .col.span_1_of_5_pl\";i:208;s:63:\"#outer-wrap #wrap .wpex-row .col.span_1_of_5_pl:nth-child(5n+1)\";i:209;s:47:\"#outer-wrap #wrap .wpex-row .col.span_1_of_6_pl\";i:210;s:63:\"#outer-wrap #wrap .wpex-row .col.span_1_of_6_pl:nth-child(6n+1)\";i:211;s:47:\"#outer-wrap #wrap .wpex-row .col.span_1_of_7_pl\";i:212;s:63:\"#outer-wrap #wrap .wpex-row .col.span_1_of_7_pl:nth-child(7n+1)\";i:213;s:47:\"#outer-wrap #wrap .wpex-row .col.span_1_of_1_pp\";i:214;s:63:\"#outer-wrap #wrap .wpex-row .col.span_1_of_1_pp:nth-child(1n+1)\";i:215;s:47:\"#outer-wrap #wrap .wpex-row .col.span_1_of_2_pp\";i:216;s:63:\"#outer-wrap #wrap .wpex-row .col.span_1_of_2_pp:nth-child(2n+1)\";i:217;s:47:\"#outer-wrap #wrap .wpex-row .col.span_1_of_3_pp\";i:218;s:63:\"#outer-wrap #wrap .wpex-row .col.span_1_of_3_pp:nth-child(3n+1)\";i:219;s:47:\"#outer-wrap #wrap .wpex-row .col.span_1_of_4_pp\";i:220;s:63:\"#outer-wrap #wrap .wpex-row .col.span_1_of_4_pp:nth-child(4n+1)\";i:221;s:47:\"#outer-wrap #wrap .wpex-row .col.span_1_of_5_pp\";i:222;s:63:\"#outer-wrap #wrap .wpex-row .col.span_1_of_5_pp:nth-child(5n+1)\";i:223;s:47:\"#outer-wrap #wrap .wpex-row .col.span_1_of_6_pp\";i:224;s:63:\"#outer-wrap #wrap .wpex-row .col.span_1_of_6_pp:nth-child(6n+1)\";i:225;s:47:\"#outer-wrap #wrap .wpex-row .col.span_1_of_7_pp\";i:226;s:63:\"#outer-wrap #wrap .wpex-row .col.span_1_of_7_pp:nth-child(7n+1)\";i:227;s:487:\"html, body, div, span, applet, object, iframe, h1, h2, h3, h4, h5, h6, p, blockquote, pre, abbr, acronym, address, big, cite, code, del, dfn, em, img, ins, kbd, q, s, samp, small, strike, strong, sub, sup, tt, var, b, u, i, center, dl, dt, dd, ol, ul, li, fieldset, form, label, legend, table, caption, tbody, tfoot, thead, tr, th, td, article, aside, canvas, details, embed, figure, figcaption, footer, header, hgroup, menu, nav, output, ruby, section, summary, time, mark, audio, video\";i:228;s:87:\"article, aside, details, figcaption, figure, footer, header, hgroup, menu, nav, section\";i:229;s:4:\"html\";i:230;s:4:\"body\";i:231;s:79:\"article, aside, details, figcaption, figure, footer, header, main, nav, section\";i:232;s:6:\"ol, ul\";i:233;s:5:\"table\";i:234;s:15:\"caption, th, td\";i:235;s:54:\"blockquote:before, blockquote:after, q:before, q:after\";i:236;s:13:\"blockquote, q\";i:237;s:17:\"a:hover, a:active\";i:238;s:5:\"a img\";i:239;s:3:\"img\";i:240;s:6:\"select\";i:241;s:19:\".screen-reader-text\";i:242;s:25:\".screen-reader-text:focus\";i:243;s:16:\".skip-to-content\";i:244;s:22:\".skip-to-content:focus\";i:245;s:23:\".wpex-cf-styles a:focus\";i:246;s:18:\"body.wpex-noscroll\";i:247;s:35:\".container, .vc_row-fluid.container\";i:248;s:77:\"body.wpex-responsive .container, body.wpex-responsive .vc_row-fluid.container\";i:249;s:17:\".center-row-inner\";i:250;s:59:\".content-full-width .content-area, .content-area.full-width\";i:251;s:11:\"#outer-wrap\";i:252;s:60:\"body.content-full-screen #content-wrap, .content-full-screen\";i:253;s:126:\"body.content-full-width #content-wrap .content-area, .content-full-width .content-area, body.content-full-screen #content-wrap\";i:254;s:88:\"body.content-full-screen #content-wrap .content-area, .content-full-screen .content-area\";i:255;s:90:\"body.content-left-sidebar #content-wrap .content-area, .content-left-sidebar .content-area\";i:256;s:80:\"body.content-left-sidebar #content-wrap #sidebar, .content-left-sidebar #sidebar\";i:257;s:212:\".content-right-sidebar .vc_row-fluid.container, .content-left-sidebar .vc_row-fluid.container, .content-right-sidebar .vcex-testimonials-fullslider-entry, .content-left-sidebar .vcex-testimonials-fullslider-entry\";i:258;s:170:\"#primary, body.has-composer.page-template-blog #primary, body.has-composer.page-template-blog-content-above #primary, body.has-composer.post-type-archive-product #primary\";i:259;s:141:\"body.has-composer #primary, body.elementor-page #primary, body.compose-mode #primary, body.single-product #primary, body.single-post #primary\";i:260;s:18:\".boxed-main-layout\";i:261;s:35:\".boxed-main-layout #wrap .container\";i:262;s:40:\".boxed-main-layout.wpex-responsive #wrap\";i:263;s:39:\".boxed-main-layout.wrap-boxshadow #wrap\";i:264;s:52:\".boxed-main-layout.content-full-screen #content-wrap\";i:265;s:36:\".boxed-main-layout .navbar-style-one\";i:266;s:143:\".boxed-main-layout.has-mobile-menu #mobile-menu, .boxed-main-layout #footer-bottom-menu, .boxed-main-layout .site-breadcrumbs.position-absolute\";i:267;s:21:\"body.has-frame-border\";i:268;s:68:\"body.has-frame-border #wpex-sfb-l, body.has-frame-border #wpex-sfb-r\";i:269;s:68:\"body.has-frame-border #wpex-sfb-t, body.has-frame-border #wpex-sfb-b\";i:270;s:24:\"#wpex-sfb-l, #wpex-sfb-r\";i:271;s:11:\"#wpex-sfb-l\";i:272;s:11:\"#wpex-sfb-r\";i:273;s:24:\"#wpex-sfb-t, #wpex-sfb-b\";i:274;s:11:\"#wpex-sfb-t\";i:275;s:11:\"#wpex-sfb-b\";i:276;s:216:\".col:after, .clr:after, .wpex-clr:after, .group:after, dl:after, .vc-empty-shortcode-element:after, ul.page-numbers:after, #comments .comment-body:after, .vcex-clr:after, .wpex-slider .sp-nc-thumbnail-container:after\";i:277;s:19:\".clear, .wpex-clear\";i:278;s:9:\".wpex-row\";i:279;s:14:\".wpex-row .col\";i:280;s:26:\".wpex-row .span_1_of_1.col\";i:281;s:22:\".wpex-row .span_1_of_2\";i:282;s:22:\".wpex-row .span_1_of_3\";i:283;s:22:\".wpex-row .span_1_of_4\";i:284;s:22:\".wpex-row .span_1_of_5\";i:285;s:22:\".wpex-row .span_1_of_6\";i:286;s:22:\".wpex-row .span_1_of_7\";i:287;s:18:\".wpex-row.gap-none\";i:288;s:51:\".wpex-row.gap-none .col, .wpex-row.gap-none .nr-col\";i:289;s:15:\".wpex-row.gap-1\";i:290;s:45:\".wpex-row.gap-1>.col, .wpex-row.gap-1>.nr-col\";i:291;s:15:\".wpex-row.gap-5\";i:292;s:45:\".wpex-row.gap-5>.col, .wpex-row.gap-5>.nr-col\";i:293;s:16:\".wpex-row.gap-10\";i:294;s:47:\".wpex-row.gap-10>.col, .wpex-row.gap-10>.nr-col\";i:295;s:16:\".wpex-row.gap-15\";i:296;s:47:\".wpex-row.gap-15>.col, .wpex-row.gap-15>.nr-col\";i:297;s:16:\".wpex-row.gap-20\";i:298;s:47:\".wpex-row.gap-20>.col, .wpex-row.gap-20>.nr-col\";i:299;s:16:\".wpex-row.gap-25\";i:300;s:47:\".wpex-row.gap-25>.col, .wpex-row.gap-25>.nr-col\";i:301;s:16:\".wpex-row.gap-30\";i:302;s:47:\".wpex-row.gap-30>.col, .wpex-row.gap-30>.nr-col\";i:303;s:16:\".wpex-row.gap-35\";i:304;s:47:\".wpex-row.gap-35>.col, .wpex-row.gap-35>.nr-col\";i:305;s:16:\".wpex-row.gap-40\";i:306;s:47:\".wpex-row.gap-40>.col, .wpex-row.gap-40>.nr-col\";i:307;s:16:\".wpex-row.gap-50\";i:308;s:47:\".wpex-row.gap-50>.col, .wpex-row.gap-50>.nr-col\";i:309;s:16:\".wpex-row.gap-60\";i:310;s:47:\".wpex-row.gap-60>.col, .wpex-row.gap-60>.nr-col\";i:311;s:7:\".nr-col\";i:312;s:19:\".span_1_of_2.nr-col\";i:313;s:19:\".span_1_of_3.nr-col\";i:314;s:19:\".span_1_of_4.nr-col\";i:315;s:19:\".span_1_of_5.nr-col\";i:316;s:19:\".span_1_of_6.nr-col\";i:317;s:9:\".one-half\";i:318;s:10:\".one-third\";i:319;s:11:\".one-fourth\";i:320;s:10:\".one-fifth\";i:321;s:10:\".one-sixth\";i:322;s:29:\".wpex-row.vcex-no-margin-grid\";i:323;s:73:\".wpex-row.vcex-no-margin-grid .col, .wpex-row.vcex-no-margin-grid .nr-col\";i:324;s:42:\".wpex-row.vcex-no-margin-grid .span_1_of_3\";i:325;s:42:\".wpex-row.vcex-no-margin-grid .span_1_of_6\";i:326;s:51:\".clr-margin, .count-1, .col-1, .products .col.first\";i:327;s:14:\".isotope-entry\";i:328;s:17:\"body.smooth-fonts\";i:329;s:2:\"em\";i:330;s:6:\"strong\";i:331;s:18:\"strong.wpex-strong\";i:332;s:5:\"small\";i:333;s:6:\"p.lead\";i:334;s:7:\"address\";i:335;s:8:\"sup, sub\";i:336;s:3:\"sub\";i:337;s:17:\"body .wpex-italic\";i:338;s:18:\"body .wpex-td-none\";i:339;s:13:\".wpex-em-14px\";i:340;s:13:\".wpex-em-16px\";i:341;s:13:\".wpex-em-18px\";i:342;s:13:\".wpex-em-21px\";i:343;s:13:\".wpex-fs-13px\";i:344;s:13:\".wpex-fs-14px\";i:345;s:13:\".wpex-fs-16px\";i:346;s:13:\".wpex-fs-18px\";i:347;s:13:\".wpex-fs-21px\";i:348;s:7:\"a:hover\";i:349;s:22:\"h1, h2, h3, h4, h5, h6\";i:350;s:34:\"h1 a, h2 a, h3 a, h4 a, h5 a, h6 a\";i:351;s:70:\"h1 a:hover, h2 a:hover, h3 a:hover, h4 a:hover, h5 a:hover, h6 a:hover\";i:352;s:2:\"h1\";i:353;s:2:\"h2\";i:354;s:2:\"h3\";i:355;s:2:\"h4\";i:356;s:2:\"h5\";i:357;s:2:\"h6\";i:358;s:19:\".heading-typography\";i:359;s:12:\".columnize-2\";i:360;s:10:\".thin-font\";i:361;s:11:\".white-text\";i:362;s:10:\"blockquote\";i:363;s:23:\"blockquote p:last-child\";i:364;s:15:\"blockquote.left\";i:365;s:16:\"blockquote.right\";i:366;s:30:\"blockquote.wp-embedded-content\";i:367;s:197:\".typography-light, .typography-light a, .typography-light a:hover, .typography-light h1, .typography-light h2, .typography-light h3, .typography-light h4, .typography-light h5, .typography-light h6\";i:368;s:21:\".typography-light p>a\";i:369;s:459:\".typography-white, .typography-white a, .typography-white a:hover, .typography-white h1, .typography-white h2, .typography-white h3, .typography-white h4, .typography-white h5, .typography-white h6, .typography-white-shadow, .typography-white-shadow a, .typography-white-shadow a:hover, .typography-white-shadow h1, .typography-white-shadow h2, .typography-white-shadow h3, .typography-white-shadow h4, .typography-white-shadow h5, .typography-white-shadow h6\";i:370;s:51:\".typography-white p>a, .typography-white-shadow p>a\";i:371;s:197:\".typography-black, .typography-black a, .typography-black a:hover, .typography-black h1, .typography-black h2, .typography-black h3, .typography-black h4, .typography-black h5, .typography-black h6\";i:372;s:21:\".typography-black p>a\";i:373;s:24:\".typography-white-shadow\";i:374;s:12:\".wpex-fw-100\";i:375;s:12:\".wpex-fw-200\";i:376;s:28:\".wpex-fw-300, .wpex-fw-light\";i:377;s:29:\".wpex-fw-400, .wpex-fw-normal\";i:378;s:12:\".wpex-fw-500\";i:379;s:31:\".wpex-fw-600, .wpex-fw-semibold\";i:380;s:27:\".wpex-fw-700, .wpex-fw-bold\";i:381;s:12:\".wpex-fw-800\";i:382;s:29:\".wpex-fw-900, .wpex-fw-bolder\";i:383;s:27:\".wpex-child-inherit-color *\";i:384;s:65:\".wpex-color-black, .wpex-color-black a, .wpex-color-black a:hover\";i:385;s:65:\".wpex-color-white, .wpex-color-white a, .wpex-color-white a:hover\";i:386;s:6:\"ul, ol\";i:387;s:2:\"ul\";i:388;s:2:\"ol\";i:389;s:14:\".rev_slider ul\";i:390;s:13:\"ul.check-list\";i:391;s:16:\"ul.check-list li\";i:392;s:23:\"ul.check-list li:before\";i:393;s:2:\"hr\";i:394;s:3:\"pre\";i:395;s:8:\".dropcap\";i:396;s:14:\".dropcap.boxed\";i:397;s:15:\".text-highlight\";i:398;s:31:\"button, input, select, textarea\";i:399;s:266:\"input[type=\"date\"], input[type=\"time\"], input[type=\"datetime-local\"], input[type=\"week\"], input[type=\"month\"], input[type=\"text\"], input[type=\"email\"], input[type=\"url\"], input[type=\"password\"], input[type=\"search\"], input[type=\"tel\"], input[type=\"number\"], textarea\";i:400;s:344:\"input[type=\"date\"]:focus, input[type=\"time\"]:focus, input[type=\"datetime-local\"]:focus, input[type=\"week\"]:focus, input[type=\"month\"]:focus, input[type=\"text\"]:focus, input[type=\"email\"]:focus, input[type=\"url\"]:focus, input[type=\"password\"]:focus, input[type=\"search\"]:focus, input[type=\"tel\"]:focus, input[type=\"number\"]:focus, textarea:focus\";i:401;s:166:\"body .select2-container--default .select2-selection--single, body .select2-container--default .select2-search--dropdown .select2-search__field, body .select2-dropdown\";i:402;s:88:\"body .select2-container--default .select2-selection--single .select2-selection__rendered\";i:403;s:137:\"body .select2-container .select2-selection--single, body .select2-container--default .select2-selection--single .select2-selection__arrow\";i:404;s:209:\"input[type=\"search\"]::-webkit-search-decoration, input[type=\"search\"]::-webkit-search-cancel-button, input[type=\"search\"]::-webkit-search-results-button, input[type=\"search\"]::-webkit-search-results-decoration\";i:405;s:8:\"textarea\";i:406;s:43:\"input[type=\"checkbox\"], input[type=\"radio\"]\";i:407;s:22:\"input:-webkit-autofill\";i:408;s:47:\".password-protection-box input:-webkit-autofill\";i:409;s:27:\"::-webkit-input-placeholder\";i:410;s:17:\":-moz-placeholder\";i:411;s:18:\"::-moz-placeholder\";i:412;s:22:\":-ms-input-placeholder\";i:413;s:24:\".password-protection-box\";i:414;s:27:\".password-protection-box h2\";i:415;s:37:\".password-protection-box p:last-child\";i:416;s:30:\".password-protection-box input\";i:417;s:47:\".password-protection-box input[type=\"password\"]\";i:418;s:45:\".password-protection-box input[type=\"submit\"]\";i:419;s:29:\".wpex-multiselect-wrap select\";i:420;s:17:\".wpex-select-wrap\";i:421;s:24:\".wpex-select-wrap select\";i:422;s:38:\".vcex-form-shortcode .wpex-select-wrap\";i:423;s:45:\".vcex-form-shortcode .wpex-select-wrap select\";i:424;s:36:\".wpex-select-wrap select::-ms-expand\";i:425;s:24:\".wpex-select-wrap .ticon\";i:426;s:33:\"#footer-widgets .wpex-select-wrap\";i:427;s:13:\".wpcf7-form p\";i:428;s:70:\".wpcf7-form input, .wpcf7-form textarea, .wpcf7-form .wpex-select-wrap\";i:429;s:23:\".wpcf7 .wpcf7-not-valid\";i:430;s:26:\".wpcf7 .wpcf7-mail-sent-ok\";i:431;s:22:\".wpcf7 img.ajax-loader\";i:432;s:31:\".wpcf7 .ticon.wpex-wpcf7-loader\";i:433;s:39:\".wpcf7 .ticon.wpex-wpcf7-loader.visible\";i:434;s:418:\".wpcf7 .one-half input[type=\"text\"], .wpcf7 .one-half input[type=\"email\"], .wpcf7 .one-half input[type=\"tel\"], .wpcf7 .one-half input[type=\"password\"], .wpcf7 .one-half input[type=\"url\"], .wpcf7 .one-half input[type=\"name\"], .wpcf7 .col input[type=\"text\"], .wpcf7 .col input[type=\"email\"], .wpcf7 .col input[type=\"tel\"], .wpcf7 .col input[type=\"password\"], .wpcf7 .col input[type=\"url\"], .wpcf7 .col input[type=\"name\"]\";i:435;s:16:\".wpcf7 .one-half\";i:436;s:22:\".wpcf7 .one-half.first\";i:437;s:24:\".wpcf7 .full-width input\";i:438;s:30:\".wpcf7 .screen-reader-response\";i:439;s:27:\".wpcf7 span.wpcf7-list-item\";i:440;s:20:\".wpcf7-not-valid-tip\";i:441;s:30:\"body div.wpcf7-response-output\";i:442;s:24:\".wpcf7-validation-errors\";i:443;s:46:\".wpcf7-validation-errors.wpcf7-response-output\";i:444;s:19:\".wpcf7-mail-sent-ng\";i:445;s:84:\".full-width-input .wpcf7 img.ajax-loader, .full-width-input .ticon.wpex-wpcf7-loader\";i:446;s:24:\".wpcf7-form-control-wrap\";i:447;s:17:\".wpcf7-quiz-label\";i:448;s:25:\".wpcf7 .wpex-wpcf7-loader\";i:449;s:27:\"body div.wpcf7 .ajax-loader\";i:450;s:37:\"body div.wpcf7 .ajax-loader.is-active\";i:451;s:23:\"body .light-form select\";i:452;s:571:\"body .light-form input[type=\"date\"], body .light-form input[type=\"time\"], body .light-form input[type=\"datetime-local\"], body .light-form input[type=\"week\"], body .light-form input[type=\"month\"], body .light-form input[type=\"text\"], body .light-form input[type=\"email\"], body .light-form input[type=\"url\"], body .light-form input[type=\"password\"], body .light-form input[type=\"search\"], body .light-form input[type=\"tel\"], body .light-form input[type=\"number\"], body .light-form textarea, body .light-form .wpex-select-wrap, body .light-form .wpex-multiselect-wrap select\";i:453;s:77:\"body .light-form, body .light-form label, body .light-form .wpex-wpcf7-loader\";i:454;s:41:\"body .light-form .wpex-select-wrap .ticon\";i:455;s:86:\"body .light-form .wpcf7-validation-errors, body .light-form .wpcf7 .wpcf7-mail-sent-ok\";i:456;s:39:\"body .light-form input:-webkit-autofill\";i:457;s:33:\"body .light-form .wpcf7-not-valid\";i:458;s:19:\"body .wpex-form-min\";i:459;s:25:\"body .wpex-form-min label\";i:460;s:616:\"body .wpex-form-min input[type=\"date\"], body .wpex-form-min input[type=\"time\"], body .wpex-form-min input[type=\"datetime-local\"], body .wpex-form-min input[type=\"week\"], body .wpex-form-min input[type=\"month\"], body .wpex-form-min input[type=\"text\"], body .wpex-form-min input[type=\"email\"], body .wpex-form-min input[type=\"url\"], body .wpex-form-min input[type=\"password\"], body .wpex-form-min input[type=\"search\"], body .wpex-form-min input[type=\"tel\"], body .wpex-form-min input[type=\"number\"], body .wpex-form-min textarea, body .wpex-form-min .wpex-select-wrap, body .wpex-form-min .wpex-multiselect-wrap select\";i:461;s:38:\"body .wpex-form-min .wpex-wpcf7-loader\";i:462;s:92:\"body .wpex-form-min .wpcf7-validation-errors, body .wpex-form-min .wpcf7 .wpcf7-mail-sent-ok\";i:463;s:42:\"body .wpex-form-min input:-webkit-autofill\";i:464;s:36:\"body .wpex-form-min .wpcf7-not-valid\";i:465;s:22:\"body .wpex-form-modern\";i:466;s:28:\"body .wpex-form-modern label\";i:467;s:661:\"body .wpex-form-modern input[type=\"date\"], body .wpex-form-modern input[type=\"time\"], body .wpex-form-modern input[type=\"datetime-local\"], body .wpex-form-modern input[type=\"week\"], body .wpex-form-modern input[type=\"month\"], body .wpex-form-modern input[type=\"text\"], body .wpex-form-modern input[type=\"email\"], body .wpex-form-modern input[type=\"url\"], body .wpex-form-modern input[type=\"password\"], body .wpex-form-modern input[type=\"search\"], body .wpex-form-modern input[type=\"tel\"], body .wpex-form-modern input[type=\"number\"], body .wpex-form-modern textarea, body .wpex-form-modern .wpex-select-wrap, body .wpex-form-modern .wpex-multiselect-wrap select\";i:468;s:751:\"body .wpex-form-modern input[type=\"date\"]:focus, body .wpex-form-modern input[type=\"time\"]:focus, body .wpex-form-modern input[type=\"datetime-local\"]:focus, body .wpex-form-modern input[type=\"week\"]:focus, body .wpex-form-modern input[type=\"month\"]:focus, body .wpex-form-modern input[type=\"text\"]:focus, body .wpex-form-modern input[type=\"email\"]:focus, body .wpex-form-modern input[type=\"url\"]:focus, body .wpex-form-modern input[type=\"password\"]:focus, body .wpex-form-modern input[type=\"search\"]:focus, body .wpex-form-modern input[type=\"tel\"]:focus, body .wpex-form-modern input[type=\"number\"]:focus, body .wpex-form-modern textarea:focus, body .wpex-form-modern .wpex-select-wrap:focus, body .wpex-form-modern .wpex-multiselect-wrap select:focus\";i:469;s:41:\"body .wpex-form-modern .wpex-wpcf7-loader\";i:470;s:39:\"body .wpex-form-modern .wpcf7-not-valid\";i:471;s:23:\"body .wpex-form-white-o\";i:472;s:73:\"body .wpex-form-white-o label, body .wpex-form-white-o .wpex-wpcf7-loader\";i:473;s:30:\"body .wpex-form-white-o select\";i:474;s:676:\"body .wpex-form-white-o input[type=\"date\"], body .wpex-form-white-o input[type=\"time\"], body .wpex-form-white-o input[type=\"datetime-local\"], body .wpex-form-white-o input[type=\"week\"], body .wpex-form-white-o input[type=\"month\"], body .wpex-form-white-o input[type=\"text\"], body .wpex-form-white-o input[type=\"email\"], body .wpex-form-white-o input[type=\"url\"], body .wpex-form-white-o input[type=\"password\"], body .wpex-form-white-o input[type=\"search\"], body .wpex-form-white-o input[type=\"tel\"], body .wpex-form-white-o input[type=\"number\"], body .wpex-form-white-o textarea, body .wpex-form-white-o .wpex-select-wrap, body .wpex-form-white-o .wpex-multiselect-wrap select\";i:475;s:48:\"body .wpex-form-white-o .wpex-select-wrap select\";i:476;s:59:\"body .wpex-form-white-o .wpex-select-wrap .ticon-angle-down\";i:477;s:67:\"body .wpex-form-white-o .wpex-select-wrap .ticon-angle-down::before\";i:478;s:46:\"body .wpex-form-white-o input:-webkit-autofill\";i:479;s:100:\"body .wpex-form-white-o .wpcf7-validation-errors, body .wpex-form-white-o .wpcf7 .wpcf7-mail-sent-ok\";i:480;s:40:\"body .wpex-form-white-o .wpcf7-not-valid\";i:481;s:21:\"body .wpex-form-black\";i:482;s:27:\"body .wpex-form-black label\";i:483;s:646:\"body .wpex-form-black input[type=\"date\"], body .wpex-form-black input[type=\"time\"], body .wpex-form-black input[type=\"datetime-local\"], body .wpex-form-black input[type=\"week\"], body .wpex-form-black input[type=\"month\"], body .wpex-form-black input[type=\"text\"], body .wpex-form-black input[type=\"email\"], body .wpex-form-black input[type=\"url\"], body .wpex-form-black input[type=\"password\"], body .wpex-form-black input[type=\"search\"], body .wpex-form-black input[type=\"tel\"], body .wpex-form-black input[type=\"number\"], body .wpex-form-black textarea, body .wpex-form-black .wpex-select-wrap, body .wpex-form-black .wpex-multiselect-wrap select\";i:484;s:44:\"body .wpex-form-black input:-webkit-autofill\";i:485;s:46:\"body .wpex-form-black .wpex-select-wrap .ticon\";i:486;s:96:\"body .wpex-form-black .wpcf7-validation-errors, body .wpex-form-black .wpcf7 .wpcf7-mail-sent-ok\";i:487;s:38:\"body .wpex-form-black .wpcf7-not-valid\";i:488;s:23:\"body .wpex-form-black-o\";i:489;s:73:\"body .wpex-form-black-o label, body .wpex-form-black-o .wpex-wpcf7-loader\";i:490;s:676:\"body .wpex-form-black-o input[type=\"date\"], body .wpex-form-black-o input[type=\"time\"], body .wpex-form-black-o input[type=\"datetime-local\"], body .wpex-form-black-o input[type=\"week\"], body .wpex-form-black-o input[type=\"month\"], body .wpex-form-black-o input[type=\"text\"], body .wpex-form-black-o input[type=\"email\"], body .wpex-form-black-o input[type=\"url\"], body .wpex-form-black-o input[type=\"password\"], body .wpex-form-black-o input[type=\"search\"], body .wpex-form-black-o input[type=\"tel\"], body .wpex-form-black-o input[type=\"number\"], body .wpex-form-black-o textarea, body .wpex-form-black-o .wpex-select-wrap, body .wpex-form-black-o .wpex-multiselect-wrap select\";i:491;s:46:\"body .wpex-form-black-o input:-webkit-autofill\";i:492;s:59:\"body .wpex-form-black-o .wpex-select-wrap .ticon-angle-down\";i:493;s:67:\"body .wpex-form-black-o .wpex-select-wrap .ticon-angle-down::before\";i:494;s:100:\"body .wpex-form-black-o .wpcf7-validation-errors, body .wpex-form-black-o .wpcf7 .wpcf7-mail-sent-ok\";i:495;s:40:\"body .wpex-form-black-o .wpcf7-not-valid\";i:496;s:566:\".full-width-input input[type=\"date\"], .full-width-input input[type=\"time\"], .full-width-input input[type=\"datetime-local\"], .full-width-input input[type=\"week\"], .full-width-input input[type=\"month\"], .full-width-input input[type=\"text\"], .full-width-input input[type=\"email\"], .full-width-input input[type=\"url\"], .full-width-input input[type=\"password\"], .full-width-input input[type=\"search\"], .full-width-input input[type=\"tel\"], .full-width-input input[type=\"number\"], .full-width-input input[type=\"submit\"], .full-width-input textarea, .full-width-input select\";i:497;s:38:\".full-width-input input[type=\"submit\"]\";i:498;s:35:\".full-width-input .wpex-select-wrap\";i:499;s:42:\".full-width-input .wpex-select-wrap select\";i:500;s:26:\"#wpex-loginform-wrap label\";i:501;s:84:\"#wpex-loginform-wrap input[type=\"text\"], #wpex-loginform-wrap input[type=\"password\"]\";i:502;s:96:\"#wpex-loginform-wrap input[type=\"text\"]:focus, #wpex-loginform-wrap input[type=\"password\"]:focus\";i:503;s:33:\"#wpex-loginform-wrap p:last-child\";i:504;s:28:\"#wpex-loginform-wrap a:hover\";i:505;s:83:\".theme-button, .color-button, input[type=\"submit\"], button, .button, .added_to_cart\";i:506;s:16:\"p.theme-button a\";i:507;s:31:\".theme-button p, .vcex-button p\";i:508;s:119:\".theme-button:hover, .color-button:hover, input[type=\"submit\"]:hover, button:hover, .button:hover, .added_to_cart:hover\";i:509;s:102:\".theme-button:active, .color-button:active, input[type=\"submit\"]:active, button:active, .button:active\";i:510;s:28:\".wp-editor-wrap button:hover\";i:511;s:117:\".theme-button.animate-on-hover, .theme-button.hvr-float-shadow, .theme-button.hvr-float-grow, .theme-button.hvr-float\";i:512;s:23:\".theme-button.graphical\";i:513;s:30:\".theme-button.graphical:active\";i:514;s:21:\".theme-button.three-d\";i:515;s:28:\".theme-button.three-d:active\";i:516;s:24:\".theme-button.full-width\";i:517;s:128:\".theme-button.blue, .color-button.blue, .active>.theme-button.outline, .theme-button.outline.active, .theme-button.outline:hover\";i:518;s:123:\".theme-button.blue:hover, .active>.theme-button, .theme-button.active .active>.theme-button.blue, .theme-button.blue.active\";i:519;s:38:\".theme-button.grey, .color-button.grey\";i:520;s:79:\".theme-button.grey:hover, .active>.theme-button.grey, .theme-button.active.grey\";i:521;s:278:\".active>.theme-button.outline.black, .active>.theme-button.minimal-border.black, .theme-button.outline.black:hover, .theme-button.minimal-border.black:hover, .theme-button.outline.black.active, .theme-button.minimal-border.blackk.active, .theme-button.black, .color-button.black\";i:522;s:82:\".theme-button.black:hover, .active>.theme-button.black, .theme-button.active.black\";i:523;s:42:\".theme-button.orange, .color-button.orange\";i:524;s:85:\".theme-button.orange:hover, .active>.theme-button.orange, .theme-button.active.orange\";i:525;s:38:\".theme-button.gold, .color-button.gold\";i:526;s:79:\".theme-button.gold:hover, .active>.theme-button.gold, .theme-button.active.gold\";i:527;s:40:\".theme-button.green, .color-button.green\";i:528;s:82:\".theme-button.green:hover, .active>.theme-button.green, .theme-button.active.green\";i:529;s:42:\".theme-button.purple, .color-button.purple\";i:530;s:85:\".theme-button.purple:hover, .active>.theme-button.purple, .theme-button.active.purple\";i:531;s:38:\".theme-button.teal, .color-button.teal\";i:532;s:79:\".theme-button.teal:hover, .active>.theme-button.teal, .theme-button.active.teal\";i:533;s:38:\".theme-button.pink, .color-button.pink\";i:534;s:79:\".theme-button.pink:hover, .active>.theme-button.pink, .theme-button.active.pink\";i:535;s:40:\".theme-button.brown, .color-button.brown\";i:536;s:82:\".theme-button.brown:hover, .active>.theme-button.brown, .theme-button.active.brown\";i:537;s:36:\".theme-button.red, .color-button.red\";i:538;s:76:\".theme-button.red:hover, .active>.theme-button.red, .theme-button.active.red\";i:539;s:38:\".theme-button.rosy, .color-button.rosy\";i:540;s:79:\".theme-button.rosy:hover, .active>.theme-button.rosy, .theme-button.active.rosy\";i:541;s:40:\".theme-button.white, .color-button.white\";i:542;s:82:\".theme-button.white:hover, .active>.theme-button.white, .theme-button.active.white\";i:543;s:25:\".theme-button.white:hover\";i:544;s:21:\".theme-button.outline\";i:545;s:36:\".wpex-carousel .theme-button.outline\";i:546;s:28:\".theme-button.outline:active\";i:547;s:27:\".theme-button.outline:hover\";i:548;s:88:\".active>.theme-button.outline, .theme-button.outline.active, .theme-button.outline:hover\";i:549;s:103:\".theme-button.clean, .theme-button.clean:hover, .theme-button.clean.active, .active>.theme-button.clean\";i:550;s:97:\"body .theme-button.clean:hover, body .theme-button.clean.active, body .active>.theme-button.clean\";i:551;s:31:\".theme-button.clean.black:hover\";i:552;s:26:\".theme-button.clean:active\";i:553;s:28:\".theme-button.minimal-border\";i:554;s:109:\".theme-button.minimal-border:hover, .active>.theme-button.minimal-border, .theme-button.minimal-border.active\";i:555;s:63:\".theme-button.outline.black, .theme-button.minimal-border.black\";i:556;s:61:\".theme-button.outline.grey, .theme-button.minimal-border.grey\";i:557;s:229:\".theme-button.outline.grey:hover, .theme-button.outline.grey.active, .active>.theme-button.outline.grey, .theme-button.minimal-border.grey:hover, .theme-button.minimal-border.grey.active, .active>.theme-button.minimal-border.grey\";i:558;s:61:\".theme-button.outline.blue, .theme-button.minimal-border.blue\";i:559;s:229:\".theme-button.outline.blue:hover, .theme-button.outline.blue.active, .active>.theme-button.outline.blue, .theme-button.minimal-border.blue:hover, .theme-button.minimal-border.blue.active, .active>.theme-button.minimal-border.blue\";i:560;s:65:\".theme-button.outline.orange, .theme-button.minimal-border.orange\";i:561;s:241:\".theme-button.outline.orange:hover, .theme-button.outline.orange.active, .active>.theme-button.outline.orange, .theme-button.minimal-border.orange:hover, .theme-button.minimal-border.orange.active, .active>.theme-button.minimal-border.orange\";i:562;s:61:\".theme-button.outline.gold, .theme-button.minimal-border.gold\";i:563;s:229:\".theme-button.outline.gold:hover, .theme-button.outline.gold.active, .active>.theme-button.outline.gold, .theme-button.minimal-border.gold:hover, .theme-button.minimal-border.gold.active, .active>.theme-button.minimal-border.gold\";i:564;s:92:\".theme-button.outline.green, .theme-button.outline.green, .theme-button.minimal-border.green\";i:565;s:235:\".theme-button.outline.green:hover, .active>.theme-button.outline.green, .theme-button.outline.green.active, .theme-button.minimal-border.green:hover, .theme-button.minimal-border.green.active, .active>.theme-button.minimal-border.green\";i:566;s:65:\".theme-button.outline.purple, .theme-button.minimal-border.purple\";i:567;s:241:\".theme-button.outline.purple:hover, .active>.theme-button.outline.purple, .theme-button.outline.purple.active, .theme-button.minimal-border.purple:hover, .active>.theme-button.minimal-border.purple, .theme-button.minimal-border.purple.active\";i:568;s:61:\".theme-button.outline.teal, .theme-button.minimal-border.teal\";i:569;s:229:\".theme-button.outline.teal:hover, .theme-button.outline.teal.active, .active>.theme-button.outline.teal, .theme-button.minimal-border.teal:hover, .theme-button.minimal-border.teal.active, .active>.theme-button.minimal-border.teal\";i:570;s:61:\".theme-button.outline.pink, .theme-button.minimal-border.pink\";i:571;s:229:\".theme-button.outline.pink:hover, .theme-button.outline.pink.active, .active>.theme-button.outline.pink, .theme-button.minimal-border.pink:hover, .theme-button.minimal-border.pink.active, .active>.theme-button.minimal-border.pink\";i:572;s:63:\".theme-button.outline.brown, .theme-button.minimal-border.brown\";i:573;s:235:\".theme-button.outline.brown:hover, .theme-button.outline.brown.active, .active>.theme-button.outline.brown, .theme-button.minimal-border.brown:hover, .theme-button.minimal-border.brown.active, .active>.theme-button.minimal-border.brown\";i:574;s:86:\".theme-button.outline.red, .theme-button.outline.red, .theme-button.minimal-border.red\";i:575;s:223:\".theme-button.outline.red:hover, .theme-button.outline.red.active, .active>.theme-button.outline.red, .theme-button.minimal-border.red:hover, .theme-button.minimal-border.red.active, .active>.theme-button.minimal-border.red\";i:576;s:61:\".theme-button.outline.rosy, .theme-button.minimal-border.rosy\";i:577;s:229:\".theme-button.outline.rosy:hover, .theme-button.outline.rosy.active, .active>.theme-button.outline.rosy, .theme-button.minimal-border.rosy:hover, .theme-button.minimal-border.rosy.active, .active>.theme-button.minimal-border.rosy\";i:578;s:63:\".theme-button.outline.white, .theme-button.minimal-border.white\";i:579;s:235:\".theme-button.outline.white:hover, .theme-button.outline.white.active, .active>.theme-button.outline.white, .theme-button.minimal-border.white:hover, .theme-button.minimal-border.white.active, .active>.theme-button.minimal-border.white\";i:580;s:109:\".theme-button.clean.grey, .theme-button.outline.grey, .theme-button.minimal-border.grey, .theme-txt-link.grey\";i:581;s:113:\".theme-button.clean.black, .theme-button.outline.black, .theme-button.minimal-border.black, .theme-txt-link.black\";i:582;s:109:\".theme-button.clean.blue, .theme-button.outline.blue, .theme-button.minimal-border.blue, .theme-txt-link.blue\";i:583;s:117:\".theme-button.clean.orange, .theme-button.outline.orange, .theme-button.minimal-border.orange, .theme-txt-link.orange\";i:584;s:109:\".theme-button.clean.gold, .theme-button.outline.gold, .theme-button.minimal-border.gold, .theme-txt-link.gold\";i:585;s:113:\".theme-button.clean.green, .theme-button.outline.green, .theme-button.minimal-border.green, .theme-txt-link.green\";i:586;s:117:\".theme-button.clean.purple, .theme-button.outline.purple, .theme-button.minimal-border.purple, .theme-txt-link.purple\";i:587;s:109:\".theme-button.clean.teal, .theme-button.outline.teal, .theme-button.minimal-border.teal, .theme-txt-link.teal\";i:588;s:109:\".theme-button.clean.pink, .theme-button.outline.pink, .theme-button.minimal-border.pink, .theme-txt-link.pink\";i:589;s:113:\".theme-button.clean.brown, .theme-button.outline.brown, .theme-button.minimal-border.brown, .theme-txt-link.brown\";i:590;s:105:\".theme-button.clean.red, .theme-button.outline.red, .theme-button.minimal-border.red, .theme-txt-link.red\";i:591;s:109:\".theme-button.clean.rosy, .theme-button.outline.rosy, .theme-button.minimal-border.rosy, .theme-txt-link.rosy\";i:592;s:351:\".active>.theme-button.outline.black, .active>.theme-button.minimal-border.black, .theme-button.outline.black:hover, .theme-button.minimal-border.black:hover, .theme-button.outline.black.active, .theme-button.minimal-border.blackk.active, .theme-button.clean.white, .theme-button.outline.white, .theme-button.minimal-border.white, .theme-txt-link.white\";i:593;s:47:\".active>.theme-txt-link, .theme-txt-link.active\";i:594;s:24:\".theme-txt-link.expanded\";i:595;s:40:\".theme-button.small, .color-button.small\";i:596;s:42:\".theme-button.medium, .color-button.medium\";i:597;s:40:\".theme-button.large, .color-button.large\";i:598;s:50:\".theme-button.align-left, .color-button.align-left\";i:599;s:52:\".theme-button.align-right, .color-button.align-right\";i:600;s:22:\".theme-button.expanded\";i:601;s:50:\".theme-button-icon-right, .color-button-icon-right\";i:602;s:48:\".theme-button-icon-left, .color-button-icon-left\";i:603;s:13:\".color-button\";i:604;s:19:\".color-button:hover\";i:605;s:17:\".error404-content\";i:606;s:20:\".error404-content h1\";i:607;s:30:\".error404-content p:last-child\";i:608;s:12:\".aligncenter\";i:609;s:11:\".alignright\";i:610;s:10:\".alignleft\";i:611;s:16:\".floatleftcenter\";i:612;s:12:\".floatcenter\";i:613;s:10:\".floatleft\";i:614;s:11:\".floatright\";i:615;s:11:\".wp-caption\";i:616;s:26:\"div.wp-caption.aligncenter\";i:617;s:15:\".wp-caption img\";i:618;s:29:\".wp-caption p.wp-caption-text\";i:619;s:21:\".wp-caption.alignnone\";i:620;s:10:\".wp-smiley\";i:621;s:15:\"#img-attch-page\";i:622;s:19:\"#img-attch-page img\";i:623;s:52:\".post-password-form label, .post-password-form input\";i:624;s:25:\".post-password-form input\";i:625;s:42:\".post-password-form input[type=\"password\"]\";i:626;s:25:\".post-password-form label\";i:627;s:10:\"form.login\";i:628;s:25:\"form.login .lost_password\";i:629;s:8:\".wpstats\";i:630;s:21:\"#wrap .wpex-gallery p\";i:631;s:23:\"#wrap .gallery-item img\";i:632;s:23:\".gallery-item img:hover\";i:633;s:16:\".gallery-caption\";i:634;s:26:\".entry .wpex-gallery.gap-1\";i:635;s:27:\".entry .wpex-gallery.gap-10\";i:636;s:27:\".entry .wpex-gallery.gap-15\";i:637;s:14:\".non-clickable\";i:638;s:19:\".readmore-link-wrap\";i:639;s:33:\".search-entry .readmore-link-wrap\";i:640;s:14:\".readmore-link\";i:641;s:4:\".hvr\";i:642;s:8:\".hvr img\";i:643;s:27:\".wpex-thumbnail-format-icon\";i:644;s:51:\"body.wpex-window-loaded .wpex-thumbnail-format-icon\";i:645;s:10:\".wpex-bars\";i:646;s:64:\".wpex-bars>span, .wpex-bars>span::before, .wpex-bars>span::after\";i:647;s:136:\".wpex-bars>span .white-style.dyn-styles, .wpex-bars>span::before .white-style.dyn-styles, .wpex-bars>span::after .white-style.dyn-styles\";i:648;s:47:\".wpex-bars>span::before, .wpex-bars>span::after\";i:649;s:15:\".wpex-bars>span\";i:650;s:23:\".wpex-bars>span::before\";i:651;s:22:\".wpex-bars>span::after\";i:652;s:28:\".wpex-active .wpex-bars>span\";i:653;s:36:\".wpex-active .wpex-bars>span::before\";i:654;s:35:\".wpex-active .wpex-bars>span::after\";i:655;s:61:\".wpex-single-templatera-notice, .wpex-single-elementor-notice\";i:656;s:75:\".wpex-single-templatera-notice .ticon, .wpex-single-elementor-notice .ticon\";i:657;s:25:\".wpex-disable-user-select\";i:658;s:15:\".wpex-highlight\";i:659;s:27:\".wpex-highlight .wpex-after\";i:660;s:8:\".rounded\";i:661;s:18:\"table th, table td\";i:662;s:8:\"table th\";i:663;s:5:\"thead\";i:664;s:36:\".display-none, .hidden, .wpex-hidden\";i:665;s:27:\".display-block, .wpex-block\";i:666;s:18:\".wpex-inline-block\";i:667;s:29:\".display-inline, .wpex-inline\";i:668;s:47:\"body.vc_editor.compose-mode .vc_element .hidden\";i:669;s:14:\".wpex-relative\";i:670;s:14:\".wpex-absolute\";i:671;s:11:\".textcenter\";i:672;s:10:\".textright\";i:673;s:9:\".textleft\";i:674;s:11:\".float-left\";i:675;s:12:\".float-right\";i:676;s:11:\".ticon-left\";i:677;s:12:\".ticon-right\";i:678;s:13:\".max-width-10\";i:679;s:13:\".max-width-20\";i:680;s:13:\".max-width-30\";i:681;s:13:\".max-width-40\";i:682;s:13:\".max-width-50\";i:683;s:13:\".max-width-60\";i:684;s:13:\".max-width-70\";i:685;s:13:\".max-width-80\";i:686;s:15:\"body .no-margin\";i:687;s:20:\"body .no-left-margin\";i:688;s:21:\"body .no-right-margin\";i:689;s:34:\".remove-last-p-margin p:last-child\";i:690;s:18:\".margin-bottom-5px\";i:691;s:19:\".margin-bottom-10px\";i:692;s:19:\".margin-bottom-15px\";i:693;s:19:\".margin-bottom-20px\";i:694;s:16:\"body .no-padding\";i:695;s:21:\"body .no-left-padding\";i:696;s:22:\"body .no-right-padding\";i:697;s:16:\".wpex-padding-10\";i:698;s:16:\".wpex-padding-20\";i:699;s:16:\".wpex-padding-30\";i:700;s:46:\".opacity-hover:hover, .opacity-hover:hover img\";i:701;s:34:\".wpex-show-on-load, .fade-in-image\";i:702;s:154:\"body.compose-mode .fade-in-image, body.compose-mode .wpex-show-on-load, body.wpex-window-loaded .fade-in-image, body.wpex-window-loaded .wpex-show-on-load\";i:703;s:23:\"body .wpex-semi-rounded\";i:704;s:18:\"body .wpex-rounded\";i:705;s:16:\"body .wpex-round\";i:706;s:13:\".wpex-bg-gray\";i:707;s:14:\".wpex-bordered\";i:708;s:24:\".bg-cover, .bg-stretched\";i:709;s:10:\".bg-repeat\";i:710;s:12:\".bg-repeat-x\";i:711;s:12:\".bg-repeat-y\";i:712;s:60:\"#wrap .bg-fixed-top, #wrap .bg-fixed-bottom, #wrap .bg-fixed\";i:713;s:19:\"#wrap .bg-fixed-top\";i:714;s:22:\"#wrap .bg-fixed-bottom\";i:715;s:155:\".wpex-is-mobile-device body, .wpex-is-mobile-device #wrap .bg-fixed, .wpex-is-mobile-device #wrap .bg-fixed-top, .wpex-is-mobile-device #wrap .bg-fixed-top\";i:716;s:14:\".wpex-term-tag\";i:717;s:5:\"video\";i:718;s:27:\".entry iframe, .entry embed\";i:719;s:61:\".wpex-roembed, .responsive-video-wrap, .responsive-audio-wrap\";i:720;s:247:\".wpex-roembed iframe, .wpex-roembed object, .wpex-roembed embed, .responsive-video-wrap iframe, .responsive-video-wrap object, .responsive-video-wrap embed, .responsive-audio-wrap iframe, .responsive-audio-wrap object, .responsive-audio-wrap embed\";i:721;s:67:\".wpex-roembed p, .responsive-video-wrap p, .responsive-audio-wrap p\";i:722;s:19:\".wp-video-shortcode\";i:723;s:39:\".wpex-window-loaded .wp-video-shortcode\";i:724;s:122:\".wpex-rounded-images figure img, .wpex-rounded-images figure .theme-overlay, .wpex-rounded-images figure .wpex-image-hover\";i:725;s:37:\".stretch-image img, img.stretch-image\";i:726;s:38:\"body #wrap .image-filter-grayscale img\";i:727;s:23:\".image-filter-grayscale\";i:728;s:29:\".image-filter-grayscale:hover\";i:729;s:13:\".image-shadow\";i:730;s:13:\".image-border\";i:731;s:14:\".image-rounded\";i:732;s:13:\".image-circle\";i:733;s:12:\".image-fancy\";i:734;s:38:\".image-hover:hover, .image-fancy:hover\";i:735;s:17:\".wpex-image-hover\";i:736;s:21:\".wpex-image-hover img\";i:737;s:35:\".wpex-image-hover.opacity:hover img\";i:738;s:22:\".wpex-image-hover.grow\";i:739;s:37:\".wpex-image-hover.grow.overlay-parent\";i:740;s:26:\".wpex-image-hover.grow img\";i:741;s:32:\".wpex-image-hover.grow:hover img\";i:742;s:34:\".wpex-image-hover.shrink:hover img\";i:743;s:36:\".wpex-image-hover.side-pan:hover img\";i:744;s:40:\".wpex-image-hover.vertical-pan:hover img\";i:745;s:22:\".wpex-image-hover.tilt\";i:746;s:32:\".wpex-image-hover.tilt:hover img\";i:747;s:69:\".wpex-image-hover.blurr:hover img, .wpex-image-hover.blurr-invert img\";i:748;s:40:\".wpex-image-hover.blurr-invert:hover img\";i:749;s:27:\".wpex-image-hover.sepia img\";i:750;s:53:\".wpex-image-hover.fade-in, .wpex-image-hover.fade-out\";i:751;s:61:\".wpex-image-hover.fade-out img, .wpex-image-hover.fade-in img\";i:752;s:67:\".wpex-image-hover.fade-in img, .wpex-image-hover.fade-out:hover img\";i:753;s:35:\".wpex-image-hover.fade-in:hover img\";i:754;s:15:\".transition-all\";i:755;s:17:\".animate-bg-hover\";i:756;s:60:\".wpex-hover-white-text:hover, .wpex-hover-white-text:hover *\";i:757;s:76:\"body .wpex-hover-inherit-color:hover, body .wpex-hover-inherit-color a:hover\";i:758;s:16:\".wpex-fs-overlay\";i:759;s:23:\".wpex-fs-overlay.active\";i:760;s:28:\".wpex-fs-overlay .wpex-inner\";i:761;s:39:\".wpex-fs-overlay .wpex-inner.wpex-scale\";i:762;s:46:\".wpex-fs-overlay.active .wpex-inner.wpex-scale\";i:763;s:28:\".wpex-fs-overlay .wpex-close\";i:764;s:34:\".wpex-fs-overlay .wpex-close:hover\";i:765;s:14:\".theme-heading\";i:766;s:24:\".theme-heading span.text\";i:767;s:30:\".theme-heading span.text:after\";i:768;s:20:\".theme-heading.plain\";i:769;s:30:\".theme-heading.plain span.text\";i:770;s:36:\".theme-heading.plain span.text:after\";i:771;s:26:\".theme-heading.plain:after\";i:772;s:29:\".theme-heading.border-w-color\";i:773;s:39:\".theme-heading.border-w-color span.text\";i:774;s:45:\".theme-heading.border-w-color span.text:after\";i:775;s:10:\".post-edit\";i:776;s:36:\"body.is_customize_preview .post-edit\";i:777;s:35:\"body.content-full-screen .post-edit\";i:778;s:12:\".post-edit a\";i:779;s:18:\".post-edit a:hover\";i:780;s:16:\".wpex-social-btn\";i:781;s:22:\".wpex-social-btn:hover\";i:782;s:24:\".wpex-social-btn-minimal\";i:783;s:30:\".wpex-social-btn-minimal:hover\";i:784;s:21:\".wpex-social-btn-flat\";i:785;s:19:\".wpex-social-btn-3d\";i:786;s:25:\".wpex-social-btn-3d:hover\";i:787;s:26:\".wpex-social-btn-3d:active\";i:788;s:49:\".wpex-social-btn-black, .wpex-social-btn-black-ch\";i:789;s:61:\".wpex-social-btn-black:hover, .wpex-social-btn-black-ch:hover\";i:790;s:26:\".wpex-social-btn-graphical\";i:791;s:25:\".wpex-social-btn-bordered\";i:792;s:31:\".wpex-social-btn-bordered:hover\";i:793;s:88:\"#wrap .wpex-social-color.wpex-twitter, #wrap .wpex-social-color-hover.wpex-twitter:hover\";i:794;s:90:\"#wrap .wpex-social-color.wpex-facebook, #wrap .wpex-social-color-hover.wpex-facebook:hover\";i:795;s:94:\"#wrap .wpex-social-color.wpex-googleplus, #wrap .wpex-social-color-hover.wpex-googleplus:hover\";i:796;s:96:\"#wrap .wpex-social-color.wpex-google-plus, #wrap .wpex-social-color-hover.wpex-google-plus:hover\";i:797;s:96:\"#wrap .wpex-social-color.wpex-tripadvisor, #wrap .wpex-social-color-hover.wpex-tripadvisor:hover\";i:798;s:92:\"#wrap .wpex-social-color.wpex-pinterest, #wrap .wpex-social-color-hover.wpex-pinterest:hover\";i:799;s:82:\"#wrap .wpex-social-color.wpex-etsy, #wrap .wpex-social-color-hover.wpex-etsy:hover\";i:800;s:90:\"#wrap .wpex-social-color.wpex-linkedin, #wrap .wpex-social-color-hover.wpex-linkedin:hover\";i:801;s:90:\"#wrap .wpex-social-color.wpex-dribbble, #wrap .wpex-social-color-hover.wpex-dribbble:hover\";i:802;s:84:\"#wrap .wpex-social-color.wpex-skype, #wrap .wpex-social-color-hover.wpex-skype:hover\";i:803;s:90:\"#wrap .wpex-social-color.wpex-envelope, #wrap .wpex-social-color-hover.wpex-envelope:hover\";i:804;s:82:\"#wrap .wpex-social-color.wpex-mail, #wrap .wpex-social-color-hover.wpex-mail:hover\";i:805;s:92:\"#wrap .wpex-social-color.wpex-instagram, #wrap .wpex-social-color-hover.wpex-instagram:hover\";i:806;s:86:\"#wrap .wpex-social-color.wpex-flickr, #wrap .wpex-social-color-hover.wpex-flickr:hover\";i:807;s:78:\"#wrap .wpex-social-color.wpex-vk, #wrap .wpex-social-color-hover.wpex-vk:hover\";i:808;s:86:\"#wrap .wpex-social-color.wpex-trello, #wrap .wpex-social-color-hover.wpex-trello:hover\";i:809;s:86:\"#wrap .wpex-social-color.wpex-tumblr, #wrap .wpex-social-color-hover.wpex-tumblr:hover\";i:810;s:94:\"#wrap .wpex-social-color.wpex-foursquare, #wrap .wpex-social-color-hover.wpex-foursquare:hover\";i:811;s:82:\"#wrap .wpex-social-color.wpex-xing, #wrap .wpex-social-color-hover.wpex-xing:hover\";i:812;s:86:\"#wrap .wpex-social-color.wpex-renren, #wrap .wpex-social-color-hover.wpex-renren:hover\";i:813;s:84:\"#wrap .wpex-social-color.wpex-vimeo, #wrap .wpex-social-color-hover.wpex-vimeo:hover\";i:814;s:88:\"#wrap .wpex-social-color.wpex-youtube, #wrap .wpex-social-color-hover.wpex-youtube:hover\";i:815;s:80:\"#wrap .wpex-social-color.wpex-rss, #wrap .wpex-social-color-hover.wpex-rss:hover\";i:816;s:82:\"#wrap .wpex-social-color.wpex-vine, #wrap .wpex-social-color-hover.wpex-vine:hover\";i:817;s:84:\"#wrap .wpex-social-color.wpex-email, #wrap .wpex-social-color-hover.wpex-email:hover\";i:818;s:88:\"#wrap .wpex-social-color.wpex-website, #wrap .wpex-social-color-hover.wpex-website:hover\";i:819;s:98:\"#wrap .wpex-social-color.wpex-phone-number, #wrap .wpex-social-color-hover.wpex-phone-number:hover\";i:820;s:84:\"#wrap .wpex-social-color.wpex-phone, #wrap .wpex-social-color-hover.wpex-phone:hover\";i:821;s:82:\"#wrap .wpex-social-color.wpex-yelp, #wrap .wpex-social-color-hover.wpex-yelp:hover\";i:822;s:84:\"#wrap .wpex-social-color.wpex-houzz, #wrap .wpex-social-color-hover.wpex-houzz:hover\";i:823;s:90:\"#wrap .wpex-social-color.wpex-whatsapp, #wrap .wpex-social-color-hover.wpex-whatsapp:hover\";i:824;s:88:\"#wrap .wpex-social-color.wpex-spotify, #wrap .wpex-social-color-hover.wpex-spotify:hover\";i:825;s:86:\"#wrap .wpex-social-color.wpex-twitch, #wrap .wpex-social-color-hover.wpex-twitch:hover\";i:826;s:84:\"#wrap .wpex-social-color.wpex-quora, #wrap .wpex-social-color-hover.wpex-quora:hover\";i:827;s:15:\".wpex-social-bg\";i:828;s:21:\".wpex-social-bg:hover\";i:829;s:38:\".wpex-social-bg, .wpex-social-bg:hover\";i:830;s:70:\".wpex-social-bg.wpex-twitter, .wpex-social-bg-hover.wpex-twitter:hover\";i:831;s:72:\".wpex-social-bg.wpex-facebook, .wpex-social-bg-hover.wpex-facebook:hover\";i:832;s:76:\".wpex-social-bg.wpex-googleplus, .wpex-social-bg-hover.wpex-googleplus:hover\";i:833;s:78:\".wpex-social-bg.wpex-google-plus, .wpex-social-bg-hover.wpex-google-plus:hover\";i:834;s:78:\".wpex-social-bg.wpex-tripadvisor, .wpex-social-bg-hover.wpex-tripadvisor:hover\";i:835;s:74:\".wpex-social-bg.wpex-pinterest, .wpex-social-bg-hover.wpex-pinterest:hover\";i:836;s:64:\".wpex-social-bg.wpex-etsy, .wpex-social-bg-hover.wpex-etsy:hover\";i:837;s:72:\".wpex-social-bg.wpex-linkedin, .wpex-social-bg-hover.wpex-linkedin:hover\";i:838;s:72:\".wpex-social-bg.wpex-dribbble, .wpex-social-bg-hover.wpex-dribbble:hover\";i:839;s:66:\".wpex-social-bg.wpex-skype, .wpex-social-bg-hover.wpex-skype:hover\";i:840;s:72:\".wpex-social-bg.wpex-envelope, .wpex-social-bg-hover.wpex-envelope:hover\";i:841;s:64:\".wpex-social-bg.wpex-mail, .wpex-social-bg-hover.wpex-mail:hover\";i:842;s:74:\".wpex-social-bg.wpex-instagram, .wpex-social-bg-hover.wpex-instagram:hover\";i:843;s:68:\".wpex-social-bg.wpex-flickr, .wpex-social-bg-hover.wpex-flickr:hover\";i:844;s:60:\".wpex-social-bg.wpex-vk, .wpex-social-bg-hover.wpex-vk:hover\";i:845;s:68:\".wpex-social-bg.wpex-trello, .wpex-social-bg-hover.wpex-trello:hover\";i:846;s:68:\".wpex-social-bg.wpex-tumblr, .wpex-social-bg-hover.wpex-tumblr:hover\";i:847;s:76:\".wpex-social-bg.wpex-foursquare, .wpex-social-bg-hover.wpex-foursquare:hover\";i:848;s:64:\".wpex-social-bg.wpex-xing, .wpex-social-bg-hover.wpex-xing:hover\";i:849;s:68:\".wpex-social-bg.wpex-renren, .wpex-social-bg-hover.wpex-renren:hover\";i:850;s:66:\".wpex-social-bg.wpex-vimeo, .wpex-social-bg-hover.wpex-vimeo:hover\";i:851;s:70:\".wpex-social-bg.wpex-youtube, .wpex-social-bg-hover.wpex-youtube:hover\";i:852;s:62:\".wpex-social-bg.wpex-rss, .wpex-social-bg-hover.wpex-rss:hover\";i:853;s:64:\".wpex-social-bg.wpex-vine, .wpex-social-bg-hover.wpex-vine:hover\";i:854;s:66:\".wpex-social-bg.wpex-email, .wpex-social-bg-hover.wpex-email:hover\";i:855;s:70:\".wpex-social-bg.wpex-website, .wpex-social-bg-hover.wpex-website:hover\";i:856;s:80:\".wpex-social-bg.wpex-phone-number, .wpex-social-bg-hover.wpex-phone-number:hover\";i:857;s:66:\".wpex-social-bg.wpex-phone, .wpex-social-bg-hover.wpex-phone:hover\";i:858;s:64:\".wpex-social-bg.wpex-yelp, .wpex-social-bg-hover.wpex-yelp:hover\";i:859;s:66:\".wpex-social-bg.wpex-houzz, .wpex-social-bg-hover.wpex-houzz:hover\";i:860;s:72:\".wpex-social-bg.wpex-whatsapp, .wpex-social-bg-hover.wpex-whatsapp:hover\";i:861;s:70:\".wpex-social-bg.wpex-spotify, .wpex-social-bg-hover.wpex-spotify:hover\";i:862;s:68:\".wpex-social-bg.wpex-twitch, .wpex-social-bg-hover.wpex-twitch:hover\";i:863;s:66:\".wpex-social-bg.wpex-quora, .wpex-social-bg-hover.wpex-quora:hover\";i:864;s:32:\".wpex-social-border.wpex-twitter\";i:865;s:33:\".wpex-social-border.wpex-facebook\";i:866;s:35:\".wpex-social-border.wpex-googleplus\";i:867;s:36:\".wpex-social-border.wpex-google-plus\";i:868;s:36:\".wpex-social-border.wpex-tripadvisor\";i:869;s:34:\".wpex-social-border.wpex-pinterest\";i:870;s:29:\".wpex-social-border.wpex-etsy\";i:871;s:33:\".wpex-social-border.wpex-linkedin\";i:872;s:33:\".wpex-social-border.wpex-dribbble\";i:873;s:30:\".wpex-social-border.wpex-skype\";i:874;s:33:\".wpex-social-border.wpex-envelope\";i:875;s:29:\".wpex-social-border.wpex-mail\";i:876;s:34:\".wpex-social-border.wpex-instagram\";i:877;s:31:\".wpex-social-border.wpex-flickr\";i:878;s:27:\".wpex-social-border.wpex-vk\";i:879;s:31:\".wpex-social-border.wpex-trello\";i:880;s:31:\".wpex-social-border.wpex-tumblr\";i:881;s:35:\".wpex-social-border.wpex-foursquare\";i:882;s:29:\".wpex-social-border.wpex-xing\";i:883;s:31:\".wpex-social-border.wpex-renren\";i:884;s:30:\".wpex-social-border.wpex-vimeo\";i:885;s:32:\".wpex-social-border.wpex-youtube\";i:886;s:28:\".wpex-social-border.wpex-rss\";i:887;s:29:\".wpex-social-border.wpex-vine\";i:888;s:30:\".wpex-social-border.wpex-email\";i:889;s:32:\".wpex-social-border.wpex-website\";i:890;s:37:\".wpex-social-border.wpex-phone-number\";i:891;s:30:\".wpex-social-border.wpex-phone\";i:892;s:29:\".wpex-social-border.wpex-yelp\";i:893;s:30:\".wpex-social-border.wpex-houzz\";i:894;s:33:\".wpex-social-border.wpex-whatsapp\";i:895;s:32:\".wpex-social-border.wpex-spotify\";i:896;s:31:\".wpex-social-border.wpex-twitch\";i:897;s:30:\".wpex-social-border.wpex-quora\";i:898;s:17:\".wpex-has-overlay\";i:899;s:91:\".wpex-has-overlay .container, .wpex-has-overlay .wpb_column, .wpex-has-overlay .wpb_wrapper\";i:900;s:45:\".wpex-video-bg-overlay, .wpex-bg-overlay-wrap\";i:901;s:79:\".wpex-video-bg-overlay .wpex-bg-overlay, .wpex-bg-overlay-wrap .wpex-bg-overlay\";i:902;s:93:\".wpex-video-bg-overlay .wpex-bg-overlay.custom, .wpex-bg-overlay-wrap .wpex-bg-overlay.custom\";i:903;s:54:\".wpex-video-bg-overlay.dotted, .wpex-bg-overlay.dotted\";i:904;s:54:\".wpex-video-bg-overlay.dashed, .wpex-bg-overlay.dashed\";i:905;s:22:\".wpex-parallax-bg-wrap\";i:906;s:69:\".wpex-parallax-bg-wrap .container, .wpex-parallax-bg-wrap .wpb_column\";i:907;s:17:\".wpex-parallax-bg\";i:908;s:31:\".compose-mode .wpex-parallax-bg\";i:909;s:30:\".wpex-parallax-bg.fixed-repeat\";i:910;s:33:\".wpex-parallax-bg.fixed-no-repeat\";i:911;s:55:\"body.wpex-is-mobile-device .wpex-parallax-bg.not-mobile\";i:912;s:68:\"body.wpex-is-mobile-device .wpex-parallax-bg.not-mobile.fixed-repeat\";i:913;s:18:\".wpex-has-video-bg\";i:914;s:61:\".wpex-has-video-bg .container, .wpex-has-video-bg .wpb_column\";i:915;s:19:\".wpex-video-bg-wrap\";i:916;s:14:\".wpex-video-bg\";i:917;s:79:\".wpex-is-mobile-device .vc_video-bg, .wpex-is-mobile-device .wpex-video-bg-wrap\";i:918;s:15:\".overlay-parent\";i:919;s:61:\".overlay-parent>a, .overlay-parent>a img, .overlay-parent>img\";i:920;s:14:\".overlay-table\";i:921;s:19:\".overlay-table-cell\";i:922;s:13:\".overlay-hide\";i:923;s:79:\".overlay-parent:hover .overlay-hide, .overlay-parent.wpex-touched .overlay-hide\";i:924;s:21:\".overlay-title-center\";i:925;s:49:\".overlay-title-center:hover .overlay-title-center\";i:926;s:27:\".overlay-title-center-boxed\";i:927;s:47:\".overlay-title-center-boxed .overlay-table-cell\";i:928;s:54:\".overlay-title-center-boxed .overlay-table-cell .title\";i:929;s:17:\".magnifying-hover\";i:930;s:24:\".magnifying-hover .ticon\";i:931;s:19:\".overlay-plus-hover\";i:932;s:41:\".overlay-parent:hover .overlay-plus-hover\";i:933;s:23:\".overlay-plus-two-hover\";i:934;s:30:\".overlay-plus-two-hover .ticon\";i:935;s:25:\".overlay-plus-three-hover\";i:936;s:32:\".overlay-plus-three-hover .ticon\";i:937;s:101:\".overlay-plus-three-hover:hover .ticon, .overlay-parent.wpex-touched .overlay-plus-three-hover .ticon\";i:938;s:22:\".overlay-slideup-title\";i:939;s:28:\".overlay-slideup-title.white\";i:940;s:28:\".overlay-slideup-title.black\";i:941;s:33:\".overlay-slideup-title span.title\";i:942;s:39:\".overlay-slideup-title.black span.title\";i:943;s:97:\".overlay-parent:hover .overlay-slideup-title, .overlay-parent.wpex-touched .overlay-slideup-title\";i:944;s:119:\".overlay-parent:hover .overlay-slideup-title span.title, .overlay-parent.wpex-touched .overlay-slideup-title span.title\";i:945;s:30:\".overlay-view-lightbox-buttons\";i:946;s:32:\".overlay-view-lightbox-buttons a\";i:947;s:44:\".overlay-view-lightbox-buttons a:first-child\";i:948;s:38:\".overlay-view-lightbox-buttons a:hover\";i:949;s:39:\".overlay-view-lightbox-buttons a .ticon\";i:950;s:50:\".blog-entry-inner .overlay-view-lightbox-buttons a\";i:951;s:27:\".overlay-view-lightbox-text\";i:952;s:29:\".overlay-view-lightbox-text a\";i:953;s:41:\".overlay-view-lightbox-text a:first-child\";i:954;s:35:\".overlay-view-lightbox-text a:hover\";i:955;s:36:\".overlay-view-lightbox-text a .ticon\";i:956;s:42:\".overlay-view-lightbox-text a:hover .ticon\";i:957;s:28:\".overlay-title-excerpt-hover\";i:958;s:48:\".overlay-title-excerpt-hover .overlay-table-cell\";i:959;s:133:\".overlay-title-excerpt-hover:hover .overlay-table-cell, .overlay-parent.wpex-touched .overlay-title-excerpt-hover .overlay-table-cell\";i:960;s:43:\".overlay-title-excerpt-hover .overlay-title\";i:961;s:45:\".overlay-title-excerpt-hover .overlay-excerpt\";i:962;s:29:\".overlay-title-category-hover\";i:963;s:49:\".overlay-title-category-hover .overlay-table-cell\";i:964;s:135:\".overlay-title-category-hover:hover .overlay-table-cell, .overlay-parent.wpex-touched .overlay-title-category-hover .overlay-table-cell\";i:965;s:44:\".overlay-title-category-hover .overlay-title\";i:966;s:44:\".overlay-title-category-hover .overlay-terms\";i:967;s:31:\".overlay-title-category-visible\";i:968;s:51:\".overlay-title-category-visible .overlay-table-cell\";i:969;s:46:\".overlay-title-category-visible .overlay-title\";i:970;s:46:\".overlay-title-category-visible .overlay-terms\";i:971;s:25:\".overlay-title-date-hover\";i:972;s:45:\".overlay-title-date-hover .overlay-table-cell\";i:973;s:127:\".overlay-title-date-hover:hover .overlay-table-cell, .overlay-parent.wpex-touched .overlay-title-date-hover .overlay-table-cell\";i:974;s:40:\".overlay-title-date-hover .overlay-title\";i:975;s:39:\".overlay-title-date-hover .overlay-date\";i:976;s:27:\".overlay-title-date-visible\";i:977;s:47:\".overlay-title-date-visible .overlay-table-cell\";i:978;s:42:\".overlay-title-date-visible .overlay-title\";i:979;s:41:\".overlay-title-date-visible .overlay-date\";i:980;s:62:\".overlay-parent-title-push-up, .overlay-parent-title-push-up>a\";i:981;s:33:\".overlay-parent-title-push-up img\";i:982;s:22:\".overlay-title-push-up\";i:983;s:56:\".overlay-title-bottom, .overlay-title-bottom-see-through\";i:984;s:33:\".overlay-title-bottom-see-through\";i:985;s:21:\".overlay-hover-button\";i:986;s:26:\".overlay-hover-button-text\";i:987;s:105:\".overlay-parent:hover .overlay-hover-button-text, .overlay-parent.wpex-touched .overlay-hover-button-text\";i:988;s:39:\".theme-button.overlay-hover-button-link\";i:989;s:21:\".overlay-category-tag\";i:990;s:23:\".overlay-category-tag a\";i:991;s:29:\".overlay-category-tag a:hover\";i:992;s:25:\".overlay-category-tag-two\";i:993;s:27:\".overlay-category-tag-two a\";i:994;s:33:\".overlay-category-tag-two a:hover\";i:995;s:25:\".overlay-cats-title-btm-v\";i:996;s:30:\".overlay-cats-title-btm-v-cats\";i:997;s:32:\".overlay-cats-title-btm-v-cats a\";i:998;s:38:\".overlay-cats-title-btm-v .entry-title\";i:999;s:44:\".overlay-cats-title-btm-v .entry-title:hover\";i:1000;s:60:\".overlay-parent-thumb-swap, .overlay-parent-thumb-swap-title\";i:1001;s:29:\".overlay-thumb-swap-secondary\";i:1002;s:62:\".overlay-parent-thumb-swap-title .overlay-thumb-swap-secondary\";i:1003;s:25:\".overlay-thumb-swap-title\";i:1004;s:30:\".overlay-thumb-swap-title>span\";i:1005;s:33:\".overlay-thumb-swap-title::before\";i:1006;s:33:\".overlay-thumb-swap-secondary img\";i:1007;s:138:\".overlay-parent:hover .overlay-thumb-swap-secondary, .overlay-parent.wpex-touched .overlay-parent-thumb-swap .overlay-thumb-swap-secondary\";i:1008;s:13:\".overlay-icon\";i:1009;s:18:\".overlay-icon span\";i:1010;s:37:\"body.wpex-window-loaded .overlay-icon\";i:1011;s:19:\".overlay-icon:hover\";i:1012;s:35:\"body .fancybox-is-open .fancybox-bg\";i:1013;s:28:\"body .fancybox-caption__body\";i:1014;s:24:\".fancybox-caption__title\";i:1015;s:31:\".fancybox-caption__title-margin\";i:1016;s:33:\"button.fancybox-close-small:hover\";i:1017;s:40:\".fancybox-button, .fancybox-button:hover\";i:1018;s:21:\"body .fancybox-thumbs\";i:1019;s:36:\"body .fancybox-thumbs__list a:before\";i:1020;s:94:\"body.woocommerce .fancybox-button[disabled], body.woocommerce .fancybox-button[disabled]:hover\";i:1021;s:12:\".wpex-slider\";i:1022;s:48:\".wpex-slider .sp-grab, .wpex-slider .sp-grabbing\";i:1023;s:14:\".wpex-slider *\";i:1024;s:24:\".wpex-slider .sp-buttons\";i:1025;s:23:\".wpex-slider .sp-button\";i:1026;s:63:\".wpex-slider .sp-button:hover, .wpex-slider .sp-selected-button\";i:1027;s:22:\".wpex-slider .sp-arrow\";i:1028;s:28:\".wpex-slider .sp-arrow:hover\";i:1029;s:45:\".wpex-slider.sp-horizontal .sp-previous-arrow\";i:1030;s:41:\".wpex-slider.sp-horizontal .sp-next-arrow\";i:1031;s:29:\".wpex-slider .sp-arrow:before\";i:1032;s:47:\".wpex-slider .sp-arrow.sp-previous-arrow:before\";i:1033;s:43:\".wpex-slider .sp-arrow.sp-next-arrow:before\";i:1034;s:28:\".wpex-slider .sp-arrow:after\";i:1035;s:53:\".wpex-slider.arrows-topright.sp-horizontal .sp-arrows\";i:1036;s:63:\".wpex-slider.arrows-topright.sp-horizontal .sp-arrows .sp-arrow\";i:1037;s:35:\".wpex-slider .sp-layer p:last-child\";i:1038;s:24:\".wpex-slider .sp-black a\";i:1039;s:24:\".wpex-slider .sp-white a\";i:1040;s:33:\".wpex-slider .sp-thumbnail-arrows\";i:1041;s:53:\".wpex-slider-preloaderimg img, .wpex-slider-media img\";i:1042;s:88:\".wpex-slider.no-stretch .wpex-slider-media img, .wpex-slider-preloaderimg.no-stretch img\";i:1043;s:18:\".wpex-slider-slide\";i:1044;s:23:\".wpex-slider-media-link\";i:1045;s:20:\".wpex-slider-caption\";i:1046;s:23:\".wpex-slider-thumbnails\";i:1047;s:36:\".wpex-slider .sp-thumbnail-container\";i:1048;s:58:\".wpex-slider .sp-thumbnails-container.sp-bottom-thumbnails\";i:1049;s:30:\".wpex-slider .sp-nc-thumbnails\";i:1050;s:67:\".wpex-slider .sp-thumbnails img, .wpex-slider .sp-nc-thumbnails img\";i:1051;s:197:\".wpex-slider .sp-thumbnails img:hover, .wpex-slider .sp-thumbnails .sp-selected-thumbnail img, .wpex-slider .sp-nc-thumbnails img:hover, .wpex-slider .sp-nc-thumbnails .sp-nc-selected-thumbnail img\";i:1052;s:63:\".wpex-slider .sp-bottom-thumbnails .sp-previous-thumbnail-arrow\";i:1053;s:59:\".wpex-slider .sp-bottom-thumbnails .sp-next-thumbnail-arrow\";i:1054;s:39:\".wpex-slider .sp-nc-thumbnail-container\";i:1055;s:51:\".wpex-slider .sp-nc-thumbnail-container:first-child\";i:1056;s:51:\".wpex-slider.no-margin-thumbnails .sp-nc-thumbnails\";i:1057;s:55:\".wpex-slider.no-margin-thumbnails .sp-bottom-thumbnails\";i:1058;s:60:\".wpex-slider.no-margin-thumbnails .sp-nc-thumbnail-container\";i:1059;s:53:\".wpex-slider.no-margin-thumbnails img.sp-nc-thumbnail\";i:1060;s:91:\".wpex-slider.no-margin-thumbnails .wpex-slider-thumbnails.cols-6 .sp-nc-thumbnail-container\";i:1061;s:91:\".wpex-slider.no-margin-thumbnails .wpex-slider-thumbnails.cols-5 .sp-nc-thumbnail-container\";i:1062;s:91:\".wpex-slider.no-margin-thumbnails .wpex-slider-thumbnails.cols-4 .sp-nc-thumbnail-container\";i:1063;s:91:\".wpex-slider.no-margin-thumbnails .wpex-slider-thumbnails.cols-3 .sp-nc-thumbnail-container\";i:1064;s:91:\".wpex-slider.no-margin-thumbnails .wpex-slider-thumbnails.cols-2 .sp-nc-thumbnail-container\";i:1065;s:159:\".wpex-slider .sp-bottom-thumbnails.sp-has-pointer .sp-selected-thumbnail:before, .wpex-slider .sp-bottom-thumbnails.sp-has-pointer .sp-selected-thumbnail:after\";i:1066;s:14:\".wpex-carousel\";i:1067;s:25:\".wpex-carousel.no-margins\";i:1068;s:41:\".wpex-carousel.owl-carousel .owl-item img\";i:1069;s:26:\".wpex-carousel-entry-media\";i:1070;s:30:\".wpex-carousel-entry-media img\";i:1071;s:56:\".wpex-carousel.no-margins .wpex-carousel-entry-media img\";i:1072;s:28:\".wpex-carousel-entry-details\";i:1073;s:28:\".wpex-carousel-entry-excerpt\";i:1074;s:41:\".wpex-carousel-entry-excerpt p:last-child\";i:1075;s:31:\".wpex-carousel-entry-price span\";i:1076;s:48:\".wpex-carousel.owl-carousel .owl-video-play-icon\";i:1077;s:70:\".wpex-carousel.owl-carousel .owl-item-video .wpex-carousel-entry-media\";i:1078;s:24:\".wpex-carousel .owl-dots\";i:1079;s:33:\".wpex-carousel .owl-dots.disabled\";i:1080;s:29:\".wpex-carousel button.owl-dot\";i:1081;s:23:\".wpex-carousel .owl-nav\";i:1082;s:32:\".wpex-carousel .owl-nav.disabled\";i:1083;s:50:\".wpex-carousel .owl-prev, .wpex-carousel .owl-next\";i:1084;s:24:\".wpex-carousel .owl-prev\";i:1085;s:24:\".wpex-carousel .owl-next\";i:1086;s:37:\".wpex-carousel.arrwpos-right .owl-nav\";i:1087;s:36:\".wpex-carousel.arrwpos-left .owl-nav\";i:1088;s:38:\".wpex-carousel.arrwpos-center .owl-nav\";i:1089;s:80:\".wpex-carousel.arrwpos-center .owl-prev, .wpex-carousel.arrwpos-center .owl-next\";i:1090;s:80:\".wpex-carousel.arrwstyle-slim .owl-prev, .wpex-carousel.arrwstyle-slim .owl-next\";i:1091;s:92:\".wpex-carousel.arrwstyle-slim .owl-prev:hover, .wpex-carousel.arrwstyle-slim .owl-next:hover\";i:1092;s:53:\".wpex-carousel.arrwstyle-slim .owl-prev .ticon:before\";i:1093;s:53:\".wpex-carousel.arrwstyle-slim .owl-next .ticon:before\";i:1094;s:104:\".wpex-carousel.arrwstyle-slim.arrwpos-abs .owl-prev, .wpex-carousel.arrwstyle-slim.arrwpos-abs .owl-next\";i:1095;s:51:\".wpex-carousel.arrwstyle-slim.arrwpos-abs .owl-prev\";i:1096;s:51:\".wpex-carousel.arrwstyle-slim.arrwpos-abs .owl-next\";i:1097;s:78:\".wpex-carousel.arrwstyle-min .owl-prev, .wpex-carousel.arrwstyle-min .owl-next\";i:1098;s:90:\".wpex-carousel.arrwstyle-min .owl-prev:hover, .wpex-carousel.arrwstyle-min .owl-next:hover\";i:1099;s:84:\".wpex-carousel.arrwstyle-circle .owl-prev, .wpex-carousel.arrwstyle-circle .owl-next\";i:1100;s:96:\".wpex-carousel.arrwstyle-circle .owl-prev:hover, .wpex-carousel.arrwstyle-circle .owl-next:hover\";i:1101;s:55:\".wpex-carousel.arrwstyle-circle .owl-prev .ticon:before\";i:1102;s:55:\".wpex-carousel.arrwstyle-circle .owl-next .ticon:before\";i:1103;s:84:\".wpex-carousel.arrwstyle-border .owl-prev, .wpex-carousel.arrwstyle-border .owl-next\";i:1104;s:96:\".wpex-carousel.arrwstyle-border .owl-prev:hover, .wpex-carousel.arrwstyle-border .owl-next:hover\";i:1105;s:74:\".wpex-carousel.arrwpos-abs .owl-prev, .wpex-carousel.arrwpos-abs .owl-next\";i:1106;s:86:\".wpex-carousel.arrwpos-abs .owl-prev:hover, .wpex-carousel.arrwpos-abs .owl-next:hover\";i:1107;s:36:\".wpex-carousel.arrwpos-abs .owl-prev\";i:1108;s:36:\".wpex-carousel.arrwpos-abs .owl-next\";i:1109;s:108:\".wpex-carousel.arrwpos-abs.arrwstyle-circle .owl-prev, .wpex-carousel.arrwpos-abs.arrwstyle-circle .owl-next\";i:1110;s:108:\".wpex-carousel.arrwpos-abs.arrwstyle-border .owl-prev, .wpex-carousel.arrwpos-abs.arrwstyle-border .owl-next\";i:1111;s:102:\".wpex-carousel.arrwpos-abs.arrwstyle-min .owl-prev, .wpex-carousel.arrwpos-abs.arrwstyle-min .owl-next\";i:1112;s:110:\".wpex-carousel.arrwpos-abs.arrwstyle-default .owl-prev, .wpex-carousel.arrwpos-abs.arrwstyle-default .owl-next\";i:1113;s:71:\".wpex-carousel.arrwpos-abs.arrwstyle-default .ticon-chevron-left:before\";i:1114;s:72:\".wpex-carousel.arrwpos-abs.arrwstyle-default .ticon-chevron-right:before\";i:1115;s:17:\".site-breadcrumbs\";i:1116;s:19:\".site-breadcrumbs a\";i:1117;s:35:\".site-breadcrumbs .breadcrumb-trail\";i:1118;s:35:\".site-breadcrumbs .breadcrumb-title\";i:1119;s:22:\".site-breadcrumbs .sep\";i:1120;s:38:\".site-breadcrumbs.position-under-title\";i:1121;s:47:\".background-image-page-header .site-breadcrumbs\";i:1122;s:49:\".background-image-page-header .site-breadcrumbs a\";i:1123;s:21:\".post-pagination-wrap\";i:1124;s:16:\".post-pagination\";i:1125;s:27:\".post-pagination .post-prev\";i:1126;s:32:\".post-pagination .post-prev span\";i:1127;s:27:\".post-pagination .post-next\";i:1128;s:32:\".post-pagination .post-next span\";i:1129;s:18:\".post-pagination a\";i:1130;s:28:\"ul.page-numbers, .page-links\";i:1131;s:34:\"ul.page-numbers li, .page-links li\";i:1132;s:66:\"ul.page-numbers li:last-child>span, .page-links li:last-child>span\";i:1133;s:128:\"ul.page-numbers li:first-child, ul.page-numbers li:first-child>span, .page-links li:first-child, .page-links li:first-child>span\";i:1134;s:15:\"ul.page-numbers\";i:1135;s:36:\"ul.page-numbers li, .page-links span\";i:1136;s:152:\"ul.page-numbers a, span.page-numbers, .page-links span, .page-links a>span, .bbp-pagination-links span.page-numbers, .bbp-pagination-links .page-numbers\";i:1137;s:162:\".page-numbers a:hover, .page-numbers.current, .page-numbers.current:hover, .page-links span, .page-links a>span:hover, .bbp-pagination-links .page-numbers.current\";i:1138;s:21:\".page-numbers.current\";i:1139;s:19:\".page-numbers:hover\";i:1140;s:28:\".wpex-pagination.wpex-center\";i:1141;s:27:\".wpex-pagination.wpex-right\";i:1142;s:20:\".infinite-scroll-nav\";i:1143;s:21:\".infinite-scroll-wrap\";i:1144;s:20:\"#wpex-infscr-loading\";i:1145;s:24:\".wpex-infscr-spinner img\";i:1146;s:27:\".wpex-infscr-spinner .ticon\";i:1147;s:20:\".wpex-load-more-wrap\";i:1148;s:34:\".wpex-load-more-wrap .theme-button\";i:1149;s:27:\".wpex-load-more-wrap .ticon\";i:1150;s:34:\".wpex-load-more-wrap .wpex-spinner\";i:1151;s:15:\".wpex-load-more\";i:1152;s:28:\".wpex-load-more.wpex-visible\";i:1153;s:49:\".wpex-load-more-wrap.wpex-loading .wpex-load-more\";i:1154;s:47:\".wpex-load-more-wrap.wpex-loading .wpex-spinner\";i:1155;s:23:\".page-slider-mobile-alt\";i:1156;s:5:\".meta\";i:1157;s:8:\".meta li\";i:1158;s:19:\".meta li:last-child\";i:1159;s:15:\".meta li .ticon\";i:1160;s:19:\".meta li .meta-icon\";i:1161;s:7:\".meta a\";i:1162;s:13:\".meta a:hover\";i:1163;s:10:\".meta time\";i:1164;s:11:\".author-bio\";i:1165;s:21:\".author-bio.no-avatar\";i:1166;s:18:\".author-bio-avatar\";i:1167;s:22:\".author-bio-avatar img\";i:1168;s:17:\".author-bio-title\";i:1169;s:36:\".author-bio-description p:last-child\";i:1170;s:18:\".author-bio-social\";i:1171;s:20:\".author-bio-social a\";i:1172;s:12:\"#post-series\";i:1173;s:15:\"#post-series ul\";i:1174;s:15:\"#post-series li\";i:1175;s:27:\"#post-series li:first-child\";i:1176;s:26:\"#post-series li:last-child\";i:1177;s:31:\"#post-series .post-series-count\";i:1178;s:33:\"#post-series .post-series-current\";i:1179;s:18:\"#post-series-title\";i:1180;s:20:\"#post-series-title a\";i:1181;s:30:\".blog-entry .wpex-social-share\";i:1182;s:21:\".wpex-social-share ul\";i:1183;s:21:\".wpex-social-share li\";i:1184;s:20:\".wpex-social-share a\";i:1185;s:26:\".wpex-social-share a:hover\";i:1186;s:30:\".wpex-social-share .wpex-label\";i:1187;s:45:\".wpex-social-share.disable-labels .wpex-label\";i:1188;s:68:\".single-portfolio.no-composer .social-share-wrap.position-horizontal\";i:1189;s:66:\"body.wpex-has-vertical-header .wpex-social-share.position-vertical\";i:1190;s:51:\".wpex-docready .wpex-social-share.position-vertical\";i:1191;s:48:\".wpex-social-share.position-vertical .wpex-label\";i:1192;s:38:\".wpex-social-share.position-horizontal\";i:1193;s:41:\".wpex-social-share.position-horizontal ul\";i:1194;s:41:\".wpex-social-share.position-horizontal li\";i:1195;s:43:\".wpex-social-share.position-horizontal li a\";i:1196;s:53:\".wpex-social-share.position-horizontal.disable-labels\";i:1197;s:58:\".wpex-social-share.position-horizontal.disable-labels li a\";i:1198;s:72:\".wpex-social-share.position-horizontal.disable-labels.style-rounded li a\";i:1199;s:37:\".wpex-social-share.style-minimal li a\";i:1200;s:43:\".wpex-social-share.style-minimal li a:hover\";i:1201;s:56:\".wpex-social-share.style-minimal li.wpex-twitter a:hover\";i:1202;s:57:\".wpex-social-share.style-minimal li.wpex-facebook a:hover\";i:1203;s:58:\".wpex-social-share.style-minimal li.wpex-pinterest a:hover\";i:1204;s:59:\".wpex-social-share.style-minimal li.wpex-googleplus a:hover\";i:1205;s:57:\".wpex-social-share.style-minimal li.wpex-linkedin a:hover\";i:1206;s:54:\".wpex-social-share.style-minimal li.wpex-email a:hover\";i:1207;s:50:\".wpex-social-share.style-minimal.position-vertical\";i:1208;s:52:\".wpex-social-share.style-minimal.position-vertical a\";i:1209;s:51:\".wpex-social-share.style-flat.position-horizontal a\";i:1210;s:34:\".wpex-social-share.style-flat li a\";i:1211;s:47:\".wpex-social-share.style-flat li.wpex-twitter a\";i:1212;s:53:\".wpex-social-share.style-flat li.wpex-twitter a:hover\";i:1213;s:45:\".wpex-social-share.style-flat li.wpex-email a\";i:1214;s:51:\".wpex-social-share.style-flat li.wpex-email a:hover\";i:1215;s:48:\".wpex-social-share.style-flat li.wpex-facebook a\";i:1216;s:54:\".wpex-social-share.style-flat li.wpex-facebook a:hover\";i:1217;s:49:\".wpex-social-share.style-flat li.wpex-pinterest a\";i:1218;s:55:\".wpex-social-share.style-flat li.wpex-pinterest a:hover\";i:1219;s:50:\".wpex-social-share.style-flat li.wpex-googleplus a\";i:1220;s:56:\".wpex-social-share.style-flat li.wpex-googleplus a:hover\";i:1221;s:48:\".wpex-social-share.style-flat li.wpex-linkedin a\";i:1222;s:54:\".wpex-social-share.style-flat li.wpex-linkedin a:hover\";i:1223;s:37:\".wpex-social-share.style-three-d li a\";i:1224;s:44:\".wpex-social-share.style-three-d li a:active\";i:1225;s:48:\".wpex-social-share.style-three-d li.wpex-email a\";i:1226;s:54:\".wpex-social-share.style-three-d li.wpex-email a:hover\";i:1227;s:50:\".wpex-social-share.style-three-d li.wpex-twitter a\";i:1228;s:56:\".wpex-social-share.style-three-d li.wpex-twitter a:hover\";i:1229;s:51:\".wpex-social-share.style-three-d li.wpex-facebook a\";i:1230;s:57:\".wpex-social-share.style-three-d li.wpex-facebook a:hover\";i:1231;s:52:\".wpex-social-share.style-three-d li.wpex-pinterest a\";i:1232;s:58:\".wpex-social-share.style-three-d li.wpex-pinterest a:hover\";i:1233;s:53:\".wpex-social-share.style-three-d li.wpex-googleplus a\";i:1234;s:59:\".wpex-social-share.style-three-d li.wpex-googleplus a:hover\";i:1235;s:51:\".wpex-social-share.style-three-d li.wpex-linkedin a\";i:1236;s:57:\".wpex-social-share.style-three-d li.wpex-linkedin a:hover\";i:1237;s:32:\".wpex-social-share.style-rounded\";i:1238;s:37:\".wpex-social-share.style-rounded li a\";i:1239;s:48:\".wpex-social-share.style-rounded li.wpex-email a\";i:1240;s:54:\".wpex-social-share.style-rounded li.wpex-email a:hover\";i:1241;s:50:\".wpex-social-share.style-rounded li.wpex-twitter a\";i:1242;s:56:\".wpex-social-share.style-rounded li.wpex-twitter a:hover\";i:1243;s:51:\".wpex-social-share.style-rounded li.wpex-facebook a\";i:1244;s:57:\".wpex-social-share.style-rounded li.wpex-facebook a:hover\";i:1245;s:52:\".wpex-social-share.style-rounded li.wpex-pinterest a\";i:1246;s:58:\".wpex-social-share.style-rounded li.wpex-pinterest a:hover\";i:1247;s:53:\".wpex-social-share.style-rounded li.wpex-googleplus a\";i:1248;s:59:\".wpex-social-share.style-rounded li.wpex-googleplus a:hover\";i:1249;s:51:\".wpex-social-share.style-rounded li.wpex-linkedin a\";i:1250;s:57:\".wpex-social-share.style-rounded li.wpex-linkedin a:hover\";i:1251;s:50:\".wpex-social-share.style-rounded.position-vertical\";i:1252;s:53:\".wpex-social-share.style-rounded.position-vertical li\";i:1253;s:55:\".wpex-social-share.style-rounded.position-vertical li a\";i:1254;s:9:\"#comments\";i:1255;s:25:\"#comments .comments-title\";i:1256;s:26:\"#comments ol, #comments ul\";i:1257;s:32:\"#comments .empty-closed-comments\";i:1258;s:18:\"#comments .comment\";i:1259;s:32:\"#comments .comment .comment-body\";i:1260;s:62:\"body.comment-avatars-disabled #comments .comment .comment-body\";i:1261;s:23:\"#comments .comment-body\";i:1262;s:36:\"#comments .comment-body p:last-child\";i:1263;s:33:\"#comments .comment-author .avatar\";i:1264;s:23:\"#comments .comment-meta\";i:1265;s:27:\"#comments .comment-meta .fn\";i:1266;s:32:\"#comments .comment-meta .fn .url\";i:1267;s:29:\"#comments .comment-meta .says\";i:1268;s:31:\"#comments .comment-meta a:hover\";i:1269;s:41:\"#comments .comment-meta .comment-metadata\";i:1270;s:43:\"#comments .comment-meta .comment-metadata a\";i:1271;s:42:\"#comments .comment-meta .comment-edit-link\";i:1272;s:48:\"#comments .comment-meta .comment-edit-link:hover\";i:1273;s:30:\"#comments .comment-body .reply\";i:1274;s:32:\"#comments .comment-body .reply a\";i:1275;s:38:\"#comments .comment-body .reply a:hover\";i:1276;s:30:\"#comments .comment-reply-title\";i:1277;s:23:\"#comments .logged-in-as\";i:1278;s:25:\"#comments .logged-in-as a\";i:1279;s:36:\"#comments #cancel-comment-reply-link\";i:1280;s:25:\"#comments p.comment-notes\";i:1281;s:156:\"#comments .comment-form-author, #comments .comment-form-email, #comments .comment-form-website, #comments .comment-form-comment, #comments .comment-form-url\";i:1282;s:186:\"#comments .comment-form-author input, #comments .comment-form-email input, #comments .comment-form-website input, #comments .comment-form-comment input, #comments .comment-form-url input\";i:1283;s:30:\"#comments .comment-form-author\";i:1284;s:29:\"#comments .comment-form-email\";i:1285;s:60:\"#comments .comment-form-url, #comments .comment-form-website\";i:1286;s:28:\"#comments #commentform label\";i:1287;s:45:\"#comments .comment-form-cookies-consent label\";i:1288;s:28:\"#comments .form-allowed-tags\";i:1289;s:23:\"#comments span.required\";i:1290;s:38:\"#comments .comment-awaiting-moderation\";i:1291;s:22:\"#comments .no-comments\";i:1292;s:93:\"#comments .comment-navigation a.page-numbers, #comments .comment-navigation span.page-numbers\";i:1293;s:39:\"#comments .comment-navigation .nav-next\";i:1294;s:22:\".navigation .nav-links\";i:1295;s:29:\".navigation .nav-links::after\";i:1296;s:70:\".navigation .nav-links .nav-previous, .navigation .nav-links .nav-next\";i:1297;s:36:\".navigation .nav-links .nav-previous\";i:1298;s:32:\".navigation .nav-links .nav-next\";i:1299;s:24:\".navigation .nav-links a\";i:1300;s:30:\".navigation .nav-links a:hover\";i:1301;s:67:\"body.comment-author-highlight .bypostauthor .comment-author .avatar\";i:1302;s:26:\".comment-subscription-form\";i:1303;s:32:\".comment-subscription-form:after\";i:1304;s:66:\".comment-subscription-form input, .comment-subscription-form label\";i:1305;s:18:\".wpex-site-overlay\";i:1306;s:30:\".wpex-site-overlay.wpex-active\";i:1307;s:19:\".wpex-shape-divider\";i:1308;s:27:\".vc_row .wpex-shape-divider\";i:1309;s:42:\".wpex-vc-row-stretched .wpex-shape-divider\";i:1310;s:23:\".wpex-shape-divider svg\";i:1311;s:44:\".wpex-shape-divider .wpex-shape-divider-path\";i:1312;s:30:\".wpex-shape-divider.skrollable\";i:1313;s:23:\".wpex-shape-divider-top\";i:1314;s:26:\".wpex-shape-divider-bottom\";i:1315;s:26:\".wpex-shape-divider-rotate\";i:1316;s:28:\".wpex-shape-divider-flip svg\";i:1317;s:22:\"#site-scroll-top:hover\";i:1318;s:21:\"#site-scroll-top.show\";i:1319;s:16:\"#toggle-bar-wrap\";i:1320;s:34:\"#toggle-bar-wrap.toggle-bar-inline\";i:1321;s:45:\"#toggle-bar-wrap.toggle-bar-inline.active-bar\";i:1322;s:35:\"#toggle-bar-wrap.toggle-bar-overlay\";i:1323;s:46:\"#toggle-bar-wrap.toggle-bar-overlay.active-bar\";i:1324;s:50:\"body.admin-bar #toggle-bar-wrap.toggle-bar-overlay\";i:1325;s:38:\"#toggle-bar-wrap.toggle-bar-fade-slide\";i:1326;s:49:\"#toggle-bar-wrap.toggle-bar-fade-slide.active-bar\";i:1327;s:15:\".toggle-bar-btn\";i:1328;s:26:\".toggle-bar-btn span.ticon\";i:1329;s:36:\".togglebar-is-inline .toggle-bar-btn\";i:1330;s:30:\"body.admin-bar .toggle-bar-btn\";i:1331;s:13:\"#top-bar-wrap\";i:1332;s:41:\".textcenter #top-bar, #top-bar.textcenter\";i:1333;s:10:\"#top-bar a\";i:1334;s:20:\"#top-bar .searchform\";i:1335;s:26:\"#top-bar .searchform input\";i:1336;s:15:\"#top-bar select\";i:1337;s:13:\".top-bar-left\";i:1338;s:17:\".top-bar-centered\";i:1339;s:20:\".wpex-top-bar-sticky\";i:1340;s:59:\"#top-bar-wrap-sticky-wrapper.is-sticky .wpex-top-bar-sticky\";i:1341;s:23:\"#top-bar-content strong\";i:1342;s:40:\"#top-bar-content span.wpex-inline .ticon\";i:1343;s:24:\"#top-bar #lang_sel ul ul\";i:1344;s:34:\"#top-bar .lang_sel_list_horizontal\";i:1345;s:82:\"#top-bar .lang_sel_list_horizontal a, #top-bar .lang_sel_list_horizontal a:visited\";i:1346;s:37:\"#top-bar .lang_sel_list_horizontal li\";i:1347;s:13:\".top-bar-menu\";i:1348;s:26:\".has-content .top-bar-menu\";i:1349;s:27:\".top-bar-menu li:last-child\";i:1350;s:23:\".top-bar-menu li .ticon\";i:1351;s:19:\".top-bar-menu li li\";i:1352;s:99:\"#top-bar-content.top-bar-centered .top-bar-menu, #top-bar-content.top-bar-centered .top-bar-menu li\";i:1353;s:18:\"#top-bar-social ul\";i:1354;s:30:\".textcenter #top-bar-social li\";i:1355;s:17:\"#top-bar-social a\";i:1356;s:33:\"#top-bar-social a.wpex-social-btn\";i:1357;s:58:\"#top-bar-social a.wpex-social-btn.wpex-social-btn-bordered\";i:1358;s:42:\"#top-bar-social a.wpex-social-btn-no-style\";i:1359;s:48:\"#top-bar-social a.wpex-social-btn-no-style:hover\";i:1360;s:28:\"#top-bar-social a:last-child\";i:1361;s:32:\"#top-bar-social.top-bar-centered\";i:1362;s:34:\"#top-bar-social.top-bar-centered a\";i:1363;s:44:\"#top-bar-social.social-style-colored-icons a\";i:1364;s:50:\"#top-bar-social.social-style-colored-icons a:hover\";i:1365;s:46:\"#top-bar-social.social-style-colored-icons img\";i:1366;s:43:\".top-bar-right .polylang-switcher-shortcode\";i:1367;s:42:\".top-bar-left .polylang-switcher-shortcode\";i:1368;s:12:\"#site-header\";i:1369;s:68:\"#site-header.wpex-header-two-flex-v #site-header-inner #header-aside\";i:1370;s:18:\"#site-header-inner\";i:1371;s:26:\"#site-navigation.container\";i:1372;s:27:\"#site-header.header-builder\";i:1373;s:46:\"#site-header.header-builder #site-header-inner\";i:1374;s:12:\"#site-logo a\";i:1375;s:27:\"#site-logo a.site-logo-text\";i:1376;s:18:\"#site-logo a:hover\";i:1377;s:14:\"#site-logo img\";i:1378;s:16:\"#site-logo-inner\";i:1379;s:18:\"#site-logo-fa-icon\";i:1380;s:36:\"#site-logo-fa-icon.ticon-wpex-hidden\";i:1381;s:21:\"#site-navigation-wrap\";i:1382;s:18:\"#site-navigation a\";i:1383;s:65:\"#site-navigation .menu-button.menu-button-rounded span.link-inner\";i:1384;s:36:\"#site-navigation>ul>li>a:not([href])\";i:1385;s:35:\"#site-navigation .link-inner .ticon\";i:1386;s:53:\"#site-navigation li.no-icon-margin .link-inner .ticon\";i:1387;s:110:\"#site-navigation .link-inner .ticon.wpex-menu-search-icon, #site-navigation .link-inner .ticon.wcmenucart-icon\";i:1388;s:18:\".wpex-mm-menu-item\";i:1389;s:63:\"#site-navigation-sticky-wrapper.is-sticky #site-navigation-wrap\";i:1390;s:47:\"#site-navigation .dropdown-menu li a .nav-arrow\";i:1391;s:81:\"#site-navigation .dropdown-menu ul.sub-menu li.menu-item.menu-item-has-children a\";i:1392;s:45:\"#site-navigation .sf-menu>li ul li .nav-arrow\";i:1393;s:43:\"#site-navigation .dropdown-menu ul.sub-menu\";i:1394;s:46:\"#site-navigation .dropdown-menu ul.sub-menu ul\";i:1395;s:71:\"#site-navigation .dropdown-menu ul.sub-menu li.menu-item:first-child ul\";i:1396;s:56:\"#site-navigation .dropdown-menu ul.sub-menu li.menu-item\";i:1397;s:58:\"#site-navigation .dropdown-menu ul.sub-menu li.menu-item a\";i:1398;s:59:\"#site-navigation .dropdown-menu ul.sub-menu li:last-child>a\";i:1399;s:64:\"#site-navigation .dropdown-menu ul.sub-menu li.menu-item a:hover\";i:1400;s:55:\"#site-navigation .dropdown-menu li.left-dropdowns ul ul\";i:1401;s:64:\"body #site-navigation .sf-menu li.left-dropdowns ul a.sf-with-ul\";i:1402;s:71:\"#site-navigation .dropdown-menu li.left-dropdowns ul .ticon-angle-right\";i:1403;s:78:\"#site-navigation .dropdown-menu li.left-dropdowns ul .ticon-angle-right:before\";i:1404;s:62:\"#site-navigation .dropdown-menu>li.menu-item>a>span.link-inner\";i:1405;s:58:\"#site-navigation .dropdown-menu ul.sub-menu li.menu-item>a\";i:1406;s:24:\"#site-logo a.sticky-logo\";i:1407;s:25:\"#site-header.fixed-scroll\";i:1408;s:30:\"#site-header.transform-prepare\";i:1409;s:46:\"#site-header.transform-prepare .overlay-header\";i:1410;s:43:\"#site-header.transform-prepare.transform-go\";i:1411;s:50:\"#site-header-sticky-wrapper.is-sticky #site-header\";i:1412;s:56:\"#site-header-sticky-wrapper.is-sticky #site-header-inner\";i:1413;s:33:\"#site-header.shrink-sticky-header\";i:1414;s:65:\"#site-header.shrink-sticky-header.sticky-header-shrunk #site-logo\";i:1415;s:40:\".sticky-header-shrunk #site-header-inner\";i:1416;s:81:\".shrink-sticky-header.sticky-header-shrunk .navbar-style-five .dropdown-menu>li>a\";i:1417;s:57:\".shrink-sticky-header.sticky-header-shrunk #site-logo img\";i:1418;s:358:\".anim-shrink-header #site-header-sticky-wrapper, .anim-shrink-header #site-header, .anim-shrink-header #site-header-inner, .anim-shrink-header .navbar-style-five, .anim-shrink-header .navbar-style-five #site-navigation, .anim-shrink-header #site-logo, .anim-shrink-header #site-logo-inner, .anim-shrink-header #site-logo a, .anim-shrink-header #site-logo img\";i:1419;s:34:\".anim-shrink-header #site-logo img\";i:1420;s:41:\".anim-shrink-header #site-navigation-wrap\";i:1421;s:22:\".header-one #site-logo\";i:1422;s:17:\".navbar-style-one\";i:1423;s:47:\"body.navbar-has-inner-span-bg .navbar-style-one\";i:1424;s:94:\"body:not(.navbar-has-inner-span-bg) .navbar-style-one .dropdown-menu>li:last-child.menu-button\";i:1425;s:47:\".navbar-style-one .dropdown-menu>li.menu-item>a\";i:1426;s:63:\".navbar-style-one .dropdown-menu>li.menu-item>a>span.link-inner\";i:1427;s:11:\".header-two\";i:1428;s:16:\".header-two-logo\";i:1429;s:39:\"#header-two-search input[type=\"search\"]\";i:1430;s:44:\"#header-two-search #header-two-search-submit\";i:1431;s:67:\"#header-two-search .woocommerce-product-search input[type=\"submit\"]\";i:1432;s:17:\".navbar-style-two\";i:1433;s:43:\"body.page-header-disabled .navbar-style-two\";i:1434;s:32:\".navbar-style-two .dropdown-menu\";i:1435;s:34:\".navbar-style-two .dropdown-menu a\";i:1436;s:35:\".navbar-style-two .dropdown-menu li\";i:1437;s:38:\".navbar-style-two .dropdown-menu li li\";i:1438;s:37:\".navbar-style-two .dropdown-menu>li>a\";i:1439;s:99:\".navbar-style-two .dropdown-menu .search-toggle-li, .navbar-style-two .dropdown-menu .woo-menu-icon\";i:1440;s:30:\".navbar-style-two.center-items\";i:1441;s:48:\".navbar-style-two.center-items .dropdown-menu>ul\";i:1442;s:60:\".navbar-style-two.center-items .dropdown-menu>li:first-child\";i:1443;s:175:\".navbar-style-two.center-items .dropdown-menu>li, .navbar-style-two.center-items .dropdown-menu .woo-menu-icon, .navbar-style-two.center-items .dropdown-menu .search-toggle-li\";i:1444;s:91:\".navbar-style-two.no-borders .dropdown-menu, .navbar-style-two.no-borders .dropdown-menu li\";i:1445;s:34:\".navbar-style-two.no-borders li ul\";i:1446;s:18:\".header-three-logo\";i:1447;s:20:\".header-three-logo a\";i:1448;s:19:\".header-three-aside\";i:1449;s:19:\".navbar-style-three\";i:1450;s:45:\"body.page-header-disabled .navbar-style-three\";i:1451;s:43:\"body.has-overlay-header .navbar-style-three\";i:1452;s:34:\".navbar-style-three .dropdown-menu\";i:1453;s:46:\".navbar-style-three .dropdown-menu ul.sub-menu\";i:1454;s:47:\".navbar-style-three .dropdown-menu>li.menu-item\";i:1455;s:49:\".navbar-style-three .dropdown-menu>li.menu-item>a\";i:1456;s:65:\".navbar-style-three .dropdown-menu>li.menu-item>a>span.link-inner\";i:1457;s:17:\".header-four-logo\";i:1458;s:19:\".header-four-logo a\";i:1459;s:18:\".header-four-aside\";i:1460;s:78:\"#site-header.overlay-header.dyn-styles #site-navigation-wrap.navbar-style-four\";i:1461;s:18:\".navbar-style-four\";i:1462;s:33:\".navbar-style-four .dropdown-menu\";i:1463;s:45:\".navbar-style-four .dropdown-menu ul.sub-menu\";i:1464;s:46:\".navbar-style-four .dropdown-menu>li.menu-item\";i:1465;s:48:\".navbar-style-four .dropdown-menu>li.menu-item>a\";i:1466;s:64:\".navbar-style-four .dropdown-menu>li.menu-item>a>span.link-inner\";i:1467;s:27:\"#site-logo.header-five-logo\";i:1468;s:35:\"#site-logo.header-five-logo.display\";i:1469;s:15:\".menu-item-logo\";i:1470;s:76:\"#site-navigation-wrap.navbar-style-five, .navbar-style-five #site-navigation\";i:1471;s:33:\".navbar-style-five .dropdown-menu\";i:1472;s:45:\".navbar-style-five .dropdown-menu ul.sub-menu\";i:1473;s:46:\".navbar-style-five .dropdown-menu>li.menu-item\";i:1474;s:48:\".navbar-style-five .dropdown-menu>li.menu-item>a\";i:1475;s:64:\".navbar-style-five .dropdown-menu>li.menu-item>a>span.link-inner\";i:1476;s:34:\".navbar-style-six #site-navigation\";i:1477;s:45:\".navbar-style-six .dropdown-menu>li.menu-item\";i:1478;s:47:\".navbar-style-six .dropdown-menu>li.menu-item>a\";i:1479;s:63:\".navbar-style-six .dropdown-menu>li.menu-item>a span.link-inner\";i:1480;s:70:\".navbar-style-six .dropdown-menu>li.menu-item.menu-item-has-children>a\";i:1481;s:47:\".navbar-style-six .dropdown-menu>li.menu-item a\";i:1482;s:53:\".navbar-style-six .dropdown-menu>li.menu-item a:hover\";i:1483;s:134:\".navbar-style-six .dropdown-menu>li.menu-item.current-menu-item>a, .navbar-style-six .dropdown-menu>li.menu-item.current-menu-parent>a\";i:1484;s:53:\".navbar-style-six .dropdown-menu .nav-arrow.top-level\";i:1485;s:40:\".navbar-style-six .wpex-menu-search-text\";i:1486;s:44:\".navbar-style-six.rtl .wpex-menu-search-text\";i:1487;s:39:\".navbar-style-six .sf-menu li.menu-item\";i:1488;s:58:\"body.wpex-has-vertical-header #site-navigation .sf-menu ul\";i:1489;s:60:\"body.wpex-has-vertical-header #site-navigation .sf-menu ul a\";i:1490;s:73:\"body.wpex-has-vertical-header #site-navigation .dropdown-menu li.megamenu\";i:1491;s:76:\"body.wpex-has-vertical-header #site-navigation .dropdown-menu li.megamenu>ul\";i:1492;s:80:\"body.wpex-has-vertical-header.rtl #site-navigation .dropdown-menu li.megamenu>ul\";i:1493;s:14:\"#mobile-menu a\";i:1494;s:26:\"#mobile-menu a:first-child\";i:1495;s:20:\"#mobile-menu a:hover\";i:1496;s:23:\"#mobile-menu .wpex-shop\";i:1497;s:29:\"#mobile-menu .wpex-cart-count\";i:1498;s:44:\"#mobile-menu .wpex-cart-count.wpex-has-items\";i:1499;s:54:\"body.wpex-mobile-toggle-menu-icon_buttons #mobile-menu\";i:1500;s:48:\".wpex-mobile-toggle-menu-icon_buttons_under_logo\";i:1501;s:61:\".wpex-mobile-toggle-menu-icon_buttons_under_logo #mobile-menu\";i:1502;s:27:\"#wpex-mobile-menu-fixed-top\";i:1503;s:38:\"#wpex-mobile-menu-fixed-top .container\";i:1504;s:39:\"#wpex-mobile-menu-fixed-top .wpex-inner\";i:1505;s:41:\"#wpex-mobile-menu-fixed-top .wpex-inner a\";i:1506;s:42:\"body.admin-bar #wpex-mobile-menu-fixed-top\";i:1507;s:47:\"#wpex-mobile-menu-fixed-top .mobile-menu-toggle\";i:1508;s:54:\"#wpex-mobile-menu-fixed-top .mobile-menu-toggle .ticon\";i:1509;s:39:\"#wpex-mobile-menu-fixed-top .wpex-aside\";i:1510;s:41:\"#wpex-mobile-menu-fixed-top .wpex-aside a\";i:1511;s:44:\"#wpex-mobile-menu-fixed-top .wpex-cart-count\";i:1512;s:24:\"#wpex-mobile-menu-navbar\";i:1513;s:44:\"#wpex-mobile-menu-navbar .mobile-menu-toggle\";i:1514;s:50:\"#wpex-mobile-menu-navbar .mobile-menu-toggle:hover\";i:1515;s:51:\"#wpex-mobile-menu-navbar .mobile-menu-toggle .ticon\";i:1516;s:10:\"#sidr-main\";i:1517;s:16:\"#sidr-main.right\";i:1518;s:15:\"#sidr-main.left\";i:1519;s:13:\"#sidr-main ul\";i:1520;s:22:\".sidr-class-wpex-close\";i:1521;s:24:\".sidr-class-wpex-close a\";i:1522;s:30:\".sidr-class-wpex-close a:hover\";i:1523;s:7:\".sidr a\";i:1524;s:13:\".sidr a:hover\";i:1525;s:11:\"#sidr-close\";i:1526;s:40:\".sidr-class-dropdown-menu>li:first-child\";i:1527;s:28:\".sidr-class-dropdown-menu li\";i:1528;s:30:\".sidr-class-dropdown-menu li a\";i:1529;s:52:\".sidr-class-dropdown-menu li a.sidr-class-sf-with-ul\";i:1530;s:64:\".sidr-class-dropdown-menu li.sidr-class-menu-item-has-children>a\";i:1531;s:28:\".sidr-class-dropdown-menu ul\";i:1532;s:42:\".sidr-class-dropdown-menu ul li:last-child\";i:1533;s:31:\".sidr-class-dropdown-menu ul ul\";i:1534;s:30:\".sidr-class-dropdown-menu ul a\";i:1535;s:37:\".sidr-class-dropdown-menu ul a:before\";i:1536;s:40:\".sidr-class-dropdown-menu ul ul a:before\";i:1537;s:43:\".sidr-class-dropdown-menu ul ul ul a:before\";i:1538;s:65:\".sidr-class-dropdown-menu li.active>a>.sidr-class-dropdown-toggle\";i:1539;s:34:\".sidr-class-dropdown-menu a .ticon\";i:1540;s:43:\"body.rtl .sidr-class-dropdown-menu a .ticon\";i:1541;s:34:\".sidr-class-menu-item-has-children\";i:1542;s:27:\".sidr-class-dropdown-toggle\";i:1543;s:34:\".sidr-class-dropdown-toggle:before\";i:1544;s:162:\".sidr #searchform-header-replace-close, .sidr .nav-arrow, .sidr-class-wcmenucart, .sidr-class-nav-arrow, .sidr-class-wpex-menu-extra, #sidr-id-searchform-dropdown\";i:1545;s:18:\".wpex-sidr-overlay\";i:1546;s:37:\".wpex-sidr-overlay.wpex-custom-cursor\";i:1547;s:33:\"#sidr-id-searchform-overlay-title\";i:1548;s:34:\".sidr-class-mobile-menu-searchform\";i:1549;s:40:\".sidr-class-mobile-menu-searchform input\";i:1550;s:41:\".sidr-class-mobile-menu-searchform button\";i:1551;s:53:\".sidr-class-mobile-menu-searchform input[placeholder]\";i:1552;s:62:\".sidr-class-mobile-menu-searchform ::-webkit-input-placeholder\";i:1553;s:53:\".sidr-class-mobile-menu-searchform ::-moz-placeholder\";i:1554;s:57:\".sidr-class-mobile-menu-searchform :-ms-input-placeholder\";i:1555;s:52:\".sidr-class-mobile-menu-searchform :-moz-placeholder\";i:1556;s:18:\".mobile-toggle-nav\";i:1557;s:40:\".mobile-toggle-nav.wpex-togglep-absolute\";i:1558;s:20:\".mobile-toggle-nav a\";i:1559;s:26:\".mobile-toggle-nav a:hover\";i:1560;s:27:\".mobile-toggle-nav a .ticon\";i:1561;s:21:\".mobile-toggle-nav ul\";i:1562;s:29:\".mobile-toggle-nav .nav-arrow\";i:1563;s:44:\".mobile-toggle-nav .menu-item-has-children>a\";i:1564;s:45:\".mobile-toggle-nav .menu-item-has-children ul\";i:1565;s:47:\".mobile-toggle-nav .menu-item-has-children ul a\";i:1566;s:54:\".mobile-toggle-nav .menu-item-has-children ul a:before\";i:1567;s:50:\".mobile-toggle-nav .menu-item-has-children ul ul a\";i:1568;s:57:\".mobile-toggle-nav .menu-item-has-children ul ul a:before\";i:1569;s:53:\".mobile-toggle-nav .menu-item-has-children ul ul ul a\";i:1570;s:60:\".mobile-toggle-nav .menu-item-has-children ul ul ul a:before\";i:1571;s:56:\".mobile-toggle-nav .menu-item-has-children ul ul ul ul a\";i:1572;s:37:\".mobile-toggle-nav .wpex-open-submenu\";i:1573;s:45:\".mobile-toggle-nav .wpex-open-submenu::before\";i:1574;s:47:\".mobile-toggle-nav .active>a>.wpex-open-submenu\";i:1575;s:53:\".wpex-mobile-toggle-menu-fixed_top .mobile-toggle-nav\";i:1576;s:55:\".wpex-mobile-toggle-menu-fixed_top .mobile-toggle-nav a\";i:1577;s:61:\".wpex-mobile-toggle-menu-fixed_top .mobile-toggle-nav a:hover\";i:1578;s:38:\".mobile-toggle-nav #mobile-menu-search\";i:1579;s:46:\".mobile-toggle-nav-search input[type=\"search\"]\";i:1580;s:44:\".mobile-toggle-nav-search .searchform-submit\";i:1581;s:35:\".mobile-toggle-nav .wpex-menu-extra\";i:1582;s:37:\".mobile-toggle-nav .wpex-mm-menu-item\";i:1583;s:24:\".full-screen-overlay-nav\";i:1584;s:32:\".full-screen-overlay-nav.visible\";i:1585;s:61:\".full-screen-overlay-nav button.full-screen-overlay-nav-close\";i:1586;s:67:\".full-screen-overlay-nav button.full-screen-overlay-nav-close:hover\";i:1587;s:79:\".full-screen-overlay-nav button.full-screen-overlay-nav-close::-moz-focus-inner\";i:1588;s:30:\".full-screen-overlay-nav.white\";i:1589;s:47:\".full-screen-overlay-nav.white li.wpex-active>a\";i:1590;s:71:\".full-screen-overlay-nav.white #mobile-menu-search input[type=\"search\"]\";i:1591;s:30:\".full-screen-overlay-nav.black\";i:1592;s:35:\".full-screen-overlay-nav.black li a\";i:1593;s:90:\".full-screen-overlay-nav.black li a:hover, .full-screen-overlay-nav.black li.wpex-active>a\";i:1594;s:71:\".full-screen-overlay-nav.black #mobile-menu-search input[type=\"search\"]\";i:1595;s:35:\".full-screen-overlay-nav-ul-wrapper\";i:1596;s:55:\".full-screen-overlay-nav-ul-wrapper #mobile-menu-search\";i:1597;s:76:\".full-screen-overlay-nav-ul-wrapper #mobile-menu-search input[type=\"search\"]\";i:1598;s:140:\".full-screen-overlay-nav-ul-wrapper #mobile-menu-search button, .full-screen-overlay-nav-ul-wrapper #mobile-menu-search input[type=\"submit\"]\";i:1599;s:27:\".full-screen-overlay-nav-ul\";i:1600;s:30:\".full-screen-overlay-nav-ul ul\";i:1601;s:30:\".full-screen-overlay-nav-ul li\";i:1602;s:32:\".full-screen-overlay-nav-ul li a\";i:1603;s:39:\".full-screen-overlay-nav-ul li a .ticon\";i:1604;s:38:\".full-screen-overlay-nav-ul li a:hover\";i:1605;s:46:\".full-screen-overlay-nav-ul li.wpex-menu-extra\";i:1606;s:49:\".full-screen-overlay-nav-ul li .wpex-mm-menu-item\";i:1607;s:41:\".full-screen-overlay-nav-ul li .nav-arrow\";i:1608;s:43:\".full-screen-overlay-nav-ul span.link-inner\";i:1609;s:50:\".full-screen-overlay-nav-ul span.link-inner::after\";i:1610;s:67:\".full-screen-overlay-nav-ul li.wpex-active>a>span.link-inner::after\";i:1611;s:74:\".black .full-screen-overlay-nav-ul li.wpex-active>a>span.link-inner::after\";i:1612;s:39:\".full-screen-overlay-nav-ul ul.sub-menu\";i:1613;s:56:\".wpex-dropdowns-caret .dropdown-menu ul.sub-menu::before\";i:1614;s:55:\".wpex-dropdowns-caret .dropdown-menu ul.sub-menu::after\";i:1615;s:119:\".wpex-dropdowns-caret .dropdown-menu ul.sub-menu ul::before, .wpex-dropdowns-caret .dropdown-menu ul.sub-menu ul::after\";i:1616;s:147:\".wpex-dropdowns-shadow-one ul ul.sub-menu, .wpex-dropdowns-shadow-one #searchform-dropdown, .wpex-dropdowns-shadow-one #current-shop-items-dropdown\";i:1617;s:147:\".wpex-dropdowns-shadow-two ul ul.sub-menu, .wpex-dropdowns-shadow-two #searchform-dropdown, .wpex-dropdowns-shadow-two #current-shop-items-dropdown\";i:1618;s:153:\".wpex-dropdowns-shadow-three ul ul.sub-menu, .wpex-dropdowns-shadow-three #searchform-dropdown, .wpex-dropdowns-shadow-three #current-shop-items-dropdown\";i:1619;s:150:\".wpex-dropdowns-shadow-four ul ul.sub-menu, .wpex-dropdowns-shadow-four #searchform-dropdown, .wpex-dropdowns-shadow-four #current-shop-items-dropdown\";i:1620;s:150:\".wpex-dropdowns-shadow-five ul ul.sub-menu, .wpex-dropdowns-shadow-five #searchform-dropdown, .wpex-dropdowns-shadow-five #current-shop-items-dropdown\";i:1621;s:82:\".wpex-dropdown-top-border #site-navigation .dropdown-menu li.menu-item ul.sub-menu\";i:1622;s:121:\".wpex-dropdown-top-border .dropdown-menu ul.sub-menu::before, .wpex-dropdown-top-border .dropdown-menu ul.sub-menu::after\";i:1623;s:113:\".wpex-flush-dropdowns .dropdown-menu ul.sub-menu::before, .wpex-flush-dropdowns .dropdown-menu ul.sub-menu::after\";i:1624;s:72:\".wpex-dropdown-style-minimal #site-navigation .dropdown-menu ul.sub-menu\";i:1625;s:161:\".wpex-dropdown-style-minimal #site-navigation .dropdown-menu ul.sub-menu::after, .wpex-dropdown-style-minimal #site-navigation .dropdown-menu ul.sub-menu::before\";i:1626;s:87:\".wpex-dropdown-style-minimal #site-navigation .dropdown-menu ul.sub-menu li.menu-item a\";i:1627;s:93:\".wpex-dropdown-style-minimal #site-navigation .dropdown-menu ul.sub-menu li.menu-item a:hover\";i:1628;s:277:\".wpex-dropdown-style-minimal .navbar-style-two #site-navigation .dropdown-menu ul.sub-menu, .wpex-dropdown-style-minimal .navbar-style-three #site-navigation .dropdown-menu ul.sub-menu, .wpex-dropdown-style-minimal .navbar-style-four #site-navigation .dropdown-menu ul.sub-menu\";i:1629;s:75:\".wpex-dropdown-style-minimal-sq #site-navigation .dropdown-menu ul.sub-menu\";i:1630;s:167:\".wpex-dropdown-style-minimal-sq #site-navigation .dropdown-menu ul.sub-menu::after, .wpex-dropdown-style-minimal-sq #site-navigation .dropdown-menu ul.sub-menu::before\";i:1631;s:90:\".wpex-dropdown-style-minimal-sq #site-navigation .dropdown-menu ul.sub-menu li.menu-item a\";i:1632;s:70:\".wpex-dropdown-style-black #site-navigation .dropdown-menu ul.sub-menu\";i:1633;s:157:\".wpex-dropdown-style-black #site-navigation .dropdown-menu ul.sub-menu::before, .wpex-dropdown-style-black #site-navigation .dropdown-menu ul.sub-menu::after\";i:1634;s:85:\".wpex-dropdown-style-black #site-navigation .dropdown-menu ul.sub-menu li.menu-item a\";i:1635;s:91:\".wpex-dropdown-style-black #site-navigation .dropdown-menu ul.sub-menu li.menu-item a:hover\";i:1636;s:80:\".wpex-dropdown-style-black #site-navigation li.megamenu>ul.sub-menu>li.menu-item\";i:1637;s:117:\".wpex-dropdown-style-black #site-navigation li.megamenu>ul.sub-menu>li.menu-item.menu-item-has-children>a .link-inner\";i:1638;s:47:\".wpex-dropdown-style-black #searchform-dropdown\";i:1639;s:68:\".wpex-dropdown-style-black #searchform-dropdown input[type=\"search\"]\";i:1640;s:28:\"#site-navigation li.megamenu\";i:1641;s:40:\"#site-navigation li.megamenu>ul.sub-menu\";i:1642;s:95:\"#site-navigation li.megamenu>ul.sub-menu:after, #site-navigation li.megamenu>ul.sub-menu:before\";i:1643;s:51:\"#site-navigation li.megamenu>ul.sub-menu .nav-arrow\";i:1644;s:53:\"#site-navigation li.megamenu>ul.sub-menu>li.menu-item\";i:1645;s:65:\"#site-navigation li.megamenu>ul.sub-menu>li.menu-item:first-child\";i:1646;s:55:\"#site-navigation li.megamenu>ul.sub-menu>li.menu-item a\";i:1647;s:76:\"#site-navigation li.megamenu>ul.sub-menu>li.menu-item.menu-item-has-children\";i:1648;s:78:\"#site-navigation li.megamenu>ul.sub-menu>li.menu-item.menu-item-has-children>a\";i:1649;s:84:\"#site-navigation li.megamenu>ul.sub-menu>li.menu-item.menu-item-has-children>a:hover\";i:1650;s:90:\"#site-navigation li.megamenu>ul.sub-menu>li.menu-item.menu-item-has-children>a .link-inner\";i:1651;s:56:\"#site-navigation li.megamenu>ul.sub-menu>li.menu-item ul\";i:1652;s:89:\"#site-navigation li.megamenu>ul.sub-menu>li.menu-item ul.sub-menu>li>ul.sub-menu a:before\";i:1653;s:49:\"#site-navigation li.megamenu.col-1>ul.sub-menu>li\";i:1654;s:49:\"#site-navigation li.megamenu.col-2>ul.sub-menu>li\";i:1655;s:65:\"#site-navigation li.megamenu.col-2>ul.sub-menu>li:nth-child(2n+1)\";i:1656;s:49:\"#site-navigation li.megamenu.col-3>ul.sub-menu>li\";i:1657;s:65:\"#site-navigation li.megamenu.col-3>ul.sub-menu>li:nth-child(3n+1)\";i:1658;s:49:\"#site-navigation li.megamenu.col-4>ul.sub-menu>li\";i:1659;s:65:\"#site-navigation li.megamenu.col-4>ul.sub-menu>li:nth-child(4n+1)\";i:1660;s:49:\"#site-navigation li.megamenu.col-5>ul.sub-menu>li\";i:1661;s:65:\"#site-navigation li.megamenu.col-5>ul.sub-menu>li:nth-child(5n+1)\";i:1662;s:49:\"#site-navigation li.megamenu.col-6>ul.sub-menu>li\";i:1663;s:65:\"#site-navigation li.megamenu.col-6>ul.sub-menu>li:nth-child(6n+1)\";i:1664;s:80:\"#site-navigation li.megamenu.hide-headings>ul.sub-menu>.menu-item-has-children>a\";i:1665;s:55:\"#site-navigation li.megamenu.display-always>ul.sub-menu\";i:1666;s:20:\"#overlay-header-wrap\";i:1667;s:27:\"#site-header.overlay-header\";i:1668;s:38:\"#site-header.overlay-header.dyn-styles\";i:1669;s:60:\"#site-header.overlay-header.dyn-styles #site-navigation-wrap\";i:1670;s:46:\"#site-header.overlay-header #site-header-inner\";i:1671;s:44:\"#site-header.overlay-header li.menu-button>a\";i:1672;s:56:\"#site-header.overlay-header .has-overlay-logo .main-logo\";i:1673;s:58:\"body.has-overlay-header.page-header-disabled #content-wrap\";i:1674;s:26:\".overlay-header-offset-div\";i:1675;s:48:\".add-overlay-header-offset .wpex-vc-columns-wrap\";i:1676;s:68:\".wpex-window-loaded .add-overlay-header-offset .wpex-vc-columns-wrap\";i:1677;s:47:\"body.boxed-main-layout.has-overlay-header #wrap\";i:1678;s:69:\"body.boxed-main-layout.has-overlay-header #site-header.overlay-header\";i:1679;s:50:\"body.has-overlay-header .wpex-sticky-header-holder\";i:1680;s:64:\".wpex-sticky-header-holder.is-sticky #site-header.overlay-header\";i:1681;s:39:\"#site-header.overlay-header.light-style\";i:1682;s:201:\"#site-header.overlay-header.light-style #site-logo a.site-logo-text, #site-header.overlay-header.light-style #site-navigation .dropdown-menu>li>a, #site-header.overlay-header.light-style #mobile-menu a\";i:1683;s:76:\"#site-header.overlay-header.light-style #site-navigation .dropdown-menu>li>a\";i:1684;s:82:\"#site-header.overlay-header.light-style #site-navigation .dropdown-menu>li>a:hover\";i:1685;s:223:\"#site-header.overlay-header.light-style #mobile-menu .wpex-bars>span, #site-header.overlay-header.light-style #mobile-menu .wpex-bars>span::before, #site-header.overlay-header.light-style #mobile-menu .wpex-bars>span::after\";i:1686;s:77:\"#site-header-sticky-wrapper.is-sticky #site-header.overlay-header.light-style\";i:1687;s:99:\"#site-header-sticky-wrapper.is-sticky #site-header.overlay-header.light-style #site-navigation-wrap\";i:1688;s:50:\"#site-header.overlay-header.white-style.dyn-styles\";i:1689;s:234:\"#site-header.overlay-header.white-style.dyn-styles #site-logo a.site-logo-text, #site-header.overlay-header.white-style.dyn-styles #site-navigation .dropdown-menu>li>a, #site-header.overlay-header.white-style.dyn-styles #mobile-menu a\";i:1690;s:87:\"#site-header.overlay-header.white-style.dyn-styles #site-navigation .dropdown-menu>li>a\";i:1691;s:93:\"#site-header.overlay-header.white-style.dyn-styles #site-navigation .dropdown-menu>li>a:hover\";i:1692;s:256:\"#site-header.overlay-header.white-style.dyn-styles #mobile-menu .wpex-bars>span, #site-header.overlay-header.white-style.dyn-styles #mobile-menu .wpex-bars>span::before, #site-header.overlay-header.white-style.dyn-styles #mobile-menu .wpex-bars>span::after\";i:1693;s:49:\"#site-header.overlay-header.dark-style.dyn-styles\";i:1694;s:231:\"#site-header.overlay-header.dark-style.dyn-styles #site-logo a.site-logo-text, #site-header.overlay-header.dark-style.dyn-styles #site-navigation .dropdown-menu>li>a, #site-header.overlay-header.dark-style.dyn-styles #mobile-menu a\";i:1695;s:86:\"#site-header.overlay-header.dark-style.dyn-styles #site-navigation .dropdown-menu>li>a\";i:1696;s:92:\"#site-header.overlay-header.dark-style.dyn-styles #site-navigation .dropdown-menu>li>a:hover\";i:1697;s:253:\"#site-header.overlay-header.dark-style.dyn-styles #mobile-menu .wpex-bars>span, #site-header.overlay-header.dark-style.dyn-styles #mobile-menu .wpex-bars>span::before, #site-header.overlay-header.dark-style.dyn-styles #mobile-menu .wpex-bars>span::after\";i:1698;s:12:\".page-header\";i:1699;s:30:\".no-header-margin .page-header\";i:1700;s:23:\".page-header .container\";i:1701;s:56:\"body.page-header-disabled.no-header-margin #content-wrap\";i:1702;s:18:\".page-header-title\";i:1703;s:16:\".page-subheading\";i:1704;s:29:\".page-subheading p:last-child\";i:1705;s:21:\".centered-page-header\";i:1706;s:40:\".centered-page-header .page-header-title\";i:1707;s:38:\".centered-page-header .page-subheading\";i:1708;s:29:\".centered-minimal-page-header\";i:1709;s:48:\".centered-minimal-page-header .page-header-title\";i:1710;s:46:\".centered-minimal-page-header .page-subheading\";i:1711;s:26:\".solid-color-page-header *\";i:1712;s:20:\".archive-description\";i:1713;s:29:\".background-image-page-header\";i:1714;s:18:\".page-header-table\";i:1715;s:23:\".page-header-table-cell\";i:1716;s:60:\".page-header.background-image-page-header .page-header-title\";i:1717;s:58:\".page-header.background-image-page-header .page-subheading\";i:1718;s:37:\".background-image-page-header-overlay\";i:1719;s:50:\".background-image-page-header-overlay.style-dotted\";i:1720;s:50:\".background-image-page-header-overlay.style-dashed\";i:1721;s:12:\".sidebar-box\";i:1722;s:18:\".sidebar-box input\";i:1723;s:26:\".sidebar-box .widget-title\";i:1724;s:32:\".sidebar-box .widget-titleselect\";i:1725;s:18:\"#page-featured-img\";i:1726;s:22:\"#page-featured-img img\";i:1727;s:12:\".entry-media\";i:1728;s:16:\".entry-media img\";i:1729;s:16:\".entry-excerpt p\";i:1730;s:27:\".entry-excerpt p:last-child\";i:1731;s:20:\".entry-readmore-wrap\";i:1732;s:27:\".entries.left-thumbs .entry\";i:1733;s:40:\".entries.left-thumbs .entry .entry-media\";i:1734;s:42:\".entries.left-thumbs .entry .entry-details\";i:1735;s:51:\".entries.left-thumbs .entry.no-media .entry-details\";i:1736;s:12:\".entry-title\";i:1737;s:14:\".entry-title a\";i:1738;s:20:\".entry-title a:hover\";i:1739;s:38:\".single-post-title, .single-page-title\";i:1740;s:18:\".single-page-title\";i:1741;s:16:\"#login-page-wrap\";i:1742;s:16:\"#login-page-logo\";i:1743;s:18:\"#login-page-logo a\";i:1744;s:20:\"#login-template-form\";i:1745;s:84:\"#login-template-form input[type=\"text\"], #login-template-form input[type=\"password\"]\";i:1746;s:43:\"#login-template-form input:-webkit-autofill\";i:1747;s:26:\"#login-template-form label\";i:1748;s:36:\"#login-template-form .button-primary\";i:1749;s:34:\"#login-template-form .login-submit\";i:1750;s:26:\"#attachment-post-media img\";i:1751;s:24:\"#attachment-post-content\";i:1752;s:25:\"#attachment-post-footer p\";i:1753;s:10:\".widget ul\";i:1754;s:15:\".widget ul li a\";i:1755;s:199:\".widget_archive a, .widget_pages a, .widget_categories a, .widget_recent_entries a, .widget_meta a, .widget_layered_nav_filters a, .widget_product_categories a, .widget_rating_filter a, .widget_rss a\";i:1756;s:331:\".sidebar-widget-icons .widget_archive a:before, .sidebar-widget-icons .widget_recent_entries a:before, .sidebar-widget-icons .widget_recent_comments a:first-child:before, .sidebar-widget-icons .widget_layered_nav a:before, .sidebar-widget-icons .widget_product_categories a:before, .sidebar-widget-icons .widget_categories a:before\";i:1757;s:46:\".sidebar-widget-icons .widget_archive a:before\";i:1758;s:53:\".sidebar-widget-icons .widget_recent_entries a:before\";i:1759;s:66:\".sidebar-widget-icons .widget_recent_comments a:first-child:before\";i:1760;s:50:\".sidebar-widget-icons .widget_layered_nav a:before\";i:1761;s:57:\".sidebar-widget-icons .widget_product_categories a:before\";i:1762;s:49:\".sidebar-widget-icons .widget_categories a:before\";i:1763;s:246:\".wpex-widget-recent-posts-li, .widget_categories li, .widget_recent_entries li, .widget_archive li, .widget_recent_comments li, .widget_product_categories li, .widget_layered_nav li, .widget-recent-posts-icons li, .site-footer .widget_nav_menu li\";i:1764;s:354:\".wpex-widget-recent-posts-li:first-child, .widget_categories li:first-child, .widget_recent_entries li:first-child, .widget_archive li:first-child, .widget_recent_comments li:first-child, .widget_product_categories li:first-child, .widget_layered_nav li:first-child, .widget-recent-posts-icons li:first-child, .site-footer .widget_nav_menu li:first-child\";i:1765;s:46:\".widget_product_categories ul ul li:last-child\";i:1766;s:35:\".widget_product_categories ul ul li\";i:1767;s:10:\"#footer li\";i:1768;s:25:\".tagcloud a, .post-tags a\";i:1769;s:37:\".tagcloud a:hover, .post-tags a:hover\";i:1770;s:11:\".tagcloud a\";i:1771;s:12:\".post-tags a\";i:1772;s:12:\"#wp-calendar\";i:1773;s:32:\"#wp-calendar th, #wp-calendar td\";i:1774;s:21:\"#wp-calendar tbody td\";i:1775;s:23:\"#wp-calendar tbody td a\";i:1776;s:29:\"#wp-calendar tbody td:hover a\";i:1777;s:21:\"#wp-calendar tfoot td\";i:1778;s:20:\"#wp-calendar caption\";i:1779;s:20:\"#wp-calendar tbody a\";i:1780;s:18:\"#wp-calendar #prev\";i:1781;s:18:\"#wp-calendar #next\";i:1782;s:29:\"#footer #wp-calendar thead th\";i:1783;s:48:\"#footer #wp-calendar th, #footer #wp-calendar td\";i:1784;s:68:\"#footer #wp-calendar tbody td:hover, #footer #wp-calendar tbody td a\";i:1785;s:33:\".widget_recent_entries .post-date\";i:1786;s:90:\"#sidebar .widget_nav_menu .sub-menu, .widget_nav_menu_accordion .widget_nav_menu .sub-menu\";i:1787;s:108:\"#sidebar .widget_nav_menu .sub-menu a:before, .widget_nav_menu_accordion .widget_nav_menu .sub-menu a:before\";i:1788;s:128:\"#sidebar .widget_nav_menu .sub-menu .sub-menu a:before, .widget_nav_menu_accordion .widget_nav_menu .sub-menu .sub-menu a:before\";i:1789;s:76:\"#sidebar .widget_nav_menu ul, .widget_nav_menu_accordion .widget_nav_menu ul\";i:1790;s:82:\"#sidebar .widget_nav_menu ul ul, .widget_nav_menu_accordion .widget_nav_menu ul ul\";i:1791;s:116:\"#sidebar .widget_nav_menu ul ul li:first-child a, .widget_nav_menu_accordion .widget_nav_menu ul ul li:first-child a\";i:1792;s:110:\"#sidebar .widget_nav_menu ul>li:first-child>a, .widget_nav_menu_accordion .widget_nav_menu ul>li:first-child>a\";i:1793;s:118:\"#sidebar .widget_nav_menu>div>ul>li:first-child>a, .widget_nav_menu_accordion .widget_nav_menu>div>ul>li:first-child>a\";i:1794;s:116:\"#sidebar .widget_nav_menu>div>ul>li:last-child>a, .widget_nav_menu_accordion .widget_nav_menu>div>ul>li:last-child>a\";i:1795;s:74:\"#sidebar .widget_nav_menu a, .widget_nav_menu_accordion .widget_nav_menu a\";i:1796;s:88:\"#sidebar .widget_nav_menu a .ticon, .widget_nav_menu_accordion .widget_nav_menu a .ticon\";i:1797;s:122:\"#sidebar .widget_nav_menu .menu-item-has-children>a, .widget_nav_menu_accordion .widget_nav_menu .menu-item-has-children>a\";i:1798;s:102:\"#sidebar .widget_nav_menu .parent>a:after, .widget_nav_menu_accordion .widget_nav_menu .parent>a:after\";i:1799;s:116:\"#sidebar .widget_nav_menu .parent.active>a:after, .widget_nav_menu_accordion .widget_nav_menu .parent.active>a:after\";i:1800;s:86:\"#sidebar .widget_nav_menu a:hover, .widget_nav_menu_accordion .widget_nav_menu a:hover\";i:1801;s:112:\"#sidebar .widget_nav_menu .current-menu-item>a, .widget_nav_menu_accordion .widget_nav_menu .current-menu-item>a\";i:1802;s:126:\"#sidebar .widget_nav_menu .current-menu-item>a::after, .widget_nav_menu_accordion .widget_nav_menu .current-menu-item>a::after\";i:1803;s:92:\"#sidebar .widget_nav_menu ul ul li a, .widget_nav_menu_accordion .widget_nav_menu ul ul li a\";i:1804;s:98:\"#sidebar .widget_nav_menu ul ul ul li a, .widget_nav_menu_accordion .widget_nav_menu ul ul ul li a\";i:1805;s:258:\"#sidebar .widget_nav_menu .current_page_item>.sub-menu, #sidebar .widget_nav_menu .current-menu-item>.sub-menu, .widget_nav_menu_accordion .widget_nav_menu .current_page_item>.sub-menu, .widget_nav_menu_accordion .widget_nav_menu .current-menu-item>.sub-menu\";i:1806;s:32:\".site-footer .widget_nav_menu li\";i:1807;s:35:\".site-footer .widget_nav_menu li ul\";i:1808;s:50:\".site-footer .widget_nav_menu li ul li:first-child\";i:1809;s:49:\".site-footer .widget_nav_menu li ul li:last-child\";i:1810;s:34:\".widget_categories .cat-count-span\";i:1811;s:22:\".widget_layered_nav li\";i:1812;s:26:\".widget_layered_nav .count\";i:1813;s:14:\".widget_rss li\";i:1814;s:25:\".widget_rss li:last-child\";i:1815;s:23:\".widget_rss a.rsswidget\";i:1816;s:28:\".widget_rss .rss-widget-icon\";i:1817;s:37:\".widget_rss .widget-title a.rsswidget\";i:1818;s:21:\".widget_rss .rss-date\";i:1819;s:23:\".widget_rss .rssSummary\";i:1820;s:16:\".widget_rss cite\";i:1821;s:33:\".widget_wpex_facebook_page_widget\";i:1822;s:28:\".wpex-about-widget-image img\";i:1823;s:30:\".wpex-about-widget-description\";i:1824;s:19:\".wpex-flickr-widget\";i:1825;s:86:\".wpex-flickr-widget .flickr_badge_image a, .wpex-flickr-widget .flickr_badge_image img\";i:1826;s:45:\".wpex-flickr-widget .flickr_badge_image:hover\";i:1827;s:30:\".wpex-video-widget-description\";i:1828;s:30:\".wpex-gmap-widget-embed iframe\";i:1829;s:21:\".wpex-info-widget div\";i:1830;s:32:\".wpex-info-widget div:last-child\";i:1831;s:19:\".wpex-info-widget p\";i:1832;s:24:\".wpex-info-widget .ticon\";i:1833;s:20:\".wpex-users-widget a\";i:1834;s:26:\".wpex-users-widget a:hover\";i:1835;s:29:\".wpex-users-widget-avatar img\";i:1836;s:23:\".wpex-users-widget-name\";i:1837;s:19:\".modern-menu-widget\";i:1838;s:21:\".modern-menu-widget a\";i:1839;s:28:\".modern-menu-widget a>.ticon\";i:1840;s:27:\".modern-menu-widget a:after\";i:1841;s:27:\".modern-menu-widget a:hover\";i:1842;s:22:\".modern-menu-widget li\";i:1843;s:42:\".modern-menu-widget li.current-menu-item a\";i:1844;s:48:\".modern-menu-widget li.current-menu-item a:after\";i:1845;s:25:\".modern-menu-widget li ul\";i:1846;s:33:\".modern-menu-widget li:last-child\";i:1847;s:36:\".modern-menu-widget>li:first-child>a\";i:1848;s:35:\".modern-menu-widget>li:last-child>a\";i:1849;s:51:\"body.content-right-sidebar .modern-menu-widget li a\";i:1850;s:54:\"body.content-right-sidebar .modern-menu-widget a:after\";i:1851;s:26:\".wpex-social-widget-output\";i:1852;s:29:\".wpex-social-widget-output li\";i:1853;s:33:\".wpex-social-widget-output li img\";i:1854;s:39:\".wpex-social-widget-output li img:hover\";i:1855;s:40:\".wpex-social-widget-output li img:active\";i:1856;s:40:\".wpex-social-widget-output.textcenter li\";i:1857;s:39:\".wpex-social-widget-output.textright li\";i:1858;s:28:\".wpex-fa-social-widget .desc\";i:1859;s:41:\".wpex-fa-social-widget .desc p:last-child\";i:1860;s:25:\".wpex-fa-social-widget ul\";i:1861;s:28:\".wpex-fa-social-widget ul li\";i:1862;s:39:\".wpex-fa-social-widget .wpex-social-btn\";i:1863;s:54:\".wpex-fa-social-widget .wpex-social-btn-no-style:hover\";i:1864;s:39:\".wpex-fa-social-widget.textcenter ul li\";i:1865;s:38:\".wpex-fa-social-widget.textright ul li\";i:1866;s:23:\".wpex-newsletter-widget\";i:1867;s:30:\".wpex-newsletter-widget button\";i:1868;s:87:\".wpex-newsletter-widget input[type=\"email\"], .wpex-newsletter-widget input[type=\"text\"]\";i:1869;s:31:\".wpex-newsletter-widget-heading\";i:1870;s:35:\".wpex-newsletter-widget-description\";i:1871;s:48:\".wpex-newsletter-widget-description p:last-child\";i:1872;s:31:\"#footer .wpex-newsletter-widget\";i:1873;s:39:\"#footer .wpex-newsletter-widget-heading\";i:1874;s:113:\"#footer input[type=\"email\"].wpex-newsletter-widget-input, #footer input[type=\"text\"].wpex-newsletter-widget-input\";i:1875;s:125:\"#footer input[type=\"email\"].wpex-newsletter-widget-input:focus, #footer input[type=\"text\"].wpex-newsletter-widget-input:focus\";i:1876;s:28:\".widget_wpex_newsletter form\";i:1877;s:43:\".widget_wpex_newsletter input[type=\"email\"]\";i:1878;s:57:\".widget_wpex_newsletter.footer-widget input[type=\"email\"]\";i:1879;s:30:\".widget_wpex_newsletter button\";i:1880;s:31:\".wpex-instagram-grid-widget img\";i:1881;s:37:\".wpex-instagram-grid-widget img:hover\";i:1882;s:41:\"#main .wpex-recent-comments-widget strong\";i:1883;s:31:\".wpex-recent-comments-widget li\";i:1884;s:33:\".wpex-recent-comments-widget li a\";i:1885;s:40:\".wpex-recent-comments-widget li a.avatar\";i:1886;s:44:\".wpex-recent-comments-widget li a.avatar img\";i:1887;s:43:\".wpex-recent-comments-widget li:first-child\";i:1888;s:52:\".wpex-recent-comments-widget li:first-child a.avatar\";i:1889;s:53:\".site-footer .wpex-recent-comments-widget li a.avatar\";i:1890;s:48:\".site-footer .wpex-recent-comments-widget strong\";i:1891;s:28:\".wpex-widget-recent-posts-li\";i:1892;s:37:\".wpex-widget-recent-posts-li .details\";i:1893;s:35:\".wpex-widget-recent-posts-thumbnail\";i:1894;s:39:\".wpex-widget-recent-posts-thumbnail img\";i:1895;s:31:\".wpex-widget-recent-posts-title\";i:1896;s:37:\".wpex-widget-recent-posts-title:hover\";i:1897;s:39:\"#sidebar .wpex-widget-recent-posts-date\";i:1898;s:33:\".wpex-widget-recent-posts-excerpt\";i:1899;s:68:\".wpex-widget-recent-posts.style-fullimg .wpex-widget-recent-posts-li\";i:1900;s:75:\".wpex-widget-recent-posts.style-fullimg .wpex-widget-recent-posts-thumbnail\";i:1901;s:70:\".wpex-widget-recent-posts.style-fullimg .wpex-widget-recent-posts-date\";i:1902;s:36:\".widget-recent-posts-icons li .ticon\";i:1903;s:49:\".site-footer .widget-recent-posts-icons li .ticon\";i:1904;s:60:\".blog-entry-media, .blog-entry-excerpt, .blog-entry-readmore\";i:1905;s:42:\".blog-isotope-grid .infinite-scroll-loader\";i:1906;s:17:\".blog-entry-title\";i:1907;s:32:\".blog-entry-excerpt p:last-child\";i:1908;s:39:\".blog-entry-readmore span.readmore-rarr\";i:1909;s:30:\".blog-entry-music-icon-overlay\";i:1910;s:36:\".blog-entry-music-icon-overlay:hover\";i:1911;s:37:\".blog-entry-music-icon-overlay .ticon\";i:1912;s:16:\".blog-post-audio\";i:1913;s:47:\".blog-post-audio iframe, .blog-post-audio embed\";i:1914;s:54:\".single-post .blog-entry.grid-entry-style.format-quote\";i:1915;s:13:\".format-quote\";i:1916;s:48:\".blog-entry.format-quote .post-quote-entry-inner\";i:1917;s:37:\".blog-entry.format-quote p:last-child\";i:1918;s:44:\".blog-entry.format-quote .quote-entry-author\";i:1919;s:43:\".blog-entry.format-quote .ticon-quote-right\";i:1920;s:41:\".entry-has-avatar.large-image-entry-style\";i:1921;s:58:\".blog-entry-author-avatar a, .blog-entry-author-avatar img\";i:1922;s:35:\".blog-entry.large-image-entry-style\";i:1923;s:48:\".blog-entry.large-image-entry-style.format-quote\";i:1924;s:73:\".blog-entry.large-image-entry-style .blog-entry-music-icon-overlay .ticon\";i:1925;s:56:\".blog-entry.large-image-entry-style .blog-entry-readmore\";i:1926;s:28:\".blog-entry.grid-entry-style\";i:1927;s:46:\".blog-entry.grid-entry-style .blog-entry-inner\";i:1928;s:46:\".blog-entry.grid-entry-style .blog-entry-media\";i:1929;s:35:\".blog-entry.grid-entry-style header\";i:1930;s:46:\".blog-entry.grid-entry-style .blog-entry-title\";i:1931;s:48:\".blog-entry.grid-entry-style .header-with-avatar\";i:1932;s:54:\".blog-entry.grid-entry-style .blog-entry-author-avatar\";i:1933;s:44:\".blog-entry.grid-entry-style .sp-fade-arrows\";i:1934;s:54:\".blog-entry.grid-entry-style .sp-horizontal .sp-arrows\";i:1935;s:51:\".blog-entry.grid-entry-style .wpex-slider .sp-arrow\";i:1936;s:57:\".blog-entry.grid-entry-style .wpex-slider .sp-arrow:hover\";i:1937;s:48:\".blog-entry.grid-entry-style .blog-entry-excerpt\";i:1938;s:49:\".blog-entry.grid-entry-style .blog-entry-readmore\";i:1939;s:54:\".entries.left-thumbs .blog-entry.thumbnail-entry-style\";i:1940;s:51:\".blog-entry.thumbnail-entry-style .blog-entry-title\";i:1941;s:49:\".blog-entry.thumbnail-entry-style .sp-fade-arrows\";i:1942;s:59:\".blog-entry.thumbnail-entry-style .sp-horizontal .sp-arrows\";i:1943;s:56:\".blog-entry.thumbnail-entry-style .wpex-slider .sp-arrow\";i:1944;s:62:\".blog-entry.thumbnail-entry-style .wpex-slider .sp-arrow:hover\";i:1945;s:20:\".single-blog-content\";i:1946;s:11:\"#post-media\";i:1947;s:15:\"#post-media img\";i:1948;s:19:\".post-media-caption\";i:1949;s:21:\".post-media-caption p\";i:1950;s:32:\".post-media-caption p:last-child\";i:1951;s:21:\".post-media-caption a\";i:1952;s:18:\".single-post .meta\";i:1953;s:34:\".single-post .meta.meta-with-title\";i:1954;s:10:\".post-tags\";i:1955;s:11:\".page-links\";i:1956;s:14:\".related-posts\";i:1957;s:17:\".related-posts li\";i:1958;s:60:\".related-posts li:last-child, .related-posts li p:last-child\";i:1959;s:20:\".related-post-figure\";i:1960;s:48:\".related-post-figure .wpex-thumbnail-format-icon\";i:1961;s:19:\".related-post-thumb\";i:1962;s:23:\".related-post-thumb img\";i:1963;s:19:\".related-post-title\";i:1964;s:25:\"#wrap .related-post-title\";i:1965;s:21:\".related-post-excerpt\";i:1966;s:34:\".related-post-excerpt p:last-child\";i:1967;s:21:\".single .format-quote\";i:1968;s:34:\".single .format-quote p:last-child\";i:1969;s:41:\".single .format-quote .quote-entry-author\";i:1970;s:40:\".single .format-quote .ticon-quote-right\";i:1971;s:10:\".cpt-entry\";i:1972;s:39:\".cpt-entry.span_1_of_1 .cpt-entry-inner\";i:1973;s:16:\".cpt-entry-media\";i:1974;s:16:\".cpt-entry-title\";i:1975;s:31:\".cpt-entry-excerpt p:last-child\";i:1976;s:43:\".cpt-entry.span_1_of_1 .entry-readmore-wrap\";i:1977;s:27:\".portfolio-entry-categories\";i:1978;s:29:\".portfolio-entry-categories a\";i:1979;s:24:\".portfolio-entry-details\";i:1980;s:26:\".portfolio-entry-media img\";i:1981;s:26:\".portfolio-entry-excerpt p\";i:1982;s:37:\".portfolio-entry-excerpt p:last-child\";i:1983;s:30:\".portfolio-entry-readmore-wrap\";i:1984;s:26:\".portfolio-no-margins .col\";i:1985;s:93:\".vcex-no-margin-grid .portfolio-entry-details, .portfolio-no-margins .portfolio-entry-details\";i:1986;s:188:\".vcex-no-margin-grid .portfolio-entry-title a, .vcex-no-margin-grid .portfolio-entry-title a, .portfolio-no-margins .portfolio-entry-title a, .portfolio-no-margins .portfolio-entry-title a\";i:1987;s:47:\"#portfolio-entries .portfolio-entry.span_1_of_1\";i:1988;s:70:\"#portfolio-entries .portfolio-entry.span_1_of_1 .portfolio-entry-media\";i:1989;s:72:\"#portfolio-entries .portfolio-entry.span_1_of_1 .portfolio-entry-details\";i:1990;s:70:\"#portfolio-entries .portfolio-entry.span_1_of_1 .portfolio-entry-title\";i:1991;s:50:\"#portfolio-single-media, #portfolio-single-related\";i:1992;s:127:\"#portfolio-post-comments, .single-portfolio .wpex-social-share-wrap.position-horizontal, .no-composer #portfolio-single-related\";i:1993;s:12:\".staff-entry\";i:1994;s:23:\".staff-entry-categories\";i:1995;s:25:\".staff-entry-categories a\";i:1996;s:20:\".staff-entry-details\";i:1997;s:21:\".staff-entry-position\";i:1998;s:39:\"#staff-entries .staff-entry.span_1_of_1\";i:1999;s:58:\"#staff-entries .staff-entry.span_1_of_1 .staff-entry-media\";i:2000;s:60:\"#staff-entries .staff-entry.span_1_of_1 .staff-entry-details\";i:2001;s:21:\"#staff-post-thumbnail\";i:2002;s:25:\"#staff-post-thumbnail img\";i:2003;s:19:\"#staff-single-media\";i:2004;s:21:\"#staff-single-related\";i:2005;s:22:\".staff-no-margins .col\";i:2006;s:20:\"#staff-single-header\";i:2007;s:19:\"#staff-single-title\";i:2008;s:22:\"#staff-single-position\";i:2009;s:13:\".staff-social\";i:2010;s:15:\".staff-social a\";i:2011;s:26:\".testimonial-entry-content\";i:2012;s:28:\".testimonial-entry-content p\";i:2013;s:39:\".testimonial-entry-content p:last-child\";i:2014;s:18:\".testimonial-caret\";i:2015;s:24:\".testimonial-entry-thumb\";i:2016;s:28:\".testimonial-entry-thumb img\";i:2017;s:41:\".testimonial-entry-thumb.default-dims img\";i:2018;s:25:\".testimonial-entry-bottom\";i:2019;s:23:\".testimonial-entry-meta\";i:2020;s:25:\".testimonial-entry-author\";i:2021;s:26:\".testimonial-entry-company\";i:2022;s:25:\".testimonial-entry-rating\";i:2023;s:32:\".testimonial-entry-rating .ticon\";i:2024;s:35:\".single-testimonials .entry-content\";i:2025;s:109:\".single-testimonials .content-left-sidebar blockquote, .single-testimonials .content-right-sidebar blockquote\";i:2026;s:11:\".searchform\";i:2027;s:17:\".searchform label\";i:2028;s:17:\".searchform input\";i:2029;s:25:\"#footer .searchform input\";i:2030;s:30:\".searchform .searchform-submit\";i:2031;s:22:\".wpex-menu-search-text\";i:2032;s:28:\"#footer input[type=\"search\"]\";i:2033;s:24:\"#wpex-searchform-overlay\";i:2034;s:45:\"#wpex-searchform-overlay input[type=\"search\"]\";i:2035;s:191:\"#wpex-searchform-overlay input[type=\"submit\"], #wpex-searchform-overlay button.submit, #wpex-searchform-overlay .searchform-submit, #wpex-searchform-overlay .woocommerce-product-search button\";i:2036;s:36:\"#wpex-searchform-overlay .wpex-title\";i:2037;s:38:\"#wpex-searchform-overlay .ticon-search\";i:2038;s:20:\"#searchform-dropdown\";i:2039;s:25:\"#searchform-dropdown.show\";i:2040;s:41:\"#searchform-dropdown input[type=\"search\"]\";i:2041;s:127:\"#searchform-dropdown button, #searchform-dropdown input[type=\"submit\"], #searchform-dropdown .woocommerce-product-search button\";i:2042;s:39:\".boxed-main-layout #searchform-dropdown\";i:2043;s:38:\".navbar-style-six #searchform-dropdown\";i:2044;s:26:\"#searchform-header-replace\";i:2045;s:31:\"#searchform-header-replace.show\";i:2046;s:31:\"#searchform-header-replace form\";i:2047;s:47:\"#searchform-header-replace input[type=\"search\"]\";i:2048;s:199:\"#searchform-header-replace input[type=\"submit\"], #searchform-header-replace button.submit, #searchform-header-replace .searchform-submit, #searchform-header-replace .woocommerce-product-search button\";i:2049;s:32:\"#searchform-header-replace-close\";i:2050;s:38:\"#searchform-header-replace-close:hover\";i:2051;s:49:\".custom-bg #searchform-header-replace-close:hover\";i:2052;s:55:\"body.boxed-main-layout #searchform-header-replace input\";i:2053;s:55:\"body.boxed-main-layout #searchform-header-replace-close\";i:2054;s:18:\"#search-no-results\";i:2055;s:13:\".search-entry\";i:2056;s:26:\".search-entry-header-title\";i:2057;s:18:\".search-entry-text\";i:2058;s:31:\".search-entry-text p:last-child\";i:2059;s:19:\".search-entry-thumb\";i:2060;s:20:\"#footer-callout-wrap\";i:2061;s:20:\"#footer-callout-left\";i:2062;s:31:\"#footer-callout-left.full-width\";i:2063;s:21:\"#footer-callout-right\";i:2064;s:29:\"#footer-callout .theme-button\";i:2065;s:29:\"#footer-callout-wrap.btn-only\";i:2066;s:45:\"#footer-callout-wrap.btn-only #footer-callout\";i:2067;s:103:\"#footer-callout-wrap.btn-only #footer-callout-left, #footer-callout-wrap.btn-only #footer-callout-right\";i:2068;s:43:\"#footer-callout-wrap.btn-only .theme-button\";i:2069;s:27:\"#footer a, #footer-bottom a\";i:2070;s:12:\".site-footer\";i:2071;s:44:\".site-footer table th, .site-footer table td\";i:2072;s:29:\".footer-builder-content.entry\";i:2073;s:25:\".footer-builder-content>p\";i:2074;s:18:\".site-footer-inner\";i:2075;s:23:\".single-col-footer .col\";i:2076;s:15:\".site-footer ul\";i:2077;s:17:\".site-footer .col\";i:2078;s:30:\".full-screen-post .site-footer\";i:2079;s:74:\".site-footer .widget_recent_entries li, .site-footer .widget_categories li\";i:2080;s:14:\".site-footer p\";i:2081;s:20:\".site-footer-widgets\";i:2082;s:35:\".site-footer a, .site-footer strong\";i:2083;s:20:\".site-footer a:hover\";i:2084;s:75:\".site-footer button, .site-footer .color-button, .site-footer .theme-button\";i:2085;s:14:\".footer-widget\";i:2086;s:28:\".footer-widget .widget-title\";i:2087;s:40:\"#footer-widgets.wpex-row .footer-box.col\";i:2088;s:46:\".footer-widget .wpex-widget-recent-posts-title\";i:2089;s:33:\".footer-widget.widget_tag_cloud a\";i:2090;s:16:\"#footer-bottom p\";i:2091;s:27:\"#footer-bottom p:last-child\";i:2092;s:20:\"#footer-bottom-inner\";i:2093;s:94:\".textleft .footer-bottom-flex, .textcenter .footer-bottom-flex, .textright .footer-bottom-flex\";i:2094;s:16:\"#footer-bottom a\";i:2095;s:22:\"#footer-bottom a:hover\";i:2096;s:25:\"#footer-bottom #copyright\";i:2097;s:38:\"#footer-bottom #copyright p:last-child\";i:2098;s:94:\".textleft #footer-bottom-menu, .textcenter #footer-bottom-menu, .textright #footer-bottom-menu\";i:2099;s:22:\"#footer-bottom-menu ul\";i:2100;s:22:\"#footer-bottom-menu li\";i:2101;s:34:\"#footer-bottom-menu li:first-child\";i:2102;s:29:\"#footer-bottom-menu li .ticon\";i:2103;s:48:\"#footer-bottom.textcenter #footer-bottom-menu li\";i:2104;s:47:\"#footer-bottom.textright #footer-bottom-menu li\";i:2105;s:46:\".footer-has-reveal #site-header.header-builder\";i:2106;s:27:\".footer-reveal.wpex-visible\";i:2107;s:122:\"#site-scroll-top, .page-numbers.next, .page-numbers.prev, .author-bio-social a, .wpex-ticon-social-widget .wpex-social-btn\";i:2108;s:689:\".sf-menu>li.megamenu>ul.sub-menu>li>ul.sub-menu>li>ul.sub-menu a:before, .wpex-slider .sp-arrow, .wpex-slider .sp-arrow:before, #main .widget_nav_menu .parent>a:after, .modern-menu-widget a:after, .sidebar-widget-icons .widget_archive a:before, .sidebar-widget-icons .widget_recent_entries a:before, .sidebar-widget-icons .widget_recent_comments a:before, .sidebar-widget-icons .widget_layered_nav a:before, .sidebar-widget-icons .widget_product_categories a:before, .sidebar-widget-icons .widget_categories a:before, .theme-select:after, .searchform input:after, ul.check-list li:before, .animsition-loading:after, .sidr-class-dropdown-toggle:before, .sidr-class-dropdown-menu ul a:before\";i:2109;s:6:\".ticon\";i:2110;s:9:\".ticon-lg\";i:2111;s:9:\".ticon-2x\";i:2112;s:9:\".ticon-3x\";i:2113;s:9:\".ticon-4x\";i:2114;s:9:\".ticon-5x\";i:2115;s:9:\".ticon-fw\";i:2116;s:9:\".ticon-ul\";i:2117;s:12:\".ticon-ul>li\";i:2118;s:9:\".ticon-li\";i:2119;s:18:\".ticon-li.ticon-lg\";i:2120;s:13:\".ticon-border\";i:2121;s:16:\".ticon-pull-left\";i:2122;s:17:\".ticon-pull-right\";i:2123;s:22:\".ticon.ticon-pull-left\";i:2124;s:23:\".ticon.ticon-pull-right\";i:2125;s:11:\".pull-right\";i:2126;s:10:\".pull-left\";i:2127;s:16:\".ticon.pull-left\";i:2128;s:17:\".ticon.pull-right\";i:2129;s:11:\".ticon-spin\";i:2130;s:12:\".ticon-pulse\";i:2131;s:16:\".ticon-rotate-90\";i:2132;s:17:\".ticon-rotate-180\";i:2133;s:17:\".ticon-rotate-270\";i:2134;s:22:\".ticon-flip-horizontal\";i:2135;s:20:\".ticon-flip-vertical\";i:2136;s:130:\":root .ticon-rotate-90, :root .ticon-rotate-180, :root .ticon-rotate-270, :root .ticon-flip-horizontal, :root .ticon-flip-vertical\";i:2137;s:12:\".ticon-stack\";i:2138;s:32:\".ticon-stack-1x, .ticon-stack-2x\";i:2139;s:15:\".ticon-stack-1x\";i:2140;s:15:\".ticon-stack-2x\";i:2141;s:14:\".ticon-inverse\";i:2142;s:19:\".ticon-glass:before\";i:2143;s:19:\".ticon-music:before\";i:2144;s:20:\".ticon-search:before\";i:2145;s:24:\".ticon-envelope-o:before\";i:2146;s:19:\".ticon-heart:before\";i:2147;s:18:\".ticon-star:before\";i:2148;s:46:\".ticon-star-empty:before, .ticon-star-o:before\";i:2149;s:18:\".ticon-user:before\";i:2150;s:18:\".ticon-film:before\";i:2151;s:22:\".ticon-th-large:before\";i:2152;s:16:\".ticon-th:before\";i:2153;s:21:\".ticon-th-list:before\";i:2154;s:19:\".ticon-check:before\";i:2155;s:62:\".ticon-remove:before, .ticon-close:before, .ticon-times:before\";i:2156;s:25:\".ticon-search-plus:before\";i:2157;s:26:\".ticon-search-minus:before\";i:2158;s:23:\".ticon-power-off:before\";i:2159;s:20:\".ticon-signal:before\";i:2160;s:37:\".ticon-gear:before, .ticon-cog:before\";i:2161;s:21:\".ticon-trash-o:before\";i:2162;s:18:\".ticon-home:before\";i:2163;s:20:\".ticon-file-o:before\";i:2164;s:21:\".ticon-clock-o:before\";i:2165;s:18:\".ticon-road:before\";i:2166;s:22:\".ticon-download:before\";i:2167;s:33:\".ticon-arrow-circle-o-down:before\";i:2168;s:31:\".ticon-arrow-circle-o-up:before\";i:2169;s:19:\".ticon-inbox:before\";i:2170;s:27:\".ticon-play-circle-o:before\";i:2171;s:48:\".ticon-rotate-right:before, .ticon-repeat:before\";i:2172;s:21:\".ticon-refresh:before\";i:2173;s:22:\".ticon-list-alt:before\";i:2174;s:18:\".ticon-lock:before\";i:2175;s:18:\".ticon-flag:before\";i:2176;s:24:\".ticon-headphones:before\";i:2177;s:24:\".ticon-volume-off:before\";i:2178;s:25:\".ticon-volume-down:before\";i:2179;s:23:\".ticon-volume-up:before\";i:2180;s:20:\".ticon-qrcode:before\";i:2181;s:21:\".ticon-barcode:before\";i:2182;s:17:\".ticon-tag:before\";i:2183;s:18:\".ticon-tags:before\";i:2184;s:18:\".ticon-book:before\";i:2185;s:22:\".ticon-bookmark:before\";i:2186;s:19:\".ticon-print:before\";i:2187;s:20:\".ticon-camera:before\";i:2188;s:18:\".ticon-font:before\";i:2189;s:18:\".ticon-bold:before\";i:2190;s:20:\".ticon-italic:before\";i:2191;s:25:\".ticon-text-height:before\";i:2192;s:24:\".ticon-text-width:before\";i:2193;s:24:\".ticon-align-left:before\";i:2194;s:26:\".ticon-align-center:before\";i:2195;s:25:\".ticon-align-right:before\";i:2196;s:27:\".ticon-align-justify:before\";i:2197;s:18:\".ticon-list:before\";i:2198;s:43:\".ticon-dedent:before, .ticon-outdent:before\";i:2199;s:20:\".ticon-indent:before\";i:2200;s:26:\".ticon-video-camera:before\";i:2201;s:65:\".ticon-photo:before, .ticon-image:before, .ticon-picture-o:before\";i:2202;s:20:\".ticon-pencil:before\";i:2203;s:24:\".ticon-map-marker:before\";i:2204;s:20:\".ticon-adjust:before\";i:2205;s:18:\".ticon-tint:before\";i:2206;s:49:\".ticon-edit:before, .ticon-pencil-square-o:before\";i:2207;s:28:\".ticon-share-square-o:before\";i:2208;s:28:\".ticon-check-square-o:before\";i:2209;s:20:\".ticon-arrows:before\";i:2210;s:27:\".ticon-step-backward:before\";i:2211;s:27:\".ticon-fast-backward:before\";i:2212;s:22:\".ticon-backward:before\";i:2213;s:18:\".ticon-play:before\";i:2214;s:19:\".ticon-pause:before\";i:2215;s:18:\".ticon-stop:before\";i:2216;s:21:\".ticon-forward:before\";i:2217;s:26:\".ticon-fast-forward:before\";i:2218;s:26:\".ticon-step-forward:before\";i:2219;s:19:\".ticon-eject:before\";i:2220;s:26:\".ticon-chevron-left:before\";i:2221;s:27:\".ticon-chevron-right:before\";i:2222;s:25:\".ticon-plus-circle:before\";i:2223;s:26:\".ticon-minus-circle:before\";i:2224;s:26:\".ticon-times-circle:before\";i:2225;s:26:\".ticon-check-circle:before\";i:2226;s:29:\".ticon-question-circle:before\";i:2227;s:25:\".ticon-info-circle:before\";i:2228;s:24:\".ticon-crosshairs:before\";i:2229;s:28:\".ticon-times-circle-o:before\";i:2230;s:28:\".ticon-check-circle-o:before\";i:2231;s:17:\".ticon-ban:before\";i:2232;s:24:\".ticon-arrow-left:before\";i:2233;s:25:\".ticon-arrow-right:before\";i:2234;s:22:\".ticon-arrow-up:before\";i:2235;s:24:\".ticon-arrow-down:before\";i:2236;s:47:\".ticon-mail-forward:before, .ticon-share:before\";i:2237;s:20:\".ticon-expand:before\";i:2238;s:22:\".ticon-compress:before\";i:2239;s:18:\".ticon-plus:before\";i:2240;s:19:\".ticon-minus:before\";i:2241;s:22:\".ticon-asterisk:before\";i:2242;s:32:\".ticon-exclamation-circle:before\";i:2243;s:18:\".ticon-gift:before\";i:2244;s:18:\".ticon-leaf:before\";i:2245;s:18:\".ticon-fire:before\";i:2246;s:17:\".ticon-eye:before\";i:2247;s:23:\".ticon-eye-slash:before\";i:2248;s:57:\".ticon-warning:before, .ticon-exclamation-triangle:before\";i:2249;s:19:\".ticon-plane:before\";i:2250;s:22:\".ticon-calendar:before\";i:2251;s:20:\".ticon-random:before\";i:2252;s:21:\".ticon-comment:before\";i:2253;s:20:\".ticon-magnet:before\";i:2254;s:24:\".ticon-chevron-up:before\";i:2255;s:26:\".ticon-chevron-down:before\";i:2256;s:21:\".ticon-retweet:before\";i:2257;s:27:\".ticon-shopping-cart:before\";i:2258;s:20:\".ticon-folder:before\";i:2259;s:25:\".ticon-folder-open:before\";i:2260;s:22:\".ticon-arrows-v:before\";i:2261;s:22:\".ticon-arrows-h:before\";i:2262;s:50:\".ticon-bar-chart-o:before, .ticon-bar-chart:before\";i:2263;s:28:\".ticon-twitter-square:before\";i:2264;s:29:\".ticon-facebook-square:before\";i:2265;s:26:\".ticon-camera-retro:before\";i:2266;s:17:\".ticon-key:before\";i:2267;s:39:\".ticon-gears:before, .ticon-cogs:before\";i:2268;s:22:\".ticon-comments:before\";i:2269;s:25:\".ticon-thumbs-o-up:before\";i:2270;s:27:\".ticon-thumbs-o-down:before\";i:2271;s:23:\".ticon-star-half:before\";i:2272;s:21:\".ticon-heart-o:before\";i:2273;s:22:\".ticon-sign-out:before\";i:2274;s:29:\".ticon-linkedin-square:before\";i:2275;s:24:\".ticon-thumb-tack:before\";i:2276;s:27:\".ticon-external-link:before\";i:2277;s:21:\".ticon-sign-in:before\";i:2278;s:20:\".ticon-trophy:before\";i:2279;s:27:\".ticon-github-square:before\";i:2280;s:20:\".ticon-upload:before\";i:2281;s:21:\".ticon-lemon-o:before\";i:2282;s:19:\".ticon-phone:before\";i:2283;s:22:\".ticon-square-o:before\";i:2284;s:24:\".ticon-bookmark-o:before\";i:2285;s:26:\".ticon-phone-square:before\";i:2286;s:21:\".ticon-twitter:before\";i:2287;s:48:\".ticon-facebook-f:before, .ticon-facebook:before\";i:2288;s:20:\".ticon-github:before\";i:2289;s:20:\".ticon-unlock:before\";i:2290;s:25:\".ticon-credit-card:before\";i:2291;s:37:\".ticon-feed:before, .ticon-rss:before\";i:2292;s:19:\".ticon-hdd-o:before\";i:2293;s:22:\".ticon-bullhorn:before\";i:2294;s:18:\".ticon-bell:before\";i:2295;s:25:\".ticon-certificate:before\";i:2296;s:26:\".ticon-hand-o-right:before\";i:2297;s:25:\".ticon-hand-o-left:before\";i:2298;s:23:\".ticon-hand-o-up:before\";i:2299;s:25:\".ticon-hand-o-down:before\";i:2300;s:31:\".ticon-arrow-circle-left:before\";i:2301;s:32:\".ticon-arrow-circle-right:before\";i:2302;s:29:\".ticon-arrow-circle-up:before\";i:2303;s:31:\".ticon-arrow-circle-down:before\";i:2304;s:19:\".ticon-globe:before\";i:2305;s:20:\".ticon-wrench:before\";i:2306;s:19:\".ticon-tasks:before\";i:2307;s:20:\".ticon-filter:before\";i:2308;s:23:\".ticon-briefcase:before\";i:2309;s:24:\".ticon-arrows-alt:before\";i:2310;s:40:\".ticon-group:before, .ticon-users:before\";i:2311;s:39:\".ticon-chain:before, .ticon-link:before\";i:2312;s:19:\".ticon-cloud:before\";i:2313;s:19:\".ticon-flask:before\";i:2314;s:41:\".ticon-cut:before, .ticon-scissors:before\";i:2315;s:41:\".ticon-copy:before, .ticon-files-o:before\";i:2316;s:23:\".ticon-paperclip:before\";i:2317;s:42:\".ticon-save:before, .ticon-floppy-o:before\";i:2318;s:20:\".ticon-square:before\";i:2319;s:64:\".ticon-navicon:before, .ticon-reorder:before, .ticon-bars:before\";i:2320;s:21:\".ticon-list-ul:before\";i:2321;s:21:\".ticon-list-ol:before\";i:2322;s:27:\".ticon-strikethrough:before\";i:2323;s:23:\".ticon-underline:before\";i:2324;s:19:\".ticon-table:before\";i:2325;s:19:\".ticon-magic:before\";i:2326;s:19:\".ticon-truck:before\";i:2327;s:23:\".ticon-pinterest:before\";i:2328;s:30:\".ticon-pinterest-square:before\";i:2329;s:32:\".ticon-google-plus-square:before\";i:2330;s:25:\".ticon-google-plus:before\";i:2331;s:19:\".ticon-money:before\";i:2332;s:24:\".ticon-caret-down:before\";i:2333;s:22:\".ticon-caret-up:before\";i:2334;s:24:\".ticon-caret-left:before\";i:2335;s:25:\".ticon-caret-right:before\";i:2336;s:21:\".ticon-columns:before\";i:2337;s:42:\".ticon-unsorted:before, .ticon-sort:before\";i:2338;s:48:\".ticon-sort-down:before, .ticon-sort-desc:before\";i:2339;s:45:\".ticon-sort-up:before, .ticon-sort-asc:before\";i:2340;s:22:\".ticon-envelope:before\";i:2341;s:22:\".ticon-linkedin:before\";i:2342;s:45:\".ticon-rotate-left:before, .ticon-undo:before\";i:2343;s:40:\".ticon-legal:before, .ticon-gavel:before\";i:2344;s:49:\".ticon-dashboard:before, .ticon-tachometer:before\";i:2345;s:23:\".ticon-comment-o:before\";i:2346;s:24:\".ticon-comments-o:before\";i:2347;s:39:\".ticon-flash:before, .ticon-bolt:before\";i:2348;s:21:\".ticon-sitemap:before\";i:2349;s:22:\".ticon-umbrella:before\";i:2350;s:44:\".ticon-paste:before, .ticon-clipboard:before\";i:2351;s:25:\".ticon-lightbulb-o:before\";i:2352;s:22:\".ticon-exchange:before\";i:2353;s:28:\".ticon-cloud-download:before\";i:2354;s:26:\".ticon-cloud-upload:before\";i:2355;s:21:\".ticon-user-md:before\";i:2356;s:25:\".ticon-stethoscope:before\";i:2357;s:22:\".ticon-suitcase:before\";i:2358;s:20:\".ticon-bell-o:before\";i:2359;s:20:\".ticon-coffee:before\";i:2360;s:21:\".ticon-cutlery:before\";i:2361;s:25:\".ticon-file-text-o:before\";i:2362;s:24:\".ticon-building-o:before\";i:2363;s:24:\".ticon-hospital-o:before\";i:2364;s:23:\".ticon-ambulance:before\";i:2365;s:20:\".ticon-medkit:before\";i:2366;s:25:\".ticon-fighter-jet:before\";i:2367;s:18:\".ticon-beer:before\";i:2368;s:22:\".ticon-h-square:before\";i:2369;s:25:\".ticon-plus-square:before\";i:2370;s:31:\".ticon-angle-double-left:before\";i:2371;s:32:\".ticon-angle-double-right:before\";i:2372;s:29:\".ticon-angle-double-up:before\";i:2373;s:31:\".ticon-angle-double-down:before\";i:2374;s:24:\".ticon-angle-left:before\";i:2375;s:25:\".ticon-angle-right:before\";i:2376;s:22:\".ticon-angle-up:before\";i:2377;s:24:\".ticon-angle-down:before\";i:2378;s:21:\".ticon-desktop:before\";i:2379;s:20:\".ticon-laptop:before\";i:2380;s:20:\".ticon-tablet:before\";i:2381;s:48:\".ticon-mobile-phone:before, .ticon-mobile:before\";i:2382;s:22:\".ticon-circle-o:before\";i:2383;s:24:\".ticon-quote-left:before\";i:2384;s:25:\".ticon-quote-right:before\";i:2385;s:21:\".ticon-spinner:before\";i:2386;s:20:\".ticon-circle:before\";i:2387;s:45:\".ticon-mail-reply:before, .ticon-reply:before\";i:2388;s:24:\".ticon-github-alt:before\";i:2389;s:22:\".ticon-folder-o:before\";i:2390;s:27:\".ticon-folder-open-o:before\";i:2391;s:21:\".ticon-smile-o:before\";i:2392;s:21:\".ticon-frown-o:before\";i:2393;s:19:\".ticon-meh-o:before\";i:2394;s:21:\".ticon-gamepad:before\";i:2395;s:24:\".ticon-keyboard-o:before\";i:2396;s:20:\".ticon-flag-o:before\";i:2397;s:28:\".ticon-flag-checkered:before\";i:2398;s:22:\".ticon-terminal:before\";i:2399;s:18:\".ticon-code:before\";i:2400;s:53:\".ticon-mail-reply-all:before, .ticon-reply-all:before\";i:2401;s:86:\".ticon-star-half-empty:before, .ticon-star-half-full:before, .ticon-star-half-o:before\";i:2402;s:28:\".ticon-location-arrow:before\";i:2403;s:18:\".ticon-crop:before\";i:2404;s:23:\".ticon-code-fork:before\";i:2405;s:48:\".ticon-unlink:before, .ticon-chain-broken:before\";i:2406;s:22:\".ticon-question:before\";i:2407;s:18:\".ticon-info:before\";i:2408;s:25:\".ticon-exclamation:before\";i:2409;s:25:\".ticon-superscript:before\";i:2410;s:23:\".ticon-subscript:before\";i:2411;s:20:\".ticon-eraser:before\";i:2412;s:26:\".ticon-puzzle-piece:before\";i:2413;s:24:\".ticon-microphone:before\";i:2414;s:30:\".ticon-microphone-slash:before\";i:2415;s:20:\".ticon-shield:before\";i:2416;s:24:\".ticon-calendar-o:before\";i:2417;s:31:\".ticon-fire-extinguisher:before\";i:2418;s:20:\".ticon-rocket:before\";i:2419;s:20:\".ticon-maxcdn:before\";i:2420;s:33:\".ticon-chevron-circle-left:before\";i:2421;s:34:\".ticon-chevron-circle-right:before\";i:2422;s:31:\".ticon-chevron-circle-up:before\";i:2423;s:33:\".ticon-chevron-circle-down:before\";i:2424;s:19:\".ticon-html5:before\";i:2425;s:18:\".ticon-css3:before\";i:2426;s:20:\".ticon-anchor:before\";i:2427;s:24:\".ticon-unlock-alt:before\";i:2428;s:22:\".ticon-bullseye:before\";i:2429;s:24:\".ticon-ellipsis-h:before\";i:2430;s:24:\".ticon-ellipsis-v:before\";i:2431;s:24:\".ticon-rss-square:before\";i:2432;s:25:\".ticon-play-circle:before\";i:2433;s:20:\".ticon-ticket:before\";i:2434;s:26:\".ticon-minus-square:before\";i:2435;s:28:\".ticon-minus-square-o:before\";i:2436;s:22:\".ticon-level-up:before\";i:2437;s:24:\".ticon-level-down:before\";i:2438;s:26:\".ticon-check-square:before\";i:2439;s:27:\".ticon-pencil-square:before\";i:2440;s:34:\".ticon-external-link-square:before\";i:2441;s:26:\".ticon-share-square:before\";i:2442;s:21:\".ticon-compass:before\";i:2443;s:60:\".ticon-toggle-down:before, .ticon-caret-square-o-down:before\";i:2444;s:56:\".ticon-toggle-up:before, .ticon-caret-square-o-up:before\";i:2445;s:62:\".ticon-toggle-right:before, .ticon-caret-square-o-right:before\";i:2446;s:37:\".ticon-euro:before, .ticon-eur:before\";i:2447;s:17:\".ticon-gbp:before\";i:2448;s:39:\".ticon-dollar:before, .ticon-usd:before\";i:2449;s:38:\".ticon-rupee:before, .ticon-inr:before\";i:2450;s:74:\".ticon-cny:before, .ticon-rmb:before, .ticon-yen:before, .ticon-jpy:before\";i:2451;s:60:\".ticon-ruble:before, .ticon-rouble:before, .ticon-rub:before\";i:2452;s:36:\".ticon-won:before, .ticon-krw:before\";i:2453;s:40:\".ticon-bitcoin:before, .ticon-btc:before\";i:2454;s:18:\".ticon-file:before\";i:2455;s:23:\".ticon-file-text:before\";i:2456;s:28:\".ticon-sort-alpha-asc:before\";i:2457;s:29:\".ticon-sort-alpha-desc:before\";i:2458;s:29:\".ticon-sort-amount-asc:before\";i:2459;s:30:\".ticon-sort-amount-desc:before\";i:2460;s:30:\".ticon-sort-numeric-asc:before\";i:2461;s:31:\".ticon-sort-numeric-desc:before\";i:2462;s:23:\".ticon-thumbs-up:before\";i:2463;s:25:\".ticon-thumbs-down:before\";i:2464;s:28:\".ticon-youtube-square:before\";i:2465;s:21:\".ticon-youtube:before\";i:2466;s:18:\".ticon-xing:before\";i:2467;s:25:\".ticon-xing-square:before\";i:2468;s:26:\".ticon-youtube-play:before\";i:2469;s:21:\".ticon-dropbox:before\";i:2470;s:28:\".ticon-stack-overflow:before\";i:2471;s:23:\".ticon-instagram:before\";i:2472;s:20:\".ticon-flickr:before\";i:2473;s:17:\".ticon-adn:before\";i:2474;s:23:\".ticon-bitbucket:before\";i:2475;s:30:\".ticon-bitbucket-square:before\";i:2476;s:20:\".ticon-tumblr:before\";i:2477;s:27:\".ticon-tumblr-square:before\";i:2478;s:29:\".ticon-long-arrow-down:before\";i:2479;s:27:\".ticon-long-arrow-up:before\";i:2480;s:29:\".ticon-long-arrow-left:before\";i:2481;s:30:\".ticon-long-arrow-right:before\";i:2482;s:19:\".ticon-apple:before\";i:2483;s:21:\".ticon-windows:before\";i:2484;s:21:\".ticon-android:before\";i:2485;s:19:\".ticon-linux:before\";i:2486;s:22:\".ticon-dribbble:before\";i:2487;s:19:\".ticon-skype:before\";i:2488;s:24:\".ticon-foursquare:before\";i:2489;s:20:\".ticon-trello:before\";i:2490;s:20:\".ticon-female:before\";i:2491;s:18:\".ticon-male:before\";i:2492;s:44:\".ticon-gittip:before, .ticon-gratipay:before\";i:2493;s:19:\".ticon-sun-o:before\";i:2494;s:20:\".ticon-moon-o:before\";i:2495;s:21:\".ticon-archive:before\";i:2496;s:17:\".ticon-bug:before\";i:2497;s:16:\".ticon-vk:before\";i:2498;s:19:\".ticon-weibo:before\";i:2499;s:20:\".ticon-renren:before\";i:2500;s:23:\".ticon-pagelines:before\";i:2501;s:28:\".ticon-stack-exchange:before\";i:2502;s:34:\".ticon-arrow-circle-o-right:before\";i:2503;s:33:\".ticon-arrow-circle-o-left:before\";i:2504;s:60:\".ticon-toggle-left:before, .ticon-caret-square-o-left:before\";i:2505;s:26:\".ticon-dot-circle-o:before\";i:2506;s:24:\".ticon-wheelchair:before\";i:2507;s:26:\".ticon-vimeo-square:before\";i:2508;s:45:\".ticon-turkish-lira:before, .ticon-try:before\";i:2509;s:27:\".ticon-plus-square-o:before\";i:2510;s:27:\".ticon-space-shuttle:before\";i:2511;s:19:\".ticon-slack:before\";i:2512;s:29:\".ticon-envelope-square:before\";i:2513;s:23:\".ticon-wordpress:before\";i:2514;s:20:\".ticon-openid:before\";i:2515;s:71:\".ticon-institution:before, .ticon-bank:before, .ticon-university:before\";i:2516;s:56:\".ticon-mortar-board:before, .ticon-graduation-cap:before\";i:2517;s:19:\".ticon-yahoo:before\";i:2518;s:20:\".ticon-google:before\";i:2519;s:20:\".ticon-reddit:before\";i:2520;s:27:\".ticon-reddit-square:before\";i:2521;s:32:\".ticon-stumbleupon-circle:before\";i:2522;s:25:\".ticon-stumbleupon:before\";i:2523;s:23:\".ticon-delicious:before\";i:2524;s:18:\".ticon-digg:before\";i:2525;s:27:\".ticon-pied-piper-pp:before\";i:2526;s:28:\".ticon-pied-piper-alt:before\";i:2527;s:20:\".ticon-drupal:before\";i:2528;s:20:\".ticon-joomla:before\";i:2529;s:22:\".ticon-language:before\";i:2530;s:17:\".ticon-fax:before\";i:2531;s:22:\".ticon-building:before\";i:2532;s:19:\".ticon-child:before\";i:2533;s:17:\".ticon-paw:before\";i:2534;s:19:\".ticon-spoon:before\";i:2535;s:18:\".ticon-cube:before\";i:2536;s:19:\".ticon-cubes:before\";i:2537;s:21:\".ticon-behance:before\";i:2538;s:28:\".ticon-behance-square:before\";i:2539;s:19:\".ticon-steam:before\";i:2540;s:26:\".ticon-steam-square:before\";i:2541;s:21:\".ticon-recycle:before\";i:2542;s:43:\".ticon-automobile:before, .ticon-car:before\";i:2543;s:37:\".ticon-cab:before, .ticon-taxi:before\";i:2544;s:18:\".ticon-tree:before\";i:2545;s:21:\".ticon-spotify:before\";i:2546;s:24:\".ticon-deviantart:before\";i:2547;s:24:\".ticon-soundcloud:before\";i:2548;s:22:\".ticon-database:before\";i:2549;s:24:\".ticon-file-pdf-o:before\";i:2550;s:25:\".ticon-file-word-o:before\";i:2551;s:26:\".ticon-file-excel-o:before\";i:2552;s:31:\".ticon-file-powerpoint-o:before\";i:2553;s:84:\".ticon-file-photo-o:before, .ticon-file-picture-o:before, .ticon-file-image-o:before\";i:2554;s:54:\".ticon-file-zip-o:before, .ticon-file-archive-o:before\";i:2555;s:54:\".ticon-file-sound-o:before, .ticon-file-audio-o:before\";i:2556;s:54:\".ticon-file-movie-o:before, .ticon-file-video-o:before\";i:2557;s:25:\".ticon-file-code-o:before\";i:2558;s:18:\".ticon-vine:before\";i:2559;s:21:\".ticon-codepen:before\";i:2560;s:22:\".ticon-jsfiddle:before\";i:2561;s:122:\".ticon-life-bouy:before, .ticon-life-buoy:before, .ticon-life-saver:before, .ticon-support:before, .ticon-life-ring:before\";i:2562;s:28:\".ticon-circle-o-notch:before\";i:2563;s:63:\".ticon-ra:before, .ticon-resistance:before, .ticon-rebel:before\";i:2564;s:38:\".ticon-ge:before, .ticon-empire:before\";i:2565;s:24:\".ticon-git-square:before\";i:2566;s:17:\".ticon-git:before\";i:2567;s:85:\".ticon-y-combinator-square:before, .ticon-yc-square:before, .ticon-hacker-news:before\";i:2568;s:27:\".ticon-tencent-weibo:before\";i:2569;s:16:\".ticon-qq:before\";i:2570;s:42:\".ticon-wechat:before, .ticon-weixin:before\";i:2571;s:45:\".ticon-send:before, .ticon-paper-plane:before\";i:2572;s:49:\".ticon-send-o:before, .ticon-paper-plane-o:before\";i:2573;s:21:\".ticon-history:before\";i:2574;s:25:\".ticon-circle-thin:before\";i:2575;s:20:\".ticon-header:before\";i:2576;s:23:\".ticon-paragraph:before\";i:2577;s:21:\".ticon-sliders:before\";i:2578;s:23:\".ticon-share-alt:before\";i:2579;s:30:\".ticon-share-alt-square:before\";i:2580;s:18:\".ticon-bomb:before\";i:2581;s:51:\".ticon-soccer-ball-o:before, .ticon-futbol-o:before\";i:2582;s:17:\".ticon-tty:before\";i:2583;s:24:\".ticon-binoculars:before\";i:2584;s:18:\".ticon-plug:before\";i:2585;s:24:\".ticon-slideshare:before\";i:2586;s:20:\".ticon-twitch:before\";i:2587;s:18:\".ticon-yelp:before\";i:2588;s:25:\".ticon-newspaper-o:before\";i:2589;s:18:\".ticon-wifi:before\";i:2590;s:24:\".ticon-calculator:before\";i:2591;s:20:\".ticon-paypal:before\";i:2592;s:27:\".ticon-google-wallet:before\";i:2593;s:21:\".ticon-cc-visa:before\";i:2594;s:27:\".ticon-cc-mastercard:before\";i:2595;s:25:\".ticon-cc-discover:before\";i:2596;s:21:\".ticon-cc-amex:before\";i:2597;s:23:\".ticon-cc-paypal:before\";i:2598;s:23:\".ticon-cc-stripe:before\";i:2599;s:24:\".ticon-bell-slash:before\";i:2600;s:26:\".ticon-bell-slash-o:before\";i:2601;s:19:\".ticon-trash:before\";i:2602;s:23:\".ticon-copyright:before\";i:2603;s:16:\".ticon-at:before\";i:2604;s:24:\".ticon-eyedropper:before\";i:2605;s:25:\".ticon-paint-brush:before\";i:2606;s:27:\".ticon-birthday-cake:before\";i:2607;s:24:\".ticon-area-chart:before\";i:2608;s:23:\".ticon-pie-chart:before\";i:2609;s:24:\".ticon-line-chart:before\";i:2610;s:20:\".ticon-lastfm:before\";i:2611;s:27:\".ticon-lastfm-square:before\";i:2612;s:24:\".ticon-toggle-off:before\";i:2613;s:23:\".ticon-toggle-on:before\";i:2614;s:21:\".ticon-bicycle:before\";i:2615;s:17:\".ticon-bus:before\";i:2616;s:21:\".ticon-ioxhost:before\";i:2617;s:23:\".ticon-angellist:before\";i:2618;s:16:\".ticon-cc:before\";i:2619;s:61:\".ticon-shekel:before, .ticon-sheqel:before, .ticon-ils:before\";i:2620;s:22:\".ticon-meanpath:before\";i:2621;s:24:\".ticon-buysellads:before\";i:2622;s:28:\".ticon-connectdevelop:before\";i:2623;s:22:\".ticon-dashcube:before\";i:2624;s:22:\".ticon-forumbee:before\";i:2625;s:21:\".ticon-leanpub:before\";i:2626;s:20:\".ticon-sellsy:before\";i:2627;s:26:\".ticon-shirtsinbulk:before\";i:2628;s:25:\".ticon-simplybuilt:before\";i:2629;s:22:\".ticon-skyatlas:before\";i:2630;s:23:\".ticon-cart-plus:before\";i:2631;s:29:\".ticon-cart-arrow-down:before\";i:2632;s:21:\".ticon-diamond:before\";i:2633;s:18:\".ticon-ship:before\";i:2634;s:25:\".ticon-user-secret:before\";i:2635;s:24:\".ticon-motorcycle:before\";i:2636;s:25:\".ticon-street-view:before\";i:2637;s:23:\".ticon-heartbeat:before\";i:2638;s:19:\".ticon-venus:before\";i:2639;s:18:\".ticon-mars:before\";i:2640;s:21:\".ticon-mercury:before\";i:2641;s:49:\".ticon-intersex:before, .ticon-transgender:before\";i:2642;s:29:\".ticon-transgender-alt:before\";i:2643;s:26:\".ticon-venus-double:before\";i:2644;s:25:\".ticon-mars-double:before\";i:2645;s:24:\".ticon-venus-mars:before\";i:2646;s:25:\".ticon-mars-stroke:before\";i:2647;s:27:\".ticon-mars-stroke-v:before\";i:2648;s:27:\".ticon-mars-stroke-h:before\";i:2649;s:20:\".ticon-neuter:before\";i:2650;s:24:\".ticon-genderless:before\";i:2651;s:31:\".ticon-facebook-official:before\";i:2652;s:25:\".ticon-pinterest-p:before\";i:2653;s:22:\".ticon-whatsapp:before\";i:2654;s:20:\".ticon-server:before\";i:2655;s:23:\".ticon-user-plus:before\";i:2656;s:24:\".ticon-user-times:before\";i:2657;s:38:\".ticon-hotel:before, .ticon-bed:before\";i:2658;s:21:\".ticon-viacoin:before\";i:2659;s:19:\".ticon-train:before\";i:2660;s:20:\".ticon-subway:before\";i:2661;s:20:\".ticon-medium:before\";i:2662;s:44:\".ticon-yc:before, .ticon-y-combinator:before\";i:2663;s:27:\".ticon-optin-monster:before\";i:2664;s:22:\".ticon-opencart:before\";i:2665;s:26:\".ticon-expeditedssl:before\";i:2666;s:74:\".ticon-battery-4:before, .ticon-battery:before, .ticon-battery-full:before\";i:2667;s:61:\".ticon-battery-3:before, .ticon-battery-three-quarters:before\";i:2668;s:51:\".ticon-battery-2:before, .ticon-battery-half:before\";i:2669;s:54:\".ticon-battery-1:before, .ticon-battery-quarter:before\";i:2670;s:52:\".ticon-battery-0:before, .ticon-battery-empty:before\";i:2671;s:27:\".ticon-mouse-pointer:before\";i:2672;s:22:\".ticon-i-cursor:before\";i:2673;s:26:\".ticon-object-group:before\";i:2674;s:28:\".ticon-object-ungroup:before\";i:2675;s:25:\".ticon-sticky-note:before\";i:2676;s:27:\".ticon-sticky-note-o:before\";i:2677;s:20:\".ticon-cc-jcb:before\";i:2678;s:28:\".ticon-cc-diners-club:before\";i:2679;s:19:\".ticon-clone:before\";i:2680;s:27:\".ticon-balance-scale:before\";i:2681;s:25:\".ticon-hourglass-o:before\";i:2682;s:56:\".ticon-hourglass-1:before, .ticon-hourglass-start:before\";i:2683;s:55:\".ticon-hourglass-2:before, .ticon-hourglass-half:before\";i:2684;s:54:\".ticon-hourglass-3:before, .ticon-hourglass-end:before\";i:2685;s:23:\".ticon-hourglass:before\";i:2686;s:52:\".ticon-hand-grab-o:before, .ticon-hand-rock-o:before\";i:2687;s:53:\".ticon-hand-stop-o:before, .ticon-hand-paper-o:before\";i:2688;s:29:\".ticon-hand-scissors-o:before\";i:2689;s:27:\".ticon-hand-lizard-o:before\";i:2690;s:26:\".ticon-hand-spock-o:before\";i:2691;s:28:\".ticon-hand-pointer-o:before\";i:2692;s:26:\".ticon-hand-peace-o:before\";i:2693;s:23:\".ticon-trademark:before\";i:2694;s:24:\".ticon-registered:before\";i:2695;s:30:\".ticon-creative-commons:before\";i:2696;s:16:\".ticon-gg:before\";i:2697;s:23:\".ticon-gg-circle:before\";i:2698;s:25:\".ticon-tripadvisor:before\";i:2699;s:27:\".ticon-odnoklassniki:before\";i:2700;s:34:\".ticon-odnoklassniki-square:before\";i:2701;s:24:\".ticon-get-pocket:before\";i:2702;s:25:\".ticon-wikipedia-w:before\";i:2703;s:20:\".ticon-safari:before\";i:2704;s:20:\".ticon-chrome:before\";i:2705;s:21:\".ticon-firefox:before\";i:2706;s:19:\".ticon-opera:before\";i:2707;s:31:\".ticon-internet-explorer:before\";i:2708;s:42:\".ticon-tv:before, .ticon-television:before\";i:2709;s:20:\".ticon-contao:before\";i:2710;s:19:\".ticon-500px:before\";i:2711;s:20:\".ticon-amazon:before\";i:2712;s:29:\".ticon-calendar-plus-o:before\";i:2713;s:30:\".ticon-calendar-minus-o:before\";i:2714;s:30:\".ticon-calendar-times-o:before\";i:2715;s:30:\".ticon-calendar-check-o:before\";i:2716;s:22:\".ticon-industry:before\";i:2717;s:21:\".ticon-map-pin:before\";i:2718;s:23:\".ticon-map-signs:before\";i:2719;s:19:\".ticon-map-o:before\";i:2720;s:17:\".ticon-map:before\";i:2721;s:24:\".ticon-commenting:before\";i:2722;s:26:\".ticon-commenting-o:before\";i:2723;s:19:\".ticon-houzz:before\";i:2724;s:19:\".ticon-vimeo:before\";i:2725;s:23:\".ticon-black-tie:before\";i:2726;s:23:\".ticon-fonticons:before\";i:2727;s:26:\".ticon-reddit-alien:before\";i:2728;s:18:\".ticon-edge:before\";i:2729;s:29:\".ticon-credit-card-alt:before\";i:2730;s:22:\".ticon-codiepie:before\";i:2731;s:18:\".ticon-modx:before\";i:2732;s:26:\".ticon-fort-awesome:before\";i:2733;s:17:\".ticon-usb:before\";i:2734;s:26:\".ticon-product-hunt:before\";i:2735;s:22:\".ticon-mixcloud:before\";i:2736;s:20:\".ticon-scribd:before\";i:2737;s:26:\".ticon-pause-circle:before\";i:2738;s:28:\".ticon-pause-circle-o:before\";i:2739;s:25:\".ticon-stop-circle:before\";i:2740;s:27:\".ticon-stop-circle-o:before\";i:2741;s:26:\".ticon-shopping-bag:before\";i:2742;s:29:\".ticon-shopping-basket:before\";i:2743;s:21:\".ticon-hashtag:before\";i:2744;s:23:\".ticon-bluetooth:before\";i:2745;s:25:\".ticon-bluetooth-b:before\";i:2746;s:21:\".ticon-percent:before\";i:2747;s:20:\".ticon-gitlab:before\";i:2748;s:24:\".ticon-wpbeginner:before\";i:2749;s:21:\".ticon-wpforms:before\";i:2750;s:20:\".ticon-envira:before\";i:2751;s:30:\".ticon-universal-access:before\";i:2752;s:28:\".ticon-wheelchair-alt:before\";i:2753;s:31:\".ticon-question-circle-o:before\";i:2754;s:19:\".ticon-blind:before\";i:2755;s:31:\".ticon-audio-description:before\";i:2756;s:34:\".ticon-volume-control-phone:before\";i:2757;s:21:\".ticon-braille:before\";i:2758;s:41:\".ticon-assistive-listening-systems:before\";i:2759;s:81:\".ticon-asl-interpreting:before, .ticon-american-sign-language-interpreting:before\";i:2760;s:73:\".ticon-deafness:before, .ticon-hard-of-hearing:before, .ticon-deaf:before\";i:2761;s:19:\".ticon-glide:before\";i:2762;s:21:\".ticon-glide-g:before\";i:2763;s:50:\".ticon-signing:before, .ticon-sign-language:before\";i:2764;s:24:\".ticon-low-vision:before\";i:2765;s:20:\".ticon-viadeo:before\";i:2766;s:27:\".ticon-viadeo-square:before\";i:2767;s:22:\".ticon-snapchat:before\";i:2768;s:28:\".ticon-snapchat-ghost:before\";i:2769;s:29:\".ticon-snapchat-square:before\";i:2770;s:24:\".ticon-pied-piper:before\";i:2771;s:25:\".ticon-first-order:before\";i:2772;s:19:\".ticon-yoast:before\";i:2773;s:23:\".ticon-themeisle:before\";i:2774;s:68:\".ticon-google-plus-circle:before, .ticon-google-plus-official:before\";i:2775;s:44:\".ticon-fa:before, .ticon-font-awesome:before\";i:2776;s:25:\".ticon-handshake-o:before\";i:2777;s:27:\".ticon-envelope-open:before\";i:2778;s:29:\".ticon-envelope-open-o:before\";i:2779;s:20:\".ticon-linode:before\";i:2780;s:26:\".ticon-address-book:before\";i:2781;s:28:\".ticon-address-book-o:before\";i:2782;s:47:\".ticon-vcard:before, .ticon-address-card:before\";i:2783;s:51:\".ticon-vcard-o:before, .ticon-address-card-o:before\";i:2784;s:25:\".ticon-user-circle:before\";i:2785;s:27:\".ticon-user-circle-o:before\";i:2786;s:20:\".ticon-user-o:before\";i:2787;s:22:\".ticon-id-badge:before\";i:2788;s:52:\".ticon-drivers-license:before, .ticon-id-card:before\";i:2789;s:56:\".ticon-drivers-license-o:before, .ticon-id-card-o:before\";i:2790;s:19:\".ticon-quora:before\";i:2791;s:28:\".ticon-free-code-camp:before\";i:2792;s:22:\".ticon-telegram:before\";i:2793;s:86:\".ticon-thermometer-4:before, .ticon-thermometer:before, .ticon-thermometer-full:before\";i:2794;s:69:\".ticon-thermometer-3:before, .ticon-thermometer-three-quarters:before\";i:2795;s:59:\".ticon-thermometer-2:before, .ticon-thermometer-half:before\";i:2796;s:62:\".ticon-thermometer-1:before, .ticon-thermometer-quarter:before\";i:2797;s:60:\".ticon-thermometer-0:before, .ticon-thermometer-empty:before\";i:2798;s:20:\".ticon-shower:before\";i:2799;s:60:\".ticon-bathtub:before, .ticon-s15:before, .ticon-bath:before\";i:2800;s:21:\".ticon-podcast:before\";i:2801;s:29:\".ticon-window-maximize:before\";i:2802;s:29:\".ticon-window-minimize:before\";i:2803;s:28:\".ticon-window-restore:before\";i:2804;s:57:\".ticon-times-rectangle:before, .ticon-window-close:before\";i:2805;s:61:\".ticon-times-rectangle-o:before, .ticon-window-close-o:before\";i:2806;s:22:\".ticon-bandcamp:before\";i:2807;s:18:\".ticon-grav:before\";i:2808;s:18:\".ticon-etsy:before\";i:2809;s:18:\".ticon-imdb:before\";i:2810;s:21:\".ticon-ravelry:before\";i:2811;s:21:\".ticon-eercast:before\";i:2812;s:23:\".ticon-microchip:before\";i:2813;s:25:\".ticon-snowflake-o:before\";i:2814;s:25:\".ticon-superpowers:before\";i:2815;s:24:\".ticon-wpexplorer:before\";i:2816;s:20:\".ticon-meetup:before\";i:2817;s:307:\".wpex-accent-bg, .background-highlight, .tagcloud a:hover, .post-tags a:hover, .wpex-carousel .owl-dot.active, #site-navigation .menu-button>a>span.link-inner, .wpex-carousel .owl-prev, .wpex-carousel .owl-next, .modern-menu-widget li.current-menu-item a, #wp-calendar caption, #wp-calendar tbody td:hover a\";i:2818;s:141:\"#site-scroll-top:hover, .wpex-carousel .owl-prev:hover, .wpex-carousel .owl-next:hover, #site-navigation .menu-button>a>span.link-inner:hover\";i:2819;s:333:\".wpex-accent-color, a.wpex-accent-color, #site-navigation .dropdown-menu>li.menu-item>a:hover, #site-navigation .dropdown-menu>li.menu-item.current-menu-item>a, #site-navigation .dropdown-menu>li.menu-item.current-menu-parent>a, h1 a:hover, h2 a:hover, a:hover h2, h3 a:hover, h4 a:hover, h5 a:hover, h6 a:hover, .entry-title a:hover\";i:2820;s:30:\".sf-menu, .sf-menu ul.sub-menu\";i:2821;s:20:\".sf-menu ul.sub-menu\";i:2822;s:21:\".sf-menu>li.menu-item\";i:2823;s:64:\".sf-menu li.menu-item:hover>ul, .sf-menu li.menu-item.sfHover>ul\";i:2824;s:23:\".sf-menu li.menu-item>a\";i:2825;s:32:\".sf-menu ul.sub-menu ul.sub-menu\";i:2826;s:8:\".sf-menu\";i:2827;s:21:\".sf-menu li.menu-item\";i:2828;s:58:\".sf-menu li.menu-item:hover, .sf-menu li.menu-item.sfHover\";i:2829;s:13:\".typed-cursor\";i:2830;s:24:\".wpex-animsition-loading\";i:2831;s:13:\"#lean_overlay\";i:2832;s:23:\".owl-carousel .animated\";i:2833;s:30:\".owl-carousel .owl-animated-in\";i:2834;s:31:\".owl-carousel .owl-animated-out\";i:2835;s:22:\".owl-carousel .fadeOut\";i:2836;s:11:\".owl-height\";i:2837;s:13:\".owl-carousel\";i:2838;s:24:\".owl-carousel .owl-stage\";i:2839;s:30:\".owl-carousel .owl-stage:after\";i:2840;s:30:\".owl-carousel .owl-stage-outer\";i:2841;s:132:\".owl-carousel .owl-controls .owl-nav .owl-prev, .owl-carousel .owl-controls .owl-nav .owl-next, .owl-carousel .owl-controls .owl-dot\";i:2842;s:24:\".owl-carousel.owl-loaded\";i:2843;s:25:\".owl-carousel.owl-loading\";i:2844;s:24:\".owl-carousel.owl-hidden\";i:2845;s:36:\".owl-carousel .owl-refresh .owl-item\";i:2846;s:23:\".owl-carousel .owl-item\";i:2847;s:27:\".owl-carousel .owl-item img\";i:2848;s:42:\".owl-carousel.owl-text-select-on .owl-item\";i:2849;s:23:\".owl-carousel .owl-grab\";i:2850;s:21:\".owl-carousel.owl-rtl\";i:2851;s:31:\".owl-carousel.owl-rtl .owl-item\";i:2852;s:20:\".no-js .owl-carousel\";i:2853;s:33:\".owl-carousel .owl-item .owl-lazy\";i:2854;s:32:\".owl-carousel .owl-video-wrapper\";i:2855;s:34:\".owl-carousel .owl-video-play-icon\";i:2856;s:40:\".owl-carousel .owl-video-play-icon:hover\";i:2857;s:101:\".owl-carousel .owl-video-playing .owl-video-tn, .owl-carousel .owl-video-playing .owl-video-play-icon\";i:2858;s:27:\".owl-carousel .owl-video-tn\";i:2859;s:30:\".owl-carousel .owl-video-frame\";i:2860;s:11:\".slider-pro\";i:2861;s:20:\".sp-slides-container\";i:2862;s:8:\".sp-mask\";i:2863;s:10:\".sp-slides\";i:2864;s:9:\".sp-slide\";i:2865;s:19:\".sp-image-container\";i:2866;s:9:\".sp-image\";i:2867;s:9:\".sp-no-js\";i:2868;s:24:\".sp-thumbnails-container\";i:2869;s:41:\".sp-bottom-thumbnails, .sp-top-thumbnails\";i:2870;s:18:\".sp-top-thumbnails\";i:2871;s:21:\".sp-bottom-thumbnails\";i:2872;s:41:\".sp-left-thumbnails, .sp-right-thumbnails\";i:2873;s:20:\".sp-right-thumbnails\";i:2874;s:19:\".sp-left-thumbnails\";i:2875;s:14:\".sp-thumbnails\";i:2876;s:13:\".sp-thumbnail\";i:2877;s:23:\".sp-thumbnail-container\";i:2878;s:89:\".sp-bottom-thumbnails .sp-thumbnail-container, .sp-top-thumbnails .sp-thumbnail-container\";i:2879;s:113:\".sp-bottom-thumbnails .sp-thumbnail-container:first-child, .sp-top-thumbnails .sp-thumbnail-container:first-child\";i:2880;s:111:\".sp-bottom-thumbnails .sp-thumbnail-container:last-child, .sp-top-thumbnails .sp-thumbnail-container:last-child\";i:2881;s:89:\".sp-left-thumbnails .sp-thumbnail-container, .sp-right-thumbnails .sp-thumbnail-container\";i:2882;s:113:\".sp-left-thumbnails .sp-thumbnail-container:first-child, .sp-right-thumbnails .sp-thumbnail-container:first-child\";i:2883;s:111:\".sp-left-thumbnails .sp-thumbnail-container:last-child, .sp-right-thumbnails .sp-thumbnail-container:last-child\";i:2884;s:35:\".sp-right-thumbnails.sp-has-pointer\";i:2885;s:49:\".sp-right-thumbnails.sp-has-pointer .sp-thumbnail\";i:2886;s:65:\".sp-right-thumbnails.sp-has-pointer .sp-selected-thumbnail:before\";i:2887;s:64:\".sp-right-thumbnails.sp-has-pointer .sp-selected-thumbnail:after\";i:2888;s:34:\".sp-left-thumbnails.sp-has-pointer\";i:2889;s:48:\".sp-left-thumbnails.sp-has-pointer .sp-thumbnail\";i:2890;s:64:\".sp-left-thumbnails.sp-has-pointer .sp-selected-thumbnail:before\";i:2891;s:63:\".sp-left-thumbnails.sp-has-pointer .sp-selected-thumbnail:after\";i:2892;s:36:\".sp-bottom-thumbnails.sp-has-pointer\";i:2893;s:50:\".sp-bottom-thumbnails.sp-has-pointer .sp-thumbnail\";i:2894;s:66:\".sp-bottom-thumbnails.sp-has-pointer .sp-selected-thumbnail:before\";i:2895;s:65:\".sp-bottom-thumbnails.sp-has-pointer .sp-selected-thumbnail:after\";i:2896;s:33:\".sp-top-thumbnails.sp-has-pointer\";i:2897;s:47:\".sp-top-thumbnails.sp-has-pointer .sp-thumbnail\";i:2898;s:63:\".sp-top-thumbnails.sp-has-pointer .sp-selected-thumbnail:before\";i:2899;s:62:\".sp-top-thumbnails.sp-has-pointer .sp-selected-thumbnail:after\";i:2900;s:9:\".sp-layer\";i:2901;s:9:\".sp-black\";i:2902;s:9:\".sp-white\";i:2903;s:11:\".sp-rounded\";i:2904;s:11:\".sp-padding\";i:2905;s:8:\".sp-grab\";i:2906;s:12:\".sp-grabbing\";i:2907;s:14:\".sp-selectable\";i:2908;s:21:\".sp-caption-container\";i:2909;s:15:\".sp-full-screen\";i:2910;s:22:\".sp-full-screen-button\";i:2911;s:29:\".sp-full-screen-button:before\";i:2912;s:20:\".sp-fade-full-screen\";i:2913;s:38:\".slider-pro:hover .sp-fade-full-screen\";i:2914;s:11:\".sp-buttons\";i:2915;s:19:\".sp-selected-button\";i:2916;s:10:\".sp-arrows\";i:2917;s:15:\".sp-fade-arrows\";i:2918;s:42:\".sp-slides-container:hover .sp-fade-arrows\";i:2919;s:25:\".sp-horizontal .sp-arrows\";i:2920;s:23:\".sp-vertical .sp-arrows\";i:2921;s:9:\".sp-arrow\";i:2922;s:22:\".sp-vertical .sp-arrow\";i:2923;s:33:\".sp-horizontal .sp-previous-arrow\";i:2924;s:29:\".sp-horizontal .sp-next-arrow\";i:2925;s:31:\".sp-vertical .sp-previous-arrow\";i:2926;s:27:\".sp-vertical .sp-next-arrow\";i:2927;s:96:\".sp-next-arrow:after, .sp-next-arrow:before, .sp-previous-arrow:after, .sp-previous-arrow:before\";i:2928;s:25:\".sp-previous-arrow:before\";i:2929;s:24:\".sp-previous-arrow:after\";i:2930;s:21:\".sp-next-arrow:before\";i:2931;s:20:\".sp-next-arrow:after\";i:2932;s:30:\".ie7 .sp-arrow, .ie8 .sp-arrow\";i:2933;s:88:\".ie7 .sp-arrow:after, .ie7 .sp-arrow:before, .ie8 .sp-arrow:after, .ie8 .sp-arrow:before\";i:2934;s:76:\".ie7.sp-horizontal .sp-previous-arrow, .ie8.sp-horizontal .sp-previous-arrow\";i:2935;s:68:\".ie7.sp-horizontal .sp-next-arrow, .ie8.sp-horizontal .sp-next-arrow\";i:2936;s:72:\".ie7.sp-vertical .sp-previous-arrow, .ie8.sp-vertical .sp-previous-arrow\";i:2937;s:64:\".ie7.sp-vertical .sp-next-arrow, .ie8.sp-vertical .sp-next-arrow\";i:2938;s:20:\".sp-thumbnail-arrows\";i:2939;s:25:\".sp-fade-thumbnail-arrows\";i:2940;s:56:\".sp-thumbnails-container:hover .sp-fade-thumbnail-arrows\";i:2941;s:83:\".sp-bottom-thumbnails .sp-thumbnail-arrows, .sp-top-thumbnails .sp-thumbnail-arrows\";i:2942;s:83:\".sp-left-thumbnails .sp-thumbnail-arrows, .sp-right-thumbnails .sp-thumbnail-arrows\";i:2943;s:19:\".sp-thumbnail-arrow\";i:2944;s:123:\".sp-left-thumbnails .sp-thumbnail-arrows .sp-thumbnail-arrow, .sp-right-thumbnails .sp-thumbnail-arrows .sp-thumbnail-arrow\";i:2945;s:99:\".sp-bottom-thumbnails .sp-previous-thumbnail-arrow, .sp-top-thumbnails .sp-previous-thumbnail-arrow\";i:2946;s:91:\".sp-bottom-thumbnails .sp-next-thumbnail-arrow, .sp-top-thumbnails .sp-next-thumbnail-arrow\";i:2947;s:99:\".sp-left-thumbnails .sp-previous-thumbnail-arrow, .sp-right-thumbnails .sp-previous-thumbnail-arrow\";i:2948;s:91:\".sp-left-thumbnails .sp-next-thumbnail-arrow, .sp-right-thumbnails .sp-next-thumbnail-arrow\";i:2949;s:136:\".sp-next-thumbnail-arrow:after, .sp-next-thumbnail-arrow:before, .sp-previous-thumbnail-arrow:after, .sp-previous-thumbnail-arrow:before\";i:2950;s:35:\".sp-previous-thumbnail-arrow:before\";i:2951;s:34:\".sp-previous-thumbnail-arrow:after\";i:2952;s:31:\".sp-next-thumbnail-arrow:before\";i:2953;s:30:\".sp-next-thumbnail-arrow:after\";i:2954;s:50:\".ie7 .sp-thumbnail-arrow, .ie8 .sp-thumbnail-arrow\";i:2955;s:128:\".ie7 .sp-thumbnail-arrow:after, .ie7 .sp-thumbnail-arrow:before, .ie8 .sp-thumbnail-arrow:after, .ie8 .sp-thumbnail-arrow:before\";i:2956;s:220:\".ie7 .sp-bottom-thumbnails .sp-previous-thumbnail-arrow, .ie7 .sp-top-thumbnails .sp-previous-thumbnail-arrow, .ie8 .sp-bottom-thumbnails .sp-previous-thumbnail-arrow, .ie8 .sp-top-thumbnails .sp-previous-thumbnail-arrow\";i:2957;s:204:\".ie7 .sp-bottom-thumbnails .sp-next-thumbnail-arrow, .ie7 .sp-top-thumbnails .sp-next-thumbnail-arrow, .ie8 .sp-bottom-thumbnails .sp-next-thumbnail-arrow, .ie8 .sp-top-thumbnails .sp-next-thumbnail-arrow\";i:2958;s:220:\".ie7 .sp-left-thumbnails .sp-previous-thumbnail-arrow, .ie7 .sp-right-thumbnails .sp-previous-thumbnail-arrow, .ie8 .sp-left-thumbnails .sp-previous-thumbnail-arrow, .ie8 .sp-right-thumbnails .sp-previous-thumbnail-arrow\";i:2959;s:204:\".ie7 .sp-left-thumbnails .sp-next-thumbnail-arrow, .ie7 .sp-right-thumbnails .sp-next-thumbnail-arrow, .ie8 .sp-left-thumbnails .sp-next-thumbnail-arrow, .ie8 .sp-right-thumbnails .sp-next-thumbnail-arrow\";i:2960;s:10:\"a.sp-video\";i:2961;s:14:\"a.sp-video img\";i:2962;s:16:\"a.sp-video:after\";i:2963;s:54:\".slider-pro img.sp-image, .slider-pro img.sp-thumbnail\";i:2964;s:13:\".slider-pro a\";i:2965;s:96:\".slider-pro canvas, .slider-pro embed, .slider-pro iframe, .slider-pro object, .slider-pro video\";i:2966;s:22:\".slider-pro p.sp-layer\";i:2967;s:23:\".slider-pro h1.sp-layer\";i:2968;s:23:\".slider-pro h2.sp-layer\";i:2969;s:23:\".slider-pro h3.sp-layer\";i:2970;s:23:\".slider-pro h4.sp-layer\";i:2971;s:23:\".slider-pro h5.sp-layer\";i:2972;s:23:\".slider-pro h6.sp-layer\";i:2973;s:24:\".slider-pro img.sp-layer\";i:2974;s:24:\".tparrows.preview2:after\";i:2975;s:31:\".polylang-switcher-shortcode li\";i:2976;s:47:\".polylang-switcher-shortcode.flags-and-names li\";i:2977;s:42:\".polylang-switcher-shortcode li:last-child\";i:2978;s:25:\".dataTables_wrapper table\";i:2979;s:82:\".dataTables_wrapper .tablepress tfoot th, .dataTables_wrapper .tablepress thead th\";i:2980;s:139:\".dataTables_wrapper .tablepress .sorting:hover, .dataTables_wrapper .tablepress .sorting_asc, .dataTables_wrapper .tablepress .sorting_desc\";i:2981;s:82:\".dataTables_wrapper .tablepress tbody td, .dataTables_wrapper .tablepress tfoot th\";i:2982;s:39:\".dataTables_wrapper .tablepress .odd td\";i:2983;s:36:\".dataTables_wrapper .dataTables_info\";i:2984;s:20:\".dataTables_paginate\";i:2985;s:34:\".dataTables_paginate.paging_simple\";i:2986;s:131:\".dataTables_paginate.paging_simple .paginate_button.next:after, .dataTables_paginate.paging_simple .paginate_button.previous:before\";i:2987;s:67:\".dataTables_paginate.paging_simple .paginate_button.previous:before\";i:2988;s:62:\".dataTables_paginate.paging_simple .paginate_button.next:after\";i:2989;s:36:\".dataTables_paginate.paging_simple a\";i:2990;s:60:\".dataTables_paginate.paging_simple .paginate_button.disabled\";i:2991;s:38:\".dataTables_length, .dataTables_filter\";i:2992;s:39:\".dataTables_filter input[type=\"search\"]\";i:2993;s:58:\"#footer #lang_sel_list a, #footer #lang_sel_list a:visited\";i:2994;s:25:\"#footer #lang_sel_list li\";i:2995;s:68:\".visible-tablet, .visible-tablet-landscape, .visible-tablet-portrait\";i:2996;s:325:\"input[type=\"color\"], input[type=\"date\"], input[type=\"datetime\"], input[type=\"datetime-local\"], input[type=\"email\"], input[type=\"month\"], input[type=\"number\"], input[type=\"password\"], input[type=\"search\"], input[type=\"tel\"], input[type=\"text\"], input[type=\"time\"], input[type=\"url\"], input[type=\"week\"], select:focus, textarea\";i:2997;s:18:\"#wrap .remove-dims\";i:2998;s:19:\"#wrap .reset-styles\";i:2999;s:21:\"#wrap .reset-styles a\";i:3000;s:25:\"#wrap .disable-box-shadow\";}", "no");
INSERT INTO `wp_options` VALUES("1492", "ms_child_theme_editor_dict_query", "a:23:{i:1;s:41:\"@media only screen and (max-width: 768px)\";i:2;s:41:\"@media only screen and (min-width: 960px)\";i:3;s:36:\"@media screen and (max-width: 600px)\";i:4;s:36:\"@media screen and (max-width: 400px)\";i:5;s:41:\"@media only screen and (max-width: 959px)\";i:6;s:12:\"@media print\";i:7;s:65:\"@media only screen and (min-width: 768px) and (max-width: 1024px)\";i:8;s:64:\"@media only screen and (min-width: 568px) and (max-width: 768px)\";i:9;s:64:\"@media only screen and (min-width: 320px) and (max-width: 568px)\";i:10;s:42:\"@media only screen and (max-width: 1279px)\";i:11;s:42:\"@media only screen and (max-width: 1280px)\";i:12;s:41:\"@media only screen and (min-width: 768px)\";i:13;s:42:\"@media only screen and (min-width: 1280px)\";i:14;s:94:\"@media only screen and (min-width: 768px) and (max-width: 1024px) and (orientation: landscape)\";i:15;s:64:\"@media only screen and (min-width: 768px) and (max-width: 959px)\";i:16;s:41:\"@media only screen and (max-width: 767px)\";i:17;s:64:\"@media only screen and (min-width: 480px) and (max-width: 767px)\";i:18;s:41:\"@media only screen and (max-width: 479px)\";i:19;s:37:\"@media screen and (max-width: 1024px)\";i:20;s:36:\"@media screen and (max-width: 959px)\";i:21;s:36:\"@media screen and (max-width: 767px)\";i:22;s:36:\"@media screen and (max-width: 479px)\";i:23;s:4:\"base\";}", "no");
INSERT INTO `wp_options` VALUES("1493", "ms_child_theme_editor_dict_rule", "a:136:{i:1;s:7:\"display\";i:2;s:10:\"text-align\";i:3;s:10:\"visibility\";i:4;s:7:\"z-index\";i:5;s:8:\"position\";i:6;s:6:\"bottom\";i:7;s:4:\"left\";i:8;s:5:\"width\";i:9;s:7:\"opacity\";i:10;s:16:\"background-color\";i:11;s:12:\"padding-left\";i:12;s:13:\"padding-right\";i:13;s:3:\"top\";i:14;s:6:\"height\";i:15;s:10:\"box-shadow\";i:16;s:9:\"max-width\";i:17;s:5:\"right\";i:18;s:8:\"overflow\";i:19;s:10:\"margin-top\";i:20;s:12:\"margin-right\";i:21;s:13:\"margin-bottom\";i:22;s:11:\"margin-left\";i:23;s:11:\"padding-top\";i:24;s:14:\"padding-bottom\";i:25;s:9:\"min-width\";i:26;s:10:\"border-top\";i:27;s:9:\"font-size\";i:28;s:5:\"float\";i:29;s:5:\"clear\";i:30;s:9:\"transform\";i:31;s:4:\"flex\";i:32;s:11:\"line-height\";i:33;s:13:\"border-radius\";i:34;s:12:\"border-color\";i:35;s:19:\"border-bottom-width\";i:36;s:7:\"content\";i:37;s:10:\"min-height\";i:38;s:6:\"border\";i:39;s:7:\"outline\";i:40;s:11:\"font-family\";i:41;s:14:\"vertical-align\";i:42;s:10:\"font-style\";i:43;s:11:\"font-weight\";i:44;s:10:\"overflow-y\";i:45;s:24:\"-webkit-text-size-adjust\";i:46;s:20:\"-ms-text-size-adjust\";i:47;s:10:\"list-style\";i:48;s:15:\"border-collapse\";i:49;s:14:\"border-spacing\";i:50;s:6:\"quotes\";i:51;s:22:\"-ms-interpolation-mode\";i:52;s:4:\"clip\";i:53;s:5:\"color\";i:54;s:15:\"text-decoration\";i:55;s:10:\"transition\";i:56;s:4:\"zoom\";i:57;s:14:\"font-smoothing\";i:58;s:23:\"-moz-osx-font-smoothing\";i:59;s:12:\"column-count\";i:60;s:10:\"column-gap\";i:61;s:19:\"-webkit-column-rule\";i:62;s:16:\"-moz-column-rule\";i:63;s:11:\"column-rule\";i:64;s:16:\"background-image\";i:65;s:17:\"background-repeat\";i:66;s:19:\"background-position\";i:67;s:11:\"text-shadow\";i:68;s:12:\"border-width\";i:69;s:11:\"white-space\";i:70;s:9:\"word-wrap\";i:71;s:11:\"border-left\";i:72;s:18:\"-webkit-appearance\";i:73;s:15:\"-moz-appearance\";i:74;s:10:\"appearance\";i:75;s:6:\"cursor\";i:76;s:13:\"border-bottom\";i:77;s:10:\"max-height\";i:78;s:10:\"box-sizing\";i:79;s:21:\"-webkit-touch-callout\";i:80;s:19:\"-webkit-user-select\";i:81;s:16:\"-moz-user-select\";i:82;s:15:\"-ms-user-select\";i:83;s:11:\"user-select\";i:84;s:23:\"-webkit-background-size\";i:85;s:20:\"-moz-background-size\";i:86;s:18:\"-o-background-size\";i:87;s:15:\"background-size\";i:88;s:21:\"background-attachment\";i:89;s:6:\"filter\";i:90;s:14:\"-webkit-filter\";i:91;s:27:\"-webkit-backface-visibility\";i:92;s:19:\"-webkit-perspective\";i:93;s:24:\"-moz-backface-visibility\";i:94;s:23:\"-ms-backface-visibility\";i:95;s:19:\"backface-visibility\";i:96;s:11:\"-moz-filter\";i:97;s:9:\"-o-filter\";i:98;s:10:\"-ms-filter\";i:99;s:14:\"text-transform\";i:100;s:14:\"letter-spacing\";i:101;s:19:\"transition-duration\";i:102;s:18:\"-khtml-user-select\";i:103;s:19:\"border-bottom-color\";i:104;s:12:\"border-right\";i:105;s:23:\"border-top-right-radius\";i:106;s:26:\"border-bottom-right-radius\";i:107;s:22:\"border-top-left-radius\";i:108;s:25:\"border-bottom-left-radius\";i:109;s:13:\"overflow-wrap\";i:110;s:9:\"direction\";i:111;s:16:\"transform-origin\";i:112;s:15:\"justify-content\";i:113;s:11:\"align-items\";i:114;s:5:\"order\";i:115;s:10:\"overflow-x\";i:116;s:26:\"-webkit-overflow-scrolling\";i:117;s:9:\"flex-grow\";i:118;s:12:\"border-style\";i:119;s:18:\"border-right-width\";i:120;s:13:\"text-overflow\";i:121;s:14:\"text-rendering\";i:122;s:15:\"list-style-type\";i:123;s:17:\"-webkit-animation\";i:124;s:9:\"animation\";i:125;s:16:\"border-top-color\";i:126;s:14:\"-moz-animation\";i:127;s:26:\"-webkit-animation-duration\";i:128;s:18:\"animation-duration\";i:129;s:27:\"-webkit-animation-fill-mode\";i:130;s:19:\"animation-fill-mode\";i:131;s:22:\"-webkit-animation-name\";i:132;s:14:\"animation-name\";i:133;s:27:\"-webkit-tap-highlight-color\";i:134;s:16:\"-ms-touch-action\";i:135;s:15:\"transform-style\";i:136;s:15:\"-mox-box-shadow\";}", "no");
INSERT INTO `wp_options` VALUES("1494", "ms_child_theme_editor_dict_val", "a:1342:{i:1;s:4:\"none\";i:2;s:6:\"center\";i:3;s:5:\"right\";i:4;s:4:\"left\";i:5;s:5:\"block\";i:6;s:6:\"hidden\";i:7;s:1:\"1\";i:8;s:5:\"fixed\";i:9;s:1:\"0\";i:10;s:4:\"100%\";i:11;s:8:\"relative\";i:12;s:1:\"2\";i:13;s:4:\"#fff\";i:14;s:5:\"280px\";i:15;s:8:\"absolute\";i:16;s:2:\"99\";i:17;s:23:\"0 0 7px rgba(0,0,0,0.1)\";i:18;s:4:\"auto\";i:19;s:7:\"visible\";i:20;s:4:\"32px\";i:21;s:4:\"30px\";i:22;s:5:\"180px\";i:23;s:4:\"20px\";i:24;s:4:\"14px\";i:25;s:4:\"40px\";i:26;s:4:\"both\";i:27;s:12:\"inline-block\";i:28;s:6:\"inline\";i:29;s:4:\"50px\";i:30;s:7:\"1000200\";i:31;s:4:\"18px\";i:32;s:5:\"-45px\";i:33;s:4:\"flex\";i:34;s:4:\"38px\";i:35;s:5:\"0.4em\";i:36;s:4:\"#ddd\";i:37;s:4:\"16px\";i:38;s:3:\"9px\";i:39;s:7:\"\"\\f104\"\";i:40;s:4:\"25px\";i:41;s:4:\"12px\";i:42;s:3:\"70%\";i:43;s:3:\"26%\";i:44;s:7:\"inherit\";i:45;s:3:\"50%\";i:46;s:5:\"1.5em\";i:47;s:4:\"10px\";i:48;s:5:\"150px\";i:49;s:7:\"1.846em\";i:50;s:7:\"1.077em\";i:51;s:3:\"5px\";i:52;s:6:\".769em\";i:53;s:3:\"23%\";i:54;s:4:\"13px\";i:55;s:7:\"33.333%\";i:56;s:3:\"25%\";i:57;s:3:\"20%\";i:58;s:7:\"16.667%\";i:59;s:7:\"14.286%\";i:60;s:8:\"baseline\";i:61;s:5:\"62.5%\";i:62;s:6:\"scroll\";i:63;s:8:\"collapse\";i:64;s:6:\"normal\";i:65;s:2:\"\'\'\";i:66;s:7:\"bicubic\";i:67;s:24:\"rect(1px, 1px, 1px, 1px)\";i:68;s:3:\"1px\";i:69;s:7:\"#f1f1f1\";i:70;s:3:\"3px\";i:71;s:27:\"0 0 2px 2px rgba(0,0,0,0.6)\";i:72;s:7:\"#21759b\";i:73;s:8:\"0.875rem\";i:74;s:4:\"bold\";i:75;s:4:\"15px\";i:76;s:4:\"23px\";i:77;s:6:\"100000\";i:78;s:3:\"8px\";i:79;s:5:\"-46px\";i:80;s:9:\"all 0.25s\";i:81;s:7:\"#2c87f0\";i:82;s:3:\"700\";i:83;s:4:\"46px\";i:84;s:28:\"0 0 2px 2px rgba(0,0,0,0.15)\";i:85;s:11:\"thin dotted\";i:86;s:9:\"underline\";i:87;s:33:\"\"Helvetica Neue\",Arial,sans-serif\";i:88;s:4:\"1.65\";i:89;s:4:\"#666\";i:90;s:5:\"980px\";i:91;s:3:\"90%\";i:92;s:5:\"-15px\";i:93;s:3:\"69%\";i:94;s:6:\"1040px\";i:95;s:26:\"0 1px 4px rgba(0,0,0,0.25)\";i:96;s:4:\"1002\";i:97;s:2:\"\"\"\";i:98;s:5:\"-10px\";i:99;s:6:\"33.33%\";i:100;s:12:\"16.66666667%\";i:101;s:6:\"14.28%\";i:102;s:4:\"-1px\";i:103;s:5:\"0.5px\";i:104;s:6:\"-2.5px\";i:105;s:5:\"2.5px\";i:106;s:4:\"-5px\";i:107;s:6:\"-7.5px\";i:108;s:5:\"7.5px\";i:109;s:7:\"-12.5px\";i:110;s:6:\"12.5px\";i:111;s:7:\"-17.5px\";i:112;s:6:\"17.5px\";i:113;s:4:\"35px\";i:114;s:5:\"-20px\";i:115;s:5:\"-25px\";i:116;s:5:\"-30px\";i:117;s:4:\"60px\";i:118;s:8:\"16.6666%\";i:119;s:5:\"33.3%\";i:120;s:6:\"16.66%\";i:121;s:11:\"antialiased\";i:122;s:9:\"grayscale\";i:123;s:6:\"italic\";i:124;s:3:\"600\";i:125;s:4:\"#000\";i:126;s:3:\"80%\";i:127;s:7:\"1.313em\";i:128;s:4:\"27px\";i:129;s:4:\"#777\";i:130;s:3:\"1.5\";i:131;s:6:\"-0.4em\";i:132;s:7:\"1.231em\";i:133;s:7:\"1.385em\";i:134;s:7:\"1.615em\";i:135;s:4:\"21px\";i:136;s:7:\"1.500em\";i:137;s:7:\"1.125em\";i:138;s:3:\"1em\";i:139;s:7:\"0.875em\";i:140;s:7:\"0.750em\";i:141;s:3:\"3em\";i:142;s:17:\"1px solid #e5e5e5\";i:143;s:3:\"300\";i:144;s:30:\"url(./assets/images/quote.png)\";i:145;s:9:\"no-repeat\";i:146;s:8:\"left 4px\";i:147;s:4:\"55px\";i:148;s:7:\"#ababab\";i:149;s:3:\"33%\";i:150;s:21:\"rgba(255,255,255,0.8)\";i:151;s:26:\"0 0 0.25em rgba(0,0,0,0.6)\";i:152;s:3:\"100\";i:153;s:3:\"200\";i:154;s:3:\"500\";i:155;s:3:\"800\";i:156;s:3:\"900\";i:157;s:4:\"disc\";i:158;s:7:\"decimal\";i:159;s:8:\"\"ticons\"\";i:160;s:7:\"\"\\f00c\"\";i:161;s:3:\"0.6\";i:162;s:13:\"solid #e8e8e8\";i:163;s:7:\"1px 0 0\";i:164;s:7:\"2.308em\";i:165;s:7:\"#f7f7f7\";i:166;s:24:\"Monaco, monospace, serif\";i:167;s:8:\"pre-wrap\";i:168;s:13:\"-moz-pre-wrap\";i:169;s:9:\"-pre-wrap\";i:170;s:11:\"-o-pre-wrap\";i:171;s:10:\"break-word\";i:172;s:17:\"3px solid #7b7b7b\";i:173;s:6:\".923em\";i:174;s:7:\"3.231em\";i:175;s:6:\"yellow\";i:176;s:5:\"black\";i:177;s:6:\".462em\";i:178;s:17:\"1px solid #e1e1e1\";i:179;s:7:\"#e1e1e1\";i:180;s:17:\"1px solid #e8e8e8\";i:181;s:8:\"0.4375em\";i:182;s:26:\"0 0 0 1000px #f7f7f7 inset\";i:183;s:23:\"0 0 0 1000px #fff inset\";i:184;s:3:\"0.7\";i:185;s:14:\"1px solid #eee\";i:186;s:3:\"68%\";i:187;s:3:\"30%\";i:188;s:3:\"4px\";i:189;s:11:\"transparent\";i:190;s:4:\"36px\";i:191;s:7:\"pointer\";i:192;s:22:\"rgba(255,255,255,0.03)\";i:193;s:23:\"rgba(255,255,255,0.035)\";i:194;s:4:\"#f00\";i:195;s:5:\"1.2em\";i:196;s:7:\"#edfdd3\";i:197;s:17:\"1px solid #c4dba0\";i:198;s:7:\"#657e3c\";i:199;s:7:\"0.923em\";i:200;s:7:\"#c4690e\";i:201;s:7:\"#fffdf3\";i:202;s:17:\"1px solid #fad7b5\";i:203;s:7:\"#ffe9e9\";i:204;s:7:\"#d04544\";i:205;s:17:\"1px solid #e7a9a9\";i:206;s:4:\"#555\";i:207;s:3:\"0.8\";i:208;s:14:\"3px solid #fff\";i:209;s:13:\"1px solid red\";i:210;s:4:\"#444\";i:211;s:4:\"#888\";i:212;s:14:\"1px solid #ddd\";i:213;s:4:\"#999\";i:214;s:7:\"#f9f9f9\";i:215;s:7:\"#536570\";i:216;s:17:\"1px solid #d4dbe0\";i:217;s:33:\"inset 0 1px 1px rgba(0,0,0,0.072)\";i:218;s:8:\"all .15s\";i:219;s:17:\"1px solid #66afe9\";i:220;s:7:\"\"\\f078\"\";i:221;s:3:\"red\";i:222;s:23:\"0 0 0 1000px #000 inset\";i:223;s:14:\"3px solid #000\";i:224;s:5:\"0.9em\";i:225;s:25:\"0 1px 3px rgba(0,0,0,0.1)\";i:226;s:21:\"1px solid transparent\";i:227;s:4:\"#ccc\";i:228;s:25:\"0 1px 2px rgba(0,0,0,0.1)\";i:229;s:4:\"#333\";i:230;s:7:\"#4d4d4d\";i:231;s:6:\".538em\";i:232;s:3:\"400\";i:233;s:14:\"0.15s all ease\";i:234;s:7:\"#1175e9\";i:235;s:22:\"0 -1px rgba(0,0,0,0.4)\";i:236;s:26:\"1px solid rgba(0,0,0,0.15)\";i:237;s:71:\"inset 0 1px 1px rgba(255,255,255,0.3),0 1px 3px -1px rgba(45,60,72,0.5)\";i:238;s:32:\"0 2px 2px rgba(0,0,0,0.25) inset\";i:239;s:26:\"4px solid rgba(0,0,0,0.25)\";i:240;s:3:\"2px\";i:241;s:7:\"#4a97c2\";i:242;s:7:\"#327397\";i:243;s:4:\"#bbb\";i:244;s:7:\"#ee7836\";i:245;s:7:\"#cf5511\";i:246;s:4:\"#fa3\";i:247;s:7:\"#ff9500\";i:248;s:7:\"#87bf17\";i:249;s:7:\"#679212\";i:250;s:7:\"#9a5e9a\";i:251;s:7:\"#653e65\";i:252;s:7:\"#00b3b3\";i:253;s:7:\"#006f6f\";i:254;s:7:\"#f261c2\";i:255;s:7:\"#bc0f83\";i:256;s:7:\"#804b35\";i:257;s:7:\"#5c3626\";i:258;s:7:\"#f73936\";i:259;s:7:\"#bf0a08\";i:260;s:7:\"#ea2487\";i:261;s:7:\"#b81265\";i:262;s:3:\".85\";i:263;s:14:\"3px solid #eee\";i:264;s:7:\"#3f90bd\";i:265;s:27:\"bottom:#f6f6f6:0%:#fff:100%\";i:266;s:32:\"0 1px 1px rgba(180,180,180,0.13)\";i:267;s:31:\"0 1px 2px rgba(0,0,0,0.1) inset\";i:268;s:7:\"#009191\";i:269;s:7:\"0.769em\";i:270;s:7:\"2.571em\";i:271;s:6:\"0 none\";i:272;s:5:\"200px\";i:273;s:17:\"0 0 0 transparent\";i:274;s:4:\"19px\";i:275;s:7:\"default\";i:276;s:7:\"0.846em\";i:277;s:3:\"top\";i:278;s:24:\"1px 1px rgba(0,0,0,0.25)\";i:279;s:4:\"22px\";i:280;s:11:\"content-box\";i:281;s:17:\"all 0.2s ease-out\";i:282;s:4:\"-7px\";i:283;s:42:\"rotatez(-45deg) translate(-4.95px, 4.95px)\";i:284;s:42:\"rotatez(45deg) translate(-4.95px, -4.95px)\";i:285;s:7:\"#00529b\";i:286;s:7:\"#bde5f8\";i:287;s:3:\"\' \'\";i:288;s:2:\"-1\";i:289;s:5:\"0.5em\";i:290;s:3:\"10%\";i:291;s:3:\"40%\";i:292;s:3:\"60%\";i:293;s:9:\"all 0.35s\";i:294;s:13:\"center center\";i:295;s:5:\"cover\";i:296;s:6:\"repeat\";i:297;s:8:\"repeat-x\";i:298;s:8:\"repeat-y\";i:299;s:10:\"center top\";i:300;s:13:\"center bottom\";i:301;s:4:\"#aaa\";i:302;s:4:\".4em\";i:303;s:3:\"56%\";i:304;s:12:\"opacity 0.4s\";i:305;s:243:\"url(\"data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\'><filter id=\'grayscale\'><feColorMatrix type=\'matrix\' values=\'0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0\'/></filter></svg>#grayscale\")\";i:306;s:15:\"grayscale(100%)\";i:307;s:4:\"gray\";i:308;s:13:\"translateZ(0)\";i:309;s:4:\"1000\";i:310;s:14:\"all 0.25s ease\";i:311;s:201:\"url(\"data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\'><filter id=\'grayscale\'><feColorMatrix type=\'matrix\' values=\'1 0 0 0 0, 0 1 0 0 0, 0 0 1 0 0, 0 0 0 1 0\'/></filter></svg>#grayscale\")\";i:312;s:13:\"grayscale(0%)\";i:313;s:25:\"0 1px 5px rgba(0,0,0,0.2)\";i:314;s:20:\"translate3d(0, 0, 0)\";i:315;s:6:\"bottom\";i:316;s:6:\"static\";i:317;s:35:\"all 1.5s cubic-bezier(0, 0, 0.2, 1)\";i:318;s:22:\"scale3d(1.2, 1.2, 1.2)\";i:319;s:10:\"scale(0.8)\";i:320;s:4:\"-11%\";i:321;s:10:\"scale(1.2)\";i:322;s:4:\"-10%\";i:323;s:14:\"rotate(-10deg)\";i:324;s:9:\"blur(3px)\";i:325;s:7:\"blur(0)\";i:326;s:11:\"sepia(100%)\";i:327;s:27:\"background 0.2s ease-in-out\";i:328;s:5:\"99999\";i:329;s:16:\"rgba(0,0,0,0.92)\";i:330;s:21:\"all 0.25s ease-in-out\";i:331;s:5:\"700px\";i:332;s:28:\"scale(0.85) translateY(-50%)\";i:333;s:25:\"scale(1) translateY(-50%)\";i:334;s:4:\"80px\";i:335;s:31:\"\"Times New Roman\", Times, serif\";i:336;s:4:\"64px\";i:337;s:2:\".2\";i:338;s:8:\"all 0.3s\";i:339;s:7:\"1.154em\";i:340;s:7:\"1.333em\";i:341;s:14:\"solid 1px #eee\";i:342;s:6:\"9999px\";i:343;s:3:\"6px\";i:344;s:21:\"2px solid transparent\";i:345;s:83:\"apple-system,BlinkMacSystemFont,\"Segoe UI\",Roboto,\"Helvetica Neue\",Arial,sans-serif\";i:346;s:26:\"3px solid rgba(0,0,0,0.25)\";i:347;s:25:\"1px solid rgba(0,0,0,0.1)\";i:348;s:37:\"inset 0 1px 1px rgba(255,255,255,0.4)\";i:349;s:14:\"2px solid #bbb\";i:350;s:13:\"rotate(10deg)\";i:351;s:7:\"#00aced\";i:352;s:7:\"#3b5998\";i:353;s:7:\"#dd4b39\";i:354;s:7:\"#589442\";i:355;s:7:\"#cb2027\";i:356;s:7:\"#d5641c\";i:357;s:7:\"#4875b4\";i:358;s:7:\"#ef5b93\";i:359;s:7:\"#04b1f5\";i:360;s:7:\"#305777\";i:361;s:7:\"#ff0084\";i:362;s:7:\"#55779b\";i:363;s:7:\"#0cbadf\";i:364;s:7:\"#2c4762\";i:365;s:7:\"#2970ad\";i:366;s:7:\"#026466\";i:367;s:7:\"#1ab7ea\";i:368;s:7:\"#c4302b\";i:369;s:7:\"#ff7900\";i:370;s:7:\"#00b386\";i:371;s:7:\"#ffc548\";i:372;s:7:\"#3395ff\";i:373;s:7:\"#af0605\";i:374;s:7:\"#7cc04b\";i:375;s:7:\"#0dc143\";i:376;s:7:\"#1db954\";i:377;s:7:\"#6441a5\";i:378;s:7:\"#a82400\";i:379;s:3:\".65\";i:380;s:39:\"url(./assets/images/dotted-overlay.png)\";i:381;s:39:\"url(./assets/images/dashed-overlay.png)\";i:382;s:5:\"50% 0\";i:383;s:5:\"table\";i:384;s:6:\"middle\";i:385;s:10:\"table-cell\";i:386;s:9:\"uppercase\";i:387;s:15:\"rgba(0,0,0,0.5)\";i:388;s:6:\"0.2rem\";i:389;s:16:\"background 0.25s\";i:390;s:15:\"rgba(0,0,0,0.3)\";i:391;s:3:\"18%\";i:392;s:15:\"rgba(0,0,0,0.7)\";i:393;s:37:\"url(./assets/images/overlay-plus.png)\";i:394;s:15:\"rgba(0,0,0,0.8)\";i:395;s:15:\"rgba(0,0,0,0.6)\";i:396;s:5:\"1.6em\";i:397;s:21:\"all 0.15s ease-in-out\";i:398;s:16:\"rgba(0,0,0,0.65)\";i:399;s:25:\"opacity 0.25s ease-in-out\";i:400;s:14:\"2px solid #fff\";i:401;s:20:\"all 0.2s ease-in-out\";i:402;s:4:\"-2px\";i:403;s:20:\"all .25s ease-in-out\";i:404;s:16:\"all 0.15s linear\";i:405;s:10:\"scale(1.3)\";i:406;s:6:\"-100px\";i:407;s:9:\"0.35s all\";i:408;s:2:\"10\";i:409;s:7:\"0.308em\";i:410;s:7:\"0.615em\";i:411;s:9:\"0.15s all\";i:412;s:21:\"rgba(255,255,255,0.5)\";i:413;s:20:\"all 0.3s ease-in-out\";i:414;s:4:\"0.6s\";i:415;s:7:\"4.615em\";i:416;s:7:\"1.538em\";i:417;s:1:\"3\";i:418;s:1:\"4\";i:419;s:39:\"top:transparent:0%:rgba(0,0,0,0.6):100%\";i:420;s:9:\"0.25s all\";i:421;s:3:\"0.9\";i:422;s:4:\"0.95\";i:423;s:5:\"800px\";i:424;s:3:\"1.2\";i:425;s:18:\"rgba(30,30,30,0.6)\";i:426;s:4:\"34px\";i:427;s:7:\"\"\\f105\"\";i:428;s:3:\".75\";i:429;s:8:\"33.3333%\";i:430;s:48:\"url(./assets/images/carousel-video-play-btn.png)\";i:431;s:5:\"300px\";i:432;s:4:\"11px\";i:433;s:5:\"-60px\";i:434;s:7:\"\"\\f0a8\"\";i:435;s:7:\"\"\\f0a9\"\";i:436;s:14:\"2px solid #ccc\";i:437;s:4:\"24px\";i:438;s:7:\"#bcbcbc\";i:439;s:5:\"-16px\";i:440;s:3:\"48%\";i:441;s:6:\".615em\";i:442;s:11:\"text-bottom\";i:443;s:3:\"0.4\";i:444;s:6:\".846em\";i:445;s:5:\"110px\";i:446;s:4:\"94px\";i:447;s:4:\"70px\";i:448;s:17:\"1px solid #e4e4e4\";i:449;s:3:\"7px\";i:450;s:12:\"line-through\";i:451;s:4:\"#eee\";i:452;s:1:\"9\";i:453;s:4:\"45px\";i:454;s:16:\"translateY(-50%)\";i:455;s:4:\"9999\";i:456;s:17:\"margin 0.25s ease\";i:457;s:6:\".385em\";i:458;s:7:\"#0093cb\";i:459;s:7:\"#324b80\";i:460;s:7:\"#ae1b21\";i:461;s:7:\"#d03724\";i:462;s:7:\"#3e659c\";i:463;s:7:\"0.462em\";i:464;s:7:\"1.692em\";i:465;s:14:\"2px solid #eee\";i:466;s:13:\"all 0.2s ease\";i:467;s:4:\"99px\";i:468;s:5:\"-70px\";i:469;s:3:\"49%\";i:470;s:7:\"#484848\";i:471;s:6:\".692em\";i:472;s:4:\"-4px\";i:473;s:7:\"#d75440\";i:474;s:17:\"2px solid #2c87f0\";i:475;s:42:\"opacity .25s ease, visibility 0s ease .25s\";i:476;s:37:\"url(assets/cursors/close.ico),default\";i:477;s:87:\"-webkit-image-set(url(assets/cursors/close.ico) 1x, url(assets/cursors/close2x.ico) 2x)\";i:478;s:3:\"ltr\";i:479;s:18:\"calc(100% + 1.3px)\";i:480;s:16:\"translateX(-50%)\";i:481;s:13:\"rotateY(0deg)\";i:482;s:14:\"rotate(180deg)\";i:483;s:32:\"translateX(-50%) rotateY(180deg)\";i:484;s:3:\"998\";i:485;s:24:\"0 0 6px rgba(0,0,0,0.25)\";i:486;s:5:\"10001\";i:487;s:22:\"20px solid transparent\";i:488;s:18:\"20px solid #252525\";i:489;s:5:\"10002\";i:490;s:5:\"-11px\";i:491;s:13:\"space-between\";i:492;s:3:\"999\";i:493;s:4:\"26px\";i:494;s:4:\"#222\";i:495;s:52:\"background-color 0.15s ease, border-color 0.15s ease\";i:496;s:25:\"0 2px 7px rgba(0,0,0,0.1)\";i:497;s:5:\"1.4em\";i:498;s:53:\"background 0.15s ease-in-out, color 0.15s ease-in-out\";i:499;s:14:\"all 0.15s ease\";i:500;s:17:\"translateY(-100%)\";i:501;s:52:\"transform .25s ease-in-out, opacity .15s ease-in-out\";i:502;s:14:\"translateY(0%)\";i:503;s:4:\"1001\";i:504;s:25:\"0 2px 5px rgba(0,0,0,0.1)\";i:505;s:12:\"opacity 0.3s\";i:506;s:15:\"all 0.3s linear\";i:507;s:15:\"top 0.3s linear\";i:508;s:5:\"160px\";i:509;s:5:\"0.8em\";i:510;s:13:\"all 0.3s ease\";i:511;s:14:\"all 0.35s ease\";i:512;s:5:\"750px\";i:513;s:4:\"-3px\";i:514;s:4:\"-8px\";i:515;s:6:\"999999\";i:516;s:5:\"320px\";i:517;s:7:\"#262626\";i:518;s:7:\"#707070\";i:519;s:5:\"touch\";i:520;s:6:\"-320px\";i:521;s:33:\"1px solid rgba(255,255,255,0.035)\";i:522;s:22:\"rgba(255,255,255,0.02)\";i:523;s:5:\"0.7em\";i:524;s:3:\"\"-\"\";i:525;s:4:\"\"--\"\";i:526;s:13:\"rotate(90deg)\";i:527;s:6:\"1.25em\";i:528;s:5:\"500px\";i:529;s:5:\"\"---\"\";i:530;s:4:\"42px\";i:531;s:8:\"all 0.4s\";i:532;s:3:\"0.3\";i:533;s:22:\"rgba(255,255,255,0.95)\";i:534;s:16:\"rgba(0,0,0,0.98)\";i:535;s:5:\"350px\";i:536;s:6:\"0.85em\";i:537;s:15:\"all 0.4s linear\";i:538;s:21:\"7px solid transparent\";i:539;s:14:\"7px solid #ddd\";i:540;s:16:\"rgba(0,0,0,0.15)\";i:541;s:4:\"-6px\";i:542;s:21:\"6px solid transparent\";i:543;s:14:\"6px solid #fff\";i:544;s:26:\"0 3px 10px rgba(0,0,0,0.1)\";i:545;s:23:\"0 3px 0 rgba(0,0,0,0.1)\";i:546;s:25:\"0 2px 3px rgba(0,0,0,0.4)\";i:547;s:29:\"0 5px 11px 0 rgba(0,0,0,0.24)\";i:548;s:21:\"3px solid transparent\";i:549;s:7:\"#909090\";i:550;s:7:\"#252525\";i:551;s:6:\"1.03em\";i:552;s:8:\"\'ticons\'\";i:553;s:20:\"background 0.3s ease\";i:554;s:2:\".5\";i:555;s:5:\"400px\";i:556;s:3:\"46%\";i:557;s:7:\"\"\\f016\"\";i:558;s:7:\"\"\\f0f6\"\";i:559;s:7:\"\"\\f0e5\"\";i:560;s:7:\"\"\\f0da\"\";i:561;s:7:\"\"\\f114\"\";i:562;s:7:\"#787878\";i:563;s:7:\"1.182em\";i:564;s:22:\"rgba(255,255,255,0.06)\";i:565;s:5:\"\"- -\"\";i:566;s:7:\"\"\\f054\"\";i:567;s:3:\"22%\";i:568;s:2:\"2%\";i:569;s:5:\"0.6em\";i:570;s:7:\"#fafafa\";i:571;s:7:\"\"\\f053\"\";i:572;s:15:\"rgba(0,0,0,0.1)\";i:573;s:22:\"rgba(255,255,255,0.08)\";i:574;s:5:\"solid\";i:575;s:7:\"#585858\";i:576;s:6:\"nowrap\";i:577;s:8:\"ellipsis\";i:578;s:4:\"62px\";i:579;s:4:\"65px\";i:580;s:15:\"rgba(0,0,0,0.4)\";i:581;s:8:\"all 0.2s\";i:582;s:4:\"0.15\";i:583;s:5:\"100px\";i:584;s:4:\"74px\";i:585;s:16:\"rgba(0,0,0,0.75)\";i:586;s:5:\"1.7em\";i:587;s:2:\".1\";i:588;s:3:\"45%\";i:589;s:3:\"55%\";i:590;s:5:\"-12px\";i:591;s:22:\"12px solid transparent\";i:592;s:18:\"12px solid #f7f7f7\";i:593;s:7:\"#ffc833\";i:594;s:12:\"right center\";i:595;s:4:\".7em\";i:596;s:4:\".8em\";i:597;s:31:\"3px solid rgba(255,255,255,0.2)\";i:598;s:5:\"-35px\";i:599;s:21:\"rgba(255,255,255,0.3)\";i:600;s:5:\"10000\";i:601;s:5:\"260px\";i:602;s:7:\"#f4f4f4\";i:603;s:4:\"28px\";i:604;s:46:\"Times New Roman, Times New Roman, Times, serif\";i:605;s:15:\"color 0.2s ease\";i:606;s:3:\"75%\";i:607;s:7:\"0.889em\";i:608;s:20:\"normal 14px/1 ticons\";i:609;s:12:\"1.33333333em\";i:610;s:6:\"0.75em\";i:611;s:4:\"-15%\";i:612;s:3:\"2em\";i:613;s:3:\"4em\";i:614;s:3:\"5em\";i:615;s:12:\"1.28571429em\";i:616;s:12:\"2.14285714em\";i:617;s:13:\"-2.14285714em\";i:618;s:12:\"0.14285714em\";i:619;s:13:\"-1.85714286em\";i:620;s:4:\".2em\";i:621;s:5:\".25em\";i:622;s:5:\".15em\";i:623;s:17:\"solid 0.08em #eee\";i:624;s:4:\".1em\";i:625;s:4:\".3em\";i:626;s:29:\"ticon-spin 2s infinite linear\";i:627;s:31:\"ticon-spin 1s infinite steps(8)\";i:628;s:58:\"\"progid:DXImageTransform.Microsoft.BasicImage(rotation=1)\"\";i:629;s:58:\"\"progid:DXImageTransform.Microsoft.BasicImage(rotation=2)\"\";i:630;s:58:\"\"progid:DXImageTransform.Microsoft.BasicImage(rotation=3)\"\";i:631;s:14:\"rotate(270deg)\";i:632;s:68:\"\"progid:DXImageTransform.Microsoft.BasicImage(rotation=0, mirror=1)\"\";i:633;s:12:\"scale(-1, 1)\";i:634;s:68:\"\"progid:DXImageTransform.Microsoft.BasicImage(rotation=2, mirror=1)\"\";i:635;s:12:\"scale(1, -1)\";i:636;s:7:\"\"\\f000\"\";i:637;s:7:\"\"\\f001\"\";i:638;s:7:\"\"\\f002\"\";i:639;s:7:\"\"\\f003\"\";i:640;s:7:\"\"\\f004\"\";i:641;s:7:\"\"\\f005\"\";i:642;s:7:\"\"\\f006\"\";i:643;s:7:\"\"\\f007\"\";i:644;s:7:\"\"\\f008\"\";i:645;s:7:\"\"\\f009\"\";i:646;s:7:\"\"\\f00a\"\";i:647;s:7:\"\"\\f00b\"\";i:648;s:7:\"\"\\f00d\"\";i:649;s:7:\"\"\\f00e\"\";i:650;s:7:\"\"\\f010\"\";i:651;s:7:\"\"\\f011\"\";i:652;s:7:\"\"\\f012\"\";i:653;s:7:\"\"\\f013\"\";i:654;s:7:\"\"\\f014\"\";i:655;s:7:\"\"\\f015\"\";i:656;s:7:\"\"\\f017\"\";i:657;s:7:\"\"\\f018\"\";i:658;s:7:\"\"\\f019\"\";i:659;s:7:\"\"\\f01a\"\";i:660;s:7:\"\"\\f01b\"\";i:661;s:7:\"\"\\f01c\"\";i:662;s:7:\"\"\\f01d\"\";i:663;s:7:\"\"\\f01e\"\";i:664;s:7:\"\"\\f021\"\";i:665;s:7:\"\"\\f022\"\";i:666;s:7:\"\"\\f023\"\";i:667;s:7:\"\"\\f024\"\";i:668;s:7:\"\"\\f025\"\";i:669;s:7:\"\"\\f026\"\";i:670;s:7:\"\"\\f027\"\";i:671;s:7:\"\"\\f028\"\";i:672;s:7:\"\"\\f029\"\";i:673;s:7:\"\"\\f02a\"\";i:674;s:7:\"\"\\f02b\"\";i:675;s:7:\"\"\\f02c\"\";i:676;s:7:\"\"\\f02d\"\";i:677;s:7:\"\"\\f02e\"\";i:678;s:7:\"\"\\f02f\"\";i:679;s:7:\"\"\\f030\"\";i:680;s:7:\"\"\\f031\"\";i:681;s:7:\"\"\\f032\"\";i:682;s:7:\"\"\\f033\"\";i:683;s:7:\"\"\\f034\"\";i:684;s:7:\"\"\\f035\"\";i:685;s:7:\"\"\\f036\"\";i:686;s:7:\"\"\\f037\"\";i:687;s:7:\"\"\\f038\"\";i:688;s:7:\"\"\\f039\"\";i:689;s:7:\"\"\\f03a\"\";i:690;s:7:\"\"\\f03b\"\";i:691;s:7:\"\"\\f03c\"\";i:692;s:7:\"\"\\f03d\"\";i:693;s:7:\"\"\\f03e\"\";i:694;s:7:\"\"\\f040\"\";i:695;s:7:\"\"\\f041\"\";i:696;s:7:\"\"\\f042\"\";i:697;s:7:\"\"\\f043\"\";i:698;s:7:\"\"\\f044\"\";i:699;s:7:\"\"\\f045\"\";i:700;s:7:\"\"\\f046\"\";i:701;s:7:\"\"\\f047\"\";i:702;s:7:\"\"\\f048\"\";i:703;s:7:\"\"\\f049\"\";i:704;s:7:\"\"\\f04a\"\";i:705;s:7:\"\"\\f04b\"\";i:706;s:7:\"\"\\f04c\"\";i:707;s:7:\"\"\\f04d\"\";i:708;s:7:\"\"\\f04e\"\";i:709;s:7:\"\"\\f050\"\";i:710;s:7:\"\"\\f051\"\";i:711;s:7:\"\"\\f052\"\";i:712;s:7:\"\"\\f055\"\";i:713;s:7:\"\"\\f056\"\";i:714;s:7:\"\"\\f057\"\";i:715;s:7:\"\"\\f058\"\";i:716;s:7:\"\"\\f059\"\";i:717;s:7:\"\"\\f05a\"\";i:718;s:7:\"\"\\f05b\"\";i:719;s:7:\"\"\\f05c\"\";i:720;s:7:\"\"\\f05d\"\";i:721;s:7:\"\"\\f05e\"\";i:722;s:7:\"\"\\f060\"\";i:723;s:7:\"\"\\f061\"\";i:724;s:7:\"\"\\f062\"\";i:725;s:7:\"\"\\f063\"\";i:726;s:7:\"\"\\f064\"\";i:727;s:7:\"\"\\f065\"\";i:728;s:7:\"\"\\f066\"\";i:729;s:7:\"\"\\f067\"\";i:730;s:7:\"\"\\f068\"\";i:731;s:7:\"\"\\f069\"\";i:732;s:7:\"\"\\f06a\"\";i:733;s:7:\"\"\\f06b\"\";i:734;s:7:\"\"\\f06c\"\";i:735;s:7:\"\"\\f06d\"\";i:736;s:7:\"\"\\f06e\"\";i:737;s:7:\"\"\\f070\"\";i:738;s:7:\"\"\\f071\"\";i:739;s:7:\"\"\\f072\"\";i:740;s:7:\"\"\\f073\"\";i:741;s:7:\"\"\\f074\"\";i:742;s:7:\"\"\\f075\"\";i:743;s:7:\"\"\\f076\"\";i:744;s:7:\"\"\\f077\"\";i:745;s:7:\"\"\\f079\"\";i:746;s:7:\"\"\\f07a\"\";i:747;s:7:\"\"\\f07b\"\";i:748;s:7:\"\"\\f07c\"\";i:749;s:7:\"\"\\f07d\"\";i:750;s:7:\"\"\\f07e\"\";i:751;s:7:\"\"\\f080\"\";i:752;s:7:\"\"\\f081\"\";i:753;s:7:\"\"\\f082\"\";i:754;s:7:\"\"\\f083\"\";i:755;s:7:\"\"\\f084\"\";i:756;s:7:\"\"\\f085\"\";i:757;s:7:\"\"\\f086\"\";i:758;s:7:\"\"\\f087\"\";i:759;s:7:\"\"\\f088\"\";i:760;s:7:\"\"\\f089\"\";i:761;s:7:\"\"\\f08a\"\";i:762;s:7:\"\"\\f08b\"\";i:763;s:7:\"\"\\f08c\"\";i:764;s:7:\"\"\\f08d\"\";i:765;s:7:\"\"\\f08e\"\";i:766;s:7:\"\"\\f090\"\";i:767;s:7:\"\"\\f091\"\";i:768;s:7:\"\"\\f092\"\";i:769;s:7:\"\"\\f093\"\";i:770;s:7:\"\"\\f094\"\";i:771;s:7:\"\"\\f095\"\";i:772;s:7:\"\"\\f096\"\";i:773;s:7:\"\"\\f097\"\";i:774;s:7:\"\"\\f098\"\";i:775;s:7:\"\"\\f099\"\";i:776;s:7:\"\"\\f09a\"\";i:777;s:7:\"\"\\f09b\"\";i:778;s:7:\"\"\\f09c\"\";i:779;s:7:\"\"\\f09d\"\";i:780;s:7:\"\"\\f09e\"\";i:781;s:7:\"\"\\f0a0\"\";i:782;s:7:\"\"\\f0a1\"\";i:783;s:7:\"\"\\f0f3\"\";i:784;s:7:\"\"\\f0a3\"\";i:785;s:7:\"\"\\f0a4\"\";i:786;s:7:\"\"\\f0a5\"\";i:787;s:7:\"\"\\f0a6\"\";i:788;s:7:\"\"\\f0a7\"\";i:789;s:7:\"\"\\f0aa\"\";i:790;s:7:\"\"\\f0ab\"\";i:791;s:7:\"\"\\f0ac\"\";i:792;s:7:\"\"\\f0ad\"\";i:793;s:7:\"\"\\f0ae\"\";i:794;s:7:\"\"\\f0b0\"\";i:795;s:7:\"\"\\f0b1\"\";i:796;s:7:\"\"\\f0b2\"\";i:797;s:7:\"\"\\f0c0\"\";i:798;s:7:\"\"\\f0c1\"\";i:799;s:7:\"\"\\f0c2\"\";i:800;s:7:\"\"\\f0c3\"\";i:801;s:7:\"\"\\f0c4\"\";i:802;s:7:\"\"\\f0c5\"\";i:803;s:7:\"\"\\f0c6\"\";i:804;s:7:\"\"\\f0c7\"\";i:805;s:7:\"\"\\f0c8\"\";i:806;s:7:\"\"\\f0c9\"\";i:807;s:7:\"\"\\f0ca\"\";i:808;s:7:\"\"\\f0cb\"\";i:809;s:7:\"\"\\f0cc\"\";i:810;s:7:\"\"\\f0cd\"\";i:811;s:7:\"\"\\f0ce\"\";i:812;s:7:\"\"\\f0d0\"\";i:813;s:7:\"\"\\f0d1\"\";i:814;s:7:\"\"\\f0d2\"\";i:815;s:7:\"\"\\f0d3\"\";i:816;s:7:\"\"\\f0d4\"\";i:817;s:7:\"\"\\f0d5\"\";i:818;s:7:\"\"\\f0d6\"\";i:819;s:7:\"\"\\f0d7\"\";i:820;s:7:\"\"\\f0d8\"\";i:821;s:7:\"\"\\f0d9\"\";i:822;s:7:\"\"\\f0db\"\";i:823;s:7:\"\"\\f0dc\"\";i:824;s:7:\"\"\\f0dd\"\";i:825;s:7:\"\"\\f0de\"\";i:826;s:7:\"\"\\f0e0\"\";i:827;s:7:\"\"\\f0e1\"\";i:828;s:7:\"\"\\f0e2\"\";i:829;s:7:\"\"\\f0e3\"\";i:830;s:7:\"\"\\f0e4\"\";i:831;s:7:\"\"\\f0e6\"\";i:832;s:7:\"\"\\f0e7\"\";i:833;s:7:\"\"\\f0e8\"\";i:834;s:7:\"\"\\f0e9\"\";i:835;s:7:\"\"\\f0ea\"\";i:836;s:7:\"\"\\f0eb\"\";i:837;s:7:\"\"\\f0ec\"\";i:838;s:7:\"\"\\f0ed\"\";i:839;s:7:\"\"\\f0ee\"\";i:840;s:7:\"\"\\f0f0\"\";i:841;s:7:\"\"\\f0f1\"\";i:842;s:7:\"\"\\f0f2\"\";i:843;s:7:\"\"\\f0a2\"\";i:844;s:7:\"\"\\f0f4\"\";i:845;s:7:\"\"\\f0f5\"\";i:846;s:7:\"\"\\f0f7\"\";i:847;s:7:\"\"\\f0f8\"\";i:848;s:7:\"\"\\f0f9\"\";i:849;s:7:\"\"\\f0fa\"\";i:850;s:7:\"\"\\f0fb\"\";i:851;s:7:\"\"\\f0fc\"\";i:852;s:7:\"\"\\f0fd\"\";i:853;s:7:\"\"\\f0fe\"\";i:854;s:7:\"\"\\f100\"\";i:855;s:7:\"\"\\f101\"\";i:856;s:7:\"\"\\f102\"\";i:857;s:7:\"\"\\f103\"\";i:858;s:7:\"\"\\f106\"\";i:859;s:7:\"\"\\f107\"\";i:860;s:7:\"\"\\f108\"\";i:861;s:7:\"\"\\f109\"\";i:862;s:7:\"\"\\f10a\"\";i:863;s:7:\"\"\\f10b\"\";i:864;s:7:\"\"\\f10c\"\";i:865;s:7:\"\"\\f10d\"\";i:866;s:7:\"\"\\f10e\"\";i:867;s:7:\"\"\\f110\"\";i:868;s:7:\"\"\\f111\"\";i:869;s:7:\"\"\\f112\"\";i:870;s:7:\"\"\\f113\"\";i:871;s:7:\"\"\\f115\"\";i:872;s:7:\"\"\\f118\"\";i:873;s:7:\"\"\\f119\"\";i:874;s:7:\"\"\\f11a\"\";i:875;s:7:\"\"\\f11b\"\";i:876;s:7:\"\"\\f11c\"\";i:877;s:7:\"\"\\f11d\"\";i:878;s:7:\"\"\\f11e\"\";i:879;s:7:\"\"\\f120\"\";i:880;s:7:\"\"\\f121\"\";i:881;s:7:\"\"\\f122\"\";i:882;s:7:\"\"\\f123\"\";i:883;s:7:\"\"\\f124\"\";i:884;s:7:\"\"\\f125\"\";i:885;s:7:\"\"\\f126\"\";i:886;s:7:\"\"\\f127\"\";i:887;s:7:\"\"\\f128\"\";i:888;s:7:\"\"\\f129\"\";i:889;s:7:\"\"\\f12a\"\";i:890;s:7:\"\"\\f12b\"\";i:891;s:7:\"\"\\f12c\"\";i:892;s:7:\"\"\\f12d\"\";i:893;s:7:\"\"\\f12e\"\";i:894;s:7:\"\"\\f130\"\";i:895;s:7:\"\"\\f131\"\";i:896;s:7:\"\"\\f132\"\";i:897;s:7:\"\"\\f133\"\";i:898;s:7:\"\"\\f134\"\";i:899;s:7:\"\"\\f135\"\";i:900;s:7:\"\"\\f136\"\";i:901;s:7:\"\"\\f137\"\";i:902;s:7:\"\"\\f138\"\";i:903;s:7:\"\"\\f139\"\";i:904;s:7:\"\"\\f13a\"\";i:905;s:7:\"\"\\f13b\"\";i:906;s:7:\"\"\\f13c\"\";i:907;s:7:\"\"\\f13d\"\";i:908;s:7:\"\"\\f13e\"\";i:909;s:7:\"\"\\f140\"\";i:910;s:7:\"\"\\f141\"\";i:911;s:7:\"\"\\f142\"\";i:912;s:7:\"\"\\f143\"\";i:913;s:7:\"\"\\f144\"\";i:914;s:7:\"\"\\f145\"\";i:915;s:7:\"\"\\f146\"\";i:916;s:7:\"\"\\f147\"\";i:917;s:7:\"\"\\f148\"\";i:918;s:7:\"\"\\f149\"\";i:919;s:7:\"\"\\f14a\"\";i:920;s:7:\"\"\\f14b\"\";i:921;s:7:\"\"\\f14c\"\";i:922;s:7:\"\"\\f14d\"\";i:923;s:7:\"\"\\f14e\"\";i:924;s:7:\"\"\\f150\"\";i:925;s:7:\"\"\\f151\"\";i:926;s:7:\"\"\\f152\"\";i:927;s:7:\"\"\\f153\"\";i:928;s:7:\"\"\\f154\"\";i:929;s:7:\"\"\\f155\"\";i:930;s:7:\"\"\\f156\"\";i:931;s:7:\"\"\\f157\"\";i:932;s:7:\"\"\\f158\"\";i:933;s:7:\"\"\\f159\"\";i:934;s:7:\"\"\\f15a\"\";i:935;s:7:\"\"\\f15b\"\";i:936;s:7:\"\"\\f15c\"\";i:937;s:7:\"\"\\f15d\"\";i:938;s:7:\"\"\\f15e\"\";i:939;s:7:\"\"\\f160\"\";i:940;s:7:\"\"\\f161\"\";i:941;s:7:\"\"\\f162\"\";i:942;s:7:\"\"\\f163\"\";i:943;s:7:\"\"\\f164\"\";i:944;s:7:\"\"\\f165\"\";i:945;s:7:\"\"\\f166\"\";i:946;s:7:\"\"\\f167\"\";i:947;s:7:\"\"\\f168\"\";i:948;s:7:\"\"\\f169\"\";i:949;s:7:\"\"\\f16a\"\";i:950;s:7:\"\"\\f16b\"\";i:951;s:7:\"\"\\f16c\"\";i:952;s:7:\"\"\\f16d\"\";i:953;s:7:\"\"\\f16e\"\";i:954;s:7:\"\"\\f170\"\";i:955;s:7:\"\"\\f171\"\";i:956;s:7:\"\"\\f172\"\";i:957;s:7:\"\"\\f173\"\";i:958;s:7:\"\"\\f174\"\";i:959;s:7:\"\"\\f175\"\";i:960;s:7:\"\"\\f176\"\";i:961;s:7:\"\"\\f177\"\";i:962;s:7:\"\"\\f178\"\";i:963;s:7:\"\"\\f179\"\";i:964;s:7:\"\"\\f17a\"\";i:965;s:7:\"\"\\f17b\"\";i:966;s:7:\"\"\\f17c\"\";i:967;s:7:\"\"\\f17d\"\";i:968;s:7:\"\"\\f17e\"\";i:969;s:7:\"\"\\f180\"\";i:970;s:7:\"\"\\f181\"\";i:971;s:7:\"\"\\f182\"\";i:972;s:7:\"\"\\f183\"\";i:973;s:7:\"\"\\f184\"\";i:974;s:7:\"\"\\f185\"\";i:975;s:7:\"\"\\f186\"\";i:976;s:7:\"\"\\f187\"\";i:977;s:7:\"\"\\f188\"\";i:978;s:7:\"\"\\f189\"\";i:979;s:7:\"\"\\f18a\"\";i:980;s:7:\"\"\\f18b\"\";i:981;s:7:\"\"\\f18c\"\";i:982;s:7:\"\"\\f18d\"\";i:983;s:7:\"\"\\f18e\"\";i:984;s:7:\"\"\\f190\"\";i:985;s:7:\"\"\\f191\"\";i:986;s:7:\"\"\\f192\"\";i:987;s:7:\"\"\\f193\"\";i:988;s:7:\"\"\\f194\"\";i:989;s:7:\"\"\\f195\"\";i:990;s:7:\"\"\\f196\"\";i:991;s:7:\"\"\\f197\"\";i:992;s:7:\"\"\\f198\"\";i:993;s:7:\"\"\\f199\"\";i:994;s:7:\"\"\\f19a\"\";i:995;s:7:\"\"\\f19b\"\";i:996;s:7:\"\"\\f19c\"\";i:997;s:7:\"\"\\f19d\"\";i:998;s:7:\"\"\\f19e\"\";i:999;s:7:\"\"\\f1a0\"\";i:1000;s:7:\"\"\\f1a1\"\";i:1001;s:7:\"\"\\f1a2\"\";i:1002;s:7:\"\"\\f1a3\"\";i:1003;s:7:\"\"\\f1a4\"\";i:1004;s:7:\"\"\\f1a5\"\";i:1005;s:7:\"\"\\f1a6\"\";i:1006;s:7:\"\"\\f1a7\"\";i:1007;s:7:\"\"\\f1a8\"\";i:1008;s:7:\"\"\\f1a9\"\";i:1009;s:7:\"\"\\f1aa\"\";i:1010;s:7:\"\"\\f1ab\"\";i:1011;s:7:\"\"\\f1ac\"\";i:1012;s:7:\"\"\\f1ad\"\";i:1013;s:7:\"\"\\f1ae\"\";i:1014;s:7:\"\"\\f1b0\"\";i:1015;s:7:\"\"\\f1b1\"\";i:1016;s:7:\"\"\\f1b2\"\";i:1017;s:7:\"\"\\f1b3\"\";i:1018;s:7:\"\"\\f1b4\"\";i:1019;s:7:\"\"\\f1b5\"\";i:1020;s:7:\"\"\\f1b6\"\";i:1021;s:7:\"\"\\f1b7\"\";i:1022;s:7:\"\"\\f1b8\"\";i:1023;s:7:\"\"\\f1b9\"\";i:1024;s:7:\"\"\\f1ba\"\";i:1025;s:7:\"\"\\f1bb\"\";i:1026;s:7:\"\"\\f1bc\"\";i:1027;s:7:\"\"\\f1bd\"\";i:1028;s:7:\"\"\\f1be\"\";i:1029;s:7:\"\"\\f1c0\"\";i:1030;s:7:\"\"\\f1c1\"\";i:1031;s:7:\"\"\\f1c2\"\";i:1032;s:7:\"\"\\f1c3\"\";i:1033;s:7:\"\"\\f1c4\"\";i:1034;s:7:\"\"\\f1c5\"\";i:1035;s:7:\"\"\\f1c6\"\";i:1036;s:7:\"\"\\f1c7\"\";i:1037;s:7:\"\"\\f1c8\"\";i:1038;s:7:\"\"\\f1c9\"\";i:1039;s:7:\"\"\\f1ca\"\";i:1040;s:7:\"\"\\f1cb\"\";i:1041;s:7:\"\"\\f1cc\"\";i:1042;s:7:\"\"\\f1cd\"\";i:1043;s:7:\"\"\\f1ce\"\";i:1044;s:7:\"\"\\f1d0\"\";i:1045;s:7:\"\"\\f1d1\"\";i:1046;s:7:\"\"\\f1d2\"\";i:1047;s:7:\"\"\\f1d3\"\";i:1048;s:7:\"\"\\f1d4\"\";i:1049;s:7:\"\"\\f1d5\"\";i:1050;s:7:\"\"\\f1d6\"\";i:1051;s:7:\"\"\\f1d7\"\";i:1052;s:7:\"\"\\f1d8\"\";i:1053;s:7:\"\"\\f1d9\"\";i:1054;s:7:\"\"\\f1da\"\";i:1055;s:7:\"\"\\f1db\"\";i:1056;s:7:\"\"\\f1dc\"\";i:1057;s:7:\"\"\\f1dd\"\";i:1058;s:7:\"\"\\f1de\"\";i:1059;s:7:\"\"\\f1e0\"\";i:1060;s:7:\"\"\\f1e1\"\";i:1061;s:7:\"\"\\f1e2\"\";i:1062;s:7:\"\"\\f1e3\"\";i:1063;s:7:\"\"\\f1e4\"\";i:1064;s:7:\"\"\\f1e5\"\";i:1065;s:7:\"\"\\f1e6\"\";i:1066;s:7:\"\"\\f1e7\"\";i:1067;s:7:\"\"\\f1e8\"\";i:1068;s:7:\"\"\\f1e9\"\";i:1069;s:7:\"\"\\f1ea\"\";i:1070;s:7:\"\"\\f1eb\"\";i:1071;s:7:\"\"\\f1ec\"\";i:1072;s:7:\"\"\\f1ed\"\";i:1073;s:7:\"\"\\f1ee\"\";i:1074;s:7:\"\"\\f1f0\"\";i:1075;s:7:\"\"\\f1f1\"\";i:1076;s:7:\"\"\\f1f2\"\";i:1077;s:7:\"\"\\f1f3\"\";i:1078;s:7:\"\"\\f1f4\"\";i:1079;s:7:\"\"\\f1f5\"\";i:1080;s:7:\"\"\\f1f6\"\";i:1081;s:7:\"\"\\f1f7\"\";i:1082;s:7:\"\"\\f1f8\"\";i:1083;s:7:\"\"\\f1f9\"\";i:1084;s:7:\"\"\\f1fa\"\";i:1085;s:7:\"\"\\f1fb\"\";i:1086;s:7:\"\"\\f1fc\"\";i:1087;s:7:\"\"\\f1fd\"\";i:1088;s:7:\"\"\\f1fe\"\";i:1089;s:7:\"\"\\f200\"\";i:1090;s:7:\"\"\\f201\"\";i:1091;s:7:\"\"\\f202\"\";i:1092;s:7:\"\"\\f203\"\";i:1093;s:7:\"\"\\f204\"\";i:1094;s:7:\"\"\\f205\"\";i:1095;s:7:\"\"\\f206\"\";i:1096;s:7:\"\"\\f207\"\";i:1097;s:7:\"\"\\f208\"\";i:1098;s:7:\"\"\\f209\"\";i:1099;s:7:\"\"\\f20a\"\";i:1100;s:7:\"\"\\f20b\"\";i:1101;s:7:\"\"\\f20c\"\";i:1102;s:7:\"\"\\f20d\"\";i:1103;s:7:\"\"\\f20e\"\";i:1104;s:7:\"\"\\f210\"\";i:1105;s:7:\"\"\\f211\"\";i:1106;s:7:\"\"\\f212\"\";i:1107;s:7:\"\"\\f213\"\";i:1108;s:7:\"\"\\f214\"\";i:1109;s:7:\"\"\\f215\"\";i:1110;s:7:\"\"\\f216\"\";i:1111;s:7:\"\"\\f217\"\";i:1112;s:7:\"\"\\f218\"\";i:1113;s:7:\"\"\\f219\"\";i:1114;s:7:\"\"\\f21a\"\";i:1115;s:7:\"\"\\f21b\"\";i:1116;s:7:\"\"\\f21c\"\";i:1117;s:7:\"\"\\f21d\"\";i:1118;s:7:\"\"\\f21e\"\";i:1119;s:7:\"\"\\f221\"\";i:1120;s:7:\"\"\\f222\"\";i:1121;s:7:\"\"\\f223\"\";i:1122;s:7:\"\"\\f224\"\";i:1123;s:7:\"\"\\f225\"\";i:1124;s:7:\"\"\\f226\"\";i:1125;s:7:\"\"\\f227\"\";i:1126;s:7:\"\"\\f228\"\";i:1127;s:7:\"\"\\f229\"\";i:1128;s:7:\"\"\\f22a\"\";i:1129;s:7:\"\"\\f22b\"\";i:1130;s:7:\"\"\\f22c\"\";i:1131;s:7:\"\"\\f22d\"\";i:1132;s:7:\"\"\\f230\"\";i:1133;s:7:\"\"\\f231\"\";i:1134;s:7:\"\"\\f232\"\";i:1135;s:7:\"\"\\f233\"\";i:1136;s:7:\"\"\\f234\"\";i:1137;s:7:\"\"\\f235\"\";i:1138;s:7:\"\"\\f236\"\";i:1139;s:7:\"\"\\f237\"\";i:1140;s:7:\"\"\\f238\"\";i:1141;s:7:\"\"\\f239\"\";i:1142;s:7:\"\"\\f23a\"\";i:1143;s:7:\"\"\\f23b\"\";i:1144;s:7:\"\"\\f23c\"\";i:1145;s:7:\"\"\\f23d\"\";i:1146;s:7:\"\"\\f23e\"\";i:1147;s:7:\"\"\\f240\"\";i:1148;s:7:\"\"\\f241\"\";i:1149;s:7:\"\"\\f242\"\";i:1150;s:7:\"\"\\f243\"\";i:1151;s:7:\"\"\\f244\"\";i:1152;s:7:\"\"\\f245\"\";i:1153;s:7:\"\"\\f246\"\";i:1154;s:7:\"\"\\f247\"\";i:1155;s:7:\"\"\\f248\"\";i:1156;s:7:\"\"\\f249\"\";i:1157;s:7:\"\"\\f24a\"\";i:1158;s:7:\"\"\\f24b\"\";i:1159;s:7:\"\"\\f24c\"\";i:1160;s:7:\"\"\\f24d\"\";i:1161;s:7:\"\"\\f24e\"\";i:1162;s:7:\"\"\\f250\"\";i:1163;s:7:\"\"\\f251\"\";i:1164;s:7:\"\"\\f252\"\";i:1165;s:7:\"\"\\f253\"\";i:1166;s:7:\"\"\\f254\"\";i:1167;s:7:\"\"\\f255\"\";i:1168;s:7:\"\"\\f256\"\";i:1169;s:7:\"\"\\f257\"\";i:1170;s:7:\"\"\\f258\"\";i:1171;s:7:\"\"\\f259\"\";i:1172;s:7:\"\"\\f25a\"\";i:1173;s:7:\"\"\\f25b\"\";i:1174;s:7:\"\"\\f25c\"\";i:1175;s:7:\"\"\\f25d\"\";i:1176;s:7:\"\"\\f25e\"\";i:1177;s:7:\"\"\\f260\"\";i:1178;s:7:\"\"\\f261\"\";i:1179;s:7:\"\"\\f262\"\";i:1180;s:7:\"\"\\f263\"\";i:1181;s:7:\"\"\\f264\"\";i:1182;s:7:\"\"\\f265\"\";i:1183;s:7:\"\"\\f266\"\";i:1184;s:7:\"\"\\f267\"\";i:1185;s:7:\"\"\\f268\"\";i:1186;s:7:\"\"\\f269\"\";i:1187;s:7:\"\"\\f26a\"\";i:1188;s:7:\"\"\\f26b\"\";i:1189;s:7:\"\"\\f26c\"\";i:1190;s:7:\"\"\\f26d\"\";i:1191;s:7:\"\"\\f26e\"\";i:1192;s:7:\"\"\\f270\"\";i:1193;s:7:\"\"\\f271\"\";i:1194;s:7:\"\"\\f272\"\";i:1195;s:7:\"\"\\f273\"\";i:1196;s:7:\"\"\\f274\"\";i:1197;s:7:\"\"\\f275\"\";i:1198;s:7:\"\"\\f276\"\";i:1199;s:7:\"\"\\f277\"\";i:1200;s:7:\"\"\\f278\"\";i:1201;s:7:\"\"\\f279\"\";i:1202;s:7:\"\"\\f27a\"\";i:1203;s:7:\"\"\\f27b\"\";i:1204;s:7:\"\"\\f27c\"\";i:1205;s:7:\"\"\\f27d\"\";i:1206;s:7:\"\"\\f27e\"\";i:1207;s:7:\"\"\\f280\"\";i:1208;s:7:\"\"\\f281\"\";i:1209;s:7:\"\"\\f282\"\";i:1210;s:7:\"\"\\f283\"\";i:1211;s:7:\"\"\\f284\"\";i:1212;s:7:\"\"\\f285\"\";i:1213;s:7:\"\"\\f286\"\";i:1214;s:7:\"\"\\f287\"\";i:1215;s:7:\"\"\\f288\"\";i:1216;s:7:\"\"\\f289\"\";i:1217;s:7:\"\"\\f28a\"\";i:1218;s:7:\"\"\\f28b\"\";i:1219;s:7:\"\"\\f28c\"\";i:1220;s:7:\"\"\\f28d\"\";i:1221;s:7:\"\"\\f28e\"\";i:1222;s:7:\"\"\\f290\"\";i:1223;s:7:\"\"\\f291\"\";i:1224;s:7:\"\"\\f292\"\";i:1225;s:7:\"\"\\f293\"\";i:1226;s:7:\"\"\\f294\"\";i:1227;s:7:\"\"\\f295\"\";i:1228;s:7:\"\"\\f296\"\";i:1229;s:7:\"\"\\f297\"\";i:1230;s:7:\"\"\\f298\"\";i:1231;s:7:\"\"\\f299\"\";i:1232;s:7:\"\"\\f29a\"\";i:1233;s:7:\"\"\\f29b\"\";i:1234;s:7:\"\"\\f29c\"\";i:1235;s:7:\"\"\\f29d\"\";i:1236;s:7:\"\"\\f29e\"\";i:1237;s:7:\"\"\\f2a0\"\";i:1238;s:7:\"\"\\f2a1\"\";i:1239;s:7:\"\"\\f2a2\"\";i:1240;s:7:\"\"\\f2a3\"\";i:1241;s:7:\"\"\\f2a4\"\";i:1242;s:7:\"\"\\f2a5\"\";i:1243;s:7:\"\"\\f2a6\"\";i:1244;s:7:\"\"\\f2a7\"\";i:1245;s:7:\"\"\\f2a8\"\";i:1246;s:7:\"\"\\f2a9\"\";i:1247;s:7:\"\"\\f2aa\"\";i:1248;s:7:\"\"\\f2ab\"\";i:1249;s:7:\"\"\\f2ac\"\";i:1250;s:7:\"\"\\f2ad\"\";i:1251;s:7:\"\"\\f2ae\"\";i:1252;s:7:\"\"\\f2b0\"\";i:1253;s:7:\"\"\\f2b1\"\";i:1254;s:7:\"\"\\f2b2\"\";i:1255;s:7:\"\"\\f2b3\"\";i:1256;s:7:\"\"\\f2b4\"\";i:1257;s:7:\"\"\\f2b5\"\";i:1258;s:7:\"\"\\f2b6\"\";i:1259;s:7:\"\"\\f2b7\"\";i:1260;s:7:\"\"\\f2b8\"\";i:1261;s:7:\"\"\\f2b9\"\";i:1262;s:7:\"\"\\f2ba\"\";i:1263;s:7:\"\"\\f2bb\"\";i:1264;s:7:\"\"\\f2bc\"\";i:1265;s:7:\"\"\\f2bd\"\";i:1266;s:7:\"\"\\f2be\"\";i:1267;s:7:\"\"\\f2c0\"\";i:1268;s:7:\"\"\\f2c1\"\";i:1269;s:7:\"\"\\f2c2\"\";i:1270;s:7:\"\"\\f2c3\"\";i:1271;s:7:\"\"\\f2c4\"\";i:1272;s:7:\"\"\\f2c5\"\";i:1273;s:7:\"\"\\f2c6\"\";i:1274;s:7:\"\"\\f2c7\"\";i:1275;s:7:\"\"\\f2c8\"\";i:1276;s:7:\"\"\\f2c9\"\";i:1277;s:7:\"\"\\f2ca\"\";i:1278;s:7:\"\"\\f2cb\"\";i:1279;s:7:\"\"\\f2cc\"\";i:1280;s:7:\"\"\\f2cd\"\";i:1281;s:7:\"\"\\f2ce\"\";i:1282;s:7:\"\"\\f2d0\"\";i:1283;s:7:\"\"\\f2d1\"\";i:1284;s:7:\"\"\\f2d2\"\";i:1285;s:7:\"\"\\f2d3\"\";i:1286;s:7:\"\"\\f2d4\"\";i:1287;s:7:\"\"\\f2d5\"\";i:1288;s:7:\"\"\\f2d6\"\";i:1289;s:7:\"\"\\f2d7\"\";i:1290;s:7:\"\"\\f2d8\"\";i:1291;s:7:\"\"\\f2d9\"\";i:1292;s:7:\"\"\\f2da\"\";i:1293;s:7:\"\"\\f2db\"\";i:1294;s:7:\"\"\\f2dc\"\";i:1295;s:7:\"\"\\f2dd\"\";i:1296;s:7:\"\"\\f2de\"\";i:1297;s:7:\"\"\\f2e0\"\";i:1298;s:5:\"140px\";i:1299;s:19:\"blink 0.7s infinite\";i:1300;s:6:\"1000ms\";i:1301;s:7:\"fadeOut\";i:1302;s:24:\"height 500ms ease-in-out\";i:1303;s:5:\"pan-Y\";i:1304;s:3:\"\".\"\";i:1305;s:11:\"preserve-3d\";i:1306;s:4:\"move\";i:1307;s:12:\"-webkit-grab\";i:1308;s:7:\"-o-grab\";i:1309;s:8:\"-ms-grab\";i:1310;s:4:\"grab\";i:1311;s:3:\"rtl\";i:1312;s:18:\"opacity 400ms ease\";i:1313;s:5:\"-40px\";i:1314;s:16:\"scale 100ms ease\";i:1315;s:15:\"scale(1.3, 1.3)\";i:1316;s:7:\"contain\";i:1317;s:10:\"border-box\";i:1318;s:5:\"-13px\";i:1319;s:13:\"5px solid red\";i:1320;s:14:\"13px solid red\";i:1321;s:21:\"8px solid transparent\";i:1322;s:20:\"subpixel-antialiased\";i:1323;s:21:\"rgba(255,255,255,0.7)\";i:1324;s:36:\"url(assets/images/openhand.cur),move\";i:1325;s:38:\"url(assets/images/closedhand.cur),move\";i:1326;s:13:\"rotate(45deg)\";i:1327;s:7:\"\'\\2195\'\";i:1328;s:11:\"opacity .5s\";i:1329;s:14:\"2px solid #000\";i:1330;s:18:\"skew(145deg, 0deg)\";i:1331;s:19:\"skew(-145deg, 0deg)\";i:1332;s:17:\"skew(35deg, 0deg)\";i:1333;s:18:\"skew(-35deg, 0deg)\";i:1334;s:15:\"20px solid #fff\";i:1335;s:15:\"12px solid #fff\";i:1336;s:7:\"\'\\25B6\'\";i:1337;s:15:\"rgba(0,0,0,0.2)\";i:1338;s:4:\"52px\";i:1339;s:3:\"1.4\";i:1340;s:3:\"1.7\";i:1341;s:7:\"#e8e8e8\";i:1342;s:4:\"0.35\";}", "no");
INSERT INTO `wp_options` VALUES("1495", "ms_child_theme_editor_dict_seq", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("1496", "ms_child_theme_editor_dict_token", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("1497", "ms_child_theme_editor_val_ndx", "a:3043:{i:1;s:12:\"VE=hT?GUZA$A\";i:2;s:13:\"VE=hT?GUatlBA\";i:3;s:12:\"EH=hT?GUpA$A\";i:4;s:12:\"EH=hT?GU5A$A\";i:5;s:12:\"EH=hT?GU/A$A\";i:6;s:90:\"cE=hT?GU~AlBjL.4Fx~5BAYL=hT?GUeBlBrL.4Fx}MCA[Q=hT?GU!BlBzL.4FxrjCAvW=hT?GU>BlB7L.4FxrjCABA\";i:7;s:35:\"uP=hT?GUDClBnL.4Fx}MDANc=hT?GUjClBA\";i:8;s:13:\"sP=hT?GUDClBA\";i:9;s:13:\"hg=hT?GUzClBA\";i:10;s:24:\"ig=hT?GU!BlB,L.4Fx~5DABA\";i:11;s:13:\"hg=hT?GU!BlBA\";i:12;s:68:\"xP=hT?GU(ClBnL.4Fx}MEA1k=hT?GU!BlBzL.4FxrjCAvW=hT?GUzClB?L.4Fx~5CABA\";i:13;s:13:\"4r=hT?GUIDlBA\";i:14;s:24:\"`X=hT?GU>BlB|L.4Fx~5CABA\";i:15;s:24:\"LV=hT?GUYDlBAM.4FxrjCABA\";i:16;s:24:\"tP=hT?GUuBlBEM.4Fxs@EABA\";i:17;s:13:\"\"l=hT?GU4DlBA\";i:18;s:13:\"VE=hT?GU~AlBA\";i:19;s:57:\"ZE=hT?GU~AlBIM.4FxrjCAZ4=hT?GUYDlBQM.4FxrjCA]9=hT?GUYDlBA\";i:20;s:46:\"O&=hT?GU!BlB,L.4FxrjFAw(=hT?GU.DlB(L.4FxrjFABA\";i:21;s:13:\"VE=hT?GU~AlBA\";i:22;s:13:\"),=hT?GU}DlBA\";i:23;s:13:\"hg=hT?GUzClBA\";i:24;s:13:\"hg=hT?GU!BlBA\";i:25;s:24:\"ig=hT?GU#ulB,L.4Fxrj&ABA\";i:26;s:24:\"ig=hT?GU!BlB,L.4Fx~5DABA\";i:27;s:13:\"z:=hT?GU!BlBA\";i:28;s:24:\"`X=hT?GU?ulB|L.4Fxrj$ABA\";i:29;s:24:\"ig=hT?GU/wlB,L.4Fxrj*ABA\";i:30;s:24:\"ig=hT?GU.DlB,L.4FxrjFABA\";i:31;s:24:\"ig=hT?GU.DlB,L.4FxrjFABA\";i:32;s:24:\"`X=hT?GU?ulB|L.4Fxrj$ABA\";i:33;s:13:\"i==hT?GUNElBA\";i:34;s:13:\"i==hT?GUdElBA\";i:35;s:13:\"VE=hT?GUatlBA\";i:36;s:13:\"F0=hT?GUOBlBA\";i:37;s:24:\"`X=hT?GU>BlB|L.4FxrjAABA\";i:38;s:13:\"t8=hT?GUtElBA\";i:39;s:13:\"VE=hT?GU~AlBA\";i:40;s:12:\"VE=hT?GUZA$A\";i:41;s:13:\"VE=hT?GU~AlBA\";i:42;s:45:\"U@=hT?GU/A$AMDSOYMu7Ctgg_Q3nE3GC$A<CSOYM)ZBtA\";i:43;s:13:\"VE=hT?GU=ElBA\";i:44;s:67:\"W@=hT?GUZA$A<CSOYMtOBt&a_Q3nE3<AgAvBJHNzX0uW+OqI:$vbDBgAwBJHNz`auWA\";i:45;s:28:\"WE=hT?IUCFlBUoDAkn_Q3nE3MAgA\";i:46;s:13:\"VE=hT?GU~AlBA\";i:47;s:90:\"zP=hT?GUDClB;L.4Fx~5EA<v=hT?GUYDlBwM.4Fx~5GAq1=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:48;s:34:\";o=hT?GU>BlBsM.4Fx}MBA6F=hT?GU/A$A\";i:49;s:23:\"S@=hT?GU5A$A<CSOYMLUBtA\";i:50;s:45:\"U@=hT?GUZA$A]CSOYMu7Bt#T_Q3nE35B$A<CSOYMtOBtA\";i:51;s:12:\"EH=hT?GUpA$A\";i:52;s:13:\"L&=hT?GUSFlBA\";i:53;s:34:\"T@=hT?GUZA$A]CSOYMu7Bt:C_Q3nE3UAgA\";i:54;s:122:\"Jm=hT?GUYDlBzL.4FxrjCA<v=hT?GU!BlBvL.4FxrjCAvW=hT?GU>BlB|L.4Fx~5CAYL=hT?GUiFlBoM.4Fxs@HAl_=hT?GUZA$AFDSOYM@1Btxd_Q3nE3>C$A\";i:55;s:13:\"VE=hT?GU]FlBA\";i:56;s:13:\"5}=hT?GUeBlBA\";i:57;s:90:\"cE=hT?GU~AlB3L.4Fx~5CAkn=hT?GUHGlB8M.4Fx~5IA%$=hT?GU!BlB,L.4Fxs@IAw(=hT?GU!BlB(L.4Fxs@IABA\";i:58;s:13:\"KV=hT?GU!BlBA\";i:59;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:60;s:46:\"1d=hT?GUjClB$M.4FxrjCA6F>hT?GUnGlB.M.4FxrjCABA\";i:61;s:13:\"`)=hT?GUHGlBA\";i:62;s:13:\"t8=hT?GUHGlBA\";i:63;s:13:\"t8=hT?GU!BlBA\";i:64;s:12:\"VE=hT?GUZA$A\";i:65;s:57:\"}X=hT?GU>BlBYM.4FxrjCA+h=hT?GU!BlBcM.4FxrjCA|e=hT?GU!BlBA\";i:66;s:13:\"VE=hT?GU\"tlBA\";i:67;s:24:\"`X=hT?GUdElB?L.4Fx}MGABA\";i:68;s:24:\"`X=hT?GU3GlB?L.4FxrjJABA\";i:69;s:24:\"`X=hT?GUyFlB?L.4Fxs@HABA\";i:70;s:13:\"VE=hT?GUatlBA\";i:71;s:24:\"LV=hT?GUYDlBAM.4Fx~5CABA\";i:72;s:24:\"LV=hT?GU,GlBAM.4Fx~5EABA\";i:73;s:13:\"9M>hT?GU|GlBA\";i:74;s:24:\"ig=hT?GUMHlB,L.4FxrjKABA\";i:75;s:13:\"nu=hT?GUsHlBA\";i:76;s:13:\"nu=hT?GU8HlBA\";i:77;s:13:\"VE=hT?GUatlBA\";i:78;s:12:\"EH=hT?GUpA$A\";i:79;s:12:\"EH=hT?GU5A$A\";i:80;s:12:\"EH=hT?GU/A$A\";i:81;s:13:\"VE=hT?GUatlBA\";i:82;s:12:\"EH=hT?GUpA$A\";i:83;s:12:\"EH=hT?GU5A$A\";i:84;s:12:\"EH=hT?GU/A$A\";i:85;s:13:\"VE=hT?GU\"tlBA\";i:86;s:13:\"VE=hT?GU^ylBA\";i:87;s:13:\"VE=hT?GUatlBA\";i:88;s:13:\"VE=hT?GU\"tlBA\";i:89;s:13:\"VE=hT?GU^ylBA\";i:90;s:13:\"VE=hT?GUatlBA\";i:91;s:13:\"_X=hT?GUZwlBA\";i:92;s:35:\"{X=hT?GU?ulBUM.4Fxrj&Akn=hT?GUZwlBA\";i:93;s:13:\"VE=hT?GU~AlBA\";i:94;s:13:\"t8=hT?GU.DlBA\";i:95;s:46:\"vP=hT?GU<HlB;L.4Fx~5EA$T=hT?GUYDlB|L.4Fx~5CABA\";i:96;s:13:\"nu=hT?GU>BlBA\";i:97;s:13:\"Qj=hT?GU!BlBA\";i:98;s:13:\"hg=hT?GU!BlBA\";i:99;s:57:\"wP=hT?GU<HlB;L.4Fx~5EA$T=hT?GUYDlBAM.4Fx~5EAq1=hT?GU!BlBA\";i:100;s:46:\"O&=hT?GU!BlB,L.4FxrjFAw(=hT?GU!BlB(L.4FxrjFABA\";i:101;s:24:\"d#=hT?GU!BlBwM.4Fx~5GABA\";i:102;s:13:\"_X=hT?GUBIlBA\";i:103;s:13:\"_X=hT?GU>BlBA\";i:104;s:13:\"_X=hT?GU?ulBA\";i:105;s:13:\"VE=hT?GUatlBA\";i:106;s:12:\"EH=hT?GUpA$A\";i:107;s:12:\"EH=hT?GU5A$A\";i:108;s:12:\"EH=hT?GU/A$A\";i:109;s:13:\"_X=hT?GU?ulBA\";i:110;s:13:\"_X=hT?GUZwlBA\";i:111;s:13:\"_X=hT?GU>BlBA\";i:112;s:23:\"S@=hT?GUZA$A]CSOYMu7RtA\";i:113;s:13:\"t8=hT?GU#ulBA\";i:114;s:13:\"t8=hT?GU!BlBA\";i:115;s:13:\"t8=hT?GU#ulBA\";i:116;s:12:\"VE=hT?GUZA$A\";i:117;s:24:\"`X=hT?GU>BlBsM.4FxrjAABA\";i:118;s:13:\"hg=hT?GU!BlBA\";i:119;s:46:\"O&=hT?GU#ulB,L.4Fxrj&Aw(=hT?GU#ulB(L.4Fxrj&ABA\";i:120;s:24:\"@2=hT?GU#ulBQM.4Fxrj&ABA\";i:121;s:13:\"t8=hT?GUNElBA\";i:122;s:23:\"S@=hT?GUZA$A]CSOYMu7BtA\";i:123;s:35:\"{X=hT?GU?ulBUM.4Fxrj&Akn=hT?GUZwlBA\";i:124;s:13:\"t8=hT?GU.DlBA\";i:125;s:13:\"VE=hT?GU~AlBA\";i:126;s:46:\"vP=hT?GU<HlB;L.4Fx~5EA$T=hT?GUYDlB|L.4Fx~5CABA\";i:127;s:13:\"nu=hT?GU>BlBA\";i:128;s:13:\"Qj=hT?GU!BlBA\";i:129;s:13:\"hg=hT?GU!BlBA\";i:130;s:13:\"VE=hT?GU~AlBA\";i:131;s:13:\"mB>hT?GURIlBA\";i:132;s:24:\"WE=hT?GU=ElBsM.4FxrjAABA\";i:133;s:23:\"S@=hT?GUZA$A<CSOYMtOBtA\";i:134;s:24:\"WE=hT?GU=ElBsM.4FxrjAABA\";i:135;s:12:\"EH=hT?GU/A$A\";i:136;s:12:\"EH=hT?GU5A$A\";i:137;s:13:\"L&=hT?GUhIlBA\";i:138;s:13:\"/o=hT?GUxIlBA\";i:139;s:13:\"i==hT?GU%IlBA\";i:140;s:13:\"i==hT?GU[IlBA\";i:141;s:24:\"ou=hT?GU>BlB3L.4Fx~5CABA\";i:142;s:56:\"V@=hT?GUZA$ACDSOYM@1BtMc_Q3nE3<Ai\"vBJHNzG3vWrPqI:$vbmAQA\";i:143;s:24:\"d#=hT?GU!BlBMM.4FxrjCABA\";i:144;s:13:\"\"l=hT?GU!BlBA\";i:145;s:68:\"~X=hT?GU>BlBYM.4FxrjCA+h=hT?GU!BlBcM.4FxrjCA|e=hT?GU!BlB@M.4FxrjCABA\";i:146;s:12:\"VE=hT?GUZA$A\";i:147;s:13:\"_X=hT?GU?ulBA\";i:148;s:57:\"wP=hT?GU<HlBzL.4Fx~5EA<v=hT?GUYDlB;L.4Fx~5EAI7=hT?GUNElBA\";i:149;s:46:\"O&=hT?GUNElB,L.4Fxs@FAw(=hT?GUNElB(L.4Fxs@FABA\";i:150;s:13:\"c#=hT?GU!BlBA\";i:151;s:13:\"_X=hT?GU>BlBA\";i:152;s:12:\"VE=hT?GUZA$A\";i:153;s:13:\"VE=hT?GU~AlBA\";i:154;s:72:\"~X=hT?GU>BlBIM.4?zrjCAq1GClBGGkcwY(RD\"xd_Q3nE3<AgAwBJHNz`auW#TqI:$vbGAQA\";i:155;s:12:\"EH=hT?GUpA$A\";i:156;s:13:\"VE=hT?GU~AlBA\";i:157;s:13:\"L&=hT?GUWJlBA\";i:158;s:89:\"Y@=hT?GUZA$A;CSOYMM%Ct#T_Q3nE35B$APDSOYM*+Dt&a_Q3nE3<AgAvBJHNzG3vW+OqI:$vbmAS\",\",ub@Yk5FA\";i:159;s:24:\"Xx=hT?GUNElBvL.4Fxs@FABA\";i:160;s:24:\"`X=hT?GU>BlBsM.4FxrjAABA\";i:161;s:13:\"_X=hT?GU>BlBA\";i:162;s:13:\"t8=hT?GU!BlBA\";i:163;s:13:\"_X=hT?GUmJlBA\";i:164;s:35:\"XE=hT?GU~AlBMM.4FxrjCAI7=hT?GUGJlBA\";i:165;s:13:\"VE=hT?GUatlBA\";i:166;s:13:\"VE=hT?GU>xlBA\";i:167;s:13:\"i==hT?GU2JlBA\";i:168;s:12:\"EH=hT?GUpA$A\";i:169;s:12:\"EH=hT?GU5A$A\";i:170;s:12:\"EH=hT?GU/A$A\";i:171;s:24:\"`X=hT?GU>BlBwM.4FxrjAABA\";i:172;s:12:\"A^=hT?GUZA$A\";i:173;s:13:\"A^=hT?GU9ElBA\";i:174;s:24:\"`X=hT?GUBIlBwM.4FxrjAABA\";i:175;s:12:\"A^=hT?GUZA$A\";i:176;s:13:\"A^=hT?GU9ElBA\";i:177;s:24:\"`X=hT?GU+JlBwM.4FxrjAABA\";i:178;s:12:\"A^=hT?GUZA$A\";i:179;s:13:\"A^=hT?GU9ElBA\";i:180;s:24:\"`X=hT?GU{JlBwM.4FxrjAABA\";i:181;s:12:\"A^=hT?GUZA$A\";i:182;s:13:\"A^=hT?GU9ElBA\";i:183;s:24:\"`X=hT?GULKlBwM.4FxrjAABA\";i:184;s:12:\"A^=hT?GUZA$A\";i:185;s:13:\"A^=hT?GU9ElBA\";i:186;s:24:\"`X=hT?GUbKlBwM.4FxrjAABA\";i:187;s:12:\"A^=hT?GUZA$A\";i:188;s:13:\"A^=hT?GU9ElBA\";i:189;s:24:\"`X=hT?GUrKlBwM.4FxrjAABA\";i:190;s:12:\"A^=hT?GUZA$A\";i:191;s:13:\"A^=hT?GU9ElBA\";i:192;s:24:\"`X=hT?GU>BlBwM.4FxrjAABA\";i:193;s:13:\"A^=hT?GU9ElBA\";i:194;s:24:\"`X=hT?GUBIlBwM.4FxrjAABA\";i:195;s:13:\"A^=hT?GU9ElBA\";i:196;s:24:\"`X=hT?GU+JlBwM.4FxrjAABA\";i:197;s:13:\"A^=hT?GU9ElBA\";i:198;s:24:\"`X=hT?GU{JlBwM.4FxrjAABA\";i:199;s:13:\"A^=hT?GU9ElBA\";i:200;s:24:\"`X=hT?GULKlBwM.4FxrjAABA\";i:201;s:13:\"A^=hT?GU9ElBA\";i:202;s:24:\"`X=hT?GUbKlBwM.4FxrjAABA\";i:203;s:13:\"A^=hT?GU9ElBA\";i:204;s:24:\"`X=hT?GUrKlBwM.4FxrjAABA\";i:205;s:13:\"A^=hT?GU9ElBA\";i:206;s:24:\"`X=hT?GU>BlBwM.4FxrjAABA\";i:207;s:13:\"A^=hT?GU9ElBA\";i:208;s:24:\"`X=hT?GUBIlBwM.4FxrjAABA\";i:209;s:13:\"A^=hT?GU9ElBA\";i:210;s:24:\"`X=hT?GU+JlBwM.4FxrjAABA\";i:211;s:13:\"A^=hT?GU9ElBA\";i:212;s:24:\"`X=hT?GU{JlBwM.4FxrjAABA\";i:213;s:13:\"A^=hT?GU9ElBA\";i:214;s:24:\"`X=hT?GULKlBwM.4FxrjAABA\";i:215;s:13:\"A^=hT?GU9ElBA\";i:216;s:24:\"`X=hT?GUbKlBwM.4FxrjAABA\";i:217;s:13:\"A^=hT?GU9ElBA\";i:218;s:24:\"`X=hT?GUrKlBwM.4FxrjAABA\";i:219;s:13:\"A^=hT?GU9ElBA\";i:220;s:24:\"`X=hT?GU?ulBwM.4Fxrj$ABA\";i:221;s:13:\"A^=hT?GU!xlBA\";i:222;s:24:\"`X=hT?GUC1lBwM.4Fxrj$ABA\";i:223;s:13:\"A^=hT?GU!xlBA\";i:224;s:24:\"`X=hT?GU,2lBwM.4Fxrj$ABA\";i:225;s:13:\"A^=hT?GU!xlBA\";i:226;s:24:\"`X=hT?GU|2lBwM.4Fxrj$ABA\";i:227;s:13:\"A^=hT?GU!xlBA\";i:228;s:24:\"`X=hT?GUM3lBwM.4Fxrj$ABA\";i:229;s:13:\"A^=hT?GU!xlBA\";i:230;s:24:\"`X=hT?GUc3lBwM.4Fxrj$ABA\";i:231;s:13:\"A^=hT?GU!xlBA\";i:232;s:24:\"`X=hT?GUs3lBwM.4Fxrj$ABA\";i:233;s:13:\"A^=hT?GU!xlBA\";i:234;s:167:\"C3=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCA%$=hT?GU!BlB,L.4FxrjCAw(=hT?GU!BlB(L.4FxrjCA[Q>hT?GU!BlB}M.4FxrjCA};=hT?GU>BlBBN.4Fx}MLAeZ>hT?GU7KlBJN.4Fx}MLA|e>hT?GU<HlBA\";i:235;s:13:\"VE=hT?GU~AlBA\";i:236;s:46:\"l==hT?GU;KlBRN.4Fx~5PA1k>hT?GU>BlBZN.4Fx~5CABA\";i:237;s:61:\"2d=hT?GUjClB8M.4?zs@BAq1,HlBuGkcwYX`M\"~l_Q3nE3.E$AkDSOYM@1GtA\";i:238;s:13:\"VE=hT?GU~AlBA\";i:239;s:12:\"4r>hT?GUZA$A\";i:240;s:135:\"yu>hT?GUQLlBlN.4FxrjCAvW=hT?GU>BlBYM.4FxrjCA+h=hT?GU!BlBcM.4FxrjCA|e=hT?GU!BlBIM.4FxrjCAZ4=hT?GU!BlBQM.4Fxs@FA]9=hT?GU!BlBoM.4Fx}M2H6FA\";i:241;s:24:\"ig>hT?GUgLlBfL.4Fx}MBABA\";i:242;s:17:\"9M>hT?IUwLlB%RAAB\";i:243;s:12:\"F0>hT?GUZA$A\";i:244;s:13:\"KV>hT?GU!BlBA\";i:245;s:13:\"bS>hT?GU!BlBA\";i:246;s:35:\"pu=hT?GU>BlB?L.4Fx~5EAq1>hT?GU$LlBA\";i:247;s:58:\"ru=hT?GU>BlB1N.4Fx}MLANc=hT?GUjClB_M.4Fx}MMl6F?zLvSQ[zJAEA\";i:248;s:57:\"&5>hT?GU@LlBrL.4Fxs@(Akn=hT?GUFMlB3L.4Fx}MRA7y=hT?GUOBlBA\";i:249;s:218:\"oC!u)\",ub@_w5F:yLvSQ[z+A:>it,ub@ey5FO2LvSQ[zBD2W?\",ub@Dz5FRtLvSQ[zFA/hkt,uj@ZR5F>+kA`9%(k)NoUa:C(XzXJI{ZJAln#(k)NoMS:CdZzXJI{ZgAln$(k)No0a:CzXzXJI{ZmADt$(k)No6I:CrXzXJI{ZmA,h&(k)NoyAlB;L.4Fxs@MAvW=hT?GUYDlBnL.4FxrjTABA\";i:250;s:68:\"xP=hT?GU(ClBzL.4Fx~5TA1k=hT?GU\"NlB7L.4FxrjCA%$>hT?GUPOlB1N.4FxrjUABA\";i:251;s:155:\"iE=hT?GU~AlBnL.4FxrjTA};=hT?GUcHlBNN.4Fx~5UA1k=hT?GU:NlB?L.4Fxs@UAD\"_Q3nE3fH$AGDSOYM@1Bt@Q_Q3nE36G$AHDSOYM@1BtrP_Q3nE36G$A_CSOYMifFtJV_Q3nE3nH$A^CSOYM5qBtA\";i:252;s:24:\"LV>hT?GUEPlB5N.4Fx~5VABA\";i:253;s:57:\"wP=hT?GU(ClB3L.4Fx~5CA+h>hT?GUOBlB;L.4FxrjCA[Q=hT?GU!BlBA\";i:254;s:13:\"_X=hT?GU_PlBA\";i:255;s:13:\"nu=hT?GUJQlBA\";i:256;s:46:\"]2=hT?GU!BlBMM.4Fx~5EAI7=hT?GU!BlBUM.4Fx~5EABA\";i:257;s:46:\"]2=hT?GU!BlBMM.4Fx}MXAI7=hT?GU!BlBUM.4Fx}MXABA\";i:258;s:35:\"{X=hT?GUpQlBsM.4Fx}MBAHO=hT?GUDClBA\";i:259;s:24:\"`X=hT?GU>BlB|L.4Fxrj$ABA\";i:260;s:35:\"{X=hT?GU8HlBsM.4Fxs@AAI7=hT?GUhIlBA\";i:261;s:13:\"F0=hT?GUOBlBA\";i:262;s:13:\"sP=hT?GUDClBA\";i:263;s:24:\"`X=hT?GU?ulB|L.4Fxrj$ABA\";i:264;s:24:\"`X=hT?GU?ulB|L.4Fxrj$ABA\";i:265;s:78:\"X@=hT?GUZA$AGDSOYM@1Bt@Q_Q3nE3<AgAxBJHNz`auW(HqI:$vbmAQA)\",ub@nH7F;vLvSQ[z;CIA\";i:266;s:12:\"R@=hT?GU5A$A\";i:267;s:12:\"R@=hT?GU/A$A\";i:268;s:13:\"_X=hT?GU?ulBA\";i:269;s:13:\"`)=hT?GUtElBA\";i:270;s:13:\"`)=hT?GU!BlBA\";i:271;s:13:\"yd=hT?GUnGlBA\";i:272;s:46:\"O&=hT?GUtElB,L.4FxrjFAw(=hT?GUtElB(L.4FxrjFABA\";i:273;s:68:\"~X=hT?GU5QlBIM.4FxrjCAZ4=hT?GUYDlBQM.4FxrjCA]9=hT?GUYDlB#L.4FxrjDABA\";i:274;s:46:\"|X=hT?GUZwlB|L.4Fxrj$A|e=hT?GU.DlB,L.4FxrjFABA\";i:275;s:13:\"nu=hT?GU>BlBA\";i:276;s:13:\"4r=hT?GU/QlBA\";i:277;s:24:\"ig=hT?GU#ulB,L.4Fxrj&ABA\";i:278;s:13:\"Wx=hT?GUaNlBA\";i:279;s:13:\"Wx=hT?GU.DlBA\";i:280;s:46:\"O&=hT?GUaNlB,L.4Fxs@SAw(=hT?GUaNlB(L.4Fxs@SABA\";i:281;s:13:\"_X=hT?GUaNlBA\";i:282;s:13:\"/o=hT?GUaNlBA\";i:283;s:35:\"0d=hT?GUfOlBrL.4Fx}MCAYL=hT?GU~QlBA\";i:284;s:24:\"Am=hT?GU!BlBvL.4FxrjCABA\";i:285;s:13:\"KV=hT?GU!BlBA\";i:286;s:13:\"Wx=hT?GU!BlBA\";i:287;s:24:\"LV=hT?GU!BlBAM.4FxrjCABA\";i:288;s:13:\"\"l=hT?GU!BlBA\";i:289;s:13:\"bS=hT?GU!BlBA\";i:290;s:68:\"&M>hT?GUORlBbL.4FxrjBAkn=hT?GU!BlBwM.4Fx~5GApI=hT?GUOBlB%N.4Fxs@BABA\";i:291;s:13:\"A^=hT?GU9ElBA\";i:292;s:46:\"]2=hT?GU!BlBMM.4Fx~5YAI7=hT?GU!BlBUM.4Fx~5YABA\";i:293;s:100:\"Z@=hT?GU/A$ACDSOYM@1BtMc_Q3nE3<Ai\"vBJHNzd&uWrPqI:$vbmARtwBJHNz`auWoIqI:$vbICgAxBJHNz`auW(HqI:$vbICgA\";i:294;s:23:\"S@=hT?GUZA$A]CSOYMu7BtA\";i:295;s:13:\"_X=hT?GUBIlBA\";i:296;s:13:\"_X=hT?GUuRlBA\";i:297;s:13:\"_X=hT?GU{JlBA\";i:298;s:13:\"_X=hT?GULKlBA\";i:299;s:13:\"_X=hT?GU!RlBA\";i:300;s:13:\"_X=hT?GU>RlBA\";i:301;s:24:\"d#=hT?GU!BlBMM.4FxrjCABA\";i:302;s:35:\"jg=hT?GU!BlB,L.4FxrjCAI7=hT?GU!BlBA\";i:303;s:24:\"d#=hT?GUDSlBMM.4Fx~5ZABA\";i:304;s:35:\"jg=hT?GUTSlB,L.4Fxs@ZAI7=hT?GUFMlBA\";i:305;s:24:\"d#=hT?GUjSlBMM.4Fx}MaABA\";i:306;s:35:\"jg=hT?GUzSlB,L.4FxrjaAI7=hT?GUGJlBA\";i:307;s:24:\"d#=hT?GU(SlBMM.4Fx~5aABA\";i:308;s:35:\"jg=hT?GUGJlB,L.4Fxs@MAI7=hT?GUhIlBA\";i:309;s:24:\"d#=hT?GU^SlBMM.4Fxs@aABA\";i:310;s:35:\"jg=hT?GUITlB,L.4Fx}MbAI7=hT?GUaNlBA\";i:311;s:24:\"d#=hT?GUeRlBMM.4Fx~5YABA\";i:312;s:35:\"jg=hT?GUhIlB,L.4Fxs@LAI7=hT?GUNElBA\";i:313;s:24:\"d#=hT?GUYTlBMM.4FxrjbABA\";i:314;s:35:\"jg=hT?GUoTlB,L.4Fx~5bAI7=hT?GUMHlBA\";i:315;s:24:\"d#=hT?GUZQlBMM.4Fx}MXABA\";i:316;s:35:\"jg=hT?GUaNlB,L.4Fxs@SAI7=hT?GU.DlBA\";i:317;s:24:\"d#=hT?GU4TlBMM.4Fxs@bABA\";i:318;s:35:\"jg=hT?GU.TlB,L.4Fx}McAI7=hT?GU}TlBA\";i:319;s:24:\"d#=hT?GUNUlBMM.4Fx~5cABA\";i:320;s:35:\"jg=hT?GUNElB,L.4Fxs@FAI7=hT?GUtElBA\";i:321;s:24:\"d#=hT?GUdUlBMM.4Fxs@cABA\";i:322;s:35:\"jg=hT?GUMHlB,L.4Fx}MKAI7=hT?GUSFlBA\";i:323;s:24:\"d#=hT?GUtUlBMM.4Fx}MdABA\";i:324;s:35:\"jg=hT?GU.DlB,L.4FxrjFAI7=hT?GU9UlBA\";i:325;s:100:\"Z@=hT?GU/A$ACDSOYM@1BtMc_Q3nE3<Ai\"vBJHNzd&uWrPqI:$vbmARtwBJHNz`auWoIqI:$vbICgAxBJHNz`auW(HqI:$vbICgA\";i:326;s:13:\"_X=hT?GUBIlBA\";i:327;s:13:\"_X=hT?GUuRlBA\";i:328;s:13:\"_X=hT?GU{JlBA\";i:329;s:13:\"_X=hT?GULKlBA\";i:330;s:13:\"_X=hT?GU!RlBA\";i:331;s:24:\"WE=hT?GU~AlBsM.4Fx}MBABA\";i:332;s:13:\"_X=hT?GUBIlBA\";i:333;s:13:\"_X=hT?GUuRlBA\";i:334;s:13:\"_X=hT?GU{JlBA\";i:335;s:13:\"_X=hT?GULKlBA\";i:336;s:13:\"_X=hT?GU=UlBA\";i:337;s:24:\"d#=hT?GU!BlBMM.4FxrjCABA\";i:338;s:90:\"{2=hT?GU#ulBMM.4Fxrj&AI7=hT?GU#ulBUM.4Fxrj&A%$=hT?GU#ulB,L.4Fxrj&Aw(=hT?GU#ulB(L.4Fxrj&ABA\";i:339;s:13:\"_X=hT?GUCVlBA\";i:340;s:13:\"_X=hT?GUSVlBA\";i:341;s:24:\"B^=hT?GU9ElBUM.4FxrjCABA\";i:342;s:12:\"A^=hT?GUZA$A\";i:343;s:24:\"*,>hT?GUiVlB/N.4Fx~5eABA\";i:344;s:13:\"yd>hT?GU&VlBA\";i:345;s:13:\"hg>hT?GU]VlBA\";i:346;s:13:\"t8>hT?GUHWlBA\";i:347;s:13:\"i==hT?GUXWlBA\";i:348;s:37:\"k==hT?GUnWlB8M.4Fx}M1\":CPbzXJI{ZwCZLA\";i:349;s:58:\"qB>hT?GU}j%A]Q$(k)NohD:CYYzXJI|+EAOc$(k)NoaI:CoYzXJI|+EACA\";i:350;s:36:\"*a>hT?GU7KlBrL.4Fxs@CA1k=hT?GU~@%ACA\";i:351;s:13:\"\"l=hT?GUXGlBA\";i:352;s:13:\"yd>hT?GU&VlBA\";i:353;s:12:\"c#>hT?GUZA$A\";i:354;s:13:\"i==hT?GU[IlBA\";i:355;s:14:\"i==hT?GU}j&ACA\";i:356;s:14:\"i==hT?GU~@&ACA\";i:357;s:14:\"i==hT?GU}j(ACA\";i:358;s:13:\"i==hT?GU2JlBA\";i:359;s:13:\"i==hT?GUdElBA\";i:360;s:13:\"i==hT?GU3GlBA\";i:361;s:13:\"i==hT?GUyFlBA\";i:362;s:14:\"i==hT?GU~@(ACA\";i:363;s:13:\"c#>hT?GUUPlBA\";i:364;s:80:\"ng>hT?GU]VlB1N.4FxrjfAD\"_Q3nE3\"!gAq1=hT?GU.DlBMM.4FxrjCAI7=hT?GUNElBUM.4FxrjCABA\";i:365;s:13:\"t8>hT?GU<HlBA\";i:366;s:12:\"c#>hT?GUZA$A\";i:367;s:58:\"m==hT?GU}j)A]Q$(k)NohD:CYYzXJI|+EAOc$(k)NoaI:CoYzXJI|+EACA\";i:368;s:13:\"i==hT?GUnWlBA\";i:369;s:14:\"i==hT?GU~@)ACA\";i:370;s:14:\"i==hT?GU}j*ACA\";i:371;s:14:\"i==hT?GU~@*ACA\";i:372;s:14:\"i==hT?GU}j+ACA\";i:373;s:14:\"mB>hT?GU}j%ACA\";i:374;s:106:\"q=>hT?GUTClB[N.4Fx}M$J6F(3LvSQ[z5pyW3rqI:$vbu<T\"4}_Q3nE3\"!jAq1=hT?GU!BlBMM.4FxrjCAI7=hT?GUnWlBUM.4FxrjCABA\";i:375;s:14:\"hg>hT?GU~@RCEA\";i:376;s:13:\"t8>hT?GUkvlBA\";i:377;s:119:\"vB?hT?GU}j.A7F((k)No`,2BJt]\",ub@=1UDRtqBJHNzij\"M$ACDSOYMifCtMc_Q3nE3<Ai\"vBJHNz#8uWrPqI:$vbmARtyBJHNzij9L$AkDSOYM*+OalBA\";i:378;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:379;s:57:\"V@=hT?GU/A$ADDSOYM5qCt:C_Q3nE3cAgAwBJHNz`auW5FqI:$vbX%U\"A\";i:380;s:57:\"V@=hT?GU5A$AFDSOYM5qCt:C_Q3nE3kAgAvBJHNz`auW5FqI:$vbX%U\"A\";i:381;s:123:\"wB?hT?GUZA$AGDSOYM@1Bt@Q_Q3nE3<AgAxBJHNz`auW(HqI:$vbmARtuBJHNz`auWGOqI:$vbmARtvBJHNz`auWrPqI:$vbmARtyBJHNzijSM$AkDSOYM*+DtA\";i:382;s:19:\"t8>hT?IUjClBrzC15FA\";i:383;s:13:\"c#>hT?GUUPlBA\";i:384;s:13:\"t8>hT?GUjClBA\";i:385;s:13:\"c#>hT?GUUPlBA\";i:386;s:13:\"t8>hT?GUHWlBA\";i:387;s:13:\"c#>hT?GUUPlBA\";i:388;s:14:\">J?hT?GU~@;ACA\";i:389;s:14:\"hg>hT?GU}jWCEA\";i:390;s:14:\"hg>hT?GU~@WCEA\";i:391;s:14:\"hg>hT?GU~@RCEA\";i:392;s:13:\"hg>hT?GUh4lBA\";i:393;s:14:\"hg>hT?GU}jXCEA\";i:394;s:13:\"hg>hT?GU^&lBA\";i:395;s:13:\"hg>hT?GUw7lBA\";i:396;s:14:\"hg>hT?GU~@XCEA\";i:397;s:14:\"hg>hT?GU}jYCEA\";i:398;s:13:\"t8>hT?GU=0lBA\";i:399;s:13:\"t8>hT?GUI(lBA\";i:400;s:13:\"t8>hT?GUkvlBA\";i:401;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GUNElBUM.4FxrjFABA\";i:402;s:14:\"4r>hT?GU~@>ACA\";i:403;s:14:\"4r>hT?GU}j?ACA\";i:404;s:90:\"{2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCA%$=hT?GU!BlB,L.4FxrjCAw(=hT?GU!BlB(L.4FxrjCABA\";i:405;s:56:\"^2=hT?GU!BlBMM.4FxrjCAI7=hT?GUNElBUM.4FxrjCATq>hT?GUZA$A\";i:406;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GUGJlBUM.4FxrjCABA\";i:407;s:49:\"|X>hT?GU~@?AwW%(k)No`,*BK\"jt,ub@}k5F2uLvSQ[zFFzWA\";i:408;s:94:\"iS>hT?GU}j[AwW((k)No`,.B2W/\",ub@!S5FgwLvSQ[ztNzWGOqI:$vbmARtvBJHNzijsO$AFDSOYM@1Bt#T_Q3nE3<AgA\";i:409;s:192:\"$d=hT?GU~@]ADt%(k)No`,;B2W?\",ub@\"!5FFxLvSQ[zXAFtit,ub@0Q5FVxLvSQ[zXA/hit,ub@0Q5FgwLvSQ[zJAFtjt,ub@&G5F$wLvSQ[zXAz(jt,ub@&G5FN5Lv|x[z`VzWhNuxM\"hNM3Lt(atfVAqI`Q3nE3t`qA$T?hT?GU}j{A^9$(k)No`,]BIA\";i:410;s:69:\"aE=hT?GU~AlBsM.4Fx}MBAZ4=hT?GUhIlBQM.4Fxs@LA};=hT?GU}j|ACA>hT?GU>BlBA\";i:411;s:68:\"y8>hT?GUjClB#L.4FxrjfA%$=hT?GUGJlB,L.4Fxs@LAw(=hT?GUGJlB(L.4Fxs@LABA\";i:412;s:26:\"zd=hT?GU~@|AOc&(k)No`,`BIA\";i:413;s:79:\"o==hT?GU>BlB8M.4Fx}MLAq1=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCAeZ>hT?GU7KlBA\";i:414;s:195:\"oCAY&\",ub@jT5Fe2LvSQ[z~A3(,\",ub@=1]DQA*\",ub@}k5FVxLvSQ[zGyzW(HqI:$vbcCgA5BJHNzijvWWeqI:$vb|Bi\"yBJHNzijSM$APDSOYMXwGtuW_Q3nE3_AgA4BJHNzij%P$A_CSOYMj<Btmu_Q3nE3SG$A3DSOYM?IBt8M`Q3nE3MAgA:BJHNznEuWA\";i:415;s:13:\"KV>hT?GU!BlBA\";i:416;s:14:\"EH>hT?GU~@~AEA\";i:417;s:24:\"u8>hT?GU)PlB8M.4FxrjcABA\";i:418;s:13:\"/o=hT?GU}TlBA\";i:419;s:12:\"VE=hT?GUZA$A\";i:420;s:56:\"}X=hT?GU>BlB|L.4Fx~5CAvW?hT?GUZA$A4DSOYM?IBtGO`Q3nE3MAgA\";i:421;s:14:\"!5=hT?GU~@\"AEA\";i:422;s:14:\"4r=hT?GU}jABEA\";i:423;s:14:\"4r=hT?GU~@ABEA\";i:424;s:25:\"u8>hT?GU<HlB7L.4Fx}M{n6FA\";i:425;s:25:\"u8>hT?GU<HlB7L.4Fx}M{n6FA\";i:426;s:25:\"u8>hT?GU<HlB7L.4Fx}M{n6FA\";i:427;s:25:\"u8>hT?GU<HlB7L.4Fx}M{n6FA\";i:428;s:81:\"R&=hT?GUNElB,L.4Fxs@FAw(=hT?GUNElB(L.4Fxs@FAI7=hT?GUtElB#L.4Fx}M1a6F#zLvSQ[z0.zWA\";i:429;s:57:\"m==hT?GU[IlBIM.4FxrjCAZ4=hT?GU!BlBQM.4Fxs@LA]9=hT?GU!BlBA\";i:430;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:431;s:35:\";o=hT?GUtElBYM.4FxrjCAw(=hT?GU!BlBA\";i:432;s:36:\"0d=hT?GUjClB3L.4Fx}Mgp6F`xLvSQ[zEAEA\";i:433;s:115:\"a@=hT?GU5A$A]CSOYM*+BhlBoM.4Fx}M2H6FrvLvSQ[zZAEA%(k)No\"I:CoYzXJI{Zv`ZLIIVElg*NTAK\"it,ub@wc5FVxLvSQ[zJA/hit,ub@wc5FA\";i:434;s:14:\"yd=hT?GU~@]ACA\";i:435;s:48:\"vP=hT?GUDClB_M.4Fx}M&j6F:yLvSQ[z+Ac4nt,ub@=1=CQA\";i:436;s:239:\"oCgY(\",ub@MI5F%tLvSQ[zMAG\"#(k)No%D:C^XzXJI{ZFAa4#(k)No`,HCJt;\",ub@&G5F?zLvSQ[zJA:>jt,ub@&G5FLvLvSQ[zVAG\"$(k)NohD:CrXzXJI{ZnAOc&(k)No9P:C(XzXJI{Ze}ZLXLVElg*NY^MtJV_Q3nE3MAgA*BJHNznEuW6yqI:$vbGARt/BJHNznEuWE0qI:$vbGARt:BJHNzij>Q$AQDSOYM@1BtA\";i:437;s:13:\"VE=hT?GU=ElBA\";i:438;s:13:\"_X=hT?GUYDlBA\";i:439;s:12:\"VE=hT?GUZA$A\";i:440;s:113:\"1P=hT?GU(ClBnL.4Fxs@BA<v=hT?GUhIlB;L.4FxrjLA};=hT?GUyFlB?L.4Fxs@FAD\"_Q3nE3GC$ACDSOYMtOHty:_Q3nE3^D$A^CSOYM*+oclBA\";i:441;s:26:\"zd=hT?GU}jFByWlt,ub@=1XEQA\";i:442;s:13:\"t8=hT?GUaNlBA\";i:443;s:13:\"?2=hT?GUlMlBA\";i:444;s:14:\"EH>hT?GU}jGBEA\";i:445;s:109:\"T&=hT?GU}j*Ax(#(k)No`,NCIAkt,ub@=1EDRtqBJHNzijTR$A_CSOYM*+2ilB_M.4Fx}MIx6FhtLvSQ[zCAc4nt,ub@=1hERt6BJHNz4BwWA\";i:446;s:13:\"c#=hT?GUhIlBA\";i:447;s:34:\"k==hT?GU3GlBUM.4Fxs@LA;C=hT?GUZA$A\";i:448;s:30:\"WE=hT?IU~AlBUoDA9M_Q3nE3sooABA\";i:449;s:13:\"_X=hT?GU>BlBA\";i:450;s:13:\"hg=hT?GUNElBA\";i:451;s:13:\"hg=hT?GU!BlBA\";i:452;s:13:\"_X=hT?GU>BlBA\";i:453;s:156:\"5P=hT?GU(ClBEM.4Fx~5BAZ4>hT?GU@LlB?L.4Fx}MRAvW=hT?GUFMlBIM.4FxrjCAZ4=hT?GU!BlBQM.4FxrjCA]9=hT?GU!BlBYM.4FxrjCA+h=hT?GU!BlBcM.4FxrjCA|e=hT?GU!BlB_M.4FxrjCABA\";i:454;s:24:\"d#=hT?GU!BlBMM.4Fxs@FABA\";i:455;s:13:\"VE=hT?GUatlBA\";i:456;s:46:\"]2=hT?GUNElBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:457;s:110:\"q==hT?GU~@IB:>jt,ub@=1EDQA*\",ub@=1bEQA.\",ub@=1EDRtqBJHNzijTR$AkDSOYM*+bjlB#L.4Fx}M]z6FhtLvSQ[zCAz(lt,ub@=1pEQA\";i:458;s:50:\"O&=hT?GU}j*Ax(#(k)No`,NCIAkt,ub@=1EDRtqBJHNzijTR$A\";i:459;s:126:\"~2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCA%$=hT?GUhIlB,L.4Fxs@LAw(=hT?GUhIlB(L.4Fxs@LANc=hT?GU~@KBc4nt,ub@=1tES\";\",ub@=1vEQA\";i:460;s:46:\"]2=hT?GUhIlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:461;s:13:\"sP=hT?GUDClBA\";i:462;s:13:\"VE=hT?GU~AlBA\";i:463;s:34:\"k==hT?GU3GlBUM.4Fxs@LA;C=hT?GUZA$A\";i:464;s:56:\"ZE=hT?GUZA$ACDSOYM6|DtMc_Q3nE3<Ai\"vBJHNz`auWrPqI:$vbmAQA\";i:465;s:13:\"VE=hT?GU~AlBA\";i:466;s:14:\"t8>hT?GU}jMBEA\";i:467;s:37:\"0d=hT?GUkvlB1N.4Fx}Mm38F\"yLvSQ[z;^7WA\";i:468;s:13:\"t8>hT?GUjClBA\";i:469;s:14:\"(a=hT?GU~@MBEA\";i:470;s:36:\"oB?hT?GUZA$AkDSOYMj<Btp1_Q3nE3~R0ABA\";i:471;s:14:\"4r=hT?GU~@ABEA\";i:472;s:14:\"bS>hT?GU~@yCEA\";i:473;s:14:\"t8>hT?GU}jOBEA\";i:474;s:14:\"t8>hT?GU}jOBEA\";i:475;s:48:\"pB?hT?GUatlB1N.4Fx}M`68F#zLvSQ[zu68WTXqI:$vb9LgA\";i:476;s:25:\"u8>hT?GU~@PB/hkt,ub@Vd5FA\";i:477;s:37:\"0d=hT?GU}jQBz(lt,ub@&G5Fe2LvSQ[z#30WA\";i:478;s:14:\"4r=hT?GU~@ABEA\";i:479;s:14:\"bS>hT?GU~@yCEA\";i:480;s:14:\"t8>hT?GU}jOBEA\";i:481;s:14:\"t8>hT?GU}jOBEA\";i:482;s:74:\"3d=hT?GUjClB1N.4Fx}M)96F#zLvSQ[z**0WTXqI:$vbA2Z\"JV_Q3nE3so2A%$>hT?GU}jSBEA\";i:483;s:47:\"1d=hT?GUjClB1N.4FxrjfA[Q>hT?GU~@SB:>it,ub@JB5FA\";i:484;s:25:\"u8>hT?GU~@PB/hkt,ub@Vd5FA\";i:485;s:14:\"bS>hT?GU~@yCEA\";i:486;s:13:\"t8>hT?GUjClBA\";i:487;s:13:\"t8>hT?GUjClBA\";i:488;s:14:\"t8>hT?GU}jMBEA\";i:489;s:47:\"pB?hT?GUatlB1N.4Fxrj(A[Q>hT?GU}jyCbLlt,ub@&G5FA\";i:490;s:13:\"t8>hT?GUjClBA\";i:491;s:24:\")a=hT?GUeBlBoM.4FxrjKABA\";i:492;s:14:\"9M>hT?GU}jTBEA\";i:493;s:14:\"4r=hT?GU~@ABEA\";i:494;s:24:\"zd=hT?GUjClB_M.4FxrjCABA\";i:495;s:14:\"EH>hT?GU~@4CEA\";i:496;s:13:\"t8>hT?GUHWlBA\";i:497;s:13:\"t8>hT?GUHWlBA\";i:498;s:35:\"0d=hT?GUI(lB1N.4Fxrj(A6F>hT?GUI(lBA\";i:499;s:14:\"4r=hT?GU}jUBEA\";i:500;s:13:\"(a=hT?GUeBlBA\";i:501;s:36:\"oB?hT?GUZA$AkDSOYMj<Itp1_Q3nE3t`3ABA\";i:502;s:14:\"bS>hT?GU~@yCEA\";i:503;s:13:\"t8>hT?GUHWlBA\";i:504;s:13:\"t8>hT?GUHWlBA\";i:505;s:47:\"pB?hT?GUatlB1N.4FxrjEB,h%(k)No`,YF2W:\",ub@&G5FA\";i:506;s:12:\"4r=hT?GUZA$A\";i:507;s:24:\")a=hT?GUeBlBoM.4FxrjKABA\";i:508;s:14:\"9M>hT?GU}jTBEA\";i:509;s:35:\"0d=hT?GUHWlB_M.4FxrjCAI7>hT?GUjClBA\";i:510;s:14:\"EH>hT?GU~@4CEA\";i:511;s:13:\"_X=hT?GU?ulBA\";i:512;s:50:\"O&=hT?GU}jVBFtit,ub@=1bEQA.\",ub@=1`ERtqBJHNzijTR$A\";i:513;s:13:\"VE=hT?GU~AlBA\";i:514;s:13:\"_X=hT?GU>BlBA\";i:515;s:14:\"i==hT?GU~@)ACA\";i:516;s:71:\"~X=hT?GU>BlBoM.4Fx}M2H6F7vLvSQ[zFF1W&aqI:$vbtfe\"&a_Q3nE3QE$AQDSOYMAlFtA\";i:517;s:38:\"GH>hT?GU~@WB:>it,ub@=1CFRt#BJHNzijSU$A\";i:518;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:519;s:25:\"u8>hT?GU}jYBz(nt,ub@JB5FA\";i:520;s:264:\"oCwY&\",ub@jT5F+uLvSQ[z[Ac4nt,ub@xJ5FFxLvSQ[z`V1WoIqI:$vbUCgAxBJHNzijiU$A`CSOYMtOEtY4_Q3nE3^D$AKDSOYM*+yelBNN.4Fx}M$/6FgwLvSQ[zJAFtjt,ub@&G5F$wLvSQ[zJAz(jt,ub@&G5F#zLvSQ[zJA/hqt,ub@=1TEQA:\",ub@a!5F95LvSQ[zBAbLot,ub@ff5Fu2LvSQ[z;CIAjt,ub@nH5F!2LvSQ[zzb1WTXqI:$vbJDgA\";i:521;s:13:\"t8>hT?GUjClBA\";i:522;s:46:\"]2=hT?GU#ulBMM.4Fxrj&AI7=hT?GU#ulBUM.4Fxrj&ABA\";i:523;s:36:\"0d=hT?GU}jaBc4nt,ub@xJ5Fu2LvSQ[zBAEA\";i:524;s:13:\"t8>hT?GUjClBA\";i:525;s:26:\"zd=hT?GU}j1Cc4nt,ub@=1xEQA\";i:526;s:13:\"L&>hT?GUPOlBA\";i:527;s:60:\"x8>hT?GUjClBSO.4Fx}M:;6F#zLvSQ[zAk1WyKqI:$vbX%f\"mu_Q3nE3SG$A\";i:528;s:14:\"4r=hT?GU}jcBEA\";i:529;s:37:\"v8>hT?GUjClB2O.4Fx}M5>6F:yLvSQ[zXv1WA\";i:530;s:14:\"EH>hT?GU~@DBEA\";i:531;s:13:\"_X=hT?GU>BlBA\";i:532;s:14:\"yd=hT?GU~@dBEA\";i:533;s:14:\"yd=hT?GU}jeBEA\";i:534;s:14:\"yd=hT?GU~@eBEA\";i:535;s:14:\"yd=hT?GU~@PBEA\";i:536;s:14:\"yd=hT?GU~@XBEA\";i:537;s:14:\"yd=hT?GU}jMBEA\";i:538;s:14:\"yd=hT?GU}jfBEA\";i:539;s:14:\"yd=hT?GU~@fBEA\";i:540;s:14:\"yd=hT?GU}jgBEA\";i:541;s:14:\"yd=hT?GU~@gBEA\";i:542;s:14:\"yd=hT?GU}jhBEA\";i:543;s:14:\"yd=hT?GU~@hBEA\";i:544;s:14:\"yd=hT?GU}jiBEA\";i:545;s:14:\"yd=hT?GU~@iBEA\";i:546;s:14:\"yd=hT?GU}jjBEA\";i:547;s:14:\"yd=hT?GU~@jBEA\";i:548;s:14:\"yd=hT?GU}jkBEA\";i:549;s:14:\"yd=hT?GU~@kBEA\";i:550;s:15:\"yd=hT?GUO[AA5FA\";i:551;s:15:\"yd=hT?GUO[lBXLA\";i:552;s:15:\"yd=hT?GUO[:CXLA\";i:553;s:15:\"yd=hT?GUO[UEXLA\";i:554;s:15:\"yd=hT?GUO[5FXLA\";i:555;s:15:\"yd=hT?GUO[DHXLA\";i:556;s:24:\"zd=hT?GUjClB1N.4FxrjfABA\";i:557;s:13:\"yd=hT?GUjClBA\";i:558;s:15:\"(a=hT?GUO[oIXLA\";i:559;s:61:\"x8>hT?GU~@OBEA((k)NoyAlB_M.4FxrjYBOA3(<\",ub@3|5F:yLvSQ[zXv1WA\";i:560;s:12:\"mB?hT?GUZA$A\";i:561;s:25:\"FH>hT?GU~@oC:>it,ub@JB5FA\";i:562;s:25:\"u8>hT?GUjClB)M.4Fx}Mqr8FA\";i:563;s:25:\"u8>hT?GUjClB)M.4Fx}Mqr6FA\";i:564;s:77:\"y8>hT?GUO[XLXLhNVElg*NAbOtC\"qI:$vbaUPD:CaazXJI{Z!A7F%(k)No`,6C3(*\",ub@y2b4BtA\";i:565;s:13:\"t8>hT?GUHWlBA\";i:566;s:14:\"t8>hT?GU~@$ACA\";i:567;s:15:\"4r=hT?GUO[rPXLA\";i:568;s:48:\"pB?hT?GUZA$AkDSOYM*+VllB_M.4Fx}MMl6F:yLvSQ[zJAEA\";i:569;s:26:\"zd=hT?GU~@]AOc&(k)No`,YCIA\";i:570;s:14:\"EH>hT?GU~@XBEA\";i:571;s:14:\"EH>hT?GU~@eBEA\";i:572;s:25:\"zd=hT?GU~@eBc4nt,ub@xJ5FA\";i:573;s:15:\"EH>hT?GUO[XLXLA\";i:574;s:26:\"zd=hT?GUO[XLXL6SVElg*NbAIA\";i:575;s:14:\"EH>hT?GU}jfBEA\";i:576;s:25:\"zd=hT?GU}jfBc4nt,ub@xJ5FA\";i:577;s:14:\"EH>hT?GU}jgBEA\";i:578;s:25:\"zd=hT?GU}jgBc4nt,ub@xJ5FA\";i:579;s:14:\"EH>hT?GU}jhBEA\";i:580;s:25:\"zd=hT?GU}jhBc4nt,ub@xJ5FA\";i:581;s:14:\"EH>hT?GU}jiBEA\";i:582;s:25:\"zd=hT?GU}jiBc4nt,ub@xJ5FA\";i:583;s:15:\"EH>hT?GUO[@QXLA\";i:584;s:26:\"zd=hT?GUO[@QXL6SVElg*NbAIA\";i:585;s:14:\"EH>hT?GU}jkBEA\";i:586;s:25:\"zd=hT?GU}jkBc4nt,ub@xJ5FA\";i:587;s:15:\"EH>hT?GUO[AA5FA\";i:588;s:26:\"zd=hT?GUO[AA5Fe2LvSQ[zNAEA\";i:589;s:15:\"EH>hT?GUO[:CXLA\";i:590;s:26:\"zd=hT?GUO[:CXL6SVElg*NbAIA\";i:591;s:15:\"EH>hT?GUO[5FXLA\";i:592;s:26:\"zd=hT?GUO[5FXL6SVElg*NbAIA\";i:593;s:24:\"FH>hT?GUjClB1N.4FxrjDABA\";i:594;s:35:\"GH>hT?GUjClB#L.4FxrjDAI7>hT?GUHWlBA\";i:595;s:14:\"t8>hT?GU~@eBEA\";i:596;s:14:\"t8>hT?GU~@XBEA\";i:597;s:15:\"t8>hT?GUO[XLXLA\";i:598;s:14:\"t8>hT?GU}jfBEA\";i:599;s:14:\"t8>hT?GU}jgBEA\";i:600;s:14:\"t8>hT?GU}jhBEA\";i:601;s:14:\"t8>hT?GU}jiBEA\";i:602;s:15:\"t8>hT?GUO[@QXLA\";i:603;s:14:\"t8>hT?GU}jkBEA\";i:604;s:15:\"t8>hT?GUO[AA5FA\";i:605;s:15:\"t8>hT?GUO[:CXLA\";i:606;s:15:\"t8>hT?GUO[5FXLA\";i:607;s:13:\"t8>hT?GUjClBA\";i:608;s:13:\"c#>hT?GUUPlBA\";i:609;s:24:\"`X=hT?GU>BlBbL.4FxrjBABA\";i:610;s:14:\"i==hT?GU~@IBEA\";i:611;s:13:\"i==hT?GU[IlBA\";i:612;s:14:\"i==hT?GU~@&ACA\";i:613;s:12:\"R@=hT?GU/A$A\";i:614;s:12:\"R@=hT?GU5A$A\";i:615;s:72:\"~X=hT?GU>BlBYM.4Fx}MH)6FLvLvSQ[z!K0W@QqI:$vb\"Ie\"rP_Q3nE3t`wA6F=hT?GUpA$A\";i:616;s:15:\"hg=hT?GUO[aSXLA\";i:617;s:15:\"Qj=hT?GUO[aSXLA\";i:618;s:57:\"^2=hT?GU!BlBMM.4Fxs@MAI7=hT?GUGJlBUM.4FxrjCA;C=hT?GU=ElBA\";i:619;s:15:\"(a=hT?GUO[oIXLA\";i:620;s:67:\"JH=hT?GUpA$AGDSOYMifCt@Q_Q3nE3<AgAxBJHNz#8uW(HqI:$vbmARtyBJHNzX0vWA\";i:621;s:59:\"m==hT?GUO[#TXL!GVElg*NTAK\"jt,ub@&G5F$wLvSQ[zvAz(jt,ub@&G5FA\";i:622;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:623;s:57:\"ZE=hT?GU~AlBIM.4FxrjCAZ4=hT?GUYDlBQM.4FxrjCA]9=hT?GUYDlBA\";i:624;s:56:\"V@=hT?GU5A$ACDSOYM@1BtMc_Q3nE3<Ai\"vBJHNz:rvWrPqI:$vbDBgA\";i:625;s:56:\"V@=hT?GU/A$ACDSOYM@1BtMc_Q3nE3GC$AEDSOYM6|Dt{e_Q3nE3<AgA\";i:626;s:56:\"V@=hT?GUZA$ACDSOYM@1BtMc_Q3nE35B$AEDSOYM@1Bt{e_Q3nE35B$A\";i:627;s:46:\"]2=hT?GU!BlBMM.4Fx~5EAI7=hT?GU!BlBUM.4Fx~5EABA\";i:628;s:12:\"R@=hT?GU/A$A\";i:629;s:12:\"R@=hT?GU5A$A\";i:630;s:91:\"LH=hT?GUpA$A\"CSOYMu7Btp1_Q3nE3souANc=hT?GUjClBYM.4Fx~5TA+h=hT?GU:NlBcM.4Fx~5TA|e=hT?GU:NlBA\";i:631;s:13:\"t8=hT?GUNElBA\";i:632;s:114:\"eE=hT?GU~AlBIM.4FxrjCAZ4=hT?GUYDlBQM.4FxrjCA]9=hT?GUYDlBYM.4FxrjCA+h=hT?GU!BlBcM.4FxrjCA|e=hT?GU!BlB_M.4FxrjYBeAIA\";i:633;s:113:\"r==hT?GU~@*Aln$(k)No&Q:CzXzXJI|+EADt$(k)NohD:CrXzXJI|+EA]Q$(k)NohD:CYYzXJI|+EAOc$(k)NohD:CoYzXJI|+EAZL#(k)No]AlBA\";i:634;s:13:\"t8=hT?GUNElBA\";i:635;s:58:\"^2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCA1k?hT?GU}j*ACA\";i:636;s:23:\"FH=hT?GUpA$ABDSOYMAlBtA\";i:637;s:72:\"aE=hT?GU=ElBIM.4FxrjCAZ4=hT?GUYDlBQM.4?zrjCAq1GClBKGkcwY\"cE\"uW_Q3nE3_AgA\";i:638;s:24:\"WE=hT?GU~AlBsM.4FxrjAABA\";i:639;s:13:\"?2=hT?GUhIlBA\";i:640;s:26:\"`X=hT?GUO[uWXL5FVElg*NVAIA\";i:641;s:24:\"ig>hT?GU]VlB1N.4FxrjfABA\";i:642;s:58:\"P&=hT?GUNElB,L.4Fxs@FAw(=hT?GUNElB(L.4Fxs@FA[Q>hT?GU~@BBEA\";i:643;s:24:\"d#=hT?GUNElBbL.4Fxs@GABA\";i:644;s:12:\"VE=hT?GUZA$A\";i:645;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:646;s:48:\"YE=hT?GU~AlB_M.4FxrjAAvW=hT?GU>BlB^L.4FxrjYBiAIA\";i:647;s:14:\"(a=hT?GU~@MBEA\";i:648;s:104:\"q==hT?GU~@IByWit,ub@=16DS\";\",ub@=1}DS\".\",ub@JB5FhtLvSQ[zCA:>jt,ub@Yk5FLvLvSQ[zvAG\"$(k)NoMS:CrXzXJI|+XACA\";i:649;s:15:\"t8=hT?GUO[dZXLA\";i:650;s:13:\"t8=hT?GUhIlBA\";i:651;s:13:\"t8=hT?GUGJlBA\";i:652;s:15:\"hg?hT?GUO[&aXLA\";i:653;s:13:\"VE=hT?GU~AlBA\";i:654;s:13:\"?2=hT?GUhIlBA\";i:655;s:37:\"XE=hT?GU~AlBsM.4Fx}MBA};=hT?GUO[McXLA\";i:656;s:42:\"uP=hT?GUDClBFN.4FxrjYBqA2W&\",uj@^D5F>+NAEA\";i:657;s:17:\"VE=hT?IU~AlBUoDAB\";i:658;s:150:\"hE=hT?GU~AlBrL.4Fxs@DA<v=hT?GUaNlBvL.4Fxs@SAkn=hT?GU.DlB8M.4FxrjFAvW=hT?GU.DlBfL.4Fx~5AAI7>hT?GUjClBoM.4Fx}MsF6F:yLvSQ[zB[zWLvqI:$vbaU(H:CbXzXJI|+EACA\";i:659;s:13:\"(a=hT?GUeBlBA\";i:660;s:72:\"xP=hT?GUDClBbL.4Fxs@GAkn=hT?GU3GlB3L.4FxrjYBuAIAlt,ub@lt5F&6LvSQ[zGFKC$A\";i:661;s:79:\"4d=hT?GU)PlB<M.4FxrjQA;C=hT?GU~AlBzL.4FxrjCAHO=hT?GU(ClB?L.4Fx~5RAvW=hT?GU>BlBA\";i:662;s:13:\"yd=hT?GUkvlBA\";i:663;s:15:\"L&>hT?GUO[PjXLA\";i:664;s:24:\"Am=hT?GUBIlBIM.4Fx~5ZABA\";i:665;s:15:\"\"l=hT?GUO[0kXLA\";i:666;s:15:\"bS=hT?GUO[0kXLA\";i:667;s:13:\"mB?hT?GUatlBA\";i:668;s:15:\":`=hT?GUO[~lXLA\";i:669;s:15:\":`=hT?GUO[jnXLA\";i:670;s:140:\"t==hT?GU[IlBIM.4FxrjGAZ4=hT?GU!BlBQM.4FxrjGA]9=hT?GU!BlB1N.4FxrjYB6AJt)\",ub@y2/>Ctgg_Q3nE37D$A{CSOYM5qCt*h_Q3nE37D$A`CSOYM5qCtmu_Q3nE3~RvABA\";i:671;s:13:\"!5=hT?GUhIlBA\";i:672;s:56:\"8r?hT?GUZA$A#DSOYM?IBt^X`Q3nE3MAgA>BJHNznEuWi6qI:$vbGAQA\";i:673;s:24:\"WE=hT?GU=ElBrL.4Fxs@CABA\";i:674;s:97:\")M>hT?GUO[3rXLi\"LvSQ[zFAc4ht,ub@{K5F%tLvSQ[zGF:C$A@CSOYM@1Bt=J_Q3nE3<AgApBJHNz)duW=JqI:$vbaU3L:CA\";i:675;s:13:\"VE>hT?GUBIlBA\";i:676;s:71:\"JH=hT?GU<HlBYM.4Fx}MNA+h=hT?GU}j*ADt$(k)NosS:CrXzXJI{ZRPZLhNVElg*NM3MtA\";i:677;s:25:\"ig>hT?GU]VlB1N.4Fx}MV66FA\";i:678;s:14:\"yd=hT?GU~@]ACA\";i:679;s:12:\"VE=hT?GUZA$A\";i:680;s:13:\"VE=hT?GU~AlBA\";i:681;s:17:\"VE=hT?IU~AlBUoDAB\";i:682;s:13:\"VE=hT?GUCFlBA\";i:683;s:13:\"VE=hT?GU\"tlBA\";i:684;s:24:\"tP=hT?GUDClBnL.4Fxs@BABA\";i:685;s:24:\"tP=hT?GU(ClBnL.4Fxs@BABA\";i:686;s:13:\"EH=hT?GUqtlBA\";i:687;s:13:\"EH=hT?GU6tlBA\";i:688;s:13:\"EH=hT?GU:tlBA\";i:689;s:12:\"R@=hT?GU/A$A\";i:690;s:12:\"R@=hT?GU5A$A\";i:691;s:13:\"!5=hT?GUhIlBA\";i:692;s:13:\"c#=hT?GUhIlBA\";i:693;s:59:\"ru=hT?GUO[;vXL!GVElg*NTAK\"jt,ub@FN5F$wLvSQ[zJAz(jt,ub@FN5FA\";i:694;s:57:\"ru=hT?GULKlBIM.4FxrjCAZ4=hT?GUYDlBQM.4FxrjCA]9=hT?GUYDlBA\";i:695;s:58:\"ru=hT?GU~@CB/hjt,ub@&G5FwwLvSQ[zSAc4jt,ub@&G5F@wLvSQ[zSAEA\";i:696;s:59:\"ru=hT?GUO[VxXL!GVElg*NTAK\"jt,ub@FN5F$wLvSQ[zJAz(jt,ub@FN5FA\";i:697;s:57:\"ru=hT?GUBIlBIM.4FxrjCAZ4=hT?GUYDlBQM.4FxrjCA]9=hT?GUYDlBA\";i:698;s:59:\"ru=hT?GUO[6yXL!GVElg*NTAK\"jt,ub@FN5F$wLvSQ[zJAz(jt,ub@FN5FA\";i:699;s:57:\"ru=hT?GUsHlBIM.4FxrjCAZ4=hT?GUYDlBQM.4FxrjCA]9=hT?GUYDlBA\";i:700;s:57:\"ru=hT?GUXWlBIM.4FxrjCAZ4=hT?GUYDlBQM.4FxrjCA]9=hT?GUYDlBA\";i:701;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:702;s:13:\"c#=hT?GU!BlBA\";i:703;s:13:\"!5=hT?GU!BlBA\";i:704;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:705;s:13:\"t8=hT?GUGJlBA\";i:706;s:13:\"t8=hT?GUhIlBA\";i:707;s:13:\"t8=hT?GUaNlBA\";i:708;s:13:\"t8=hT?GUNElBA\";i:709;s:46:\"O&=hT?GU!BlB,L.4FxrjCAw(=hT?GU!BlB(L.4FxrjCABA\";i:710;s:13:\"hg=hT?GU!BlBA\";i:711;s:13:\"Qj=hT?GU!BlBA\";i:712;s:46:\"O&=hT?GUhIlB,L.4Fxs@LAw(=hT?GUhIlB(L.4Fxs@LABA\";i:713;s:46:\"O&=hT?GUNElB,L.4Fxs@FAw(=hT?GUNElB(L.4Fxs@FABA\";i:714;s:46:\"O&=hT?GU.DlB,L.4FxrjFAw(=hT?GU.DlB(L.4FxrjFABA\";i:715;s:14:\"(a=hT?GU~@MBEA\";i:716;s:26:\")a=hT?GU!BlB9N.4FxrjYB:AIA\";i:717;s:13:\"(a=hT?GUeBlBA\";i:718;s:14:\"VE>hT?GU}jDBEA\";i:719;s:13:\"VE>hT?GUhIlBA\";i:720;s:13:\"VE>hT?GUBIlBA\";i:721;s:14:\"yd=hT?GU~@]ACA\";i:722;s:14:\"bS>hT?GU~@BBEA\";i:723;s:81:\"aE?hT?GU~@.AZL((k)Noa.[QvWH7qI:$vbaU%N:C~dzXJI|+wC%BgA@BJHNzRm9(JA%$?hT?GUO[>2XLA\";i:724;s:15:\"VE?hT?GUO[Y4XLA\";i:725;s:15:\"VE?hT?GUO[95XLA\";i:726;s:15:\"VE?hT?GUO[H7XLA\";i:727;s:92:\"bE?hT?GU~@SCG\")(k)NoBD;CcczXJI|+wC_MgA?BJHNzRm9(JAI7?hT?GUO[>2XLWeVElg*NNK>GlBHP.4FxrjYB>AIA\";i:728;s:15:\"EH?hT?GUO[s8bLA\";i:729;s:15:\"EH?hT?GUO[[9bLA\";i:730;s:13:\"`)?hT?GUB4lBA\";i:731;s:143:\"9d=hT?GUO[b#XLIIVElg*NNKIIlB,L.4Fx}M2H6FVxLvSQ[zGFEE$A`CSOYM*+kYlB1N.4FxrjDA]9>hT?GUZA$ADDSOYMLUEtxd_Q3nE3wE$A;CSOYMifBtjn_Q3nE3kAi\"1BJHNzd&uWA\";i:732;s:13:\"nu=hT?GU>BlBA\";i:733;s:13:\"nu=hT?GU>BlBA\";i:734;s:26:\"tP=hT?GUDClBYM.4FxrjYBDBQA\";i:735;s:68:\"aE=hT?GU~AlBrL.4Fxs@DA1k=hT?GU!BlBzL.4FxrjCAvW=hT?GU>BlB?L.4Fx~5CABA\";i:736;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:737;s:59:\"}X=hT?GUZwlB|L.4Fx~5&A%$>hT?GUO[v(XLFBVElg*NNA2W)\",ub@&G5FA\";i:738;s:24:\"?J=hT?GUoDlB7L.4Fxs@BABA\";i:739;s:13:\"VE>hT?GUBIlBA\";i:740;s:24:\"WE=hT?GU~AlB3L.4Fx~5&ABA\";i:741;s:13:\"(a=hT?GUeBlBA\";i:742;s:94:\"/,?hT?KUO[_)XL#zGFkElBi<dtZAe4)(k)Noa.7yvWA$qI:$vbaAS\"/\",ub@y2xWEtjn`Q3nE30oZl5F!2LvSQ[zGF)E$A\";i:743;s:36:\"*,?hT?IUO[h=XL#zGF_ElB3HkcwY)!5AcACA\";i:744;s:25:\"zd=hT?GUjClB^L.4Fx}M,)6FA\";i:745;s:74:\"3d=hT?GUjClBYM.4Fx}M*q6FLvLvSQ[zB[zW@QqI:$vbA2Z\"rP_Q3nE3~RvA[Q>hT?GU}jPBEA\";i:746;s:24:\"zd=hT?GUjClB$M.4Fx~5RABA\";i:747;s:24:\"zd=hT?GUjClB$M.4FxrjLABA\";i:748;s:85:\"4d=hT?GUjClBYM.4Fx}M*q6FLvLvSQ[zB[zW@QqI:$vbA2Z\"rP_Q3nE3~RvA[Q>hT?GU}jPBbLlt,ub@Eg5FA\";i:749;s:27:\")a=hT?GU~@MB:>it,ub@y29yEtA\";i:750;s:110:\"0P=hT?GUDClBEM.4Fx~5BAeZ>hT?GUO[xdXLi\"Lvpb[zFA/h#J5FuezXJI{ZDAP/)(k)NocC:C+ezXJI{ZDAm_)(k)NocC:CNZzXJI|+wCyCgA\";i:751;s:121:\"eE=hT?IU~AlBUoDA!5_Q3nE30otp5FmuLvSQ[zKAz(it,ub@FN5F7vLvSQ[zGFtB$A:DSOYMAlBt.o`Q3nE30AgA_BJHNztSuW:&qI:$vbaARt$BJHNz5uwWA\";i:752;s:14:\"(a=hT?GU~@MBEA\";i:753;s:15:\"sP=hT?GUO[k_XLA\";i:754;s:13:\"sP=hT?GUDClBA\";i:755;s:15:\"L&>hT?GUO[/`XLA\";i:756;s:15:\":`=hT?GUO[T|XLA\";i:757;s:15:\":`=hT?GUO[4}XLA\";i:758;s:28:\"d#=hT?GUO[C\"5FayLvSQ[zGF%F$A\";i:759;s:29:\"@2=hT?GUO[:CYLyKVElg*NNKnLlBA\";i:760;s:13:\"F0=hT?GUoDlBA\";i:761;s:15:\":`=hT?GUO[UEYLA\";i:762;s:55:\"2:?hT?GUO[5FYL*hVElg*NNK|LlBvP.4FxrjYBtBS\"\"\",ub@y2xWFtA\";i:763;s:55:\"2:?hT?GUO[DHYL*hVElg*NNKMMlBvP.4FxrjYBvBS\"\"\",ub@y2PcFtA\";i:764;s:55:\"2:?hT?GUO[oIYL*hVElg*NNKcMlBvP.4FxrjYBxBS\"\"\",ub@y2.hFtA\";i:765;s:24:\"zd=hT?GUHWlBEM.4Fxs@EABA\";i:766;s:13:\"_X=hT?GU>BlBA\";i:767;s:14:\"(a=hT?GU}jBBEA\";i:768;s:13:\"(a=hT?GUeBlBA\";i:769;s:14:\"L&>hT?GU~@ZBEA\";i:770;s:15:\"L&>hT?GUO[=JYLA\";i:771;s:13:\"t8>hT?GUkvlBA\";i:772;s:13:\"t8>hT?GU<HlBA\";i:773;s:137:\"2P=hT?GUuBlB;L.4FxrjCA$T=hT?GU!BlB?L.4Fx~5CAvW=hT?GU>BlBnL.4FxrjYB1BRtmBJHNztSuWeGqI:$vbmAS\")\",uj@c}5F>+wCTD$A0BJHNzRmQ\"I\"h=_Q3nE30oE05FA\";i:774;s:24:\")a=hT?GUeBlBjL.4Fxs@EABA\";i:775;s:147:\"4P=hT?GUDClB;L.4FxrjLA;C=hT?GU~AlB3L.4FxrjYB7BQA+\",ub@nH5FgwLvSQ[zJAFtjt,ub@FN5F$wLvSQ[zJAz(jt,ub@FN5FFxLvSQ[zJAFtit,ub@PP5FVxLvSQ[zJA/hit,ub@PP5FA\";i:776;s:29:\";`=hT?GUO[@QYLfTVElg*NNKBNlBA\";i:777;s:15:\":`=hT?GUO[aSYLA\";i:778;s:186:\"6P=hT?GUuBlB;L.4FxrjCA<v=hT?GU!BlB3L.4FxrjYB%BS\"*\",ub@y2/>FtBt_Q3nE30o>25FhtLvSQ[zCA/hqt,ub@=1TEQA<\",ub@y2n_Fts8_Q3nE3~R6Af+>hT?GUiVlB/N.4Fx~5eA};=hT?GUO[uWYLPDVElg*NNKWOlB9N.4FxrjYB/BQA\";i:779;s:13:\"(a=hT?GUeBlBA\";i:780;s:127:\"^o=hT?GUYDlB;L.4Fx~5)A};=hT?GUO[&aYLLPVElg*N(CRt#BJHNzS^xWhNqI:$vbmAQA,\",ub@&G5F$wLvSQ[zGFjH$AFDSOYM@1BtdZ_Q3nE30Ai\"nBJHNzzguWA\";i:781;s:35:\"XE=hT?GU=ElB|L.4Fxs@WAHO=hT?GUDClBA\";i:782;s:105:\"*M>hT?GUORlBbL.4FxrjBAHO=hT?GU(ClB;L.4FxrjLA+h?hT?GUO[xdYLqCVElg*NVAIAit,ub@y2.hGt&a_Q3nE3BJ$AFDSOYMM%FtA\";i:783;s:57:\"fS>hT?GU!BlBYM.4FxrjCA+h=hT?GU!BlBcM.4FxrjCA|e=hT?GU!BlBA\";i:784;s:26:\"ou=hT?GUZA$A?CSOYMj<cAPABA\";i:785;s:12:\"VE=hT?GUZA$A\";i:786;s:12:\"VE=hT?GUZA$A\";i:787;s:69:\"Q&=hT?GU!BlB,L.4FxrjCAw(=hT?GU!BlB(L.4FxrjCA+h?hT?GU}j\"AyWjt,ub@*N5FA\";i:788;s:84:\"bE=hT?GU=ElBcM.4FxrjYB^BQA`\",ub@y2EtGtDH_Q3nE3BB$A@CSOYMAlHtuW_Q3nE3MAi\"}BJHNzij6U$A\";i:789;s:12:\"VE=hT?GUZA$A\";i:790;s:46:\"O&=hT?GUtElB,L.4FxrjCAw(=hT?GUtElB(L.4FxrjCABA\";i:791;s:12:\"VE=hT?GUZA$A\";i:792;s:12:\"EH=hT?GUpA$A\";i:793;s:130:\"DY>hT?GUO[PjYLi\"LvSQ[zbA:>jt,ub@y2mnGt@Q_Q3nE37D$AHDSOYMj<dtrA^9#(k)No4O:CjXzXJI|+oAOc&(k)No+E:CYYzXJI{ZjA^9$(k)No4O:ClZzXJI{ZjACA\";i:794;s:36:\"v8>hT?GUjClB5N.4FxrjAANc=hT?GU}jaBEA\";i:795;s:176:\"jE=hT?IU~AlBUoDA\"l_Q3nE3^D$AkDSOYM*+Dtgg_Q3nE3<AgArBJHNz`auW@QqI:$vbmARtqBJHNz`auW=JqI:$vbQCgA1BJHNzoxvW5FqI:$vbQCi\":BJHNzij>Q$A<CSOYMtOBtmu_Q3nE3^D$AmDSOYM*+JplB!O.4FxrjYBwAIA\";i:796;s:12:\"c#>hT?GUZA$A\";i:797;s:26:\"u8>hT?GU~@eBz(lt,ub@=1HEQA\";i:798;s:14:\"yd=hT?GU~@]ACA\";i:799;s:26:\"u8>hT?GU~@OByWit,ub@=16DQA\";i:800;s:52:\"1d=hT?GUO[b#XL6SVElg*N_FQA`\",ub@y2b4Gtmu_Q3nE3~R8ABA\";i:801;s:14:\"yd=hT?GU}jMBEA\";i:802;s:13:\"bS>hT?GU!BlBA\";i:803;s:24:\"zd=hT?GUHWlB1N.4Fxrj(ABA\";i:804;s:14:\"yd=hT?GU}jOBEA\";i:805;s:41:\"0d=hT?GU}jOBz(lt,ub@y2_9GtJV_Q3nE30o$$5FA\";i:806;s:15:\"bS>hT?GUO[.oYLA\";i:807;s:27:\";`=hT?GUO[SqYLPDVElg*N[}NtA\";i:808;s:15:\"t8>hT?GUO[3rYLA\";i:809;s:15:\"t8>hT?GUO[BtYLA\";i:810;s:15:\"t8>hT?GUO[muYLA\";i:811;s:15:\"t8>hT?GUO[muYLA\";i:812;s:15:\"t8>hT?GUO[;vYLA\";i:813;s:15:\"t8>hT?GUO[VxYLA\";i:814;s:15:\"t8>hT?GUO[6yYLA\";i:815;s:15:\"t8>hT?GUO[E0YLA\";i:816;s:15:\"t8>hT?GUO[p1YLA\";i:817;s:15:\"t8>hT?GUO[>2YLA\";i:818;s:13:\"t8>hT?GU)PlBA\";i:819;s:13:\"t8>hT?GU)PlBA\";i:820;s:15:\"t8>hT?GUO[Y4YLA\";i:821;s:15:\"t8>hT?GUO[95YLA\";i:822;s:15:\"t8>hT?GUO[H7YLA\";i:823;s:15:\"t8>hT?GUO[s8YLA\";i:824;s:15:\"t8>hT?GUO[[9YLA\";i:825;s:15:\"t8>hT?GUO[b#YLA\";i:826;s:15:\"t8>hT?GUO[$$YLA\";i:827;s:15:\"t8>hT?GUO[b#YLA\";i:828;s:15:\"t8>hT?GUO[K&YLA\";i:829;s:15:\"t8>hT?GUO[v(YLA\";i:830;s:15:\"t8>hT?GUO[_)YLA\";i:831;s:15:\"t8>hT?GUO[e+YLA\";i:832;s:15:\"t8>hT?GUO[(,YLA\";i:833;s:14:\"t8>hT?GU~@XBEA\";i:834;s:15:\"t8>hT?GUO[N/YLA\";i:835;s:13:\"t8>hT?GUHWlBA\";i:836;s:15:\"t8>hT?GUO[y:YLA\";i:837;s:15:\"t8>hT?GUO[|;YLA\";i:838;s:15:\"t8>hT?GUO[h=YLA\";i:839;s:15:\"t8>hT?GUO[+>YLA\";i:840;s:15:\"t8>hT?GUO[Q@YLA\";i:841;s:15:\"t8>hT?GUO[1[YLA\";i:842;s:15:\"yd=hT?GUO[b#XLA\";i:843;s:14:\"(a=hT?GU~@@ACA\";i:844;s:13:\"t8>hT?GUkvlBA\";i:845;s:15:\"yd=hT?GUO[3rYLA\";i:846;s:15:\"yd=hT?GUO[BtYLA\";i:847;s:15:\"yd=hT?GUO[muYLA\";i:848;s:15:\"yd=hT?GUO[muYLA\";i:849;s:15:\"yd=hT?GUO[;vYLA\";i:850;s:15:\"yd=hT?GUO[VxYLA\";i:851;s:15:\"yd=hT?GUO[6yYLA\";i:852;s:15:\"yd=hT?GUO[E0YLA\";i:853;s:15:\"yd=hT?GUO[p1YLA\";i:854;s:15:\"yd=hT?GUO[>2YLA\";i:855;s:13:\"yd=hT?GU)PlBA\";i:856;s:13:\"yd=hT?GU)PlBA\";i:857;s:15:\"yd=hT?GUO[Y4YLA\";i:858;s:15:\"yd=hT?GUO[95YLA\";i:859;s:15:\"yd=hT?GUO[H7YLA\";i:860;s:15:\"yd=hT?GUO[s8YLA\";i:861;s:15:\"yd=hT?GUO[[9YLA\";i:862;s:15:\"yd=hT?GUO[b#YLA\";i:863;s:15:\"yd=hT?GUO[$$YLA\";i:864;s:15:\"yd=hT?GUO[b#YLA\";i:865;s:15:\"yd=hT?GUO[K&YLA\";i:866;s:15:\"yd=hT?GUO[v(YLA\";i:867;s:15:\"yd=hT?GUO[_)YLA\";i:868;s:15:\"yd=hT?GUO[e+YLA\";i:869;s:15:\"yd=hT?GUO[(,YLA\";i:870;s:14:\"yd=hT?GU~@XBEA\";i:871;s:15:\"yd=hT?GUO[N/YLA\";i:872;s:13:\"yd=hT?GUHWlBA\";i:873;s:15:\"yd=hT?GUO[y:YLA\";i:874;s:15:\"yd=hT?GUO[|;YLA\";i:875;s:15:\"yd=hT?GUO[h=YLA\";i:876;s:15:\"yd=hT?GUO[+>YLA\";i:877;s:15:\"yd=hT?GUO[Q@YLA\";i:878;s:15:\"yd=hT?GUO[1[YLA\";i:879;s:15:\"EH>hT?GUO[3rYLA\";i:880;s:15:\"EH>hT?GUO[BtYLA\";i:881;s:15:\"EH>hT?GUO[muYLA\";i:882;s:15:\"EH>hT?GUO[muYLA\";i:883;s:15:\"EH>hT?GUO[;vYLA\";i:884;s:15:\"EH>hT?GUO[VxYLA\";i:885;s:15:\"EH>hT?GUO[6yYLA\";i:886;s:15:\"EH>hT?GUO[E0YLA\";i:887;s:15:\"EH>hT?GUO[p1YLA\";i:888;s:15:\"EH>hT?GUO[>2YLA\";i:889;s:13:\"EH>hT?GU)PlBA\";i:890;s:13:\"EH>hT?GU)PlBA\";i:891;s:15:\"EH>hT?GUO[Y4YLA\";i:892;s:15:\"EH>hT?GUO[95YLA\";i:893;s:15:\"EH>hT?GUO[H7YLA\";i:894;s:15:\"EH>hT?GUO[s8YLA\";i:895;s:15:\"EH>hT?GUO[[9YLA\";i:896;s:15:\"EH>hT?GUO[b#YLA\";i:897;s:15:\"EH>hT?GUO[$$YLA\";i:898;s:15:\"EH>hT?GUO[b#YLA\";i:899;s:15:\"EH>hT?GUO[K&YLA\";i:900;s:15:\"EH>hT?GUO[v(YLA\";i:901;s:15:\"EH>hT?GUO[_)YLA\";i:902;s:15:\"EH>hT?GUO[e+YLA\";i:903;s:15:\"EH>hT?GUO[(,YLA\";i:904;s:14:\"EH>hT?GU~@XBEA\";i:905;s:15:\"EH>hT?GUO[N/YLA\";i:906;s:13:\"EH>hT?GUHWlBA\";i:907;s:15:\"EH>hT?GUO[y:YLA\";i:908;s:15:\"EH>hT?GUO[|;YLA\";i:909;s:15:\"EH>hT?GUO[h=YLA\";i:910;s:15:\"EH>hT?GUO[+>YLA\";i:911;s:15:\"EH>hT?GUO[Q@YLA\";i:912;s:15:\"EH>hT?GUO[1[YLA\";i:913;s:24:\"!M=hT?GUTClBrL.4Fxs@CABA\";i:914;s:24:\"tP=hT?GUDClBnL.4Fx}MDABA\";i:915;s:79:\"yP=hT?GU(ClB;L.4FxrjCA$T=hT?GU!BlB?L.4Fx~5CAvW=hT?GU>BlBnL.4Fxs@%A;C>hT?GU<HlBA\";i:916;s:105:\"0P=hT?GU(ClB$M.4Fx}MLAvW=hT?GU>BlB?L.4Fx~5CA1k=hT?GU!BlBzL.4FxrjCANc=hT?GUHWlBKO.4FxrjYB@A2W)\",ub@y2_9ItA\";i:917;s:14:\"yd=hT?GU~@DBEA\";i:918;s:40:\"oB?hT?GUO[k_YL>WVElg*NNKDHlB#L.4FxrjfABA\";i:919;s:40:\"oB?hT?GUO[/`YL>WVElg*NNKDHlB#L.4FxrjfABA\";i:920;s:24:\"tP=hT?GUDClBGO.4Fxrj$ABA\";i:921;s:24:\"tP=hT?GUDClBnL.4Fx}MDABA\";i:922;s:128:\"fE=hT?GU~AlB7L.4FxrjCAvW=hT?GU>BlB?L.4Fx~5CAHO=hT?GU(ClB;L.4FxrjCA$T=hT?GU!BlBnL.4Fxrj&Aw(?hT?GUuBlBOO.4FxrjYB+CRt@BJHNzRm9(JABA\";i:923;s:13:\"(a=hT?GUeBlBA\";i:924;s:26:\"WE?hT?GUO[Y4XL2eVElg*NlAIA\";i:925;s:25:\"WE?hT?GU~@.Aln)(k)NowG:CA\";i:926;s:36:\"|)?hT?GUB4lBOO.4Fx~5$A;C?hT?GU~@SCEA\";i:927;s:15:\"VE?hT?GUO[Y4bLA\";i:928;s:13:\"sP=hT?GUDClBA\";i:929;s:24:\"tP=hT?GUDClBnL.4Fx}MDABA\";i:930;s:90:\"cE=hT?GU~AlBEM.4Fx~5BAHO=hT?GU(ClB;L.4FxrjCA$T=hT?GU!BlB?L.4Fx~5CAvW=hT?GU>BlBnL.4FxrjCABA\";i:931;s:90:\"zP=hT?GU(ClB;L.4FxrjCA$T=hT?GU!BlBgM.4Fx~5CAHO>hT?GU>BlB3L.4Fx~5EAkn=hT?GUYDlB|L.4FxrjAABA\";i:932;s:12:\"VE=hT?GUZA$A\";i:933;s:35:\"uP=hT?GUDClBbL.4FxrjBA7y=hT?GUOBlBA\";i:934;s:24:\"WE=hT?GU~AlB3L.4Fx~5&ABA\";i:935;s:62:\"ZE=hT?GUO[4}YLmOVElg*NNKuWlB3L.4Fx~5CAkn=hT?GU>BlBEM.4Fx~5BABA\";i:936;s:28:\")a>hT?GUO[AA6FRtLvSQ[zGFfL$A\";i:937;s:24:\"?J=hT?GUOBlB7L.4FxrjCABA\";i:938;s:24:\"?J=hT?GUoDlB7L.4Fxs@BABA\";i:939;s:176:\"78>hT?GUjClB3P.4FxrjYB>CRt6BJHNzj@xWvDqI:$vb!ARtrBJHNz`auW_EqI:$vbmAQA)\",ub@nH5FrvLvSQ[zKAyWit,ub@y2^QJt6y`Q3nE30o:C6FFxLvSQ[zvAFtit,ub@ph5FVxLvSQ[zvA/hit,ub@ph5F!2LvSQ[zGF#L$A\";i:940;s:15:\"yd=hT?GUO[oIZLA\";i:941;s:57:\"wP=hT?GU(ClB;L.4FxrjCA$T=hT?GU!BlB3L.4Fx~5CAkn=hT?GU>BlBA\";i:942;s:50:\"O&=hT?GU.DlB,L.4FxrjYB}CQA.\",ub@PP5F{uLvSQ[zGF?L$A\";i:943;s:111:\"NH=hT?GUpA$A;CSOYMifBtGO_Q3nE3RB$AGDSOYMifCt@Q_Q3nE3[B$AHDSOYMifCtrP_Q3nE3[B$AkDSOYMj<Its8_Q3nE3{K$AKDSOYMtOEtA\";i:944;s:88:\"?o=hT?GU>BlB3L.4Fx~5CAHO=hT?GU(ClB;L.4FxrjCA$T=hT?GU!BlB#L.4?zrjfAq10o5FYL!2LvSQ[zGFuG$A\";i:945;s:123:\"2P=hT?GU(ClB?L.4FxrjFAD\"_Q3nE3[B$A]CSOYMifCt:C_Q3nE3UAi\"rBJHNzRmvWhNqI:$vbGEi\"oBJHNzRmvWrPqI:$vbGEi\"#BJHNzRmuW\"SqI:$vb*|S\"A\";i:946;s:120:\"]o=hT?GU>BlB3L.4Fx~5CAHO=hT?GU(ClB;L.4FxrjCA$T=hT?GU!BlBGO.4FxrjYBBDRt*BJHNzij:M$AxDSOYMj<e\"JANc=hT?GUHWlB9N.4FxrjYB5BQA\";i:947;s:15:\"(a=hT?GUO[\"]YLA\";i:948;s:88:\"?o=hT?GU>BlB3L.4Fx~5CAHO=hT?GU(ClB;L.4FxrjCA$T=hT?GU!BlB#L.4?zrjfAq10oDHYL!2LvSQ[zGFuG$A\";i:949;s:122:\"2P=hT?GU(ClB?L.4FxrjFAD\"_Q3nE3[B$A]CSOYMifCt:C_Q3nE3UAi\"rBJHNzRmvWhNqI:$vbGEi\"oBJHNzRmvWrPqI:$vbGEi\"#BJHNzRmuW\"SqI:$vbHBgA\";i:950;s:88:\"?o=hT?GU>BlB3L.4Fx~5CAHO=hT?GU(ClB;L.4FxrjCA$T=hT?GU!BlB#L.4?zrjfAq10o(HYL!2LvSQ[zGFTH$A\";i:951;s:137:\"3P=hT?GU(ClB?L.4FxrjFAD\"_Q3nE3[B$A]CSOYMifCt:C_Q3nE3UAi\"rBJHNzRmvW_EqI:$vbACgAwBJHNzj@wW\"SqI:$vbu<Z\"UE_Q3nE3MAi\"pBJHNz`auW!mqI:$vbaU<c:CA\";i:952;s:35:\"@J=hT?GUoDlBIM.4Fx}MXAeZ=hT?GUeBlBA\";i:953;s:93:\"zP=hT?GU(ClB;L.4FxrjCA<v=hT?GU!BlB#L.4FxrjDAkn=hT?GU>BlB3L.4Fx~5CA};=hT?GU}j*Aln&(k)Noa.NcwWA\";i:954;s:13:\"yd=hT?GUjClBA\";i:955;s:13:\"yd=hT?GUHWlBA\";i:956;s:160:\"5P=hT?GU(ClBvL.4FxrjFA$T=hT?GU!BlB3L.4Fx~5CA6F=hT?GUpA$AGDSOYM@1Bt@Q_Q3nE3[B$AHDSOYM@1BtrP_Q3nE3[B$AkDSOYMj<It~l_Q3nE3oE$AaDSOYM*+ItBt_Q3nE30ooI6F!2LvSQ[zGFkM$A\";i:957;s:13:\"t8>hT?GUjClBA\";i:958;s:14:\"(a=hT?GU~@MBEA\";i:959;s:13:\"bS=hT?GU9UlBA\";i:960;s:88:\"4d=hT?IUHWlB&!5A,AQc#(k)NorF:C7XzXJI|+EA7F$(k)NohD:C(XzXJI{ZFADt#(k)No%D:CfbzXJI|+wCaGgA\";i:961;s:127:\"fE=hT?GU=ElB1N.4FxrjDA[Q>hT?GUO[uWZLIIVElg*NTAK\"it,ub@ph5FVxLvSQ[zJA/hit,ub@ph5FrvLvSQ[zUAEA%(k)NoVH:ClZzXJI{ZjAln&(k)Noa.<vyWA\";i:962;s:13:\"!5=hT?GUGJlBA\";i:963;s:34:\"0d=hT?GUjClB1N.4FxrjfA]9>hT?GUZA$A\";i:964;s:26:\"tP=hT?GUDClB;L.4FxrjYBTDQA\";i:965;s:15:\"/o?hT?GUO[*hXLA\";i:966;s:88:\"4d=hT?IUHWlB&!5A,AQc#(k)NorF:C7XzXJI|+EA7F$(k)NohD:C(XzXJI{ZFADt#(k)No%D:CfbzXJI|+wCXDgA\";i:967;s:190:\"oC^X(\",ub@MI5FRtLvSQ[zbAc4nt,ub@xJ5F#zLvSQ[zGF8M$AGDSOYM@1Bt@Q_Q3nE3OC$AHDSOYM@1BtrP_Q3nE3OC$A}CSOYMifCtBt_Q3nE3[B$A]DSOYMj<e\"gA};=hT?GUO[McXLLPVElg*N(CQA~AyD1+nGYL3LVElg*NyBRt$BJHNzRm8WjABA\";i:968;s:13:\"!5=hT?GUGJlBA\";i:969;s:45:\"1d=hT?GUjClB1N.4FxrjfA]9>hT?GUZA$A{CSOYM)ZCtA\";i:970;s:67:\"^J=hT?GUOBlBrL.4Fxs@DA1k=hT?GU!BlB?L.4FxrjFAD\"_Q3nE3[B$AADSOYMXwCtA\";i:971;s:13:\">J=hT?GUoDlBA\";i:972;s:121:\"7d=hT?IUHWlB&!5A,AQc#(k)NorF:C7XzXJI|+EA7F$(k)NohD:C(XzXJI{ZFADt#(k)No%D:CfbzXJI|+wCqGgAuBJHNztSuWZlqI:$vb2ARt6BJHNzj@xWA\";i:973;s:73:\"Q&=hT?GUNElB,L.4Fxs@FAw(=hT?GUNElB(L.4Fxs@FA%$>hT?GUO[McZLyKVElg*NNKSalBA\";i:974;s:12:\":`=hT?GUZA$A\";i:975;s:58:\"m==hT?GU}j&A]Q$(k)NohD:CYYzXJI|+EAOc$(k)No&Q:CoYzXJI|+EACA\";i:976;s:47:\"1d>hT?GU&VlBNN.4Fx}MQAI7>hT?GU~@eByWjt,ub@4E5FA\";i:977;s:110:\"6d=hT?IUHWlB&!5A,AQc#(k)NorF:C7XzXJI|+EA7F$(k)NohD:C(XzXJI{ZFADt#(k)No%D:CfbzXJI|+wCqGi\"#BJHNzRmuWWeqI:$vbrFgA\";i:978;s:73:\"Q&=hT?GUNElB,L.4Fxs@FAw(=hT?GUNElB(L.4Fxs@FA%$>hT?GUO[McZLyKVElg*NNKSalBA\";i:979;s:12:\":`=hT?GUZA$A\";i:980;s:14:\"i==hT?GU}j&ACA\";i:981;s:36:\"0d>hT?GU&VlBNN.4Fx}MQAI7>hT?GU~@eBEA\";i:982;s:97:\"5d=hT?IUHWlB&!7\"%AQc#(k)NorF:C7XzXJI|+EA7F$(k)NohD:C(XzXJI{ZFADt#(k)No%D:CPbzXJI|+GA^9%(k)No/r:CA\";i:983;s:46:\"O&=hT?GUNElB,L.4Fxs@FAw(=hT?GUNElB(L.4Fxs@FABA\";i:984;s:14:\"i==hT?GU}j&ACA\";i:985;s:35:\"v8>hT?GUjClBNN.4Fx}MQAf+>hT?GUiVlBA\";i:986;s:99:\"5d=hT?IUHWlB&!5A,AQc#(k)NorF:C7XzXJI|+EA7F$(k)NohD:C(XzXJI{ZFADt#(k)No%D:CfbzXJI|+wCqGi\"#BJHNzRmuWA\";i:987;s:73:\"Q&=hT?GUNElB,L.4Fxs@FAw(=hT?GUNElB(L.4Fxs@FA%$>hT?GUO[McZLyKVElg*NNKSalBA\";i:988;s:12:\":`=hT?GUZA$A\";i:989;s:25:\"j==hT?GU}j&A^9%(k)No/r:CA\";i:990;s:37:\"0d>hT?GU&VlBNN.4Fx}M$/6Fe2LvSQ[z#31WA\";i:991;s:86:\"4d=hT?IUHWlB&!7\"%AQc#(k)NorF:C7XzXJI|+EA7F$(k)NohD:C(XzXJI{ZFADt#(k)No%D:CPbzXJI|+GACA\";i:992;s:46:\"O&=hT?GUNElB,L.4Fxs@FAw(=hT?GUNElB(L.4Fxs@FABA\";i:993;s:25:\"j==hT?GU}j&A^9%(k)No/r:CA\";i:994;s:25:\"*,>hT?GUiVlBNN.4Fx}M$/6FA\";i:995;s:35:\"H0=hT?GUOBlBrL.4Fxs@CA};?hT?GUOBlBA\";i:996;s:15:\"L&>hT?GUO[E0XLA\";i:997;s:172:\"jE=hT?GU~AlB#L.4FxrjfAI7>hT?GUjClBYM.4Fxs@SA+h=hT?GUNElBcM.4Fxs@SA|e=hT?GUNElBrL.4Fxs@DA[Q=hT?GUO[{eZLqCVElg*NTAIAit,ub@nH5F!2LvSQ[zGFZN$AKDSOYMtOEt~l`Q3nE30AgA.BJHNzijJP$A\";i:998;s:134:\"gE=hT?GU~AlB#L.4FxrjfAI7>hT?GUjClBYM.4Fxs@LA+h=hT?GUNElBcM.4Fxs@LA|e=hT?GUNElBrL.4Fxs@DA[Q=hT?GU!BlBzL.4FxrjCAvW=hT?GU>BlBoM.4Fx~5MABA\";i:999;s:15:\"yd=hT?GUO[rPZLA\";i:1000;s:88:\"4d=hT?IUHWlB&!5A,AQc#(k)NorF:C7XzXJI|+EA7F$(k)NohD:C(XzXJI{ZFADt#(k)No%D:CfbzXJI|+wCqGgA\";i:1001;s:95:\"08>hT?GUjClBNN.4Fx}MfA%$=hT?GUNElB,L.4Fxs@FAw(=hT?GUNElB(L.4Fxs@FA%$>hT?GUO[McZLyKVElg*NNKSalBA\";i:1002;s:12:\":`=hT?GUZA$A\";i:1003;s:13:\"i==hT?GU[IlBA\";i:1004;s:92:\"zP=hT?GU(ClBzL.4FxrjCA1k=hT?GU!BlBIM.4FxrjCAZ4=hT?GU!BlBQM.4FxrjCA]9=hT?GU!BlBnL.4FxrjYBfDQA\";i:1005;s:180:\"iE=hT?GU~AlBsM.4Fx}MBA};=hT?GUO[McXLLPVElg*N(CRtwBJHNzRm8WmA+h=hT?GUO[0kZLoIVElg*NNK]alB(L.4FxrjYBjDQA,\",ub@Yk5F$wLvSQ[zzA/htt,ub@y2aLJth=_Q3nE30o\"S6Fe2LvSQ[zNAyWit,uj@c}5F>+wCWG$A\";i:1006;s:24:\"zd=hT?GUHWlB5N.4FxrjAABA\";i:1007;s:92:\"zP=hT?GU(ClBzL.4Fxs@FA1k=hT?GUNElBIM.4FxrjCAZ4=hT?GU!BlBQM.4FxrjCA]9=hT?GU!BlBnL.4FxrjYBfDQA\";i:1008;s:211:\"oCAY&\",ub@^D5F`xLvSQ[zEA/hkt,ub@y2xWCts8_Q3nE3{K$AGDSOYMj<dt<Ax(#(k)No`,RCIAkt,ub@y29yKtrP_Q3nE3t`xAZ4=hT?GUGJlBQM.4Fxs@MApI@hT?GUO[:CZLfTVElg*NNKXblB1N.4FxrjDA[Q>hT?GUO[uWZL|LVElg*NNKnblB$M.4FxrjGAYL@hT?GUFMlBA\";i:1009;s:34:\"0d=hT?GUjClB1N.4FxrjfA]9>hT?GUZA$A\";i:1010;s:108:\"0P=hT?GU(ClBvL.4FxrjCAvW=hT?GU>BlB#L.4?zrjfAq10oKCYLFxLvSQ[zlAFtit,ub@ma5FVxLvSQ[zlA/hit,ub@ma5Fe2LvSQ[zNAEA\";i:1011;s:37:\"0d>hT?GU&VlBoM.4Fx}Mty6F2uLvSQ[z**zWA\";i:1012;s:13:\"t8>hT?GUjClBA\";i:1013;s:26:\"j==hT?GUO[&aYL6SVElg*N_FQA\";i:1014;s:12:\"c#>hT?GUZA$A\";i:1015;s:24:\"tP=hT?GUDClBEM.4Fx~5BABA\";i:1016;s:114:\"|J=hT?GUOBlB7L.4FxrjCAHO=hT?GU(ClB;L.4FxrjCA$T=hT?GU!BlB?L.4Fx~5CAYL=hT?GUeBlB3L.4Fx~5CA7y=hT?GUOBlB9N.4FxrjYBpDQA\";i:1017;s:15:\"sP@hT?GUO[SqZLA\";i:1018;s:179:\"6P=hT?GU(ClBvL.4FxrjCA$T=hT?GU!BlB3L.4Fx~5CA%$=hT?GUO[3rZLUEVElg*NNKMclBcM.4Fx}M@Z6F{uLvSQ[zGFGO$AvDSOYM?IBty:_Q3nE3RB$A<CSOYMtOBts8_Q3nE3{K$AKDSOYM*+vXlB8M.4Fx}MQAYL=hT?GUO[muZLA\";i:1019;s:26:\"tP=hT?GUDClBnL.4FxrjYBzDQA\";i:1020;s:81:\"(M>hT?GUwLlBrL.4Fxs@DA1k=hT?GU!BlBzL.4FxrjCAvW=hT?GU>BlB?L.4Fx~5CABA`Q3nE30o4Y6FA\";i:1021;s:13:\"VE=hT?GU~AlBA\";i:1022;s:35:\"@J=hT?GUoDlB7L.4Fxs@BAYL=hT?GUTClBA\";i:1023;s:197:\"oCAY&\",ub@JB5F[tLvSQ[zPAc4it,ub@Eg5FWuLvSQ[ztA/hjt,ub@0@5F@wLvSQ[zXBJt*\",ub@~R5F6yLvSQ[zZAG\"#(k)No\"I:C!WzXJI{ZBA^9$(k)NoRT:CjXzXJI|+!A7F%(k)NoCQ:ChdzXJI|+wCFBi\"#BJHNzRmuWeGqI:$vb\"IZ\"h=_Q3nE30odZ6FA\";i:1024;s:24:\"WE=hT?GU=ElB(L.4Fx~5RABA\";i:1025;s:13:\"VE=hT?GU~AlBA\";i:1026;s:15:\"(a=hT?GUO[E0ZLA\";i:1027;s:15:\"(a=hT?GUO[p1ZLA\";i:1028;s:59:\"^2=hT?GU!BlBMM.4Fx~5EAI7=hT?GU!BlBUM.4Fx~5EACt=hT?GUO[>2ZLA\";i:1029;s:59:\"ZE=hT?GU~AlBBN.4Fx}MLA|e>hT?GU]VlB8M.4FxrjYB#DRtyBJHNz!PvWA\";i:1030;s:13:\"t8=hT?GUcHlBA\";i:1031;s:14:\"yd=hT?GU~@DBEA\";i:1032;s:15:\"yd=hT?GUO[95ZLA\";i:1033;s:15:\"yd=hT?GUO[oIZLA\";i:1034;s:13:\"bS>hT?GU!BlBA\";i:1035;s:52:\"w8>hT?GU~@zC/hqt,ub@y2^QSt>2_Q3nE36W$A_CSOYMj<dteCEA\";i:1036;s:13:\"sP=hT?GUDClBA\";i:1037;s:15:\"hg?hT?GUO[&aXLA\";i:1038;s:67:\"9r?hT?GUZA$A#DSOYM?IBtp1`Q3nE3MAi\"=BJHNznEuW95qI:$vbGARt>BJHNznEuWA\";i:1039;s:90:\"zP=hT?GU(ClBzL.4FxrjCA1k=hT?GU!BlB3L.4Fx~5EA%$=hT?GUaNlB,L.4Fxs@SAw(=hT?GUaNlB(L.4Fxs@SABA\";i:1040;s:108:\"MH>hT?GUjClBWO.4Fx}MRAq1=hT?GU}jdBFtjt,ub@=1aFRtvBJHNzijPV$AFDSOYM*+eqlB3L.4Fxs@LAkn=hT?GUhIlB9N.4FxrjYB5BQA\";i:1041;s:25:\"zd=hT?GUjClB)M.4Fx}Mqr6FA\";i:1042;s:124:\"CY=hT?GUO[H7ZL_EVElg*N1CQA:\",ub@!]5FbvLvSQ[zJAG\"%(k)No`,)B2W?\",ub@xJ5FhtLvSQ[zCA/hkt,ub@=1~CS\")\",uj@c}5F>+wC[F&\"$BJHNzijyU$A\";i:1043;s:15:\"yd=hT?GUO[#TZLA\";i:1044;s:13:\"KV=hT?GU#ulBA\";i:1045;s:13:\"Wx=hT?GU#ulBA\";i:1046;s:78:\"(M>hT?GUORlBGO.4FxrjAA$T=hT?GU!BlB;L.4FxrjCAkn=hT?GU>BlB3L.4Fx~5CAl_=hT?GUZA$A\";i:1047;s:24:\"!M>hT?GU|GlBzL.4FxrjCABA\";i:1048;s:26:\"!M>hT?GUO[s8ZL~FVElg*NlAIA\";i:1049;s:12:\"VE=hT?GUZA$A\";i:1050;s:90:\"Gm=hT?GU!BlBAM.4FxrjCA$T=hT?GUYDlBIM.4FxrjCAZ4=hT?GU!BlBQM.4FxrjCA]9=hT?GU!BlB3L.4Fx~5EABA\";i:1051;s:91:\"@o=hT?GU.DlB3L.4FxrjFAD\"_Q3nE3[B$AKDSOYM*+kYlBsM.4Fx}MBA$T=hT?GUYDlBAM.4Fx~5EAHO=hT?GUDClBA\";i:1052;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:1053;s:24:\"u8>hT?GUjClB5N.4Fx~5VABA\";i:1054;s:24:\"u8>hT?GUHWlB5N.4Fx~5VABA\";i:1055;s:13:\"VE=hT?GUatlBA\";i:1056;s:35:\"XE=hT?GU~AlB3L.4Fx~5CAkn=hT?GUYDlBA\";i:1057;s:57:\"}X=hT?GUYDlBIM.4FxrjCAZ4=hT?GUYDlBQM.4FxrjCA]9=hT?GUYDlBA\";i:1058;s:56:\"ZE=hT?GUZA$A:DSOYMAlBt.o`Q3nE30AgA_BJHNztSuW:&qI:$vbaAQA\";i:1059;s:13:\"VE=hT?GU~AlBA\";i:1060;s:67:\"Q&=hT?GUaNlB,L.4Fxs@SAw(=hT?GUaNlB(L.4Fxs@SA6F=hT?GUpA$A\"CSOYMu7BtA\";i:1061;s:12:\"VE=hT?GUZA$A\";i:1062;s:14:\"hg?hT?GU~@EBEA\";i:1063;s:13:\"_X=hT?GU?ulBA\";i:1064;s:13:\"L&=hT?GUGJlBA\";i:1065;s:29:\")a=hT?GUO[[9ZLZFVElg*NNK\"ClBA\";i:1066;s:13:\"(a=hT?GUeBlBA\";i:1067;s:13:\"KV=hT?GUhIlBA\";i:1068;s:13:\"Wx=hT?GUhIlBA\";i:1069;s:47:\"YE=hT?GU~AlBsM.4Fx}MBA|e?hT?GU~@EBz(jt,ub@Yk5FA\";i:1070;s:13:\"c#=hT?GU!BlBA\";i:1071;s:90:\"S&=hT?GU!BlB,L.4FxrjCAw(=hT?GU!BlB(L.4FxrjCAq1=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:1072;s:13:\"?2=hT?GU!BlBA\";i:1073;s:46:\"]2=hT?GU#ulBMM.4Fxrj&AI7=hT?GU#ulBUM.4Fxrj&ABA\";i:1074;s:68:\"aE=hT?GU~AlBIM.4FxrjCAZ4=hT?GU!BlBQM.4FxrjCA]9=hT?GU!BlB3L.4Fx~5CABA\";i:1075;s:13:\"_X=hT?GU>%lBA\";i:1076;s:13:\"_X=hT?GUM3lBA\";i:1077;s:13:\"_X=hT?GU|2lBA\";i:1078;s:15:\"_X=hT?GUO[b#dLA\";i:1079;s:13:\"_X=hT?GUC1lBA\";i:1080;s:14:\"KV@hT?GU~@TBEA\";i:1081;s:35:\"uP=hT?GUDClBUM.4Fxrj&AZ4=hT?GU#ulBA\";i:1082;s:13:\"t8=hT?GU#ulBA\";i:1083;s:57:\"ZE=hT?GUCFlBIM.4FxrjCAZ4=hT?GU!BlBQM.4FxrjCA]9=hT?GU!BlBA\";i:1084;s:12:\"EH=hT?GUpA$A\";i:1085;s:15:\"(a>hT?GUO[\"]XLA\";i:1086;s:13:\"_X=hT?GU>BlBA\";i:1087;s:70:\"3d=hT?GU~@]A,h%(k)No`,DC3(,\",ub@N15FLvLvSQ[z;AG\"$(k)No0a:CrXzXJI|+lACA\";i:1088;s:13:\"?2=hT?GUGJlBA\";i:1089;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:1090;s:13:\"t8>hT?GU<HlBA\";i:1091;s:15:\"mB?hT?GUO[$$ZLA\";i:1092;s:15:\"/o=hT?GUO[K&ZLA\";i:1093;s:12:\"EH=hT?GUpA$A\";i:1094;s:13:\"VE=hT?GUatlBA\";i:1095;s:168:\"pS>hT?GU!BlBbL.4Fxs@GAkn=hT?GUhIlB3L.4Fxs@LA]9=hT?GUzSlBMM.4FxrjaAq1=hT?GU.DlByO.4Fx}M?s6F+uLvSQ[zkA:>jt,ub@&G5FLvLvSQ[zJAG\"$(k)NohD:CrXzXJI|+EAln%(k)NohD:ClZzXJI|+WACA\";i:1096;s:45:\"qu?hT?GUZA$A$DSOYM?IBtdZ`Q3nE3MAi\">BJHNznEuWA\";i:1097;s:13:\"VE=hT?GUatlBA\";i:1098;s:254:\"oCp*+\",ub@0Q5FRtLvSQ[zFAz(it,ub@0Q5F6yLvSQ[zXAG\"#(k)NoaI:C@YzXJI|+wC(Hi\":BJHNzij>Q$A<CSOYMtOBtgg_Q3nE3<AgArBJHNz`auW@QqI:$vbmARtqBJHNz`auW&aqI:$vbmARt4BJHNz`auW#TqI:$vbSAS\"<\",ub@lt5F00LvSQ[z$AbLot,ub@t`5FT3LvSQ[zfB2W:\",ub@=1aFRt$BJHNzijyU$A9DSOYMj<cAGABA\";i:1099;s:13:\"!5=hT?GUzSlBA\";i:1100;s:13:\"c#=hT?GUzSlBA\";i:1101;s:12:\"R@=hT?GU5A$A\";i:1102;s:12:\"R@=hT?GU/A$A\";i:1103;s:12:\"EH=hT?GUpA$A\";i:1104;s:24:\"WE=hT?GU=ElBsM.4FxrjAABA\";i:1105;s:49:\"pB?hT?GUZA$AkDSOYM*+Dt~l_Q3nE3t`hAeZ=hT?GUO[\"]YLA\";i:1106;s:23:\"nB?hT?GUZA$A^CSOYM5qBtA\";i:1107;s:13:\"9M>hT?GU|GlBA\";i:1108;s:15:\"9M>hT?GUO[s8ZLA\";i:1109;s:26:\"nB?hT?GUatlBoM.4FxrjYB(DQA\";i:1110;s:15:\"KV=hT?GUO[_)ZLA\";i:1111;s:15:\"Wx=hT?GUO[_)ZLA\";i:1112;s:37:\"oB?hT?GUZA$AkDSOYMj<dtWA^9$(k)NoTN:CA\";i:1113;s:25:\"nB?hT?GUZA$AkDSOYM*+:WlBA\";i:1114;s:38:\"oB?hT?GUZA$AkDSOYMj<dtWA^9$(k)No`,sBIA\";i:1115;s:25:\"nB?hT?GUZA$AkDSOYM*+:WlBA\";i:1116;s:15:\"9M>hT?GUO[e+ZLA\";i:1117;s:15:\"9M>hT?GUO[(,ZLA\";i:1118;s:90:\"sB?hT?GUZA$AkDSOYMj<dtWA^9$(k)No6I:C=ZzXJI|+wC^HgAsBJHNzRm8WtAD\"_Q3nE30oZl6FmuLvSQ[zGF^P$A\";i:1119;s:37:\"oB?hT?GUZA$AkDSOYM*+:WlB)M.4Fx}Mf86FA\";i:1120;s:177:\"$d=hT?IUHWlB&!5A(A:>#(k)Nofp:CdZzXJI|+6ADt#(k)No\"I:C{WzXJI|+HAP/#(k)NoCQ:CQYzXJI{Z6AwW$(k)NohD:CgYzXJI|+EA,h$(k)NohD:C@YzXJI|+SAm_#(k)NoyAlByO.4Fx}M?s6F%tLvSQ[zGFOO$AQDSOYMAlFtA\";i:1121;s:15:\"yd=hT?GUO[#TZLA\";i:1122;s:13:\"KV=hT?GUaNlBA\";i:1123;s:13:\"Wx=hT?GUaNlBA\";i:1124;s:81:\"sB?hT?GUZA$AkDSOYMj<Bt~l_Q3nE30oZl6FrvLvSQ[zVAG\"#(k)No1H:CdZzXJI|+KA]Q$(k)Noyg:CA\";i:1125;s:34:\"oB?hT?GUZA$AkDSOYMj<Bt;v_Q3nE3RB$A\";i:1126;s:37:\"oB?hT?GUZA$AkDSOYMj<Bt~l_Q3nE30oZl6FA\";i:1127;s:14:\"i==hT?GU~@(ACA\";i:1128;s:13:\"9M>hT?GU|GlBA\";i:1129;s:15:\"9M>hT?GUO[s8ZLA\";i:1130;s:27:\"j==hT?GU}jVBc4nt,ub@y2.hMtA\";i:1131;s:14:\"t8>hT?GU~@$ACA\";i:1132;s:13:\"VE=hT?GU=ElBA\";i:1133;s:13:\"!5=hT?GUGJlBA\";i:1134;s:46:\"]2=hT?GU!BlBMM.4Fx~5RAI7=hT?GU!BlBUM.4Fx~5RABA\";i:1135;s:70:\"xP=hT?GU(ClBAM.4FxrjCA1k=hT?GUBIlBIM.4FxrjYBCES\"*\",ub@qO5F6yLvSQ[zUAEA\";i:1136;s:13:\"L&=hT?GUGJlBA\";i:1137;s:137:\"gE=hT?GUZA$A?CSOYMM%Bt5F_Q3nE3JB$ACDSOYM@1BtMc_Q3nE3<Ai\"vBJHNz`auWrPqI:$vbmARtwBJHNz:rvWlBqI:$vbKARt#BJHNzRmuW\"SqI:$vbtfT\"8M_Q3nE30o{e6FA\";i:1138;s:13:\"t8>hT?GUjClBA\";i:1139;s:62:\"3:=hT?GU~@BB:>jt,ub@y2DAzWoIqI:$vbmAQA.\",ub@y2DAzW(HqI:$vbmAQA\";i:1140;s:12:\"4r>hT?GUZA$A\";i:1141;s:26:\"S@=hT?GU/A$A]CSOYMj<cAuABA\";i:1142;s:13:\"!5=hT?GUGJlBA\";i:1143;s:36:\"T@=hT?GU5A$A]CSOYMj<cAuA6F=hT?GU5A$A\";i:1144;s:13:\"c#=hT?GUGJlBA\";i:1145;s:14:\"t8>hT?GU~@OBEA\";i:1146;s:59:\"m==hT?GU}j*A7F#(k)No#J:C7fzXJI{ZY:ZL_kVElg*NyBS\"\"AyD1+WJYLA\";i:1147;s:25:\"cS>hT?GU}j\"AG\"*(k)NohD:CA\";i:1148;s:24:\")a@hT?GUlMlB^P.4Fx~5RABA\";i:1149;s:24:\"ig@hT?GUlMlBAQ.4Fx~5RABA\";i:1150;s:56:\"8r>hT?GUZA$ACDSOYM@1BtMc_Q3nE3<Ai\"vBJHNz`auWrPqI:$vbmAQA\";i:1151;s:24:\"WE=hT?GU~AlBsM.4Fx}MBABA\";i:1152;s:147:\"xB?hT?GUZA$A;CSOYMifBtBt_Q3nE38Ai\"wBJHNzRm8WuA+h=hT?GUWJlBcM.4FxrjYBGERtqBJHNz@5vW~lqI:$vbGARt6BJHtz4BwWhNuxQ\")0qI:$vb*|Z\"y:_Q3nE3^D$AmDSOYM*+JplBA\";i:1153;s:36:\"v8>hT?GUHWlB#L.4Fx}M1a6Fu2LvSQ[zBAEA\";i:1154;s:15:\"hg?hT?GUO[&aXLA\";i:1155;s:12:\"c#>hT?GUZA$A\";i:1156;s:12:\"EH=hT?GUpA$A\";i:1157;s:12:\"EH=hT?GU5A$A\";i:1158;s:12:\"VE=hT?GUZA$A\";i:1159;s:24:\"tP=hT?GUDClBcM.4Fxs@FABA\";i:1160;s:57:\"wP=hT?GU(ClB3L.4Fx~5CA[Q=hT?GU!BlBfL.4Fx~5AAkn=hT?GUNElBA\";i:1161;s:51:\"<o=hT?GUNElB3L.4Fxs@FAeZ>hT?GUO[1[ZLPDVElg*NNK@glBA\";i:1162;s:12:\"VE=hT?GUZA$A\";i:1163;s:24:\"M&=hT?GUhIlBfL.4Fx~5AABA\";i:1164;s:46:\"O&=hT?GU!BlBcM.4FxrjCAkn=hT?GUtElB8M.4FxrjGABA\";i:1165;s:12:\"VE=hT?GUZA$A\";i:1166;s:48:\"YE=hT?GUZA$A}CSOYM5qCtXL_Q3nE3GC$A^CSOYMj<dtCBEA\";i:1167;s:73:\".a=hT?GU!BlBjL.4Fx~5BApI@hT?GUO[:CZLLPVElg*N(CQA~AyD1+nGYLtJVElg*NNKFhlBA\";i:1168;s:24:\")a=hT?GUeBlBjL.4Fxs@EABA\";i:1169;s:12:\"VE=hT?GUZA$A\";i:1170;s:13:\"VE=hT?GU=ElBA\";i:1171;s:35:\"{X=hT?GU>BlB?L.4Fx~5EA;C=hT?GU~AlBA\";i:1172;s:81:\"!r>hT?GUZA$ACDSOYM@1BtMc_Q3nE3<Ai\"vBJHNz:rvWrPqI:$vbmARtyBJHNzijzR$AkDSOYM*+:WlBA\";i:1173;s:61:\"ZE=hT?IUCFlBUoDA(a_Q3nE3<AgAvBJHNzd&uW+OqI:$vbYCgAwBJHNz`auWA\";i:1174;s:13:\"!5=hT?GU!BlBA\";i:1175;s:13:\"!5=hT?GU:NlBA\";i:1176;s:15:\"!5=hT?GUO[Q@ZLA\";i:1177;s:24:\"u8>hT?GU<HlB5N.4FxrjAABA\";i:1178;s:24:\"u8>hT?GUfOlB5N.4Fx~5VABA\";i:1179;s:13:\"VE=hT?GUCFlBA\";i:1180;s:141:\"3P=hT?GUDClBIM.4FxrjCAZ4=hT?GU!BlBQM.4FxrjGA]9=hT?GU!BlB#L.4Fx}M1a6F#zLvSQ[z0.zWQQqI:$vbDBgArBJHNzd&uW@QqI:$vbDBi\"qBJHNzRm8WvAHO>hT?GUO[T|ZLA\";i:1181;s:13:\"hg=hT?GUNElBA\";i:1182;s:35:\"uP=hT?GU(ClB;L.4Fxs@FA$T=hT?GUNElBA\";i:1183;s:50:\"YE=hT?GU~AlB?L.4FxrjYBSEQA)\",ub@y2n_Mtmu_Q3nE3AE$A\";i:1184;s:59:\"m==hT?GUO[&aYL!GVElg*NTAK\"jt,ub@&G5F$wLvSQ[zvAz(jt,ub@&G5FA\";i:1185;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:1186;s:13:\"?2=hT?GUaNlBA\";i:1187;s:68:\"aE=hT?GU~AlBsM.4Fx}MBAq1=hT?GU!BlBMM.4Fxs@MAI7=hT?GU!BlBUM.4FxrjCABA\";i:1188;s:82:\"R&=hT?GU!BlB,L.4Fx}MKAw(=hT?GUMHlB(L.4Fx}MKANc=hT?GU~@]A,h%(k)Noa.BAaLjHVElg*NrAIA\";i:1189;s:57:\"8r>hT?GUatlBIM.4Fxrj&AZ4=hT?GU#ulBQM.4Fxrj&A]9=hT?GU#ulBA\";i:1190;s:62:\"P&=hT?GUO[lBaLUEVElg*NTAIAkt,ub@y28FNtrP_Q3nE3<AgA;BJHNzijeQ$A\";i:1191;s:13:\"L&=hT?GU!BlBA\";i:1192;s:23:\"cS>hT?GUZA$AHDSOYM@1BtA\";i:1193;s:35:\"jg>hT?GU]VlB1N.4FxrjfAZ4=hT?GUhIlBA\";i:1194;s:29:\"d#>hT?GUO[:CaLPDVElg*NNKWelBA\";i:1195;s:151:\"!d=hT?GUO[UEaLtJVElg*NAbJts8_Q3nE39F$ACDSOYM@1BtMc_Q3nE3OK$AEDSOYMXwDt{e_Q3nE3OK$AGDSOYM6|Dt@Q_Q3nE3zD$AHDSOYM6|DtrP_Q3nE3zD$AkDSOYMj<It@Q`Q3nE30oBt6FA\";i:1196;s:25:\"u8>hT?GU<HlB7L.4Fx}M{n6FA\";i:1197;s:12:\"VE=hT?GUZA$A\";i:1198;s:56:\"^2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCATq>hT?GUZA$A\";i:1199;s:17:\"VE=hT?IUCFlBUoDAB\";i:1200;s:59:\"ZE=hT?GU~AlB5N.4FxrjAA|e?hT?GU~@EByWht,ub@/B5F!2LvSQ[zzb1WA\";i:1201;s:12:\"c#>hT?GUZA$A\";i:1202;s:14:\"c#=hT?GU~@YBEA\";i:1203;s:12:\"VE=hT?GUZA$A\";i:1204;s:46:\"]2=hT?GUtElBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:1205;s:131:\"1P=hT?GUuBlB;L.4FxrjLA$T=hT?GU!BlBnL.4?zrjYBcERtIT=>YAYL_Q3nE30oww6FZ1LvSQ[zBAz(kt,ub@y2.hNt~l_Q3nE30oQQ5F!2LvSQ[zGF1R$AFDSOYMWDDtA\";i:1206;s:24:\"LV=hT?GUYDlBAM.4FxrjCABA\";i:1207;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:1208;s:42:\"{X=hT?GUO[DHaL_EVElg*NNK6ilB8M.4FxrjYBeEQA\";i:1209;s:12:\"VE=hT?GUZA$A\";i:1210;s:46:\"]2=hT?GU!BlBMM.4Fx~5EAI7=hT?GUtElBUM.4Fx~5EABA\";i:1211;s:14:\"i==hT?GU~@{ACA\";i:1212;s:46:\"]2=hT?GU!BlBMM.4Fx~5RAI7=hT?GUlMlBUM.4FxrjCABA\";i:1213;s:63:\"x8>hT?GU~@PB:>jt,ub@y29yNt@Q_Q3nE34E$AHDSOYMj<dtJB/hit,ub@}k5FA\";i:1214;s:13:\"i==hT?GU3GlBA\";i:1215;s:81:\"R&=hT?GU!BlB,L.4FxrjCAw(=hT?GU!BlB(L.4FxrjCAkn=hT?GU}TlB8M.4FxrjcAvW=hT?GUO[DHaLA\";i:1216;s:24:\"`X=hT?GU}TlBoM.4Fx}MGABA\";i:1217;s:37:\"v8>hT?GU~@PBz(lt,ub@=1}DS\")\",ub@xJ5FA\";i:1218;s:14:\"yd=hT?GU~@]ACA\";i:1219;s:15:\"t8>hT?GUO[3rYLA\";i:1220;s:15:\"t8>hT?GUO[BtYLA\";i:1221;s:15:\"t8>hT?GUO[VxYLA\";i:1222;s:15:\"t8>hT?GUO[muYLA\";i:1223;s:15:\"t8>hT?GUO[E0YLA\";i:1224;s:13:\"t8>hT?GU)PlBA\";i:1225;s:14:\"z:=hT?GU}j\"AEA\";i:1226;s:24:\"0:=hT?GU!BlBiO.4FxrjCABA\";i:1227;s:13:\"VE>hT?GUlMlBA\";i:1228;s:25:\"zd=hT?GU}jOBc4nt,ub@xJ7FA\";i:1229;s:15:\"yd=hT?GUO[3rYLA\";i:1230;s:15:\"yd=hT?GUO[GOaLA\";i:1231;s:14:\"yd=hT?GU~@PBEA\";i:1232;s:14:\"yd=hT?GU~@OBEA\";i:1233;s:15:\"yd=hT?GUO[BtYLA\";i:1234;s:15:\"yd=hT?GUO[rPaLA\";i:1235;s:15:\"yd=hT?GUO[VxYLA\";i:1236;s:15:\"yd=hT?GUO[@QaLA\";i:1237;s:15:\"yd=hT?GUO[muYLA\";i:1238;s:15:\"yd=hT?GUO[aSaLA\";i:1239;s:15:\"yd=hT?GUO[E0YLA\";i:1240;s:15:\"yd=hT?GUO[#TaLA\";i:1241;s:37:\"v8>hT?GUkvlB_M.4FxrjAA+h?hT?GUO[0kYLA\";i:1242;s:14:\"KV@hT?GU~@DBEA\";i:1243;s:14:\"yd=hT?GU~@PBEA\";i:1244;s:14:\"yd=hT?GU~@OBEA\";i:1245;s:15:\"yd=hT?GUO[3rYLA\";i:1246;s:15:\"yd=hT?GUO[GOaLA\";i:1247;s:15:\"yd=hT?GUO[BtYLA\";i:1248;s:15:\"yd=hT?GUO[rPaLA\";i:1249;s:15:\"yd=hT?GUO[VxYLA\";i:1250;s:15:\"yd=hT?GUO[@QaLA\";i:1251;s:15:\"yd=hT?GUO[muYLA\";i:1252;s:15:\"yd=hT?GUO[aSaLA\";i:1253;s:15:\"yd=hT?GUO[E0YLA\";i:1254;s:15:\"yd=hT?GUO[#TaLA\";i:1255;s:14:\"i==hT?GU}j*ACA\";i:1256;s:109:\"S&=hT?GUO[JVaLUEVElg*NNK0klBcM.4FxrjYByERtqBJHNzRmOAc\"p1_Q3nE30o}46F&6LvSQ[zGFKC$AmDSOYMj<e\"0A;C>hT?GUO[&aaLA\";i:1257;s:26:\"FH>hT?GU~@OBc4nt,ub@=17EQA\";i:1258;s:25:\"zd=hT?GU~@OBc4nt,ub@xJ5FA\";i:1259;s:29:\"FH>hT?GUO[3rYL6SVElg*NNK$QlBA\";i:1260;s:26:\"zd=hT?GUO[3rYL6SVElg*NbAIA\";i:1261;s:29:\"FH>hT?GUO[BtYL6SVElg*NNK@QlBA\";i:1262;s:26:\"zd=hT?GUO[BtYL6SVElg*NbAIA\";i:1263;s:29:\"FH>hT?GUO[VxYL6SVElg*NNKlRlBA\";i:1264;s:26:\"zd=hT?GUO[VxYL6SVElg*NbAIA\";i:1265;s:29:\"FH>hT?GUO[muYL6SVElg*NNKFRlBA\";i:1266;s:26:\"zd=hT?GUO[muYL6SVElg*NbAIA\";i:1267;s:29:\"FH>hT?GUO[E0YL6SVElg*NNK*RlBA\";i:1268;s:26:\"zd=hT?GUO[E0YL6SVElg*NbAIA\";i:1269;s:24:\"j==hT?GUyFlBzL.4Fxs@LABA\";i:1270;s:26:\"#5=hT?GU!BlBQM.4FxrjYBWEQA\";i:1271;s:59:\"P&=hT?GU!BlB,L.4FxrjCAw(=hT?GU!BlB(L.4FxrjCAkn?hT?GUO[*hXLA\";i:1272;s:13:\"t8=hT?GUtElBA\";i:1273;s:14:\"t8=hT?GU}j]ACA\";i:1274;s:56:\"8r>hT?GUZA$ACDSOYM@1BtMc_Q3nE3<Ai\"vBJHNz`auWrPqI:$vbmAQA\";i:1275;s:12:\"VE=hT?GUZA$A\";i:1276;s:13:\"c#=hT?GU.DlBA\";i:1277;s:13:\"sP=hT?GUDClBA\";i:1278;s:15:\"c#=hT?GUO[4}ZLA\";i:1279;s:24:\"d#=hT?GU!BlBMM.4FxrjCABA\";i:1280;s:76:\"xP=hT?GUDClBQM.4FxrjYBvDQA.\",ub@y2DAzWp1qI:$vbWUZ\"b#`Q3nE3t`qA[Q?hT?GU~@`ACA\";i:1281;s:13:\"t8=hT?GU!BlBA\";i:1282;s:48:\"vP=hT?GU(ClB;L.4FxrjCA$T=hT?GUO[McaL3LVElg*NABQA\";i:1283;s:13:\"t8=hT?GUWJlBA\";i:1284;s:48:\"YE=hT?GU~AlBoM.4Fx}M2H6F00LvSQ[zhB2W?\",ub@=15EQA\";i:1285;s:13:\"t8>hT?GUHWlBA\";i:1286;s:12:\"VE=hT?GUZA$A\";i:1287;s:12:\"c#>hT?GUZA$A\";i:1288;s:26:\"j==hT?GU~@{A8y#(k)No`,+BIA\";i:1289;s:13:\"t8>hT?GU<HlBA\";i:1290;s:26:\"WE=hT?GU=ElBUM.4FxrjYB^BQA\";i:1291;s:13:\"c#>hT?GUUPlBA\";i:1292;s:36:\"N&=hT?GUaNlBoM.4Fx}MTg6FhtLvSQ[zDAEA\";i:1293;s:36:\"v8>hT?GU<HlB7L.4Fx}M+X6Fu2LvSQ[zBAEA\";i:1294;s:13:\"(a=hT?GUeBlBA\";i:1295;s:26:\"j==hT?GUO[&aYLjHVElg*NTAIA\";i:1296;s:58:\"m==hT?GU~@{A]Q$(k)NohD:CYYzXJI|+EAOc$(k)No&Q:CoYzXJI|+EACA\";i:1297;s:13:\"t8>hT?GU<HlBA\";i:1298;s:59:\"m==hT?GU~@{AOc&(k)No`,nCK\"kt,ub@uC5F00LvSQ[z$Az(nt,ub@@85FA\";i:1299;s:70:\".a=hT?GU}jBB/hkt,ub@=1:DRtuBJHNz:rvWGOqI:$vbmARtvBJHNzd&uWrPqI:$vbmAQA\";i:1300;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GUaNlBUM.4FxrjCABA\";i:1301;s:13:\"_X=hT?GU>BlBA\";i:1302;s:26:\"`X=hT?GUO[xdaL=JVElg*NJAIA\";i:1303;s:26:\"`X=hT?GUO[xdaL=JVElg*NHAIA\";i:1304;s:13:\"A^=hT?GU9ElBA\";i:1305;s:37:\"XE=hT?GU=ElBQM.4Fx~5RAI7>hT?GUO[{eaLA\";i:1306;s:13:\"c#=hT?GUGJlBA\";i:1307;s:12:\"VE=hT?GUZA$A\";i:1308;s:52:\"w8>hT?GU}jGB/hkt,ub@y2mnOtDH_Q3nE3BB$A|CSOYMj<cA2ABA\";i:1309;s:59:\"x8>hT?GUO[PjaL!GVElg*NEBQA,\",ub@&G5F$wLvSQ[zvAz(jt,ub@&G5FA\";i:1310;s:92:\"{2=hT?GUtElBYM.4Fxs@LA+h=hT?GUhIlBcM.4Fxs@LA|e=hT?GUhIlB#L.4Fx}M1a6F#zLvSQ[z0.zWlBqI:$vbKAQA\";i:1311;s:70:\"aE=hT?GU~AlBsM.4Fx}MBAq1=hT?GU!BlBMM.4Fx}M*q6F$wLvSQ[zB[zWrPqI:$vbmAQA\";i:1312;s:12:\"EH=hT?GU5A$A\";i:1313;s:13:\"t8=hT?GU.DlBA\";i:1314;s:68:\"&M>hT?GUORlBbL.4FxrjBAkn=hT?GU!BlBwM.4Fx~5GApI=hT?GUOBlB%N.4Fxs@BABA\";i:1315;s:13:\"_X=hT?GUBIlBA\";i:1316;s:12:\"R@=hT?GU/A$A\";i:1317;s:23:\"FH=hT?GU5A$ALDSOYMLUBtA\";i:1318;s:36:\"v8>hT?GU<HlB5N.4Fx~5VAeZ=hT?GU~@@ACA\";i:1319;s:13:\"(a=hT?GUeBlBA\";i:1320;s:15:\"bS>hT?GUO[0kaLA\";i:1321;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:1322;s:68:\"&M>hT?GUORlBbL.4FxrjBAkn=hT?GU!BlBwM.4Fx~5GApI=hT?GUOBlB%N.4Fxs@BABA\";i:1323;s:74:\"W@=hT?GU/A$AKDSOYMj<cAvAq1=hT?GU#ulBMM.4?zrj&Aq1DblBIGkcwY(Rj\"{e_Q3nE3fX$A\";i:1324;s:119:\"1P=hT?GUuBlB;L.4FxrjCA$T=hT?GU!BlB3L.4Fx~5CAkn=hT?GU>BlBnL.4FxrjYBiERtpBJHNz`auWKCqI:$vbaAS\")\",ub@y2/>Jth=_Q3nE30oA$6FA\";i:1325;s:44:\"jg?hT?IUO[jnaL#zGFnTlB;FkcwYX`C\"UE_Q3nE3%B$A\";i:1326;s:81:\"yP=hT?GU(ClBEM.4Fx~5BA$T=hT?GU!BlB3L.4Fx~5CAD\"_Q3nE3<AgABCJHNzRmPt3AYL=hT?GUeBlBA\";i:1327;s:46:\"O&=hT?GU!BlB,L.4Fxs@SAw(=hT?GU!BlB(L.4Fxs@SABA\";i:1328;s:24:\"ig=hT?GU!BlB,L.4FxrjCABA\";i:1329;s:61:\"ZE=hT?GU~AlB3L.4FxrjYB]ERtnBJHNzzguW_EqI:$vbACgA0BJHNzRmOAe\"A\";i:1330;s:26:\"5r@hT?GUpA$ANDSOYMj<dtVBEA\";i:1331;s:13:\"(a=hT?GUfulBA\";i:1332;s:13:\"\"l=hT?GUDSlBA\";i:1333;s:13:\"bS=hT?GUDSlBA\";i:1334;s:15:\":`=hT?GUO[;vaLA\";i:1335;s:15:\":`=hT?GUO[VxaLA\";i:1336;s:200:\"oCAY&\",ub@^D5F[tLvSQ[zIAbLjt,ub@PP5FGuLvSQ[zVAc4nt,ub@=1#ES\"*\",ub@??5F6yLvSQ[zWBIAit,ub@??5F*xLvSQ[zlAyWit,ub@=16DS\"&\",ub@/B5F%tLvSQ[zGFEU$A=CSOYMAlBt8M_Q3nE3<Ai\"1BJHNzRmvW!mqI:$vbaUCa:ChdzXJI|+wCFBgA\";i:1337;s:36:\"GH>hT?GU~@DBz(nt,ub@JB5Fe2LvSQ[zNAEA\";i:1338;s:24:\"?J=hT?GUoDlB7L.4Fxs@BABA\";i:1339;s:59:\"2d=hT?GUjClB3L.4Fx~5CApI=hT?GUOBlB7L.4FxrjCA%$>hT?GUO[GOYLA\";i:1340;s:69:\"aE=hT?GUZA$A7DSOYM*+8glBYM.4Fxs@FA+h=hT?GU!BlBcM.4Fxs@FA|e=hT?GU!BlBA\";i:1341;s:35:\"XE=hT?GU~AlBjL.4Fxs@EAeZ=hT?GUeBlBA\";i:1342;s:127:\"2P=hT?GUuBlB;L.4FxrjCA$T=hT?GU!BlBnL.4FxrjYB$A2W`\",ub@nH5FQwLvSQ[zSA:>jt,ub@~R5FLvLvSQ[zJAG\"$(k)No\"I:CrXzXJI|+EAm_#(k)Noa.HO1WA\";i:1343;s:37:\"@J=hT?GUoDlBnL.4FxrjYBFFRtpBJHNzcVuWA\";i:1344;s:13:\"\"l=hT?GU4DlBA\";i:1345;s:15:\"\"l=hT?GUO[_)ZLA\";i:1346;s:13:\"\"l=hT?GU!BlBA\";i:1347;s:124:\"eE=hT?GU~AlBrL.4Fx}MCA1k=hT?GU!BlBAM.4FxrjCA$T?hT?GUO[>2aL&aVElg*NNK4olB;P.4FxrjYBJFS\".\",ub@y2EtPt5F_Q3nE30o=/6Fe2LvSQ[zNAEA\";i:1348;s:52:\"vP=hT?GU(ClBoM.4FxrjYB?DRtrBJHNzRmPt6A$T=hT?GU}jDBEA\";i:1349;s:13:\"sP=hT?GU(ClBA\";i:1350;s:13:\"\"l=hT?GU4DlBA\";i:1351;s:26:\"Rj?hT?GU~@BB/hkt,ub@=1jEQA\";i:1352;s:92:\"zP=hT?GUDClBYM.4Fxs@SA+h=hT?GU!BlBcM.4Fxs@SA|e=hT?GU!BlBbL.4FxrjIACt@hT?GUO[s8aL(nVElg*NFAIA\";i:1353;s:13:\"VE=hT?GU~AlBA\";i:1354;s:26:\"u8>hT?GU}jMB:>nt,ub@=1MFQA\";i:1355;s:13:\"VE=hT?GU=ElBA\";i:1356;s:29:\"M&=hT?GUO[muXLoIVElg*NNK/FlBA\";i:1357;s:13:\"t8>hT?GUHWlBA\";i:1358;s:23:\"S@=hT?GU/A$ADDSOYMtOCtA\";i:1359;s:23:\"S@=hT?GU5A$AFDSOYMtOCtA\";i:1360;s:12:\"R@=hT?GUZA$A\";i:1361;s:37:\"0d=hT?GUjClBnL.4Fx}MEAl_=hT?GUO[N/XLA\";i:1362;s:26:\"tP=hT?GUuBlBnL.4FxrjYBRFQA\";i:1363;s:13:\"t8>hT?GUHWlBA\";i:1364;s:24:\"WE=hT?GU=ElBMM.4Fxs@FABA\";i:1365;s:14:\"!5=hT?GU~@}ACA\";i:1366;s:46:\"$M=hT?GU^ClBrL.4Fxs@CAZ4=hT?GUhIlBbL.4Fxs@GABA\";i:1367;s:15:\"9M=hT?GUO[XLYLA\";i:1368;s:24:\"`X>hT?GU<HlB?L.4Fx~5EABA\";i:1369;s:78:\"sB?hT?GUZA$AkDSOYM*+Dtgg_Q3nE3<AgArBJHNz`auW@QqI:$vbmARtqBJHNz`auW\"SqI:$vb|BgA\";i:1370;s:67:\"W@=hT?GUZA$A;CSOYMM%Ct&a_Q3nE3fX$ADDSOYM6|Ttxd_Q3nE3fX$AFDSOYM@1RtA\";i:1371;s:78:\"bE=hT?GU~AlBsM.4Fx}MBAq1=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCATq>hT?GUZA$A\";i:1372;s:13:\"!5=hT?GUNElBA\";i:1373;s:35:\"XE=hT?GU~AlBsM.4Fx}MBAZ4=hT?GUNElBA\";i:1374;s:13:\"!5=hT?GU!BlBA\";i:1375;s:15:\"!5=hT?GUO[ggYLA\";i:1376;s:13:\"VE=hT?GUatlBA\";i:1377;s:24:\"WE=hT?GU=ElBsM.4FxrjAABA\";i:1378;s:13:\"sP=hT?GUDClBA\";i:1379;s:81:\"bE=hT?GU=ElBdN.4FxrjAAq1=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCAeZ>hT?GUO[\"]XLA\";i:1380;s:23:\"S@=hT?GU/A$ADDSOYMLUEtA\";i:1381;s:23:\"S@=hT?GUZA$A;CSOYMM%CtA\";i:1382;s:24:\"WE=hT?GU~AlBoM.4Fx}MGABA\";i:1383;s:86:\"?o=hT?GUO[b#aLXLVElg*NNK9plB3L.4FxrjYBTFRtwBJHNz`auWoIqI:$vbmAQA.\",ub@&G5F{uLvSQ[zJAEA\";i:1384;s:53:\"<o=hT?GUO[ggXLXLVElg*NNKEElB3L.4FxrjYBuA3(.\",ub@im5FA\";i:1385;s:47:\"%5=hT?GUhIlB1N.4Fx}Mo[6F*xLvSQ[zfAG\"#(k)NowG:CA\";i:1386;s:13:\"t8>hT?GUHWlBA\";i:1387;s:13:\"!5=hT?GU!BlBA\";i:1388;s:13:\"L&=hT?GUaNlBA\";i:1389;s:24:\"WE=hT?GU=ElBsM.4FxrjAABA\";i:1390;s:13:\"!5=hT?GU!BlBA\";i:1391;s:15:\"(a=hT?GUO[oIXLA\";i:1392;s:15:\"/o=hT?GUO[y:ZLA\";i:1393;s:23:\"S@=hT?GU5A$AFDSOYM5qCtA\";i:1394;s:23:\"S@=hT?GU/A$ADDSOYM5qCtA\";i:1395;s:57:\"P&=hT?GU#ulB,L.4Fxrj&Aw(=hT?GU#ulB(L.4Fxrj&AHO=hT?GUDClBA\";i:1396;s:24:\"WE=hT?GU]FlBUQ.4Fx~5AABA\";i:1397;s:24:\"d#=hT?GUYDlBYQ.4Fx}MDABA\";i:1398;s:46:\"vP=hT?GUDClBYM.4FxrjFAw(=hT?GU.DlB?L.4Fx~5CABA\";i:1399;s:13:\"sP=hT?GUDClBA\";i:1400;s:15:\"9M=hT?GUO[*hZLA\";i:1401;s:46:\"O&=hT?GU!BlB,L.4FxrjCAw(=hT?GU!BlB(L.4FxrjCABA\";i:1402;s:15:\"VE=hT?GUO[4}YLA\";i:1403;s:112:\"]o=hT?GU>BlBYM.4FxrjCA+h=hT?GU!BlBcM.4FxrjCA|e=hT?GU!BlBIM.4FxrjCAZ4=hT?GU!BlBQM.4FxrjCA]9=hT?GU!BlB5N.4FxrjAABA\";i:1404;s:52:\"w8>hT?GUO[$$aLtJVElg*NNK;flBNN.4Fx~5SA%$>hT?GU~@ZBEA\";i:1405;s:12:\"c#>hT?GUZA$A\";i:1406;s:70:\"aE=hT?GUCFlBFN.4FxrjYB:CS\"*\",ub@FN5FmuLvSQ[zSAc4qt,ub@nH5F;vLvSQ[zKAEA\";i:1407;s:29:\"WE=hT?GUO[lBZLmOVElg*NNKuWlBA\";i:1408;s:13:\"!5=hT?GUhIlBA\";i:1409;s:13:\"!5=hT?GU!BlBA\";i:1410;s:15:\"L&>hT?GUO[K&aLA\";i:1411;s:12:\"c#>hT?GUZA$A\";i:1412;s:13:\"VE>hT?GUtElBA\";i:1413;s:26:\"ig?hT?GUO[&aXLRdVElg*NDAIA\";i:1414;s:14:\"!5=hT?GU~@}ACA\";i:1415;s:13:\"!5=hT?GU!BlBA\";i:1416;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:1417;s:13:\"VE=hT?GUatlBA\";i:1418;s:109:\"0P=hT?GUuBlB;L.4FxrjCAvW=hT?GU>BlB#L.4FxrjDA7y=hT?GUpwlBnL.4FxrjYBRFQA`\",ub@=1HERtsBJHNzRmOAg\"Sq_Q3nE30o.o5FA\";i:1419;s:25:\"d#=hT?GU}jDBFtjt,ub@&G5FA\";i:1420;s:13:\"Qj=hT?GUMHlBA\";i:1421;s:67:\"xP=hT?GU(ClB;L.4FxrjLA<v=hT?GUhIlB?L.4Fxs@LAD\"_Q3nE3QE$ACDSOYMu7HtA\";i:1422;s:25:\"zd=hT?GUjClB_M.4Fx}M7o6FA\";i:1423;s:24:\"d#=hT?GU!BlBfL.4Fx}MBABA\";i:1424;s:13:\"?2=hT?GU!BlBA\";i:1425;s:46:\"O&=hT?GU!BlB,L.4FxrjCAw(=hT?GU!BlB(L.4FxrjCABA\";i:1426;s:185:\"oC^X&\",ub@^D5F`xLvSQ[zBA:>jt,ub@X35FLvLvSQ[zpAG\"$(k)No5b:CrXzXJI|+UA.>#(k)NowG:CQYzXJI|+EAwW$(k)NohD:CgYzXJI|+EA,h$(k)NohD:C=ZzXJI|+EACA>hT?GUO[_)aL6SVElg*N}BRtyBJHNzijzR$A7DSOYM*+8glBA\";i:1427;s:13:\"Qj?hT?GU!BlBA\";i:1428;s:14:\"yd=hT?GU~@]ACA\";i:1429;s:24:\"LV=hT?GUYDlBAM.4Fx~5CABA\";i:1430;s:24:\"ig=hT?GUMHlB,L.4FxrjKABA\";i:1431;s:24:\"LV=hT?GU,GlBAM.4Fx~5EABA\";i:1432;s:13:\"9M>hT?GU|GlBA\";i:1433;s:15:\"L&>hT?GUO[e+aLA\";i:1434;s:15:\"L&>hT?GUO[(,aLA\";i:1435;s:12:\"VE=hT?GUZA$A\";i:1436;s:26:\"!M=hT?GU^ClB0M.4FxrjYBNBQA\";i:1437;s:29:\";`=hT?GUO[N/aLfTVElg*NNKI}lBA\";i:1438;s:13:\"sP=hT?GUuBlBA\";i:1439;s:15:\":`=hT?GUO[|;aLA\";i:1440;s:61:\"wP=hT?GUuBlBEM.4Fxs@)AYL=hT?GUO[h=aLvDVElg*NbA3(*\",ub@y2EtQtA\";i:1441;s:15:\"9M=hT?GUO[[9aLA\";i:1442;s:26:\"`X=hT?GU>BlB9N.4FxrjYBrFQA\";i:1443;s:24:\"M&=hT?GU!BlBcM.4FxrjCABA\";i:1444;s:37:\";o=hT?GUO[4}ZLIIVElg*N9GQA.\",ub@ph7FA\";i:1445;s:13:\"/o=hT?GUSFlBA\";i:1446;s:13:\"\"l?hT?GUSFlBA\";i:1447;s:15:\"L&>hT?GUO[1[aLA\";i:1448;s:59:\">`=hT?GUO[1[XLAgVElg*NNA2W~\",ub@4E5Fx9LvSQ[zGA:>st,ub@4E5FA\";i:1449;s:15:\"L&>hT?GUO[\"]aLA\";i:1450;s:23:\"S@=hT?GU/A$A}CSOYMu7BtA\";i:1451;s:57:\"wP=hT?GU(ClBAM.4Fx}MXA1k=hT?GUBIlBIM.4Fxs@cAkn=hT?GUSFlBA\";i:1452;s:15:\"Wx=hT?GUO[*haLA\";i:1453;s:15:\"!5=hT?GUO[v(ZLA\";i:1454;s:93:\"cE=hT?GU~AlB?L.4FxrjHAD\"_Q3nE32C$AGDSOYM@1Bt@Q_Q3nE3~RvAw(=hT?GU!BlB(L.4Fx}M*q6Fe2LvSQ[z5p0WA\";i:1455;s:88:\"bE=hT?GU=ElB8M.4Fxs@BA%$=hT?GUO[muXLUEVElg*NNK{elBcM.4FxrjYB&A3()\",ub@y2F\"zWTXqI:$vbJDgA\";i:1456;s:13:\"yd=hT?GUjClBA\";i:1457;s:34:\"T@=hT?GU5A$AKDSOYMtOEt:C_Q3nE3cAgA\";i:1458;s:12:\"R@=hT?GU/A$A\";i:1459;s:24:\"@2=hT?GUhIlBsM.4Fxs@AABA\";i:1460;s:118:\"CY=hT?GUO[k_aL=JVElg*NJAJt*\",ub@y2b4LtBt_Q3nE39F$AGDSOYM@1Bt@Q_Q3nE3QE$AHDSOYM@1BtrP_Q3nE3QE$AQDSOYM@1Bt~l_Q3nE3sorABA\";i:1461;s:139:\"t==hT?GUcHlB?L.4FxrjYB(DQA:\",ub@y2b4LtXL_Q3nE3~J$A<CSOYMtOBtgg_Q3nE3<AgArBJHNz`auW@QqI:$vbmARtqBJHNz`auWnbqI:$vbGARt:BJHNzij>Q$AQDSOYM@1BtA\";i:1462;s:26:\":o=hT?GUO[H7ZL:CVElg*NlAIA\";i:1463;s:25:\"zd=hT?GUjClBkM.4Fx}M7o6FA\";i:1464;s:14:\"Qj?hT?GU~@BBEA\";i:1465;s:37:\"{X=hT?GU>BlBiO.4Fx}M7o6Fb#LvSQ[z0.zWA\";i:1466;s:15:\"L&>hT?GUO[(,aLA\";i:1467;s:14:\"_X@hT?GU~@BBEA\";i:1468;s:13:\"_X@hT?GU!BlBA\";i:1469;s:102:\"dE=hT?GU~AlB?L.4FxrjHAD\"_Q3nE32C$AkDSOYM*+gklBNN.4Fx}MQA%$=hT?GU!BlB,L.4Fxs@FAw(=hT?GU!BlB(L.4Fxs@FABA\";i:1470;s:36:\"T@=hT?GU5A$A2DSOYM*+8glB;P.4FxrjCABA\";i:1471;s:12:\"EH=hT?GUpA$A\";i:1472;s:34:\"GH=hT?GU/A$A2DSOYM@1BtY4`Q3nE3<AgA\";i:1473;s:14:\"KV?hT?GU~@BBEA\";i:1474;s:47:\"YE=hT?GU=ElBsM.4FxrjAA$T?hT?GU!BlB;P.4Fx}M7o6FA\";i:1475;s:13:\"bS>hT?GU#ulBA\";i:1476;s:12:\"EH=hT?GU/A$A\";i:1477;s:67:\"W@=hT?GUZA$A<CSOYMtOBt&a_Q3nE3<AgAvBJHNzX0uW+OqI:$vbmAS\",\",ub@FN5FA\";i:1478;s:28:\"WE=hT?IUCFlBUoDAkn_Q3nE3MAgA\";i:1479;s:56:\"V@=hT?GUZA$AMDSOYMu7Ct:C_Q3nE3UAgApBJHNz)duWhNqI:$vbICgA\";i:1480;s:25:\"zd=hT?GUjClBkM.4Fx}M7o6FA\";i:1481;s:14:\"Qj?hT?GU~@BBEA\";i:1482;s:13:\"bS>hT?GU!BlBA\";i:1483;s:23:\"FH=hT?GUpA$ALDSOYM?IBtA\";i:1484;s:12:\"EH=hT?GU/A$A\";i:1485;s:24:\"WE=hT?GU=ElBsM.4FxrjAABA\";i:1486;s:102:\"dE=hT?GU~AlB?L.4FxrjHAD\"_Q3nE32C$AkDSOYM*+gklBNN.4Fx}MQA%$=hT?GU!BlB,L.4Fxs@MAw(=hT?GU!BlB(L.4Fxs@MABA\";i:1487;s:88:\"bE=hT?GU=ElB8M.4Fxs@BA%$=hT?GUO[muXLUEVElg*NNKsslBcM.4FxrjYB&A3()\",ub@y2Q/Qtmu_Q3nE3SG$A\";i:1488;s:67:\"W@=hT?GUZA$A<CSOYMtOBt&a_Q3nE3<AgAvBJHNzX0uW+OqI:$vbmAS\",\",ub@FN5FA\";i:1489;s:24:\"WE=hT?GU=ElBsM.4FxrjAABA\";i:1490;s:56:\"V@=hT?GUZA$AMDSOYMu7Ct:C_Q3nE3UAgApBJHNz)duWhNqI:$vbICgA\";i:1491;s:26:\"zd=hT?GUO[UEZLhNVElg*NTAIA\";i:1492;s:25:\"zd=hT?GUjClB2O.4Fx}M7o6FA\";i:1493;s:23:\"FH=hT?GUpA$ALDSOYM?IBtA\";i:1494;s:12:\"EH=hT?GU/A$A\";i:1495;s:24:\"WE=hT?GU=ElBsM.4FxrjAABA\";i:1496;s:102:\"dE=hT?GU~AlB?L.4FxrjHAD\"_Q3nE32C$AkDSOYM*+gklBNN.4Fx}MQA%$=hT?GU!BlB,L.4Fxs@MAw(=hT?GU!BlB(L.4Fxs@MABA\";i:1497;s:88:\"bE=hT?GU=ElB8M.4Fxs@BA%$=hT?GUO[muXLUEVElg*NNKsslBcM.4FxrjYB&A3()\",ub@y2Q/Qtmu_Q3nE3SG$A\";i:1498;s:124:\"fE=hT?GUZA$ALDSOYM?IBt&a_Q3nE3<AgAvBJHNz`auW+OqI:$vbmAS\",\",ub@&G5FFxLvSQ[zJAFtit,ub@&G5FVxLvSQ[zJA/hit,ub@&G5F!2LvSQ[zGFeW$A\";i:1499;s:15:\"VE=hT?GUO[4}YLA\";i:1500;s:46:\"O&=hT?GU!BlB,L.4FxrjGAw(=hT?GU!BlB(L.4FxrjGABA\";i:1501;s:13:\"/o=hT?GU>BlBA\";i:1502;s:92:\"LH=hT?GUpA$ALDSOYM?IBtlB_Q3nE30od~5FrvLvSQ[zKA/hjt,ub@&G5FwwLvSQ[zSAc4jt,ub@&G5F@wLvSQ[zSAEA\";i:1503;s:12:\"EH=hT?GU/A$A\";i:1504;s:50:\"<o=hT?GU>BlBbL.4FxrjYB<CRt5BJHNzRmOAS\"jn_Q3nE3MAgA\";i:1505;s:104:\"dE=hT?GU~AlB?L.4FxrjHAD\"_Q3nE32C$AkDSOYM*+gklBNN.4Fx}MQA%$=hT?GU!BlB,L.4Fx}M*q6FVxLvSQ[zJA/hit,ub@=1NEQA\";i:1506;s:88:\"bE=hT?GU=ElB8M.4Fxs@BA%$=hT?GUO[muXLUEVElg*NNKsslBcM.4FxrjYB&A3()\",ub@y2Q/Qtmu_Q3nE3SG$A\";i:1507;s:14:\"z:=hT?GU~@BBEA\";i:1508;s:47:\"YE=hT?GU~AlB3L.4Fx~5CAkn=hT?GUYDlB2O.4Fx}M7o6FA\";i:1509;s:82:\"bE=hT?GU~AlB1N.4Fx}Mm36F00LvSQ[z$A:>jt,ub@=1EDQA*\",ub@PP5FVxLvSQ[zieyW(HqI:$vb{AQA\";i:1510;s:68:\"aE=hT?GU~AlBYM.4FxrjCA+h=hT?GU!BlBcM.4FxrjCA|e=hT?GU!BlB9N.4FxrjAABA\";i:1511;s:13:\"Qj=hT?GUSFlBA\";i:1512;s:15:\"L&>hT?GUO[4}aLA\";i:1513;s:14:\"yd=hT?GU~@]ACA\";i:1514;s:38:\"0d=hT?GU~@dBc4nt,ub@xJ7F!2LvSQ[zGF/N$A\";i:1515;s:94:\"zP=hT?GU(ClBAM.4Fxs@FA1k=hT?GUBIlB?L.4Fxs@FAD\"_Q3nE3GC$ACDSOYMtOHt~l_Q3nE30o*h6F2uLvSQ[zGFoQ$A\";i:1516;s:24:\"WE=hT?GU=ElB(L.4Fxs@FABA\";i:1517;s:24:\"ig=hT?GU!BlB,L.4Fxs@FABA\";i:1518;s:13:\"sP?hT?GUgLlBA\";i:1519;s:13:\"yd=hT?GUjClBA\";i:1520;s:34:\"Bm=hT?GU!BlBzL.4Fx~5CA6F=hT?GU/A$A\";i:1521;s:48:\"O&=hT?GU}j*Ax(#(k)NoaI:C4YzXJI{ZRPZL?DVElg*NvAIA\";i:1522;s:13:\"sP=hT?GUDClBA\";i:1523;s:26:\"LV=hT?GU>BlB3L.4Fxrj}BAAIA\";i:1524;s:24:\"LV=hT?GUYDlBAM.4Fx~5CABA\";i:1525;s:71:\"xP=hT?GUDClBbL.4Fxs@GAI7>hT?GU<HlBoM.4FxrjYBuAJt,\",ub@}k5F!2LvSQ[zzb1WA\";i:1526;s:13:\"c#=hT?GU!BlBA\";i:1527;s:12:\"c#>hT?GUZA$A\";i:1528;s:13:\"sP=hT?GUDClBA\";i:1529;s:155:\"hE=hT?IU~AlB%RAAEH_Q3nE3hB$A|CSOYMj<ttAA7F$(k)Noa.7FuW=JqI:$vb7BgA1BJHNz!PvW5FqI:$vb7BgAmBJHNzWHuWDHqI:$vb)qg\"y:_Q3nE3RB$AKDSOYMAlDts8_Q3nE3{K$AQDSOYMj<DtA\";i:1530;s:24:\"zd=hT?GUfOlBbL.4FxrjBABA\";i:1531;s:68:\">o=hT?GU.DlB8M.4FxrjFAHO=hT?GU(ClBAM.4FxrjCA1k=hT?GUBIlBIM.4Fx}MXABA\";i:1532;s:13:\"A^=hT?GU9ElBA\";i:1533;s:24:\"M&=hT?GUhIlBfL.4Fx~5AABA\";i:1534;s:72:\"3d=hT?GUO[$$aL*BVElg*NRA2W*\",ub@&G5FWuLvSQ[zJAG\"#(k)No%D:C>WzXJI|+wC)IgA\";i:1535;s:13:\"sP=hT?GUDClBA\";i:1536;s:45:\"l==hT?GUyFlB?L.4FxrjHAD\"_Q3nE32C$AkDSOYMj<BtA\";i:1537;s:24:\"u8>hT?GU<HlB5N.4FxrjAABA\";i:1538;s:13:\"\"l=hT?GU4DlBA\";i:1539;s:24:\"WE=hT?GU~AlB5N.4FxrjAABA\";i:1540;s:13:\"!5=hT?GUhIlBA\";i:1541;s:12:\"R@=hT?GU5A$A\";i:1542;s:14:\"c#=hT?GU~@{ACA\";i:1543;s:14:\"c#=hT?GU}jDBEA\";i:1544;s:26:\"zd=hT?GUO[$$aL*BVElg*NXAIA\";i:1545;s:57:\"ZE=hT?GU~AlB1N.4FxrjDAkn=hT?GUSFlB8M.4FxrjHA};=hT?GU[IlBA\";i:1546;s:12:\"c#>hT?GUZA$A\";i:1547;s:13:\"!5=hT?GUWJlBA\";i:1548;s:225:\"oCQY&\",ub@^D5F[tLvSQ[zIAc4it,ub@&G5FrvLvSQ[zKAFtht,ub@y2`QBtXL_Q3nE3H#:C5F;vLvSQ[zKAG\"$(k)No1H:C4gzXJI{ZDAx(%(k)NowG:C@YzXJI{ZMAa4#(k)Noa.IOuWZlqI:$vbxfKC:C$gzXJI|+`DcARt<BJHNznEuWY4qI:$vbGARt=BJHNznEuW95qI:$vbGARt>BJHNznEuWA\";i:1549;s:15:\"Wx=hT?GUNkYLXLA\";i:1550;s:15:\"KV=hT?GUNkYLXLA\";i:1551;s:56:\"8r>hT?GUZA$ACDSOYM@1BtMc_Q3nE3<Ai\"vBJHNz`auWrPqI:$vbmAQA\";i:1552;s:84:\"sB>hT?GUgLlBoM.4Fx}MFAI7>hT?GUO[b#XLGOVElg*NNK[NlBNN.4Fx~5SAf+>hT?GUiVlB/N.4Fx~5eABA\";i:1553;s:72:\"y8>hT?GU<HlBbL.4?zrjBAq1mClBMGkcwYX`H\"@Q_Q3nE3GC$AHDSOYM6|DtrP_Q3nE3GC$A\";i:1554;s:13:\"t8>hT?GUjClBA\";i:1555;s:37:\"v8>hT?GU<HlB_M.4FxrjCA%$>hT?GUO[aSZLA\";i:1556;s:24:\"u8>hT?GUjClB5N.4FxrjAABA\";i:1557;s:12:\"VE=hT?GUZA$A\";i:1558;s:15:\"z:=hT?GUNk9MXLA\";i:1559;s:15:\"Qj?hT?GUNk9MXLA\";i:1560;s:70:\"aE=hT?GU~AlBrL.4Fxs@CA%$=hT?GU}jVBFtit,ub@0Q5FVxLvSQ[zWC1W(HqI:$vbDBgA\";i:1561;s:13:\"Qj=hT?GUtElBA\";i:1562;s:13:\"Qj=hT?GU9UlBA\";i:1563;s:50:\"YE=hT?GUZA$AJDSOYMj<ttEA,h$(k)NohD:CjXzXJI|+`DoAQA\";i:1564;s:13:\"bS>hT?GU!BlBA\";i:1565;s:14:\"i==hT?GU}j*ACA\";i:1566;s:29:\"M&=hT?GUNksPXLoIVElg*N+P`BlBA\";i:1567;s:75:\"&M>hT?GUNk[QXLi\"LvSQ[zbA/hjt,ub@&G5FwwLvSQ[zGFYQ$AEDSOYM@1Bt{e_Q3nE30oIo6FA\";i:1568;s:26:\"!M>hT?GUNkbSXL(HVElg*NvAIA\";i:1569;s:13:\"c#=hT?GUtElBA\";i:1570;s:15:\":`=hT?GUNk$TXLA\";i:1571;s:15:\"!5=hT?GUO[Q@ZLA\";i:1572;s:24:\"#5=hT?GU!BlBUM.4Fx~5TABA\";i:1573;s:13:\"sP=hT?GUDClBA\";i:1574;s:112:\"q==hT?GUNkKVXL_EVE^2*NVA3(0QXL[tLvSQ[zPAbLjt,ub@N15FbvLvSQ[ztA/hjt,ub@d*5F6yLvSQ[zXA/hqt,ub@=1TERt$BJHNzRm8WGABA\";i:1575;s:15:\"9M>hT?GUO[s8ZLA\";i:1576;s:13:\"VE=hT?GUatlBA\";i:1577;s:97:\"zP=hT?GUuBlB;L.4FxrjCA$T=hT?GU!BlB?L.4Fx~5CAvW=hT?GU>BlB#L.4FxrjYBFDQA(\",ub@y2mnNtSq_Q3nE30o0k5FA\";i:1578;s:23:\"hg?hT?IUO[jnaL#zGFnTlBA\";i:1579;s:12:\"VE=hT?GUZA$A\";i:1580;s:26:\"tP=hT?GUDClB2O.4Fxrj}BSAIA\";i:1581;s:138:\"EY=hT?GU>BlBGO.4FxrjAA[Q>hT?GU!BlB}M.4FxrjCA%$=hT?GU}jVBFtit,ub@=1WDQA.\",ub@=1`ERtqBJHNzd&uW\"SqI:$vbtfT\"y:_Q3nE3^D$AaDSOYM*+Dtmu_Q3nE3<AgA\";i:1582;s:167:\"0B?hT?GUatlBbL.4FxrjBAHO=hT?GU(ClBAM.4Fxs@FAkn=hT?GU.DlB8M.4FxrjFAvW=hT?GU.DlBfL.4Fxs@AA1k=hT?GUBIlBIM.4Fx}MXAI7>hT?GU<HlBYM.4FxrjCA+h=hT?GU!BlBcM.4FxrjCA|e=hT?GU!BlBA\";i:1583;s:13:\"t8>hT?GU<HlBA\";i:1584;s:13:\"t8>hT?GU<HlBA\";i:1585;s:24:\"u8>hT?GU<HlB7L.4Fxs@BABA\";i:1586;s:13:\"t8>hT?GU<HlBA\";i:1587;s:13:\"t8>hT?GU<HlBA\";i:1588;s:70:\"aE=hT?GUZA$A_CSOYMj<Bt5F_Q3nE30o`x6FrvLvSQ[zSAEA%(k)No9P:CQYzXJI|+EACA\";i:1589;s:70:\"xP=hT?GU(ClB;L.4Fx~5CA$T=hT?GU!BlB3L.4Fx~5CA1k?hT?GUNkvWXLrPVElg*NlAIA\";i:1590;s:92:\"zP=hT?GUDClB1N.4Fx}Mm36FRtLvSQ[zFA:>jt,ub@ph5FLvLvSQ[zJAG\"$(k)No&Q:CrXzXJI|+EAa4$(k)No`,DCIA\";i:1591;s:24:\"u8>hT?GUHWlB5N.4FxrjAABA\";i:1592;s:13:\"!5=hT?GUhIlBA\";i:1593;s:56:\"8r>hT?GUZA$ACDSOYM@1BtMc_Q3nE35B$AEDSOYM@1Bt{e_Q3nE35B$A\";i:1594;s:12:\"VE=hT?GUZA$A\";i:1595;s:13:\"Qj=hT?GU9UlBA\";i:1596;s:12:\"VE=hT?GUZA$A\";i:1597;s:13:\"hg=hT?GUcHlBA\";i:1598;s:26:\"!M>hT?GUNk[QXLDHVElg*NEBQA\";i:1599;s:15:\"hg=hT?GUO[ggXLA\";i:1600;s:26:\"!M>hT?GUNkbSXLDHVElg*NEBQA\";i:1601;s:13:\"hg=hT?GU4DlBA\";i:1602;s:26:\"!M>hT?GUNk_XXLDHVElg*NEBQA\";i:1603;s:15:\"hg=hT?GUNkeZXLA\";i:1604;s:118:\"1P=hT?GU(ClB;L.4FxrjLA<v=hT?GU!BlBIM.4Fx~5YAkn=hT?GUNElB8M.4Fxs@FA|e?hT?GU~@EB:>nt,ub@y29yCt~l_Q3nE3t`wAeZ=hT?GU~@MBEA\";i:1605;s:27:\"!M>hT?GUO[s8ZLGOVElg*N[}KtA\";i:1606;s:15:\":`=hT?GUNk$TXLA\";i:1607;s:15:\"yd=hT?GUO[$$aLA\";i:1608;s:27:\"FH>hT?GU~@XBc4nt,ub@y2Q/DtA\";i:1609;s:13:\"t8>hT?GUjClBA\";i:1610;s:35:\"XE=hT?GU~AlBcM.4Fxs@FAHO=hT?GUDClBA\";i:1611;s:81:\"\"X=hT?GU>BlBYM.4FxrjCA+h=hT?GUSFlBcM.4FxrjCA|e=hT?GUhIlB?L.4FxrjYBeERt1BJHNz`auWA\";i:1612;s:130:\"2P=hT?GU(ClB;L.4FxrjCA<v=hT?GU!BlBYM.4FxrjCA+h=hT?GU!BlBcM.4FxrjCA|e=hT?GU!BlB?L.4FxrjYBeEQA:\",ub@y2PcNtXL_Q3nE30oww6F:yLvSQ[zJAEA\";i:1613;s:12:\"VE=hT?GUZA$A\";i:1614;s:13:\"VE=hT?GU\"tlBA\";i:1615;s:161:\"iE=hT?GU~AlBrL.4Fx}MCAYL=hT?GUO[BtXL:CVElg*NVAJt*\",ub@nH5FbvLvSQ[zJA:>ht,ub@&G5FxtLvSQ[zGAFtmt,ub@FN5F00LvSQ[zosyW\"SqI:$vb]AQA:\",ub@lt5F2uLvSQ[zJA:>nt,ub@y2`QCtA\";i:1616;s:37:\"#M=hT?GUO[XLYLFBVElg*NnA2W)\",ub@dF5FA\";i:1617;s:342:\"oCFZ&\",ub@^D5F[tLvSQ[zIAc4it,ub@&G5FAwLvSQ[zJAG\"#(k)Noa.knwWlBqI:$vbKAS\"*\",ub@y2/>FtBt_Q3nE30o>25FS6LvSQ[zp~zWMcqI:$vbaU,b:CaazXJI{Zj5aLEUVElg*N9CS\"@\",ub@S{5F*xLvSQ[zGFDH$AkDSOYM*+DtC\"qI:$vbGARtwBJHNz`auWoIqI:$vbmAQA.\",ub@&G5F{uLvSQ[zJAbLlt,ub@&G5F#zLvSQ[zJA/hjt,ub@&G5FwwLvSQ[zJAc4jt,ub@&G5F@wLvSQ[zJAbLit,ub@y2zWCt>2_Q3nE3<Ai\"$BJHNzRmPtUABA\";i:1618;s:13:\"(a=hT?GUeBlBA\";i:1619;s:13:\"bS>hT?GU!BlBA\";i:1620;s:31:\"zd=hT?IUjClB&!~AVAg4nt,ub@c}5FA\";i:1621;s:15:\"(a=hT?GUO[\"]ZLA\";i:1622;s:13:\"EH>hT?GUnGlBA\";i:1623;s:31:\"zd=hT?IUHWlB&!~AWAg4nt,ub@xJ5FA\";i:1624;s:15:\"(a=hT?GUO[\"]ZLA\";i:1625;s:13:\"(a=hT?GUeBlBA\";i:1626;s:14:\"EH>hT?GU~@XBEA\";i:1627;s:48:\"YE=hT?GUO[4}YL:CVElg*NVAJt*\",ub@nH5FhtLvSQ[zCAEA\";i:1628;s:105:\"dE=hT?GU~AlBIM.4FxrjCAZ4=hT?GUYDlBQM.4FxrjCA]9=hT?GUYDlB3L.4Fxrj}BuAIAjt,ub@nH5FFxLvSQ[zXA/hkt,ub@y2GtCtA\";i:1629;s:69:\"~X=hT?GU>BlBGO.4FxrjAAI7>hT?GU<HlB_M.4FxrjCA6F=hT?GUpA$A7DSOYM*+?nlBA\";i:1630;s:12:\"VE=hT?GUZA$A\";i:1631;s:154:\"hE=hT?GUO[lBZLmOVElg*NNKuWlB?L.4Fx~5CAvW=hT?GU>BlBYM.4FxrjYB%BQA*\",ub@PP5FVxLvSQ[zGF>G$A`CSOYMifCtK&_Q3nE3MAi\"uBJHNz`auWGOqI:$vbmARtvBJHNz`auWrPqI:$vbmAQA\";i:1632;s:124:\"s==hT?GU}jVBbLht,ub@^D5FZ1LvSQ[zBA:>jt,ub@&G5FLvLvSQ[zJAG\"$(k)NohD:CrXzXJI|+EA]Q$(k)NohD:CYYzXJI|+EAOc$(k)NohD:CoYzXJI|+EACA\";i:1633;s:13:\"VE=hT?GU~AlBA\";i:1634;s:48:\"YE=hT?GU=ElBQM.4Fxs@FAI7>hT?GU<HlB9N.4FxrjYB/BQA\";i:1635;s:13:\"!5=hT?GUhIlBA\";i:1636;s:26:\"d#>hT?GUZA$A^CSOYMj<dtCBEA\";i:1637;s:12:\"VE=hT?GUZA$A\";i:1638;s:13:\"VE=hT?GU\"tlBA\";i:1639;s:12:\"VE=hT?GUZA$A\";i:1640;s:13:\"sP=hT?GUDClBA\";i:1641;s:82:\"yP=hT?GU(ClBzL.4FxrjCA[Q=hT?GU!BlB<M.4FxrjYAkn=hT?GU}jdBG\"#(k)NohD:CfbzXJI|+`DJBgA\";i:1642;s:24:\"`X=hT?GU>BlB#L.4FxrjfABA\";i:1643;s:13:\"yd=hT?GUjClBA\";i:1644;s:12:\"VE=hT?GUZA$A\";i:1645;s:113:\"*M>hT?GUORlBbL.4FxrjBAHO=hT?GU(ClB;L.4FxrjYB0A3((\",ub@Vd5Fb#LvSQ[z@HaC$A7DSOYMj<ttNAln*(k)Noa..>uW`xqI:$vbxfNJ:CA\";i:1646;s:99:\")M>hT?GUORlBbL.4FxrjBAHO=hT?GU(ClB;L.4Fxrj}B6A3((\",ub@im5Fb#LvSQ[z@H6C$A7DSOYMj<ttPAln((k)Noa.m_uWA\";i:1647;s:12:\"VE=hT?GUZA$A\";i:1648;s:15:\"4r=hT?GUNkCtXLA\";i:1649;s:15:\"4r=hT?GUNknuXLA\";i:1650;s:15:\"4r=hT?GUO[+>aLA\";i:1651;s:15:\"4r=hT?GUNk<vXLA\";i:1652;s:15:\"4r=hT?GUNkWxXLA\";i:1653;s:38:\"dS>hT?GUZA$AJDSOYMj<sAJA2[@hT?GU}jaBEA\";i:1654;s:12:\"VE=hT?GUZA$A\";i:1655;s:12:\"VE=hT?GUZA$A\";i:1656;s:80:\"4d=hT?GUjClB_M.4Fx}M676FFxLvSQ[zvAFtit,ub@ph5FVxLvSQ[zvA/hit,ub@ph5F:yLvSQ[z+AEA\";i:1657;s:12:\"VE=hT?GUZA$A\";i:1658;s:24:\"cS>hT?GU!BlB9N.4FxrjAABA\";i:1659;s:25:\"zd=hT?GU~@DBc4nt,ub@c}5FA\";i:1660;s:26:\"FH>hT?GUO[UEaL3LVElg*NTAIA\";i:1661;s:68:\"3d=hT?GUjClB_M.4FxrjCA%$=hT?GU!BlB,L.4FxrjCAw(=hT?GU!BlB(L.4FxrjCABA\";i:1662;s:12:\"VE=hT?GUZA$A\";i:1663;s:68:\"gS>hT?GU!BlBYM.4Fxs@LA+h=hT?GUyFlBcM.4Fxs@LA|e=hT?GUyFlB9N.4FxrjAABA\";i:1664;s:24:\"zd=hT?GUHWlB_M.4FxrjCABA\";i:1665;s:13:\"KV@hT?GUHWlBA\";i:1666;s:39:\"XE=hT?GU~AlB1N.4Fxrj}B:AJt:\",ub@y2:hDtA\";i:1667;s:26:\"zd=hT?GUNkq1XL6SVElg*NbAIA\";i:1668;s:15:\"EH>hT?GUNkq1XLA\";i:1669;s:13:\"t8>hT?GUjClBA\";i:1670;s:24:\"zd=hT?GUHWlB_M.4FxrjCABA\";i:1671;s:48:\"pB?hT?GUZA$AGDSOYM@1Bt*h_Q3nE3<Ai\"#BJHNzRm8WLABA\";i:1672;s:13:\"sP=hT?GU<HlBA\";i:1673;s:90:\"AY=hT?GU>BlBzL.4FxrjCA<v=hT?GUYDlB$M.4FxrjCA%$=hT?GUcHlB,L.4FxrjCAw(=hT?GU!BlB(L.4FxrjCABA\";i:1674;s:12:\"VE=hT?GUZA$A\";i:1675;s:12:\"VE=hT?GUZA$A\";i:1676;s:91:\"cE=hT?GU~AlBsM.4Fx}MBA%$=hT?GU!BlB,L.4FxrjKAw(=hT?GU!BlB(L.4FxrjKAvW=hT?GU>BlBiO.4Fx}M7o6FA\";i:1677;s:12:\"KV?hT?GUZA$A\";i:1678;s:13:\"bS>hT?GU!BlBA\";i:1679;s:13:\"t8=hT?GUcHlBA\";i:1680;s:69:\"Q&=hT?GU:NlB,L.4FxrjKAw(=hT?GU:NlB(L.4FxrjKA[Q?hT?GU~@`AOc((k)No$W:CA\";i:1681;s:12:\"mB?hT?GUZA$A\";i:1682;s:37:\"jg>hT?GU]VlB1N.4FxrjfA};=hT?GUNk?2XLA\";i:1683;s:145:\"hE=hT?GU\"tlB;L.4Fx~5)AvW=hT?GU?ulBgM.4Fxrj&A$T=hT?GUZwlBrL.4Fxs@&AeZ=hT?GUfulB_M.4Fxrj$A%$=hT?GU#ulB,L.4Fxrj&Aw(=hT?GU#ulB(L.4Fxrj&ATq=hT?GUatlBA\";i:1684;s:53:\"YE=hT?GU=ElB<M.4FxrjYB*DQA,\",ub@y28FNtY4_Q3nE3H#Mc5FA\";i:1685;s:13:\"_X=hT?GU>BlBA\";i:1686;s:13:\"_X=hT?GUBIlBA\";i:1687;s:13:\"A^=hT?GU9ElBA\";i:1688;s:13:\"_X=hT?GUuRlBA\";i:1689;s:13:\"A^=hT?GU9ElBA\";i:1690;s:13:\"_X=hT?GU{JlBA\";i:1691;s:13:\"A^=hT?GU9ElBA\";i:1692;s:13:\"_X=hT?GULKlBA\";i:1693;s:13:\"A^=hT?GU9ElBA\";i:1694;s:13:\"_X=hT?GUSVlBA\";i:1695;s:13:\"A^=hT?GU9ElBA\";i:1696;s:12:\"VE=hT?GUZA$A\";i:1697;s:24:\"WE=hT?GU\"tlB7L.4Fxs@%ABA\";i:1698;s:26:\"tP=hT?GUDClBnL.4FxrjYBxDQA\";i:1699;s:84:\"yP=hT?GU(ClB;L.4FxrjCA$T=hT?GU!BlB?L.4Fx~5EAvW=hT?GU>BlBnL.4FxrjYBiERt$BJHNzRm)WKABA\";i:1700;s:12:\"mB?hT?GUZA$A\";i:1701;s:12:\"mB?hT?GUZA$A\";i:1702;s:24:\"M&=hT?GU.DlBcM.4FxrjFABA\";i:1703;s:13:\"(a=hT?GUfulBA\";i:1704;s:12:\"VE=hT?GUZA$A\";i:1705;s:13:\"L&=hT?GU!BlBA\";i:1706;s:24:\"`X=hT?GU>BlBbL.4FxrjBABA\";i:1707;s:13:\"(a=hT?GU!BlBA\";i:1708;s:13:\"(a=hT?GUeBlBA\";i:1709;s:13:\"sP=hT?GUDClBA\";i:1710;s:46:\"O&=hT?GU!BlB,L.4FxrjFAw(=hT?GU!BlB(L.4FxrjFABA\";i:1711;s:24:\":o=hT?GUZwlBGO.4Fxrj$ABA\";i:1712;s:13:\"KV=hT?GUYDlBA\";i:1713;s:13:\"t8>hT?GUjClBA\";i:1714;s:13:\"t8>hT?GUkvlBA\";i:1715;s:25:\"nB?hT?GUZA$A^CSOYM*+sglBA\";i:1716;s:13:\"(a=hT?GUeBlBA\";i:1717;s:13:\"yd=hT?GUjClBA\";i:1718;s:13:\"yd=hT?GUHWlBA\";i:1719;s:12:\"mB?hT?GUZA$A\";i:1720;s:13:\"t8>hT?GUjClBA\";i:1721;s:13:\"t8>hT?GUkvlBA\";i:1722;s:25:\"nB?hT?GUZA$AmDSOYM*+JplBA\";i:1723;s:15:\"(a=hT?GUNkI7XLA\";i:1724;s:13:\"yd=hT?GUjClBA\";i:1725;s:13:\"t8>hT?GUHWlBA\";i:1726;s:13:\"t8>hT?GUI(lBA\";i:1727;s:37:\"oB?hT?GUZA$AmDSOYM*+JplB7L.4Fx}M{n6FA\";i:1728;s:13:\"(a=hT?GUeBlBA\";i:1729;s:13:\"yd=hT?GUHWlBA\";i:1730;s:148:\"A3=hT?GU!BlBMM.4Fx~5EAI7=hT?GUtElBUM.4Fx~5EA%$=hT?GUNElB,L.4FxrjCAw(=hT?GUNElB(L.4FxrjCAHO=hT?GUDClB#L.4Fx}M1a6F#zLvSQ[zJAyWkt,ub@=1HEQA`\",ub@=1HEQA\";i:1731;s:13:\"t8=hT?GU!BlBA\";i:1732;s:13:\"sP=hT?GUDClBA\";i:1733;s:13:\"L&=hT?GU!BlBA\";i:1734;s:110:\"dE=hT?GU~AlBoM.4Fx}M,E6F6yLvSQ[zGFRV$AaDSO}MWDFt&a\"IdA(a_Q3nE3<AgAvBJHNz`auW+OqI:$vbmAS\",\",ub@&G5Fe2LvSQ[ziBIA\";i:1735;s:69:\"n==hT?GU[IlBIM.4FxrjCAZ4=hT?GU!BlBQM.4FxrjCA]9=hT?GU!BlB1N.4Fx}Mf86FA\";i:1736;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:1737;s:56:\"IH=hT?GUpA$AGDSOYMifCt@Q_Q3nE3<AgAxBJHNz#8uW(HqI:$vbmAQA\";i:1738;s:13:\"i==hT?GU4DlBA\";i:1739;s:26:\"j==hT?GU~@&A^9%(k)No`,0BIA\";i:1740;s:80:\"KH=hT?GUpA$AGDSOYMifCt@Q_Q3nE3<AgAxBJHNz#8uW(HqI:$vbmAS\")\",ub@xJ5F\"yLvSQ[zGFNR$A\";i:1741;s:13:\"i==hT?GU4DlBA\";i:1742;s:26:\"j==hT?GU~@&A^9%(k)No`,0BIA\";i:1743;s:13:\"t8>hT?GUkvlBA\";i:1744;s:13:\"t8=hT?GU.DlBA\";i:1745;s:79:\"\"X=hT?GU>BlB_M.4FxrjAANc=hT?GUHWlBYM.4FxrjCA+h=hT?GU!BlBcM.4FxrjCA|e=hT?GU!BlBA\";i:1746;s:83:\"bE=hT?GUO[4}YL:CVElg*NVAJt*\",ub@y2{9Dtgg_Q3nE3GC$A{CSOYM@1Bt*h_Q3nE3GC$A`CSOYM@1BtA\";i:1747;s:84:\"bE=hT?GUO[lBZLmOVElg*NNKuWlBfL.4Fx~5AA%$=hT?GU!BlB,L.4FxrjFAw(=hT?GU!BlB(L.4FxrjFABA\";i:1748;s:70:\"xP=hT?GUDClBnL.4Fx}MDAI7>hT?GUjClB|L.4Fx~5&A};=hT?GU}j|A^9%(k)No`,yCIA\";i:1749;s:58:\"wP=hT?GUDClBnL.4Fx}MDAI7>hT?GUjClBoM.4FxrjMA|e>hT?GU~@,ACA\";i:1750;s:103:\"dE=hT?GU~AlBrL.4Fxs@DA1k=hT?GU!BlBzL.4FxrjCAkn=hT?GU>BlB3L.4Fx~5CANc=hT?GUHWlBnL.4Fxs@BAeZ=hT?GUNkI7XLA\";i:1751;s:42:\"oB?hT?GUO[k_YL>WVElg*NNKDHlB#L.4FxrjYB{CQA\";i:1752;s:42:\"oB?hT?GUO[/`YL>WVElg*NNKDHlB#L.4FxrjYB{CQA\";i:1753;s:13:\"t8=hT?GU.DlBA\";i:1754;s:13:\"nu=hT?GU>BlBA\";i:1755;s:102:\"dE=hT?GU~AlBIM.4FxrjCAZ4=hT?GU!BlBQM.4Fxs@FA]9=hT?GU!BlBoM.4Fx~5MAD\"_Q3nE3\"!gA|e>hT?GU]VlB1N.4FxrjfABA\";i:1756;s:13:\"_X=hT?GU>BlBA\";i:1757;s:13:\"t8=hT?GUtElBA\";i:1758;s:68:\"aE=hT?GU~AlB|L.4Fx~5CAq1=hT?GU!BlBMM.4Fx~5EAI7=hT?GU!BlBUM.4Fx~5EABA\";i:1759;s:24:\"tP=hT?GUDClBfL.4Fx~5AABA\";i:1760;s:29:\")a>hT?GUO[\"]XLZFVElg*NNK\"ClBA\";i:1761;s:13:\"t8=hT?GUaNlBA\";i:1762;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:1763;s:13:\"L&=hT?GUaNlBA\";i:1764;s:13:\"bS>hT?GU!BlBA\";i:1765;s:74:\"W@=hT?GU/A$ACDSOYM@1BtMc_Q3nE3<Ai\"vBJHtz`auWhNvARt,\",ub@&G5FmuLvSQ[z@H?D$A\";i:1766;s:89:\"tB?hT?GUZA$AVDSOYM?IBtjn_Q3nE3cAgApBJHNzRmvWQQqI:$vbmAQA*\",ub@&G5FVxLvSQ[zJA/hit,ub@&G5FA\";i:1767;s:13:\"_X=hT?GU>BlBA\";i:1768;s:114:\"eE=hT?GU~AlBoM.4Fx~5MAq1=hT?GU!BlBMM.4FxrjCAI7=hT?GUGJlBUM.4FxrjCA|e>hT?GU]VlB1N.4FxrjfA1k@hT?GU~@`A,h((k)No`,@BIA\";i:1769;s:13:\"t8>hT?GU<HlBA\";i:1770;s:12:\"c#>hT?GUZA$A\";i:1771;s:69:\"n==hT?GU%IlBIM.4FxrjCAZ4=hT?GU!BlBQM.4Fxs@LA]9=hT?GU!BlBNN.4Fx}M$/6FA\";i:1772;s:13:\"t8=hT?GUNElBA\";i:1773;s:61:\"P&=hT?GUO[#TYLUEVElg*NTAIAkt,ub@y2/>FtrP_Q3nE3<AgAmBJHNzWHuWA\";i:1774;s:13:\"t8=hT?GUhIlBA\";i:1775;s:37:\"jg>hT?GU]VlBoM.4FxrjYBTFRt#BJHNzS^xWA\";i:1776;s:106:\"dE=hT?GU=ElB_M.4Fx}M7o6F+uLvSQ[zcQzWQQqI:$vbDBgArBJHNzd&uW@QqI:$vbDBi\"qBJHNzd&uW5FqI:$vbaUx9:C^XzXJI{ZFACA\";i:1777;s:24:\"`X=hT?GU>BlB#L.4FxrjDABA\";i:1778;s:14:\"4r=hT?GU~@ABEA\";i:1779;s:108:\"dE=hT?GU~AlBsM.4FxrjAAI7=hT?GUGJlB1N.4Fx}Mf86F*xLvSQ[zGF*B$AaDSOYM*+_olB3P.4FxrjYB>CS\"&\",ub@TD5F2!LvSQ[z)AEA\";i:1780;s:64:\"}X=hT?GU>BlBYM.4FxrjYBzFQA*\",ub@=1bEQA.\",ub@y2Q/QtrP_Q3nE3t`wABA\";i:1781;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:1782;s:15:\"(a>hT?GUO[\"]XLA\";i:1783;s:13:\"L&=hT?GUNElBA\";i:1784;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:1785;s:56:\"8r>hT?GUZA$ACDSOYM@1BtMc_Q3nE3<Ai\"vBJHNz`auWrPqI:$vbmAQA\";i:1786;s:26:\"Am@hT?GU~@`A,h((k)No`,@BIA\";i:1787;s:13:\"t8>hT?GU<HlBA\";i:1788;s:48:\"%5=hT?GUhIlBBN.4Fx}MhW6Fe2LvSQ[zd90W$AVElg*N3AIA\";i:1789;s:15:\"9M>hT?GUNkc#XLA\";i:1790;s:15:\"9M>hT?GUNk%$XLA\";i:1791;s:15:\"9M>hT?GUNkL&XLA\";i:1792;s:15:\"9M>hT?GUNkw(XLA\";i:1793;s:15:\"9M>hT?GUNkw(XLA\";i:1794;s:15:\"9M>hT?GUNk`)XLA\";i:1795;s:60:\"P&=hT?GU~@}Ax(#(k)NohD:C4YzXJI{ZE+ZL?DVElg*NTAK\"qt,ub@=1HEQA\";i:1796;s:14:\"z:=hT?GU~@BBEA\";i:1797;s:24:\"Rj?hT?GU!BlBcM.4FxrjCABA\";i:1798;s:13:\"hg=hT?GUaNlBA\";i:1799;s:14:\"EH>hT?GU~@XBEA\";i:1800;s:118:\"q==hT?GU~@{Aln$(k)Noa.eZ0WoIqI:$vbcCgAxBJHNzRm8WyA|e=hT?GUWJlB1N.4?z}MLAq1H#PjXLS6LvSQ[zp~zW&aqI:$vbA2Y\"h=_Q3nE3so6ABA\";i:1801;s:36:\"e#>hT?GUZA$AkDSOYMj<Bt;v_Q3nE3sovABA\";i:1802;s:68:\"aE=hT?GU~AlBsM.4Fx}MBAq1=hT?GU!BlBMM.4Fx~5RAI7=hT?GUlMlBUM.4FxrjCABA\";i:1803;s:28:\"WE=hT?IUCFlBUoDANc_Q3nE3wE$A\";i:1804;s:34:\"{X=hT?GU>BlBoM.4Fx}MNA6F=hT?GUpA$A\";i:1805;s:56:\"O&=hT?GUO[8MaLUEVElg*NNKfjlBcM.4FxrjYBmERtqBJHNzRm8WyABA\";i:1806;s:69:\"Q&=hT?GU!BlB,L.4FxrjCAw(=hT?GU!BlB(L.4FxrjCA6F=hT?GUpA$APDSOYM*+_YlBA\";i:1807;s:54:\"O&>hT?IU~@ZB/ha.]9Ct$AVElg*NLAJt?\",ub@JB5F00LvSQ[zhBIA\";i:1808;s:13:\"t8>hT?GUjClBA\";i:1809;s:56:\"O&=hT?IUFMlBrzj&5FzXzXJI{Zv`ZLoIVElg*NB.MtrP_Q3nE3~RvABA\";i:1810;s:175:\"vg?hT?GU~@EB/hkt,ub@y2`QEtVx`Q3nE30olB6FgwLvSQ[zJAFtjt,ub@&G5F$wLvSQ[zJAz(jt,ub@&G5FFxLvSQ[zpAFtit,ub@Vd5FVxLvSQ[zpA/hit,ub@Vd5F?zLvSQ[zGF;X$AkDSOYMj<Bt:C_Q3nE3UAi\"6BJHNzj@xWA\";i:1811;s:24:\"WE=hT?GU~AlB5N.4Fx~5VABA\";i:1812;s:12:\"EH=hT?GU/A$A\";i:1813;s:12:\"EH=hT?GU5A$A\";i:1814;s:15:\"yd=hT?GUO[$$aLA\";i:1815;s:21:\"EH>hT?IU~@XB/ha.a4CtA\";i:1816;s:25:\"u8>hT?GUjClB#L.4Fx}M2,6FA\";i:1817;s:83:\"bE=hT?GU~AlBoM.4FxrjYBoA3(+\",ub@Yk5FwwLvSQ[zJAc4jt,ub@&G5F@wLvSQ[zJAbLit,ub@y2.hBtA\";i:1818;s:12:\"VE=hT?GUZA$A\";i:1819;s:26:\"!M>hT?GUNk[QXLDHVElg*NEBQA\";i:1820;s:26:\"!M>hT?GUNkz:XLDHVElg*NEBQA\";i:1821;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:1822;s:56:\"^2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCA[Q>hT?GUZA$A\";i:1823;s:13:\"z:=hT?GU!BlBA\";i:1824;s:14:\"z:=hT?GU~@BBEA\";i:1825;s:24:\"ig@hT?GUlMlB?P.4Fx~5RABA\";i:1826;s:24:\"Rj@hT?GUlMlB^P.4Fx~5RABA\";i:1827;s:118:\"eE=hT?GU~AlBrL.4Fxs@CA%$=hT?GU~@YBFtit,ub@}k5FVxLvSQ[z`V1W(HqI:$vbcCi\"#BJHNzijlL$AVDSOYM*+8glBkM.4FxrjCA%$>hT?GU~@ZBEA\";i:1828;s:14:\"!5=hT?GU~@YBEA\";i:1829;s:13:\"Qj=hT?GU.DlBA\";i:1830;s:150:\"hE=hT?GU~AlB<M.4Fxrj}BRBRtnBJHNz:ruW|LqI:$vbmARtrBJHNzRmvW=JqI:$vbDBgA1BJHNzd&uWhNqI:$vbeEi\"#BJHNzijnV$AKDSOYM*+yelBEM.4Fxs@EAvW=hT?GU.DlBfL.4Fx~5AABA\";i:1831;s:14:\"9M>hT?GU}jTBEA\";i:1832;s:25:\"zd=hT?GU}jQBz(nt,ub@JB5FA\";i:1833;s:24:\"zd=hT?GUfOlB1N.4FxrjDABA\";i:1834;s:13:\"t8>hT?GU<HlBA\";i:1835;s:13:\"hg=hT?GUNElBA\";i:1836;s:13:\"hg=hT?GU.DlBA\";i:1837;s:13:\"VE=hT?GU~AlBA\";i:1838;s:13:\"sP=hT?GUDClBA\";i:1839;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4Fxs@FABA\";i:1840;s:26:\"0:=hT?GU}jWB/hjt,ub@=1NEQA\";i:1841;s:24:\"Rj?hT?GU!BlBcM.4FxrjCABA\";i:1842;s:27:\"j==hT?GUO[McXLPDVElg*NuxMtA\";i:1843;s:13:\"sP=hT?GUDClBA\";i:1844;s:95:\"zP=hT?GU(ClBAM.4FxrjCA1k=hT?GUBIlBIM.4Fxrj}B6AJt*\",ub@Vd5F6yLvSQ[zpAc4nt,ub@=1#ERtyBJHNzRmQ\"E\"A\";i:1845;s:13:\"t8=hT?GUNElBA\";i:1846;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:1847;s:125:\"fE=hT?GU~AlB1N.4FxrjfA};=hT?GU[IlBIM.4FxrjCAZ4=hT?GU!BlBQM.4Fxs@MA]9=hT?GU!BlBNN.4Fx}MfA1k@hT?GU~@`A,h((k)No`,@BJt?\",ub@JB5FA\";i:1848;s:13:\"!5=hT?GUhIlBA\";i:1849;s:57:\"ZE=hT?GU=ElBIM.4FxrjCAZ4=hT?GU!BlBQM.4FxrjCA]9=hT?GU!BlBA\";i:1850;s:26:\"u8=hT?GUGJlB7L.4FxrjYB$CQA\";i:1851;s:13:\"t8=hT?GUGJlBA\";i:1852;s:13:\"hg>hT?GU]VlBA\";i:1853;s:13:\"F0=hT?GUOBlBA\";i:1854;s:15:\"(a>hT?GUO[\"]XLA\";i:1855;s:13:\"L&=hT?GUNElBA\";i:1856;s:13:\"!5=hT?GUeRlBA\";i:1857;s:75:\"aE=hT?GU~AlB3L.4Fxrj}BTBQA/\",ub@TD5FwwLvSQ[z@H_E$AEDSOYMj<dtFBz(it,ub@FN7FA\";i:1858;s:46:\"YE=hT?GU~AlBsM.4Fx}MBAvW=hT?GUZwlB?L.4Fx~5)ABA\";i:1859;s:14:\"(a=hT?GU~@MBEA\";i:1860;s:23:\"FH=hT?GUpA$ACDSOYMM%FtA\";i:1861;s:90:\"08=hT?GU!BlBYM.4FxrjCA+h=hT?GU!BlBcM.4FxrjCA|e=hT?GU!BlBbL.4FxrjBAvW=hT?GU>BlB_M.4FxrjAABA\";i:1862;s:48:\"kg=hT?GU}j]AOc#(k)NoGE:CdZzXJI{Z`DZLjHVElg*NEBQA\";i:1863;s:13:\"t8=hT?GU!BlBA\";i:1864;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:1865;s:47:\"vP=hT?GU(ClBzL.4FxrjCA1k=hT?GU!BlBoM.4Fx}MiD6FA\";i:1866;s:13:\"t8>hT?GU<HlBA\";i:1867;s:12:\"c#>hT?GUZA$A\";i:1868;s:13:\"VE=hT?GU~AlBA\";i:1869;s:82:\"R&=hT?GUNkR@XLtJVElg*N*8Jt:C_Q3nE3UAi\"uBJHNz`auWGOqI:$vbmARtvBJHNz`auWrPqI:$vbmAQA\";i:1870;s:69:\"_2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCA[Q>hT?GU~@BBbLlt,ub@5x5FA\";i:1871;s:96:\"cE=hT?GU~AlBrL.4Fxs@CA%$=hT?GU~@YBFtit,ub@PP5FVxLvSQ[z`V1W(HqI:$vbcCi\"#BJHNzijlL$AmDSOYMj<e\"NABA\";i:1872;s:13:\"!5=hT?GU:NlBA\";i:1873;s:164:\"iE=hT?GU~AlBBN.4Fx}MhW6FfzLvSQ[z@H)E$A?CSOYM6|Bt^X_Q3nE3<AgApBJHNz#8uWlBqI:$vbKARtrBJHNzRmvWhNqI:$vbxfSK:C(XzXJI|+UACA>hT?GUcHlBoM.4Fx}MTg6Fe2LvSQ[z#31W8MqI:$vb>AQA\";i:1874;s:38:\"e#>hT?GUZA$AkDSOYM*+ZplB#L.4Fxrj}BZBQA\";i:1875;s:14:\"Qj?hT?GU~@BBEA\";i:1876;s:57:\"x8>hT?GUjClBIM.4FxrjCAZ4=hT?GUDSlBQM.4FxrjCA]9=hT?GUDSlBA\";i:1877;s:13:\"t8>hT?GUjClBA\";i:1878;s:14:\"z:=hT?GU~@BBEA\";i:1879;s:13:\"Qj?hT?GU!BlBA\";i:1880;s:24:\"ig@hT?GUlMlB?P.4Fx~5RABA\";i:1881;s:24:\"Rj@hT?GUlMlB^P.4Fx~5RABA\";i:1882;s:26:\"ig=hT?GU.DlB,L.4FxrjYBaAIA\";i:1883;s:37:\"MV=hT?GU!BlBAM.4Fx~5EAYL>hT?GUNkA^XLA\";i:1884;s:12:\"4r>hT?GUZA$A\";i:1885;s:121:\"}2=hT?GU!BlBMM.4?zrjCAq1wElBIGkc`Z(RD\"&aYC$AwBJHNz`auWQQqI:$vbmAQA*\",ub@&G5FVxLvSQ[zJA/hit,ub@&G5F#zLvSQ[zBAFtkt,ub@TD5FA\";i:1886;s:25:\"WE=hT?GU~AlB9N.4Fx}Ml:6FA\";i:1887;s:14:\"(a=hT?GU~@MBEA\";i:1888;s:24:\"tP=hT?GUDClB;L.4Fx}MRABA\";i:1889;s:23:\"S@=hT?GUZA$A;CSOYMM%CtA\";i:1890;s:34:\"T@=hT?GU5A$ADDSOYM@1Bt{e_Q3nE3wE$A\";i:1891;s:13:\"t8=hT?GUNElBA\";i:1892;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:1893;s:12:\"4r>hT?GUZA$A\";i:1894;s:121:\"}2=hT?GU!BlBMM.4?zrjCAq1wElBIGkc`Z(RD\"&aYC$AwBJHNz`auWQQqI:$vbmAQA*\",ub@&G5FVxLvSQ[zJA/hit,ub@&G5F#zLvSQ[zBAFtkt,ub@TD5FA\";i:1895;s:68:\"aE=hT?GU~AlBoM.4Fx~5MA%$=hT?GU!BlB,L.4FxrjCAw(=hT?GU!BlB(L.4FxrjCABA\";i:1896;s:15:\"(a=hT?GUNkI7XLA\";i:1897;s:23:\"S@=hT?GUZA$A;CSOYMM%CtA\";i:1898;s:34:\"T@=hT?GU5A$ADDSOYM@1Bt{e_Q3nE3wE$A\";i:1899;s:81:\"R&=hT?GUNElB,L.4Fxs@FAw(=hT?GUNElB(L.4Fxs@FANc=hT?GU~@]A,h%(k)No`,DCJt&\",ub@/B5FA\";i:1900;s:95:\"p==hT?GU}j*A]Q$(k)NoMS:CTXzXJI{ZFAln$(k)No`,qCK\"it,ub@=1bEQA.\",ub@=1`ERtqBJHNzijTR$A;CSOYMifBtA\";i:1901;s:70:\"JH>hT?GUO[UEaLvDVElg*NbAIAit,ub@nH5F$wLvSQ[zzAyWht,ub@/B5F:yLvSQ[zJAEA\";i:1902;s:69:\"mg>hT?GU]VlBoM.4Fx}MiD6FgwLvSQ[zJAFtjt,ub@&G5F$wLvSQ[zvAz(jt,ub@&G5FA\";i:1903;s:38:\"k==hT?GU~@IBc4jt,ub@ph5Fe2LvSQ[z@HkE$A\";i:1904;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:1905;s:42:\"zd=hT?IUO[$$aL#z@HZFlBiGkc`Ztz/@:Cnj}BfBgA\";i:1906;s:13:\"t8>hT?GUjClBA\";i:1907;s:14:\"EH>hT?GU~@DBEA\";i:1908;s:13:\"t8>hT?GUjClBA\";i:1909;s:34:\"XE=hT?GU]FlB3L.4Fx~5CACt@hT?GUpA$A\";i:1910;s:150:\"58@hT?GUeBlB?L.4FxrjGA%$=hT?GU:NlB,L.4Fx~5TAw(=hT?GU:NlB(L.4Fx~5TANc=hT?GUjClB1N.4Fx}MLAYL?hT?GUFMlBoQ.4Fxrj}BhBRtFCJHNz`auW^XqI:$vbxfJV:ClZzXJI|+EACA\";i:1911;s:15:\"t8>hT?GUNk5}XLA\";i:1912;s:99:\"zP?hT?GUNkD\"5FQwLvSQ[zGAG\"+(k)Noa.<CwW5*qI:$vbaU%t:CaazXJI{Z!A^9$(k)Noa.,>zWTXqI:$vbmAS\"&\",ub@/B5FA\";i:1913;s:15:\"(a>hT?GUO[\"]XLA\";i:1914;s:14:\"(a=hT?GU~@MBEA\";i:1915;s:13:\"t8>hT?GUHWlBA\";i:1916;s:85:\"yP=hT?GUDClB(L.4FxrjYBSERtlBJHNz!PuWp1qI:$vbWUZ\"*h_Q3nE3GC$AEDSOYM5qCtE0_Q3nE3H#mu5FA\";i:1917;s:13:\"VE=hT?GU~AlBA\";i:1918;s:68:\"~X=hT?GUSFlB?L.4FxrjHAHO=hT?GU(ClBzL.4FxrjCA1k=hT?GU!BlBbL.4FxrjBABA\";i:1919;s:13:\"VE>hT?GUBIlBA\";i:1920;s:25:\"0:=hT?GU~@BB:>jt,ub@0Q5FA\";i:1921;s:13:\"\"l=hT?GUNElBA\";i:1922;s:21:\"EH>hT?IU~@XB/ha.a4CtA\";i:1923;s:13:\"t8>hT?GUjClBA\";i:1924;s:68:\"_2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCA%$=hT?GUWJlBcM.4Fx}MNABA\";i:1925;s:13:\"F0=hT?GUOBlBA\";i:1926;s:48:\"|X=hT?GUNkVEYL=JVElg*NJAK\"jt,ub@N15FRtLvSQ[zFAEA\";i:1927;s:13:\"VE=hT?GU~AlBA\";i:1928;s:24:\"ig>hT?GU]VlB1N.4FxrjfABA\";i:1929;s:12:\"c#>hT?GUZA$A\";i:1930;s:26:\"j==hT?GU~@IBbLit,ub@=1zEQA\";i:1931;s:13:\"L&=hT?GUGJlBA\";i:1932;s:24:\"ig=hT?GU!BlB@M.4FxrjCABA\";i:1933;s:56:\"V@=hT?GUZA$ADDSOYM@1Btxd_Q3nE36G$A]CSOYMtOCtlB_Q3nE3mC$A\";i:1934;s:13:\"?2=hT?GU!BlBA\";i:1935;s:25:\"#5=hT?GUhIlB1N.4Fx}Mf86FA\";i:1936;s:14:\"t8>hT?GU~@$ACA\";i:1937;s:13:\"t8=hT?GUNElBA\";i:1938;s:13:\"bS=hT?GU!BlBA\";i:1939;s:69:\"n==hT?GU%IlBIM.4FxrjCAZ4=hT?GU!BlBQM.4Fxs@LA]9=hT?GU!BlBNN.4Fx}M$/6FA\";i:1940;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:1941;s:15:\"c#=hT?GUO[lBaLA\";i:1942;s:84:\"yP=hT?GU(ClB;L.4FxrjCA$T=hT?GU!BlB?L.4Fx~5CAvW=hT?GU>BlB#L.4Fxrj}BtBRt$BJHNzRm)WRABA\";i:1943;s:15:\"yd=hT?GUO[rPZLA\";i:1944;s:173:\"jE=hT?GU~AlBrL.4Fxs@DA1k=hT?GUBIlBzL.4FxrjLAq1=hT?GUNUlBUM.4Fx~5cAkn=hT?GUtElB3L.4FxrjGAD\"_Q3nE3WC$A<CSOYMtOBtGO_Q3nE3RB$AkDSOYMj<It~l_Q3nE3sohA;C>hT?GUO[&aaLPDVElg*NNKFBlBA\";i:1945;s:24:\"G0=hT?GUOBlB3L.4Fx~5CABA\";i:1946;s:13:\"nu=hT?GU>BlBA\";i:1947;s:57:\"}X=hT?GU>BlBIM.4FxrjCAZ4=hT?GU!BlBQM.4FxrjCA]9=hT?GU!BlBA\";i:1948;s:13:\"F0=hT?GUOBlBA\";i:1949;s:103:\"0P=hT?GUDClBbL.4FxrjBA%$=hT?GUNElB,L.4FxrjFAw(=hT?GUNElB(L.4FxrjFA};=hT?GU}j&AwW#(k)NomE:CjXzXJI{ZP1ZLA\";i:1950;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:1951;s:48:\"]2=hT?GUaNlBoM.4Fx}Mty6F00LvSQ[zosyW~lqI:$vb/DgA\";i:1952;s:93:\"zP=hT?GU(ClBAM.4Fxs@SA[Q=hT?GUaNlB1N.4Fx}Mf86F*xLvSQ[zaB2W&\",ub@^D5F%tLvSQ[zHAbLit,ub@y2:hFtA\";i:1953;s:13:\"sP=hT?GUDClBA\";i:1954;s:50:\"vP=hT?GUDClB(L.4Fxrj}BzBRt3BJHNzRmWAL\"xd_Q3nE3GC$A\";i:1955;s:61:\"wP=hT?GU(ClBzL.4FxrjCA1k=hT?GU!BlB?L.4Fxrj}B1BQA)\",ub@y2GtFtA\";i:1956;s:35:\"XE=hT?GU~AlB3L.4Fx~5CAkn=hT?GU>BlBA\";i:1957;s:58:\"wP=hT?GUDClBQM.4FxrjGAw(=hT?GUNElB2O.4Fx}M7o6F@wLvSQ[zJAEA\";i:1958;s:13:\"`)=hT?GUtElBA\";i:1959;s:57:\"=o=hT?GU9UlB8M.4FxrjdAvW=hT?GU9UlBIM.4Fx}MdA]9=hT?GUtUlBA\";i:1960;s:13:\"?2=hT?GU!BlBA\";i:1961;s:12:\"R@=hT?GU/A$A\";i:1962;s:58:\"P&=hT?GU!BlB,L.4Fxs@FAw(=hT?GUNElB(L.4Fxs@FA[Q>hT?GU~@BBEA\";i:1963;s:46:\"]2=hT?GU!BlBMM.4Fx~5cAI7=hT?GU!BlBUM.4Fx~5cABA\";i:1964;s:13:\"?2=hT?GUNElBA\";i:1965;s:14:\"i==hT?GU}j&ACA\";i:1966;s:26:\"ig=hT?GUO[#TYLBNVElg*N1CQA\";i:1967;s:24:\":o=hT?GU9UlB3L.4FxrjdABA\";i:1968;s:13:\"(a=hT?GUeBlBA\";i:1969;s:13:\"?2=hT?GUNUlBA\";i:1970;s:59:\"=o=hT?GUtElB3L.4Fx}MKAD\"_Q3nE3WC$AKDSOYMtOEtGO_Q3nE30oUE6FA\";i:1971;s:13:\"yd=hT?GUHWlBA\";i:1972;s:13:\"?2=hT?GUhIlBA\";i:1973;s:13:\"?2=hT?GUNElBA\";i:1974;s:36:\"v8=hT?GU.DlBcM.4Fxs@LA+h?hT?GU~@BBEA\";i:1975;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GUGJlBUM.4FxrjCABA\";i:1976;s:13:\"(a=hT?GUeBlBA\";i:1977;s:13:\"?2=hT?GUNUlBA\";i:1978;s:59:\"=o=hT?GUtElB3L.4Fx}MKAD\"_Q3nE3WC$AKDSOYMtOEtGO_Q3nE30oUE6FA\";i:1979;s:13:\"yd=hT?GUHWlBA\";i:1980;s:13:\"t8=hT?GUtElBA\";i:1981;s:46:\"YE=hT?GU~AlBrL.4Fxs@CAI7=hT?GUNElBfL.4Fx~5AABA\";i:1982;s:29:\")a>hT?GUO[\"]XLZFVElg*NNK\"ClBA\";i:1983;s:153:\"4P=hT?GU(ClBvL.4FxrjCA$T=hT?GU!BlB3L.4Fx~5CA%$=hT?GUhIlB,L.4Fxs@SAw(=hT?GUhIlB(L.4Fxs@SANc=hT?IUHWlB&!~A/Ag4nt,ub@xJ5F*xLvSQ[z`V0WWeqI:$vb<CgAmBJHNzWHuWA\";i:1984;s:13:\"t8>hT?GUjClBA\";i:1985;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:1986;s:24:\"u8>hT?GUjClB5N.4Fx~5VABA\";i:1987;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GUNElBUM.4FxrjCABA\";i:1988;s:56:\"fS>hT?GUZA$AGDSOYM@1Bt@Q_Q3nE3<AgAxBJHNz`auW(HqI:$vbmAQA\";i:1989;s:13:\"t8=hT?GUtElBA\";i:1990;s:13:\"t8=hT?GUtElBA\";i:1991;s:24:\"u8=hT?GU.DlBEM.4Fx~5BABA\";i:1992;s:13:\"t8=hT?GUNElBA\";i:1993;s:13:\"t8=hT?GU!BlBA\";i:1994;s:24:\"tP=hT?GUDClBQM.4Fx}MGABA\";i:1995;s:35:\"Yx=hT?GUhIlBvL.4Fxs@LA};=hT?GUyFlBA\";i:1996;s:13:\"VE=hT?GU~AlBA\";i:1997;s:24:\"WE=hT?GU~AlB3L.4Fx~5CABA\";i:1998;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GUGJlBUM.4FxrjCABA\";i:1999;s:14:\"i==hT?GU}j*ACA\";i:2000;s:27:\"j==hT?GU~@IBEA%(k)Noa.OcwWA\";i:2001;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:2002;s:103:\"0P=hT?GUDClBbL.4FxrjBA%$=hT?GUNElB,L.4FxrjFAw(=hT?GUNElB(L.4FxrjFA};=hT?GU}j&AwW#(k)NomE:CjXzXJI{ZP1ZLA\";i:2003;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:2004;s:48:\"]2=hT?GUaNlBoM.4Fx}Mty6F00LvSQ[zosyW~lqI:$vb/DgA\";i:2005;s:81:\"yP=hT?GU(ClBAM.4Fxs@SA[Q=hT?GUaNlBoM.4FxrjdA;C=hT?GU~AlBnL.4Fxs@BAeZ=hT?GUNksPYLA\";i:2006;s:13:\"sP=hT?GUDClBA\";i:2007;s:36:\"v8=hT?GU.DlBcM.4FxrjFA+h?hT?GU~@BBEA\";i:2008;s:13:\"t8=hT?GUNElBA\";i:2009;s:71:\"n==hT?GUO[y:ZL!GVElg*NTAK\"jt,ub@&G5F$wLvSQ[zvAz(jt,ub@&G5F00LvSQ[z)Y1WA\";i:2010;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:2011;s:13:\"L&=hT?GUNElBA\";i:2012;s:70:\"_2=hT?GU(SlBMM.4FxrjCAI7=hT?GUhIlBUM.4FxrjCA};=hT?GU~@IBc4nt,ub@=1=CQA\";i:2013;s:13:\"t8>hT?GU<HlBA\";i:2014;s:70:\"3d=hT?GU~@]A,h%(k)No`,DC3(,\",ub@N15FLvLvSQ[z;AG\"$(k)No0a:CrXzXJI|+lACA\";i:2015;s:15:\"(a>hT?GUO[\"]XLA\";i:2016;s:13:\"t8=hT?GUaNlBA\";i:2017;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:2018;s:13:\"L&=hT?GUaNlBA\";i:2019;s:90:\"{2=hT?GU#ulBMM.4Fxrj&AI7=hT?GU#ulBUM.4Fxrj&A%$=hT?GU#ulB,L.4Fxrj&Aw(=hT?GU#ulB(L.4Fxrj&ABA\";i:2020;s:39:\"0d=hT?GUNkEHXLhNVElg*NDA2W?\",ub@y2cLEtA\";i:2021;s:13:\"t8>hT?GUjClBA\";i:2022;s:67:\"_2=hT?GU!BlBMM.4FxrjCAI7=hT?GU.DlBUM.4FxrjCA,>=hT?GUZA$AVDSOYM?IBtA\";i:2023;s:70:\"~X=hT?GUNk[QYL=JVElg*NJA3(+\",ub@&G5FwwLvSQ[zVAc4jt,ub@&G5F@wLvSQ[zJAEA\";i:2024;s:67:\"rB?hT?GUZA$AVDSOYM?IBtgg_Q3nE3<AgArBJHNz`auW@QqI:$vbmARtqBJHNz`auWA\";i:2025;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:2026;s:13:\"t8=hT?GU.DlBA\";i:2027;s:13:\"?2=hT?GU.DlBA\";i:2028;s:13:\"t8=hT?GU.DlBA\";i:2029;s:70:\"_2=hT?GU(SlBMM.4FxrjCAI7=hT?GUhIlBUM.4FxrjCA};=hT?GU~@IBc4nt,ub@=1=CQA\";i:2030;s:13:\"t8>hT?GU<HlBA\";i:2031;s:13:\"L&=hT?GUaNlBA\";i:2032;s:70:\"n==hT?GU~@IBc4nt,ub@=1=CRtuBJHNz)dxWGOqI:$vbmARtvBJHNz:rvWrPqI:$vbmAQA\";i:2033;s:67:\"_2=hT?GU!BlBMM.4FxrjCAI7=hT?GU.DlBUM.4FxrjCA,>=hT?GUZA$AVDSOYM?IBtA\";i:2034;s:70:\"~X=hT?GUNk[QYL=JVElg*NJA3(,\",ub@&G5FLvLvSQ[zVAG\"$(k)NohD:CrXzXJI|+EACA\";i:2035;s:37:\"{X=hT?GUNkbSYL=JVElg*NHA3(,\",ub@&G5FA\";i:2036;s:13:\"t8=hT?GUNElBA\";i:2037;s:57:\"ZE=hT?GU~AlBIM.4FxrjCAZ4=hT?GU!BlBQM.4FxrjCA]9=hT?GU!BlBA\";i:2038;s:13:\"t8=hT?GU.DlBA\";i:2039;s:13:\"t8=hT?GU.DlBA\";i:2040;s:90:\"{2=hT?GU#ulBMM.4Fxrj&AI7=hT?GU#ulBUM.4Fxrj&A%$=hT?GU#ulB,L.4Fxrj&Aw(=hT?GU#ulB(L.4Fxrj&ABA\";i:2041;s:13:\"t8=hT?GUNElBA\";i:2042;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:2043;s:25:\"u8>hT?GU~@eB/hkt,ub@zj5FA\";i:2044;s:24:\"@2=hT?GUGJlBoM.4Fx~5NABA\";i:2045;s:26:\"#5=hT?GU}jDB/hjt,ub@=1NEQA\";i:2046;s:80:\"yP=hT?GUDClBYM.4Fxs@FA+h=hT?GUNElBcM.4Fxs@FA|e=hT?GUNElB#L.4Fx}M1a6F:yLvSQ[z+AEA\";i:2047;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GUaNlBUM.4FxrjCABA\";i:2048;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:2049;s:110:\"0P=hT?GU(ClBbL.4FxrjBA$T=hT?GUhIlBvL.4Fxrj}B%BQA)\",ub@&G5FrvLvSQ[zJA:>pt,ub@y2p_FtY4`Q3nE3H#z35F1xLvSQ[z@HDH$A\";i:2050;s:23:\"S@=hT?GU/A$ADDSOYM5qCtA\";i:2051;s:80:\"bE=hT?GU~AlBYM.4Fx~5RA+h=hT?GUlMlBcM.4Fx~5RA|e=hT?GUlMlB_M.4Fx}M7o6F:yLvSQ[zKAEA\";i:2052;s:29:\"`X=hT?GUO[DHaL_EVElg*NNK6ilBA\";i:2053;s:13:\"?2=hT?GUNElBA\";i:2054;s:12:\"R@=hT?GU/A$A\";i:2055;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:2056;s:49:\"]2=hT?GUO[dZZLi\"LvSQ[zFAc4nt,ub@=1#ERtyBJHNzu#vWA\";i:2057;s:15:\"t8>hT?GUNk_XYLA\";i:2058;s:13:\"!5=hT?GUlMlBA\";i:2059;s:13:\"t8=hT?GUtElBA\";i:2060;s:13:\"?2=hT?GU!BlBA\";i:2061;s:13:\"sP=hT?GUDClBA\";i:2062;s:90:\"{2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCA%$=hT?GU!BlB,L.4FxrjCAw(=hT?GU!BlB(L.4FxrjCABA\";i:2063;s:89:\"\"X=hT?GU>BlBKO.4Fx}MvM6F44LvSQ[z@HTH$AGDSOYMj<ttpAx(#(k)No1H:C4YzXJI|+`D7Di\"qBJHNzRmY\"M\"A\";i:2064;s:24:\"zd=hT?GUjClB_M.4FxrjCABA\";i:2065;s:218:\"oCQY(\",ub@{K5FbvLvSQ[ztAbLjt,ub@ZR5FrvLvSQ[zXAEA%(k)NoaI:CQYzXJI{ZxAwW$(k)NohD:CgYzXJI|+EA,h$(k)NohD:CMczXJI|+AAln$(k)NohD:CzXzXJI|+EADt$(k)NohD:CrXzXJI|+EA,h%(k)NohD:C`ZzXJI|+EAOc&(k)No9P:C@YzXJI|+wCYIi\"pBJHNzRmXtKABA\";i:2066;s:12:\"VE=hT?GUZA$A\";i:2067;s:12:\"KV>hT?GUZA$A\";i:2068;s:24:\"u8>hT?GUjClBfL.4Fx~5AABA\";i:2069;s:13:\"i==hT?GU4DlBA\";i:2070;s:183:\"oClB)\",ub@nH5F`xLvSQ[zBAz(lt,ub@&G5F?zLvSQ[zJAEA((k)NoyAlB1N.4Fx}MLAkn=hT?GUYDlB8M.4Fx}MQA};=hT?GU<HlBNN.4Fx}MKL6FFxLvSQ[zJAFtit,ub@PP5FVxLvSQ[zXA/hit,ub@&G5Fi6LvSQ[z@HrH$A<CSOYM)ZBtA\";i:2071;s:12:\"VE=hT?GUZA$A\";i:2072;s:12:\"VE=hT?GUZA$A\";i:2073;s:97:\"zP=hT?GU(ClBAM.4FxrjFA1k=hT?GUBIlB?L.4FxrjHAD\"_Q3nE32C$AKDSOYMj<dt\"A/hjt,ub@y2:hGty:_Q3nE3H#R95FA\";i:2074;s:194:\"oClB(\",ub@y2GtGtDH_Q3nE3hB$AADSOYM@1BtGO_Q3nE3RB$A|CSOYMu7Btgg_Q3nE36G$A{CSOYMM%Ft*h_Q3nE36G$A`CSOYMM%FtXL_Q3nE3H#2!5F1xLvSQ[z@HPD$A=CSOYMAlBtJV_Q3nE30o+>6F2uLvSQ[zJA:>nt,ub@y2b4Ft;v_Q3nE3\"!6ABA\";i:2075;s:24:\"?J=hT?GUoDlB7L.4Fxs@BABA\";i:2076;s:143:\"gE=hT?GU~AlB}M.4FxrjCA[Q>hT?GU!BlB3L.4Fx~5CANc=hT?GUNk1kYL_EVElg*NlAIAlt,ub@a!5FFxLvSQ[z@HbH$A{CSOYMifCt*h_Q3nE3H#i65F{uLvSQ[z@HjH$AQDSOYM@1BtA\";i:2077;s:12:\"VE=hT?GUZA$A\";i:2078;s:13:\"Wx=hT?GU.DlBA\";i:2079;s:35:\"Bm=hT?GU!BlBzL.4Fx~5CA<v=hT?GUYDlBA\";i:2080;s:129:\"2P=hT?GU(ClB;L.4FxrjCA$T=hT?GU!BlB?L.4Fx~5CAvW=hT?GU>BlB#L.4FxrjDApI=hT?GUOBlBnL.4FxrjYBRFRt#BJHNzijnV$A^CSOYM@1Bth=_Q3nE30oE05FA\";i:2081;s:24:\"?J=hT?GUoDlB7L.4Fxs@BABA\";i:2082;s:24:\":o=hT?GU>BlB3L.4Fx~5CABA\";i:2083;s:161:\"{o=hT?GU>BlB3L.4Fx~5CA$T>hT?GU!BlB_M.4FxrjCA};=hT?GUNk\"lYLPjVElg*NuBRt{BJHNzRmPtgAI7>hT?GU<HlBGO.4FxrjAA%$=hT?GU!BlB,L.4FxrjCAw(=hT?GU!BlB(L.4FxrjCA;C>hT?GU!BlBA\";i:2084;s:12:\"VE=hT?GUZA$A\";i:2085;s:141:\"3P=hT?GU(ClBAM.4FxrjCA1k=hT?GUBIlBIM.4Fx~5cAkn=hT?GUtElB8M.4FxrjGAI7>hT?GU<HlByO.4Fx}M?s6FE0LvSQ[z@HII$AKDSOYM@1Cts8_Q3nE3~R6A%$>hT?GUNk/oYLA\";i:2086;s:13:\"t8>hT?GUHWlBA\";i:2087;s:13:\"t8>hT?GU<HlBA\";i:2088;s:46:\"O&=hT?GU!BlB,L.4FxrjFAw(=hT?GU!BlB(L.4FxrjFABA\";i:2089;s:13:\"Wx=hT?GU.DlBA\";i:2090;s:25:\"j==hT?GU}j&AOc$(k)NoaI:CA\";i:2091;s:36:\"v8=hT?GUNElBcM.4Fxs@FA+h?hT?GU~@BBEA\";i:2092;s:57:\"m==hT?GUnWlBIM.4FxrjCAZ4=hT?GU!BlBQM.4Fxs@LA]9=hT?GU!BlBA\";i:2093;s:13:\"F0=hT?GUOBlBA\";i:2094;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:2095;s:37:\"T@=hT?GU/A$A]CSOYMj<ttjAwW$(k)NoYO:CA\";i:2096;s:82:\"4d=hT?GU~@]Aln$(k)No1H:CzXzXJI|+EADt$(k)No1H:CrXzXJI|+EAa4$(k)No`,DCK\"qt,ub@=1HEQA\";i:2097;s:36:\"k==hT?GU~@&A7F#(k)No/L:CogzXJI{ZBACA\";i:2098;s:24:\"WE=hT?GU~AlBsM.4Fx}MBABA\";i:2099;s:15:\"_X=hT?GUNkTqYLA\";i:2100;s:13:\"_X=hT?GU>BlBA\";i:2101;s:26:\"`X=hT?GUmJlBUM.4Fxrj}BVBQA\";i:2102;s:125:\"~2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCAvW=hT?GU>BlBfL.4Fx~5AA};=hT?GUNk4rYLIIVElg*N8BQA*\",ub@0Q5FVxLvSQ[z;A/hit,ub@0Q5FA\";i:2103;s:67:\"rB?hT?GUZA$AGDSOYM@1Bt@Q_Q3nE3<AgAxBJHNz`auW(HqI:$vbmAS\";\",ub@&G5FA\";i:2104;s:24:\"WE=hT?GU~AlB3L.4Fx~5&ABA\";i:2105;s:67:\"W@=hT?GUZA$A]CSOYMtOCt&a_Q3nE3<AgAvBJHNz`auW+OqI:$vbmAS\",\",ub@&G5FA\";i:2106;s:35:\"XE=hT?GU~AlB3L.4Fx~5CA;C>hT?GU!BlBA\";i:2107;s:14:\"L&>hT?GU~@ZBEA\";i:2108;s:27:\"zd=hT?GUNkEHXL6SVElg*NLKJtA\";i:2109;s:14:\"EH>hT?GU~@XBEA\";i:2110;s:13:\"t8=hT?GU!BlBA\";i:2111;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:2112;s:15:\"L&=hT?GUO[DHaLA\";i:2113;s:35:\"e#=hT?GU!BlB3L.4Fx~5CAZ4=hT?GU!BlBA\";i:2114;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:2115;s:13:\"t8=hT?GU!BlBA\";i:2116;s:13:\"?2=hT?GU!BlBA\";i:2117;s:26:\"u8=hT?GU}jDBG\"$(k)No`,GCIA\";i:2118;s:14:\"t8>hT?GU~@$ACA\";i:2119;s:13:\"sP=hT?GUDClBA\";i:2120;s:14:\"t8>hT?GU~@PBEA\";i:2121;s:24:\"u8>hT?GUjClB5N.4FxrjAABA\";i:2122;s:13:\"t8>hT?GUjClBA\";i:2123;s:15:\"`)=hT?GUO[DHaLA\";i:2124;s:102:\"dE=hT?GU~AlBIM.4FxrjCAZ4=hT?GU!BlBQM.4Fxs@FA]9=hT?GU!BlBoM.4Fx~5MAI7>hT?GUjClBNN.4Fx}MfAD\"_Q3nE3\"!gABA\";i:2125;s:13:\"t8=hT?GU#ulBA\";i:2126;s:13:\"t8>hT?GUjClBA\";i:2127;s:21:\"EH>hT?IU~@XB/ha.a4CtA\";i:2128;s:40:\"0d=hT?GUO[$$aL6SVElg*N5gOt~l_Q3nE3t`xABA\";i:2129;s:14:\"t8>hT?GU~@PBEA\";i:2130;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:2131;s:35:\"uP=hT?GUDClBYM.4Fxs@FAw(=hT?GUNElBA\";i:2132;s:37:\"XE=hT?GU]FlBQQ.4FxrjYBPFRtCCJHNzWHuWA\";i:2133;s:13:\"VE=hT?GU~AlBA\";i:2134;s:14:\"t8>hT?GU~@eBEA\";i:2135;s:24:\"u8>hT?GUjClB5N.4FxrjAABA\";i:2136;s:13:\"!5=hT?GUYDlBA\";i:2137;s:46:\"]2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCABA\";i:2138;s:13:\"c#=hT?GUYDlBA\";i:2139;s:13:\"L&=hT?GUWJlBA\";i:2140;s:56:\"8r>hT?GUZA$ACDSOYM@1BtMc_Q3nE3<Ai\"vBJHNz`auWrPqI:$vbmAQA\";i:2141;s:23:\"S@=hT?GU/A$AFDSOYM5qCtA\";i:2142;s:13:\"c#=hT?GU!BlBA\";i:2143;s:15:\"!5=hT?GUO[lBaLA\";i:2144;s:67:\"W@=hT?GUZA$ACDSOYM@1BtMc_Q3nE3wE$AEDSOYM@1Bt{e_Q3nE3wE$A;CSOYMM%CtA\";i:2145;s:12:\"R@=hT?GU5A$A\";i:2146;s:24:\"tP=hT?GUDClBnL.4Fx}MDABA\";i:2147;s:24:\"?J=hT?GUoDlB7L.4Fxs@BABA\";i:2148;s:15:\"_X>hT?GUNkZ4XLA\";i:2149;s:80:\"\"X>hT?GU~@?A^9%(k)No$W:CSazXJI{ZgAwW*(k)No$W:CNhzXJI{ZJA8y&(k)No)q:C3bzXJI{Z9ACA\";i:2150;s:92:\"cE=hT?GU=ElBNN.4Fx}MQANc>hT?GUgLlBBN.4Fxrj}BKCRtyBJHNzijvWJ`qI:$vb:ARt%BJHNz{,xW.oqI:$vbjFgA\";i:2151;s:42:\"k==hT?GUNknuYLXLVElg*N+PVRlBFN.4Fxrj}BQCQA\";i:2152;s:15:\"i==hT?GUNk7yYLA\";i:2153;s:14:\"i==hT?GU~@+ACA\";i:2154;s:15:\"i==hT?GUNkF0YLA\";i:2155;s:15:\"i==hT?GUNkq1YLA\";i:2156;s:26:\"`X=hT?GUNk?2YL&\"LvSQ[zCAEA\";i:2157;s:37:\"jg=hT?GU!BlBUM.4Fxrj}BaCS\"DByD1+TCXLA\";i:2158;s:13:\"sP=hT?GUDClBA\";i:2159;s:64:\"wP=hT?GU(ClBzL.4Fxrj}BcCQA)\",ub@y2GtHtaS_Q3nE3H#y:5FhtLvSQ[zCAEA\";i:2160;s:15:\"KV=hT?GUNkt8YLA\";i:2161;s:83:\"Q&=hT?GUNk]9YLUEVElg*N+PPTlBcM.4Fxrj}BmCRtqBJHNzRm)WbA[Q>hT?GUNkL&YL3LVElg*N+P#TlBA\";i:2162;s:12:\"R@=hT?GU/A$A\";i:2163;s:12:\"R@=hT?GU5A$A\";i:2164;s:15:\"!5=hT?GUNk`)YLA\";i:2165;s:15:\"c#=hT?GUNk`)YLA\";i:2166;s:12:\"R@=hT?GU5A$A\";i:2167;s:12:\"R@=hT?GU/A$A\";i:2168;s:15:\"!5=hT?GUNk`)YLA\";i:2169;s:15:\"c#=hT?GUNk`)YLA\";i:2170;s:29:\"j=@hT?GUNkf+YL3rVElg*N+PEUlBA\";i:2171;s:29:\"j=@hT?GUNk),YL3rVElg*N+PUUlBA\";i:2172;s:29:\"FH@hT?GUNkO/YLyKVElg*N+PqClBA\";i:2173;s:29:\"FH@hT?GUNkz:YLyKVElg*NNK(nlBA\";i:2174;s:29:\"FH@hT?GUNk};YLyKVElg*N+P_UlBA\";i:2175;s:29:\"FH@hT?GUNk,>YLyKVElg*N+PZVlBA\";i:2176;s:29:\"FH@hT?GUNk2[YLyKVElg*N+P5VlBA\";i:2177;s:12:\"),?hT?GUZA$A\";i:2178;s:77:\"xP=hT?GUDClBbL.4Fxs@GAvW=hT?GUNk7yYL_EVElg*N+P1RlB8M.4Fxrj}BSCRt5BJHNzRmOAS\"A\";i:2179;s:46:\"vP=hT?GU(ClBzL.4FxrjCAvW=hT?GU>BlBfL.4Fx~5AABA\";i:2180;s:13:\"mB>hT?GU<HlBA\";i:2181;s:15:\"i==hT?GUNk7yYLA\";i:2182;s:13:\"t8>hT?GUjClBA\";i:2183;s:15:\"9M>hT?GUNkl_YLA\";i:2184;s:15:\"9M>hT?GUNk:`YLA\";i:2185;s:15:\"9M>hT?GUNkU|YLA\";i:2186;s:15:\"9M>hT?GUNk5}YLA\";i:2187;s:15:\"9M>hT?GUNkBA6FA\";i:2188;s:15:\"9M>hT?GUNkmBZLA\";i:2189;s:15:\"9M>hT?GUNk;CZLA\";i:2190;s:15:\"9M>hT?GUNkVEZLA\";i:2191;s:15:\"9M>hT?GUNk6FZLA\";i:2192;s:15:\"9M>hT?GUNkEHZLA\";i:2193;s:15:\"9M>hT?GUNkpIZLA\";i:2194;s:15:\"9M>hT?GUNk>JZLA\";i:2195;s:14:\"9M>hT?GU}j@ACA\";i:2196;s:15:\"9M>hT?GUNkYLZLA\";i:2197;s:15:\"9M>hT?GUNk9MZLA\";i:2198;s:15:\"9M>hT?GUNkHOZLA\";i:2199;s:15:\"9M>hT?GUNksPZLA\";i:2200;s:15:\"9M>hT?GUNk[QZLA\";i:2201;s:15:\"9M>hT?GUNkbSZLA\";i:2202;s:15:\"9M>hT?GUNk$TZLA\";i:2203;s:15:\"9M>hT?GUNkKVZLA\";i:2204;s:15:\"9M>hT?GUNkc#XLA\";i:2205;s:15:\"9M>hT?GUNkvWZLA\";i:2206;s:15:\"9M>hT?GUNk_XZLA\";i:2207;s:15:\"9M>hT?GUNkeZZLA\";i:2208;s:15:\"9M>hT?GUNk(aZLA\";i:2209;s:15:\"9M>hT?GUNkNcZLA\";i:2210;s:15:\"9M>hT?GUNkydZLA\";i:2211;s:15:\"9M>hT?GUNk|eZLA\";i:2212;s:15:\"9M>hT?GUNkhgZLA\";i:2213;s:15:\"9M>hT?GUNk+hZLA\";i:2214;s:15:\"9M>hT?GUNkQjZLA\";i:2215;s:15:\"9M>hT?GUNk1kZLA\";i:2216;s:15:\"9M>hT?GUNk\"lZLA\";i:2217;s:15:\"9M>hT?GUNkknZLA\";i:2218;s:15:\"9M>hT?GUNk/oZLA\";i:2219;s:15:\"9M>hT?GUNkTqZLA\";i:2220;s:15:\"9M>hT?GUNk4rZLA\";i:2221;s:15:\"9M>hT?GUNkCtZLA\";i:2222;s:15:\"9M>hT?GUNknuZLA\";i:2223;s:15:\"9M>hT?GUNk<vZLA\";i:2224;s:15:\"9M>hT?GUNkWxZLA\";i:2225;s:15:\"9M>hT?GUNk7yZLA\";i:2226;s:15:\"9M>hT?GUNkF0ZLA\";i:2227;s:15:\"9M>hT?GUNkq1ZLA\";i:2228;s:15:\"9M>hT?GUNk?2ZLA\";i:2229;s:15:\"9M>hT?GUNkZ4ZLA\";i:2230;s:15:\"9M>hT?GUNk!5ZLA\";i:2231;s:15:\"9M>hT?GUNkI7ZLA\";i:2232;s:15:\"9M>hT?GUNkt8ZLA\";i:2233;s:15:\"9M>hT?GUNk]9ZLA\";i:2234;s:15:\"9M>hT?GUNkc#ZLA\";i:2235;s:15:\"9M>hT?GUNk%$ZLA\";i:2236;s:15:\"9M>hT?GUNkL&ZLA\";i:2237;s:15:\"9M>hT?GUNkw(ZLA\";i:2238;s:15:\"9M>hT?GUNk`)ZLA\";i:2239;s:15:\"9M>hT?GUNkf+ZLA\";i:2240;s:15:\"9M>hT?GUNk),ZLA\";i:2241;s:15:\"9M>hT?GUNkO/ZLA\";i:2242;s:15:\"9M>hT?GUNkz:ZLA\";i:2243;s:15:\"9M>hT?GUNk};ZLA\";i:2244;s:15:\"9M>hT?GUNki=ZLA\";i:2245;s:15:\"9M>hT?GUNk,>ZLA\";i:2246;s:15:\"9M>hT?GUNkR@ZLA\";i:2247;s:15:\"9M>hT?GUNk2[ZLA\";i:2248;s:15:\"9M>hT?GUNkA^ZLA\";i:2249;s:15:\"9M>hT?GUNkl_ZLA\";i:2250;s:15:\"9M>hT?GUNk:`ZLA\";i:2251;s:15:\"9M>hT?GUNkU|ZLA\";i:2252;s:15:\"9M>hT?GUNk5}ZLA\";i:2253;s:15:\"9M>hT?GUNkD\"6FA\";i:2254;s:15:\"9M>hT?GUNkmBaLA\";i:2255;s:15:\"9M>hT?GUNk;CaLA\";i:2256;s:15:\"9M>hT?GUNkVEaLA\";i:2257;s:15:\"9M>hT?GUNk6FaLA\";i:2258;s:15:\"9M>hT?GUNkEHaLA\";i:2259;s:15:\"9M>hT?GUNkpIaLA\";i:2260;s:15:\"9M>hT?GUNk>JaLA\";i:2261;s:15:\"9M>hT?GUNkA^XLA\";i:2262;s:15:\"9M>hT?GUNk};XLA\";i:2263;s:15:\"9M>hT?GUNkYLaLA\";i:2264;s:15:\"9M>hT?GUNk9MaLA\";i:2265;s:15:\"9M>hT?GUNkHOaLA\";i:2266;s:15:\"9M>hT?GUNksPaLA\";i:2267;s:15:\"9M>hT?GUNk[QaLA\";i:2268;s:15:\"9M>hT?GUNkbSaLA\";i:2269;s:15:\"9M>hT?GUNk$TaLA\";i:2270;s:15:\"9M>hT?GUNkKVaLA\";i:2271;s:15:\"9M>hT?GUNkvWaLA\";i:2272;s:15:\"9M>hT?GUNk_XaLA\";i:2273;s:15:\"9M>hT?GUNkeZaLA\";i:2274;s:15:\"9M>hT?GUNk(aaLA\";i:2275;s:15:\"9M>hT?GUNkNcaLA\";i:2276;s:15:\"9M>hT?GUNkydaLA\";i:2277;s:15:\"9M>hT?GUNk|eaLA\";i:2278;s:15:\"9M>hT?GUNkhgaLA\";i:2279;s:15:\"9M>hT?GUNk+haLA\";i:2280;s:15:\"9M>hT?GUNkQjaLA\";i:2281;s:15:\"9M>hT?GUNk1kaLA\";i:2282;s:15:\"9M>hT?GUNk\"laLA\";i:2283;s:15:\"9M>hT?GUNkknaLA\";i:2284;s:15:\"9M>hT?GUNk/oaLA\";i:2285;s:15:\"9M>hT?GUNkTqaLA\";i:2286;s:15:\"9M>hT?GUNk4raLA\";i:2287;s:15:\"9M>hT?GUNkCtaLA\";i:2288;s:15:\"9M>hT?GUNknuaLA\";i:2289;s:15:\"9M>hT?GUNk<vaLA\";i:2290;s:15:\"9M>hT?GUNkWxaLA\";i:2291;s:15:\"9M>hT?GUNk7yaLA\";i:2292;s:15:\"9M>hT?GUNkF0aLA\";i:2293;s:15:\"9M>hT?GUNkq1aLA\";i:2294;s:15:\"9M>hT?GUNk?2aLA\";i:2295;s:15:\"9M>hT?GUNkZ4aLA\";i:2296;s:14:\"9M>hT?GU}jTBEA\";i:2297;s:15:\"9M>hT?GUNk!5aLA\";i:2298;s:15:\"9M>hT?GUNkI7aLA\";i:2299;s:15:\"9M>hT?GUNkt8aLA\";i:2300;s:15:\"9M>hT?GUNk]9aLA\";i:2301;s:15:\"9M>hT?GUNkc#aLA\";i:2302;s:15:\"9M>hT?GUNk%$aLA\";i:2303;s:15:\"9M>hT?GUNkL&aLA\";i:2304;s:15:\"9M>hT?GUNkw(aLA\";i:2305;s:15:\"9M>hT?GUNk`)aLA\";i:2306;s:15:\"9M>hT?GUNkf+aLA\";i:2307;s:15:\"9M>hT?GUNk),aLA\";i:2308;s:15:\"9M>hT?GUNkO/aLA\";i:2309;s:15:\"9M>hT?GUNkz:aLA\";i:2310;s:15:\"9M>hT?GUNk};aLA\";i:2311;s:15:\"9M>hT?GUNki=aLA\";i:2312;s:15:\"9M>hT?GUNk,>aLA\";i:2313;s:15:\"9M>hT?GUNkR@aLA\";i:2314;s:15:\"9M>hT?GUNk2[aLA\";i:2315;s:15:\"9M>hT?GUNkA^aLA\";i:2316;s:15:\"9M>hT?GUNkl_aLA\";i:2317;s:15:\"9M>hT?GUNk:`aLA\";i:2318;s:15:\"9M>hT?GUNkU|aLA\";i:2319;s:15:\"9M>hT?GUNk5}aLA\";i:2320;s:15:\"9M>hT?GUO[BA5FA\";i:2321;s:15:\"9M>hT?GUO[mBXLA\";i:2322;s:15:\"9M>hT?GUO[;CXLA\";i:2323;s:15:\"9M>hT?GUO[VEXLA\";i:2324;s:15:\"9M>hT?GUO[6FXLA\";i:2325;s:15:\"9M>hT?GUO[EHXLA\";i:2326;s:15:\"9M>hT?GUO[pIXLA\";i:2327;s:15:\"9M>hT?GUO[>JXLA\";i:2328;s:15:\"9M>hT?GUO[YLXLA\";i:2329;s:15:\"9M>hT?GUO[9MXLA\";i:2330;s:15:\"9M>hT?GUO[HOXLA\";i:2331;s:15:\"9M>hT?GUO[sPXLA\";i:2332;s:15:\"9M>hT?GUO[[QXLA\";i:2333;s:15:\"9M>hT?GUO[bSXLA\";i:2334;s:15:\"9M>hT?GUO[$TXLA\";i:2335;s:15:\"9M>hT?GUO[KVXLA\";i:2336;s:15:\"9M>hT?GUO[vWXLA\";i:2337;s:15:\"9M>hT?GUO[_XXLA\";i:2338;s:15:\"9M>hT?GUO[eZXLA\";i:2339;s:15:\"9M>hT?GUO[(aXLA\";i:2340;s:15:\"9M>hT?GUO[NcXLA\";i:2341;s:15:\"9M>hT?GUO[e+ZLA\";i:2342;s:15:\"9M>hT?GUO[(,ZLA\";i:2343;s:15:\"9M>hT?GUO[ydXLA\";i:2344;s:15:\"9M>hT?GUO[|eXLA\";i:2345;s:15:\"9M>hT?GUO[hgXLA\";i:2346;s:15:\"9M>hT?GUO[+hXLA\";i:2347;s:15:\"9M>hT?GUO[QjXLA\";i:2348;s:15:\"9M>hT?GUO[1kXLA\";i:2349;s:15:\"9M>hT?GUO[\"lXLA\";i:2350;s:15:\"9M>hT?GUO[knXLA\";i:2351;s:15:\"9M>hT?GUO[/oXLA\";i:2352;s:15:\"9M>hT?GUO[TqXLA\";i:2353;s:15:\"9M>hT?GUO[4rXLA\";i:2354;s:15:\"9M>hT?GUO[CtXLA\";i:2355;s:15:\"9M>hT?GUO[nuXLA\";i:2356;s:15:\"9M>hT?GUO[<vXLA\";i:2357;s:15:\"9M>hT?GUO[WxXLA\";i:2358;s:15:\"9M>hT?GUO[7yXLA\";i:2359;s:15:\"9M>hT?GUO[F0XLA\";i:2360;s:15:\"9M>hT?GUO[q1XLA\";i:2361;s:15:\"9M>hT?GUO[?2XLA\";i:2362;s:15:\"9M>hT?GUO[Z4XLA\";i:2363;s:15:\"9M>hT?GUO[!5XLA\";i:2364;s:15:\"9M>hT?GUO[I7XLA\";i:2365;s:15:\"9M>hT?GUO[t8XLA\";i:2366;s:15:\"9M>hT?GUO[]9XLA\";i:2367;s:15:\"9M>hT?GUO[c#XLA\";i:2368;s:15:\"9M>hT?GUO[%$XLA\";i:2369;s:15:\"9M>hT?GUO[L&XLA\";i:2370;s:15:\"9M>hT?GUO[w(XLA\";i:2371;s:15:\"9M>hT?GUO[`)XLA\";i:2372;s:15:\"9M>hT?GUO[f+XLA\";i:2373;s:15:\"9M>hT?GUO[),XLA\";i:2374;s:15:\"9M>hT?GUO[O/XLA\";i:2375;s:15:\"9M>hT?GUO[z:XLA\";i:2376;s:15:\"9M>hT?GUNkw(XLA\";i:2377;s:15:\"9M>hT?GUO[};XLA\";i:2378;s:15:\"9M>hT?GUO[i=XLA\";i:2379;s:15:\"9M>hT?GUO[,>XLA\";i:2380;s:15:\"9M>hT?GUO[R@XLA\";i:2381;s:15:\"9M>hT?GUO[2[XLA\";i:2382;s:15:\"9M>hT?GUO[A^XLA\";i:2383;s:15:\"9M>hT?GUO[l_XLA\";i:2384;s:15:\"9M>hT?GUO[:`XLA\";i:2385;s:15:\"9M>hT?GUO[U|XLA\";i:2386;s:15:\"9M>hT?GUNkL&XLA\";i:2387;s:15:\"9M>hT?GUO[5}XLA\";i:2388;s:15:\"9M>hT?GUO[D\"5FA\";i:2389;s:15:\"9M>hT?GUO[mBYLA\";i:2390;s:15:\"9M>hT?GUO[;CYLA\";i:2391;s:15:\"9M>hT?GUO[VEYLA\";i:2392;s:15:\"9M>hT?GUO[6FYLA\";i:2393;s:15:\"9M>hT?GUO[EHYLA\";i:2394;s:15:\"9M>hT?GUO[pIYLA\";i:2395;s:15:\"9M>hT?GUO[>JYLA\";i:2396;s:15:\"9M>hT?GUO[YLYLA\";i:2397;s:15:\"9M>hT?GUO[9MYLA\";i:2398;s:15:\"9M>hT?GUO[HOYLA\";i:2399;s:15:\"9M>hT?GUO[sPYLA\";i:2400;s:15:\"9M>hT?GUO[[QYLA\";i:2401;s:15:\"9M>hT?GUO[bSYLA\";i:2402;s:15:\"9M>hT?GUNk%$XLA\";i:2403;s:15:\"9M>hT?GUO[$TYLA\";i:2404;s:15:\"9M>hT?GUO[KVYLA\";i:2405;s:15:\"9M>hT?GUO[vWYLA\";i:2406;s:15:\"9M>hT?GUO[_XYLA\";i:2407;s:15:\"9M>hT?GUO[eZYLA\";i:2408;s:15:\"9M>hT?GUO[(aYLA\";i:2409;s:15:\"9M>hT?GUO[NcYLA\";i:2410;s:15:\"9M>hT?GUO[ydYLA\";i:2411;s:15:\"9M>hT?GUO[|eYLA\";i:2412;s:15:\"9M>hT?GUO[hgYLA\";i:2413;s:15:\"9M>hT?GUO[+hYLA\";i:2414;s:15:\"9M>hT?GUO[QjYLA\";i:2415;s:13:\"9M>hT?GU|GlBA\";i:2416;s:15:\"9M>hT?GUO[s8ZLA\";i:2417;s:15:\"9M>hT?GUO[1kYLA\";i:2418;s:15:\"9M>hT?GUO[\"lYLA\";i:2419;s:15:\"9M>hT?GUO[knYLA\";i:2420;s:15:\"9M>hT?GUO[/oYLA\";i:2421;s:15:\"9M>hT?GUO[TqYLA\";i:2422;s:15:\"9M>hT?GUO[4rYLA\";i:2423;s:15:\"9M>hT?GUO[CtYLA\";i:2424;s:15:\"9M>hT?GUO[nuYLA\";i:2425;s:15:\"9M>hT?GUO[<vYLA\";i:2426;s:15:\"9M>hT?GUO[WxYLA\";i:2427;s:15:\"9M>hT?GUO[7yYLA\";i:2428;s:15:\"9M>hT?GUO[F0YLA\";i:2429;s:15:\"9M>hT?GUO[q1YLA\";i:2430;s:15:\"9M>hT?GUNk`)XLA\";i:2431;s:15:\"9M>hT?GUO[?2YLA\";i:2432;s:15:\"9M>hT?GUO[Z4YLA\";i:2433;s:15:\"9M>hT?GUO[!5YLA\";i:2434;s:15:\"9M>hT?GUO[I7YLA\";i:2435;s:15:\"9M>hT?GUO[t8YLA\";i:2436;s:15:\"9M>hT?GUO[]9YLA\";i:2437;s:15:\"9M>hT?GUO[c#YLA\";i:2438;s:15:\"9M>hT?GUO[%$YLA\";i:2439;s:15:\"9M>hT?GUO[L&YLA\";i:2440;s:15:\"9M>hT?GUO[w(YLA\";i:2441;s:15:\"9M>hT?GUO[`)YLA\";i:2442;s:15:\"9M>hT?GUO[f+YLA\";i:2443;s:15:\"9M>hT?GUO[),YLA\";i:2444;s:15:\"9M>hT?GUO[O/YLA\";i:2445;s:15:\"9M>hT?GUO[z:YLA\";i:2446;s:15:\"9M>hT?GUO[};YLA\";i:2447;s:15:\"9M>hT?GUO[i=YLA\";i:2448;s:15:\"9M>hT?GUO[,>YLA\";i:2449;s:15:\"9M>hT?GUO[R@YLA\";i:2450;s:15:\"9M>hT?GUO[2[YLA\";i:2451;s:15:\"9M>hT?GUO[A^YLA\";i:2452;s:15:\"9M>hT?GUO[l_YLA\";i:2453;s:15:\"9M>hT?GUO[:`YLA\";i:2454;s:15:\"9M>hT?GUO[U|YLA\";i:2455;s:15:\"9M>hT?GUO[5}YLA\";i:2456;s:15:\"9M>hT?GUO[BA6FA\";i:2457;s:15:\"9M>hT?GUO[mBZLA\";i:2458;s:15:\"9M>hT?GUO[;CZLA\";i:2459;s:15:\"9M>hT?GUO[VEZLA\";i:2460;s:15:\"9M>hT?GUO[6FZLA\";i:2461;s:15:\"9M>hT?GUO[EHZLA\";i:2462;s:15:\"9M>hT?GUO[pIZLA\";i:2463;s:15:\"9M>hT?GUO[>JZLA\";i:2464;s:15:\"9M>hT?GUO[YLZLA\";i:2465;s:15:\"9M>hT?GUO[9MZLA\";i:2466;s:15:\"9M>hT?GUO[HOZLA\";i:2467;s:15:\"9M>hT?GUO[sPZLA\";i:2468;s:15:\"9M>hT?GUO[[QZLA\";i:2469;s:15:\"9M>hT?GUO[bSZLA\";i:2470;s:15:\"9M>hT?GUO[$TZLA\";i:2471;s:15:\"9M>hT?GUO[KVZLA\";i:2472;s:15:\"9M>hT?GUO[vWZLA\";i:2473;s:15:\"9M>hT?GUO[_XZLA\";i:2474;s:15:\"9M>hT?GUO[eZZLA\";i:2475;s:15:\"9M>hT?GUO[(aZLA\";i:2476;s:15:\"9M>hT?GUO[NcZLA\";i:2477;s:15:\"9M>hT?GUO[ydZLA\";i:2478;s:15:\"9M>hT?GUO[|eZLA\";i:2479;s:15:\"9M>hT?GUO[hgZLA\";i:2480;s:15:\"9M>hT?GUO[+hZLA\";i:2481;s:15:\"9M>hT?GUO[QjZLA\";i:2482;s:15:\"9M>hT?GUO[1kZLA\";i:2483;s:15:\"9M>hT?GUO[\"lZLA\";i:2484;s:15:\"9M>hT?GUO[knZLA\";i:2485;s:15:\"9M>hT?GUO[/oZLA\";i:2486;s:15:\"9M>hT?GUO[TqZLA\";i:2487;s:15:\"9M>hT?GUO[4rZLA\";i:2488;s:15:\"9M>hT?GUO[CtZLA\";i:2489;s:15:\"9M>hT?GUO[nuZLA\";i:2490;s:15:\"9M>hT?GUO[<vZLA\";i:2491;s:15:\"9M>hT?GUO[WxZLA\";i:2492;s:15:\"9M>hT?GUO[7yZLA\";i:2493;s:15:\"9M>hT?GUO[F0ZLA\";i:2494;s:15:\"9M>hT?GUO[q1ZLA\";i:2495;s:15:\"9M>hT?GUO[?2ZLA\";i:2496;s:15:\"9M>hT?GUO[Z4ZLA\";i:2497;s:15:\"9M>hT?GUO[!5ZLA\";i:2498;s:15:\"9M>hT?GUO[I7ZLA\";i:2499;s:15:\"9M>hT?GUO[t8ZLA\";i:2500;s:15:\"9M>hT?GUO[]9ZLA\";i:2501;s:15:\"9M>hT?GUO[c#ZLA\";i:2502;s:15:\"9M>hT?GUO[%$ZLA\";i:2503;s:15:\"9M>hT?GUO[L&ZLA\";i:2504;s:15:\"9M>hT?GUO[w(ZLA\";i:2505;s:15:\"9M>hT?GUO[`)ZLA\";i:2506;s:15:\"9M>hT?GUO[f+ZLA\";i:2507;s:15:\"9M>hT?GUO[),ZLA\";i:2508;s:15:\"9M>hT?GUO[O/ZLA\";i:2509;s:15:\"9M>hT?GUO[z:ZLA\";i:2510;s:15:\"9M>hT?GUO[};ZLA\";i:2511;s:15:\"9M>hT?GUO[i=ZLA\";i:2512;s:15:\"9M>hT?GUO[,>ZLA\";i:2513;s:15:\"9M>hT?GUO[R@ZLA\";i:2514;s:15:\"9M>hT?GUO[2[ZLA\";i:2515;s:15:\"9M>hT?GUO[A^ZLA\";i:2516;s:15:\"9M>hT?GUO[l_ZLA\";i:2517;s:15:\"9M>hT?GUO[:`ZLA\";i:2518;s:15:\"9M>hT?GUO[U|ZLA\";i:2519;s:15:\"9M>hT?GUO[5}ZLA\";i:2520;s:15:\"9M>hT?GUO[D\"6FA\";i:2521;s:15:\"9M>hT?GUO[mBaLA\";i:2522;s:15:\"9M>hT?GUO[;CaLA\";i:2523;s:15:\"9M>hT?GUO[VEaLA\";i:2524;s:15:\"9M>hT?GUO[6FaLA\";i:2525;s:15:\"9M>hT?GUO[EHaLA\";i:2526;s:15:\"9M>hT?GUO[pIaLA\";i:2527;s:15:\"9M>hT?GUO[>JaLA\";i:2528;s:15:\"9M>hT?GUO[YLaLA\";i:2529;s:15:\"9M>hT?GUO[9MaLA\";i:2530;s:15:\"9M>hT?GUO[HOaLA\";i:2531;s:15:\"9M>hT?GUO[sPaLA\";i:2532;s:15:\"9M>hT?GUO[[QaLA\";i:2533;s:15:\"9M>hT?GUO[bSaLA\";i:2534;s:15:\"9M>hT?GUO[$TaLA\";i:2535;s:15:\"9M>hT?GUO[KVaLA\";i:2536;s:15:\"9M>hT?GUO[vWaLA\";i:2537;s:15:\"9M>hT?GUO[_XaLA\";i:2538;s:15:\"9M>hT?GUO[eZaLA\";i:2539;s:15:\"9M>hT?GUO[(aaLA\";i:2540;s:15:\"9M>hT?GUO[NcaLA\";i:2541;s:15:\"9M>hT?GUO[ydaLA\";i:2542;s:15:\"9M>hT?GUO[|eaLA\";i:2543;s:15:\"9M>hT?GUO[hgaLA\";i:2544;s:15:\"9M>hT?GUO[+haLA\";i:2545;s:15:\"9M>hT?GUO[QjaLA\";i:2546;s:15:\"9M>hT?GUO[1kaLA\";i:2547;s:15:\"9M>hT?GUO[\"laLA\";i:2548;s:15:\"9M>hT?GUO[knaLA\";i:2549;s:15:\"9M>hT?GUO[/oaLA\";i:2550;s:15:\"9M>hT?GUO[TqaLA\";i:2551;s:15:\"9M>hT?GUO[4raLA\";i:2552;s:15:\"9M>hT?GUO[CtaLA\";i:2553;s:15:\"9M>hT?GUO[nuaLA\";i:2554;s:15:\"9M>hT?GUO[<vaLA\";i:2555;s:15:\"9M>hT?GUO[WxaLA\";i:2556;s:15:\"9M>hT?GUO[7yaLA\";i:2557;s:15:\"9M>hT?GUO[F0aLA\";i:2558;s:15:\"9M>hT?GUO[q1aLA\";i:2559;s:15:\"9M>hT?GUO[?2aLA\";i:2560;s:15:\"9M>hT?GUO[Z4aLA\";i:2561;s:15:\"9M>hT?GUO[!5aLA\";i:2562;s:15:\"9M>hT?GUO[I7aLA\";i:2563;s:15:\"9M>hT?GUO[t8aLA\";i:2564;s:15:\"9M>hT?GUO[]9aLA\";i:2565;s:15:\"9M>hT?GUO[c#aLA\";i:2566;s:15:\"9M>hT?GUO[%$aLA\";i:2567;s:15:\"9M>hT?GUO[L&aLA\";i:2568;s:15:\"9M>hT?GUO[w(aLA\";i:2569;s:15:\"9M>hT?GUO[`)aLA\";i:2570;s:15:\"9M>hT?GUO[f+aLA\";i:2571;s:15:\"9M>hT?GUO[),aLA\";i:2572;s:15:\"9M>hT?GUO[O/aLA\";i:2573;s:15:\"9M>hT?GUO[z:aLA\";i:2574;s:15:\"9M>hT?GUO[};aLA\";i:2575;s:15:\"9M>hT?GUO[i=aLA\";i:2576;s:15:\"9M>hT?GUO[,>aLA\";i:2577;s:15:\"9M>hT?GUO[R@aLA\";i:2578;s:15:\"9M>hT?GUO[2[aLA\";i:2579;s:15:\"9M>hT?GUO[A^aLA\";i:2580;s:15:\"9M>hT?GUO[l_aLA\";i:2581;s:15:\"9M>hT?GUO[:`aLA\";i:2582;s:15:\"9M>hT?GUO[U|aLA\";i:2583;s:15:\"9M>hT?GUO[5}aLA\";i:2584;s:15:\"9M>hT?GUNkCA5FA\";i:2585;s:15:\"9M>hT?GUNknBXLA\";i:2586;s:15:\"9M>hT?GUNk<CXLA\";i:2587;s:15:\"9M>hT?GUNkWEXLA\";i:2588;s:15:\"9M>hT?GUNk7FXLA\";i:2589;s:15:\"9M>hT?GUNkFHXLA\";i:2590;s:15:\"9M>hT?GUNkqIXLA\";i:2591;s:15:\"9M>hT?GUNk?JXLA\";i:2592;s:15:\"9M>hT?GUNkZLXLA\";i:2593;s:15:\"9M>hT?GUNk!MXLA\";i:2594;s:15:\"9M>hT?GUNkIOXLA\";i:2595;s:15:\"9M>hT?GUNktPXLA\";i:2596;s:15:\"9M>hT?GUNk]QXLA\";i:2597;s:15:\"9M>hT?GUNkcSXLA\";i:2598;s:15:\"9M>hT?GUNk%TXLA\";i:2599;s:15:\"9M>hT?GUNkLVXLA\";i:2600;s:15:\"9M>hT?GUNkwWXLA\";i:2601;s:15:\"9M>hT?GUNk`XXLA\";i:2602;s:15:\"9M>hT?GUNkfZXLA\";i:2603;s:15:\"9M>hT?GUNk)aXLA\";i:2604;s:15:\"9M>hT?GUNkOcXLA\";i:2605;s:15:\"9M>hT?GUNkzdXLA\";i:2606;s:15:\"9M>hT?GUNk}eXLA\";i:2607;s:15:\"9M>hT?GUNkigXLA\";i:2608;s:15:\"9M>hT?GUNk,hXLA\";i:2609;s:15:\"9M>hT?GUNkRjXLA\";i:2610;s:15:\"9M>hT?GUNk2kXLA\";i:2611;s:15:\"9M>hT?GUNkAmXLA\";i:2612;s:15:\"9M>hT?GUNklnXLA\";i:2613;s:15:\"9M>hT?GUNk:oXLA\";i:2614;s:15:\"9M>hT?GUNkUqXLA\";i:2615;s:15:\"9M>hT?GUNk5rXLA\";i:2616;s:15:\"9M>hT?GUNkDtXLA\";i:2617;s:15:\"9M>hT?GUNkouXLA\";i:2618;s:15:\"9M>hT?GUNk=vXLA\";i:2619;s:15:\"9M>hT?GUNkXxXLA\";i:2620;s:15:\"9M>hT?GUNk8yXLA\";i:2621;s:15:\"9M>hT?GUNkG0XLA\";i:2622;s:15:\"9M>hT?GUNkr1XLA\";i:2623;s:15:\"9M>hT?GUNk@2XLA\";i:2624;s:15:\"9M>hT?GUNka4XLA\";i:2625;s:15:\"9M>hT?GUNk#5XLA\";i:2626;s:15:\"9M>hT?GUNkJ7XLA\";i:2627;s:15:\"9M>hT?GUNku8XLA\";i:2628;s:15:\"9M>hT?GUNk^9XLA\";i:2629;s:15:\"9M>hT?GUNkd#XLA\";i:2630;s:15:\"9M>hT?GUNk&$XLA\";i:2631;s:15:\"9M>hT?GUNkM&XLA\";i:2632;s:15:\"9M>hT?GUNkx(XLA\";i:2633;s:15:\"9M>hT?GUNk{)XLA\";i:2634;s:15:\"9M>hT?GUNkg+XLA\";i:2635;s:15:\"9M>hT?GUNk*,XLA\";i:2636;s:15:\"9M>hT?GUNkP/XLA\";i:2637;s:15:\"9M>hT?GUNk0:XLA\";i:2638;s:15:\"9M>hT?GUNk~;XLA\";i:2639;s:15:\"9M>hT?GUNkj=XLA\";i:2640;s:15:\"9M>hT?GUNk.>XLA\";i:2641;s:15:\"9M>hT?GUNkS@XLA\";i:2642;s:15:\"9M>hT?GUNk3[XLA\";i:2643;s:15:\"9M>hT?GUNkB^XLA\";i:2644;s:15:\"9M>hT?GUNkm_XLA\";i:2645;s:15:\"9M>hT?GUNk;`XLA\";i:2646;s:15:\"9M>hT?GUNkV|XLA\";i:2647;s:15:\"9M>hT?GUNk6}XLA\";i:2648;s:15:\"9M>hT?GUNkE\"5FA\";i:2649;s:15:\"9M>hT?GUNknBYLA\";i:2650;s:15:\"9M>hT?GUNk<CYLA\";i:2651;s:15:\"9M>hT?GUNkWEYLA\";i:2652;s:15:\"9M>hT?GUNk7FYLA\";i:2653;s:15:\"9M>hT?GUNkFHYLA\";i:2654;s:15:\"9M>hT?GUNkqIYLA\";i:2655;s:15:\"9M>hT?GUNk?JYLA\";i:2656;s:15:\"9M>hT?GUNkZLYLA\";i:2657;s:15:\"9M>hT?GUNk!MYLA\";i:2658;s:15:\"9M>hT?GUNkIOYLA\";i:2659;s:15:\"9M>hT?GUNktPYLA\";i:2660;s:15:\"9M>hT?GUNk]QYLA\";i:2661;s:15:\"9M>hT?GUNkcSYLA\";i:2662;s:15:\"9M>hT?GUNk%TYLA\";i:2663;s:15:\"9M>hT?GUNkLVYLA\";i:2664;s:15:\"9M>hT?GUNkwWYLA\";i:2665;s:15:\"9M>hT?GUNk`XYLA\";i:2666;s:15:\"9M>hT?GUNkfZYLA\";i:2667;s:15:\"9M>hT?GUNk)aYLA\";i:2668;s:15:\"9M>hT?GUNkOcYLA\";i:2669;s:15:\"9M>hT?GUNkzdYLA\";i:2670;s:15:\"9M>hT?GUNk}eYLA\";i:2671;s:15:\"9M>hT?GUNkigYLA\";i:2672;s:15:\"9M>hT?GUNk,hYLA\";i:2673;s:15:\"9M>hT?GUNkRjYLA\";i:2674;s:15:\"9M>hT?GUNk2kYLA\";i:2675;s:15:\"9M>hT?GUNkAmYLA\";i:2676;s:15:\"9M>hT?GUNklnYLA\";i:2677;s:15:\"9M>hT?GUNk:oYLA\";i:2678;s:15:\"9M>hT?GUNkUqYLA\";i:2679;s:15:\"9M>hT?GUNk5rYLA\";i:2680;s:15:\"9M>hT?GUNkDtYLA\";i:2681;s:15:\"9M>hT?GUNkouYLA\";i:2682;s:15:\"9M>hT?GUNk=vYLA\";i:2683;s:15:\"9M>hT?GUNkXxYLA\";i:2684;s:15:\"9M>hT?GUNk8yYLA\";i:2685;s:15:\"9M>hT?GUNkG0YLA\";i:2686;s:15:\"9M>hT?GUNkr1YLA\";i:2687;s:15:\"9M>hT?GUNk@2YLA\";i:2688;s:15:\"9M>hT?GUNka4YLA\";i:2689;s:15:\"9M>hT?GUNk#5YLA\";i:2690;s:15:\"9M>hT?GUNkJ7YLA\";i:2691;s:15:\"9M>hT?GUNku8YLA\";i:2692;s:15:\"9M>hT?GUNk^9YLA\";i:2693;s:15:\"9M>hT?GUNkd#YLA\";i:2694;s:15:\"9M>hT?GUNk&$YLA\";i:2695;s:15:\"9M>hT?GUNkM&YLA\";i:2696;s:15:\"9M>hT?GUNkx(YLA\";i:2697;s:15:\"9M>hT?GUNk{)YLA\";i:2698;s:15:\"9M>hT?GUNkg+YLA\";i:2699;s:15:\"9M>hT?GUNk*,YLA\";i:2700;s:15:\"9M>hT?GUNkP/YLA\";i:2701;s:15:\"9M>hT?GUNk0:YLA\";i:2702;s:15:\"9M>hT?GUNk~;YLA\";i:2703;s:15:\"9M>hT?GUNkj=YLA\";i:2704;s:15:\"9M>hT?GUNk.>YLA\";i:2705;s:15:\"9M>hT?GUNkS@YLA\";i:2706;s:15:\"9M>hT?GUNk3[YLA\";i:2707;s:15:\"9M>hT?GUNkB^YLA\";i:2708;s:15:\"9M>hT?GUNkm_YLA\";i:2709;s:15:\"9M>hT?GUNk;`YLA\";i:2710;s:15:\"9M>hT?GUNkV|YLA\";i:2711;s:15:\"9M>hT?GUNk6}YLA\";i:2712;s:15:\"9M>hT?GUNkCA6FA\";i:2713;s:15:\"9M>hT?GUNknBZLA\";i:2714;s:15:\"9M>hT?GUNk<CZLA\";i:2715;s:15:\"9M>hT?GUNkWEZLA\";i:2716;s:15:\"9M>hT?GUNk7FZLA\";i:2717;s:15:\"9M>hT?GUNkFHZLA\";i:2718;s:15:\"9M>hT?GUNkqIZLA\";i:2719;s:15:\"9M>hT?GUNk?JZLA\";i:2720;s:15:\"9M>hT?GUNkZLZLA\";i:2721;s:15:\"9M>hT?GUNk!MZLA\";i:2722;s:15:\"9M>hT?GUNkIOZLA\";i:2723;s:15:\"9M>hT?GUNktPZLA\";i:2724;s:15:\"9M>hT?GUNk]QZLA\";i:2725;s:15:\"9M>hT?GUNkcSZLA\";i:2726;s:15:\"9M>hT?GUNk%TZLA\";i:2727;s:15:\"9M>hT?GUNkLVZLA\";i:2728;s:15:\"9M>hT?GUNkwWZLA\";i:2729;s:15:\"9M>hT?GUNk`XZLA\";i:2730;s:15:\"9M>hT?GUNkfZZLA\";i:2731;s:15:\"9M>hT?GUNk)aZLA\";i:2732;s:15:\"9M>hT?GUNkOcZLA\";i:2733;s:15:\"9M>hT?GUNkzdZLA\";i:2734;s:15:\"9M>hT?GUNk}eZLA\";i:2735;s:15:\"9M>hT?GUNkigZLA\";i:2736;s:15:\"9M>hT?GUNk,hZLA\";i:2737;s:15:\"9M>hT?GUNkRjZLA\";i:2738;s:15:\"9M>hT?GUNk2kZLA\";i:2739;s:15:\"9M>hT?GUNkAmZLA\";i:2740;s:15:\"9M>hT?GUNklnZLA\";i:2741;s:15:\"9M>hT?GUNk:oZLA\";i:2742;s:15:\"9M>hT?GUNkUqZLA\";i:2743;s:15:\"9M>hT?GUNk5rZLA\";i:2744;s:15:\"9M>hT?GUNkDtZLA\";i:2745;s:15:\"9M>hT?GUNkouZLA\";i:2746;s:15:\"9M>hT?GUNk=vZLA\";i:2747;s:15:\"9M>hT?GUNkXxZLA\";i:2748;s:15:\"9M>hT?GUNk8yZLA\";i:2749;s:15:\"9M>hT?GUNkG0ZLA\";i:2750;s:15:\"9M>hT?GUNkr1ZLA\";i:2751;s:15:\"9M>hT?GUNk@2ZLA\";i:2752;s:15:\"9M>hT?GUNka4ZLA\";i:2753;s:15:\"9M>hT?GUNk#5ZLA\";i:2754;s:15:\"9M>hT?GUNkJ7ZLA\";i:2755;s:15:\"9M>hT?GUNku8ZLA\";i:2756;s:15:\"9M>hT?GUNk^9ZLA\";i:2757;s:15:\"9M>hT?GUNkd#ZLA\";i:2758;s:15:\"9M>hT?GUNk&$ZLA\";i:2759;s:15:\"9M>hT?GUNkM&ZLA\";i:2760;s:15:\"9M>hT?GUNkx(ZLA\";i:2761;s:15:\"9M>hT?GUNk{)ZLA\";i:2762;s:15:\"9M>hT?GUNkg+ZLA\";i:2763;s:15:\"9M>hT?GUNk*,ZLA\";i:2764;s:15:\"9M>hT?GUNkP/ZLA\";i:2765;s:15:\"9M>hT?GUNk0:ZLA\";i:2766;s:15:\"9M>hT?GUNk~;ZLA\";i:2767;s:15:\"9M>hT?GUNkj=ZLA\";i:2768;s:15:\"9M>hT?GUNk.>ZLA\";i:2769;s:15:\"9M>hT?GUNkS@ZLA\";i:2770;s:15:\"9M>hT?GUNk3[ZLA\";i:2771;s:15:\"9M>hT?GUNkB^ZLA\";i:2772;s:15:\"9M>hT?GUNkm_ZLA\";i:2773;s:15:\"9M>hT?GUNk;`ZLA\";i:2774;s:15:\"9M>hT?GUNkV|ZLA\";i:2775;s:15:\"9M>hT?GUNk6}ZLA\";i:2776;s:15:\"9M>hT?GUNkE\"6FA\";i:2777;s:15:\"9M>hT?GUNknBaLA\";i:2778;s:15:\"9M>hT?GUNk<CaLA\";i:2779;s:15:\"9M>hT?GUNkWEaLA\";i:2780;s:15:\"9M>hT?GUNk7FaLA\";i:2781;s:15:\"9M>hT?GUNkFHaLA\";i:2782;s:15:\"9M>hT?GUNkqIaLA\";i:2783;s:15:\"9M>hT?GUNk?JaLA\";i:2784;s:15:\"9M>hT?GUNkZLaLA\";i:2785;s:15:\"9M>hT?GUNk!MaLA\";i:2786;s:15:\"9M>hT?GUNkIOaLA\";i:2787;s:15:\"9M>hT?GUNktPaLA\";i:2788;s:15:\"9M>hT?GUNk]QaLA\";i:2789;s:15:\"9M>hT?GUNkcSaLA\";i:2790;s:15:\"9M>hT?GUNk%TaLA\";i:2791;s:15:\"9M>hT?GUNkLVaLA\";i:2792;s:15:\"9M>hT?GUNkwWaLA\";i:2793;s:15:\"9M>hT?GUNk`XaLA\";i:2794;s:15:\"9M>hT?GUNkfZaLA\";i:2795;s:15:\"9M>hT?GUNk)aaLA\";i:2796;s:15:\"9M>hT?GUNkOcaLA\";i:2797;s:15:\"9M>hT?GUNkzdaLA\";i:2798;s:15:\"9M>hT?GUNk}eaLA\";i:2799;s:15:\"9M>hT?GUNkigaLA\";i:2800;s:15:\"9M>hT?GUNk,haLA\";i:2801;s:15:\"9M>hT?GUNkRjaLA\";i:2802;s:15:\"9M>hT?GUNk2kaLA\";i:2803;s:15:\"9M>hT?GUNkAmaLA\";i:2804;s:15:\"9M>hT?GUNklnaLA\";i:2805;s:15:\"9M>hT?GUNk:oaLA\";i:2806;s:15:\"9M>hT?GUNkUqaLA\";i:2807;s:15:\"9M>hT?GUNk5raLA\";i:2808;s:15:\"9M>hT?GUNkDtaLA\";i:2809;s:15:\"9M>hT?GUNkouaLA\";i:2810;s:15:\"9M>hT?GUNk=vaLA\";i:2811;s:15:\"9M>hT?GUNkXxaLA\";i:2812;s:15:\"9M>hT?GUNk8yaLA\";i:2813;s:15:\"9M>hT?GUNkG0aLA\";i:2814;s:15:\"9M>hT?GUNkr1aLA\";i:2815;s:15:\"9M>hT?GUNk@2aLA\";i:2816;s:15:\"9M>hT?GUNka4aLA\";i:2817;s:15:\"9M>hT?GUNk#5aLA\";i:2818;s:15:\"9M>hT?GUNkJ7aLA\";i:2819;s:15:\"9M>hT?GUNku8aLA\";i:2820;s:15:\"9M>hT?GUNk^9aLA\";i:2821;s:15:\"9M>hT?GUNkd#aLA\";i:2822;s:15:\"9M>hT?GUNk&$aLA\";i:2823;s:15:\"9M>hT?GUNkM&aLA\";i:2824;s:15:\"9M>hT?GUNkx(aLA\";i:2825;s:15:\"9M>hT?GUNk{)aLA\";i:2826;s:15:\"9M>hT?GUNkg+aLA\";i:2827;s:15:\"9M>hT?GUNk*,aLA\";i:2828;s:15:\"9M>hT?GUNkP/aLA\";i:2829;s:15:\"9M>hT?GUNk0:aLA\";i:2830;s:15:\"9M>hT?GUNk~;aLA\";i:2831;s:15:\"9M>hT?GUNkj=aLA\";i:2832;s:15:\"9M>hT?GUNk.>aLA\";i:2833;s:15:\"9M>hT?GUNkS@aLA\";i:2834;s:15:\"9M>hT?GUNk3[aLA\";i:2835;s:15:\"9M>hT?GUNkB^aLA\";i:2836;s:15:\"9M>hT?GUNkm_aLA\";i:2837;s:15:\"9M>hT?GUNk;`aLA\";i:2838;s:15:\"9M>hT?GUNkV|aLA\";i:2839;s:15:\"9M>hT?GUNk6}aLA\";i:2840;s:15:\"9M>hT?GUO[CA5FA\";i:2841;s:15:\"9M>hT?GUO[nBXLA\";i:2842;s:15:\"9M>hT?GUO[<CXLA\";i:2843;s:15:\"9M>hT?GUO[WEXLA\";i:2844;s:15:\"9M>hT?GUO[7FXLA\";i:2845;s:15:\"9M>hT?GUO[FHXLA\";i:2846;s:15:\"9M>hT?GUO[qIXLA\";i:2847;s:15:\"9M>hT?GUO[?JXLA\";i:2848;s:15:\"9M>hT?GUO[ZLXLA\";i:2849;s:15:\"9M>hT?GUO[!MXLA\";i:2850;s:15:\"9M>hT?GUO[IOXLA\";i:2851;s:15:\"9M>hT?GUO[tPXLA\";i:2852;s:15:\"9M>hT?GUO[]QXLA\";i:2853;s:15:\"9M>hT?GUO[cSXLA\";i:2854;s:15:\"9M>hT?GUO[%TXLA\";i:2855;s:15:\"9M>hT?GUO[LVXLA\";i:2856;s:15:\"9M>hT?GUO[wWXLA\";i:2857;s:15:\"9M>hT?GUO[`XXLA\";i:2858;s:24:\"zd=hT?GUfOlB1N.4FxrjDABA\";i:2859;s:14:\"yd=hT?GU}jaBEA\";i:2860;s:14:\"t8>hT?GU}jaBEA\";i:2861;s:100:\"|2=hT?GU!BlBMM.4FxrjCAI7=hT?GU!BlBUM.4FxrjCA%$=hT?GU!BlB,L.4FxrjCAw(=hT?GU!BlB(L.4FxrjCATq>hT?GUZA$A\";i:2862;s:73:\"xP=hT?GU(ClBbL.4FxrjAA1k=hT?GU>BlBzL.4FxrjCAYL=hT?GUO[p1aL.IVElg*N7gPDlBA\";i:2863;s:12:\"R@=hT?GU/A$A\";i:2864;s:13:\"VE=hT?GU~AlBA\";i:2865;s:35:\"XE=hT?GU~AlBrL.4Fxs@CAw(>hT?GUeBlBA\";i:2866;s:24:\"Am=hT?GU!BlBzL.4Fx~5CABA\";i:2867;s:12:\"R@=hT?GU/A$A\";i:2868;s:26:\"tP=hT?GUDClBaO.4Fxrj}BlBQA\";i:2869;s:12:\"L&>hT?GUZA$A\";i:2870;s:65:\"lg>hT?GU~@,A8y#(k)No8C:CdhzXJI|+OI<AS\"EByD1+ITBiE\"k_`Q3nE30oiN5FA\";i:2871;s:94:\"zP=hT?GUuBlB;L.4FxrjLAvW=hT?GU>BlB?L.4Fx~5CA6F=hT?GUpA$A[CSOYM@1Bty:_Q3nE30o7f5F*xLvSQ[zGF^P$A\";i:2872;s:92:\"zP=hT?GUuBlBnL.4FxrjYBLFRtrBJHNz`auW_EqI:$vbmAS\"*\",ub@nH5FmuLvSQ[zKAyWit,ub@c}5FRtLvSQ[zBAEA\";i:2873;s:54:\"8}@hT?GUO[OcXL(,UESOYMj<BBKAx(;(LvSQ[zaAFt\"tVElg*N1AIA\";i:2874;s:13:\"9M=hT?GU!BlBA\";i:2875;s:13:\"9M=hT?GUeBlBA\";i:2876;s:31:\"RjIizXJI|+OI_AQAiDrI:$vbb%jH:CA\";i:2877;s:15:\"L&>hT?GUO[}eXLA\";i:2878;s:59:\"ZE=hT?GUZA$A]CSOYMu7Bt@QMR.4Fx}Mqr6F[tLvSQ[zLAFtht,ub@dF5FA\";i:2879;s:27:\"tP=hT?GUDClBs<xt,ub@y2unCtA\";i:2880;s:70:\"&M>hT?GUO[,hXLi\"LvSQ[zFAc4kt,ub@!S5FxtLvSQ[zGAEA%(k)NohD:C(XzXJI|+EACA\";i:2881;s:37:\"uP=hT?GUDClBEM.4Fx~5BAl_=hT?GUO[1[XLA\";i:2882;s:68:\"mg?hT?GU~@EBEA)(k)NoyAlB(P.4FxrjAA<v?hT?GUZA$A%DSOYM?IBt&a`Q3nE3MAgA\";i:2883;s:13:\"VE=hT?GU~AlBA\";i:2884;s:24:\")a=hT?GU!BlBbL.4FxrjBABA\";i:2885;s:13:\"(a=hT?GU!BlBA\";i:2886;s:12:\"VE=hT?GUZA$A\";i:2887;s:103:\"0P=hT?GUDClB@M.4Fx}MRA,>=hT?GU/A$AcQ[hT?GU~@DB:>qt,ub@JB5FH7LvSQ[zBAbLrt,ub@JB5Fn7LvSQ[zBA/hrt,ub@JB5FA\";i:2888;s:71:\"aE=hT?GU~AlBIM.4FxrjCAZ4=hT?GUYDlBQM.4FxrjCA]9=hT?GUYDlB(|xt,ub@y2*yCtA\";i:2889;s:46:\"qu?hT?GUYDlB:O.4Fx~5EA7y?hT?GUYDlB]O.4Fx~5EABA\";i:2890;s:45:\"hg?hT?OUO[2kXL#zdQiClBi<BBOA{QO[:oBt#zdQ6CvDA\";i:2891;s:15:\"/o@hT?GUO[5rXLA\";i:2892;s:12:\"R@=hT?GU5A$A\";i:2893;s:13:\"VE=hT?GU~AlBA\";i:2894;s:26:\")a=hT?GU!BlB9N.4FxrjHE$AIA\";i:2895;s:35:\"uP=hT?GUDClB?L.4Fx~5CANc=hT?GUHWlBA\";i:2896;s:136:\"2P=hT?GU(ClB?L.4FxrjYB%BQA)\",ub@y2/>Ft=J_Q3nE3AE$A|CSOYMj<Dt{e_Q3nE30oUX5FgwLvSQ[zdQ]C$A6DSOYM*+%hlBnL.4Fxs@BA};?hT?GUOBlB9N.4FxrjHE)AIA\";i:2897;s:15:\"L&>hT?GUO[XxXLA\";i:2898;s:12:\"VE=hT?GUZA$A\";i:2899;s:117:\";a=hT?GU!BlB?L.4Fx~5CA6F?hT?GUO[p1XL>WVElg*NLKKtMc`Q3nE30oeZ5F|7LvSQ[zdQPD$A*DSOYMj<BBSAln)(k)Noa.cLvW!mqI:$vbb%XL:CA\";i:2900;s:24:\"tP=hT?GUDClBnL.4Fxs@BABA\";i:2901;s:70:\"xP=hT?GUDClBIM.4FxrjCAZ4=hT?GUYDlBQM.4FxrjCA]9=hT?GUYDlB!O.4FxrjYBwAIA\";i:2902;s:13:\"sP=hT?GUDClBA\";i:2903;s:24:\"tP=hT?GUDClBEM.4Fx~5BABA\";i:2904;s:37:\"uP=hT?GUDClBXP.4Fx~5BA,>?hT?GUO[y:XLA\";i:2905;s:13:\"sP=hT?GU(ClBA\";i:2906;s:13:\"F0=hT?GUOBlBA\";i:2907;s:34:\"uP=hT?GUDClBbL.4FxrjBA[Q>hT?GUZA$A\";i:2908;s:24:\"G0=hT?GUOBlB|L.4Fx~5CABA\";i:2909;s:24:\"tP=hT?GUDClBEM.4Fx~5BABA\";i:2910;s:57:\"OV=hT?GU!BlBIM.4FxrjCAZ4=hT?GUYDlBQM.4FxrjCA]9=hT?GUYDlBA\";i:2911;s:36:\"uP=hT?GU(ClB;L.4FxrjCAI7=hT?GU}jDBEA\";i:2912;s:14:\"?2=hT?GU}jDBEA\";i:2913;s:24:\"tP=hT?GU(ClB;L.4FxrjCABA\";i:2914;s:25:\"Xx=hT?GU!BlBUM.4Fx}M*q6FA\";i:2915;s:25:\"LV=hT?GU!BlBMM.4Fx}M*q6FA\";i:2916;s:13:\"sP=hT?GUDClBA\";i:2917;s:12:\"bS>hT?GUZA$A\";i:2918;s:59:\"wP=hT?GUDClBbL.4FxrjBA7y=hT?GUOBlBsM.4Fx}MBAkn?hT?GUO[G0XLA\";i:2919;s:26:\"d#=hT?GU}jdBFtjt,ub@=1aFQA\";i:2920;s:13:\"c#=hT?GU!BlBA\";i:2921;s:13:\"!5=hT?GU!BlBA\";i:2922;s:26:\"@2=hT?GU}jdBc4jt,ub@=1aFQA\";i:2923;s:13:\"?2=hT?GU!BlBA\";i:2924;s:13:\"t8=hT?GU!BlBA\";i:2925;s:15:\"c#=hT?GUO[r1XLA\";i:2926;s:35:\"uP=hT?GU(ClBzL.4Fxs@HA]9=hT?GU#ulBA\";i:2927;s:81:\"(M>hT?GUwLlBrL.4Fxs@DAkn=hT?GU>BlBiO.4FxrjHE>A3((\",ub@&G5FbvLvSQ[zJAz(jt,ub@im5FA\";i:2928;s:121:\"+M>hT?GUwLlBrL.4Fxs@DAvW=hT?GU!BlB?L.4FxrjCA$T=hT?GU!BlB;L.4FxrjLAq1=hT?GUNk;CXL0kVElg*N7gDHlBkM.4FxrjHE]AK\"qt,ub@y2*yDtA\";i:2929;s:15:\"!5=hT?GUO[r1XLA\";i:2930;s:24:\"tP=hT?GU(ClBAM.4Fxs@HABA\";i:2931;s:81:\"(M>hT?GUwLlBrL.4Fxs@DAkn=hT?GU>BlBiO.4FxrjHE>A2W+\",ub@&G5FbvLvSQ[zJAFtjt,ub@im5FA\";i:2932;s:121:\"+M>hT?GUwLlBrL.4Fxs@DAvW=hT?GU!BlB?L.4FxrjCA<v=hT?GU!BlB;L.4FxrjLAq1=hT?GUNk;CXL}YVElg*N7gDHlBkM.4FxrjHE]AK\"qt,ub@y2*yDtA\";i:2933;s:15:\"?2=hT?GUO[r1XLA\";i:2934;s:35:\"uP=hT?GU(ClB;L.4Fxs@HAq1=hT?GU#ulBA\";i:2935;s:70:\"&M>hT?GUwLlBrL.4Fxs@DAvW=hT?GU>BlB2O.4FxrjHE>A2W*\",ub@&G5FgwLvSQ[z2AEA\";i:2936;s:121:\"+M>hT?GUwLlBrL.4Fxs@DAvW=hT?GU!BlB?L.4FxrjCA$T=hT?GUBIlB;L.4FxrjCA]9=hT?GUNk;CXL&aVElg*N7gDHlBiO.4FxrjHE]AIAut,ub@y2*yDtA\";i:2937;s:15:\"t8=hT?GUO[r1XLA\";i:2938;s:24:\"tP=hT?GU(ClBvL.4Fxs@HABA\";i:2939;s:70:\"&M>hT?GUwLlBrL.4Fxs@DAvW=hT?GU>BlB2O.4FxrjHE>AJt(\",ub@&G5F$wLvSQ[z2AEA\";i:2940;s:121:\"+M>hT?GUwLlBrL.4Fxs@DAvW=hT?GU!BlB?L.4FxrjCA$T=hT?GUBIlBvL.4FxrjCA]9=hT?GUNk;CXLNJVElg*N7gDHlBiO.4FxrjHE]AIAut,ub@y2*yDtA\";i:2941;s:94:\"zP=hT?GU(ClBIM.4FxrjCAZ4=hT?GU!BlBQM.4FxrjCA]9=hT?GU!BlB!O.4FxrjHE:A2W@\",ub@y2j4Dt~l`Q3nE30AgA\";i:2942;s:31:\"u8>hT?GUjClB#L.4?zrjfAq10o5FYLA\";i:2943;s:31:\"u8>hT?GUHWlB#L.4?zrjDAq10oXeXLA\";i:2944;s:13:\"VE>hT?GUhIlBA\";i:2945;s:46:\"O&=hT?GUhIlB,L.4Fxs@LAw(=hT?GUhIlB(L.4Fxs@LABA\";i:2946;s:15:\"hg?hT?GUO[^9XLA\";i:2947;s:15:\"hg?hT?GUO[d#XLA\";i:2948;s:15:\"hg?hT?GUO[&aXLA\";i:2949;s:23:\"FH=hT?GUpA$ACDSOYM6|DtA\";i:2950;s:57:\"^2=hT?GU#ulBMM.4Fxrj&AI7=hT?GU#ulBUM.4Fxrj&ANc=hT?GUHWlBA\";i:2951;s:82:\"yP=hT?GU(ClB;L.4Fxs@MA<v=hT?GUhIlBoM.4FxrjFAD\"_Q3nE38Ai\":BJHNzij>Q$ANDSOYMj<BBXACA\";i:2952;s:15:\"9M>hT?GUO[M&XLA\";i:2953;s:26:\")a=hT?GU!BlB9N.4FxrjHEFBQA\";i:2954;s:13:\"(a=hT?GUeBlBA\";i:2955;s:45:\"vP=hT?GUDClB3L.4Fx~5CA6F=hT?GUpA$AGDSOYM6|DtA\";i:2956;s:134:\"DY=hT?GUhIlB?L.4Fxs@LA[Q>hT?GUO[{)XL3LVElg*NABRtuBJHNzij2Q$ADDSOYM*+RhlBQM.4Fx}M*q6F@wLvSQ[zB[zW$AVElg*N3AJt`\",ub@y2XcDtrP`Q3nE3t`vABA\";i:2957;s:13:\"yd=hT?GUHWlBA\";i:2958;s:13:\"sP=hT?GU(ClBA\";i:2959;s:26:\")a=hT?GU!BlB9N.4FxrjHEFBQA\";i:2960;s:13:\"(a=hT?GUeBlBA\";i:2961;s:46:\"|X=hT?GU>BlBzL.4FxrjCA1k=hT?GUBIlBIM.4Fx}MXABA\";i:2962;s:46:\"<o=hT?GU>BlBzL.4FxrjLA1k=hT?GU!BlBUM.4Fx~5YABA\";i:2963;s:58:\"wP=hT?GU(ClBbL.4FxrjBAvW=hT?GUNElB?L.4FxrjFA|e?hT?GU~@EBEA\";i:2964;s:15:\":`=hT?GUNk$TXLA\";i:2965;s:13:\"KV=hT?GUNElBA\";i:2966;s:13:\"Wx=hT?GUNElBA\";i:2967;s:13:\"\"l=hT?GUNElBA\";i:2968;s:13:\"bS=hT?GUNElBA\";i:2969;s:57:\"%M>hT?GUwLlBrL.4Fxs@DAvW=hT?GUBIlB?L.4FxrjLANc=hT?GUjClBA\";i:2970;s:38:\"MV=hT?GU~@CBc4it,ub@&G5FayLvSQ[zdQkE$A\";i:2971;s:38:\"MV=hT?GU~@CBc4it,ub@Eg5FayLvSQ[zdQsE$A\";i:2972;s:38:\"Yx=hT?GU~@CBc4it,ub@&G5FayLvSQ[zdQ0E$A\";i:2973;s:38:\"Yx=hT?GU~@CBc4it,ub@Eg5FayLvSQ[zdQ8E$A\";i:2974;s:24:\"`X=hT?GU!BlB?L.4FxrjCABA\";i:2975;s:12:\"9M>hT?GUZA$A\";i:2976;s:42:\"{X@hT?GUO[~;XLNJVElg*NNK4olB2O.4FxrjYBHFQA\";i:2977;s:42:\"MV?hT?GUO[~;XLNJVElg*NNK4olB2O.4FxrjYBHFQA\";i:2978;s:42:\"Sj?hT?GUO[~;XL}YVElg*NNK4olB;P.4FxrjYBHFQA\";i:2979;s:42:\"1:=hT?GUO[~;XL}YVElg*NNK4olB;P.4FxrjYBHFQA\";i:2980;s:13:\"sP=hT?GU(ClBA\";i:2981;s:26:\")a=hT?GU!BlB9N.4FxrjHEFBQA\";i:2982;s:13:\"(a=hT?GUeBlBA\";i:2983;s:48:\"|X=hT?GU>BlB;L.4FxrjLA$T=hT?GU!BlBIM.4Fxrj}B%BQA\";i:2984;s:48:\"<o=hT?GU>BlB;L.4FxrjCA$T=hT?GUBIlBUM.4FxrjYB0AIA\";i:2985;s:58:\"wP=hT?GU(ClBbL.4FxrjBAvW=hT?GUaNlB?L.4Fx}MKA|e?hT?GU~@EBEA\";i:2986;s:15:\":`=hT?GUNk$TXLA\";i:2987;s:13:\"KV=hT?GU!BlBA\";i:2988;s:13:\"Wx=hT?GU!BlBA\";i:2989;s:13:\"\"l=hT?GU!BlBA\";i:2990;s:13:\"bS=hT?GU!BlBA\";i:2991;s:57:\"%M>hT?GUwLlBrL.4Fxs@DAvW=hT?GUBIlB?L.4FxrjLANc=hT?GUjClBA\";i:2992;s:38:\"MV=hT?GU~@CBc4it,ub@&G5FayLvSQ[zdQkE$A\";i:2993;s:38:\"MV=hT?GU~@CBc4it,ub@Eg5FayLvSQ[zdQsE$A\";i:2994;s:38:\"Yx=hT?GU~@CBc4it,ub@&G5FayLvSQ[zdQ0E$A\";i:2995;s:38:\"Yx=hT?GU~@CBc4it,ub@Eg5FayLvSQ[zdQ8E$A\";i:2996;s:24:\"`X=hT?GU!BlB?L.4FxrjCABA\";i:2997;s:12:\"9M>hT?GUZA$A\";i:2998;s:42:\"{X@hT?GUO[j=XLNJVElg*N+P[NlB2O.4Fxrj}B(BQA\";i:2999;s:42:\"MV?hT?GUO[j=XLNJVElg*N+P[NlB2O.4Fxrj}B(BQA\";i:3000;s:42:\"Sj?hT?GUO[j=XL}YVElg*N+P[NlB;P.4Fxrj}B(BQA\";i:3001;s:42:\"1:=hT?GUO[j=XL}YVElg*N+P[NlB;P.4Fxrj}B(BQA\";i:3002;s:12:\"c#>hT?GUZA$A\";i:3003;s:24:\"j=?hT?GUOBlB_M.4FxrjAABA\";i:3004;s:236:\"oC*B;\",ub@y2MtEtDH_Q3nE3hB$A]CSOYMj<dtHB/hit,ub@Yk5FrvLvSQ[zdAz(lt,ub@y2F\"yWlBqI:$vbKARtyBJHNz#8uWTXqI:$vb{ARtrBJHNz`auWZlqI:$vb2AS\"(\",ub@&G5FWuLvSQ[zJAbLjt,ub@&G5F+uLvSQ[zdQBF$ACDSOYMtOCtMc_Q3nE35B$AEDSOYMtOCt{e_Q3nE35B$APDSOYMj<BBdACA\";i:3005;s:124:\"xu=hT?GUatlB6O.4Fxrj$A[Q>hT?GUatlB$M.4Fxrj&A%$=hT?GU#ulB,L.4Fxrj&Aw(=hT?GU#ulB(L.4Fxrj&ATq=hT?GUatlB}Iyt,ub@JB7F!2LvSQ[zBAEA\";i:3006;s:26:\"tP=hT?GUO[k_XLfTVElg*N8FQA\";i:3007;s:23:\"ou=hT?GUZA$A8DSOYM?IBtA\";i:3008;s:70:\"n==hT?GUdElB8M.4FxrjHEbBRtuBJHNz`auWGOqI:$vbmARtvBJHNz`auWrPqI:$vbmAQA\";i:3009;s:70:\"n==hT?GU4DlB8M.4FxrjHEbBRtuBJHNz`auWGOqI:$vbmARtvBJHNz`auWrPqI:$vbmAQA\";i:3010;s:73:\"n==hT?GUO[y:ZLXLVElg*N7giKlBIM.4FxrjCAZ4=hT?GU!BlBQM.4FxrjCA]9=hT?GU!BlBA\";i:3011;s:73:\"n==hT?GUO[dZXLXLVElg*N7giKlBIM.4FxrjCAZ4=hT?GU!BlBQM.4FxrjCA]9=hT?GU!BlBA\";i:3012;s:70:\"n==hT?GU3GlB8M.4FxrjHEbBRtuBJHNz`auWGOqI:$vbmARtvBJHNz`auWrPqI:$vbmAQA\";i:3013;s:70:\"n==hT?GU2JlB8M.4FxrjHEbBRtuBJHNz`auWGOqI:$vbmARtvBJHNz`auWrPqI:$vbmAQA\";i:3014;s:73:\"n==hT?GUO[v(ZLXLVElg*N7giKlBIM.4FxrjCAZ4=hT?GU!BlBQM.4FxrjCA]9=hT?GU!BlBA\";i:3015;s:12:\"bS>hT?GUZA$A\";i:3016;s:13:\"mB>hT?GUeBlBA\";i:3017;s:23:\"S@=hT?GU/A$ADDSOYMLUEtA\";i:3018;s:13:\"!5=hT?GUaNlBA\";i:3019;s:13:\"!5=hT?GU!BlBA\";i:3020;s:15:\"mB>hT?GUO[m_XLA\";i:3021;s:27:\"zd=hT?GUO[UEaL6SVElg*N)POtA\";i:3022;s:25:\"zd=hT?GU~@$AOc&(k)No+E;CA\";i:3023;s:15:\"EH>hT?GUO[;`XLA\";i:3024;s:14:\"yd=hT?GU~@]ACA\";i:3025;s:25:\"M&=hT?GUhIlB7L.4Fx}M{n6FA\";i:3026;s:13:\"L&=hT?GUhIlBA\";i:3027;s:46:\"O&=hT?GUi1lB,L.4Fxrj&Aw(=hT?GU#ulB(L.4Fxrj&ABA\";i:3028;s:138:\"EY>hT?GUNkZ4XLzXVElg*NDA2W?\",ub@ff5F[tLvSQ[zGFZF$A|CSOYMtOCt=J_Q3nE35B$AADSOYMtOCt&a_Q3nE3<AgAvBJHNz`auW+OqI:$vbmAS\",\",ub@&G5F6yLvSQ[zsAEA\";i:3029;s:26:\"!M>hT?GUO[EHZLDHVElg*N&BQA\";i:3030;s:26:\"!M>hT?GUO[pIZL(HVElg*N&BQA\";i:3031;s:25:\"d#>hT?GUZA$AkDSOYM*+h[lBA\";i:3032;s:15:\"(a=hT?GUO[V|XLA\";i:3033;s:35:\";o=hT?GU.DlB8M.4FxrjFAI7=hT?GUhIlBA\";i:3034;s:61:\"=o=hT?GUO[b#aLIIVElg*NTAK\"it,ub@=1NEQA.\",ub@&G5F{uLvSQ[zB[zWA\";i:3035;s:78:\"sB?hT?GUZA$AkDSOYM*+Dtgg_Q3nE3<AgArBJHNz`auW@QqI:$vbmARtqBJHNz`auW\"SqI:$vb|BgA\";i:3036;s:23:\"S@=hT?GUZA$AVDSOYM?IBtA\";i:3037;s:12:\"VE=hT?GUZA$A\";i:3038;s:13:\"VE=hT?GUatlBA\";i:3039;s:13:\"i==hT?GU3GlBA\";i:3040;s:24:\":o=hT?GUYDlB3L.4Fx~5EABA\";i:3041;s:167:\"w==hT?GU}j*AOc&(k)No9P:CQYzXJI|+EAwW$(k)NohD:CgYzXJI|+EA,h$(k)NohD:CwYzXJI|+EAx(#(k)NohD:C4YzXJI|+EA^9#(k)NohD:CaazXJI{ZgAa4%(k)No$W:C=ZzXJI|+AACA?hT?GUZA$A^DSOYM*+DtA\";i:3042;s:24:\"j==hT?GU<HlB1N.4Fx}MLABA\";i:3043;s:12:\"4r=hT?GUZA$A\";}", "no");
INSERT INTO `wp_options` VALUES("1501", "theme_mods_levo-theme-child", "a:7:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1736796140;s:4:\"data\";a:8:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";}s:7:\"sidebar\";a:2:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";}s:13:\"pages_sidebar\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:14:\"search_sidebar\";a:0:{}s:10:\"footer_one\";a:0:{}s:10:\"footer_two\";a:0:{}s:12:\"footer_three\";a:0:{}s:11:\"footer_four\";a:0:{}}}s:18:\"custom_css_post_id\";i:-1;s:19:\"testimonials_enable\";i:0;s:14:\"theme_branding\";s:4:\"LEVO\";s:21:\"footer_copyright_text\";s:75:\"Copyright <a href=\"/\">[blog_name].</a> [current_year] - All Rights Reserved\";}", "off");
INSERT INTO `wp_options` VALUES("1508", "theme_mods_Levo", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1583494442;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";}s:7:\"sidebar\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:13:\"pages_sidebar\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:14:\"search_sidebar\";a:0:{}s:20:\"testimonials_sidebar\";a:0:{}s:10:\"footer_one\";a:0:{}s:10:\"footer_two\";a:0:{}s:12:\"footer_three\";a:0:{}s:11:\"footer_four\";a:0:{}}}}", "off");
INSERT INTO `wp_options` VALUES("6941", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:19:\"info@levohealth.com\";s:7:\"version\";s:5:\"6.7.4\";s:9:\"timestamp\";i:1764945200;}", "off");
INSERT INTO `wp_options` VALUES("13548", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("39804", "rs-templates-new", "", "no");
INSERT INTO `wp_options` VALUES("39805", "rs-templates", "a:2:{s:6:\"slider\";a:604:{i:0;a:22:{s:2:\"id\";s:1:\"1\";s:5:\"title\";s:16:\"Classic Carousel\";s:5:\"alias\";s:16:\"classic-carousel\";s:3:\"zip\";s:20:\"classic-carousel.zip\";s:3:\"uid\";s:32:\"146a01dd380c0cdee85c4456ee68cd84\";s:3:\"img\";s:27:\"classic-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/carousel-slider-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">Our classic, full-width carousel example. Drag, swipe or click to navigate!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:284:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:1;a:22:{s:2:\"id\";s:1:\"2\";s:5:\"title\";s:14:\"Classic Slider\";s:5:\"alias\";s:13:\"classicslider\";s:3:\"zip\";s:17:\"classicslider.zip\";s:3:\"uid\";s:32:\"a0d6a9248c9066b404ba0f1cdadc5cf2\";s:3:\"img\";s:24:\"classicslider/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-slideshow-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:136:\" <span class=\"ttm_content\">A classic slideshow example with timer, bullets and arrow navigation.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:2;a:22:{s:2:\"id\";s:1:\"3\";s:5:\"title\";s:12:\"Content Tabs\";s:5:\"alias\";s:11:\"contenttabs\";s:3:\"zip\";s:15:\"contenttabs.zip\";s:3:\"uid\";s:32:\"e02e91604b690123a3d07a65582c4fd0\";s:3:\"img\";s:22:\"contenttabs/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-content-tabs-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:170:\" <span class=\"ttm_content\">An auto-size slider with a cool split-text animation effect. Navigate with vertical bullets and thumbs.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:3;a:22:{s:2:\"id\";s:1:\"4\";s:5:\"title\";s:13:\"Facebook Feed\";s:5:\"alias\";s:13:\"facebook-feed\";s:3:\"zip\";s:17:\"facebook-feed.zip\";s:3:\"uid\";s:32:\"5506431d5b1babcb25dcf52c508d42e3\";s:3:\"img\";s:24:\"facebook-feed/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-facebook-feed/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:174:\"<span class=\"ttm_content\"> This slider is automatically populated by a Facebook stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Facebook Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:4;a:22:{s:2:\"id\";s:1:\"5\";s:5:\"title\";s:7:\"Fashion\";s:5:\"alias\";s:7:\"fashion\";s:3:\"zip\";s:11:\"fashion.zip\";s:3:\"uid\";s:32:\"4f4b914d6db35e19101ff003c4e7ea3a\";s:3:\"img\";s:18:\"fashion/slider.jpg\";s:7:\"preview\";s:65:\"http://revolution.themepunch.com/wordpress-one-page-slider-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"  <span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:5;a:22:{s:2:\"id\";s:1:\"6\";s:5:\"title\";s:14:\"Flickr Gallery\";s:5:\"alias\";s:14:\"flickr-gallery\";s:3:\"zip\";s:18:\"flickr-gallery.zip\";s:3:\"uid\";s:32:\"ad85cfac7acfa678e6a1b8febfee51ed\";s:3:\"img\";s:25:\"flickr-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-flickr-slider/\";s